# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class WalletClientConfiguration(Configuration):
    """Configuration for WalletClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if not base_url:
            base_url = 'https://api.trinsic.id/wallet/v1'

        super(WalletClientConfiguration, self).__init__(base_url)

        self.add_user_agent('trinsic.service_clients.wallet/{}'.format(VERSION))

        self.credentials = credentials


class WalletClient(SDKClient):
    """A powerful API to manage self-sovereign identity for users

    :ivar config: Configuration for client.
    :vartype config: WalletClientConfiguration

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        self.config = WalletClientConfiguration(credentials, base_url)
        super(WalletClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v1'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def accept_invitation(
            self, wallet_id, invitation, custom_headers=None, raw=False, **operation_config):
        """Accept connection invitation.

        Accept a connection invitation in the specified wallet.
        The invitation can be in a form of URL or invitation JSON encoded as
        base64 data.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param invitation:
        :type invitation: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ConnectionContract or ClientRawResponse if raw=true
        :rtype: ~wallet.models.ConnectionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.accept_invitation.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'invitation': invitation,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ConnectionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    accept_invitation.metadata = {'url': '/api/{walletId}/connections/invitation'}

    def get_connection(
            self, wallet_id, connection_id, custom_headers=None, raw=False, **operation_config):
        """Get connection.

        Get the specified connection in the specified wallet.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param connection_id: The connection identifier
        :type connection_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ConnectionContract or ClientRawResponse if raw=true
        :rtype: ~wallet.models.ConnectionContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_connection.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'connectionId': self._serialize.url("connection_id", connection_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ConnectionContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_connection.metadata = {'url': '/api/{walletId}/connections/{connectionId}'}

    def list_connections(
            self, wallet_id, custom_headers=None, raw=False, **operation_config):
        """List all connections.

        List all connections in the specified wallet in the "Connected" state.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~wallet.models.ConnectionContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_connections.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ConnectionContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_connections.metadata = {'url': '/api/{walletId}/connections'}

    def list_invitations(
            self, wallet_id, custom_headers=None, raw=False, **operation_config):
        """List connection invitations.

        List all connection invitations in the specified wallet.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~wallet.models.ConnectionContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_invitations.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ConnectionContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_invitations.metadata = {'url': '/api/{walletId}/connections/invitations'}

    def list_credentials_for_connection_id(
            self, wallet_id, connection_id, custom_headers=None, raw=False, **operation_config):
        """List all credentials for connection.

        List all credentials in the specified wallet associated with the
        specified connection.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param connection_id: The connection identifier
        :type connection_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~wallet.models.CredentialContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_credentials_for_connection_id.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'connectionId': self._serialize.url("connection_id", connection_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[CredentialContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_credentials_for_connection_id.metadata = {'url': '/api/{walletId}/credentials/connection/{connectionId}'}

    def list_credentials(
            self, wallet_id, custom_headers=None, raw=False, **operation_config):
        """List all credentials.

        List all credentials in the specified wallet.

        :param wallet_id:
        :type wallet_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~wallet.models.CredentialContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_credentials.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[CredentialContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_credentials.metadata = {'url': '/api/{walletId}/credentials'}

    def get_credential(
            self, wallet_id, credential_id, custom_headers=None, raw=False, **operation_config):
        """Get credential.

        Get the specified credential in the specified wallet.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param credential_id: The credential identifier
        :type credential_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CredentialContract or ClientRawResponse if raw=true
        :rtype: ~wallet.models.CredentialContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_credential.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'credentialId': self._serialize.url("credential_id", credential_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CredentialContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_credential.metadata = {'url': '/api/{walletId}/credentials/{credentialId}'}

    def accept_credential_offer(
            self, wallet_id, credential_id, custom_headers=None, raw=False, **operation_config):
        """Accept credential offer.

        Accept the specified credential offer in the specified wallet.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param credential_id: The credential identifier
        :type credential_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.accept_credential_offer.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'credentialId': self._serialize.url("credential_id", credential_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    accept_credential_offer.metadata = {'url': '/api/{walletId}/credentials/{credentialId}'}

    def accept_credential(
            self, wallet_id, credential_data, custom_headers=None, raw=False, **operation_config):
        """Accept credential offer from URL or data.

        Accept a credential offer using the provided URL or data.
        The credential field can be in the form of a URL or JSON encoded as
        base64 data.
        This endpoint is used to accept connectionless credential issuance.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param credential_data:
        :type credential_data: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CredentialContract or ClientRawResponse if raw=true
        :rtype: ~wallet.models.CredentialContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.accept_credential.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'credentialData': credential_data,
        }

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CredentialContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    accept_credential.metadata = {'url': '/api/{walletId}/credentials/fromData'}

    def list_verifications_for_connection(
            self, wallet_id, connection_id, custom_headers=None, raw=False, **operation_config):
        """List all verifications for connection.

        List all available verifications in the specified wallet for the
        specified connection.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param connection_id: The connection identifier
        :type connection_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~wallet.models.VerificationContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_verifications_for_connection.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'connectionId': self._serialize.url("connection_id", connection_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[VerificationContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_verifications_for_connection.metadata = {'url': '/api/{walletId}/verifications/connection/{connectionId}'}

    def list_verifications(
            self, wallet_id, custom_headers=None, raw=False, **operation_config):
        """List all verifications.

        List all available verifications in the specified wallet.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~wallet.models.VerificationContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_verifications.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[VerificationContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_verifications.metadata = {'url': '/api/{walletId}/verifications'}

    def get_verification(
            self, wallet_id, verification_id, custom_headers=None, raw=False, **operation_config):
        """Get verification.

        Get the specified verification in the specified wallet.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param verification_id: The verification identifier
        :type verification_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~wallet.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_verification.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'verificationId': self._serialize.url("verification_id", verification_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_verification.metadata = {'url': '/api/{walletId}/verifications/{verificationId}'}

    def submit_verification(
            self, wallet_id, verification_id, body, custom_headers=None, raw=False, **operation_config):
        """Submit verification using policy parameters.

        Submit the verification using the provided policy parameters.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param verification_id: The verification identifier
        :type verification_id: str
        :param body: The verification policy parameters
        :type body:
         list[~wallet.models.VerificationPolicyCredentialParameters]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.submit_verification.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'verificationId': self._serialize.url("verification_id", verification_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, '[VerificationPolicyCredentialParameters]')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    submit_verification.metadata = {'url': '/api/{walletId}/verifications/{verificationId}'}

    def propose_verification(
            self, wallet_id, connection_id, body, custom_headers=None, raw=False, **operation_config):
        """Create verification proposal.

        Create a verification proposal from the specified policy.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param connection_id: The connection identifier
        :type connection_id: str
        :param body: The proposal policy
        :type body: ~wallet.models.VerificationPolicyParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VerificationContract or ClientRawResponse if raw=true
        :rtype: ~wallet.models.VerificationContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.propose_verification.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'connectionId': self._serialize.url("connection_id", connection_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'VerificationPolicyParameters')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('VerificationContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    propose_verification.metadata = {'url': '/api/{walletId}/verifications/propose/{connectionId}'}

    def submit_verification_auto_select(
            self, wallet_id, verification_id, custom_headers=None, raw=False, **operation_config):
        """Submit verification with automatic credential selection.

        Submit the verification with a credential that matches the requested
        information.
        If a credential is not available for a certain policy, that policy will
        not be included in the submitted verification.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param verification_id: The verification identifier
        :type verification_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.submit_verification_auto_select.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'verificationId': self._serialize.url("verification_id", verification_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    submit_verification_auto_select.metadata = {'url': '/api/{walletId}/verifications/{verificationId}/autoSelect'}

    def get_available_credentials_for_verification(
            self, wallet_id, verification_id, custom_headers=None, raw=False, **operation_config):
        """List all credentials for verification.

        List all available credentials that satisfy the verification request.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param verification_id: The verification identifier
        :type verification_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~wallet.models.VerificationPolicyCredentialContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_available_credentials_for_verification.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str'),
            'verificationId': self._serialize.url("verification_id", verification_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[VerificationPolicyCredentialContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_available_credentials_for_verification.metadata = {'url': '/api/{walletId}/verifications/{verificationId}/availableCredentials'}

    def submit_verification_from_data_auto_select(
            self, wallet_id, verification_data, custom_headers=None, raw=False, **operation_config):
        """Submit verification with automatic credential selection from data.

        Submit the verification from data with automatic credential selection.
        Verification data can be in the form of a URL or base64 data.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param verification_data:
        :type verification_data: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.submit_verification_from_data_auto_select.metadata['url']
        path_format_arguments = {
            'walletId': self._serialize.url("wallet_id", wallet_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'verificationData': verification_data,
        }

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    submit_verification_from_data_auto_select.metadata = {'url': '/api/{walletId}/verifications/fromData/autoSelect'}

    def list_wallets(
            self, custom_headers=None, raw=False, **operation_config):
        """List all wallets.

        List all custodian wallets for the current authorization context.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~wallet.models.CustodianWalletContract] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.list_wallets.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[CustodianWalletContract]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_wallets.metadata = {'url': '/api/wallets'}

    def create_wallet(
            self, body, custom_headers=None, raw=False, **operation_config):
        """Create wallet.

        Create a new custodian wallet.

        :param body: The wallet parameters
        :type body: ~wallet.models.WalletParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CustodianWalletContract or ClientRawResponse if raw=true
        :rtype: ~wallet.models.CustodianWalletContract or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_wallet.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'WalletParameters')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CustodianWalletContract', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_wallet.metadata = {'url': '/api/wallets'}

    def delete_wallet_by_query(
            self, wallet_id, custom_headers=None, raw=False, **operation_config):
        """Delete wallet by query.

        Permanently delete all connections, credentials and verification
        records for the specified wallet.

        :param wallet_id: The wallet identifier
        :type wallet_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_wallet_by_query.metadata['url']

        # Construct parameters
        query_parameters = {}
        query_parameters['walletId'] = self._serialize.query("wallet_id", wallet_id, 'str')

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_wallet_by_query.metadata = {'url': '/api/wallets'}
