# NUCLEI

[![Checked with mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)


This repository is created by [CEMS BV](https://cemsbv.nl/) and helps the user to access and process API calls to the [NUCLEI](https://nuclei.cemsbv.io/#/) environment.

# Installation

To install a package in this repository run:

`$ pip install cems-nuclei`

Please note that to use `NucleiClient` library `cems-nuclei[client]` should be installed.

## ENV VARS

To use `nuclei` add the follow ENV vars to your environment. Or provide them when asked.

```
* NUCLEI_TOKEN
    - Your NUCLEI user token
```

You can obtain your `NUCLEI_TOKEN` on [NUCLEI](https://nuclei.cemsbv.io/#/). 
Go to `personal-access-tokens` and create a new user token.

# Contribution

## Environment

We recommend developing in Python3.9 with a clean virtual environment (using `virtualenv` or `conda`), installing the requirements from the requirements.txt file:

Example using `virtualenv` and `pip` to install the dependencies in a new environment .env on Linux:

```bash
python -m venv .env
source activate .env/bin/activate
python -m pip install --upgrade pip setuptools
pip install -r requirements.txt
pip install -e .
```

## Documentation

Build the docs:

```bash
python -m pip install --upgrade pip setuptools
pip install -r requirements.txt
pip install .
sphinx-build -b html docs public
```

Note: You'll need to set the `NUCLEI_TOKEN` environmental variable.
You can get your token at: `https://cemsbv.crux-nuclei.com`

## Format

We format our code with black and isort.

```bash
black --config "pyproject.toml" src/nuclei tests
isort --settings-path "pyproject.toml" src/nuclei tests
```

## Lint

To maintain code quality we use the GitHub super-linter.

To run the linters locally, run the `run_super_linters.sh` bash script from the root directory.

## UnitTest

Test the software with the use of coverage:

```bash
python -m pip install --upgrade pip setuptools
pip install -r requirements.txt
pip install .
coverage run -m pytest
```

## Requirements

Requirements are autogenerated by `pip-compile` with python 3.9

```bash
pip-compile --extra=test --extra=docs --extra=lint --extra=client --output-file=requirements.txt pyproject.toml
```

To update the requirements within the defined ranges, run:

```bash
pip-compile --upgrade --extra=test --extra=docs --extra=lint --extra=client --output-file=requirements.txt pyproject.toml
```