"""
Django settings for cx_bui project.

Generated by 'django-admin startproject' using Django 2.2.4.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""

import os
import yaml
from pathlib import Path
import logging.config

# set the logging level to error:
LOGGING_CONFIG = None

cx_folder = Path(os.path.dirname(os.path.abspath(__file__))).parent.parent.parent
yaml_path = cx_folder.joinpath('.cxconfig.yaml')
try:
    with open(yaml_path.as_posix(), 'r') as file:
        httpsconfig = yaml.load(file, Loader=yaml.FullLoader)
    log_path = Path(httpsconfig['log']['path'])
    print("Setting log path to {}".format(log_path))
    # creating a new log file if it exists to prevent losing previous logs after update or reset
    counter = 1
    while log_path.joinpath('.cxerror{}.log'.format(counter)).is_file():
        counter += 1

    logging.config.dictConfig({
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'console': {
                # exact format is not important, this is the minimum information
                'format': '%(asctime)s %(name)-12s %(levelname)-8s %(message)s',
            },
            'file': {
                'format': '%(asctime)s %(name)-12s %(levelname)-8s %(message)s'
            }
        },
        'handlers': {
            'console': {
                'class': 'logging.StreamHandler',
                'formatter': 'console',
            },
            'error_logfile': {
                'level': 'ERROR',
                'class': 'logging.FileHandler',
                'formatter': 'file',
                'filename': log_path.joinpath('.cxerror{}.log'.format(counter)).as_posix()
            },
            'info_logfile': {
                'level': 'INFO',
                'class': 'logging.FileHandler',
                'formatter': 'file',
                'filename': log_path.joinpath('.cxinfo{}.log'.format(counter)).as_posix()
            }

        },
        'loggers': {
            'error_logger': {
                'level': 'ERROR',
                'handlers': ['console', 'error_logfile'],
            },
            'info_logger': {
                'level': 'INFO',
                'handlers': ['console', 'info_logfile'],
            },
        },
    })
except FileNotFoundError:
    print("Server configuration file not found, logging to console only")
    logging.config.dictConfig({
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'console': {
                # exact format is not important, this is the minimum information
                'format': '%(asctime)s %(name)-12s %(levelname)-8s %(message)s',
            },
            'file': {
                'format': '%(asctime)s %(name)-12s %(levelname)-8s %(message)s'
            }
        },
        'handlers': {
            'console': {
                'class': 'logging.StreamHandler',
                'formatter': 'console',
            }
        },
        'loggers': {
            'error_logger': {
                'level': 'ERROR',
                'handlers': ['console'],
            },
            'info_logger': {
                'level': 'INFO',
                'handlers': ['console'],
            },
        },
    })


# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'w$2!yh7k3c_io1xs90+*lbogfny2oe%)w-w4gm)s(ttvgqcpe&'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = [
    'hbp-bsp-cxsys2.cineca.it',
    'bspg.pa.ibf.cnr.it',
    '127.0.0.1',
    ]

# Application definition

INSTALLED_APPS = [
    'cxsystem2',
    'django_extensions',
    'sslserver',
    'editor',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    # 'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'cx_bui.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'cx_bui.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.2/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'


STATICFILES_DIRS = (
    os.path.join(BASE_DIR, 'static'),
)

# STATIC_ROOT = os.path.join(BASE_DIR, 'staticfiles')

