# generated by datamodel-codegen:
#   filename:  scanner-adapter-openapi-v1.1.yaml
#   timestamp: 2023-02-01T15:23:46+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import AnyUrl, Field

from .base import BaseModel


class Scanner(BaseModel):
    name: Optional[str] = Field(
        None, description="The name of the scanner.", example="Trivy"
    )
    vendor: Optional[str] = Field(
        None, description="The name of the scanner's provider.", example="Aqua Security"
    )
    version: Optional[str] = Field(
        None, description="The version of the scanner.", example="0.4.0"
    )


class ScannerProperties(BaseModel):
    __root__: Optional[Dict[str, str]] = None


class ScannerCapability(BaseModel):
    consumes_mime_types: List[str] = Field(
        ...,
        description='The set of MIME types of the artifacts supported by the scanner to produce the reports specified in the "produces_mime_types". A given\nmime type should only be present in one capability item.\n',
        example=[
            "application/vnd.oci.image.manifest.v1+json",
            "application/vnd.docker.distribution.manifest.v2+json",
        ],
    )
    produces_mime_types: List[str] = Field(
        ...,
        description="The set of MIME types of reports generated by the scanner for the consumes_mime_types of the same capability record.\n",
        example=[
            "application/vnd.scanner.adapter.vuln.report.harbor+json; version=1.0"
        ],
    )


class ScanRequestId(BaseModel):
    __root__: str = Field(
        ...,
        description="A unique identifier returned by the [/scan](#/operation/AcceptScanRequest] operations. The format of the\nidentifier is not imposed but it should be unique enough to prevent collisons when polling for scan reports.\n",
        example="3fa85f64-5717-4562-b3fc-2c963f66afa6",
    )


class Registry(BaseModel):
    url: Optional[str] = Field(
        None,
        description="A base URL or the Docker Registry v2 API.",
        example="https://core.harbor.domain",
    )
    authorization: Optional[str] = Field(
        None,
        description="An optional value of the HTTP Authorization header sent with each request to the Docker Registry v2 API.\nIt's used to exchange Base64 encoded robot account credentials to a short lived JWT access token which\nallows the underlying scanner to pull the artifact from the Docker Registry.\n",
        example="Basic BASE64_ENCODED_CREDENTIALS",
    )


class Artifact(BaseModel):
    repository: Optional[str] = Field(
        None,
        description="The name of the Docker Registry repository containing the artifact.",
        example="library/mongo",
    )
    digest: Optional[str] = Field(
        None,
        description="The artifact's digest, consisting of an algorithm and hex portion.",
        example="sha256:6c3c624b58dbbcd3c0dd82b4c53f04194d1247c6eebdaab7c610cf7d66709b3b",
    )
    tag: Optional[str] = Field(
        None, description="The artifact's tag", example="3.14-xenial"
    )
    mime_type: Optional[str] = Field(
        None,
        description="The MIME type of the artifact.",
        example="application/vnd.docker.distribution.manifest.v2+json",
    )


class Severity(Enum):
    unknown = "Unknown"
    negligible = "Negligible"
    low = "Low"
    medium = "Medium"
    high = "High"
    critical = "Critical"


class Error(BaseModel):
    message: Optional[str] = Field(None, example="Some unexpected error")


class CVSSDetails(BaseModel):
    score_v3: Optional[float] = Field(
        None, description="The CVSS 3.0 score for the vulnerability.\n", example=3.2
    )
    score_v2: Optional[float] = Field(
        None, description="The CVSS 2.0 score for the vulnerability.\n"
    )
    vector_v3: Optional[str] = Field(
        None,
        description="The CVSS 3.0 vector for the vulnerability. \n",
        example="CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N",
    )
    vector_v2: Optional[str] = Field(
        None,
        description="The CVSS 2.0 vector for the vulnerability. The string is of the form AV:L/AC:M/Au:N/C:P/I:N/A:N\n",
        example="AV:N/AC:L/Au:N/C:N/I:N/A:P",
    )


class ScannerAdapterMetadata(BaseModel):
    scanner: Scanner
    capabilities: List[ScannerCapability]
    properties: Optional[ScannerProperties] = None


class ScanRequest(BaseModel):
    registry: Registry
    artifact: Artifact


class ScanResponse(BaseModel):
    id: ScanRequestId


class VulnerabilityItem(BaseModel):
    id: Optional[str] = Field(
        None,
        description="The unique identifier of the vulnerability.",
        example="CVE-2017-8283",
    )
    package: Optional[str] = Field(
        None,
        description="An operating system package containing the vulnerability.\n",
        example="dpkg",
    )
    version: Optional[str] = Field(
        None,
        description="The version of the package containing the vulnerability.\n",
        example="1.17.27",
    )
    fix_version: Optional[str] = Field(
        None,
        description="The version of the package containing the fix if available.\n",
        example="1.18.0",
    )
    severity: Optional[Severity] = None
    description: Optional[str] = Field(
        None,
        description="The detailed description of the vulnerability.\n",
        example="dpkg-source in dpkg 1.3.0 through 1.18.23 is able to use a non-GNU patch program\nand does not offer a protection mechanism for blank-indented diff hunks, which\nallows remote attackers to conduct directory traversal attacks via a crafted\nDebian source package, as demonstrated by using of dpkg-source on NetBSD.\n",
    )
    links: Optional[List[AnyUrl]] = Field(
        None,
        description="The list of links to the upstream databases with the full description of the vulnerability.\n",
        example=["https://security-tracker.debian.org/tracker/CVE-2017-8283"],
    )
    preferred_cvss: Optional[CVSSDetails] = None
    cwe_ids: Optional[List[str]] = Field(
        None,
        description="The Common Weakness Enumeration Identifiers associated with this vulnerability.\n",
        example=["CWE-476"],
    )
    vendor_attributes: Optional[Dict[str, Any]] = None


class ErrorResponse(BaseModel):
    error: Optional[Error] = None


class HarborVulnerabilityReport(BaseModel):
    generated_at: Optional[datetime] = None
    artifact: Optional[Artifact] = None
    scanner: Optional[Scanner] = None
    severity: Optional[Severity] = None
    vulnerabilities: Optional[List[VulnerabilityItem]] = None
