"""
The contents of this file are the return value of
``sympy.assumptions.ask.compute_known_facts``.

Do NOT manually edit this file.
Instead, run ./bin/ask_update.py.
"""

from sympy.core.cache import cacheit
from sympy.logic.boolalg import And
from sympy.assumptions.ask import Q

# -{ Known facts in Conjunctive Normal Form }-
@cacheit
def get_known_facts_cnf():
    return And(
        Q.invertible | Q.singular,
        Q.algebraic | ~Q.rational,
        Q.antihermitian | ~Q.imaginary,
        Q.complex | ~Q.algebraic,
        Q.complex | ~Q.imaginary,
        Q.complex | ~Q.real,
        Q.complex | ~Q.transcendental,
        Q.complex_elements | ~Q.real_elements,
        Q.even | ~Q.zero,
        Q.extended_real | ~Q.infinite,
        Q.extended_real | ~Q.real,
        Q.finite | ~Q.algebraic,
        Q.finite | ~Q.irrational,
        Q.finite | ~Q.rational,
        Q.finite | ~Q.transcendental,
        Q.fullrank | ~Q.invertible,
        Q.hermitian | ~Q.real,
        Q.integer | ~Q.even,
        Q.integer | ~Q.odd,
        Q.integer | ~Q.prime,
        Q.invertible | ~Q.positive_definite,
        Q.invertible | ~Q.unitary,
        Q.lower_triangular | ~Q.diagonal,
        Q.nonnegative | ~Q.positive,
        Q.nonnegative | ~Q.zero,
        Q.nonpositive | ~Q.negative,
        Q.nonpositive | ~Q.zero,
        Q.nonzero | ~Q.negative,
        Q.nonzero | ~Q.positive,
        Q.normal | ~Q.diagonal,
        Q.normal | ~Q.unitary,
        Q.positive | ~Q.prime,
        Q.positive_definite | ~Q.orthogonal,
        Q.rational | ~Q.integer,
        Q.real | ~Q.irrational,
        Q.real | ~Q.negative,
        Q.real | ~Q.positive,
        Q.real | ~Q.rational,
        Q.real | ~Q.zero,
        Q.real_elements | ~Q.integer_elements,
        Q.square | ~Q.invertible,
        Q.square | ~Q.normal,
        Q.square | ~Q.symmetric,
        Q.symmetric | ~Q.diagonal,
        Q.triangular | ~Q.lower_triangular,
        Q.triangular | ~Q.unit_triangular,
        Q.triangular | ~Q.upper_triangular,
        Q.unitary | ~Q.orthogonal,
        Q.upper_triangular | ~Q.diagonal,
        ~Q.algebraic | ~Q.transcendental,
        ~Q.antihermitian | ~Q.hermitian,
        ~Q.composite | ~Q.prime,
        ~Q.even | ~Q.odd,
        ~Q.finite | ~Q.infinite,
        ~Q.imaginary | ~Q.real,
        ~Q.invertible | ~Q.singular,
        ~Q.irrational | ~Q.rational,
        ~Q.negative | ~Q.positive,
        ~Q.negative | ~Q.zero,
        ~Q.positive | ~Q.zero,
        Q.even | Q.odd | ~Q.integer,
        Q.infinite | Q.real | ~Q.extended_real,
        Q.lower_triangular | Q.upper_triangular | ~Q.triangular,
        Q.negative | Q.positive | ~Q.nonzero,
        Q.negative | Q.zero | ~Q.nonpositive,
        Q.positive | Q.zero | ~Q.nonnegative,
        Q.diagonal | ~Q.lower_triangular | ~Q.upper_triangular,
        Q.invertible | ~Q.fullrank | ~Q.square,
        Q.orthogonal | ~Q.real | ~Q.unitary,
        Q.negative | Q.positive | Q.zero | ~Q.real,
        Q.algebraic | Q.transcendental | ~Q.complex | ~Q.finite,
        Q.composite | Q.prime | ~Q.integer | ~Q.positive,
        Q.irrational | Q.rational | ~Q.finite | ~Q.real
    )

# -{ Known facts in compressed sets }-
@cacheit
def get_known_facts_dict():
    return {
        Q.algebraic: set([Q.algebraic, Q.complex, Q.finite]),
        Q.antihermitian: set([Q.antihermitian]),
        Q.commutative: set([Q.commutative]),
        Q.complex: set([Q.complex]),
        Q.complex_elements: set([Q.complex_elements]),
        Q.composite: set([Q.composite]),
        Q.diagonal: set([Q.diagonal, Q.lower_triangular, Q.normal, Q.square,
        Q.symmetric, Q.triangular, Q.upper_triangular]),
        Q.even: set([Q.algebraic, Q.complex, Q.even, Q.extended_real,
        Q.finite, Q.hermitian, Q.integer, Q.rational, Q.real]),
        Q.extended_real: set([Q.extended_real]),
        Q.finite: set([Q.finite]),
        Q.fullrank: set([Q.fullrank]),
        Q.hermitian: set([Q.hermitian]),
        Q.imaginary: set([Q.antihermitian, Q.complex, Q.imaginary]),
        Q.infinite: set([Q.extended_real, Q.infinite]),
        Q.integer: set([Q.algebraic, Q.complex, Q.extended_real, Q.finite,
        Q.hermitian, Q.integer, Q.rational, Q.real]),
        Q.integer_elements: set([Q.complex_elements, Q.integer_elements,
        Q.real_elements]),
        Q.invertible: set([Q.fullrank, Q.invertible, Q.square]),
        Q.irrational: set([Q.complex, Q.extended_real, Q.finite, Q.hermitian,
        Q.irrational, Q.nonzero, Q.real]),
        Q.is_true: set([Q.is_true]),
        Q.lower_triangular: set([Q.lower_triangular, Q.triangular]),
        Q.negative: set([Q.complex, Q.extended_real, Q.hermitian, Q.negative,
        Q.nonpositive, Q.nonzero, Q.real]),
        Q.nonnegative: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonnegative, Q.real]),
        Q.nonpositive: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonpositive, Q.real]),
        Q.nonzero: set([Q.complex, Q.extended_real, Q.hermitian, Q.nonzero,
        Q.real]),
        Q.normal: set([Q.normal, Q.square]),
        Q.odd: set([Q.algebraic, Q.complex, Q.extended_real, Q.finite,
        Q.hermitian, Q.integer, Q.nonzero, Q.odd, Q.rational, Q.real]),
        Q.orthogonal: set([Q.fullrank, Q.invertible, Q.normal, Q.orthogonal,
        Q.positive_definite, Q.square, Q.unitary]),
        Q.positive: set([Q.complex, Q.extended_real, Q.hermitian,
        Q.nonnegative, Q.nonzero, Q.positive, Q.real]),
        Q.positive_definite: set([Q.fullrank, Q.invertible,
        Q.positive_definite, Q.square]),
        Q.prime: set([Q.algebraic, Q.complex, Q.extended_real, Q.finite,
        Q.hermitian, Q.integer, Q.nonnegative, Q.nonzero, Q.positive,
        Q.prime, Q.rational, Q.real]),
        Q.rational: set([Q.algebraic, Q.complex, Q.extended_real, Q.finite,
        Q.hermitian, Q.rational, Q.real]),
        Q.real: set([Q.complex, Q.extended_real, Q.hermitian, Q.real]),
        Q.real_elements: set([Q.complex_elements, Q.real_elements]),
        Q.singular: set([Q.singular]),
        Q.square: set([Q.square]),
        Q.symmetric: set([Q.square, Q.symmetric]),
        Q.transcendental: set([Q.complex, Q.finite, Q.transcendental]),
        Q.triangular: set([Q.triangular]),
        Q.unit_triangular: set([Q.triangular, Q.unit_triangular]),
        Q.unitary: set([Q.fullrank, Q.invertible, Q.normal, Q.square,
        Q.unitary]),
        Q.upper_triangular: set([Q.triangular, Q.upper_triangular]),
        Q.zero: set([Q.algebraic, Q.complex, Q.even, Q.extended_real,
        Q.finite, Q.hermitian, Q.integer, Q.nonnegative,
        Q.nonpositive, Q.rational, Q.real, Q.zero]),
    }
