# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-09-28 12:23
from __future__ import unicode_literals

from django.db import migrations


def move_transport_entries(apps, schema_editor):
    """Move old transport entries to new model."""
    pf_Transport = apps.get_model("modoboa_postfix_autoreply", "Transport")
    Transport = apps.get_model("transport", "Transport")
    to_create = []
    for old_transport in pf_Transport.objects.all():
        to_create.append(Transport(
            pattern=old_transport.domain, service="autoreply"))
    Transport.objects.bulk_create(to_create)


def backward(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('transport', '0002_auto_20180928_1520'),
        ('modoboa_postfix_autoreply', '0006_auto_20160329_1501'),
    ]

    operations = [
        migrations.RunPython(move_transport_entries, backward),
    ]
