"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Manifest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
class Manifest {
    constructor(props = {}) {
        this.outdir = props.outdir ?? '.cdktg.out';
        this.data = {};
    }
    static fromFile(dir) {
        const manifest = new Manifest({
            outdir: dir,
        });
        const json = fs.readJSONSync(path.join(dir, 'manifest.json'));
        Object.keys(json).forEach(k => {
            manifest.addModel(k, json[k]);
        });
        return manifest;
    }
    addModel(title, filePath) {
        this.data[title] = filePath;
    }
    save() {
        fs.writeJSONSync(path.join(this.outdir, 'manifest.json'), this.data, {
            spaces: 4,
        });
    }
}
exports.Manifest = Manifest;
_a = JSII_RTTI_SYMBOL_1;
Manifest[_a] = { fqn: "cdktg.Manifest", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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