import { Construct } from 'constructs';
import { Asset, AssetProps } from './asset';
import * as spec from './spec/threatgile.generated';
export interface DataAssetProps extends AssetProps {
    readonly origin?: string;
    readonly owner?: string;
    readonly quantity: Quantity;
}
export declare class DataAsset extends Asset {
    readonly origin?: string;
    readonly owner?: string;
    readonly quantity: Quantity;
    constructor(model: Construct, id: string, props: DataAssetProps);
    /**
     * @internal
     */
    _toThreagile(): spec.Threagile['data_assets'];
}
export declare enum Quantity {
    VERY_FEW = "very-few",
    FEW = "few",
    MANY = "many",
    VERY_MANY = "very-many"
}
