"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PingCommand = void 0;
const threagile_1 = require("../api/threagile");
class PingCommand {
    constructor() {
        this.command = 'ping';
        this.describe = 'ping the api';
        this.builder = (args) => {
            args.option('url', { type: 'string', alias: 'u', describe: '' });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            const api = new threagile_1.Threagile(url);
            const resp = await api.ping();
            if (resp.status === 200) {
                console.log(`✅  ${resp.data.message}\n`);
            }
            else {
                console.log('❌  Error\n');
            }
        };
    }
}
exports.PingCommand = PingCommand;
//# sourceMappingURL=data:application/json;base64,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