"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckCommand = void 0;
const path = require("path");
const threagile_1 = require("../api/threagile");
const manifest_1 = require("../manifest");
class CheckCommand {
    constructor() {
        this.command = 'check';
        this.describe = 'check the models';
        this.builder = (args) => {
            args.option('url', { type: 'string', alias: 'u', describe: '' });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromFile('.cdktg.out');
            Object.keys(manifest.data).forEach(async (k) => {
                const filepath = path.join(manifest.outdir, `${manifest.data[k]}.yml`);
                const resp = await api.check(filepath);
                console.log(`Results for model "${k}":`);
                if (resp.status === 200) {
                    console.log(`✅  ${resp.data.message}\n`);
                }
                else {
                    console.log(`❌  ${resp.data.message}\n`);
                }
            });
        };
    }
}
exports.CheckCommand = CheckCommand;
//# sourceMappingURL=data:application/json;base64,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