"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyseCommand = void 0;
const path = require("path");
const AdmZip = require("adm-zip");
const fs = require("fs-extra");
const threagile_1 = require("../api/threagile");
const manifest_1 = require("../manifest");
class AnalyseCommand {
    constructor() {
        this.command = 'analyse';
        this.describe = 'analyze the models';
        this.builder = (args) => {
            args.option('url', { type: 'string', alias: 'u', describe: '' });
            args.option('out', { type: 'string', alias: 'o', describe: '', default: 'dist' });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            fs.mkdirSync(args.out, { recursive: true });
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromFile('.cdktg.out');
            Object.keys(manifest.data).forEach(async (k) => {
                const filepath = path.join(manifest.outdir, `${manifest.data[k]}.yml`);
                const resp = await api.analyse(filepath);
                if (resp.status === 400) {
                    console.log(resp.data.error);
                    return;
                }
                const zip = new AdmZip(resp.data);
                zip.extractAllTo(path.join(args.out, k));
            });
        };
    }
}
exports.AnalyseCommand = AnalyseCommand;
//# sourceMappingURL=data:application/json;base64,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