"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Threagile = void 0;
const fs = require("fs-extra");
const generated_1 = require("./generated");
class Threagile {
    constructor(baseURL) {
        const configuration = new generated_1.Configuration({
            basePath: baseURL,
        });
        this.metaApi = new generated_1.MetaApi(configuration);
        this.directApi = new generated_1.DirectApi(configuration);
    }
    async ping() {
        return this.metaApi.metaPingGet();
    }
    async check(filename) {
        if (!fs.existsSync(filename)) {
            throw new Error(`File ${filename} not exist!`);
        }
        const file = fs.createReadStream(filename);
        return this.directApi.directCheckPost(file);
    }
    async analyse(filename, dpi = 120) {
        if (!fs.existsSync(filename)) {
            throw new Error(`File ${filename} not exist!`);
        }
        const file = fs.createReadStream(filename);
        return this.directApi.directAnalyzePost(dpi, file, {
            responseType: 'arraybuffer',
        });
    }
}
exports.Threagile = Threagile;
//# sourceMappingURL=data:application/json;base64,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