/**
 * Threagile API
 * <b>Threagile API</b> for Agile Threat Modeling: visit <a href=\"https://threagile.io\">https://threagile.io</a> for more information.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { Configuration } from './configuration';
import { AxiosPromise, AxiosInstance, AxiosRequestConfig } from 'axios';
import { RequestArgs, BaseAPI } from './base';
/**
 *
 * @export
 * @interface AuthKeysDelete200Response
 */
export interface AuthKeysDelete200Response {
    /**
     *
     * @type {string}
     * @memberof AuthKeysDelete200Response
     */
    'message'?: string;
}
/**
 *
 * @export
 * @interface AuthKeysDelete201Response
 */
export interface AuthKeysDelete201Response {
    /**
     *
     * @type {string}
     * @memberof AuthKeysDelete201Response
     */
    'key'?: string;
}
/**
 *
 * @export
 * @interface AuthKeysDelete404Response
 */
export interface AuthKeysDelete404Response {
    /**
     *
     * @type {string}
     * @memberof AuthKeysDelete404Response
     */
    'error'?: string;
}
/**
 *
 * @export
 * @interface AuthKeysDelete500Response
 */
export interface AuthKeysDelete500Response {
    /**
     *
     * @type {string}
     * @memberof AuthKeysDelete500Response
     */
    'error'?: string;
}
/**
 *
 * @export
 * @interface AuthTokensDelete200Response
 */
export interface AuthTokensDelete200Response {
    /**
     *
     * @type {string}
     * @memberof AuthTokensDelete200Response
     */
    'message'?: string;
}
/**
 *
 * @export
 * @interface AuthTokensDelete201Response
 */
export interface AuthTokensDelete201Response {
    /**
     *
     * @type {string}
     * @memberof AuthTokensDelete201Response
     */
    'token'?: string;
}
/**
 *
 * @export
 * @interface AuthTokensDelete404Response
 */
export interface AuthTokensDelete404Response {
    /**
     *
     * @type {string}
     * @memberof AuthTokensDelete404Response
     */
    'error'?: string;
}
/**
 *
 * @export
 * @interface AuthTokensDelete500Response
 */
export interface AuthTokensDelete500Response {
    /**
     *
     * @type {string}
     * @memberof AuthTokensDelete500Response
     */
    'error'?: string;
}
/**
 *
 * @export
 * @interface DirectCheckPost200Response
 */
export interface DirectCheckPost200Response {
    /**
     *
     * @type {string}
     * @memberof DirectCheckPost200Response
     */
    'message'?: string;
}
/**
 *
 * @export
 * @interface DirectCheckPost400Response
 */
export interface DirectCheckPost400Response {
    /**
     *
     * @type {string}
     * @memberof DirectCheckPost400Response
     */
    'error'?: string;
}
/**
 *
 * @export
 * @interface MetaPingGet200Response
 */
export interface MetaPingGet200Response {
    /**
     *
     * @type {string}
     * @memberof MetaPingGet200Response
     */
    'message'?: string;
}
/**
 *
 * @export
 * @interface MetaStatsGet200Response
 */
export interface MetaStatsGet200Response {
    /**
     *
     * @type {number}
     * @memberof MetaStatsGet200Response
     */
    'key_count'?: number;
    /**
     *
     * @type {number}
     * @memberof MetaStatsGet200Response
     */
    'model_count'?: number;
    /**
     *
     * @type {number}
     * @memberof MetaStatsGet200Response
     */
    'success_count'?: number;
    /**
     *
     * @type {number}
     * @memberof MetaStatsGet200Response
     */
    'error_count'?: number;
}
/**
 *
 * @export
 * @interface MetaTypesGet200Response
 */
export interface MetaTypesGet200Response {
    /**
     *
     * @type {Array<string>}
     * @memberof MetaTypesGet200Response
     */
    'confidentiality'?: Array<string>;
}
/**
 *
 * @export
 * @interface MetaVersionGet200Response
 */
export interface MetaVersionGet200Response {
    /**
     *
     * @type {string}
     * @memberof MetaVersionGet200Response
     */
    'version'?: string;
    /**
     *
     * @type {string}
     * @memberof MetaVersionGet200Response
     */
    'build_timestamp'?: string;
}
/**
 * AuthApi - axios parameter creator
 * @export
 */
export declare const AuthApiAxiosParamCreator: (configuration?: Configuration | undefined) => {
    /**
     * Delete an auth key
     * @summary Delete an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authKeysDelete: (key: string, options?: AxiosRequestConfig) => Promise<RequestArgs>;
    /**
     * Create a new auth key
     * @summary Create a new auth key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authKeysPost: (options?: AxiosRequestConfig) => Promise<RequestArgs>;
    /**
     * Delete a token
     * @summary Delete a token
     * @param {string} token
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authTokensDelete: (token: string, options?: AxiosRequestConfig) => Promise<RequestArgs>;
    /**
     * Create a new (time limited) token from an auth key
     * @summary Create a new (time limited) token from an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authTokensPost: (key: string, options?: AxiosRequestConfig) => Promise<RequestArgs>;
};
/**
 * AuthApi - functional programming interface
 * @export
 */
export declare const AuthApiFp: (configuration?: Configuration | undefined) => {
    /**
     * Delete an auth key
     * @summary Delete an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authKeysDelete(key: string, options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AuthKeysDelete200Response>>;
    /**
     * Create a new auth key
     * @summary Create a new auth key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authKeysPost(options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AuthKeysDelete201Response>>;
    /**
     * Delete a token
     * @summary Delete a token
     * @param {string} token
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authTokensDelete(token: string, options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AuthTokensDelete200Response>>;
    /**
     * Create a new (time limited) token from an auth key
     * @summary Create a new (time limited) token from an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authTokensPost(key: string, options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AuthTokensDelete201Response>>;
};
/**
 * AuthApi - factory interface
 * @export
 */
export declare const AuthApiFactory: (configuration?: Configuration | undefined, basePath?: string | undefined, axios?: AxiosInstance | undefined) => {
    /**
     * Delete an auth key
     * @summary Delete an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authKeysDelete(key: string, options?: any): AxiosPromise<AuthKeysDelete200Response>;
    /**
     * Create a new auth key
     * @summary Create a new auth key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authKeysPost(options?: any): AxiosPromise<AuthKeysDelete201Response>;
    /**
     * Delete a token
     * @summary Delete a token
     * @param {string} token
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authTokensDelete(token: string, options?: any): AxiosPromise<AuthTokensDelete200Response>;
    /**
     * Create a new (time limited) token from an auth key
     * @summary Create a new (time limited) token from an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authTokensPost(key: string, options?: any): AxiosPromise<AuthTokensDelete201Response>;
};
/**
 * AuthApi - object-oriented interface
 * @export
 * @class AuthApi
 * @extends {BaseAPI}
 */
export declare class AuthApi extends BaseAPI {
    /**
     * Delete an auth key
     * @summary Delete an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AuthApi
     */
    authKeysDelete(key: string, options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<AuthKeysDelete200Response, any>>;
    /**
     * Create a new auth key
     * @summary Create a new auth key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AuthApi
     */
    authKeysPost(options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<AuthKeysDelete201Response, any>>;
    /**
     * Delete a token
     * @summary Delete a token
     * @param {string} token
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AuthApi
     */
    authTokensDelete(token: string, options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<AuthTokensDelete200Response, any>>;
    /**
     * Create a new (time limited) token from an auth key
     * @summary Create a new (time limited) token from an auth key
     * @param {string} key
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AuthApi
     */
    authTokensPost(key: string, options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<AuthTokensDelete201Response, any>>;
}
/**
 * DirectApi - axios parameter creator
 * @export
 */
export declare const DirectApiAxiosParamCreator: (configuration?: Configuration | undefined) => {
    /**
     * Direct model analyze call
     * @summary Direct model analyze call
     * @param {number} [dpi] The DPI (resolution) to use for the diagram generation
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directAnalyzePost: (dpi?: number | undefined, file?: any, options?: AxiosRequestConfig) => Promise<RequestArgs>;
    /**
     * Direct model check call
     * @summary Direct model check call
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directCheckPost: (file?: any, options?: AxiosRequestConfig) => Promise<RequestArgs>;
    /**
     * Stub model file (as a starting point)
     * @summary Stub model file
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directStubGet: (options?: AxiosRequestConfig) => Promise<RequestArgs>;
};
/**
 * DirectApi - functional programming interface
 * @export
 */
export declare const DirectApiFp: (configuration?: Configuration | undefined) => {
    /**
     * Direct model analyze call
     * @summary Direct model analyze call
     * @param {number} [dpi] The DPI (resolution) to use for the diagram generation
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directAnalyzePost(dpi?: number | undefined, file?: any, options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<any>>;
    /**
     * Direct model check call
     * @summary Direct model check call
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directCheckPost(file?: any, options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<DirectCheckPost200Response>>;
    /**
     * Stub model file (as a starting point)
     * @summary Stub model file
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directStubGet(options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<string>>;
};
/**
 * DirectApi - factory interface
 * @export
 */
export declare const DirectApiFactory: (configuration?: Configuration | undefined, basePath?: string | undefined, axios?: AxiosInstance | undefined) => {
    /**
     * Direct model analyze call
     * @summary Direct model analyze call
     * @param {number} [dpi] The DPI (resolution) to use for the diagram generation
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directAnalyzePost(dpi?: number | undefined, file?: any, options?: any): AxiosPromise<any>;
    /**
     * Direct model check call
     * @summary Direct model check call
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directCheckPost(file?: any, options?: any): AxiosPromise<DirectCheckPost200Response>;
    /**
     * Stub model file (as a starting point)
     * @summary Stub model file
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    directStubGet(options?: any): AxiosPromise<string>;
};
/**
 * DirectApi - object-oriented interface
 * @export
 * @class DirectApi
 * @extends {BaseAPI}
 */
export declare class DirectApi extends BaseAPI {
    /**
     * Direct model analyze call
     * @summary Direct model analyze call
     * @param {number} [dpi] The DPI (resolution) to use for the diagram generation
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DirectApi
     */
    directAnalyzePost(dpi?: number, file?: any, options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<any, any>>;
    /**
     * Direct model check call
     * @summary Direct model check call
     * @param {any} [file]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DirectApi
     */
    directCheckPost(file?: any, options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<DirectCheckPost200Response, any>>;
    /**
     * Stub model file (as a starting point)
     * @summary Stub model file
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DirectApi
     */
    directStubGet(options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<string, any>>;
}
/**
 * MetaApi - axios parameter creator
 * @export
 */
export declare const MetaApiAxiosParamCreator: (configuration?: Configuration | undefined) => {
    /**
     * Used as health check in docker container as well
     * @summary Simple health check ping
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaPingGet: (options?: AxiosRequestConfig) => Promise<RequestArgs>;
    /**
     * Model statistics
     * @summary Model statistics
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaStatsGet: (options?: AxiosRequestConfig) => Promise<RequestArgs>;
    /**
     * Listing of all enum type values
     * @summary Listing of all enum type values
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaTypesGet: (options?: AxiosRequestConfig) => Promise<RequestArgs>;
    /**
     * Version number
     * @summary Version number
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaVersionGet: (options?: AxiosRequestConfig) => Promise<RequestArgs>;
};
/**
 * MetaApi - functional programming interface
 * @export
 */
export declare const MetaApiFp: (configuration?: Configuration | undefined) => {
    /**
     * Used as health check in docker container as well
     * @summary Simple health check ping
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaPingGet(options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<MetaPingGet200Response>>;
    /**
     * Model statistics
     * @summary Model statistics
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaStatsGet(options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<MetaStatsGet200Response>>;
    /**
     * Listing of all enum type values
     * @summary Listing of all enum type values
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaTypesGet(options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<MetaTypesGet200Response>>;
    /**
     * Version number
     * @summary Version number
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaVersionGet(options?: AxiosRequestConfig<any> | undefined): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<MetaVersionGet200Response>>;
};
/**
 * MetaApi - factory interface
 * @export
 */
export declare const MetaApiFactory: (configuration?: Configuration | undefined, basePath?: string | undefined, axios?: AxiosInstance | undefined) => {
    /**
     * Used as health check in docker container as well
     * @summary Simple health check ping
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaPingGet(options?: any): AxiosPromise<MetaPingGet200Response>;
    /**
     * Model statistics
     * @summary Model statistics
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaStatsGet(options?: any): AxiosPromise<MetaStatsGet200Response>;
    /**
     * Listing of all enum type values
     * @summary Listing of all enum type values
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaTypesGet(options?: any): AxiosPromise<MetaTypesGet200Response>;
    /**
     * Version number
     * @summary Version number
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    metaVersionGet(options?: any): AxiosPromise<MetaVersionGet200Response>;
};
/**
 * MetaApi - object-oriented interface
 * @export
 * @class MetaApi
 * @extends {BaseAPI}
 */
export declare class MetaApi extends BaseAPI {
    /**
     * Used as health check in docker container as well
     * @summary Simple health check ping
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MetaApi
     */
    metaPingGet(options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<MetaPingGet200Response, any>>;
    /**
     * Model statistics
     * @summary Model statistics
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MetaApi
     */
    metaStatsGet(options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<MetaStatsGet200Response, any>>;
    /**
     * Listing of all enum type values
     * @summary Listing of all enum type values
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MetaApi
     */
    metaTypesGet(options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<MetaTypesGet200Response, any>>;
    /**
     * Version number
     * @summary Version number
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MetaApi
     */
    metaVersionGet(options?: AxiosRequestConfig): Promise<import("axios").AxiosResponse<MetaVersionGet200Response, any>>;
}
