# 漏洞修补策略

在一个系统中发现了漏洞，可以有两种方式进行修补：

1、直接修复这个漏洞。

2、屏蔽这个漏洞。尽可能地屏蔽所有“可能引发这个漏洞”的途径。对于这种修补方式，由于可能引发漏洞的途径有无限多，造物主难以一一屏蔽，因此我们认为漏洞仍有被触发的可能性，并称这种修补方式存在“不严密性”。

以投篮为例，假如系统中存在这样一个漏洞：当篮球投进球框后，篮球不会在地心引力的作用下往下掉，而是会反引力地往天上飞。

此时，造物主可以直接修复这个漏洞，使篮球可以正常地穿过球框并往下掉。

造物主也可以屏蔽这个漏洞，比如抹去篮球这项活动，使这个世界上不存在篮球运动；也可对投球者进行修改，使其无法准确地瞄准球框；也可对球的运动轨迹进行修改，使其总因为莫名其妙刮来的风而错过球框。

造物主屏蔽“投篮漏洞”时，忽视了“灌篮”这个途径，当投球者采取直接灌篮的方式时，漏洞仍会被触发，这便是手法的“不严密性”。

# 占卜的可能性

假设存在这样一种星象相关性：当天上一颗星星陨落，则会有一个对应的人死亡。

在早期，这种相关性可能表现得很明显，如：一旦有一颗星星陨落，则立刻有一人无故暴毙。很自然地：人们很快掌握了这种规律。

造物主可能不会满意这样的设计，于是一段时间以后，他在保持这种相关性的前提下，使这种相关性变得不明显。如：添加时间延迟、制造意外情况、使目标患病等可能的措施，使一切显得合理。

造物主并未直接去除这种事物相关性，而仅仅使其变得不明显。这种相关性仍然存在，若掌握其规律，虽不能作出“立竿见影”的即时性预言，但也能知晓宏观大趋势。

当然，这只是一个故事，只是为了说明“占卜是有可能的”。

# 系统运行越久，越臻于完善

一个持续运行的系统，通常越早期漏洞越多，时间越往后，随着造物主不断修修补补，漏洞便越来越少，系统也臻于完善。

我们所处的这个宇宙，发展至今，除非人类认识世界的思维或工具或感官（思维应从哲学上突破，工具应从科学上突破，感官应从生物学上突破）有革命性的进展，否则已难以再发现宇宙的漏洞了。

至于早期的漏洞，有一些可能被造物主修复了，有一些可能只是被屏蔽了。对于后者，只要造物主还没有修复漏洞，只是采取手段屏蔽，由于手法的不严密性，这些漏洞仍有可能被再次利用。

到今天，想窥伺宇宙万物运行的法则，从古典文献和考古成果中钻研是一种不错的方案，但即便如此，也仅能达到管中窥豹的程度而已。（好像为考古工作赋予了新意义😊）
