# 真正的平等是按需分配

按劳分配的前提是：每个人都有能力自给自足。如：牛，吃的是草，挤出来的是奶，牛有能力自给自足。水稻，从一颗种子开始，吸取大自然能量，成长，水稻也有能力自给自足。人也有能力利用大自然来自给自足，所以按劳分配才有可行性。

但在极端情况下，比如在荒岛上，没有大自然可以利用，这时候，假如人与人真的是平等的，则人之平等的重要内涵——“**生存机会平等**”就无法回避了。为了使生存机会平等，假如胖子需要10个馒头才能填饱肚子，瘦子只需要1个，那就应该给胖子10个，给瘦子1个。因此：真正的平等不是按劳分配，而是按需分配。

# “人人平等”是伪概念

说“人人平等”，就好比说“所有阿拉伯数字都等值”，它们是等值的吗？

平等是个宣传出来的伪概念，它的本质是“洗脑”，目的是“功利”。

假设我同时养了鹰和兔子：

鹰要吃兔子，鹰可以攻击，而兔子只能逃跑 →→ 鹰和兔**天生不平等**。

如果鹰吃了兔子，我就失去了物种多样性，于是我给它们定了一条规则：轮流跑，鹰跑一米，兔子跑一米，谁都没有特权，规则面前鹰兔平等。→→ **规则平等**。

但我在制定规则的时候，很明显偏向了兔子，而削弱了鹰，原因是兔子更【需】要帮助。→→ 制定规则时**按需分配**。

鹰不满意我制定的规则，于是我给它洗脑说：“众生平等，你和兔子是平等的，因此你们只能轮流跑，不能因为你是鹰就给你特权。”鹰默许了，它也只能默许。→→ **洗脑总比赤裸裸的暴力体面**。

综上：**正如鹰和兔一样，人的身份不平等。“人人平等”是人为制定、宣传的结果，是为了实现某些目的而创造出来的伪概念。**

# “规则平等”是伪概念

这世上本没有规则，所有的规则都是人类创造的。最平等的规则就是“无规则”，原因在于：规则之所以是规则，是因为它从各个维度对玩家进行约束，约束之内即是规则。参与者，要么受到这方面约束，要么受到那方面约束，人的特长不一样，被约束的程度就不一样，原本是“八仙过海，各显神通”，现在有人说“不准使用法器，一律乘船”，铁拐李由于本身走路慢所以最高兴。

因此，规则从来不是平等的，哪里有规则，哪里就不平等。

既然如此，那为什么还要有规则？

弄出个规则，目的是为了“维稳”，维持社会稳定。

# 为了实现平等，规则应该偏向弱者

规则如果平等，那就是真正的不平等。

每个人都是从“无”中诞生出来的，入世的门票相同。但个体的身份天生不平等，有的强有的弱。显然世界对每个人门票的反馈不公平。因此：**让规则偏向弱者，使“身份不平等”与“规则不平等”相抵消，才是最终的公平和平等。**

我们所应追求的正是这最终的平等。

以拳击比赛为例子，个体体质不一样，如果都放到同一赛场上，规则是平等了，可瘦小的就完蛋了。所以才分出个不同的重量级，抵消身份的不平等。

一味地追求按劳分配，就是追求规则平等，这样弱者很快就完蛋了，平等的门票却获得不平等的座位。只有在一定程度上按需分配，才能实现一定程度的最终平等。而如果要实现彻底的最终平等，就得彻底地按需分配。
