# 财富稳定型社会

当一个社会中的非消耗型财富数量保持不变、消耗型财富的消耗与生产处于动态平衡状态时，此时的社会模型称为“财富稳定型社会”。

# 财富稳定型社会中的财富分配

我们看一个简化的经济协作案例：

小明开发了一套电子狗程序，只需将该程序拷贝到电子狗模具中，即可完成一只智能电子狗的生产。

生产一只电子狗的流程可以划分为两个步骤：1、制作一个电子狗模具。2、将程序拷贝到制作好的模具中。

此时，小明可以选择雇佣工人帮他制作模具，也可以选择亲自制作模具。已知：电子狗的市场估价为 10000 元/只，普工生产模具的效率为 3 只/人/天。由于场地因素，最多只能雇佣 10 个工人。

如果以收益最大化为目标，忽略销售环节，那么：

1、假如自己制作模具，则每天的盈利为：10000 × 3 = 30000 元。

2、基于 1，假如雇佣工人，设工人的人工费为 n 元/只，那么应满足：`(10000 - n) × 3 × 10 ≧ 30000` ，解得：`n ≦ 9000` 。

也就是说：只有当雇佣费低于 9000 元/只时，小明才会雇佣工人，否则小明将会自己制作模具，而工人也将失去工作机会。

## 收入最低差距

在上例中，工人每天收入的理论上限为 9000 × 3 = 27000 元，小明每天收入的理论下限为 30000 元，相差的这 3000 元，称为“收入最低差距”。

收入最低差距的存在在一些理论中被称为“剥削”，并被由此宣扬对资本家的仇视，在此我们要指出的是：收入最低差距是由市场规律所产生的，是市场本身的内在性质在现实中的映射，而与剥削和压榨无关。

## 新兴技术 与 旧技术

在上例中，小明的收入和工人的收入，最终都来源于电子狗的消费者，而消费者之所以愿意花一万元购买电子狗，是因为电子狗对他而言确实值一万元，他只是在做等价交换而已。而价值一万元的电子狗又是由低廉的人工费和电子程序组成的，换句话说，电子程序是构成这一万元价值的主要成分。当小明开发了这套电子狗程序时，他实际上为社会发明（增加）了新的价值，使社会的财富总和显著上升。

当然，不可否认模具制造技术的价值，尤其是优秀的制造技术。然而，这些制造技术虽然也有着很大的价值，但其价值早已获得了充分的发挥，已曾经为社会总财富带来过显著上涨，成为了当今社会已有财富的总高度中不可忽视的一个片段，其历史使命已经完成。当人类处于钻木取火时代时，社会的总财富非常低（相对于现在），正是不断出现的新技术，化成社会总财富不同高度上的一个个片段，支撑社会总财富的不断上涨。

在上例的收入最低差距中，小明之所以能处于高收益的一方，是因为他创造了新的财富 —— 电子狗程序，这是新的技术，为社会总财富的累积带来了新的片段。对这类新技术，我们称之为“新兴技术”。而工人们之所以处于低收益一方，是因为他们掌握和提供的是已经完成历史使命的技术，对这类技术，我们称之为“旧技术”。

## 财富分配

通过这个案例，我们容易知道：谁能发明或者学会新兴技术，谁就能在收益最低差距中处于高收益的一方。
