@ECHO OFF

pushd %~dp0

REM Command file for Sphinx documentation

if "%SPHINXBUILD%" == "" (
	set SPHINXBUILD=python -msphinx
)
set SOURCEDIR=.
set BUILDDIR=_build
set SPHINXPROJ=quantify_core

REM -vv can be appended below to activate sphinx verbose mode
REM For a reference of the different sphinxopts flags,
REM see https://www.sphinx-doc.org/en/master/man/sphinx-build.html
REM
REM We can't supply -W due to https://github.com/jupyter/jupyter-sphinx/issues/182
set SPHINXOPTS=--keep-going -n -w build_errors.log

if "%1" == "" goto help

%SPHINXBUILD% >NUL 2>NUL
if errorlevel 9009 (
	echo.
	echo.The Sphinx module was not found. Make sure you have Sphinx installed,
	echo.then set the SPHINXBUILD environment variable to point to the full
	echo.path of the 'sphinx-build' executable. Alternatively you may add the
	echo.Sphinx directory to PATH.
	echo.
	echo.If you don't have Sphinx installed, grab it from
	echo.http://sphinx-doc.org/
	exit /b 1
)

%SPHINXBUILD% -M %1 %SOURCEDIR% %BUILDDIR% %SPHINXOPTS%
set SPHINXEXITCODE=%ERRORLEVEL%
goto end

:help
%SPHINXBUILD% -M help %SOURCEDIR% %BUILDDIR% %SPHINXOPTS%

:end
popd
REM Exit with same code as sphinx to make sure the pipeline jobs can pass/fail correctly
exit /b %SPHINXEXITCODE%
