"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const api = require("@aws-cdk/aws-apigateway");
const iam = require("@aws-cdk/aws-iam");
// App setup
const app = new cdk.App();
const stack = new cdk.Stack(app, 'test-apigateway-iot-overriden-params');
stack.templateOptions.description = 'Integration Test for aws-apigateway-iot with overriden params';
const apiGatewayProps = {
    restApiName: 'RestApi-Regional',
    description: 'Description for the Regional Rest Api',
    endpointConfiguration: { types: [api.EndpointType.REGIONAL] },
    apiKeySourceType: api.ApiKeySourceType.HEADER,
    defaultMethodOptions: {
        authorizationType: api.AuthorizationType.NONE,
    }
};
const policyJSON = {
    Version: "2012-10-17",
    Statement: [
        {
            Action: [
                "iot:UpdateThingShadow"
            ],
            Resource: `arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:thing/*`,
            Effect: "Allow"
        },
        {
            Action: [
                "iot:Publish"
            ],
            Resource: `arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:topic/*`,
            Effect: "Allow"
        }
    ]
};
const policyDocument = iam.PolicyDocument.fromJson(policyJSON);
const iamRoleProps = {
    assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
    path: '/',
    inlinePolicies: { testPolicy: policyDocument }
};
// Create a policy that overrides the default policy that gets created with the construct
const apiGatewayExecutionRole = new iam.Role(stack, 'apigateway-iot-role', iamRoleProps);
// Api gateway setup
const props = {
    iotEndpoint: 'a1234567890123-ats',
    apiGatewayCreateApiKey: true,
    apiGatewayExecutionRole,
    apiGatewayProps
};
// Instantiate construct
new lib_1.ApiGatewayToIot(stack, 'test-apigateway-iot', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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