"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomState = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const state_1 = require("./state");
/**
 * State defined by supplying Amazon States Language (ASL) in the state machine.
 *
 */
class CustomState extends state_1.State {
    constructor(scope, id, props) {
        super(scope, id, {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_CustomStateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.endStates = [this];
        this.stateJson = props.stateJson;
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(next);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.next);
            }
            throw error;
        }
        super.makeNext(next.startState);
        return __1.Chain.sequence(this, next);
    }
    /**
     * Returns the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            ...this.renderNextEnd(),
            ...this.stateJson,
        };
    }
}
exports.CustomState = CustomState;
_a = JSII_RTTI_SYMBOL_1;
CustomState[_a] = { fqn: "@aws-cdk/aws-stepfunctions.CustomState", version: "1.156.0" };
//# sourceMappingURL=data:application/json;base64,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