#
# Copyright 2021 Venafi, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

FIELD_OWNERS = 'owners'
FIELD_USERS = 'users'
FIELD_USER_ACCESS = 'userAccess'
FIELD_APPROVERS = 'approvers'

FIELD_POLICY = 'policy'
FIELD_DOMAINS = 'domains'
FIELD_WILDCARD_ALLOWED = 'wildcardAllowed'
FIELD_MAX_VALID_DAYS = 'maxValidDays'
FIELD_CERTIFICATE_AUTHORITY = 'certificateAuthority'
FIELD_AUTOINSTALLED = "autoInstalled"

FIELD_SUBJECT = 'subject'
FIELD_ORGS = 'orgs'
FIELD_ORG_UNITS = 'orgUnits'
FIELD_LOCALITIES = 'localities'
FIELD_STATES = 'states'
FIELD_COUNTRIES = 'countries'

FIELD_KEY_PAIR = 'keyPair'
FIELD_KEY_TYPES = 'keyTypes'
FIELD_RSA_KEY_SIZES = 'rsaKeySizes'
FIELD_ELLIPTIC_CURVES = 'ellipticCurves'
FIELD_SERVICE_GENERATED = 'serviceGenerated'
FIELD_REUSE_ALLOWED = 'reuseAllowed'

FIELD_SUBJECT_ALT_NAMES = 'subjectAltNames'
FIELD_DNS_ALLOWED = 'dnsAllowed'
FIELD_IP_ALLOWED = 'ipAllowed'
FIELD_EMAIL_ALLOWED = 'emailAllowed'
FIELD_URI_ALLOWED = 'uriAllowed'
FIELD_UPN_ALLOWED = 'upnAllowed'
FIELD_URI_PROTOCOLS = 'uriProtocols'
FIELD_IP_CONSTRAINTS = 'ipConstraints'

FIELD_DEFAULTS = 'defaults'
FIELD_DEFAULT_DOMAIN = 'domain'
FIELD_DEFAULT_AUTOINSTALLED = FIELD_AUTOINSTALLED

FIELD_DEFAULT_SUBJECT = 'subject'
FIELD_DEFAULT_ORG = 'org'
FIELD_DEFAULT_ORG_UNITS = 'orgUnits'
FIELD_DEFAULT_LOCALITY = 'locality'
FIELD_DEFAULT_STATE = 'state'
FIELD_DEFAULT_COUNTRY = 'country'

FIELD_DEFAULT_KEY_PAIR = 'keyPair'
FIELD_DEFAULT_KEY_TYPE = 'keyType'
FIELD_DEFAULT_RSA_KEY_SIZE = 'rsaKeySize'
FIELD_DEFAULT_ELLIPTIC_CURVE = 'ellipticCurve'
FIELD_DEFAULT_SERVICE_GENERATED = 'serviceGenerated'
