"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kafka_generated_1 = require("./kafka.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return kafka_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::KAFKA::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::KAFKA::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new kafka_generated_1.RosInstance(this, id, {
            deployType: props.deployType,
            diskType: props.diskType,
            deployOption: props.deployOption,
            eipMax: props.eipMax,
            specType: props.specType,
            ioMax: props.ioMax,
            ioMaxSpec: props.ioMaxSpec,
            diskSize: props.diskSize,
            topicQuota: props.topicQuota,
            payType: props.payType ? props.payType : 'Hour',
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrName = rosInstance.attrName;
        this.attrOrderId = rosInstance.attrOrderId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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