/**
 * The Plaid API
 * The Plaid REST API. Please see https://plaid.com/docs/api for more details.
 *
 * The version of the OpenAPI document: 2020-09-14_1.78.2
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { Configuration } from './configuration';
import { AxiosPromise, AxiosInstance } from 'axios';
import { RequestArgs, BaseAPI } from './base';
/**
 * Specifies the use case of the transfer.  Required for transfers on an ACH network. In Sandbox, only `ccd`, `ppd`, or `web` can be used.  `\"arc\"` - Accounts Receivable Entry  `\"cbr`\" - Cross Border Entry  `\"ccd\"` - Corporate Credit or Debit - fund transfer between two corporate bank accounts  `\"cie\"` - Customer Initiated Entry  `\"cor\"` - Automated Notification of Change  `\"ctx\"` - Corporate Trade Exchange  `\"iat\"` - International  `\"mte\"` - Machine Transfer Entry  `\"pbr\"` - Cross Border Entry  `\"pop\"` - Point-of-Purchase Entry  `\"pos\"` - Point-of-Sale Entry  `\"ppd\"` - Prearranged Payment or Deposit - the transfer is part of a pre-existing relationship with a consumer, eg. bill payment  `\"rck\"` - Re-presented Check Entry  `\"tel\"` - Telephone-Initiated Entry  `\"web\"` - Internet-Initiated Entry - debits from a consumer’s account where their authorization is obtained over the Internet
 * @export
 * @enum {string}
 */
export declare enum ACHClass {
    Arc = "arc",
    Cbr = "cbr",
    Ccd = "ccd",
    Cie = "cie",
    Cor = "cor",
    Ctx = "ctx",
    Iat = "iat",
    Mte = "mte",
    Pbr = "pbr",
    Pop = "pop",
    Pos = "pos",
    Ppd = "ppd",
    Rck = "rck",
    Tel = "tel",
    Web = "web"
}
/**
 * Information about the APR on the account.
 * @export
 * @interface APR
 */
export interface APR {
    [key: string]: object | any;
    /**
     * Annual Percentage Rate applied.
     * @type {number}
     * @memberof APR
     */
    apr_percentage: number;
    /**
     * The type of balance to which the APR applies.
     * @type {string}
     * @memberof APR
     */
    apr_type: APRAprTypeEnum;
    /**
     * Amount of money that is subjected to the APR if a balance was carried beyond payment due date. How it is calculated can vary by card issuer. It is often calculated as an average daily balance.
     * @type {number}
     * @memberof APR
     */
    balance_subject_to_apr: number | null;
    /**
     * Amount of money charged due to interest from last statement.
     * @type {number}
     * @memberof APR
     */
    interest_charge_amount: number | null;
}
/**
    * @export
    * @enum {string}
    */
export declare enum APRAprTypeEnum {
    BalanceTransferApr = "balance_transfer_apr",
    CashApr = "cash_apr",
    PurchaseApr = "purchase_apr",
    Special = "special"
}
/**
 * Allow or disallow product access by account. Unlisted (e.g. missing) accounts will be considered `new_accounts`.
 * @export
 * @interface AccountAccess
 */
export interface AccountAccess {
    /**
     * The unique account identifier for this account. This value must match that returned by the data access API for this account.
     * @type {string}
     * @memberof AccountAccess
     */
    unique_id: string;
    /**
     * Allow the application to see this account (and associated details, including balance) in the list of accounts  If unset, defaults to `true`.
     * @type {boolean}
     * @memberof AccountAccess
     */
    authorized?: boolean | null;
    /**
     *
     * @type {AccountProductAccessNullable}
     * @memberof AccountAccess
     */
    account_product_access?: AccountProductAccessNullable | null;
}
/**
 * Asset information about an account
 * @export
 * @interface AccountAssets
 */
export interface AccountAssets {
    /**
     * Plaid’s unique identifier for the account. This value will not change unless Plaid can\'t reconcile the account with the data returned by the financial institution. This may occur, for example, when the name of the account changes. If this happens a new `account_id` will be assigned to the account.  The `account_id` can also change if the `access_token` is deleted and the same credentials that were used to generate that `access_token` are used to generate a new `access_token` on a later date. In that case, the new `account_id` will be different from the old `account_id`.  If an account with a specific `account_id` disappears instead of changing, the account is likely closed. Closed accounts are not returned by the Plaid API.  Like all Plaid identifiers, the `account_id` is case sensitive.
     * @type {string}
     * @memberof AccountAssets
     */
    account_id: string;
    /**
     *
     * @type {AccountBalance}
     * @memberof AccountAssets
     */
    balances: AccountBalance;
    /**
     * The last 2-4 alphanumeric characters of an account\'s official account number. Note that the mask may be non-unique between an Item\'s accounts, and it may also not match the mask that the bank displays to the user.
     * @type {string}
     * @memberof AccountAssets
     */
    mask: string | null;
    /**
     * The name of the account, either assigned by the user or by the financial institution itself
     * @type {string}
     * @memberof AccountAssets
     */
    name: string;
    /**
     * The official name of the account as given by the financial institution
     * @type {string}
     * @memberof AccountAssets
     */
    official_name: string | null;
    /**
     *
     * @type {AccountType}
     * @memberof AccountAssets
     */
    type: AccountType;
    /**
     *
     * @type {AccountSubtype}
     * @memberof AccountAssets
     */
    subtype: AccountSubtype | null;
    /**
     * The current verification status of an Auth Item initiated through Automated or Manual micro-deposits.  Returned for Auth Items only.  `pending_automatic_verification`: The Item is pending automatic verification  `pending_manual_verification`: The Item is pending manual micro-deposit verification. Items remain in this state until the user successfully verifies the two amounts.  `automatically_verified`: The Item has successfully been automatically verified   `manually_verified`: The Item has successfully been manually verified  `verification_expired`: Plaid was unable to automatically verify the deposit within 7 calendar days and will no longer attempt to validate the Item. Users may retry by submitting their information again through Link.  `verification_failed`: The Item failed manual micro-deposit verification because the user exhausted all 3 verification attempts. Users may retry by submitting their information again through Link.
     * @type {string}
     * @memberof AccountAssets
     */
    verification_status?: AccountAssetsVerificationStatusEnum;
    /**
     * The duration of transaction history available for this Item, typically defined as the time since the date of the earliest transaction in that account. Only returned by Assets endpoints.
     * @type {number}
     * @memberof AccountAssets
     */
    days_available: number;
    /**
     * Transaction history associated with the account. Only returned by Assets endpoints. Transaction history returned by endpoints such as `/transactions/get` or `/investments/transactions/get` will be returned in the top-level `transactions` field instead.
     * @type {Array<AssetReportTransaction>}
     * @memberof AccountAssets
     */
    transactions: Array<AssetReportTransaction>;
    /**
     * Data returned by the financial institution about the account owner or owners. Only returned by Identity or Assets endpoints. For business accounts, the name reported may be either the name of the individual or the name of the business, depending on the institution. Multiple owners on a single account will be represented in the same `owner` object, not in multiple owner objects within the array. In API versions 2018-05-22 and earlier, the `owners` object is not returned, and instead identity information is returned in the top level `identity` object. For more details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2019-05-29)
     * @type {Array<Owner>}
     * @memberof AccountAssets
     */
    owners: Array<Owner>;
    /**
     * Calculated data about the historical balances on the account. Only returned by Assets endpoints and currently not supported by `brokerage` or `investment` accounts.
     * @type {Array<HistoricalBalance>}
     * @memberof AccountAssets
     */
    historical_balances: Array<HistoricalBalance>;
}
/**
    * @export
    * @enum {string}
    */
export declare enum AccountAssetsVerificationStatusEnum {
    AutomaticallyVerified = "automatically_verified",
    PendingAutomaticVerification = "pending_automatic_verification",
    PendingManualVerification = "pending_manual_verification",
    ManuallyVerified = "manually_verified",
    VerificationExpired = "verification_expired",
    VerificationFailed = "verification_failed"
}
/**
 *
 * @export
 * @interface AccountAssetsAllOf
 */
export interface AccountAssetsAllOf {
    /**
     * The duration of transaction history available for this Item, typically defined as the time since the date of the earliest transaction in that account. Only returned by Assets endpoints.
     * @type {number}
     * @memberof AccountAssetsAllOf
     */
    days_available: number;
    /**
     * Transaction history associated with the account. Only returned by Assets endpoints. Transaction history returned by endpoints such as `/transactions/get` or `/investments/transactions/get` will be returned in the top-level `transactions` field instead.
     * @type {Array<AssetReportTransaction>}
     * @memberof AccountAssetsAllOf
     */
    transactions: Array<AssetReportTransaction>;
    /**
     * Data returned by the financial institution about the account owner or owners. Only returned by Identity or Assets endpoints. For business accounts, the name reported may be either the name of the individual or the name of the business, depending on the institution. Multiple owners on a single account will be represented in the same `owner` object, not in multiple owner objects within the array. In API versions 2018-05-22 and earlier, the `owners` object is not returned, and instead identity information is returned in the top level `identity` object. For more details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2019-05-29)
     * @type {Array<Owner>}
     * @memberof AccountAssetsAllOf
     */
    owners: Array<Owner>;
    /**
     * Calculated data about the historical balances on the account. Only returned by Assets endpoints and currently not supported by `brokerage` or `investment` accounts.
     * @type {Array<HistoricalBalance>}
     * @memberof AccountAssetsAllOf
     */
    historical_balances: Array<HistoricalBalance>;
}
/**
 * A set of fields describing the balance for an account. Balance information may be cached unless the balance object was returned by `/accounts/balance/get`.
 * @export
 * @interface AccountBalance
 */
export interface AccountBalance {
    [key: string]: object | any;
    /**
     * The amount of funds available to be withdrawn from the account, as determined by the financial institution.  For `credit`-type accounts, the `available` balance typically equals the `limit` less the `current` balance, less any pending outflows plus any pending inflows.  For `depository`-type accounts, the `available` balance typically equals the `current` balance less any pending outflows plus any pending inflows. For `depository`-type accounts, the `available` balance does not include the overdraft limit.  For `investment`-type accounts (or `brokerage`-type accounts for API versions 2018-05-22 and earlier), the `available` balance is the total cash available to withdraw as presented by the institution.  Note that not all institutions calculate the `available`  balance. In the event that `available` balance is unavailable, Plaid will return an `available` balance value of `null`.  Available balance may be cached and is not guaranteed to be up-to-date in realtime unless the value was returned by `/accounts/balance/get`.  If `current` is `null` this field is guaranteed not to be `null`.
     * @type {number}
     * @memberof AccountBalance
     */
    available: number | null;
    /**
     * The total amount of funds in or owed by the account.  For `credit`-type accounts, a positive balance indicates the amount owed; a negative amount indicates the lender owing the account holder.  For `loan`-type accounts, the current balance is the principal remaining on the loan, except in the case of student loan accounts at Sallie Mae (`ins_116944`). For Sallie Mae student loans, the account\'s balance includes both principal and any outstanding interest.  For `investment`-type accounts (or `brokerage`-type accounts for API versions 2018-05-22 and earlier), the current balance is the total value of assets as presented by the institution.  Note that balance information may be cached unless the value was returned by `/accounts/balance/get`; if the Item is enabled for Transactions, the balance will be at least as recent as the most recent Transaction update. If you require realtime balance information, use the `available` balance as provided by `/accounts/balance/get`.  When returned by `/accounts/balance/get`, this field may be `null`. When this happens, `available` is guaranteed not to be `null`.
     * @type {number}
     * @memberof AccountBalance
     */
    current: number | null;
    /**
     * For `credit`-type accounts, this represents the credit limit.  For `depository`-type accounts, this represents the pre-arranged overdraft limit, which is common for current (checking) accounts in Europe.  In North America, this field is typically only available for `credit`-type accounts.
     * @type {number}
     * @memberof AccountBalance
     */
    limit: number | null;
    /**
     * The ISO-4217 currency code of the balance. Always null if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof AccountBalance
     */
    iso_currency_code: string | null;
    /**
     * The unofficial currency code associated with the balance. Always null if `iso_currency_code` is non-null. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `unofficial_currency_code`s.
     * @type {string}
     * @memberof AccountBalance
     */
    unofficial_currency_code: string | null;
    /**
     * Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the last time that the balance for the given account has been updated  This is currently only provided when the `min_last_updated_datetime` is passed when calling `/accounts/balance/get` for `ins_128026` (Capital One).
     * @type {string}
     * @memberof AccountBalance
     */
    last_updated_datetime?: string | null;
}
/**
 * A single account at a financial institution.
 * @export
 * @interface AccountBase
 */
export interface AccountBase {
    [key: string]: object | any;
    /**
     * Plaid’s unique identifier for the account. This value will not change unless Plaid can\'t reconcile the account with the data returned by the financial institution. This may occur, for example, when the name of the account changes. If this happens a new `account_id` will be assigned to the account.  The `account_id` can also change if the `access_token` is deleted and the same credentials that were used to generate that `access_token` are used to generate a new `access_token` on a later date. In that case, the new `account_id` will be different from the old `account_id`.  If an account with a specific `account_id` disappears instead of changing, the account is likely closed. Closed accounts are not returned by the Plaid API.  Like all Plaid identifiers, the `account_id` is case sensitive.
     * @type {string}
     * @memberof AccountBase
     */
    account_id: string;
    /**
     *
     * @type {AccountBalance}
     * @memberof AccountBase
     */
    balances: AccountBalance;
    /**
     * The last 2-4 alphanumeric characters of an account\'s official account number. Note that the mask may be non-unique between an Item\'s accounts, and it may also not match the mask that the bank displays to the user.
     * @type {string}
     * @memberof AccountBase
     */
    mask: string | null;
    /**
     * The name of the account, either assigned by the user or by the financial institution itself
     * @type {string}
     * @memberof AccountBase
     */
    name: string;
    /**
     * The official name of the account as given by the financial institution
     * @type {string}
     * @memberof AccountBase
     */
    official_name: string | null;
    /**
     *
     * @type {AccountType}
     * @memberof AccountBase
     */
    type: AccountType;
    /**
     *
     * @type {AccountSubtype}
     * @memberof AccountBase
     */
    subtype: AccountSubtype | null;
    /**
     * The current verification status of an Auth Item initiated through Automated or Manual micro-deposits.  Returned for Auth Items only.  `pending_automatic_verification`: The Item is pending automatic verification  `pending_manual_verification`: The Item is pending manual micro-deposit verification. Items remain in this state until the user successfully verifies the two amounts.  `automatically_verified`: The Item has successfully been automatically verified   `manually_verified`: The Item has successfully been manually verified  `verification_expired`: Plaid was unable to automatically verify the deposit within 7 calendar days and will no longer attempt to validate the Item. Users may retry by submitting their information again through Link.  `verification_failed`: The Item failed manual micro-deposit verification because the user exhausted all 3 verification attempts. Users may retry by submitting their information again through Link.
     * @type {string}
     * @memberof AccountBase
     */
    verification_status?: AccountBaseVerificationStatusEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum AccountBaseVerificationStatusEnum {
    AutomaticallyVerified = "automatically_verified",
    PendingAutomaticVerification = "pending_automatic_verification",
    PendingManualVerification = "pending_manual_verification",
    ManuallyVerified = "manually_verified",
    VerificationExpired = "verification_expired",
    VerificationFailed = "verification_failed"
}
/**
 * Enumerates the account subtypes that the application wishes for the user to be able to select from. For more details refer to Plaid documentation on account filters.
 * @export
 * @interface AccountFilter
 */
export interface AccountFilter {
    /**
     * A list of account subtypes to be filtered.
     * @type {Array<string>}
     * @memberof AccountFilter
     */
    depository?: Array<string>;
    /**
     * A list of account subtypes to be filtered.
     * @type {Array<string>}
     * @memberof AccountFilter
     */
    credit?: Array<string>;
    /**
     * A list of account subtypes to be filtered.
     * @type {Array<string>}
     * @memberof AccountFilter
     */
    loan?: Array<string>;
    /**
     * A list of account subtypes to be filtered.
     * @type {Array<string>}
     * @memberof AccountFilter
     */
    investment?: Array<string>;
}
/**
 * The `account_filters` specified in the original call to `/link/token/create`.
 * @export
 * @interface AccountFiltersResponse
 */
export interface AccountFiltersResponse {
    [key: string]: object | any;
    /**
     *
     * @type {DepositoryFilter}
     * @memberof AccountFiltersResponse
     */
    depository?: DepositoryFilter;
    /**
     *
     * @type {CreditFilter}
     * @memberof AccountFiltersResponse
     */
    credit?: CreditFilter;
    /**
     *
     * @type {LoanFilter}
     * @memberof AccountFiltersResponse
     */
    loan?: LoanFilter;
    /**
     *
     * @type {InvestmentFilter}
     * @memberof AccountFiltersResponse
     */
    investment?: InvestmentFilter;
}
/**
 * Identity information about an account
 * @export
 * @interface AccountIdentity
 */
export interface AccountIdentity {
    /**
     * Plaid’s unique identifier for the account. This value will not change unless Plaid can\'t reconcile the account with the data returned by the financial institution. This may occur, for example, when the name of the account changes. If this happens a new `account_id` will be assigned to the account.  The `account_id` can also change if the `access_token` is deleted and the same credentials that were used to generate that `access_token` are used to generate a new `access_token` on a later date. In that case, the new `account_id` will be different from the old `account_id`.  If an account with a specific `account_id` disappears instead of changing, the account is likely closed. Closed accounts are not returned by the Plaid API.  Like all Plaid identifiers, the `account_id` is case sensitive.
     * @type {string}
     * @memberof AccountIdentity
     */
    account_id: string;
    /**
     *
     * @type {AccountBalance}
     * @memberof AccountIdentity
     */
    balances: AccountBalance;
    /**
     * The last 2-4 alphanumeric characters of an account\'s official account number. Note that the mask may be non-unique between an Item\'s accounts, and it may also not match the mask that the bank displays to the user.
     * @type {string}
     * @memberof AccountIdentity
     */
    mask: string | null;
    /**
     * The name of the account, either assigned by the user or by the financial institution itself
     * @type {string}
     * @memberof AccountIdentity
     */
    name: string;
    /**
     * The official name of the account as given by the financial institution
     * @type {string}
     * @memberof AccountIdentity
     */
    official_name: string | null;
    /**
     *
     * @type {AccountType}
     * @memberof AccountIdentity
     */
    type: AccountType;
    /**
     *
     * @type {AccountSubtype}
     * @memberof AccountIdentity
     */
    subtype: AccountSubtype | null;
    /**
     * The current verification status of an Auth Item initiated through Automated or Manual micro-deposits.  Returned for Auth Items only.  `pending_automatic_verification`: The Item is pending automatic verification  `pending_manual_verification`: The Item is pending manual micro-deposit verification. Items remain in this state until the user successfully verifies the two amounts.  `automatically_verified`: The Item has successfully been automatically verified   `manually_verified`: The Item has successfully been manually verified  `verification_expired`: Plaid was unable to automatically verify the deposit within 7 calendar days and will no longer attempt to validate the Item. Users may retry by submitting their information again through Link.  `verification_failed`: The Item failed manual micro-deposit verification because the user exhausted all 3 verification attempts. Users may retry by submitting their information again through Link.
     * @type {string}
     * @memberof AccountIdentity
     */
    verification_status?: AccountIdentityVerificationStatusEnum;
    /**
     * Data returned by the financial institution about the account owner or owners. Only returned by Identity or Assets endpoints. For business accounts, the name reported may be either the name of the individual or the name of the business, depending on the institution. Multiple owners on a single account will be represented in the same `owner` object, not in multiple owner objects within the array. In API versions 2018-05-22 and earlier, the `owners` object is not returned, and instead identity information is returned in the top level `identity` object. For more details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2019-05-29)
     * @type {Array<Owner>}
     * @memberof AccountIdentity
     */
    owners: Array<Owner>;
}
/**
    * @export
    * @enum {string}
    */
export declare enum AccountIdentityVerificationStatusEnum {
    AutomaticallyVerified = "automatically_verified",
    PendingAutomaticVerification = "pending_automatic_verification",
    PendingManualVerification = "pending_manual_verification",
    ManuallyVerified = "manually_verified",
    VerificationExpired = "verification_expired",
    VerificationFailed = "verification_failed"
}
/**
 *
 * @export
 * @interface AccountIdentityAllOf
 */
export interface AccountIdentityAllOf {
    /**
     * Data returned by the financial institution about the account owner or owners. Only returned by Identity or Assets endpoints. For business accounts, the name reported may be either the name of the individual or the name of the business, depending on the institution. Multiple owners on a single account will be represented in the same `owner` object, not in multiple owner objects within the array. In API versions 2018-05-22 and earlier, the `owners` object is not returned, and instead identity information is returned in the top level `identity` object. For more details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2019-05-29)
     * @type {Array<Owner>}
     * @memberof AccountIdentityAllOf
     */
    owners: Array<Owner>;
}
/**
 * Allow the application to access specific products on this account
 * @export
 * @interface AccountProductAccess
 */
export interface AccountProductAccess {
    /**
     * Allow the application to access account data. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof AccountProductAccess
     */
    account_data?: boolean | null;
    /**
     * Allow the application to access bank statements. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof AccountProductAccess
     */
    statements?: boolean | null;
    /**
     * Allow the application to access tax documents. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof AccountProductAccess
     */
    tax_documents?: boolean | null;
}
/**
 * Allow the application to access specific products on this account
 * @export
 * @interface AccountProductAccessNullable
 */
export interface AccountProductAccessNullable {
    /**
     * Allow the application to access account data. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof AccountProductAccessNullable
     */
    account_data?: boolean | null;
    /**
     * Allow the application to access bank statements. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof AccountProductAccessNullable
     */
    statements?: boolean | null;
    /**
     * Allow the application to access tax documents. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof AccountProductAccessNullable
     */
    tax_documents?: boolean | null;
}
/**
 * The application requires that accounts be limited to a specific cardinality. `MULTI_SELECT`: indicates that the user should be allowed to pick multiple accounts. `SINGLE_SELECT`: indicates that the user should be allowed to pick only a single account. `ALL`: indicates that the user must share all of their accounts and should not be given the opportunity to de-select
 * @export
 * @enum {string}
 */
export declare enum AccountSelectionCardinality {
    SingleSelect = "SINGLE_SELECT",
    MultiSelect = "MULTI_SELECT",
    All = "ALL"
}
/**
 * See the [Account type schema](https://plaid.com/docs/api/accounts/#account-type-schema) for a full listing of account types and corresponding subtypes.
 * @export
 * @enum {string}
 */
export declare enum AccountSubtype {
    _401a = "401a",
    _401k = "401k",
    _403B = "403B",
    _457b = "457b",
    _529 = "529",
    Brokerage = "brokerage",
    CashIsa = "cash isa",
    EducationSavingsAccount = "education savings account",
    Ebt = "ebt",
    FixedAnnuity = "fixed annuity",
    Gic = "gic",
    HealthReimbursementArrangement = "health reimbursement arrangement",
    Hsa = "hsa",
    Isa = "isa",
    Ira = "ira",
    Lif = "lif",
    LifeInsurance = "life insurance",
    Lira = "lira",
    Lrif = "lrif",
    Lrsp = "lrsp",
    NonTaxableBrokerageAccount = "non-taxable brokerage account",
    Other = "other",
    OtherInsurance = "other insurance",
    OtherAnnuity = "other annuity",
    Prif = "prif",
    Rdsp = "rdsp",
    Resp = "resp",
    Rlif = "rlif",
    Rrif = "rrif",
    Pension = "pension",
    ProfitSharingPlan = "profit sharing plan",
    Retirement = "retirement",
    Roth = "roth",
    Roth401k = "roth 401k",
    Rrsp = "rrsp",
    SepIra = "sep ira",
    SimpleIra = "simple ira",
    Sipp = "sipp",
    StockPlan = "stock plan",
    ThriftSavingsPlan = "thrift savings plan",
    Tfsa = "tfsa",
    Trust = "trust",
    Ugma = "ugma",
    Utma = "utma",
    VariableAnnuity = "variable annuity",
    CreditCard = "credit card",
    Paypal = "paypal",
    Cd = "cd",
    Checking = "checking",
    Savings = "savings",
    MoneyMarket = "money market",
    Prepaid = "prepaid",
    Auto = "auto",
    Business = "business",
    Commercial = "commercial",
    Construction = "construction",
    Consumer = "consumer",
    HomeEquity = "home equity",
    Loan = "loan",
    Mortgage = "mortgage",
    Overdraft = "overdraft",
    LineOfCredit = "line of credit",
    Student = "student",
    CashManagement = "cash management",
    Keogh = "keogh",
    MutualFund = "mutual fund",
    Recurring = "recurring",
    Rewards = "rewards",
    SafeDeposit = "safe deposit",
    Sarsep = "sarsep",
    Payroll = "payroll",
    Null = "null"
}
/**
 * `investment:` Investment account. In API versions 2018-05-22 and earlier, this type is called `brokerage` instead.  `credit:` Credit card  `depository:` Depository account  `loan:` Loan account  `brokerage`: An investment account. Used for `/assets/` endpoints only; other endpoints use `investment`.  `other:` Non-specified account type  See the [Account type schema](https://plaid.com/docs/api/accounts#account-type-schema) for a full listing of account types and corresponding subtypes.
 * @export
 * @enum {string}
 */
export declare enum AccountType {
    Investment = "investment",
    Credit = "credit",
    Depository = "depository",
    Loan = "loan",
    Brokerage = "brokerage",
    Other = "other"
}
/**
 * AccountsBalanceGetRequest defines the request schema for `/accounts/balance/get`
 * @export
 * @interface AccountsBalanceGetRequest
 */
export interface AccountsBalanceGetRequest {
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof AccountsBalanceGetRequest
     */
    access_token: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AccountsBalanceGetRequest
     */
    secret?: string;
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AccountsBalanceGetRequest
     */
    client_id?: string;
    /**
     *
     * @type {AccountsBalanceGetRequestOptions}
     * @memberof AccountsBalanceGetRequest
     */
    options?: AccountsBalanceGetRequestOptions;
}
/**
 * An optional object to filter `/accounts/balance/get` results.
 * @export
 * @interface AccountsBalanceGetRequestOptions
 */
export interface AccountsBalanceGetRequestOptions {
    /**
     * A list of `account_ids` to retrieve for the Item. The default value is `null`.  Note: An error will be returned if a provided `account_id` is not associated with the Item.
     * @type {Array<string>}
     * @memberof AccountsBalanceGetRequestOptions
     */
    account_ids?: Array<string>;
    /**
     * Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the oldest acceptable balance when making a request to `/accounts/balance/get`.  If the balance that is pulled for `ins_128026` (Capital One) is older than the given timestamp, an `INVALID_REQUEST` error with the code of `LAST_UPDATED_DATETIME_OUT_OF_RANGE` will be returned with the most recent timestamp for the requested account contained in the response.  This field is only used when the institution is `ins_128026` (Capital One), in which case a value must be provided or an `INVALID_REQUEST` error with the code of `INVALID_FIELD` will be returned. For all other institutions, this field is ignored.
     * @type {string}
     * @memberof AccountsBalanceGetRequestOptions
     */
    min_last_updated_datetime?: string;
}
/**
 * AccountsGetRequest defines the request schema for `/accounts/get`
 * @export
 * @interface AccountsGetRequest
 */
export interface AccountsGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AccountsGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AccountsGetRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof AccountsGetRequest
     */
    access_token: string;
    /**
     *
     * @type {AccountsGetRequestOptions}
     * @memberof AccountsGetRequest
     */
    options?: AccountsGetRequestOptions;
}
/**
 * An optional object to filter `/accounts/get` results.
 * @export
 * @interface AccountsGetRequestOptions
 */
export interface AccountsGetRequestOptions {
    /**
     * An array of `account_ids` to retrieve for the Account.
     * @type {Array<string>}
     * @memberof AccountsGetRequestOptions
     */
    account_ids?: Array<string>;
}
/**
 * AccountsGetResponse defines the response schema for `/accounts/get` and `/accounts/balance/get`.
 * @export
 * @interface AccountsGetResponse
 */
export interface AccountsGetResponse {
    [key: string]: object | any;
    /**
     * An array of financial institution accounts associated with the Item. If `/accounts/balance/get` was called, each account will include real-time balance information.
     * @type {Array<AccountBase>}
     * @memberof AccountsGetResponse
     */
    accounts: Array<AccountBase>;
    /**
     *
     * @type {Item}
     * @memberof AccountsGetResponse
     */
    item: Item;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AccountsGetResponse
     */
    request_id: string;
}
/**
 * A physical mailing address.
 * @export
 * @interface Address
 */
export interface Address {
    [key: string]: object | any;
    /**
     *
     * @type {AddressData}
     * @memberof Address
     */
    data: AddressData;
    /**
     * When `true`, identifies the address as the primary address on an account.
     * @type {boolean}
     * @memberof Address
     */
    primary?: boolean;
}
/**
 * Data about the components comprising an address.
 * @export
 * @interface AddressData
 */
export interface AddressData {
    [key: string]: object | any;
    /**
     * The full city name
     * @type {string}
     * @memberof AddressData
     */
    city: string;
    /**
     * The region or state. In API versions 2018-05-22 and earlier, this field is called `state`. Example: `\"NC\"`
     * @type {string}
     * @memberof AddressData
     */
    region: string | null;
    /**
     * The full street address Example: `\"564 Main Street, APT 15\"`
     * @type {string}
     * @memberof AddressData
     */
    street: string;
    /**
     * The postal code. In API versions 2018-05-22 and earlier, this field is called `zip`.
     * @type {string}
     * @memberof AddressData
     */
    postal_code: string | null;
    /**
     * The ISO 3166-1 alpha-2 country code
     * @type {string}
     * @memberof AddressData
     */
    country: string | null;
}
/**
 * Data about the components comprising an address.
 * @export
 * @interface AddressDataNullable
 */
export interface AddressDataNullable {
    /**
     * The full city name
     * @type {string}
     * @memberof AddressDataNullable
     */
    city: string;
    /**
     * The region or state. In API versions 2018-05-22 and earlier, this field is called `state`. Example: `\"NC\"`
     * @type {string}
     * @memberof AddressDataNullable
     */
    region: string | null;
    /**
     * The full street address Example: `\"564 Main Street, APT 15\"`
     * @type {string}
     * @memberof AddressDataNullable
     */
    street: string;
    /**
     * The postal code. In API versions 2018-05-22 and earlier, this field is called `zip`.
     * @type {string}
     * @memberof AddressDataNullable
     */
    postal_code: string | null;
    /**
     * The ISO 3166-1 alpha-2 country code
     * @type {string}
     * @memberof AddressDataNullable
     */
    country: string | null;
}
/**
 * A physical mailing address.
 * @export
 * @interface AddressNullable
 */
export interface AddressNullable {
    /**
     *
     * @type {AddressData}
     * @memberof AddressNullable
     */
    data: AddressData;
    /**
     * When `true`, identifies the address as the primary address on an account.
     * @type {boolean}
     * @memberof AddressNullable
     */
    primary?: boolean;
}
/**
 * Metadata about the application
 * @export
 * @interface Application
 */
export interface Application {
    /**
     * This field will map to the application ID that is returned from /item/applications/list, or provided to the institution in an oauth redirect.
     * @type {string}
     * @memberof Application
     */
    application_id: string;
    /**
     * The name of the application
     * @type {string}
     * @memberof Application
     */
    name: string;
    /**
     * The date this application was linked in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format in UTC.
     * @type {string}
     * @memberof Application
     * @deprecated
     */
    created_at?: string;
    /**
     * The date this application was granted production access at Plaid in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format in UTC.
     * @type {string}
     * @memberof Application
     */
    join_date: string;
    /**
     * A URL that links to the application logo image.
     * @type {string}
     * @memberof Application
     */
    logo_url: string | null;
    /**
     * The URL for the application\'s website
     * @type {string}
     * @memberof Application
     */
    application_url: string | null;
    /**
     * A string provided by the connected app stating why they use their respective enabled products.
     * @type {string}
     * @memberof Application
     */
    reason_for_access: string | null;
}
/**
 * ApplicationGetRequest defines the schema for `/application/get`
 * @export
 * @interface ApplicationGetRequest
 */
export interface ApplicationGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ApplicationGetRequest
     */
    client_id: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ApplicationGetRequest
     */
    secret: string;
    /**
     * This field will map to the application ID that is returned from /item/applications/list, or provided to the institution in an oauth redirect.
     * @type {string}
     * @memberof ApplicationGetRequest
     */
    application_id: string;
}
/**
 * ApplicationGetResponse defines the response schema for `/application/get`
 * @export
 * @interface ApplicationGetResponse
 */
export interface ApplicationGetResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ApplicationGetResponse
     */
    request_id: string;
    /**
     *
     * @type {Application}
     * @memberof ApplicationGetResponse
     */
    application: Application;
}
/**
 * An object representing an Asset Report
 * @export
 * @interface AssetReport
 */
export interface AssetReport {
    [key: string]: object | any;
    /**
     * A unique ID identifying an Asset Report. Like all Plaid identifiers, this ID is case sensitive.
     * @type {string}
     * @memberof AssetReport
     */
    asset_report_id: string;
    /**
     * An identifier you determine and submit for the Asset Report.
     * @type {string}
     * @memberof AssetReport
     */
    client_report_id: string | null;
    /**
     * The date and time when the Asset Report was created, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (e.g. \"2018-04-12T03:32:11Z\").
     * @type {string}
     * @memberof AssetReport
     */
    date_generated: string;
    /**
     * The duration of transaction history you requested
     * @type {number}
     * @memberof AssetReport
     */
    days_requested: number;
    /**
     *
     * @type {AssetReportUser}
     * @memberof AssetReport
     */
    user: AssetReportUser;
    /**
     * Data returned by Plaid about each of the Items included in the Asset Report.
     * @type {Array<AssetReportItem>}
     * @memberof AssetReport
     */
    items: Array<AssetReportItem>;
}
/**
 * AssetReportAuditCopyCreateRequest defines the request schema for `/asset_report/audit_copy/get`
 * @export
 * @interface AssetReportAuditCopyCreateRequest
 */
export interface AssetReportAuditCopyCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportAuditCopyCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportAuditCopyCreateRequest
     */
    secret?: string;
    /**
     * A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.
     * @type {string}
     * @memberof AssetReportAuditCopyCreateRequest
     */
    asset_report_token: string;
    /**
     * The `auditor_id` of the third party with whom you would like to share the Asset Report.
     * @type {string}
     * @memberof AssetReportAuditCopyCreateRequest
     */
    auditor_id: string;
}
/**
 * AssetReportAuditCopyCreateResponse defines the response schema for `/asset_report/audit_copy/get`
 * @export
 * @interface AssetReportAuditCopyCreateResponse
 */
export interface AssetReportAuditCopyCreateResponse {
    [key: string]: object | any;
    /**
     * A token that can be shared with a third party auditor to allow them to obtain access to the Asset Report. This token should be stored securely.
     * @type {string}
     * @memberof AssetReportAuditCopyCreateResponse
     */
    audit_copy_token: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AssetReportAuditCopyCreateResponse
     */
    request_id: string;
}
/**
 * AssetReportAuditCopyGetRequest defines the request schema for `/asset_report/audit_copy/get`
 * @export
 * @interface AssetReportAuditCopyGetRequest
 */
export interface AssetReportAuditCopyGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportAuditCopyGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportAuditCopyGetRequest
     */
    secret?: string;
    /**
     * The `audit_copy_token` granting access to the Audit Copy you would like to get.
     * @type {string}
     * @memberof AssetReportAuditCopyGetRequest
     */
    audit_copy_token: string;
}
/**
 * AssetReportAuditCopyRemoveRequest defines the request schema for `/asset_report/audit_copy/remove`
 * @export
 * @interface AssetReportAuditCopyRemoveRequest
 */
export interface AssetReportAuditCopyRemoveRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportAuditCopyRemoveRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportAuditCopyRemoveRequest
     */
    secret?: string;
    /**
     * The `audit_copy_token` granting access to the Audit Copy you would like to revoke.
     * @type {string}
     * @memberof AssetReportAuditCopyRemoveRequest
     */
    audit_copy_token: string;
}
/**
 * AssetReportAuditCopyRemoveResponse defines the response schema for `/asset_report/audit_copy/remove`
 * @export
 * @interface AssetReportAuditCopyRemoveResponse
 */
export interface AssetReportAuditCopyRemoveResponse {
    [key: string]: object | any;
    /**
     * `true` if the Audit Copy was successfully removed.
     * @type {boolean}
     * @memberof AssetReportAuditCopyRemoveResponse
     */
    removed: boolean;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AssetReportAuditCopyRemoveResponse
     */
    request_id: string;
}
/**
 * AssetReportCreateRequest defines the request schema for `/asset_report/create`
 * @export
 * @interface AssetReportCreateRequest
 */
export interface AssetReportCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportCreateRequest
     */
    secret?: string;
    /**
     * An array of access tokens corresponding to the Items that will be included in the report. The `assets` product must have been initialized for the Items during link; the Assets product cannot be added after initialization.
     * @type {Array<string>}
     * @memberof AssetReportCreateRequest
     */
    access_tokens: Array<string>;
    /**
     * The maximum integer number of days of history to include in the Asset Report. If using Fannie Mae Day 1 Certainty, `days_requested` must be at least 61 for new originations or at least 31 for refinancings.
     * @type {number}
     * @memberof AssetReportCreateRequest
     */
    days_requested: number;
    /**
     *
     * @type {AssetReportCreateRequestOptions}
     * @memberof AssetReportCreateRequest
     */
    options?: AssetReportCreateRequestOptions;
}
/**
 * An optional object to filter `/asset_report/create` results. If provided, must be non-`null`. The optional `user` object is required for the report to be eligible for Fannie Mae\'s Day 1 Certainty program.
 * @export
 * @interface AssetReportCreateRequestOptions
 */
export interface AssetReportCreateRequestOptions {
    /**
     * Client-generated identifier, which can be used by lenders to track loan applications.
     * @type {string}
     * @memberof AssetReportCreateRequestOptions
     */
    client_report_id?: string | null;
    /**
     * URL to which Plaid will send Assets webhooks, for example when the requested Asset Report is ready.
     * @type {string}
     * @memberof AssetReportCreateRequestOptions
     */
    webhook?: string | null;
    /**
     *
     * @type {AssetReportUser}
     * @memberof AssetReportCreateRequestOptions
     */
    user?: AssetReportUser;
}
/**
 * AssetReportCreateResponse defines the response schema for `/asset_report/create`
 * @export
 * @interface AssetReportCreateResponse
 */
export interface AssetReportCreateResponse {
    [key: string]: object | any;
    /**
     * A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.
     * @type {string}
     * @memberof AssetReportCreateResponse
     */
    asset_report_token: string;
    /**
     * A unique ID identifying an Asset Report. Like all Plaid identifiers, this ID is case sensitive.
     * @type {string}
     * @memberof AssetReportCreateResponse
     */
    asset_report_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AssetReportCreateResponse
     */
    request_id: string;
}
/**
 * AssetReportFilterRequest defines the request schema for `/asset_report/filter`
 * @export
 * @interface AssetReportFilterRequest
 */
export interface AssetReportFilterRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportFilterRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportFilterRequest
     */
    secret?: string;
    /**
     * A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.
     * @type {string}
     * @memberof AssetReportFilterRequest
     */
    asset_report_token: string;
    /**
     * The accounts to exclude from the Asset Report, identified by `account_id`.
     * @type {Array<string>}
     * @memberof AssetReportFilterRequest
     */
    account_ids_to_exclude: Array<string>;
}
/**
 * AssetReportFilterResponse defines the response schema for `/asset_report/filter`
 * @export
 * @interface AssetReportFilterResponse
 */
export interface AssetReportFilterResponse {
    [key: string]: object | any;
    /**
     * A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.
     * @type {string}
     * @memberof AssetReportFilterResponse
     */
    asset_report_token: string;
    /**
     * A unique ID identifying an Asset Report. Like all Plaid identifiers, this ID is case sensitive.
     * @type {string}
     * @memberof AssetReportFilterResponse
     */
    asset_report_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AssetReportFilterResponse
     */
    request_id: string;
}
/**
 * AssetReportGetRequest defines the request schema for `/asset_report/get`
 * @export
 * @interface AssetReportGetRequest
 */
export interface AssetReportGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportGetRequest
     */
    secret?: string;
    /**
     * A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.
     * @type {string}
     * @memberof AssetReportGetRequest
     */
    asset_report_token: string;
    /**
     * `true` if you would like to retrieve the Asset Report with Insights, `false` otherwise. This field defaults to `false` if omitted.
     * @type {boolean}
     * @memberof AssetReportGetRequest
     */
    include_insights?: boolean;
}
/**
 * AssetReportGetResponse defines the response schema for `/asset_report/get`
 * @export
 * @interface AssetReportGetResponse
 */
export interface AssetReportGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {AssetReport}
     * @memberof AssetReportGetResponse
     */
    report: AssetReport;
    /**
     * If the Asset Report generation was successful but identity information cannot be returned, this array will contain information about the errors causing identity information to be missing
     * @type {Array<Warning>}
     * @memberof AssetReportGetResponse
     */
    warnings: Array<Warning>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AssetReportGetResponse
     */
    request_id: string;
}
/**
 * A representation of an Item within an Asset Report.
 * @export
 * @interface AssetReportItem
 */
export interface AssetReportItem {
    [key: string]: object | any;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof AssetReportItem
     */
    item_id: string;
    /**
     * The full financial institution name associated with the Item.
     * @type {string}
     * @memberof AssetReportItem
     */
    institution_name: string;
    /**
     * The id of the financial institution associated with the Item.
     * @type {string}
     * @memberof AssetReportItem
     */
    institution_id: string;
    /**
     * The date and time when this Item’s data was last retrieved from the financial institution, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.
     * @type {string}
     * @memberof AssetReportItem
     */
    date_last_updated: string;
    /**
     * Data about each of the accounts open on the Item.
     * @type {Array<AccountAssets>}
     * @memberof AssetReportItem
     */
    accounts: Array<AccountAssets>;
}
/**
 * AssetReportPDFGetRequest defines the request schema for `/asset_report/pdf/get`
 * @export
 * @interface AssetReportPDFGetRequest
 */
export interface AssetReportPDFGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportPDFGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportPDFGetRequest
     */
    secret?: string;
    /**
     * A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.
     * @type {string}
     * @memberof AssetReportPDFGetRequest
     */
    asset_report_token: string;
}
/**
 * AssetReportRefreshRequest defines the request schema for `/asset_report/refresh`
 * @export
 * @interface AssetReportRefreshRequest
 */
export interface AssetReportRefreshRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportRefreshRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportRefreshRequest
     */
    secret?: string;
    /**
     * The `asset_report_token` returned by the original call to `/asset_report/create`
     * @type {string}
     * @memberof AssetReportRefreshRequest
     */
    asset_report_token: string;
    /**
     * The maximum number of days of history to include in the Asset Report. Must be an integer. If not specified, the value from the original call to `/asset_report/create` will be used.
     * @type {number}
     * @memberof AssetReportRefreshRequest
     */
    days_requested?: number | null;
    /**
     *
     * @type {AssetReportRefreshRequestOptions}
     * @memberof AssetReportRefreshRequest
     */
    options?: AssetReportRefreshRequestOptions;
}
/**
 * An optional object to filter `/asset_report/refresh` results. If provided, cannot be `null`. If not specified, the `options` from the original call to `/asset_report/create` will be used.
 * @export
 * @interface AssetReportRefreshRequestOptions
 */
export interface AssetReportRefreshRequestOptions {
    /**
     * Client-generated identifier, which can be used by lenders to track loan applications.
     * @type {string}
     * @memberof AssetReportRefreshRequestOptions
     */
    client_report_id?: string | null;
    /**
     * URL to which Plaid will send Assets webhooks, for example when the requested Asset Report is ready.
     * @type {string}
     * @memberof AssetReportRefreshRequestOptions
     */
    webhook?: string | null;
    /**
     *
     * @type {AssetReportUser}
     * @memberof AssetReportRefreshRequestOptions
     */
    user?: AssetReportUser;
}
/**
 * AssetReportRefreshResponse defines the response schema for `/asset_report/refresh`
 * @export
 * @interface AssetReportRefreshResponse
 */
export interface AssetReportRefreshResponse {
    [key: string]: object | any;
    /**
     * A unique ID identifying an Asset Report. Like all Plaid identifiers, this ID is case sensitive.
     * @type {string}
     * @memberof AssetReportRefreshResponse
     */
    asset_report_id: string;
    /**
     * A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.
     * @type {string}
     * @memberof AssetReportRefreshResponse
     */
    asset_report_token: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AssetReportRefreshResponse
     */
    request_id: string;
}
/**
 * AssetReportRemoveRequest defines the request schema for `/asset_report/remove`
 * @export
 * @interface AssetReportRemoveRequest
 */
export interface AssetReportRemoveRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportRemoveRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AssetReportRemoveRequest
     */
    secret?: string;
    /**
     * A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.
     * @type {string}
     * @memberof AssetReportRemoveRequest
     */
    asset_report_token: string;
}
/**
 * AssetReportRemoveResponse defines the response schema for `/asset_report/remove`
 * @export
 * @interface AssetReportRemoveResponse
 */
export interface AssetReportRemoveResponse {
    [key: string]: object | any;
    /**
     * `true` if the Asset Report was successfully removed.
     * @type {boolean}
     * @memberof AssetReportRemoveResponse
     */
    removed: boolean;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AssetReportRemoveResponse
     */
    request_id: string;
}
/**
 * A transaction on the asset report
 * @export
 * @interface AssetReportTransaction
 */
export interface AssetReportTransaction {
    /**
     * Please use the `payment_channel` field, `transaction_type` will be deprecated in the future.  `digital:` transactions that took place online.  `place:` transactions that were made at a physical location.  `special:` transactions that relate to banks, e.g. fees or deposits.  `unresolved:` transactions that do not fit into the other three types.
     * @type {string}
     * @memberof AssetReportTransaction
     * @deprecated
     */
    transaction_type?: AssetReportTransactionTransactionTypeEnum;
    /**
     * The ID of a posted transaction\'s associated pending transaction, where applicable.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    pending_transaction_id?: string | null;
    /**
     * The ID of the category to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/#categoriesget).  If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    category_id?: string | null;
    /**
     * A hierarchical array of the categories to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/#categoriesget).  If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {Array<string>}
     * @memberof AssetReportTransaction
     */
    category?: Array<string> | null;
    /**
     *
     * @type {Location}
     * @memberof AssetReportTransaction
     */
    location?: Location;
    /**
     *
     * @type {PaymentMeta}
     * @memberof AssetReportTransaction
     */
    payment_meta?: PaymentMeta;
    /**
     * The name of the account owner. This field is not typically populated and only relevant when dealing with sub-accounts.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    account_owner?: string | null;
    /**
     * The merchant name or transaction description.  If the `transactions` object was returned by a Transactions endpoint such as `/transactions/get`, this field will always appear. If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    name?: string;
    /**
     * The string returned by the financial institution to describe the transaction. For transactions returned by `/transactions/get`, this field is in beta and will be omitted unless the client is both enrolled in the closed beta program and has set `options.include_original_description` to `true`.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    original_description: string | null;
    /**
     * The ID of the account in which this transaction occurred.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    account_id: string;
    /**
     * The settled value of the transaction, denominated in the account\'s currency, as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.
     * @type {number}
     * @memberof AssetReportTransaction
     */
    amount: number;
    /**
     * The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    iso_currency_code: string | null;
    /**
     * The unofficial currency code associated with the transaction. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    unofficial_currency_code: string | null;
    /**
     * For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ).
     * @type {string}
     * @memberof AssetReportTransaction
     */
    date: string;
    /**
     * When `true`, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.
     * @type {boolean}
     * @memberof AssetReportTransaction
     */
    pending: boolean;
    /**
     * The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    transaction_id: string;
    /**
     * The merchant name, as extracted by Plaid from the `name` field.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    merchant_name?: string | null;
    /**
     * The check number of the transaction. This field is only populated for check transactions.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    check_number?: string | null;
    /**
     * The date on which the transaction took place, in IS0 8601 format.
     * @type {string}
     * @memberof AssetReportTransaction
     */
    date_transacted?: string | null;
}
/**
    * @export
    * @enum {string}
    */
export declare enum AssetReportTransactionTransactionTypeEnum {
    Digital = "digital",
    Place = "place",
    Special = "special",
    Unresolved = "unresolved"
}
/**
 *
 * @export
 * @interface AssetReportTransactionAllOf
 */
export interface AssetReportTransactionAllOf {
    /**
     * The date on which the transaction took place, in IS0 8601 format.
     * @type {string}
     * @memberof AssetReportTransactionAllOf
     */
    date_transacted?: string | null;
}
/**
 * The user object allows you to provide additional information about the user to be appended to the Asset Report. All fields are optional. The `first_name`, `last_name`, and `ssn` fields are required if you would like the Report to be eligible for Fannie Mae’s Day 1 Certainty™ program.
 * @export
 * @interface AssetReportUser
 */
export interface AssetReportUser {
    [key: string]: object | any;
    /**
     * An identifier you determine and submit for the user.
     * @type {string}
     * @memberof AssetReportUser
     */
    client_user_id?: string | null;
    /**
     * The user\'s first name. Required for the Fannie Mae Day 1 Certainty™ program.
     * @type {string}
     * @memberof AssetReportUser
     */
    first_name?: string | null;
    /**
     * The user\'s middle name
     * @type {string}
     * @memberof AssetReportUser
     */
    middle_name?: string | null;
    /**
     * The user\'s last name.  Required for the Fannie Mae Day 1 Certainty™ program.
     * @type {string}
     * @memberof AssetReportUser
     */
    last_name?: string | null;
    /**
     * The user\'s Social Security Number. Required for the Fannie Mae Day 1 Certainty™ program.  Format: \"ddd-dd-dddd\"
     * @type {string}
     * @memberof AssetReportUser
     */
    ssn?: string | null;
    /**
     * The user\'s phone number, in E.164 format: +{countrycode}{number}. For example: \"+14151234567\". Phone numbers provided in other formats will be parsed on a best-effort basis.
     * @type {string}
     * @memberof AssetReportUser
     */
    phone_number?: string | null;
    /**
     * The user\'s email address.
     * @type {string}
     * @memberof AssetReportUser
     */
    email?: string | null;
}
/**
 * Fired when Asset Report generation has failed. The resulting `error` will have an `error_type` of `ASSET_REPORT_ERROR`.
 * @export
 * @interface AssetsErrorWebhook
 */
export interface AssetsErrorWebhook {
    [key: string]: object | any;
    /**
     * `ASSETS`
     * @type {string}
     * @memberof AssetsErrorWebhook
     */
    webhook_type: string;
    /**
     * `ERROR`
     * @type {string}
     * @memberof AssetsErrorWebhook
     */
    webhook_code: string;
    /**
     *
     * @type {PlaidError}
     * @memberof AssetsErrorWebhook
     */
    error: PlaidError;
    /**
     * The ID associated with the Asset Report.
     * @type {string}
     * @memberof AssetsErrorWebhook
     */
    asset_report_id: string;
}
/**
 * Fired when the Asset Report has been generated and `/asset_report/get` is ready to be called.  If you attempt to retrieve an Asset Report before this webhook has fired, you’ll receive a response with the HTTP status code 400 and a Plaid error code of `PRODUCT_NOT_READY`.
 * @export
 * @interface AssetsProductReadyWebhook
 */
export interface AssetsProductReadyWebhook {
    [key: string]: object | any;
    /**
     * `ASSETS`
     * @type {string}
     * @memberof AssetsProductReadyWebhook
     */
    webhook_type: string;
    /**
     * `PRODUCT_READY`
     * @type {string}
     * @memberof AssetsProductReadyWebhook
     */
    webhook_code: string;
    /**
     * The `asset_report_id` that can be provided to `/asset_report/get` to retrieve the Asset Report.
     * @type {string}
     * @memberof AssetsProductReadyWebhook
     */
    asset_report_id: string;
}
/**
 * An object containing identifying numbers used for making electronic transfers to and from the `accounts`. The identifying number type (ACH, EFT, IBAN, or BACS) used will depend on the country of the account. An account may have more than one number type. If a particular identifying number type is not used by any `accounts` for which data has been requested, the array for that type will be empty.
 * @export
 * @interface AuthGetNumbers
 */
export interface AuthGetNumbers {
    [key: string]: object | any;
    /**
     * An array of ACH numbers identifying accounts.
     * @type {Array<NumbersACH>}
     * @memberof AuthGetNumbers
     */
    ach: Array<NumbersACH>;
    /**
     * An array of EFT numbers identifying accounts.
     * @type {Array<NumbersEFT>}
     * @memberof AuthGetNumbers
     */
    eft: Array<NumbersEFT>;
    /**
     * An array of IBAN numbers identifying accounts.
     * @type {Array<NumbersInternational>}
     * @memberof AuthGetNumbers
     */
    international: Array<NumbersInternational>;
    /**
     * An array of BACS numbers identifying accounts.
     * @type {Array<NumbersBACS>}
     * @memberof AuthGetNumbers
     */
    bacs: Array<NumbersBACS>;
}
/**
 * AuthGetRequest defines the request schema for `/auth/get`
 * @export
 * @interface AuthGetRequest
 */
export interface AuthGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof AuthGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof AuthGetRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof AuthGetRequest
     */
    access_token: string;
    /**
     *
     * @type {AuthGetRequestOptions}
     * @memberof AuthGetRequest
     */
    options?: AuthGetRequestOptions;
}
/**
 * An optional object to filter `/auth/get` results.
 * @export
 * @interface AuthGetRequestOptions
 */
export interface AuthGetRequestOptions {
    /**
     * A list of `account_ids` to retrieve for the Item. Note: An error will be returned if a provided `account_id` is not associated with the Item.
     * @type {Array<string>}
     * @memberof AuthGetRequestOptions
     */
    account_ids?: Array<string>;
}
/**
 * AuthGetResponse defines the response schema for `/auth/get`
 * @export
 * @interface AuthGetResponse
 */
export interface AuthGetResponse {
    [key: string]: object | any;
    /**
     * The `accounts` for which numbers are being retrieved.
     * @type {Array<AccountBase>}
     * @memberof AuthGetResponse
     */
    accounts: Array<AccountBase>;
    /**
     *
     * @type {AuthGetNumbers}
     * @memberof AuthGetResponse
     */
    numbers: AuthGetNumbers;
    /**
     *
     * @type {Item}
     * @memberof AuthGetResponse
     */
    item: Item;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof AuthGetResponse
     */
    request_id: string;
}
/**
 * Metadata that captures information about the Auth features of an institution.
 * @export
 * @interface AuthMetadata
 */
export interface AuthMetadata {
    [key: string]: object | any;
    /**
     *
     * @type {AuthSupportedMethods}
     * @memberof AuthMetadata
     */
    supported_methods: AuthSupportedMethods | null;
}
/**
 * Metadata specifically related to which auth methods an institution supports.
 * @export
 * @interface AuthSupportedMethods
 */
export interface AuthSupportedMethods {
    [key: string]: object | any;
    /**
     * Indicates if instant auth is supported.
     * @type {boolean}
     * @memberof AuthSupportedMethods
     */
    instant_auth: boolean;
    /**
     * Indicates if instant match is supported.
     * @type {boolean}
     * @memberof AuthSupportedMethods
     */
    instant_match: boolean;
    /**
     * Indicates if automated microdeposits are supported.
     * @type {boolean}
     * @memberof AuthSupportedMethods
     */
    automated_micro_deposits: boolean;
}
/**
 * Fired when an Item is verified via automated micro-deposits. We recommend communicating to your users when this event is received to notify them that their account is verified and ready for use.
 * @export
 * @interface AutomaticallyVerifiedWebhook
 */
export interface AutomaticallyVerifiedWebhook {
    [key: string]: object | any;
    /**
     * `AUTH`
     * @type {string}
     * @memberof AutomaticallyVerifiedWebhook
     */
    webhook_type: string;
    /**
     * `AUTOMATICALLY_VERIFIED`
     * @type {string}
     * @memberof AutomaticallyVerifiedWebhook
     */
    webhook_code: string;
    /**
     * The `account_id` of the account associated with the webhook
     * @type {string}
     * @memberof AutomaticallyVerifiedWebhook
     */
    account_id: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof AutomaticallyVerifiedWebhook
     */
    item_id: string;
}
/**
 * The object contains a risk score and a risk tier that evaluate the transaction return risk because an account is overdrawn or because an ineligible account is used. Common return codes in this category include: \"R01\", \"R02\", \"R03\", \"R04\", \"R06\", \"R08\",  \"R09\", \"R13\", \"R16\", \"R17\", \"R20\", \"R23\". These returns have a turnaround time of 2 banking days.
 * @export
 * @interface BankInitiatedReturnRisk
 */
export interface BankInitiatedReturnRisk {
    /**
     * A score from 0-99 that indicates the transaction return risk: a higher risk score suggests a higher return likelihood.
     * @type {number}
     * @memberof BankInitiatedReturnRisk
     */
    score: number;
    /**
     * In the `bank_initiated_return_risk` object, there are eight risk tiers corresponding to the scores:   1: Predicted bank-initiated return incidence rate between 0.0% - 0.5%   2: Predicted bank-initiated return incidence rate between 0.5% - 1.5%   3: Predicted bank-initiated return incidence rate between 1.5% - 3%   4: Predicted bank-initiated return incidence rate between 3% - 5%   5: Predicted bank-initiated return incidence rate between 5% - 10%   6: Predicted bank-initiated return incidence rate between 10% - 15%   7: Predicted bank-initiated return incidence rate between 15% and 50%   8: Predicted bank-initiated return incidence rate greater than 50%
     * @type {number}
     * @memberof BankInitiatedReturnRisk
     */
    risk_tier: number;
}
/**
 * Represents a bank transfer within the Bank Transfers API.
 * @export
 * @interface BankTransfer
 */
export interface BankTransfer {
    [key: string]: object | any;
    /**
     * Plaid’s unique identifier for a bank transfer.
     * @type {string}
     * @memberof BankTransfer
     */
    id: string;
    /**
     *
     * @type {ACHClass}
     * @memberof BankTransfer
     */
    ach_class: ACHClass;
    /**
     * The account ID that should be credited/debited for this bank transfer.
     * @type {string}
     * @memberof BankTransfer
     */
    account_id: string;
    /**
     *
     * @type {BankTransferType}
     * @memberof BankTransfer
     */
    type: BankTransferType;
    /**
     *
     * @type {BankTransferUser}
     * @memberof BankTransfer
     */
    user: BankTransferUser;
    /**
     * The amount of the bank transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof BankTransfer
     */
    amount: string;
    /**
     * The currency of the transfer amount, e.g. \"USD\"
     * @type {string}
     * @memberof BankTransfer
     */
    iso_currency_code: string;
    /**
     * The description of the transfer.
     * @type {string}
     * @memberof BankTransfer
     */
    description: string;
    /**
     * The datetime when this bank transfer was created. This will be of the form `2006-01-02T15:04:05Z`
     * @type {string}
     * @memberof BankTransfer
     */
    created: string;
    /**
     *
     * @type {BankTransferStatus}
     * @memberof BankTransfer
     */
    status: BankTransferStatus;
    /**
     *
     * @type {BankTransferNetwork}
     * @memberof BankTransfer
     */
    network: BankTransferNetwork;
    /**
     * When `true`, you can still cancel this bank transfer.
     * @type {boolean}
     * @memberof BankTransfer
     */
    cancellable: boolean;
    /**
     *
     * @type {BankTransferFailure}
     * @memberof BankTransfer
     */
    failure_reason: BankTransferFailure | null;
    /**
     * A string containing the custom tag provided by the client in the create request. Will be null if not provided.
     * @type {string}
     * @memberof BankTransfer
     */
    custom_tag: string | null;
    /**
     * The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters
     * @type {{ [key: string]: string; }}
     * @memberof BankTransfer
     */
    metadata: {
        [key: string]: string;
    } | null;
    /**
     * Plaid’s unique identifier for the origination account that was used for this transfer.
     * @type {string}
     * @memberof BankTransfer
     */
    origination_account_id: string;
    /**
     *
     * @type {BankTransferDirection}
     * @memberof BankTransfer
     */
    direction: BankTransferDirection | null;
}
/**
 * Information about the balance of a bank transfer
 * @export
 * @interface BankTransferBalance
 */
export interface BankTransferBalance {
    [key: string]: object | any;
    /**
     * The total available balance - the sum of all successful debit transfer amounts minus all credit transfer amounts.
     * @type {string}
     * @memberof BankTransferBalance
     */
    available: string;
    /**
     * The transactable balance shows the amount in your account that you are able to use for transfers, and is essentially your available balance minus your minimum balance.
     * @type {string}
     * @memberof BankTransferBalance
     */
    transactable: string;
}
/**
 * Defines the request schema for `/bank_transfer/balance/get`
 * @export
 * @interface BankTransferBalanceGetRequest
 */
export interface BankTransferBalanceGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferBalanceGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferBalanceGetRequest
     */
    secret?: string;
    /**
     * If multiple origination accounts are available, `origination_account_id` must be used to specify the account for which balance will be returned.
     * @type {string}
     * @memberof BankTransferBalanceGetRequest
     */
    origination_account_id?: string | null;
}
/**
 * Defines the response schema for `/bank_transfer/balance/get`
 * @export
 * @interface BankTransferBalanceGetResponse
 */
export interface BankTransferBalanceGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {BankTransferBalance}
     * @memberof BankTransferBalanceGetResponse
     */
    balance: BankTransferBalance;
    /**
     * The ID of the origination account that this balance belongs to.
     * @type {string}
     * @memberof BankTransferBalanceGetResponse
     */
    origination_account_id: string | null;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferBalanceGetResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/bank_transfer/cancel`
 * @export
 * @interface BankTransferCancelRequest
 */
export interface BankTransferCancelRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferCancelRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferCancelRequest
     */
    secret?: string;
    /**
     * Plaid’s unique identifier for a bank transfer.
     * @type {string}
     * @memberof BankTransferCancelRequest
     */
    bank_transfer_id: string;
}
/**
 * Defines the response schema for `/bank_transfer/cancel`
 * @export
 * @interface BankTransferCancelResponse
 */
export interface BankTransferCancelResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferCancelResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/bank_transfer/create`
 * @export
 * @interface BankTransferCreateRequest
 */
export interface BankTransferCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    secret?: string;
    /**
     * A random key provided by the client, per unique bank transfer. Maximum of 50 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. For example, if a request to create a bank transfer fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single bank transfer is created.
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    idempotency_key: string;
    /**
     * The Plaid `access_token` for the account that will be debited or credited.
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    access_token: string;
    /**
     * The Plaid `account_id` for the account that will be debited or credited.
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    account_id: string;
    /**
     *
     * @type {BankTransferType}
     * @memberof BankTransferCreateRequest
     */
    type: BankTransferType;
    /**
     *
     * @type {BankTransferNetwork}
     * @memberof BankTransferCreateRequest
     */
    network: BankTransferNetwork;
    /**
     * The amount of the bank transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    amount: string;
    /**
     * The currency of the transfer amount – should be set to \"USD\".
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    iso_currency_code: string;
    /**
     * The transfer description. Maximum of 10 characters.
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    description: string;
    /**
     *
     * @type {ACHClass}
     * @memberof BankTransferCreateRequest
     */
    ach_class?: ACHClass;
    /**
     *
     * @type {BankTransferUser}
     * @memberof BankTransferCreateRequest
     */
    user: BankTransferUser;
    /**
     * An arbitrary string provided by the client for storage with the bank transfer. May be up to 100 characters.
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    custom_tag?: string | null;
    /**
     * The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters
     * @type {{ [key: string]: string; }}
     * @memberof BankTransferCreateRequest
     */
    metadata?: {
        [key: string]: string;
    } | null;
    /**
     * Plaid’s unique identifier for the origination account for this transfer. If you have more than one origination account, this value must be specified. Otherwise, this field should be left blank.
     * @type {string}
     * @memberof BankTransferCreateRequest
     */
    origination_account_id?: string | null;
}
/**
 * Defines the response schema for `/bank_transfer/create`
 * @export
 * @interface BankTransferCreateResponse
 */
export interface BankTransferCreateResponse {
    [key: string]: object | any;
    /**
     *
     * @type {BankTransfer}
     * @memberof BankTransferCreateResponse
     */
    bank_transfer: BankTransfer;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferCreateResponse
     */
    request_id: string;
}
/**
 * Indicates the direction of the transfer: `outbound` for API-initiated transfers, or `inbound` for payments received by the FBO account.
 * @export
 * @enum {string}
 */
export declare enum BankTransferDirection {
    Outbound = "outbound",
    Inbound = "inbound",
    Null = "null"
}
/**
 * Represents an event in the Bank Transfers API.
 * @export
 * @interface BankTransferEvent
 */
export interface BankTransferEvent {
    [key: string]: object | any;
    /**
     * Plaid’s unique identifier for this event. IDs are sequential unsigned 64-bit integers.
     * @type {number}
     * @memberof BankTransferEvent
     */
    event_id: number;
    /**
     * The datetime when this event occurred. This will be of the form `2006-01-02T15:04:05Z`.
     * @type {string}
     * @memberof BankTransferEvent
     */
    timestamp: string;
    /**
     *
     * @type {BankTransferEventType}
     * @memberof BankTransferEvent
     */
    event_type: BankTransferEventType;
    /**
     * The account ID associated with the bank transfer.
     * @type {string}
     * @memberof BankTransferEvent
     */
    account_id: string;
    /**
     * Plaid’s unique identifier for a bank transfer.
     * @type {string}
     * @memberof BankTransferEvent
     */
    bank_transfer_id: string;
    /**
     * The ID of the origination account that this balance belongs to.
     * @type {string}
     * @memberof BankTransferEvent
     */
    origination_account_id: string | null;
    /**
     *
     * @type {BankTransferType}
     * @memberof BankTransferEvent
     */
    bank_transfer_type: BankTransferType;
    /**
     * The bank transfer amount.
     * @type {string}
     * @memberof BankTransferEvent
     */
    bank_transfer_amount: string;
    /**
     * The currency of the bank transfer amount.
     * @type {string}
     * @memberof BankTransferEvent
     */
    bank_transfer_iso_currency_code: string;
    /**
     *
     * @type {BankTransferFailure}
     * @memberof BankTransferEvent
     */
    failure_reason: BankTransferFailure | null;
    /**
     *
     * @type {BankTransferDirection}
     * @memberof BankTransferEvent
     */
    direction: BankTransferDirection | null;
}
/**
 * Defines the request schema for `/bank_transfer/event/list`
 * @export
 * @interface BankTransferEventListRequest
 */
export interface BankTransferEventListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    secret?: string;
    /**
     * The start datetime of bank transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    start_date?: string | null;
    /**
     * The end datetime of bank transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    end_date?: string | null;
    /**
     * Plaid’s unique identifier for a bank transfer.
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    bank_transfer_id?: string | null;
    /**
     * The account ID to get events for all transactions to/from an account.
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    account_id?: string | null;
    /**
     * The type of bank transfer. This will be either `debit` or `credit`.  A `debit` indicates a transfer of money into your origination account; a `credit` indicates a transfer of money out of your origination account.
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    bank_transfer_type?: BankTransferEventListRequestBankTransferTypeEnum;
    /**
     * Filter events by event type.
     * @type {Array<BankTransferEventType>}
     * @memberof BankTransferEventListRequest
     */
    event_types?: Array<BankTransferEventType>;
    /**
     * The maximum number of bank transfer events to return. If the number of events matching the above parameters is greater than `count`, the most recent events will be returned.
     * @type {number}
     * @memberof BankTransferEventListRequest
     */
    count?: number | null;
    /**
     * The offset into the list of bank transfer events. When `count`=25 and `offset`=0, the first 25 events will be returned. When `count`=25 and `offset`=25, the next 25 bank transfer events will be returned.
     * @type {number}
     * @memberof BankTransferEventListRequest
     */
    offset?: number | null;
    /**
     * The origination account ID to get events for transfers from a specific origination account.
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    origination_account_id?: string | null;
    /**
     * Indicates the direction of the transfer: `outbound`: for API-initiated transfers `inbound`: for payments received by the FBO account.
     * @type {string}
     * @memberof BankTransferEventListRequest
     */
    direction?: BankTransferEventListRequestDirectionEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum BankTransferEventListRequestBankTransferTypeEnum {
    Debit = "debit",
    Credit = "credit",
    Null = "null"
}
/**
    * @export
    * @enum {string}
    */
export declare enum BankTransferEventListRequestDirectionEnum {
    Inbound = "inbound",
    Outbound = "outbound",
    Null = "null"
}
/**
 * Defines the response schema for `/bank_transfer/event/list`
 * @export
 * @interface BankTransferEventListResponse
 */
export interface BankTransferEventListResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<BankTransferEvent>}
     * @memberof BankTransferEventListResponse
     */
    bank_transfer_events: Array<BankTransferEvent>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferEventListResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/bank_transfer/event/sync`
 * @export
 * @interface BankTransferEventSyncRequest
 */
export interface BankTransferEventSyncRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferEventSyncRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferEventSyncRequest
     */
    secret?: string;
    /**
     * The latest (largest) `event_id` fetched via the sync endpoint, or 0 initially.
     * @type {number}
     * @memberof BankTransferEventSyncRequest
     */
    after_id: number;
    /**
     * The maximum number of bank transfer events to return.
     * @type {number}
     * @memberof BankTransferEventSyncRequest
     */
    count?: number | null;
}
/**
 * Defines the response schema for `/bank_transfer/event/sync`
 * @export
 * @interface BankTransferEventSyncResponse
 */
export interface BankTransferEventSyncResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<BankTransferEvent>}
     * @memberof BankTransferEventSyncResponse
     */
    bank_transfer_events: Array<BankTransferEvent>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferEventSyncResponse
     */
    request_id: string;
}
/**
 * The type of event that this bank transfer represents.  `pending`: A new transfer was created; it is in the pending state.  `cancelled`: The transfer was cancelled by the client.  `failed`: The transfer failed, no funds were moved.  `posted`: The transfer has been successfully submitted to the payment network.  `reversed`: A posted transfer was reversed.
 * @export
 * @enum {string}
 */
export declare enum BankTransferEventType {
    Pending = "pending",
    Cancelled = "cancelled",
    Failed = "failed",
    Posted = "posted",
    Reversed = "reversed"
}
/**
 * The failure reason if the type of this transfer is `\"failed\"` or `\"reversed\"`. Null value otherwise.
 * @export
 * @interface BankTransferFailure
 */
export interface BankTransferFailure {
    [key: string]: object | any;
    /**
     * The ACH return code, e.g. `R01`.  A return code will be provided if and only if the transfer status is `reversed`. For a full listing of ACH return codes, see [Bank Transfers errors](https://plaid.com/docs/errors/bank-transfers/#ach-return-codes).
     * @type {string}
     * @memberof BankTransferFailure
     */
    ach_return_code?: string | null;
    /**
     * A human-readable description of the reason for the failure or reversal.
     * @type {string}
     * @memberof BankTransferFailure
     */
    description?: string;
}
/**
 * Defines the request schema for `/bank_transfer/get`
 * @export
 * @interface BankTransferGetRequest
 */
export interface BankTransferGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferGetRequest
     */
    secret?: string;
    /**
     * Plaid’s unique identifier for a bank transfer.
     * @type {string}
     * @memberof BankTransferGetRequest
     */
    bank_transfer_id: string;
}
/**
 * Defines the response schema for `/bank_transfer/get`
 * @export
 * @interface BankTransferGetResponse
 */
export interface BankTransferGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {BankTransfer}
     * @memberof BankTransferGetResponse
     */
    bank_transfer: BankTransfer;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferGetResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/bank_transfer/list`
 * @export
 * @interface BankTransferListRequest
 */
export interface BankTransferListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferListRequest
     */
    secret?: string;
    /**
     * The start datetime of bank transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)
     * @type {string}
     * @memberof BankTransferListRequest
     */
    start_date?: string | null;
    /**
     * The end datetime of bank transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)
     * @type {string}
     * @memberof BankTransferListRequest
     */
    end_date?: string | null;
    /**
     * The maximum number of bank transfers to return.
     * @type {number}
     * @memberof BankTransferListRequest
     */
    count?: number;
    /**
     * The number of bank transfers to skip before returning results.
     * @type {number}
     * @memberof BankTransferListRequest
     */
    offset?: number;
    /**
     * Filter bank transfers to only those originated through the specified origination account.
     * @type {string}
     * @memberof BankTransferListRequest
     */
    origination_account_id?: string | null;
    /**
     *
     * @type {BankTransferDirection}
     * @memberof BankTransferListRequest
     */
    direction?: BankTransferDirection | null;
}
/**
 * Defines the response schema for `/bank_transfer/list`
 * @export
 * @interface BankTransferListResponse
 */
export interface BankTransferListResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<BankTransfer>}
     * @memberof BankTransferListResponse
     */
    bank_transfers: Array<BankTransfer>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferListResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/bank_transfer/migrate_account`
 * @export
 * @interface BankTransferMigrateAccountRequest
 */
export interface BankTransferMigrateAccountRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferMigrateAccountRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferMigrateAccountRequest
     */
    secret?: string;
    /**
     * The user\'s account number.
     * @type {string}
     * @memberof BankTransferMigrateAccountRequest
     */
    account_number: string;
    /**
     * The user\'s routing number.
     * @type {string}
     * @memberof BankTransferMigrateAccountRequest
     */
    routing_number: string;
    /**
     * The type of the bank account (`checking` or `savings`).
     * @type {string}
     * @memberof BankTransferMigrateAccountRequest
     */
    account_type: string;
}
/**
 * Defines the response schema for `/bank_transfer/migrate_account`
 * @export
 * @interface BankTransferMigrateAccountResponse
 */
export interface BankTransferMigrateAccountResponse {
    [key: string]: object | any;
    /**
     * The Plaid `access_token` for the newly created Item.
     * @type {string}
     * @memberof BankTransferMigrateAccountResponse
     */
    access_token: string;
    /**
     * The Plaid `account_id` for the newly created Item.
     * @type {string}
     * @memberof BankTransferMigrateAccountResponse
     */
    account_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferMigrateAccountResponse
     */
    request_id: string;
}
/**
 * The network or rails used for the transfer. Valid options are `ach`, `same-day-ach`, or `wire`.
 * @export
 * @enum {string}
 */
export declare enum BankTransferNetwork {
    Ach = "ach",
    SameDayAch = "same-day-ach",
    Wire = "wire"
}
/**
 * The status of the transfer.
 * @export
 * @enum {string}
 */
export declare enum BankTransferStatus {
    Pending = "pending",
    Posted = "posted",
    Cancelled = "cancelled",
    Failed = "failed",
    Reversed = "reversed"
}
/**
 * BankTransferSweep describes a sweep transfer.
 * @export
 * @interface BankTransferSweep
 */
export interface BankTransferSweep {
    [key: string]: object | any;
    /**
     * Identifier of the sweep.
     * @type {string}
     * @memberof BankTransferSweep
     */
    id: string;
    /**
     * The datetime when the sweep occurred, in RFC 3339 format.
     * @type {string}
     * @memberof BankTransferSweep
     */
    created_at: string;
    /**
     * The amount of the sweep.
     * @type {string}
     * @memberof BankTransferSweep
     */
    amount: string;
    /**
     * The currency of the sweep, e.g. \"USD\".
     * @type {string}
     * @memberof BankTransferSweep
     */
    iso_currency_code: string;
}
/**
 * Defines the request schema for `/bank_transfer/sweep/get`
 * @export
 * @interface BankTransferSweepGetRequest
 */
export interface BankTransferSweepGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferSweepGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferSweepGetRequest
     */
    secret?: string;
    /**
     * Identifier of the sweep.
     * @type {string}
     * @memberof BankTransferSweepGetRequest
     */
    sweep_id: string;
}
/**
 * BankTransferSweepGetResponse defines the response schema for `/bank_transfer/sweep/get`
 * @export
 * @interface BankTransferSweepGetResponse
 */
export interface BankTransferSweepGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {BankTransferSweep}
     * @memberof BankTransferSweepGetResponse
     */
    sweep: BankTransferSweep;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferSweepGetResponse
     */
    request_id: string;
}
/**
 * BankTransferSweepListRequest defines the request schema for `/bank_transfer/sweep/list`
 * @export
 * @interface BankTransferSweepListRequest
 */
export interface BankTransferSweepListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferSweepListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof BankTransferSweepListRequest
     */
    secret?: string;
    /**
     * If multiple origination accounts are available, `origination_account_id` must be used to specify the account that the sweeps belong to.
     * @type {string}
     * @memberof BankTransferSweepListRequest
     */
    origination_account_id?: string | null;
    /**
     * The start datetime of sweeps to return (RFC 3339 format).
     * @type {string}
     * @memberof BankTransferSweepListRequest
     */
    start_time?: string | null;
    /**
     * The end datetime of sweeps to return (RFC 3339 format).
     * @type {string}
     * @memberof BankTransferSweepListRequest
     */
    end_time?: string | null;
    /**
     * The maximum number of sweeps to return.
     * @type {number}
     * @memberof BankTransferSweepListRequest
     */
    count?: number | null;
}
/**
 * BankTransferSweepListResponse defines the response schema for `/bank_transfer/sweep/list`
 * @export
 * @interface BankTransferSweepListResponse
 */
export interface BankTransferSweepListResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<BankTransferSweep>}
     * @memberof BankTransferSweepListResponse
     */
    sweeps: Array<BankTransferSweep>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof BankTransferSweepListResponse
     */
    request_id: string;
}
/**
 * The type of bank transfer. This will be either `debit` or `credit`.  A `debit` indicates a transfer of money into the origination account; a `credit` indicates a transfer of money out of the origination account.
 * @export
 * @enum {string}
 */
export declare enum BankTransferType {
    Debit = "debit",
    Credit = "credit"
}
/**
 * The legal name and other information for the account holder.
 * @export
 * @interface BankTransferUser
 */
export interface BankTransferUser {
    [key: string]: object | any;
    /**
     * The account holder’s full legal name. If the transfer `ach_class` is `ccd`, this should be the business name of the account holder.
     * @type {string}
     * @memberof BankTransferUser
     */
    legal_name: string;
    /**
     * The account holder’s email.
     * @type {string}
     * @memberof BankTransferUser
     */
    email_address?: string | null;
    /**
     * The account holder\'s routing number. This field is only used in response data. Do not provide this field when making requests.
     * @type {string}
     * @memberof BankTransferUser
     */
    routing_number?: string;
}
/**
 * Fired when new bank transfer events are available. Receiving this webhook indicates you should fetch the new events from `/bank_transfer/event/sync`.
 * @export
 * @interface BankTransfersEventsUpdateWebhook
 */
export interface BankTransfersEventsUpdateWebhook {
    [key: string]: object | any;
    /**
     * `BANK_TRANSFERS`
     * @type {string}
     * @memberof BankTransfersEventsUpdateWebhook
     */
    webhook_type: string;
    /**
     * `BANK_TRANSFERS_EVENTS_UPDATE`
     * @type {string}
     * @memberof BankTransfersEventsUpdateWebhook
     */
    webhook_code: string;
}
/**
 * CategoriesGetResponse defines the response schema for `/categories/get`
 * @export
 * @interface CategoriesGetResponse
 */
export interface CategoriesGetResponse {
    [key: string]: object | any;
    /**
     * An array of all of the transaction categories used by Plaid.
     * @type {Array<Category>}
     * @memberof CategoriesGetResponse
     */
    categories: Array<Category>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof CategoriesGetResponse
     */
    request_id: string;
}
/**
 * Information describing a transaction category
 * @export
 * @interface Category
 */
export interface Category {
    [key: string]: object | any;
    /**
     * An identifying number for the category. `category_id` is a Plaid-specific identifier and does not necessarily correspond to merchant category codes.
     * @type {string}
     * @memberof Category
     */
    category_id: string;
    /**
     * `place` for physical transactions or `special` for other transactions such as bank charges.
     * @type {string}
     * @memberof Category
     */
    group: string;
    /**
     * A hierarchical array of the categories to which this `category_id` belongs.
     * @type {Array<string>}
     * @memberof Category
     */
    hierarchy: Array<string>;
}
/**
 * An error object and associated `item_id` used to identify a specific Item and error when a batch operation operating on multiple Items has encountered an error in one of the Items.
 * @export
 * @interface Cause
 */
export interface Cause {
    [key: string]: object | any;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof Cause
     */
    item_id: string;
    /**
     *
     * @type {PlaidError}
     * @memberof Cause
     */
    error: PlaidError;
}
/**
 * Describes the connected application for a particular end user.
 * @export
 * @interface ConnectedApplication
 */
export interface ConnectedApplication {
    /**
     * This field will map to the application ID that is returned from /item/applications/list, or provided to the institution in an oauth redirect.
     * @type {string}
     * @memberof ConnectedApplication
     */
    application_id: string;
    /**
     * The name of the application
     * @type {string}
     * @memberof ConnectedApplication
     */
    name: string;
    /**
     * A URL that links to the application logo image (will be deprecated in the future, please use logo_url).
     * @type {string}
     * @memberof ConnectedApplication
     * @deprecated
     */
    logo: string | null;
    /**
     * A URL that links to the application logo image.
     * @type {string}
     * @memberof ConnectedApplication
     */
    logo_url: string | null;
    /**
     * The URL for the application\'s website
     * @type {string}
     * @memberof ConnectedApplication
     */
    application_url: string | null;
    /**
     * A string provided by the connected app stating why they use their respective enabled products.
     * @type {string}
     * @memberof ConnectedApplication
     */
    reason_for_access: string | null;
    /**
     * The date this application was linked in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format in UTC.
     * @type {string}
     * @memberof ConnectedApplication
     */
    created_at: string;
    /**
     * The date this application was granted production access at Plaid in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format in UTC.
     * @type {string}
     * @memberof ConnectedApplication
     */
    join_date: string;
    /**
     * (Deprecated) A list of enums representing the data collected and products enabled for this connected application.
     * @type {Array<string>}
     * @memberof ConnectedApplication
     */
    product_data_types: Array<ConnectedApplicationProductDataTypesEnum>;
    /**
     *
     * @type {ScopesNullable}
     * @memberof ConnectedApplication
     */
    scopes?: ScopesNullable | null;
    /**
     *
     * @type {RequestedScopes}
     * @memberof ConnectedApplication
     */
    requested_scopes?: RequestedScopes;
}
/**
    * @export
    * @enum {string}
    */
export declare enum ConnectedApplicationProductDataTypesEnum {
    Balance = "ACCOUNT_BALANCE",
    UserInfo = "ACCOUNT_USER_INFO",
    Transactions = "ACCOUNT_TRANSACTIONS"
}
/**
 * ISO-3166-1 alpha-2 country code standard.
 * @export
 * @enum {string}
 */
export declare enum CountryCode {
    Us = "US",
    Gb = "GB",
    Es = "ES",
    Nl = "NL",
    Fr = "FR",
    Ie = "IE",
    Ca = "CA",
    De = "DE"
}
/**
 * Valid account subtypes for credit accounts. For a list containing descriptions of each subtype, see [Account schemas](https://plaid.com/docs/api/accounts/#StandaloneAccountType-credit).
 * @export
 * @enum {string}
 */
export declare enum CreditAccountSubtype {
    CreditCard = "credit card",
    Paypal = "paypal",
    All = "all"
}
/**
 * An object representing a credit card account.
 * @export
 * @interface CreditCardLiability
 */
export interface CreditCardLiability {
    [key: string]: object | any;
    /**
     * The ID of the account that this liability belongs to.
     * @type {string}
     * @memberof CreditCardLiability
     */
    account_id: string | null;
    /**
     * The various interest rates that apply to the account.
     * @type {Array<APR>}
     * @memberof CreditCardLiability
     */
    aprs: Array<APR>;
    /**
     * true if a payment is currently overdue. Availability for this field is limited.
     * @type {boolean}
     * @memberof CreditCardLiability
     */
    is_overdue: boolean | null;
    /**
     * The amount of the last payment.
     * @type {number}
     * @memberof CreditCardLiability
     */
    last_payment_amount: number;
    /**
     * The date of the last payment. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Availability for this field is limited.
     * @type {string}
     * @memberof CreditCardLiability
     */
    last_payment_date: string | null;
    /**
     * The date of the last statement. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof CreditCardLiability
     */
    last_statement_issue_date: string;
    /**
     * The total amount owed as of the last statement issued
     * @type {number}
     * @memberof CreditCardLiability
     */
    last_statement_balance: number;
    /**
     * The minimum payment due for the next billing cycle.
     * @type {number}
     * @memberof CreditCardLiability
     */
    minimum_payment_amount: number;
    /**
     * The due date for the next payment. The due date is `null` if a payment is not expected. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof CreditCardLiability
     */
    next_payment_due_date: string | null;
}
/**
 * A filter to apply to `credit`-type accounts
 * @export
 * @interface CreditFilter
 */
export interface CreditFilter {
    [key: string]: object | any;
    /**
     * An array of account subtypes to display in Link. If not specified, all account subtypes will be shown. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).
     * @type {Array<CreditAccountSubtype>}
     * @memberof CreditFilter
     */
    account_subtypes: Array<CreditAccountSubtype>;
}
/**
 * The object contains a risk score and a risk tier that evaluate the transaction return risk of an unauthorized debit. Common return codes in this category include: \"R05\", \"R07\", \"R10\", \"R11\", \"R29\". These returns typically have a return time frame of up to 60 calendar days. During this period, the customer of financial institutions can dispute a transaction as unauthorized.
 * @export
 * @interface CustomerInitiatedReturnRisk
 */
export interface CustomerInitiatedReturnRisk {
    /**
     * A score from 0-99 that indicates the transaction return risk: a higher risk score suggests a higher return likelihood.
     * @type {number}
     * @memberof CustomerInitiatedReturnRisk
     */
    score: number;
    /**
     * A tier corresponding to the projected likelihood that the transaction, if initiated, will be subject to a return.  In the `customer_initiated_return_risk` object, there are five risk tiers corresponding to the scores:   1: Predicted customer-initiated return incidence rate between 0.00% - 0.02%   2: Predicted customer-initiated return incidence rate between 0.02% - 0.05%   3: Predicted customer-initiated return incidence rate between 0.05% - 0.1%   4: Predicted customer-initiated return incidence rate between 0.1% - 0.5%   5: Predicted customer-initiated return incidence rate greater than 0.5%
     * @type {number}
     * @memberof CustomerInitiatedReturnRisk
     */
    risk_tier: number;
}
/**
 * An object with the deduction information found on a paystub.
 * @export
 * @interface Deductions
 */
export interface Deductions {
    [key: string]: object | any;
    /**
     *
     * @type {Array<Total>}
     * @memberof Deductions
     * @deprecated
     */
    subtotals?: Array<Total>;
    /**
     *
     * @type {Array<DeductionsBreakdown>}
     * @memberof Deductions
     */
    breakdown: Array<DeductionsBreakdown>;
    /**
     *
     * @type {Array<Total>}
     * @memberof Deductions
     * @deprecated
     */
    totals?: Array<Total>;
    /**
     *
     * @type {DeductionsTotal}
     * @memberof Deductions
     */
    total: DeductionsTotal;
}
/**
 * An object representing the deduction line items for the pay period
 * @export
 * @interface DeductionsBreakdown
 */
export interface DeductionsBreakdown {
    [key: string]: object | any;
    /**
     * Raw amount of the deduction
     * @type {number}
     * @memberof DeductionsBreakdown
     */
    current_amount?: number | null;
    /**
     * Description of the deduction line item
     * @type {string}
     * @memberof DeductionsBreakdown
     */
    description?: string | null;
    /**
     * The ISO-4217 currency code of the line item. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof DeductionsBreakdown
     */
    iso_currency_code?: string | null;
    /**
     * The unofficial currency code associated with the line item. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof DeductionsBreakdown
     */
    unofficial_currency_code?: string | null;
    /**
     * The year-to-date amount of the deduction
     * @type {number}
     * @memberof DeductionsBreakdown
     */
    ytd_amount?: number | null;
}
/**
 * An object representing the total deductions for the pay period
 * @export
 * @interface DeductionsTotal
 */
export interface DeductionsTotal {
    [key: string]: object | any;
    /**
     * Raw amount of the deduction
     * @type {number}
     * @memberof DeductionsTotal
     */
    current_amount?: number | null;
    /**
     * The ISO-4217 currency code of the line item. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof DeductionsTotal
     */
    iso_currency_code?: string | null;
    /**
     * The unofficial currency code associated with the line item. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof DeductionsTotal
     */
    unofficial_currency_code?: string | null;
    /**
     * The year-to-date total amount of the deductions
     * @type {number}
     * @memberof DeductionsTotal
     */
    ytd_amount?: number | null;
}
/**
 * Fired when new transaction data is available for an Item. Plaid will typically check for new transaction data several times a day.
 * @export
 * @interface DefaultUpdateWebhook
 */
export interface DefaultUpdateWebhook {
    [key: string]: object | any;
    /**
     * `TRANSACTIONS`
     * @type {string}
     * @memberof DefaultUpdateWebhook
     */
    webhook_type: string;
    /**
     * `DEFAULT_UPDATE`
     * @type {string}
     * @memberof DefaultUpdateWebhook
     */
    webhook_code: string;
    /**
     *
     * @type {PlaidError}
     * @memberof DefaultUpdateWebhook
     */
    error?: PlaidError;
    /**
     * The number of new transactions detected since the last time this webhook was fired.
     * @type {number}
     * @memberof DefaultUpdateWebhook
     */
    new_transactions: number;
    /**
     * The `item_id` of the Item the webhook relates to.
     * @type {string}
     * @memberof DefaultUpdateWebhook
     */
    item_id: string;
}
/**
 * The user\'s address.
 * @export
 * @interface DepositSwitchAddressData
 */
export interface DepositSwitchAddressData {
    [key: string]: object | any;
    /**
     * The full city name
     * @type {string}
     * @memberof DepositSwitchAddressData
     */
    city: string;
    /**
     * The region or state Example: `\"NC\"`
     * @type {string}
     * @memberof DepositSwitchAddressData
     */
    region: string;
    /**
     * The full street address Example: `\"564 Main Street, APT 15\"`
     * @type {string}
     * @memberof DepositSwitchAddressData
     */
    street: string;
    /**
     * The postal code
     * @type {string}
     * @memberof DepositSwitchAddressData
     */
    postal_code: string;
    /**
     * The ISO 3166-1 alpha-2 country code
     * @type {string}
     * @memberof DepositSwitchAddressData
     */
    country: string;
}
/**
 * DepositSwitchAltCreateRequest defines the request schema for `/deposit_switch/alt/create`
 * @export
 * @interface DepositSwitchAltCreateRequest
 */
export interface DepositSwitchAltCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof DepositSwitchAltCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof DepositSwitchAltCreateRequest
     */
    secret?: string;
    /**
     *
     * @type {DepositSwitchTargetAccount}
     * @memberof DepositSwitchAltCreateRequest
     */
    target_account: DepositSwitchTargetAccount;
    /**
     *
     * @type {DepositSwitchTargetUser}
     * @memberof DepositSwitchAltCreateRequest
     */
    target_user: DepositSwitchTargetUser;
    /**
     *
     * @type {DepositSwitchCreateRequestOptions}
     * @memberof DepositSwitchAltCreateRequest
     */
    options?: DepositSwitchCreateRequestOptions;
    /**
     * ISO-3166-1 alpha-2 country code standard.
     * @type {string}
     * @memberof DepositSwitchAltCreateRequest
     */
    country_code?: DepositSwitchAltCreateRequestCountryCodeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum DepositSwitchAltCreateRequestCountryCodeEnum {
    Us = "US",
    Ca = "CA"
}
/**
 * DepositSwitchAltCreateResponse defines the response schema for `/deposit_switch/alt/create`
 * @export
 * @interface DepositSwitchAltCreateResponse
 */
export interface DepositSwitchAltCreateResponse {
    [key: string]: object | any;
    /**
     * ID of the deposit switch. This ID is persisted throughout the lifetime of the deposit switch.
     * @type {string}
     * @memberof DepositSwitchAltCreateResponse
     */
    deposit_switch_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof DepositSwitchAltCreateResponse
     */
    request_id: string;
}
/**
 * DepositSwitchCreateRequest defines the request schema for `/deposit_switch/create`
 * @export
 * @interface DepositSwitchCreateRequest
 */
export interface DepositSwitchCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof DepositSwitchCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof DepositSwitchCreateRequest
     */
    secret?: string;
    /**
     * Access token for the target Item, typically provided in the Import Item response.
     * @type {string}
     * @memberof DepositSwitchCreateRequest
     */
    target_access_token: string;
    /**
     * Plaid Account ID that specifies the target bank account. This account will become the recipient for a user\'s direct deposit.
     * @type {string}
     * @memberof DepositSwitchCreateRequest
     */
    target_account_id: string;
    /**
     * ISO-3166-1 alpha-2 country code standard.
     * @type {string}
     * @memberof DepositSwitchCreateRequest
     */
    country_code?: DepositSwitchCreateRequestCountryCodeEnum;
    /**
     *
     * @type {DepositSwitchCreateRequestOptions}
     * @memberof DepositSwitchCreateRequest
     */
    options?: DepositSwitchCreateRequestOptions;
}
/**
    * @export
    * @enum {string}
    */
export declare enum DepositSwitchCreateRequestCountryCodeEnum {
    Us = "US",
    Ca = "CA"
}
/**
 * Options to configure the `/deposit_switch/create` request. If provided, cannot be `null`.
 * @export
 * @interface DepositSwitchCreateRequestOptions
 */
export interface DepositSwitchCreateRequestOptions {
    /**
     * The URL registered to receive webhooks when the status of a deposit switch request has changed.
     * @type {string}
     * @memberof DepositSwitchCreateRequestOptions
     */
    webhook?: string | null;
    /**
     * An array of access tokens corresponding to transaction items to use when attempting to match the user to their Payroll Provider. These tokens must be created by the same client id as the one creating the switch, and have access to the transactions product.
     * @type {Array<string>}
     * @memberof DepositSwitchCreateRequestOptions
     */
    transaction_item_access_tokens?: Array<string>;
}
/**
 * DepositSwitchCreateResponse defines the response schema for `/deposit_switch/create`
 * @export
 * @interface DepositSwitchCreateResponse
 */
export interface DepositSwitchCreateResponse {
    [key: string]: object | any;
    /**
     * ID of the deposit switch. This ID is persisted throughout the lifetime of the deposit switch.
     * @type {string}
     * @memberof DepositSwitchCreateResponse
     */
    deposit_switch_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof DepositSwitchCreateResponse
     */
    request_id: string;
}
/**
 * DepositSwitchGetRequest defines the request schema for `/deposit_switch/get`
 * @export
 * @interface DepositSwitchGetRequest
 */
export interface DepositSwitchGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof DepositSwitchGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof DepositSwitchGetRequest
     */
    secret?: string;
    /**
     * The ID of the deposit switch
     * @type {string}
     * @memberof DepositSwitchGetRequest
     */
    deposit_switch_id: string;
}
/**
 * DepositSwitchGetResponse defines the response schema for `/deposit_switch/get`
 * @export
 * @interface DepositSwitchGetResponse
 */
export interface DepositSwitchGetResponse {
    [key: string]: object | any;
    /**
     * The ID of the deposit switch.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    deposit_switch_id: string;
    /**
     * The ID of the bank account the direct deposit was switched to.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    target_account_id: string | null;
    /**
     * The ID of the Item the direct deposit was switched to.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    target_item_id: string | null;
    /**
     *  The state, or status, of the deposit switch.  - `initialized` – The deposit switch has been initialized with the user entering the information required to submit the deposit switch request.  - `processing` – The deposit switch request has been submitted and is being processed.  - `completed` – The user\'s employer has fulfilled the deposit switch request.  - `error` – There was an error processing the deposit switch request.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    state: DepositSwitchGetResponseStateEnum;
    /**
     * The method used to make the deposit switch.  - `instant` – User instantly switched their direct deposit to a new or existing bank account by connecting their payroll or employer account.  - `mail` – User requested that Plaid contact their employer by mail to make the direct deposit switch.  - `pdf` – User generated a PDF or email to be sent to their employer with the information necessary to make the deposit switch.\'
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    switch_method?: DepositSwitchGetResponseSwitchMethodEnum;
    /**
     * When `true`, user’s direct deposit goes to multiple banks. When false, user’s direct deposit only goes to the target account. Always `null` if the deposit switch has not been completed.
     * @type {boolean}
     * @memberof DepositSwitchGetResponse
     */
    account_has_multiple_allocations: boolean | null;
    /**
     * When `true`, the target account is allocated the remainder of direct deposit after all other allocations have been deducted. When `false`, user’s direct deposit is allocated as a percent or amount. Always `null` if the deposit switch has not been completed.
     * @type {boolean}
     * @memberof DepositSwitchGetResponse
     */
    is_allocated_remainder: boolean | null;
    /**
     * The percentage of direct deposit allocated to the target account. Always `null` if the target account is not allocated a percentage or if the deposit switch has not been completed or if `is_allocated_remainder` is true.
     * @type {number}
     * @memberof DepositSwitchGetResponse
     */
    percent_allocated: number | null;
    /**
     * The dollar amount of direct deposit allocated to the target account. Always `null` if the target account is not allocated an amount or if the deposit switch has not been completed.
     * @type {number}
     * @memberof DepositSwitchGetResponse
     */
    amount_allocated: number | null;
    /**
     * The name of the employer selected by the user. If the user did not select an employer, the value returned is `null`.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    employer_name?: string | null;
    /**
     * The ID of the employer selected by the user. If the user did not select an employer, the value returned is `null`.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    employer_id?: string | null;
    /**
     * The name of the institution selected by the user. If the user did not select an institution, the value returned is `null`.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    institution_name?: string | null;
    /**
     * The ID of the institution selected by the user. If the user did not select an institution, the value returned is `null`.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    institution_id?: string | null;
    /**
     * [ISO 8601](https://wikipedia.org/wiki/ISO_8601) date the deposit switch was created.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    date_created: string;
    /**
     * [ISO 8601](https://wikipedia.org/wiki/ISO_8601) date the deposit switch was completed. Always `null` if the deposit switch has not been completed.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    date_completed: string | null;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof DepositSwitchGetResponse
     */
    request_id: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum DepositSwitchGetResponseStateEnum {
    Initialized = "initialized",
    Processing = "processing",
    Completed = "completed",
    Error = "error"
}
/**
    * @export
    * @enum {string}
    */
export declare enum DepositSwitchGetResponseSwitchMethodEnum {
    Instant = "instant",
    Mail = "mail",
    Pdf = "pdf",
    Null = "null"
}
/**
 * Fired when the status of a deposit switch request has changed.
 * @export
 * @interface DepositSwitchStateUpdateWebhook
 */
export interface DepositSwitchStateUpdateWebhook {
    /**
     * `\"DEPOSIT_SWITCH\"`
     * @type {string}
     * @memberof DepositSwitchStateUpdateWebhook
     */
    webhook_type?: string;
    /**
     * `\"SWITCH_STATE_UPDATE\"`
     * @type {string}
     * @memberof DepositSwitchStateUpdateWebhook
     */
    webhook_code?: string;
    /**
     *  The state, or status, of the deposit switch.  `initialized`: The deposit switch has been initialized with the user entering the information required to submit the deposit switch request.  `processing`: The deposit switch request has been submitted and is being processed.  `completed`: The user\'s employer has fulfilled and completed the deposit switch request.  `error`: There was an error processing the deposit switch request.  For more information, see the [Deposit Switch API reference](/docs/deposit-switch/reference#deposit_switchget).
     * @type {string}
     * @memberof DepositSwitchStateUpdateWebhook
     */
    state?: string;
    /**
     * The ID of the deposit switch.
     * @type {string}
     * @memberof DepositSwitchStateUpdateWebhook
     */
    deposit_switch_id?: string;
}
/**
 * The deposit switch destination account
 * @export
 * @interface DepositSwitchTargetAccount
 */
export interface DepositSwitchTargetAccount {
    [key: string]: object | any;
    /**
     * Account number for deposit switch destination
     * @type {string}
     * @memberof DepositSwitchTargetAccount
     */
    account_number: string;
    /**
     * Routing number for deposit switch destination
     * @type {string}
     * @memberof DepositSwitchTargetAccount
     */
    routing_number: string;
    /**
     * The name of the deposit switch destination account, as it will be displayed to the end user in the Deposit Switch interface. It is not required to match the name used in online banking.
     * @type {string}
     * @memberof DepositSwitchTargetAccount
     */
    account_name: string;
    /**
     * The account subtype of the account, either `checking` or `savings`.
     * @type {string}
     * @memberof DepositSwitchTargetAccount
     */
    account_subtype: DepositSwitchTargetAccountAccountSubtypeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum DepositSwitchTargetAccountAccountSubtypeEnum {
    Checking = "checking",
    Savings = "savings"
}
/**
 * The deposit switch target user
 * @export
 * @interface DepositSwitchTargetUser
 */
export interface DepositSwitchTargetUser {
    [key: string]: object | any;
    /**
     * The given name (first name) of the user.
     * @type {string}
     * @memberof DepositSwitchTargetUser
     */
    given_name: string;
    /**
     * The family name (last name) of the user.
     * @type {string}
     * @memberof DepositSwitchTargetUser
     */
    family_name: string;
    /**
     * The phone number of the user. The endpoint can accept a variety of phone number formats, including E.164.
     * @type {string}
     * @memberof DepositSwitchTargetUser
     */
    phone: string;
    /**
     * The email address of the user.
     * @type {string}
     * @memberof DepositSwitchTargetUser
     */
    email: string;
    /**
     *
     * @type {DepositSwitchAddressData}
     * @memberof DepositSwitchTargetUser
     */
    address?: DepositSwitchAddressData;
    /**
     * The taxpayer ID of the user, generally their SSN, EIN, or TIN.
     * @type {string}
     * @memberof DepositSwitchTargetUser
     */
    tax_payer_id?: string;
}
/**
 * DepositSwitchTokenCreateRequest defines the request schema for `/deposit_switch/token/create`
 * @export
 * @interface DepositSwitchTokenCreateRequest
 */
export interface DepositSwitchTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof DepositSwitchTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof DepositSwitchTokenCreateRequest
     */
    secret?: string;
    /**
     * The ID of the deposit switch
     * @type {string}
     * @memberof DepositSwitchTokenCreateRequest
     */
    deposit_switch_id: string;
}
/**
 * DepositSwitchTokenCreateResponse defines the response schema for `/deposit_switch/token/create`
 * @export
 * @interface DepositSwitchTokenCreateResponse
 */
export interface DepositSwitchTokenCreateResponse {
    [key: string]: object | any;
    /**
     * Deposit switch token, used to initialize Link for the Deposit Switch product
     * @type {string}
     * @memberof DepositSwitchTokenCreateResponse
     */
    deposit_switch_token: string;
    /**
     * Expiration time of the token, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format
     * @type {string}
     * @memberof DepositSwitchTokenCreateResponse
     */
    deposit_switch_token_expiration_time: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof DepositSwitchTokenCreateResponse
     */
    request_id: string;
}
/**
 * Valid account subtypes for depository accounts. For a list containing descriptions of each subtype, see [Account schemas](https://plaid.com/docs/api/accounts/#StandaloneAccountType-depository).
 * @export
 * @enum {string}
 */
export declare enum DepositoryAccountSubtype {
    Checking = "checking",
    Savings = "savings",
    Hsa = "hsa",
    Cd = "cd",
    MoneyMarket = "money market",
    Paypal = "paypal",
    Prepaid = "prepaid",
    CashManagement = "cash management",
    Ebt = "ebt",
    All = "all"
}
/**
 * A filter to apply to `depository`-type accounts
 * @export
 * @interface DepositoryFilter
 */
export interface DepositoryFilter {
    [key: string]: object | any;
    /**
     * An array of account subtypes to display in Link. If not specified, all account subtypes will be shown. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).
     * @type {Array<DepositoryAccountSubtype>}
     * @memberof DepositoryFilter
     */
    account_subtypes: Array<DepositoryAccountSubtype>;
}
/**
 * Information about the accounts that the payment was distributed to.
 * @export
 * @interface DistributionBreakdown
 */
export interface DistributionBreakdown {
    [key: string]: object | any;
    /**
     * Name of the account for the given distribution.
     * @type {string}
     * @memberof DistributionBreakdown
     */
    account_name?: string | null;
    /**
     * The name of the bank that the payment is being deposited to.
     * @type {string}
     * @memberof DistributionBreakdown
     */
    bank_name?: string | null;
    /**
     * The amount distributed to this account.
     * @type {number}
     * @memberof DistributionBreakdown
     */
    current_amount?: number | null;
    /**
     * The ISO-4217 currency code of the net pay. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof DistributionBreakdown
     */
    iso_currency_code?: string | null;
    /**
     * The last 2-4 alphanumeric characters of an account\'s official account number.
     * @type {string}
     * @memberof DistributionBreakdown
     */
    mask?: string | null;
    /**
     * Type of the account that the paystub was sent to (e.g. \'checking\').
     * @type {string}
     * @memberof DistributionBreakdown
     */
    type?: string | null;
    /**
     * The unofficial currency code associated with the net pay. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof DistributionBreakdown
     */
    unofficial_currency_code?: string | null;
    /**
     *
     * @type {Pay}
     * @memberof DistributionBreakdown
     * @deprecated
     */
    current_pay?: Pay;
}
/**
 * The type of document.  `DOCUMENT_TYPE_PAYSTUB`: A paystub.  `DOCUMENT_TYPE_BANK_STATEMENT`: A bank statement.  `DOCUMENT_TYPE_US_TAX_W2`: A W-2 wage and tax statement provided by a US employer reflecting wages earned by the employee.  `DOCUMENT_TYPE_US_MILITARY_ERAS`: An electronic Retirement Account Statement (eRAS) issued by the US military.  `DOCUMENT_TYPE_US_MILITARY_LES`: A Leave and Earnings Statement (LES) issued by the US military.  `DOCUMENT_TYPE_US_MILITARY_CLES`: A Civilian Leave and Earnings Statment (CLES) issued by the US military.  `DOCUMENT_TYPE_GIG`: Used to indicate that the income is related to gig work. Does not necessarily correspond to a specific document type.  `DOCUMENT_TYPE_NONE`: Used to indicate that there is no underlying document for the data.  `UNKNOWN`: Document type could not be determined.
 * @export
 * @enum {string}
 */
export declare enum DocType {
    Unknown = "UNKNOWN",
    DocumentTypePaystub = "DOCUMENT_TYPE_PAYSTUB",
    DocumentTypeBankStatement = "DOCUMENT_TYPE_BANK_STATEMENT",
    DocumentTypeUsTaxW2 = "DOCUMENT_TYPE_US_TAX_W2",
    DocumentTypeUsMilitaryEras = "DOCUMENT_TYPE_US_MILITARY_ERAS",
    DocumentTypeUsMilitaryLes = "DOCUMENT_TYPE_US_MILITARY_LES",
    DocumentTypeUsMilitaryCles = "DOCUMENT_TYPE_US_MILITARY_CLES",
    DocumentTypeGig = "DOCUMENT_TYPE_GIG",
    DocumentTypeNone = "DOCUMENT_TYPE_NONE"
}
/**
 * An object representing metadata from the end user\'s uploaded document.
 * @export
 * @interface DocumentMetadata
 */
export interface DocumentMetadata {
    [key: string]: object | any;
    /**
     * The name of the document.
     * @type {string}
     * @memberof DocumentMetadata
     */
    name?: string;
    /**
     * The processing status of the document.
     * @type {string}
     * @memberof DocumentMetadata
     */
    status?: string;
    /**
     * An identifier of the document that is also present in the paystub response.
     * @type {string}
     * @memberof DocumentMetadata
     */
    doc_id?: string;
    /**
     *
     * @type {DocType}
     * @memberof DocumentMetadata
     */
    doc_type?: DocType;
}
/**
 * An object representing both a breakdown of earnings on a paystub and the total earnings.
 * @export
 * @interface Earnings
 */
export interface Earnings {
    [key: string]: object | any;
    /**
     *
     * @type {Array<EarningsTotal>}
     * @memberof Earnings
     * @deprecated
     */
    subtotals?: Array<EarningsTotal>;
    /**
     *
     * @type {Array<EarningsTotal>}
     * @memberof Earnings
     * @deprecated
     */
    totals?: Array<EarningsTotal>;
    /**
     *
     * @type {Array<EarningsBreakdown>}
     * @memberof Earnings
     */
    breakdown?: Array<EarningsBreakdown>;
    /**
     *
     * @type {EarningsTotal}
     * @memberof Earnings
     */
    total?: EarningsTotal;
}
/**
 * An object representing the earnings line items for the pay period.
 * @export
 * @interface EarningsBreakdown
 */
export interface EarningsBreakdown {
    [key: string]: object | any;
    /**
     *
     * @type {EarningsBreakdownCanonicalDescription}
     * @memberof EarningsBreakdown
     */
    canonical_description?: EarningsBreakdownCanonicalDescription | null;
    /**
     * Raw amount of the earning line item.
     * @type {number}
     * @memberof EarningsBreakdown
     */
    current_amount?: number | null;
    /**
     * Description of the earning line item.
     * @type {string}
     * @memberof EarningsBreakdown
     */
    description?: string | null;
    /**
     * Number of hours applicable for this earning.
     * @type {number}
     * @memberof EarningsBreakdown
     */
    hours?: number | null;
    /**
     * The ISO-4217 currency code of the line item. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof EarningsBreakdown
     */
    iso_currency_code?: string | null;
    /**
     * Hourly rate applicable for this earning.
     * @type {number}
     * @memberof EarningsBreakdown
     */
    rate?: number | null;
    /**
     * The unofficial currency code associated with the line item. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof EarningsBreakdown
     */
    unofficial_currency_code?: string | null;
    /**
     * The year-to-date amount of the deduction.
     * @type {number}
     * @memberof EarningsBreakdown
     */
    ytd_amount?: number | null;
}
/**
 * Commonly used term to describe the earning line item.
 * @export
 * @enum {string}
 */
export declare enum EarningsBreakdownCanonicalDescription {
    Bonus = "BONUS",
    Commission = "COMMISSION",
    Overtime = "OVERTIME",
    PaidTimeOff = "PAID TIME OFF",
    RegularPay = "REGULAR PAY",
    Vacation = "VACATION",
    BasicAllowanceHousing = "BASIC ALLOWANCE HOUSING",
    BasicAllowanceSubsistence = "BASIC ALLOWANCE SUBSISTENCE",
    Other = "OTHER",
    Null = "null"
}
/**
 * An object representing both the current pay period and year to date amount for an earning category.
 * @export
 * @interface EarningsTotal
 */
export interface EarningsTotal {
    [key: string]: object | any;
    /**
     * Total amount of the earnings for this pay period
     * @type {number}
     * @memberof EarningsTotal
     */
    current_amount?: number | null;
    /**
     *
     * @type {Pay}
     * @memberof EarningsTotal
     * @deprecated
     */
    current_pay?: Pay;
    /**
     *
     * @type {Pay}
     * @memberof EarningsTotal
     * @deprecated
     */
    ytd_pay?: Pay;
    /**
     * Total number of hours worked for this pay period
     * @type {number}
     * @memberof EarningsTotal
     */
    hours?: number | null;
    /**
     * The ISO-4217 currency code of the line item. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof EarningsTotal
     */
    iso_currency_code?: string | null;
    /**
     * The unofficial currency code associated with the security. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof EarningsTotal
     */
    unofficial_currency_code?: string | null;
    /**
     * The total year-to-date amount of the earnings
     * @type {number}
     * @memberof EarningsTotal
     */
    ytd_amount?: number | null;
}
/**
 * An object representing an email address
 * @export
 * @interface Email
 */
export interface Email {
    [key: string]: object | any;
    /**
     * The email address.
     * @type {string}
     * @memberof Email
     */
    data: string;
    /**
     * When `true`, identifies the email address as the primary email on an account.
     * @type {boolean}
     * @memberof Email
     */
    primary: boolean;
    /**
     * The type of email account as described by the financial institution.
     * @type {string}
     * @memberof Email
     */
    type: EmailTypeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum EmailTypeEnum {
    Primary = "primary",
    Secondary = "secondary",
    Other = "other"
}
/**
 * Data about the employee.
 * @export
 * @interface Employee
 */
export interface Employee {
    [key: string]: object | any;
    /**
     *
     * @type {PaystubAddress}
     * @memberof Employee
     */
    address: PaystubAddress;
    /**
     * The name of the employee.
     * @type {string}
     * @memberof Employee
     */
    name: string | null;
    /**
     * Marital status of the employee - either `single` or `married`.
     * @type {string}
     * @memberof Employee
     */
    marital_status?: string | null;
    /**
     *
     * @type {TaxpayerID}
     * @memberof Employee
     */
    taxpayer_id?: TaxpayerID;
}
/**
 * The name of the employee, as reported on the paystub.
 * @export
 * @interface EmployeeIncomeSummaryFieldString
 */
export interface EmployeeIncomeSummaryFieldString {
    /**
     * The value of the field.
     * @type {string}
     * @memberof EmployeeIncomeSummaryFieldString
     */
    value: string;
    /**
     *
     * @type {VerificationStatus}
     * @memberof EmployeeIncomeSummaryFieldString
     */
    verification_status: VerificationStatus;
}
/**
 * Data about the employer.
 * @export
 * @interface Employer
 */
export interface Employer {
    [key: string]: object | any;
    /**
     * Plaid\'s unique identifier for the employer.
     * @type {string}
     * @memberof Employer
     */
    employer_id: string;
    /**
     * The name of the employer
     * @type {string}
     * @memberof Employer
     */
    name: string;
    /**
     *
     * @type {AddressDataNullable}
     * @memberof Employer
     */
    address: AddressDataNullable | null;
    /**
     * A number from 0 to 1 indicating Plaid\'s level of confidence in the pairing between the employer and the institution (not yet implemented).
     * @type {number}
     * @memberof Employer
     */
    confidence_score: number;
}
/**
 * The name of the employer, as reported on the paystub.
 * @export
 * @interface EmployerIncomeSummaryFieldString
 */
export interface EmployerIncomeSummaryFieldString {
    /**
     * The value of the field.
     * @type {string}
     * @memberof EmployerIncomeSummaryFieldString
     */
    value: string;
    /**
     *
     * @type {VerificationStatus}
     * @memberof EmployerIncomeSummaryFieldString
     */
    verification_status: VerificationStatus;
}
/**
 * An object containing employer data.
 * @export
 * @interface EmployerVerification
 */
export interface EmployerVerification {
    [key: string]: object | any;
    /**
     * Name of employer.
     * @type {string}
     * @memberof EmployerVerification
     */
    name?: string | null;
}
/**
 * EmployersSearchRequest defines the request schema for `/employers/search`.
 * @export
 * @interface EmployersSearchRequest
 */
export interface EmployersSearchRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof EmployersSearchRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof EmployersSearchRequest
     */
    secret?: string;
    /**
     * The employer name to be searched for.
     * @type {string}
     * @memberof EmployersSearchRequest
     */
    query: string;
    /**
     * The Plaid products the returned employers should support. Currently, this field must be set to `\"deposit_switch\"`.
     * @type {Array<string>}
     * @memberof EmployersSearchRequest
     */
    products: Array<string>;
}
/**
 * EmployersSearchResponse defines the response schema for `/employers/search`.
 * @export
 * @interface EmployersSearchResponse
 */
export interface EmployersSearchResponse {
    [key: string]: object | any;
    /**
     * A list of employers matching the search criteria.
     * @type {Array<Employer>}
     * @memberof EmployersSearchResponse
     */
    employers: Array<Employer>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof EmployersSearchResponse
     */
    request_id: string;
}
/**
 * An object representing employment details found on a paystub.
 * @export
 * @interface EmploymentDetails
 */
export interface EmploymentDetails {
    [key: string]: object | any;
    /**
     *
     * @type {Pay}
     * @memberof EmploymentDetails
     * @deprecated
     */
    annual_salary?: Pay;
    /**
     * Date on which the employee was hired, in the YYYY-MM-DD format.
     * @type {string}
     * @memberof EmploymentDetails
     */
    hire_date?: string | null;
}
/**
 * An object containing proof of employment data for an individual
 * @export
 * @interface EmploymentVerification
 */
export interface EmploymentVerification {
    [key: string]: object | any;
    /**
     *
     * @type {EmploymentVerificationStatus}
     * @memberof EmploymentVerification
     */
    status?: EmploymentVerificationStatus | null;
    /**
     * Start of employment in ISO 8601 format (YYYY-MM-DD).
     * @type {string}
     * @memberof EmploymentVerification
     */
    start_date?: string | null;
    /**
     * End of employment, if applicable. Provided in ISO 8601 format (YYY-MM-DD).
     * @type {string}
     * @memberof EmploymentVerification
     */
    end_date?: string | null;
    /**
     *
     * @type {EmployerVerification}
     * @memberof EmploymentVerification
     */
    employer?: EmployerVerification;
    /**
     * Current title of employee.
     * @type {string}
     * @memberof EmploymentVerification
     */
    title?: string | null;
    /**
     *
     * @type {PlatformIds}
     * @memberof EmploymentVerification
     */
    platform_ids?: PlatformIds;
}
/**
 * EmploymentVerificationGetRequest defines the request schema for `/employment/verification/get`.
 * @export
 * @interface EmploymentVerificationGetRequest
 */
export interface EmploymentVerificationGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof EmploymentVerificationGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof EmploymentVerificationGetRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof EmploymentVerificationGetRequest
     */
    access_token: string;
}
/**
 * EmploymentVerificationGetResponse defines the response schema for `/employment/verification/get`.
 * @export
 * @interface EmploymentVerificationGetResponse
 */
export interface EmploymentVerificationGetResponse {
    [key: string]: object | any;
    /**
     * A list of employment verification summaries.
     * @type {Array<EmploymentVerification>}
     * @memberof EmploymentVerificationGetResponse
     */
    employments: Array<EmploymentVerification>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof EmploymentVerificationGetResponse
     */
    request_id: string;
}
/**
 * Current employment status.
 * @export
 * @enum {string}
 */
export declare enum EmploymentVerificationStatus {
    EmploymentStatusActive = "EMPLOYMENT_STATUS_ACTIVE",
    EmploymentStatusInactive = "EMPLOYMENT_STATUS_INACTIVE",
    Null = "null"
}
/**
 * Additional payment options
 * @export
 * @interface ExternalPaymentOptions
 */
export interface ExternalPaymentOptions {
    [key: string]: object | any;
    /**
     * When `true`, Plaid will attempt to request refund details from the payee\'s financial institution.  Support varies between financial institutions and will not always be available.  If refund details could be retrieved, they will be available in the `/payment_initiation/payment/get` response.
     * @type {boolean}
     * @memberof ExternalPaymentOptions
     */
    request_refund_details?: boolean | null;
    /**
     * The International Bank Account Number (IBAN) for the payer\'s account. If provided, the end user will be able to send payments only from the specified bank account.
     * @type {string}
     * @memberof ExternalPaymentOptions
     */
    iban?: string | null;
    /**
     *
     * @type {PaymentInitiationOptionalRestrictionBacs}
     * @memberof ExternalPaymentOptions
     */
    bacs?: PaymentInitiationOptionalRestrictionBacs | null;
    /**
     * The EMI (E-Money Institution) wallet that this payment is associated with, if any. This wallet is used as an intermediary account to enable Plaid to reconcile the settlement of funds for Payment Initiation requests.
     * @type {string}
     * @memberof ExternalPaymentOptions
     */
    wallet_id?: string | null;
    /**
     *
     * @type {PaymentScheme}
     * @memberof ExternalPaymentOptions
     */
    scheme?: PaymentScheme | null;
}
/**
 * Details about external payment refund
 * @export
 * @interface ExternalPaymentRefundDetails
 */
export interface ExternalPaymentRefundDetails {
    /**
     * The name of the account holder.
     * @type {string}
     * @memberof ExternalPaymentRefundDetails
     */
    name: string;
    /**
     * The International Bank Account Number (IBAN) for the account.
     * @type {string}
     * @memberof ExternalPaymentRefundDetails
     */
    iban: string | null;
    /**
     *
     * @type {RecipientBACSNullable}
     * @memberof ExternalPaymentRefundDetails
     */
    bacs: RecipientBACSNullable | null;
}
/**
 * The schedule that the payment will be executed on. If a schedule is provided, the payment is automatically set up as a standing order. If no schedule is specified, the payment will be executed only once.
 * @export
 * @interface ExternalPaymentScheduleBase
 */
export interface ExternalPaymentScheduleBase {
    [key: string]: object | any;
    /**
     *
     * @type {PaymentScheduleInterval}
     * @memberof ExternalPaymentScheduleBase
     */
    interval?: PaymentScheduleInterval;
    /**
     * The day of the interval on which to schedule the payment.  If the payment interval is weekly, `interval_execution_day` should be an integer from 1 (Monday) to 7 (Sunday).  If the payment interval is monthly, `interval_execution_day` should be an integer indicating which day of the month to make the payment on. Integers from 1 to 28 can be used to make a payment on that day of the month. Negative integers from -1 to -5 can be used to make a payment relative to the end of the month. To make a payment on the last day of the month, use -1; to make the payment on the second-to-last day, use -2, and so on.
     * @type {number}
     * @memberof ExternalPaymentScheduleBase
     */
    interval_execution_day?: number;
    /**
     * A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Standing order payments will begin on the first `interval_execution_day` on or after the `start_date`.  If the first `interval_execution_day` on or after the start date is also the same day that `/payment_initiation/payment/create` was called, the bank *may* make the first payment on that day, but it is not guaranteed to do so.
     * @type {string}
     * @memberof ExternalPaymentScheduleBase
     */
    start_date?: string;
    /**
     * A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Standing order payments will end on the last `interval_execution_day` on or before the `end_date`. If the only `interval_execution_day` between the start date and the end date (inclusive) is also the same day that `/payment_initiation/payment/create` was called, the bank *may* make a payment on that day, but it is not guaranteed to do so.
     * @type {string}
     * @memberof ExternalPaymentScheduleBase
     */
    end_date?: string | null;
    /**
     * The start date sent to the bank after adjusting for holidays or weekends.  Will be provided in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). If the start date did not require adjustment, this field will be `null`.
     * @type {string}
     * @memberof ExternalPaymentScheduleBase
     */
    adjusted_start_date?: string | null;
}
/**
 * The schedule that the payment will be executed on. If a schedule is provided, the payment is automatically set up as a standing order. If no schedule is specified, the payment will be executed only once.
 * @export
 * @interface ExternalPaymentScheduleGet
 */
export interface ExternalPaymentScheduleGet {
    /**
     *
     * @type {PaymentScheduleInterval}
     * @memberof ExternalPaymentScheduleGet
     */
    interval: PaymentScheduleInterval;
    /**
     * The day of the interval on which to schedule the payment.  If the payment interval is weekly, `interval_execution_day` should be an integer from 1 (Monday) to 7 (Sunday).  If the payment interval is monthly, `interval_execution_day` should be an integer indicating which day of the month to make the payment on. Integers from 1 to 28 can be used to make a payment on that day of the month. Negative integers from -1 to -5 can be used to make a payment relative to the end of the month. To make a payment on the last day of the month, use -1; to make the payment on the second-to-last day, use -2, and so on.
     * @type {number}
     * @memberof ExternalPaymentScheduleGet
     */
    interval_execution_day: number;
    /**
     * A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Standing order payments will begin on the first `interval_execution_day` on or after the `start_date`.  If the first `interval_execution_day` on or after the start date is also the same day that `/payment_initiation/payment/create` was called, the bank *may* make the first payment on that day, but it is not guaranteed to do so.
     * @type {string}
     * @memberof ExternalPaymentScheduleGet
     */
    start_date: string;
    /**
     * A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Standing order payments will end on the last `interval_execution_day` on or before the `end_date`. If the only `interval_execution_day` between the start date and the end date (inclusive) is also the same day that `/payment_initiation/payment/create` was called, the bank *may* make a payment on that day, but it is not guaranteed to do so.
     * @type {string}
     * @memberof ExternalPaymentScheduleGet
     */
    end_date: string | null;
    /**
     * The start date sent to the bank after adjusting for holidays or weekends.  Will be provided in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). If the start date did not require adjustment, this field will be `null`.
     * @type {string}
     * @memberof ExternalPaymentScheduleGet
     */
    adjusted_start_date: string | null;
}
/**
 * The schedule that the payment will be executed on. If a schedule is provided, the payment is automatically set up as a standing order. If no schedule is specified, the payment will be executed only once.
 * @export
 * @interface ExternalPaymentScheduleRequest
 */
export interface ExternalPaymentScheduleRequest {
    /**
     *
     * @type {PaymentScheduleInterval}
     * @memberof ExternalPaymentScheduleRequest
     */
    interval: PaymentScheduleInterval;
    /**
     * The day of the interval on which to schedule the payment.  If the payment interval is weekly, `interval_execution_day` should be an integer from 1 (Monday) to 7 (Sunday).  If the payment interval is monthly, `interval_execution_day` should be an integer indicating which day of the month to make the payment on. Integers from 1 to 28 can be used to make a payment on that day of the month. Negative integers from -1 to -5 can be used to make a payment relative to the end of the month. To make a payment on the last day of the month, use -1; to make the payment on the second-to-last day, use -2, and so on.
     * @type {number}
     * @memberof ExternalPaymentScheduleRequest
     */
    interval_execution_day: number;
    /**
     * A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Standing order payments will begin on the first `interval_execution_day` on or after the `start_date`.  If the first `interval_execution_day` on or after the start date is also the same day that `/payment_initiation/payment/create` was called, the bank *may* make the first payment on that day, but it is not guaranteed to do so.
     * @type {string}
     * @memberof ExternalPaymentScheduleRequest
     */
    start_date: string;
    /**
     * A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Standing order payments will end on the last `interval_execution_day` on or before the `end_date`. If the only `interval_execution_day` between the start date and the end date (inclusive) is also the same day that `/payment_initiation/payment/create` was called, the bank *may* make a payment on that day, but it is not guaranteed to do so.
     * @type {string}
     * @memberof ExternalPaymentScheduleRequest
     */
    end_date?: string | null;
    /**
     * The start date sent to the bank after adjusting for holidays or weekends.  Will be provided in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). If the start date did not require adjustment, this field will be `null`.
     * @type {string}
     * @memberof ExternalPaymentScheduleRequest
     */
    adjusted_start_date?: string | null;
}
/**
 * A status health incident
 * @export
 * @interface HealthIncident
 */
export interface HealthIncident {
    [key: string]: object | any;
    /**
     * The start date of the incident, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format, e.g. `\"2020-10-30T15:26:48Z\"`.
     * @type {string}
     * @memberof HealthIncident
     */
    start_date: string;
    /**
     * The end date of the incident, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format, e.g. `\"2020-10-30T15:26:48Z\"`.
     * @type {string}
     * @memberof HealthIncident
     */
    end_date?: string;
    /**
     * The title of the incident
     * @type {string}
     * @memberof HealthIncident
     */
    title: string;
    /**
     * Updates on the health incident.
     * @type {Array<IncidentUpdate>}
     * @memberof HealthIncident
     */
    incident_updates: Array<IncidentUpdate>;
}
/**
 * An object representing a balance held by an account in the past
 * @export
 * @interface HistoricalBalance
 */
export interface HistoricalBalance {
    [key: string]: object | any;
    /**
     * The date of the calculated historical balance, in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD)
     * @type {string}
     * @memberof HistoricalBalance
     */
    date: string;
    /**
     * The total amount of funds in the account, calculated from the `current` balance in the `balance` object by subtracting inflows and adding back outflows according to the posted date of each transaction.  If the account has any pending transactions, historical balance amounts on or after the date of the earliest pending transaction may differ if retrieved in subsequent Asset Reports as a result of those pending transactions posting.
     * @type {number}
     * @memberof HistoricalBalance
     */
    current: number;
    /**
     * The ISO-4217 currency code of the balance. Always `null` if `unofficial_currency_code` is non-`null`.
     * @type {string}
     * @memberof HistoricalBalance
     */
    iso_currency_code: string | null;
    /**
     * The unofficial currency code associated with the balance. Always `null` if `iso_currency_code` is non-`null`.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof HistoricalBalance
     */
    unofficial_currency_code: string | null;
}
/**
 * Fired when an Item\'s historical transaction pull is completed and Plaid has prepared as much historical transaction data as possible for the Item. Once this webhook has been fired, transaction data beyond the most recent 30 days can be fetched for the Item. If [Account Select v2](https://plaid.com/docs/link/customization/#account-select) is enabled, this webhook will also be fired if account selections for the Item are updated, with `new_transactions` set to the number of net new transactions pulled after the account selection update.
 * @export
 * @interface HistoricalUpdateWebhook
 */
export interface HistoricalUpdateWebhook {
    [key: string]: object | any;
    /**
     * `TRANSACTIONS`
     * @type {string}
     * @memberof HistoricalUpdateWebhook
     */
    webhook_type: string;
    /**
     * `HISTORICAL_UPDATE`
     * @type {string}
     * @memberof HistoricalUpdateWebhook
     */
    webhook_code: string;
    /**
     *
     * @type {PlaidError}
     * @memberof HistoricalUpdateWebhook
     */
    error?: PlaidError;
    /**
     * The number of new, unfetched transactions available
     * @type {number}
     * @memberof HistoricalUpdateWebhook
     */
    new_transactions: number;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof HistoricalUpdateWebhook
     */
    item_id: string;
}
/**
 * A securities holding at an institution.
 * @export
 * @interface Holding
 */
export interface Holding {
    [key: string]: object | any;
    /**
     * The Plaid `account_id` associated with the holding.
     * @type {string}
     * @memberof Holding
     */
    account_id: string;
    /**
     * The Plaid `security_id` associated with the holding.
     * @type {string}
     * @memberof Holding
     */
    security_id: string;
    /**
     * The last price given by the institution for this security.
     * @type {number}
     * @memberof Holding
     */
    institution_price: number;
    /**
     * The date at which `institution_price` was current.
     * @type {string}
     * @memberof Holding
     */
    institution_price_as_of: string | null;
    /**
     * The value of the holding, as reported by the institution.
     * @type {number}
     * @memberof Holding
     */
    institution_value: number;
    /**
     * The cost basis of the holding.
     * @type {number}
     * @memberof Holding
     */
    cost_basis: number | null;
    /**
     * The total quantity of the asset held, as reported by the financial institution. If the security is an option, `quantity` will reflect the total number of options (typically the number of contracts multiplied by 100), not the number of contracts.
     * @type {number}
     * @memberof Holding
     */
    quantity: number;
    /**
     * The ISO-4217 currency code of the holding. Always `null` if `unofficial_currency_code` is non-`null`.
     * @type {string}
     * @memberof Holding
     */
    iso_currency_code: string | null;
    /**
     * The unofficial currency code associated with the holding. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof Holding
     */
    unofficial_currency_code: string | null;
}
/**
 * Fired when new or updated holdings have been detected on an investment account. The webhook typically fires once per day, after market close, in response to any newly added holdings or price changes to existing holdings.
 * @export
 * @interface HoldingsDefaultUpdateWebhook
 */
export interface HoldingsDefaultUpdateWebhook {
    [key: string]: object | any;
    /**
     * `HOLDINGS`
     * @type {string}
     * @memberof HoldingsDefaultUpdateWebhook
     */
    webhook_type: string;
    /**
     * `DEFAULT_UPDATE`
     * @type {string}
     * @memberof HoldingsDefaultUpdateWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof HoldingsDefaultUpdateWebhook
     */
    item_id: string;
    /**
     *
     * @type {PlaidError}
     * @memberof HoldingsDefaultUpdateWebhook
     */
    error?: PlaidError;
    /**
     * The number of new holdings reported since the last time this webhook was fired.
     * @type {number}
     * @memberof HoldingsDefaultUpdateWebhook
     */
    new_holdings: number;
    /**
     * The number of updated holdings reported since the last time this webhook was fired.
     * @type {number}
     * @memberof HoldingsDefaultUpdateWebhook
     */
    updated_holdings: number;
}
/**
 * Specify the holdings on the account.
 * @export
 * @interface HoldingsOverride
 */
export interface HoldingsOverride {
    /**
     * The last price given by the institution for this security
     * @type {number}
     * @memberof HoldingsOverride
     */
    institution_price: number;
    /**
     * The date at which `institution_price` was current. Must be formatted as an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) date.
     * @type {string}
     * @memberof HoldingsOverride
     */
    institution_price_as_of?: string;
    /**
     * The average original value of the holding. Multiple cost basis values for the same security purchased at different prices are not supported.
     * @type {number}
     * @memberof HoldingsOverride
     */
    cost_basis?: number;
    /**
     * The total quantity of the asset held, as reported by the financial institution.
     * @type {number}
     * @memberof HoldingsOverride
     */
    quantity: number;
    /**
     * Either a valid `iso_currency_code` or `unofficial_currency_code`
     * @type {string}
     * @memberof HoldingsOverride
     */
    currency: string;
    /**
     *
     * @type {SecurityOverride}
     * @memberof HoldingsOverride
     */
    security: SecurityOverride;
}
/**
 * IdentityGetRequest defines the request schema for `/identity/get`
 * @export
 * @interface IdentityGetRequest
 */
export interface IdentityGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IdentityGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IdentityGetRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof IdentityGetRequest
     */
    access_token: string;
    /**
     *
     * @type {IdentityGetRequestOptions}
     * @memberof IdentityGetRequest
     */
    options?: IdentityGetRequestOptions;
}
/**
 * An optional object to filter `/identity/get` results.
 * @export
 * @interface IdentityGetRequestOptions
 */
export interface IdentityGetRequestOptions {
    /**
     * A list of `account_ids` to retrieve for the Item. Note: An error will be returned if a provided `account_id` is not associated with the Item.
     * @type {Array<string>}
     * @memberof IdentityGetRequestOptions
     */
    account_ids?: Array<string>;
}
/**
 * IdentityGetResponse defines the response schema for `/identity/get`
 * @export
 * @interface IdentityGetResponse
 */
export interface IdentityGetResponse {
    [key: string]: object | any;
    /**
     * The accounts for which Identity data has been requested
     * @type {Array<AccountIdentity>}
     * @memberof IdentityGetResponse
     */
    accounts: Array<AccountIdentity>;
    /**
     *
     * @type {Item}
     * @memberof IdentityGetResponse
     */
    item: Item;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof IdentityGetResponse
     */
    request_id: string;
}
/**
 * An update on the health incident
 * @export
 * @interface IncidentUpdate
 */
export interface IncidentUpdate {
    [key: string]: object | any;
    /**
     * The content of the update.
     * @type {string}
     * @memberof IncidentUpdate
     */
    description?: string;
    /**
     * The status of the incident.
     * @type {string}
     * @memberof IncidentUpdate
     */
    status?: IncidentUpdateStatusEnum;
    /**
     * The date when the update was published, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format, e.g. `\"2020-10-30T15:26:48Z\"`.
     * @type {string}
     * @memberof IncidentUpdate
     */
    updated_date?: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum IncidentUpdateStatusEnum {
    Investigating = "INVESTIGATING",
    Identified = "IDENTIFIED",
    Scheduled = "SCHEDULED",
    Resolved = "RESOLVED",
    Unknown = "UNKNOWN"
}
/**
 * An object representing a breakdown of the different income types on the paystub.
 * @export
 * @interface IncomeBreakdown
 */
export interface IncomeBreakdown {
    [key: string]: object | any;
    /**
     *
     * @type {IncomeBreakdownType}
     * @memberof IncomeBreakdown
     */
    type: IncomeBreakdownType | null;
    /**
     * The hourly rate at which the income is paid.
     * @type {number}
     * @memberof IncomeBreakdown
     */
    rate: number | null;
    /**
     * The number of hours logged for this income for this pay period.
     * @type {number}
     * @memberof IncomeBreakdown
     */
    hours: number | null;
    /**
     * The total pay for this pay period.
     * @type {number}
     * @memberof IncomeBreakdown
     */
    total: number | null;
}
/**
 * The type of income. Possible values include:   `\"regular\"`: regular income   `\"overtime\"`: overtime income   `\"bonus\"`: bonus income
 * @export
 * @enum {string}
 */
export declare enum IncomeBreakdownType {
    Bonus = "bonus",
    Overtime = "overtime",
    Regular = "regular",
    Null = "null"
}
/**
 * Specify payroll data on the account.
 * @export
 * @interface IncomeOverride
 */
export interface IncomeOverride {
    /**
     * A list of paystubs associated with the account.
     * @type {Array<PaystubOverride>}
     * @memberof IncomeOverride
     */
    paystubs?: Array<PaystubOverride>;
}
/**
 * The verified fields from a paystub verification. All fields are provided as reported on the paystub.
 * @export
 * @interface IncomeSummary
 */
export interface IncomeSummary {
    [key: string]: object | any;
    /**
     *
     * @type {EmployerIncomeSummaryFieldString}
     * @memberof IncomeSummary
     */
    employer_name: EmployerIncomeSummaryFieldString;
    /**
     *
     * @type {EmployeeIncomeSummaryFieldString}
     * @memberof IncomeSummary
     */
    employee_name: EmployeeIncomeSummaryFieldString;
    /**
     *
     * @type {YTDGrossIncomeSummaryFieldNumber}
     * @memberof IncomeSummary
     */
    ytd_gross_income: YTDGrossIncomeSummaryFieldNumber;
    /**
     *
     * @type {YTDNetIncomeSummaryFieldNumber}
     * @memberof IncomeSummary
     */
    ytd_net_income: YTDNetIncomeSummaryFieldNumber;
    /**
     *
     * @type {PayFrequency}
     * @memberof IncomeSummary
     */
    pay_frequency: PayFrequency | null;
    /**
     *
     * @type {ProjectedIncomeSummaryFieldNumber}
     * @memberof IncomeSummary
     */
    projected_wage: ProjectedIncomeSummaryFieldNumber;
    /**
     *
     * @type {TransactionData}
     * @memberof IncomeSummary
     */
    verified_transaction: TransactionData | null;
}
/**
 * Field number for income summary
 * @export
 * @interface IncomeSummaryFieldNumber
 */
export interface IncomeSummaryFieldNumber {
    [key: string]: object | any;
    /**
     * The value of the field.
     * @type {number}
     * @memberof IncomeSummaryFieldNumber
     */
    value: number;
    /**
     *
     * @type {VerificationStatus}
     * @memberof IncomeSummaryFieldNumber
     */
    verification_status: VerificationStatus;
}
/**
 * Data about the income summary
 * @export
 * @interface IncomeSummaryFieldString
 */
export interface IncomeSummaryFieldString {
    [key: string]: object | any;
    /**
     * The value of the field.
     * @type {string}
     * @memberof IncomeSummaryFieldString
     */
    value: string;
    /**
     *
     * @type {VerificationStatus}
     * @memberof IncomeSummaryFieldString
     */
    verification_status: VerificationStatus;
}
/**
 * IncomeVerificationCreateRequest defines the request schema for `/income/verification/create`
 * @export
 * @interface IncomeVerificationCreateRequest
 */
export interface IncomeVerificationCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationCreateRequest
     */
    secret?: string;
    /**
     * The URL endpoint to which Plaid should send webhooks related to the progress of the income verification process.
     * @type {string}
     * @memberof IncomeVerificationCreateRequest
     */
    webhook: string;
    /**
     * The ID of a precheck created with `/income/verification/precheck`. Will be used to improve conversion of the income verification flow.
     * @type {string}
     * @memberof IncomeVerificationCreateRequest
     */
    precheck_id?: string;
    /**
     *
     * @type {IncomeVerificationCreateRequestOptions}
     * @memberof IncomeVerificationCreateRequest
     */
    options?: IncomeVerificationCreateRequestOptions;
}
/**
 * Optional arguments for `/income/verification/create`
 * @export
 * @interface IncomeVerificationCreateRequestOptions
 */
export interface IncomeVerificationCreateRequestOptions {
    /**
     * An array of access tokens corresponding to the Items that will be cross-referenced with the product data. Plaid will attempt to correlate transaction history from these Items with data from the user\'s paystub, such as date and amount. The `verification` status of the paystub as returned by `/income/verification/paystubs/get` will indicate if the verification status was successful, or, if not, why it failed. If the `transactions` product was not initialized for the Items during Link, it will be initialized after this Link session.
     * @type {Array<string>}
     * @memberof IncomeVerificationCreateRequestOptions
     */
    access_tokens?: Array<string>;
}
/**
 * IncomeVerificationCreateResponse defines the response schema for `/income/verification/create`.
 * @export
 * @interface IncomeVerificationCreateResponse
 */
export interface IncomeVerificationCreateResponse {
    [key: string]: object | any;
    /**
     * ID of the verification. This ID is persisted throughout the lifetime of the verification.
     * @type {string}
     * @memberof IncomeVerificationCreateResponse
     */
    income_verification_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof IncomeVerificationCreateResponse
     */
    request_id: string;
}
/**
 * IncomeVerificationDocumentsDownloadRequest defines the request schema for `/income/verification/documents/download`.
 * @export
 * @interface IncomeVerificationDocumentsDownloadRequest
 */
export interface IncomeVerificationDocumentsDownloadRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationDocumentsDownloadRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationDocumentsDownloadRequest
     */
    secret?: string;
    /**
     * The ID of the verification.
     * @type {string}
     * @memberof IncomeVerificationDocumentsDownloadRequest
     * @deprecated
     */
    income_verification_id?: string | null;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof IncomeVerificationDocumentsDownloadRequest
     */
    access_token?: string | null;
    /**
     * The document ID to download. If passed, a single document will be returned in the resulting zip file, rather than all document
     * @type {string}
     * @memberof IncomeVerificationDocumentsDownloadRequest
     */
    document_id?: string | null;
}
/**
 * IncomeVerificationPaystubGetRequest defines the request schema for `/income/verification/paystub/get`.
 * @export
 * @interface IncomeVerificationPaystubGetRequest
 */
export interface IncomeVerificationPaystubGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationPaystubGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationPaystubGetRequest
     */
    secret?: string;
    /**
     * The ID of the verification for which to get paystub information.
     * @type {string}
     * @memberof IncomeVerificationPaystubGetRequest
     * @deprecated
     */
    income_verification_id?: string | null;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof IncomeVerificationPaystubGetRequest
     */
    access_token?: string | null;
}
/**
 * IncomeVerificationPaystubGetResponse defines the response schema for `/income/verification/paystub/get`.
 * @export
 * @interface IncomeVerificationPaystubGetResponse
 */
export interface IncomeVerificationPaystubGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Paystub}
     * @memberof IncomeVerificationPaystubGetResponse
     */
    paystub: Paystub;
    /**
     *
     * @type {PlaidError}
     * @memberof IncomeVerificationPaystubGetResponse
     */
    error?: PlaidError;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof IncomeVerificationPaystubGetResponse
     */
    request_id: string;
}
/**
 * IncomeVerificationPaystubsGetRequest defines the request schema for `/income/verification/paystubs/get`.
 * @export
 * @interface IncomeVerificationPaystubsGetRequest
 */
export interface IncomeVerificationPaystubsGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationPaystubsGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationPaystubsGetRequest
     */
    secret?: string;
    /**
     * The ID of the verification for which to get paystub information.
     * @type {string}
     * @memberof IncomeVerificationPaystubsGetRequest
     * @deprecated
     */
    income_verification_id?: string | null;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof IncomeVerificationPaystubsGetRequest
     */
    access_token?: string | null;
}
/**
 * IncomeVerificationPaystubsGetResponse defines the response schema for `/income/verification/paystubs/get`.
 * @export
 * @interface IncomeVerificationPaystubsGetResponse
 */
export interface IncomeVerificationPaystubsGetResponse {
    [key: string]: object | any;
    /**
     * Metadata for an income document.
     * @type {Array<DocumentMetadata>}
     * @memberof IncomeVerificationPaystubsGetResponse
     */
    document_metadata?: Array<DocumentMetadata>;
    /**
     *
     * @type {Array<Paystub>}
     * @memberof IncomeVerificationPaystubsGetResponse
     */
    paystubs: Array<Paystub>;
    /**
     *
     * @type {PlaidError}
     * @memberof IncomeVerificationPaystubsGetResponse
     */
    error?: PlaidError;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof IncomeVerificationPaystubsGetResponse
     */
    request_id: string;
}
/**
 * The confidence that Plaid can support the user in the digital income verification flow instead of requiring a manual paystub upload. One of the following:  `\"HIGH\"`: It is very likely that this user can use the digital income verification flow.  \"`LOW`\": It is unlikely that this user can use the digital income verification flow.  `\"UNKNOWN\"`: It was not possible to determine if the user is supportable with the information passed.
 * @export
 * @enum {string}
 */
export declare enum IncomeVerificationPrecheckConfidence {
    High = "HIGH",
    Low = "LOW",
    Unknown = "UNKNOWN"
}
/**
 * Information about the end user\'s employer
 * @export
 * @interface IncomeVerificationPrecheckEmployer
 */
export interface IncomeVerificationPrecheckEmployer {
    /**
     * The employer\'s name
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployer
     */
    name?: string | null;
    /**
     *
     * @type {IncomeVerificationPrecheckEmployerAddress}
     * @memberof IncomeVerificationPrecheckEmployer
     */
    address?: IncomeVerificationPrecheckEmployerAddress | null;
    /**
     * The employer\'s tax id
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployer
     */
    tax_id?: string | null;
    /**
     * The URL for the employer\'s public website
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployer
     */
    url?: string | null;
}
/**
 * The address of the employer
 * @export
 * @interface IncomeVerificationPrecheckEmployerAddress
 */
export interface IncomeVerificationPrecheckEmployerAddress {
    /**
     * The full city name
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddress
     */
    city?: string;
    /**
     * The region or state. In API versions 2018-05-22 and earlier, this field is called `state`. Example: `\"NC\"`
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddress
     */
    region?: string;
    /**
     * The full street address Example: `\"564 Main Street, APT 15\"`
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddress
     */
    street?: string;
    /**
     * The postal code. In API versions 2018-05-22 and earlier, this field is called `zip`.
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddress
     */
    postal_code?: string;
    /**
     * The ISO 3166-1 alpha-2 country code
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddress
     */
    country?: string;
}
/**
 * Data about the components comprising an address.
 * @export
 * @interface IncomeVerificationPrecheckEmployerAddressData
 */
export interface IncomeVerificationPrecheckEmployerAddressData {
    [key: string]: object | any;
    /**
     * The full city name
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddressData
     */
    city?: string;
    /**
     * The region or state. In API versions 2018-05-22 and earlier, this field is called `state`. Example: `\"NC\"`
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddressData
     */
    region?: string;
    /**
     * The full street address Example: `\"564 Main Street, APT 15\"`
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddressData
     */
    street?: string;
    /**
     * The postal code. In API versions 2018-05-22 and earlier, this field is called `zip`.
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddressData
     */
    postal_code?: string;
    /**
     * The ISO 3166-1 alpha-2 country code
     * @type {string}
     * @memberof IncomeVerificationPrecheckEmployerAddressData
     */
    country?: string;
}
/**
 * Data about military info in the income verification precheck.
 * @export
 * @interface IncomeVerificationPrecheckMilitaryInfo
 */
export interface IncomeVerificationPrecheckMilitaryInfo {
    /**
     * Is the user currently active duty in the US military
     * @type {boolean}
     * @memberof IncomeVerificationPrecheckMilitaryInfo
     */
    is_active_duty?: boolean | null;
    /**
     * If the user is currently serving in the US military, the branch of the military they are serving in
     * @type {string}
     * @memberof IncomeVerificationPrecheckMilitaryInfo
     */
    branch?: IncomeVerificationPrecheckMilitaryInfoBranchEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum IncomeVerificationPrecheckMilitaryInfoBranchEnum {
    AirForce = "AIR FORCE",
    Army = "ARMY",
    CoastGuard = "COAST GUARD",
    Marines = "MARINES",
    Navy = "NAVY",
    Unknown = "UNKNOWN"
}
/**
 * IncomeVerificationPrecheckRequest defines the request schema for `/income/verification/precheck`
 * @export
 * @interface IncomeVerificationPrecheckRequest
 */
export interface IncomeVerificationPrecheckRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationPrecheckRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationPrecheckRequest
     */
    secret?: string;
    /**
     *
     * @type {IncomeVerificationPrecheckUser}
     * @memberof IncomeVerificationPrecheckRequest
     */
    user?: IncomeVerificationPrecheckUser | null;
    /**
     *
     * @type {IncomeVerificationPrecheckEmployer}
     * @memberof IncomeVerificationPrecheckRequest
     */
    employer?: IncomeVerificationPrecheckEmployer | null;
    /**
     *
     * @type {string}
     * @memberof IncomeVerificationPrecheckRequest
     * @deprecated
     */
    transactions_access_token?: string;
    /**
     * An array of access tokens corresponding to Items belonging to the user whose eligibility is being checked. Note that if the Items specified here are not already initialized with `transactions`, providing them in this field will cause these Items to be initialized with (and billed for) the Transactions product.
     * @type {Array<string>}
     * @memberof IncomeVerificationPrecheckRequest
     */
    transactions_access_tokens?: Array<string>;
    /**
     *
     * @type {IncomeVerificationPrecheckMilitaryInfo}
     * @memberof IncomeVerificationPrecheckRequest
     */
    us_military_info?: IncomeVerificationPrecheckMilitaryInfo | null;
}
/**
 * IncomeVerificationPrecheckResponse defines the response schema for `/income/verification/precheck`.
 * @export
 * @interface IncomeVerificationPrecheckResponse
 */
export interface IncomeVerificationPrecheckResponse {
    [key: string]: object | any;
    /**
     * ID of the precheck. Provide this value when calling `/link/token/create` in order to optimize Link conversion.
     * @type {string}
     * @memberof IncomeVerificationPrecheckResponse
     */
    precheck_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof IncomeVerificationPrecheckResponse
     */
    request_id: string;
    /**
     *
     * @type {IncomeVerificationPrecheckConfidence}
     * @memberof IncomeVerificationPrecheckResponse
     */
    confidence: IncomeVerificationPrecheckConfidence;
}
/**
 * Information about the user whose eligibility is being evaluated.
 * @export
 * @interface IncomeVerificationPrecheckUser
 */
export interface IncomeVerificationPrecheckUser {
    /**
     * The user\'s first name
     * @type {string}
     * @memberof IncomeVerificationPrecheckUser
     */
    first_name?: string | null;
    /**
     * The user\'s last name
     * @type {string}
     * @memberof IncomeVerificationPrecheckUser
     */
    last_name?: string | null;
    /**
     * The user\'s email address
     * @type {string}
     * @memberof IncomeVerificationPrecheckUser
     */
    email_address?: string | null;
    /**
     *
     * @type {SignalAddressData}
     * @memberof IncomeVerificationPrecheckUser
     */
    home_address?: SignalAddressData | null;
}
/**
 * IncomeVerificationRefreshRequest defines the request schema for `/income/verification/refresh`
 * @export
 * @interface IncomeVerificationRefreshRequest
 */
export interface IncomeVerificationRefreshRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationRefreshRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationRefreshRequest
     */
    secret?: string;
    /**
     * The ID of the verification.
     * @type {string}
     * @memberof IncomeVerificationRefreshRequest
     * @deprecated
     */
    income_verification_id?: string | null;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof IncomeVerificationRefreshRequest
     */
    access_token?: string | null;
}
/**
 * IncomeVerificationRequestResponse defines the response schema for `/income/verification/refresh`
 * @export
 * @interface IncomeVerificationRefreshResponse
 */
export interface IncomeVerificationRefreshResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof IncomeVerificationRefreshResponse
     */
    request_id: string;
    /**
     *
     * @type {VerificationRefreshStatus}
     * @memberof IncomeVerificationRefreshResponse
     */
    verification_refresh_status: VerificationRefreshStatus;
}
/**
 * Fired when the status of an income verification instance has changed. It will typically take several minutes for this webhook to fire after the end user has uploaded their documents in the Document Income flow.
 * @export
 * @interface IncomeVerificationStatusWebhook
 */
export interface IncomeVerificationStatusWebhook {
    [key: string]: object | any;
    /**
     * `\"INCOME\"`
     * @type {string}
     * @memberof IncomeVerificationStatusWebhook
     */
    webhook_type: string;
    /**
     * `income_verification`
     * @type {string}
     * @memberof IncomeVerificationStatusWebhook
     */
    webhook_code: string;
    /**
     * The `income_verification_id` of the verification instance whose status is being reported.
     * @type {string}
     * @memberof IncomeVerificationStatusWebhook
     */
    income_verification_id: string;
    /**
     * The Item ID associated with the verification.
     * @type {string}
     * @memberof IncomeVerificationStatusWebhook
     */
    item_id: string;
    /**
     * `VERIFICATION_STATUS_PROCESSING_COMPLETE`: The income verification status processing has completed. If the user uploaded multiple documents, this webhook will fire when all documents have finished processing. Call the `/income/verification/paystubs/get` endpoint and check the document metadata to see which documents were successfully parsed.  `VERIFICATION_STATUS_PROCESSING_FAILED`: A failure occurred when attempting to process the verification documentation.  `VERIFICATION_STATUS_PENDING_APPROVAL`: The income verification has been sent to the user for review.
     * @type {string}
     * @memberof IncomeVerificationStatusWebhook
     */
    verification_status: string;
}
/**
 * IncomeVerificationSummaryGetRequest defines the request schema for `/income/verification/summary/get`.
 * @export
 * @interface IncomeVerificationSummaryGetRequest
 */
export interface IncomeVerificationSummaryGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationSummaryGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationSummaryGetRequest
     */
    secret?: string;
    /**
     * The ID of the verification.
     * @type {string}
     * @memberof IncomeVerificationSummaryGetRequest
     * @deprecated
     */
    income_verification_id?: string | null;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof IncomeVerificationSummaryGetRequest
     */
    access_token?: string | null;
}
/**
 * IncomeVerificationSummaryGetResponse defines the response schema for `/income/verification/summary/get`.
 * @export
 * @interface IncomeVerificationSummaryGetResponse
 */
export interface IncomeVerificationSummaryGetResponse {
    [key: string]: object | any;
    /**
     * A list of income summaries.
     * @type {Array<IncomeSummary>}
     * @memberof IncomeVerificationSummaryGetResponse
     */
    income_summaries: Array<IncomeSummary>;
    /**
     *
     * @type {PlaidError}
     * @memberof IncomeVerificationSummaryGetResponse
     */
    error?: PlaidError;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof IncomeVerificationSummaryGetResponse
     */
    request_id: string;
}
/**
 * IncomeVerificationTaxformsGetRequest defines the request schema for `/income/verification/taxforms/get`
 * @export
 * @interface IncomeVerificationTaxformsGetRequest
 */
export interface IncomeVerificationTaxformsGetRequest {
    [key: string]: object | any;
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationTaxformsGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof IncomeVerificationTaxformsGetRequest
     */
    secret?: string;
    /**
     * The ID of the verification.
     * @type {string}
     * @memberof IncomeVerificationTaxformsGetRequest
     * @deprecated
     */
    income_verification_id?: string | null;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof IncomeVerificationTaxformsGetRequest
     */
    access_token?: string | null;
}
/**
 * IncomeVerificationTaxformsGetResponse defines the response schema for `/income/verification/taxforms/get`
 * @export
 * @interface IncomeVerificationTaxformsGetResponse
 */
export interface IncomeVerificationTaxformsGetResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof IncomeVerificationTaxformsGetResponse
     */
    request_id?: string;
    /**
     *
     * @type {Array<DocumentMetadata>}
     * @memberof IncomeVerificationTaxformsGetResponse
     */
    document_metadata: Array<DocumentMetadata>;
    /**
     * A list of forms.
     * @type {Array<Taxform>}
     * @memberof IncomeVerificationTaxformsGetResponse
     */
    taxforms: Array<Taxform>;
    /**
     *
     * @type {PlaidError}
     * @memberof IncomeVerificationTaxformsGetResponse
     */
    error?: PlaidError;
}
/**
 * Status of the income verification webhook
 * @export
 * @interface IncomeVerificationWebhookStatus
 */
export interface IncomeVerificationWebhookStatus {
    [key: string]: object | any;
    /**
     *
     * @type {string}
     * @memberof IncomeVerificationWebhookStatus
     */
    id: string;
}
/**
 * The `inflow_model` allows you to model a test account that receives regular income or make regular payments on a loan. Any transactions generated by the `inflow_model` will appear in addition to randomly generated test data or transactions specified by `override_accounts`.
 * @export
 * @interface InflowModel
 */
export interface InflowModel {
    [key: string]: object | any;
    /**
     * Inflow model. One of the following:  `none`: No income  `monthly-income`: Income occurs once per month `monthly-balance-payment`: Pays off the balance on a liability account at the given statement day of month.  `monthly-interest-only-payment`: Makes an interest-only payment on a liability account at the given statement day of month.   Note that account types supported by Liabilities will accrue interest in the Sandbox. The types impacted are account type `credit` with subtype `credit` or `paypal`, and account type `loan` with subtype `student` or `mortgage`.
     * @type {string}
     * @memberof InflowModel
     */
    type: string;
    /**
     * Amount of income per month. This value is required if `type` is `monthly-income`.
     * @type {number}
     * @memberof InflowModel
     */
    income_amount: number;
    /**
     * Number between 1 and 28, or `last` meaning the last day of the month. The day of the month on which the income transaction will appear. The name of the income transaction. This field is required if `type` is `monthly-income`, `monthly-balance-payment` or `monthly-interest-only-payment`.
     * @type {number}
     * @memberof InflowModel
     */
    payment_day_of_month: number;
    /**
     * The name of the income transaction. This field is required if `type` is `monthly-income`, `monthly-balance-payment` or `monthly-interest-only-payment`.
     * @type {string}
     * @memberof InflowModel
     */
    transaction_name: string;
    /**
     * Number between 1 and 28, or `last` meaning the last day of the month. The day of the month on which the balance is calculated for the next payment. The name of the income transaction. This field is required if `type` is `monthly-balance-payment` or `monthly-interest-only-payment`.
     * @type {string}
     * @memberof InflowModel
     */
    statement_day_of_month: string;
}
/**
 * Fired when an Item\'s initial transaction pull is completed. Once this webhook has been fired, transaction data for the most recent 30 days can be fetched for the Item. If [Account Select v2](https://plaid.com/docs/link/customization/#account-select) is enabled, this webhook will also be fired if account selections for the Item are updated, with `new_transactions` set to the number of net new transactions pulled after the account selection update.
 * @export
 * @interface InitialUpdateWebhook
 */
export interface InitialUpdateWebhook {
    [key: string]: object | any;
    /**
     * `TRANSACTIONS`
     * @type {string}
     * @memberof InitialUpdateWebhook
     */
    webhook_type: string;
    /**
     * `INITIAL_UPDATE`
     * @type {string}
     * @memberof InitialUpdateWebhook
     */
    webhook_code: string;
    /**
     * The error code associated with the webhook.
     * @type {string}
     * @memberof InitialUpdateWebhook
     */
    error?: string | null;
    /**
     * The number of new, unfetched transactions available.
     * @type {number}
     * @memberof InitialUpdateWebhook
     */
    new_transactions: number;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof InitialUpdateWebhook
     */
    item_id: string;
}
/**
 * Details relating to a specific financial institution
 * @export
 * @interface Institution
 */
export interface Institution {
    [key: string]: object | any;
    /**
     * Unique identifier for the institution
     * @type {string}
     * @memberof Institution
     */
    institution_id: string;
    /**
     * The official name of the institution
     * @type {string}
     * @memberof Institution
     */
    name: string;
    /**
     * A list of the Plaid products supported by the institution. Note that only institutions that support Instant Auth will return `auth` in the product array; institutions that do not list `auth` may still support other Auth methods such as Instant Match or Automated Micro-deposit Verification. For more details, see [Full Auth coverage](https://plaid.com/docs/auth/coverage/).
     * @type {Array<Products>}
     * @memberof Institution
     */
    products: Array<Products>;
    /**
     * A list of the country codes supported by the institution.
     * @type {Array<CountryCode>}
     * @memberof Institution
     */
    country_codes: Array<CountryCode>;
    /**
     * The URL for the institution\'s website
     * @type {string}
     * @memberof Institution
     */
    url?: string | null;
    /**
     * Hexadecimal representation of the primary color used by the institution
     * @type {string}
     * @memberof Institution
     */
    primary_color?: string | null;
    /**
     * Base64 encoded representation of the institution\'s logo
     * @type {string}
     * @memberof Institution
     */
    logo?: string | null;
    /**
     * A partial list of routing numbers associated with the institution. This list is provided for the purpose of looking up institutions by routing number. It is not comprehensive and should never be used as a complete list of routing numbers for an institution.
     * @type {Array<string>}
     * @memberof Institution
     */
    routing_numbers: Array<string>;
    /**
     * Indicates that the institution has an OAuth login flow. This is primarily relevant to institutions with European country codes.
     * @type {boolean}
     * @memberof Institution
     */
    oauth: boolean;
    /**
     *
     * @type {InstitutionStatus}
     * @memberof Institution
     */
    status?: InstitutionStatus | null;
    /**
     *
     * @type {PaymentInitiationMetadata}
     * @memberof Institution
     */
    payment_initiation_metadata?: PaymentInitiationMetadata | null;
    /**
     *
     * @type {AuthMetadata}
     * @memberof Institution
     */
    auth_metadata?: AuthMetadata | null;
}
/**
 * The status of an institution is determined by the health of its Item logins, Transactions updates, Investments updates, Liabilities updates, Auth requests, Balance requests, Identity requests, Investments requests, and Liabilities requests. A login attempt is conducted during the initial Item add in Link. If there is not enough traffic to accurately calculate an institution\'s status, Plaid will return null rather than potentially inaccurate data.  Institution status is accessible in the Dashboard and via the API using the `/institutions/get_by_id` endpoint with the `include_status` option set to true. Note that institution status is not available in the Sandbox environment.
 * @export
 * @interface InstitutionStatus
 */
export interface InstitutionStatus {
    [key: string]: object | any;
    /**
     *
     * @type {ProductStatus}
     * @memberof InstitutionStatus
     */
    item_logins: ProductStatus;
    /**
     *
     * @type {ProductStatus}
     * @memberof InstitutionStatus
     */
    transactions_updates: ProductStatus;
    /**
     *
     * @type {ProductStatus}
     * @memberof InstitutionStatus
     */
    auth: ProductStatus;
    /**
     *
     * @type {ProductStatus}
     * @memberof InstitutionStatus
     */
    identity: ProductStatus;
    /**
     *
     * @type {ProductStatus}
     * @memberof InstitutionStatus
     */
    investments_updates: ProductStatus;
    /**
     *
     * @type {ProductStatus}
     * @memberof InstitutionStatus
     */
    liabilities_updates?: ProductStatus;
    /**
     *
     * @type {ProductStatus}
     * @memberof InstitutionStatus
     */
    liabilities?: ProductStatus;
    /**
     *
     * @type {ProductStatus}
     * @memberof InstitutionStatus
     */
    investments?: ProductStatus;
    /**
     * Details of recent health incidents associated with the institution.
     * @type {Array<HealthIncident>}
     * @memberof InstitutionStatus
     */
    health_incidents?: Array<HealthIncident> | null;
}
/**
 * InstitutionsGetByIdRequest defines the request schema for `/institutions/get_by_id`
 * @export
 * @interface InstitutionsGetByIdRequest
 */
export interface InstitutionsGetByIdRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof InstitutionsGetByIdRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof InstitutionsGetByIdRequest
     */
    secret?: string;
    /**
     * The ID of the institution to get details about
     * @type {string}
     * @memberof InstitutionsGetByIdRequest
     */
    institution_id: string;
    /**
     * Specify an array of Plaid-supported country codes this institution supports, using the ISO-3166-1 alpha-2 country code standard. In API versions 2019-05-29 and earlier, the `country_codes` parameter is an optional parameter within the `options` object and will default to `[US]` if it is not supplied.
     * @type {Array<CountryCode>}
     * @memberof InstitutionsGetByIdRequest
     */
    country_codes: Array<CountryCode>;
    /**
     *
     * @type {InstitutionsGetByIdRequestOptions}
     * @memberof InstitutionsGetByIdRequest
     */
    options?: InstitutionsGetByIdRequestOptions;
}
/**
 * Specifies optional parameters for `/institutions/get_by_id`. If provided, must not be `null`.
 * @export
 * @interface InstitutionsGetByIdRequestOptions
 */
export interface InstitutionsGetByIdRequestOptions {
    /**
     * When `true`, return an institution\'s logo, brand color, and URL. When available, the bank\'s logo is returned as a base64 encoded 152x152 PNG, the brand color is in hexadecimal format. The default value is `false`.  Note that Plaid does not own any of the logos shared by the API and that by accessing or using these logos, you agree that you are doing so at your own risk and will, if necessary, obtain all required permissions from the appropriate rights holders and adhere to any applicable usage guidelines. Plaid disclaims all express or implied warranties with respect to the logos.
     * @type {boolean}
     * @memberof InstitutionsGetByIdRequestOptions
     */
    include_optional_metadata?: boolean;
    /**
     * If `true`, the response will include status information about the institution. Default value is `false`.
     * @type {boolean}
     * @memberof InstitutionsGetByIdRequestOptions
     */
    include_status?: boolean;
    /**
     * When `true`, returns metadata related to the Auth product indicating which auth methods are supported.
     * @type {boolean}
     * @memberof InstitutionsGetByIdRequestOptions
     */
    include_auth_metadata?: boolean;
    /**
     * When `true`, returns metadata related to the Payment Initiation product indicating which payment configurations are supported.
     * @type {boolean}
     * @memberof InstitutionsGetByIdRequestOptions
     */
    include_payment_initiation_metadata?: boolean;
}
/**
 * InstitutionsGetByIdResponse defines the response schema for `/institutions/get_by_id`
 * @export
 * @interface InstitutionsGetByIdResponse
 */
export interface InstitutionsGetByIdResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Institution}
     * @memberof InstitutionsGetByIdResponse
     */
    institution: Institution;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof InstitutionsGetByIdResponse
     */
    request_id: string;
}
/**
 * InstitutionsGetRequest defines the request schema for `/institutions/get`
 * @export
 * @interface InstitutionsGetRequest
 */
export interface InstitutionsGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof InstitutionsGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof InstitutionsGetRequest
     */
    secret?: string;
    /**
     * The total number of Institutions to return.
     * @type {number}
     * @memberof InstitutionsGetRequest
     */
    count: number;
    /**
     * The number of Institutions to skip.
     * @type {number}
     * @memberof InstitutionsGetRequest
     */
    offset: number;
    /**
     * Specify an array of Plaid-supported country codes this institution supports, using the ISO-3166-1 alpha-2 country code standard.   In API versions 2019-05-29 and earlier, the `country_codes` parameter is an optional parameter within the `options` object and will default to `[US]` if it is not supplied.
     * @type {Array<CountryCode>}
     * @memberof InstitutionsGetRequest
     */
    country_codes: Array<CountryCode>;
    /**
     *
     * @type {InstitutionsGetRequestOptions}
     * @memberof InstitutionsGetRequest
     */
    options?: InstitutionsGetRequestOptions;
}
/**
 * An optional object to filter `/institutions/get` results.
 * @export
 * @interface InstitutionsGetRequestOptions
 */
export interface InstitutionsGetRequestOptions {
    /**
     * Filter the Institutions based on which products they support.
     * @type {Array<Products>}
     * @memberof InstitutionsGetRequestOptions
     */
    products?: Array<Products> | null;
    /**
     * Specify an array of routing numbers to filter institutions. The response will only return institutions that match all of the routing numbers in the array. Routing number records used for this matching are not comprehensive; failure to match a given routing number to an institution does not mean that the institution is unsupported by Plaid.
     * @type {Array<string>}
     * @memberof InstitutionsGetRequestOptions
     */
    routing_numbers?: Array<string> | null;
    /**
     * Limit results to institutions with or without OAuth login flows. This is primarily relevant to institutions with European country codes.
     * @type {boolean}
     * @memberof InstitutionsGetRequestOptions
     */
    oauth?: boolean | null;
    /**
     * When `true`, return the institution\'s homepage URL, logo and primary brand color.  Note that Plaid does not own any of the logos shared by the API, and that by accessing or using these logos, you agree that you are doing so at your own risk and will, if necessary, obtain all required permissions from the appropriate rights holders and adhere to any applicable usage guidelines. Plaid disclaims all express or implied warranties with respect to the logos.
     * @type {boolean}
     * @memberof InstitutionsGetRequestOptions
     */
    include_optional_metadata?: boolean;
    /**
     * When `true`, returns metadata related to the Auth product indicating which auth methods are supported.
     * @type {boolean}
     * @memberof InstitutionsGetRequestOptions
     */
    include_auth_metadata?: boolean;
    /**
     * When `true`, returns metadata related to the Payment Initiation product indicating which payment configurations are supported.
     * @type {boolean}
     * @memberof InstitutionsGetRequestOptions
     */
    include_payment_initiation_metadata?: boolean;
}
/**
 * InstitutionsGetResponse defines the response schema for `/institutions/get`
 * @export
 * @interface InstitutionsGetResponse
 */
export interface InstitutionsGetResponse {
    [key: string]: object | any;
    /**
     * A list of Plaid institutions
     * @type {Array<Institution>}
     * @memberof InstitutionsGetResponse
     */
    institutions: Array<Institution>;
    /**
     * The total number of institutions available via this endpoint
     * @type {number}
     * @memberof InstitutionsGetResponse
     */
    total: number;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof InstitutionsGetResponse
     */
    request_id: string;
}
/**
 * An account filter to apply to institutions search requests
 * @export
 * @interface InstitutionsSearchAccountFilter
 */
export interface InstitutionsSearchAccountFilter {
    [key: string]: object | any;
    /**
     *
     * @type {Array<AccountSubtype>}
     * @memberof InstitutionsSearchAccountFilter
     */
    loan?: Array<AccountSubtype>;
    /**
     *
     * @type {Array<AccountSubtype>}
     * @memberof InstitutionsSearchAccountFilter
     */
    depository?: Array<AccountSubtype>;
    /**
     *
     * @type {Array<AccountSubtype>}
     * @memberof InstitutionsSearchAccountFilter
     */
    credit?: Array<AccountSubtype>;
    /**
     *
     * @type {Array<AccountSubtype>}
     * @memberof InstitutionsSearchAccountFilter
     */
    investment?: Array<AccountSubtype>;
}
/**
 * Additional options that will be used to filter institutions by various Payment Initiation configurations.
 * @export
 * @interface InstitutionsSearchPaymentInitiationOptions
 */
export interface InstitutionsSearchPaymentInitiationOptions {
    [key: string]: object | any;
    /**
     * A unique ID identifying the payment
     * @type {string}
     * @memberof InstitutionsSearchPaymentInitiationOptions
     */
    payment_id?: string | null;
}
/**
 * InstitutionsSearchRequest defines the request schema for `/institutions/search`
 * @export
 * @interface InstitutionsSearchRequest
 */
export interface InstitutionsSearchRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof InstitutionsSearchRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof InstitutionsSearchRequest
     */
    secret?: string;
    /**
     * The search query. Institutions with names matching the query are returned
     * @type {string}
     * @memberof InstitutionsSearchRequest
     */
    query: string;
    /**
     * Filter the Institutions based on whether they support all products listed in `products`. Provide `null` to get institutions regardless of supported products. Note that when `auth` is specified as a product, if you are enabled for Instant Match or Automated Micro-deposits, institutions that support those products will be returned even if `auth` is not present in their product array.
     * @type {Array<Products>}
     * @memberof InstitutionsSearchRequest
     */
    products: Array<Products> | null;
    /**
     * Specify an array of Plaid-supported country codes this institution supports, using the ISO-3166-1 alpha-2 country code standard. In API versions 2019-05-29 and earlier, the `country_codes` parameter is an optional parameter within the `options` object and will default to `[US]` if it is not supplied.
     * @type {Array<CountryCode>}
     * @memberof InstitutionsSearchRequest
     */
    country_codes: Array<CountryCode>;
    /**
     *
     * @type {InstitutionsSearchRequestOptions}
     * @memberof InstitutionsSearchRequest
     */
    options?: InstitutionsSearchRequestOptions;
}
/**
 * An optional object to filter `/institutions/search` results.
 * @export
 * @interface InstitutionsSearchRequestOptions
 */
export interface InstitutionsSearchRequestOptions {
    /**
     * Limit results to institutions with or without OAuth login flows. This is primarily relevant to institutions with European country codes
     * @type {boolean}
     * @memberof InstitutionsSearchRequestOptions
     */
    oauth?: boolean | null;
    /**
     * When true, return the institution\'s homepage URL, logo and primary brand color.
     * @type {boolean}
     * @memberof InstitutionsSearchRequestOptions
     */
    include_optional_metadata?: boolean;
    /**
     * When `true`, returns metadata related to the Auth product indicating which auth methods are supported.
     * @type {boolean}
     * @memberof InstitutionsSearchRequestOptions
     */
    include_auth_metadata?: boolean | null;
    /**
     * When `true`, returns metadata related to the Payment Initiation product indicating which payment configurations are supported.
     * @type {boolean}
     * @memberof InstitutionsSearchRequestOptions
     */
    include_payment_initiation_metadata?: boolean | null;
    /**
     *
     * @type {InstitutionsSearchPaymentInitiationOptions}
     * @memberof InstitutionsSearchRequestOptions
     */
    payment_initiation?: InstitutionsSearchPaymentInitiationOptions | null;
}
/**
 * InstitutionsSearchResponse defines the response schema for `/institutions/search`
 * @export
 * @interface InstitutionsSearchResponse
 */
export interface InstitutionsSearchResponse {
    [key: string]: object | any;
    /**
     * An array of institutions matching the search criteria
     * @type {Array<Institution>}
     * @memberof InstitutionsSearchResponse
     */
    institutions: Array<Institution>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof InstitutionsSearchResponse
     */
    request_id: string;
}
/**
 * Valid account subtypes for investment accounts. For a list containing descriptions of each subtype, see [Account schemas](https://plaid.com/docs/api/accounts/#StandaloneAccountType-investment).
 * @export
 * @enum {string}
 */
export declare enum InvestmentAccountSubtype {
    _529 = "529",
    _401a = "401a",
    _401k = "401k",
    _403B = "403B",
    _457b = "457b",
    Brokerage = "brokerage",
    CashIsa = "cash isa",
    EducationSavingsAccount = "education savings account",
    FixedAnnuity = "fixed annuity",
    Gic = "gic",
    HealthReimbursementArrangement = "health reimbursement arrangement",
    Hsa = "hsa",
    Ira = "ira",
    Isa = "isa",
    Keogh = "keogh",
    Lif = "lif",
    LifeInsurance = "life insurance",
    Lira = "lira",
    Lrif = "lrif",
    Lrsp = "lrsp",
    MutualFund = "mutual fund",
    NonTaxableBrokerageAccount = "non-taxable brokerage account",
    Other = "other",
    OtherAnnuity = "other annuity",
    OtherInsurance = "other insurance",
    Person = "person",
    Prif = "prif",
    ProfitSharingPlan = "profit sharing plan",
    Qshr = "qshr",
    Rdsp = "rdsp",
    Resp = "resp",
    Retirement = "retirement",
    Rlif = "rlif",
    Roth = "roth",
    Roth401k = "roth 401k",
    Rrif = "rrif",
    Rrsp = "rrsp",
    Sarsep = "sarsep",
    SepIra = "sep ira",
    SimpleIra = "simple ira",
    Sipp = "sipp",
    StockPlan = "stock plan",
    Tfsa = "tfsa",
    Trust = "trust",
    Ugma = "ugma",
    Utma = "utma",
    VariableAnnuity = "variable annuity",
    All = "all"
}
/**
 * A filter to apply to `investment`-type accounts (or `brokerage`-type acconunts for API versions 2018-05-22 and earlier).
 * @export
 * @interface InvestmentFilter
 */
export interface InvestmentFilter {
    [key: string]: object | any;
    /**
     * An array of account subtypes to display in Link. If not specified, all account subtypes will be shown. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).
     * @type {Array<InvestmentAccountSubtype>}
     * @memberof InvestmentFilter
     */
    account_subtypes: Array<InvestmentAccountSubtype>;
}
/**
 * An optional object to filter `/investments/holdings/get` results. If provided, must not be `null`.
 * @export
 * @interface InvestmentHoldingsGetRequestOptions
 */
export interface InvestmentHoldingsGetRequestOptions {
    /**
     * An array of `account_id`s to retrieve for the Item. An error will be returned if a provided `account_id` is not associated with the Item.
     * @type {Array<string>}
     * @memberof InvestmentHoldingsGetRequestOptions
     */
    account_ids?: Array<string>;
}
/**
 * A transaction within an investment account.
 * @export
 * @interface InvestmentTransaction
 */
export interface InvestmentTransaction {
    [key: string]: object | any;
    /**
     * The ID of the Investment transaction, unique across all Plaid transactions. Like all Plaid identifiers, the `investment_transaction_id` is case sensitive.
     * @type {string}
     * @memberof InvestmentTransaction
     */
    investment_transaction_id: string;
    /**
     * A legacy field formerly used internally by Plaid to identify certain canceled transactions.
     * @type {string}
     * @memberof InvestmentTransaction
     * @deprecated
     */
    cancel_transaction_id?: string | null;
    /**
     * The `account_id` of the account against which this transaction posted.
     * @type {string}
     * @memberof InvestmentTransaction
     */
    account_id: string;
    /**
     * The `security_id` to which this transaction is related.
     * @type {string}
     * @memberof InvestmentTransaction
     */
    security_id: string | null;
    /**
     * The [ISO 8601](https://wikipedia.org/wiki/ISO_8601) posting date for the transaction.
     * @type {string}
     * @memberof InvestmentTransaction
     */
    date: string;
    /**
     * The institution’s description of the transaction.
     * @type {string}
     * @memberof InvestmentTransaction
     */
    name: string;
    /**
     * The number of units of the security involved in this transaction.
     * @type {number}
     * @memberof InvestmentTransaction
     */
    quantity: number;
    /**
     * The complete value of the transaction. Positive values when cash is debited, e.g. purchases of stock; negative values when cash is credited, e.g. sales of stock. Treatment remains the same for cash-only movements unassociated with securities.
     * @type {number}
     * @memberof InvestmentTransaction
     */
    amount: number;
    /**
     * The price of the security at which this transaction occurred.
     * @type {number}
     * @memberof InvestmentTransaction
     */
    price: number;
    /**
     * The combined value of all fees applied to this transaction
     * @type {number}
     * @memberof InvestmentTransaction
     */
    fees: number | null;
    /**
     * Value is one of the following: `buy`: Buying an investment `sell`: Selling an investment `cancel`: A cancellation of a pending transaction `cash`: Activity that modifies a cash position `fee`: A fee on the account `transfer`: Activity which modifies a position, but not through buy/sell activity e.g. options exercise, portfolio transfer  For descriptions of possible transaction types and subtypes, see the [Investment transaction types schema](https://plaid.com/docs/api/accounts/#investment-transaction-types-schema).
     * @type {string}
     * @memberof InvestmentTransaction
     */
    type: InvestmentTransactionTypeEnum;
    /**
     * For descriptions of possible transaction types and subtypes, see the [Investment transaction types schema](https://plaid.com/docs/api/accounts/#investment-transaction-types-schema).
     * @type {string}
     * @memberof InvestmentTransaction
     */
    subtype: InvestmentTransactionSubtypeEnum;
    /**
     * The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-`null`.
     * @type {string}
     * @memberof InvestmentTransaction
     */
    iso_currency_code: string | null;
    /**
     * The unofficial currency code associated with the holding. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof InvestmentTransaction
     */
    unofficial_currency_code: string | null;
}
/**
    * @export
    * @enum {string}
    */
export declare enum InvestmentTransactionTypeEnum {
    Buy = "buy",
    Sell = "sell",
    Cancel = "cancel",
    Cash = "cash",
    Fee = "fee",
    Transfer = "transfer"
}
/**
    * @export
    * @enum {string}
    */
export declare enum InvestmentTransactionSubtypeEnum {
    AccountFee = "account fee",
    Adjustment = "adjustment",
    Assignment = "assignment",
    Buy = "buy",
    BuyToCover = "buy to cover",
    Contribution = "contribution",
    Deposit = "deposit",
    Distribution = "distribution",
    Dividend = "dividend",
    DividendReinvestment = "dividend reinvestment",
    Exercise = "exercise",
    Expire = "expire",
    FundFee = "fund fee",
    Interest = "interest",
    InterestReceivable = "interest receivable",
    InterestReinvestment = "interest reinvestment",
    LegalFee = "legal fee",
    LoanPayment = "loan payment",
    LongTermCapitalGain = "long-term capital gain",
    LongTermCapitalGainReinvestment = "long-term capital gain reinvestment",
    ManagementFee = "management fee",
    MarginExpense = "margin expense",
    Merger = "merger",
    MiscellaneousFee = "miscellaneous fee",
    NonQualifiedDividend = "non-qualified dividend",
    NonResidentTax = "non-resident tax",
    PendingCredit = "pending credit",
    PendingDebit = "pending debit",
    QualifiedDividend = "qualified dividend",
    Rebalance = "rebalance",
    ReturnOfPrincipal = "return of principal",
    Sell = "sell",
    SellShort = "sell short",
    ShortTermCapitalGain = "short-term capital gain",
    ShortTermCapitalGainReinvestment = "short-term capital gain reinvestment",
    SpinOff = "spin off",
    Split = "split",
    StockDistribution = "stock distribution",
    Tax = "tax",
    TaxWithheld = "tax withheld",
    Transfer = "transfer",
    TransferFee = "transfer fee",
    TrustFee = "trust fee",
    UnqualifiedGain = "unqualified gain",
    Withdrawal = "withdrawal"
}
/**
 * Fired when new or canceled transactions have been detected on an investment account.
 * @export
 * @interface InvestmentsDefaultUpdateWebhook
 */
export interface InvestmentsDefaultUpdateWebhook {
    [key: string]: object | any;
    /**
     * `INVESTMENTS_TRANSACTIONS`
     * @type {string}
     * @memberof InvestmentsDefaultUpdateWebhook
     */
    webhook_type: string;
    /**
     * `DEFAULT_UPDATE`
     * @type {string}
     * @memberof InvestmentsDefaultUpdateWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof InvestmentsDefaultUpdateWebhook
     */
    item_id: string;
    /**
     *
     * @type {PlaidError}
     * @memberof InvestmentsDefaultUpdateWebhook
     */
    error?: PlaidError;
    /**
     * The number of new transactions reported since the last time this webhook was fired.
     * @type {number}
     * @memberof InvestmentsDefaultUpdateWebhook
     */
    new_investments_transactions: number;
    /**
     * The number of canceled transactions reported since the last time this webhook was fired.
     * @type {number}
     * @memberof InvestmentsDefaultUpdateWebhook
     */
    canceled_investments_transactions: number;
}
/**
 * InvestmentsHoldingsGetRequest defines the request schema for `/investments/holdings/get`
 * @export
 * @interface InvestmentsHoldingsGetRequest
 */
export interface InvestmentsHoldingsGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof InvestmentsHoldingsGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof InvestmentsHoldingsGetRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof InvestmentsHoldingsGetRequest
     */
    access_token: string;
    /**
     *
     * @type {InvestmentHoldingsGetRequestOptions}
     * @memberof InvestmentsHoldingsGetRequest
     */
    options?: InvestmentHoldingsGetRequestOptions;
}
/**
 * InvestmentsHoldingsGetResponse defines the response schema for `/investments/holdings/get`
 * @export
 * @interface InvestmentsHoldingsGetResponse
 */
export interface InvestmentsHoldingsGetResponse {
    [key: string]: object | any;
    /**
     * The accounts associated with the Item
     * @type {Array<AccountBase>}
     * @memberof InvestmentsHoldingsGetResponse
     */
    accounts: Array<AccountBase>;
    /**
     * The holdings belonging to investment accounts associated with the Item. Details of the securities in the holdings are provided in the `securities` field.
     * @type {Array<Holding>}
     * @memberof InvestmentsHoldingsGetResponse
     */
    holdings: Array<Holding>;
    /**
     * Objects describing the securities held in the accounts associated with the Item.
     * @type {Array<Security>}
     * @memberof InvestmentsHoldingsGetResponse
     */
    securities: Array<Security>;
    /**
     *
     * @type {Item}
     * @memberof InvestmentsHoldingsGetResponse
     */
    item: Item;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof InvestmentsHoldingsGetResponse
     */
    request_id: string;
}
/**
 * InvestmentsTransactionsGetRequest defines the request schema for `/investments/transactions/get`
 * @export
 * @interface InvestmentsTransactionsGetRequest
 */
export interface InvestmentsTransactionsGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof InvestmentsTransactionsGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof InvestmentsTransactionsGetRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof InvestmentsTransactionsGetRequest
     */
    access_token: string;
    /**
     * The earliest date for which to fetch transaction history. Dates should be formatted as YYYY-MM-DD.
     * @type {string}
     * @memberof InvestmentsTransactionsGetRequest
     */
    start_date: string;
    /**
     * The most recent date for which to fetch transaction history. Dates should be formatted as YYYY-MM-DD.
     * @type {string}
     * @memberof InvestmentsTransactionsGetRequest
     */
    end_date: string;
    /**
     *
     * @type {InvestmentsTransactionsGetRequestOptions}
     * @memberof InvestmentsTransactionsGetRequest
     */
    options?: InvestmentsTransactionsGetRequestOptions;
}
/**
 * An optional object to filter `/investments/transactions/get` results. If provided, must be non-`null`.
 * @export
 * @interface InvestmentsTransactionsGetRequestOptions
 */
export interface InvestmentsTransactionsGetRequestOptions {
    /**
     * An array of `account_ids` to retrieve for the Item.
     * @type {Array<string>}
     * @memberof InvestmentsTransactionsGetRequestOptions
     */
    account_ids?: Array<string>;
    /**
     * The number of transactions to fetch.
     * @type {number}
     * @memberof InvestmentsTransactionsGetRequestOptions
     */
    count?: number;
    /**
     * The number of transactions to skip when fetching transaction history
     * @type {number}
     * @memberof InvestmentsTransactionsGetRequestOptions
     */
    offset?: number;
}
/**
 * InvestmentsTransactionsGetResponse defines the response schema for `/investments/transactions/get`
 * @export
 * @interface InvestmentsTransactionsGetResponse
 */
export interface InvestmentsTransactionsGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Item}
     * @memberof InvestmentsTransactionsGetResponse
     */
    item: Item;
    /**
     * The accounts for which transaction history is being fetched.
     * @type {Array<AccountBase>}
     * @memberof InvestmentsTransactionsGetResponse
     */
    accounts: Array<AccountBase>;
    /**
     * All securities for which there is a corresponding transaction being fetched.
     * @type {Array<Security>}
     * @memberof InvestmentsTransactionsGetResponse
     */
    securities: Array<Security>;
    /**
     * The transactions being fetched
     * @type {Array<InvestmentTransaction>}
     * @memberof InvestmentsTransactionsGetResponse
     */
    investment_transactions: Array<InvestmentTransaction>;
    /**
     * The total number of transactions available within the date range specified. If `total_investment_transactions` is larger than the size of the `transactions` array, more transactions are available and can be fetched via manipulating the `offset` parameter.\'
     * @type {number}
     * @memberof InvestmentsTransactionsGetResponse
     */
    total_investment_transactions: number;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof InvestmentsTransactionsGetResponse
     */
    request_id: string;
}
/**
 * Specify the list of investments transactions on the account.
 * @export
 * @interface InvestmentsTransactionsOverride
 */
export interface InvestmentsTransactionsOverride {
    /**
     * Posting date for the transaction. Must be formatted as an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) date.
     * @type {string}
     * @memberof InvestmentsTransactionsOverride
     */
    date: string;
    /**
     * The institution\'s description of the transaction.
     * @type {string}
     * @memberof InvestmentsTransactionsOverride
     */
    name: string;
    /**
     * The number of units of the security involved in this transaction. Must be positive if the type is a buy and negative if the type is a sell.
     * @type {number}
     * @memberof InvestmentsTransactionsOverride
     */
    quantity: number;
    /**
     * The price of the security at which this transaction occurred.
     * @type {number}
     * @memberof InvestmentsTransactionsOverride
     */
    price: number;
    /**
     * The combined value of all fees applied to this transaction.
     * @type {number}
     * @memberof InvestmentsTransactionsOverride
     */
    fees?: number;
    /**
     * The type of the investment transaction. Possible values are: `buy`: Buying an investment `sell`: Selling an investment `cash`: Activity that modifies a cash position `fee`: A fee on the account `transfer`: Activity that modifies a position, but not through buy/sell activity e.g. options exercise, portfolio transfer
     * @type {string}
     * @memberof InvestmentsTransactionsOverride
     */
    type: string;
    /**
     * Either a valid `iso_currency_code` or `unofficial_currency_code`
     * @type {string}
     * @memberof InvestmentsTransactionsOverride
     */
    currency: string;
    /**
     *
     * @type {SecurityOverride}
     * @memberof InvestmentsTransactionsOverride
     */
    security?: SecurityOverride;
}
/**
 * Metadata about the Item.
 * @export
 * @interface Item
 */
export interface Item {
    [key: string]: object | any;
    /**
     * The Plaid Item ID. The `item_id` is always unique; linking the same account at the same institution twice will result in two Items with different `item_id` values. Like all Plaid identifiers, the `item_id` is case-sensitive.
     * @type {string}
     * @memberof Item
     */
    item_id: string;
    /**
     * The Plaid Institution ID associated with the Item. Field is `null` for Items created via Same Day Micro-deposits.
     * @type {string}
     * @memberof Item
     */
    institution_id?: string | null;
    /**
     * The URL registered to receive webhooks for the Item.
     * @type {string}
     * @memberof Item
     */
    webhook: string | null;
    /**
     *
     * @type {Error}
     * @memberof Item
     */
    error: Error | null;
    /**
     * A list of products available for the Item that have not yet been accessed.
     * @type {Array<Products>}
     * @memberof Item
     */
    available_products: Array<Products>;
    /**
     * A list of products that have been billed for the Item. Note - `billed_products` is populated in all environments but only requests in Production are billed.
     * @type {Array<Products>}
     * @memberof Item
     */
    billed_products: Array<Products>;
    /**
     * A list of authorized products for the Item.
     * @type {Array<Products>}
     * @memberof Item
     */
    products?: Array<Products>;
    /**
     * The RFC 3339 timestamp after which the consent provided by the end user will expire. Upon consent expiration, the item will enter the `ITEM_LOGIN_REQUIRED` error state. To circumvent the `ITEM_LOGIN_REQUIRED` error and maintain continuous consent, the end user can reauthenticate via Link’s update mode in advance of the consent expiration time.  Note - This is only relevant for certain OAuth-based institutions. For all other institutions, this field will be null.
     * @type {string}
     * @memberof Item
     */
    consent_expiration_time: string | null;
    /**
     * Indicates whether an Item requires user interaction to be updated, which can be the case for Items with some forms of two-factor authentication.  `background` - Item can be updated in the background  `user_present_required` - Item requires user interaction to be updated
     * @type {string}
     * @memberof Item
     */
    update_type: ItemUpdateTypeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum ItemUpdateTypeEnum {
    Background = "background",
    UserPresentRequired = "user_present_required"
}
/**
 * ItemAccessTokenInvalidateRequest defines the request schema for `/item/access_token/invalidate`
 * @export
 * @interface ItemAccessTokenInvalidateRequest
 */
export interface ItemAccessTokenInvalidateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemAccessTokenInvalidateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemAccessTokenInvalidateRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemAccessTokenInvalidateRequest
     */
    access_token: string;
}
/**
 * ItemAccessTokenInvalidateResponse defines the response schema for `/item/access_token/invalidate`
 * @export
 * @interface ItemAccessTokenInvalidateResponse
 */
export interface ItemAccessTokenInvalidateResponse {
    [key: string]: object | any;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemAccessTokenInvalidateResponse
     */
    new_access_token: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemAccessTokenInvalidateResponse
     */
    request_id: string;
}
/**
 * Request to list connected applications for a user.
 * @export
 * @interface ItemApplicationListRequest
 */
export interface ItemApplicationListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemApplicationListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemApplicationListRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemApplicationListRequest
     */
    access_token?: string | null;
}
/**
 * Describes the connected application for a particular end user.
 * @export
 * @interface ItemApplicationListResponse
 */
export interface ItemApplicationListResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemApplicationListResponse
     */
    request_id?: string;
    /**
     * A list of connected applications.
     * @type {Array<ConnectedApplication>}
     * @memberof ItemApplicationListResponse
     */
    applications: Array<ConnectedApplication>;
}
/**
 * User authentication parameters, for clients making a request without an `access_token`. This is only allowed for select clients and will not be supported in the future. Most clients should call /item/import to obtain an access token before making a request.
 * @export
 * @interface ItemApplicationListUserAuth
 */
export interface ItemApplicationListUserAuth {
    /**
     * Account username.
     * @type {string}
     * @memberof ItemApplicationListUserAuth
     */
    user_id?: string | null;
    /**
     * Account username hashed by FI.
     * @type {string}
     * @memberof ItemApplicationListUserAuth
     */
    fi_username_hash?: string | null;
}
/**
 * ItemApplicationScopesUpdateRequest defines the request schema for `/item/application/scopes/update`
 * @export
 * @interface ItemApplicationScopesUpdateRequest
 */
export interface ItemApplicationScopesUpdateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemApplicationScopesUpdateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemApplicationScopesUpdateRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemApplicationScopesUpdateRequest
     */
    access_token: string;
    /**
     * This field will map to the application ID that is returned from /item/applications/list, or provided to the institution in an oauth redirect.
     * @type {string}
     * @memberof ItemApplicationScopesUpdateRequest
     */
    application_id: string;
    /**
     *
     * @type {Scopes}
     * @memberof ItemApplicationScopesUpdateRequest
     */
    scopes: Scopes;
    /**
     * When scopes are updated during enrollment, this field must be populated with the state sent to the partner in the OAuth Login URI. This field is required when the context is `ENROLLMENT`.
     * @type {string}
     * @memberof ItemApplicationScopesUpdateRequest
     */
    state?: string;
    /**
     *
     * @type {ScopesContext}
     * @memberof ItemApplicationScopesUpdateRequest
     */
    context: ScopesContext;
}
/**
 * ItemApplicationScopesUpdateResponse defines the response schema for `/item/application/scopes/update`
 * @export
 * @interface ItemApplicationScopesUpdateResponse
 */
export interface ItemApplicationScopesUpdateResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemApplicationScopesUpdateResponse
     */
    request_id: string;
}
/**
 * Fired when an error is encountered with an Item. The error can be resolved by having the user go through Link’s update mode.
 * @export
 * @interface ItemErrorWebhook
 */
export interface ItemErrorWebhook {
    [key: string]: object | any;
    /**
     * `ITEM`
     * @type {string}
     * @memberof ItemErrorWebhook
     */
    webhook_type: string;
    /**
     * `ERROR`
     * @type {string}
     * @memberof ItemErrorWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof ItemErrorWebhook
     */
    item_id: string;
    /**
     *
     * @type {PlaidError}
     * @memberof ItemErrorWebhook
     */
    error: PlaidError;
}
/**
 * ItemGetRequest defines the request schema for `/item/get`
 * @export
 * @interface ItemGetRequest
 */
export interface ItemGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemGetRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemGetRequest
     */
    access_token: string;
}
/**
 * ItemGetResponse defines the response schema for `/item/get` and `/item/webhook/update`
 * @export
 * @interface ItemGetResponse
 */
export interface ItemGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Item}
     * @memberof ItemGetResponse
     */
    item: Item;
    /**
     *
     * @type {ItemStatusNullable}
     * @memberof ItemGetResponse
     */
    status?: ItemStatusNullable | null;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemGetResponse
     */
    request_id: string;
}
/**
 * ItemImportRequest defines the request schema for `/item/import`
 * @export
 * @interface ItemImportRequest
 */
export interface ItemImportRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemImportRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemImportRequest
     */
    secret?: string;
    /**
     * Array of product strings
     * @type {Array<Products>}
     * @memberof ItemImportRequest
     */
    products: Array<Products>;
    /**
     *
     * @type {ItemImportRequestUserAuth}
     * @memberof ItemImportRequest
     */
    user_auth: ItemImportRequestUserAuth;
    /**
     *
     * @type {ItemImportRequestOptions}
     * @memberof ItemImportRequest
     */
    options?: ItemImportRequestOptions;
}
/**
 * An optional object to configure `/item/import` request.
 * @export
 * @interface ItemImportRequestOptions
 */
export interface ItemImportRequestOptions {
    /**
     * Specifies a webhook URL to associate with an Item. Plaid fires a webhook if credentials fail.
     * @type {string}
     * @memberof ItemImportRequestOptions
     */
    webhook?: string;
}
/**
 * Object of user ID and auth token pair, permitting Plaid to aggregate a user’s accounts
 * @export
 * @interface ItemImportRequestUserAuth
 */
export interface ItemImportRequestUserAuth {
    /**
     * Opaque user identifier
     * @type {string}
     * @memberof ItemImportRequestUserAuth
     */
    user_id: string;
    /**
     * Authorization token Plaid will use to aggregate this user’s accounts
     * @type {string}
     * @memberof ItemImportRequestUserAuth
     */
    auth_token: string;
}
/**
 * ItemImportResponse defines the response schema for `/item/import`
 * @export
 * @interface ItemImportResponse
 */
export interface ItemImportResponse {
    [key: string]: object | any;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemImportResponse
     */
    access_token: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemImportResponse
     */
    request_id: string;
}
/**
 * Fired once Plaid calculates income from an Item.
 * @export
 * @interface ItemProductReadyWebhook
 */
export interface ItemProductReadyWebhook {
    [key: string]: object | any;
    /**
     * `INCOME`
     * @type {string}
     * @memberof ItemProductReadyWebhook
     */
    webhook_type: string;
    /**
     * `PRODUCT_READY`
     * @type {string}
     * @memberof ItemProductReadyWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof ItemProductReadyWebhook
     */
    item_id: string;
    /**
     *
     * @type {PlaidError}
     * @memberof ItemProductReadyWebhook
     */
    error?: PlaidError;
}
/**
 * ItemPublicTokenCreateRequest defines the request schema for `/item/public_token/create`
 * @export
 * @interface ItemPublicTokenCreateRequest
 */
export interface ItemPublicTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemPublicTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemPublicTokenCreateRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemPublicTokenCreateRequest
     */
    access_token: string;
}
/**
 * ItemPublicTokenCreateResponse defines the response schema for `/item/public_token/create`
 * @export
 * @interface ItemPublicTokenCreateResponse
 */
export interface ItemPublicTokenCreateResponse {
    [key: string]: object | any;
    /**
     * A `public_token` for the particular Item corresponding to the specified `access_token`
     * @type {string}
     * @memberof ItemPublicTokenCreateResponse
     */
    public_token: string;
    /**
     *
     * @type {string}
     * @memberof ItemPublicTokenCreateResponse
     */
    expiration?: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemPublicTokenCreateResponse
     */
    request_id: string;
}
/**
 * ItemPublicTokenExchangeRequest defines the request schema for `/item/public_token/exchange`
 * @export
 * @interface ItemPublicTokenExchangeRequest
 */
export interface ItemPublicTokenExchangeRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemPublicTokenExchangeRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemPublicTokenExchangeRequest
     */
    secret?: string;
    /**
     * Your `public_token`, obtained from the Link `onSuccess` callback or `/sandbox/item/public_token/create`.
     * @type {string}
     * @memberof ItemPublicTokenExchangeRequest
     */
    public_token: string;
}
/**
 * ItemPublicTokenExchangeResponse defines the response schema for `/item/public_token/exchange`
 * @export
 * @interface ItemPublicTokenExchangeResponse
 */
export interface ItemPublicTokenExchangeResponse {
    [key: string]: object | any;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemPublicTokenExchangeResponse
     */
    access_token: string;
    /**
     * The `item_id` value of the Item associated with the returned `access_token`
     * @type {string}
     * @memberof ItemPublicTokenExchangeResponse
     */
    item_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemPublicTokenExchangeResponse
     */
    request_id: string;
}
/**
 * ItemRemoveRequest defines the request schema for `/item/remove`
 * @export
 * @interface ItemRemoveRequest
 */
export interface ItemRemoveRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemRemoveRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemRemoveRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemRemoveRequest
     */
    access_token: string;
}
/**
 * ItemRemoveResponse defines the response schema for `/item/remove`
 * @export
 * @interface ItemRemoveResponse
 */
export interface ItemRemoveResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemRemoveResponse
     */
    request_id: string;
}
/**
 * An object with information about the status of the Item.
 * @export
 * @interface ItemStatus
 */
export interface ItemStatus {
    [key: string]: object | any;
    /**
     *
     * @type {ItemStatusInvestments}
     * @memberof ItemStatus
     */
    investments?: ItemStatusInvestments | null;
    /**
     *
     * @type {ItemStatusTransactions}
     * @memberof ItemStatus
     */
    transactions?: ItemStatusTransactions | null;
    /**
     *
     * @type {ItemStatusLastWebhook}
     * @memberof ItemStatus
     */
    last_webhook?: ItemStatusLastWebhook | null;
}
/**
 * Information about the last successful and failed investments update for the Item.
 * @export
 * @interface ItemStatusInvestments
 */
export interface ItemStatusInvestments {
    [key: string]: object | any;
    /**
     * [ISO 8601](https://wikipedia.org/wiki/ISO_8601) timestamp of the last successful investments update for the Item. The status will update each time Plaid successfully connects with the institution, regardless of whether any new data is available in the update.
     * @type {string}
     * @memberof ItemStatusInvestments
     */
    last_successful_update?: string | null;
    /**
     * [ISO 8601](https://wikipedia.org/wiki/ISO_8601) timestamp of the last failed investments update for the Item. The status will update each time Plaid fails an attempt to connect with the institution, regardless of whether any new data is available in the update.
     * @type {string}
     * @memberof ItemStatusInvestments
     */
    last_failed_update?: string | null;
}
/**
 * Information about the last webhook fired for the Item.
 * @export
 * @interface ItemStatusLastWebhook
 */
export interface ItemStatusLastWebhook {
    [key: string]: object | any;
    /**
     * [ISO 8601](https://wikipedia.org/wiki/ISO_8601) timestamp of when the webhook was fired.
     * @type {string}
     * @memberof ItemStatusLastWebhook
     */
    sent_at?: string | null;
    /**
     * The last webhook code sent.
     * @type {string}
     * @memberof ItemStatusLastWebhook
     */
    code_sent?: string | null;
}
/**
 * Information about the last successful and failed transactions update for the Item.
 * @export
 * @interface ItemStatusNullable
 */
export interface ItemStatusNullable {
    /**
     *
     * @type {ItemStatusInvestments}
     * @memberof ItemStatusNullable
     */
    investments?: ItemStatusInvestments | null;
    /**
     *
     * @type {ItemStatusTransactions}
     * @memberof ItemStatusNullable
     */
    transactions?: ItemStatusTransactions | null;
    /**
     *
     * @type {ItemStatusLastWebhook}
     * @memberof ItemStatusNullable
     */
    last_webhook?: ItemStatusLastWebhook | null;
}
/**
 * Information about the last successful and failed transactions update for the Item.
 * @export
 * @interface ItemStatusTransactions
 */
export interface ItemStatusTransactions {
    [key: string]: object | any;
    /**
     * [ISO 8601](https://wikipedia.org/wiki/ISO_8601) timestamp of the last successful transactions update for the Item. The status will update each time Plaid successfully connects with the institution, regardless of whether any new data is available in the update.
     * @type {string}
     * @memberof ItemStatusTransactions
     */
    last_successful_update?: string | null;
    /**
     * [ISO 8601](https://wikipedia.org/wiki/ISO_8601) timestamp of the last failed transactions update for the Item. The status will update each time Plaid fails an attempt to connect with the institution, regardless of whether any new data is available in the update.
     * @type {string}
     * @memberof ItemStatusTransactions
     */
    last_failed_update?: string | null;
}
/**
 * ItemWebhookUpdateRequest defines the request schema for `/item/webhook/update`
 * @export
 * @interface ItemWebhookUpdateRequest
 */
export interface ItemWebhookUpdateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ItemWebhookUpdateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ItemWebhookUpdateRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ItemWebhookUpdateRequest
     */
    access_token: string;
    /**
     * The new webhook URL to associate with the Item.
     * @type {string}
     * @memberof ItemWebhookUpdateRequest
     */
    webhook?: string | null;
}
/**
 * ItemWebhookUpdateResponse defines the response schema for `/item/webhook/update`
 * @export
 * @interface ItemWebhookUpdateResponse
 */
export interface ItemWebhookUpdateResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Item}
     * @memberof ItemWebhookUpdateResponse
     */
    item: Item;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ItemWebhookUpdateResponse
     */
    request_id: string;
}
/**
 * A JSON Web Key (JWK) that can be used in conjunction with [JWT libraries](https://jwt.io/#libraries-io) to verify Plaid webhooks
 * @export
 * @interface JWKPublicKey
 */
export interface JWKPublicKey {
    [key: string]: object | any;
    /**
     * The alg member identifies the cryptographic algorithm family used with the key.
     * @type {string}
     * @memberof JWKPublicKey
     */
    alg: string;
    /**
     * The crv member identifies the cryptographic curve used with the key.
     * @type {string}
     * @memberof JWKPublicKey
     */
    crv: string;
    /**
     * The kid (Key ID) member can be used to match a specific key. This can be used, for instance, to choose among a set of keys within the JWK during key rollover.
     * @type {string}
     * @memberof JWKPublicKey
     */
    kid: string;
    /**
     * The kty (key type) parameter identifies the cryptographic algorithm family used with the key, such as RSA or EC.
     * @type {string}
     * @memberof JWKPublicKey
     */
    kty: string;
    /**
     * The use (public key use) parameter identifies the intended use of the public key.
     * @type {string}
     * @memberof JWKPublicKey
     */
    use: string;
    /**
     * The x member contains the x coordinate for the elliptic curve point.
     * @type {string}
     * @memberof JWKPublicKey
     */
    x: string;
    /**
     * The y member contains the y coordinate for the elliptic curve point.
     * @type {string}
     * @memberof JWKPublicKey
     */
    y: string;
    /**
     * The timestamp when the key was created, in Unix time.
     * @type {number}
     * @memberof JWKPublicKey
     */
    created_at: number;
    /**
     * The timestamp when the key expired, in Unix time.
     * @type {number}
     * @memberof JWKPublicKey
     */
    expired_at: number | null;
}
/**
 * A JWT Header, used for webhook validation
 * @export
 * @interface JWTHeader
 */
export interface JWTHeader {
    [key: string]: object | any;
    /**
     *
     * @type {string}
     * @memberof JWTHeader
     */
    id: string;
}
/**
 * The webhook of type `LIABILITIES` and code `DEFAULT_UPDATE` will be fired when new or updated liabilities have been detected on a liabilities item.
 * @export
 * @interface LiabilitiesDefaultUpdateWebhook
 */
export interface LiabilitiesDefaultUpdateWebhook {
    /**
     * `LIABILITIES`
     * @type {string}
     * @memberof LiabilitiesDefaultUpdateWebhook
     */
    webhook_type: string;
    /**
     * `DEFAULT_UPDATE`
     * @type {string}
     * @memberof LiabilitiesDefaultUpdateWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof LiabilitiesDefaultUpdateWebhook
     */
    item_id: string;
    /**
     *
     * @type {PlaidError}
     * @memberof LiabilitiesDefaultUpdateWebhook
     */
    error: PlaidError;
    /**
     * An array of `account_id`\'s for accounts that contain new liabilities.\'
     * @type {Array<string>}
     * @memberof LiabilitiesDefaultUpdateWebhook
     */
    account_ids_with_new_liabilities: Array<string>;
    /**
     * An object with keys of `account_id`\'s that are mapped to their respective liabilities fields that changed.  Example: `{ \"XMBvvyMGQ1UoLbKByoMqH3nXMj84ALSdE5B58\": [\"past_amount_due\"] }`
     * @type {{ [key: string]: Array<string>; }}
     * @memberof LiabilitiesDefaultUpdateWebhook
     */
    account_ids_with_updated_liabilities: {
        [key: string]: Array<string>;
    };
}
/**
 * LiabilitiesGetRequest defines the request schema for `/liabilities/get`
 * @export
 * @interface LiabilitiesGetRequest
 */
export interface LiabilitiesGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof LiabilitiesGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof LiabilitiesGetRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof LiabilitiesGetRequest
     */
    access_token: string;
    /**
     *
     * @type {LiabilitiesGetRequestOptions}
     * @memberof LiabilitiesGetRequest
     */
    options?: LiabilitiesGetRequestOptions;
}
/**
 * An optional object to filter `/liabilities/get` results. If provided, `options` cannot be null.
 * @export
 * @interface LiabilitiesGetRequestOptions
 */
export interface LiabilitiesGetRequestOptions {
    /**
     * A list of accounts to retrieve for the Item.  An error will be returned if a provided `account_id` is not associated with the Item
     * @type {Array<string>}
     * @memberof LiabilitiesGetRequestOptions
     */
    account_ids?: Array<string>;
}
/**
 * LiabilitiesGetResponse defines the response schema for `/liabilities/get`
 * @export
 * @interface LiabilitiesGetResponse
 */
export interface LiabilitiesGetResponse {
    [key: string]: object | any;
    /**
     * An array of accounts associated with the Item
     * @type {Array<AccountBase>}
     * @memberof LiabilitiesGetResponse
     */
    accounts: Array<AccountBase>;
    /**
     *
     * @type {Item}
     * @memberof LiabilitiesGetResponse
     */
    item: Item;
    /**
     *
     * @type {LiabilitiesObject}
     * @memberof LiabilitiesGetResponse
     */
    liabilities: LiabilitiesObject;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof LiabilitiesGetResponse
     */
    request_id: string;
}
/**
 * An object containing liability accounts
 * @export
 * @interface LiabilitiesObject
 */
export interface LiabilitiesObject {
    [key: string]: object | any;
    /**
     * The credit accounts returned.
     * @type {Array<CreditCardLiability>}
     * @memberof LiabilitiesObject
     */
    credit: Array<CreditCardLiability> | null;
    /**
     * The mortgage accounts returned.
     * @type {Array<MortgageLiability>}
     * @memberof LiabilitiesObject
     */
    mortgage: Array<MortgageLiability> | null;
    /**
     * The student loan accounts returned.
     * @type {Array<StudentLoan>}
     * @memberof LiabilitiesObject
     */
    student: Array<StudentLoan> | null;
}
/**
 * Used to configure Sandbox test data for the Liabilities product
 * @export
 * @interface LiabilityOverride
 */
export interface LiabilityOverride {
    [key: string]: object | any;
    /**
     * The type of the liability object, either `credit` or `student`. Mortgages are not currently supported in the custom Sandbox.
     * @type {string}
     * @memberof LiabilityOverride
     */
    type: string;
    /**
     * The purchase APR percentage value. For simplicity, this is the only interest rate used to calculate interest charges. Can only be set if `type` is `credit`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    purchase_apr: number;
    /**
     * The cash APR percentage value. Can only be set if `type` is `credit`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    cash_apr: number;
    /**
     * The balance transfer APR percentage value. Can only be set if `type` is `credit`. Can only be set if `type` is `credit`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    balance_transfer_apr: number;
    /**
     * The special APR percentage value. Can only be set if `type` is `credit`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    special_apr: number;
    /**
     * Override the `last_payment_amount` field. Can only be set if `type` is `credit`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    last_payment_amount: number;
    /**
     * Override the `minimum_payment_amount` field. Can only be set if `type` is `credit` or `student`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    minimum_payment_amount: number;
    /**
     * Override the `is_overdue` field
     * @type {boolean}
     * @memberof LiabilityOverride
     */
    is_overdue: boolean;
    /**
     * The date on which the loan was initially lent, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format. Can only be set if `type` is `student`.
     * @type {string}
     * @memberof LiabilityOverride
     */
    origination_date: string;
    /**
     * The original loan principal. Can only be set if `type` is `student`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    principal: number;
    /**
     * The interest rate on the loan as a percentage. Can only be set if `type` is `student`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    nominal_apr: number;
    /**
     * If set, interest capitalization begins at the given number of months after loan origination. By default interest is never capitalized. Can only be set if `type` is `student`.
     * @type {number}
     * @memberof LiabilityOverride
     */
    interest_capitalization_grace_period_months: number;
    /**
     *
     * @type {StudentLoanRepaymentModel}
     * @memberof LiabilityOverride
     */
    repayment_model: StudentLoanRepaymentModel;
    /**
     * Override the `expected_payoff_date` field. Can only be set if `type` is `student`.
     * @type {string}
     * @memberof LiabilityOverride
     */
    expected_payoff_date: string;
    /**
     * Override the `guarantor` field. Can only be set if `type` is `student`.
     * @type {string}
     * @memberof LiabilityOverride
     */
    guarantor: string;
    /**
     * Override the `is_federal` field. Can only be set if `type` is `student`.
     * @type {boolean}
     * @memberof LiabilityOverride
     */
    is_federal: boolean;
    /**
     * Override the `loan_name` field. Can only be set if `type` is `student`.
     * @type {string}
     * @memberof LiabilityOverride
     */
    loan_name: string;
    /**
     *
     * @type {StudentLoanStatus}
     * @memberof LiabilityOverride
     */
    loan_status: StudentLoanStatus;
    /**
     * Override the `payment_reference_number` field. Can only be set if `type` is `student`.
     * @type {string}
     * @memberof LiabilityOverride
     */
    payment_reference_number: string;
    /**
     *
     * @type {PSLFStatus}
     * @memberof LiabilityOverride
     */
    pslf_status: PSLFStatus;
    /**
     * Override the `repayment_plan.description` field. Can only be set if `type` is `student`.
     * @type {string}
     * @memberof LiabilityOverride
     */
    repayment_plan_description: string;
    /**
     * Override the `repayment_plan.type` field. Can only be set if `type` is `student`. Possible values are: `\"extended graduated\"`, `\"extended standard\"`, `\"graduated\"`, `\"income-contingent repayment\"`, `\"income-based repayment\"`, `\"interest only\"`, `\"other\"`, `\"pay as you earn\"`, `\"revised pay as you earn\"`, or `\"standard\"`.
     * @type {string}
     * @memberof LiabilityOverride
     */
    repayment_plan_type: string;
    /**
     * Override the `sequence_number` field. Can only be set if `type` is `student`.
     * @type {string}
     * @memberof LiabilityOverride
     */
    sequence_number: string;
    /**
     *
     * @type {Address}
     * @memberof LiabilityOverride
     */
    servicer_address: Address;
}
/**
 * By default, Link will provide limited account filtering: it will only display Institutions that are compatible with all products supplied in the `products` parameter of `/link/token/create`, and, if `auth` is specified in the `products` array, will also filter out accounts other than `checking` and `savings` accounts on the Account Select pane. You can further limit the accounts shown in Link by using `account_filters` to specify the account subtypes to be shown in Link. Only the specified subtypes will be shown. This filtering applies to both the Account Select view (if enabled) and the Institution Select view. Institutions that do not support the selected subtypes will be omitted from Link. To indicate that all subtypes should be shown, use the value `\"all\"`. If the `account_filters` filter is used, any account type for which a filter is not specified will be entirely omitted from Link. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).  For institutions using OAuth, the filter will not affect the list of accounts shown by the bank in the OAuth window.
 * @export
 * @interface LinkTokenAccountFilters
 */
export interface LinkTokenAccountFilters {
    [key: string]: object | any;
    /**
     *
     * @type {DepositoryFilter}
     * @memberof LinkTokenAccountFilters
     */
    depository?: DepositoryFilter;
    /**
     *
     * @type {CreditFilter}
     * @memberof LinkTokenAccountFilters
     */
    credit?: CreditFilter;
    /**
     *
     * @type {LoanFilter}
     * @memberof LinkTokenAccountFilters
     */
    loan?: LoanFilter;
    /**
     *
     * @type {InvestmentFilter}
     * @memberof LinkTokenAccountFilters
     */
    investment?: InvestmentFilter;
}
/**
 * A filter to apply to `credit`-type accounts
 * @export
 * @interface LinkTokenCreateCreditFilter
 */
export interface LinkTokenCreateCreditFilter {
    [key: string]: object | any;
    /**
     * An array of account subtypes to display in Link. If not specified, all account subtypes will be shown. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).
     * @type {Array<CreditAccountSubtype>}
     * @memberof LinkTokenCreateCreditFilter
     */
    account_subtypes?: Array<CreditAccountSubtype>;
}
/**
 * A filter to apply to `depository`-type accounts
 * @export
 * @interface LinkTokenCreateDepositoryFilter
 */
export interface LinkTokenCreateDepositoryFilter {
    [key: string]: object | any;
    /**
     * An array of account subtypes to display in Link. If not specified, all account subtypes will be shown. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).
     * @type {Array<DepositoryAccountSubtype>}
     * @memberof LinkTokenCreateDepositoryFilter
     */
    account_subtypes?: Array<DepositoryAccountSubtype>;
}
/**
 * A filter to apply to `investment`-type accounts (or `brokerage`-type accounts for API versions 2018-05-22 and earlier).
 * @export
 * @interface LinkTokenCreateInvestmentFilter
 */
export interface LinkTokenCreateInvestmentFilter {
    [key: string]: object | any;
    /**
     * An array of account subtypes to display in Link. If not specified, all account subtypes will be shown. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).
     * @type {Array<InvestmentAccountSubtype>}
     * @memberof LinkTokenCreateInvestmentFilter
     */
    account_subtypes?: Array<InvestmentAccountSubtype>;
}
/**
 * A filter to apply to `loan`-type accounts
 * @export
 * @interface LinkTokenCreateLoanFilter
 */
export interface LinkTokenCreateLoanFilter {
    [key: string]: object | any;
    /**
     * An array of account subtypes to display in Link. If not specified, all account subtypes will be shown. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).
     * @type {Array<LoanAccountSubtype>}
     * @memberof LinkTokenCreateLoanFilter
     */
    account_subtypes?: Array<LoanAccountSubtype>;
}
/**
 * LinkTokenCreateRequest defines the request schema for `/link/token/create`
 * @export
 * @interface LinkTokenCreateRequest
 */
export interface LinkTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    secret?: string;
    /**
     * The name of your application, as it should be displayed in Link. Maximum length of 30 characters. If a value longer than 30 characters is provided, Link will display \"This Application\" instead.
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    client_name: string;
    /**
     * The language that Link should be displayed in.  Supported languages are: - English (`\'en\'`) - French (`\'fr\'`) - Spanish (`\'es\'`) - Dutch (`\'nl\'`) - German(`\'de\'`)  When using a Link customization, the language configured here must match the setting in the customization, or the customization will not be applied.
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    language: string;
    /**
     * Specify an array of Plaid-supported country codes using the ISO-3166-1 alpha-2 country code standard. Institutions from all listed countries will be shown.  Supported country codes are: `US`, `CA`, `DE`, `ES`, `FR`, `GB`, `IE`, `NL`. For a complete mapping of supported products by country, see https://plaid.com/global/.  If Link is launched with multiple country codes, only products that you are enabled for in all countries will be used by Link. Note that while all countries are enabled by default in Sandbox and Development, in Production only US and Canada are enabled by default. To gain access to European institutions in the Production environment, [file a product access Support ticket](https://dashboard.plaid.com/support/new/product-and-development/product-troubleshooting/request-product-access) via the Plaid dashboard. If you initialize with a European country code, your users will see the European consent panel during the Link flow.  If using a Link customization, make sure the country codes in the customization match those specified in `country_codes`. If both `country_codes` and a Link customization are used, the value in `country_codes` may override the value in the customization.  If using the Auth features Instant Match, Same-day Micro-deposits, or Automated Micro-deposits, `country_codes` must be set to `[\'US\']`.
     * @type {Array<CountryCode>}
     * @memberof LinkTokenCreateRequest
     */
    country_codes: Array<CountryCode>;
    /**
     *
     * @type {LinkTokenCreateRequestUser}
     * @memberof LinkTokenCreateRequest
     */
    user: LinkTokenCreateRequestUser;
    /**
     * List of Plaid product(s) you wish to use. If launching Link in update mode, should be omitted; required otherwise.  `balance` is *not* a valid value, the Balance product does not require explicit initialization and will automatically be initialized when any other product is initialized.  Only institutions that support *all* requested products will be shown in Link; to maximize the number of institutions listed, it is recommended to initialize Link with the minimal product set required for your use case. Additional products can be added after Link initialization by calling the relevant endpoints. For details and exceptions, see [Choosing when to initialize products](https://plaid.com/docs/link/best-practices/#choosing-when-to-initialize-products).  Note that, unless you have opted to disable Instant Match support, institutions that support Instant Match will also be shown in Link if `auth` is specified as a product, even though these institutions do not contain `auth` in their product array.  In Production, you will be billed for each product that you specify when initializing Link. Note that a product cannot be removed from an Item once the Item has been initialized with that product. To stop billing on an Item for subscription-based products, such as Liabilities, Investments, and Transactions, remove the Item via `/item/remove`.
     * @type {Array<Products>}
     * @memberof LinkTokenCreateRequest
     */
    products?: Array<Products>;
    /**
     * The destination URL to which any webhooks should be sent.
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    webhook?: string;
    /**
     * The `access_token` associated with the Item to update, used when updating or modifying an existing `access_token`. Used when launching Link in update mode, when completing the Same-day (manual) Micro-deposit flow, or (optionally) when initializing Link as part of the Payment Initiation (UK and Europe) flow.
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    access_token?: string;
    /**
     * The name of the Link customization from the Plaid Dashboard to be applied to Link. If not specified, the `default` customization will be used. When using a Link customization, the language in the customization must match the language selected via the `language` parameter, and the countries in the customization should match the country codes selected via `country_codes`.
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    link_customization_name?: string;
    /**
     * A URI indicating the destination where a user should be forwarded after completing the Link flow; used to support OAuth authentication flows when launching Link in the browser or via a webview. The `redirect_uri` should not contain any query parameters. When used in Production or Development, must be an https URI. To specify any subdomain, use `*` as a wildcard character, e.g. `https://_*.example.com/oauth.html`. If `android_package_name` is specified, this field should be left blank.  Note that any redirect URI must also be added to the Allowed redirect URIs list in the [developer dashboard](https://dashboard.plaid.com/team/api).
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    redirect_uri?: string;
    /**
     * The name of your app\'s Android package. Required if using the `link_token` to initialize Link on Android. When creating a `link_token` for initializing Link on other platforms, this field must be left blank. Any package name specified here must also be added to the Allowed Android package names setting on the [developer dashboard](https://dashboard.plaid.com/team/api).
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    android_package_name?: string;
    /**
     *
     * @type {LinkTokenAccountFilters}
     * @memberof LinkTokenCreateRequest
     */
    account_filters?: LinkTokenAccountFilters;
    /**
     *
     * @type {LinkTokenEUConfig}
     * @memberof LinkTokenCreateRequest
     */
    eu_config?: LinkTokenEUConfig;
    /**
     * Used for certain Europe-only configurations, as well as certain legacy use cases in other regions.
     * @type {string}
     * @memberof LinkTokenCreateRequest
     */
    institution_id?: string;
    /**
     *
     * @type {LinkTokenCreateRequestPaymentInitiation}
     * @memberof LinkTokenCreateRequest
     */
    payment_initiation?: LinkTokenCreateRequestPaymentInitiation;
    /**
     *
     * @type {LinkTokenCreateRequestDepositSwitch}
     * @memberof LinkTokenCreateRequest
     */
    deposit_switch?: LinkTokenCreateRequestDepositSwitch;
    /**
     *
     * @type {LinkTokenCreateRequestIncomeVerification}
     * @memberof LinkTokenCreateRequest
     */
    income_verification?: LinkTokenCreateRequestIncomeVerification;
    /**
     *
     * @type {LinkTokenCreateRequestAuth}
     * @memberof LinkTokenCreateRequest
     */
    auth?: LinkTokenCreateRequestAuth;
    /**
     *
     * @type {LinkTokenCreateRequestTransfer}
     * @memberof LinkTokenCreateRequest
     */
    transfer?: LinkTokenCreateRequestTransfer;
    /**
     *
     * @type {LinkTokenCreateRequestUpdate}
     * @memberof LinkTokenCreateRequest
     */
    update?: LinkTokenCreateRequestUpdate;
}
/**
 * By default, Link will only display account types that are compatible with all products supplied in the `products` parameter of `/link/token/create`. You can further limit the accounts shown in Link by using `account_filters` to specify the account subtypes to be shown in Link. Only the specified subtypes will be shown. This filtering applies to both the Account Select view (if enabled) and the Institution Select view. Institutions that do not support the selected subtypes will be omitted from Link. To indicate that all subtypes should be shown, use the value `\"all\"`. If the `account_filters` filter is used, any account type for which a filter is not specified will be entirely omitted from Link.  For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).  For institutions using OAuth, the filter will not affect the list of institutions or accounts shown by the bank in the OAuth window.
 * @export
 * @interface LinkTokenCreateRequestAccountSubtypes
 */
export interface LinkTokenCreateRequestAccountSubtypes {
    /**
     *
     * @type {LinkTokenCreateDepositoryFilter}
     * @memberof LinkTokenCreateRequestAccountSubtypes
     */
    depository?: LinkTokenCreateDepositoryFilter;
    /**
     *
     * @type {LinkTokenCreateCreditFilter}
     * @memberof LinkTokenCreateRequestAccountSubtypes
     */
    credit?: LinkTokenCreateCreditFilter;
    /**
     *
     * @type {LinkTokenCreateLoanFilter}
     * @memberof LinkTokenCreateRequestAccountSubtypes
     */
    loan?: LinkTokenCreateLoanFilter;
    /**
     *
     * @type {LinkTokenCreateInvestmentFilter}
     * @memberof LinkTokenCreateRequestAccountSubtypes
     */
    investment?: LinkTokenCreateInvestmentFilter;
}
/**
 * Specifies options for initializing Link for use with the Auth product. This field is currently only required if using the Flexible Auth product (currently in closed beta).
 * @export
 * @interface LinkTokenCreateRequestAuth
 */
export interface LinkTokenCreateRequestAuth {
    /**
     * The optional Auth flow to use. Currently only used to enable Flexible Auth.
     * @type {string}
     * @memberof LinkTokenCreateRequestAuth
     */
    flow_type: LinkTokenCreateRequestAuthFlowTypeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum LinkTokenCreateRequestAuthFlowTypeEnum {
    FlexibleAuth = "FLEXIBLE_AUTH"
}
/**
 * Specifies options for initializing Link for use with the Deposit Switch (beta) product. This field is required if `deposit_switch` is included in the `products` array.
 * @export
 * @interface LinkTokenCreateRequestDepositSwitch
 */
export interface LinkTokenCreateRequestDepositSwitch {
    /**
     * The `deposit_switch_id` provided by the `/deposit_switch/create` endpoint.
     * @type {string}
     * @memberof LinkTokenCreateRequestDepositSwitch
     */
    deposit_switch_id: string;
}
/**
 * Specifies options for initializing Link for use with the Income (beta) product. This field is required if `income_verification` is included in the `products` array.
 * @export
 * @interface LinkTokenCreateRequestIncomeVerification
 */
export interface LinkTokenCreateRequestIncomeVerification {
    /**
     * The `income_verification_id` of the verification instance, as provided by `/income/verification/create`.
     * @type {string}
     * @memberof LinkTokenCreateRequestIncomeVerification
     * @deprecated
     */
    income_verification_id?: string;
    /**
     * The `asset_report_id` of an asset report associated with the user, as provided by `/asset_report/create`. Providing an `asset_report_id` is optional and can be used to verify the user through a streamlined flow. If provided, the bank linking flow will be skipped.
     * @type {string}
     * @memberof LinkTokenCreateRequestIncomeVerification
     */
    asset_report_id?: string;
    /**
     * The ID of a precheck created with `/income/verification/precheck`. Will be used to improve conversion of the income verification flow by streamlining the Link interface presented to the end user.
     * @type {string}
     * @memberof LinkTokenCreateRequestIncomeVerification
     */
    precheck_id?: string;
    /**
     * An array of access tokens corresponding to the Items that will be cross-referenced with the product data. If the `transactions` product was not initialized for the Items during link, it will be initialized after this Link session.
     * @type {Array<string>}
     * @memberof LinkTokenCreateRequestIncomeVerification
     */
    access_tokens?: Array<string>;
}
/**
 * Specifies options for initializing Link for use with the Payment Initiation (Europe) product. This field is required if `payment_initiation` is included in the `products` array.
 * @export
 * @interface LinkTokenCreateRequestPaymentInitiation
 */
export interface LinkTokenCreateRequestPaymentInitiation {
    /**
     * The `payment_id` provided by the `/payment_initiation/payment/create` endpoint.
     * @type {string}
     * @memberof LinkTokenCreateRequestPaymentInitiation
     */
    payment_id: string;
}
/**
 * Specifies options for initializing Link for use with the Transfer product.
 * @export
 * @interface LinkTokenCreateRequestTransfer
 */
export interface LinkTokenCreateRequestTransfer {
    /**
     * The `id` returned by the `/transfer/intent/create` endpoint.
     * @type {string}
     * @memberof LinkTokenCreateRequestTransfer
     */
    intent_id?: string;
}
/**
 * Specifies options for initializing Link for [update mode](https://plaid.com/docs/link/update-mode).
 * @export
 * @interface LinkTokenCreateRequestUpdate
 */
export interface LinkTokenCreateRequestUpdate {
    /**
     * If `true`, enables [update mode with Account Select](https://plaid.com/docs/link/update-mode/#using-update-mode-to-request-new-accounts).
     * @type {boolean}
     * @memberof LinkTokenCreateRequestUpdate
     */
    account_selection_enabled?: boolean;
}
/**
 * An object specifying information about the end user who will be linking their account.
 * @export
 * @interface LinkTokenCreateRequestUser
 */
export interface LinkTokenCreateRequestUser {
    /**
     * A unique ID representing the end user. Typically this will be a user ID number from your application. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`. It is currently used as a means of searching logs for the given user in the Plaid Dashboard.
     * @type {string}
     * @memberof LinkTokenCreateRequestUser
     */
    client_user_id: string;
    /**
     * The user\'s full legal name. This is an optional field used in the [returning user experience](https://plaid.com/docs/link/returning-user) to associate Items to the user.
     * @type {string}
     * @memberof LinkTokenCreateRequestUser
     */
    legal_name?: string;
    /**
     * The user\'s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. This field is optional, but required to enable the [returning user experience](https://plaid.com/docs/link/returning-user).
     * @type {string}
     * @memberof LinkTokenCreateRequestUser
     */
    phone_number?: string;
    /**
     * The date and time the phone number was verified in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDThh:mm:ssZ`). This field is optional, but required to enable any [returning user experience](https://plaid.com/docs/link/returning-user).   Only pass a verification time for a phone number that you have verified. If you have performed verification but don’t have the time, you may supply a signal value of the start of the UNIX epoch.   Example: `2020-01-01T00:00:00Z`
     * @type {string}
     * @memberof LinkTokenCreateRequestUser
     */
    phone_number_verified_time?: string;
    /**
     * The user\'s email address. This field is optional, but required to enable the [pre-authenticated returning user flow](https://plaid.com/docs/link/returning-user/#enabling-the-returning-user-experience).
     * @type {string}
     * @memberof LinkTokenCreateRequestUser
     */
    email_address?: string;
    /**
     * The date and time the email address was verified in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDThh:mm:ssZ`). This is an optional field used in the [returning user experience](https://plaid.com/docs/link/returning-user).   Only pass a verification time for an email address that you have verified. If you have performed verification but don’t have the time, you may supply a signal value of the start of the UNIX epoch.   Example: `2020-01-01T00:00:00Z`
     * @type {string}
     * @memberof LinkTokenCreateRequestUser
     */
    email_address_verified_time?: string;
    /**
     * To be provided in the format \"ddd-dd-dddd\". This field is optional and will support not-yet-implemented functionality for new products.
     * @type {string}
     * @memberof LinkTokenCreateRequestUser
     */
    ssn?: string;
    /**
     * To be provided in the format \"yyyy-mm-dd\". This field is optional and will support not-yet-implemented functionality for new products.
     * @type {string}
     * @memberof LinkTokenCreateRequestUser
     */
    date_of_birth?: string;
}
/**
 * LinkTokenCreateResponse defines the response schema for `/link/token/create`
 * @export
 * @interface LinkTokenCreateResponse
 */
export interface LinkTokenCreateResponse {
    [key: string]: object | any;
    /**
     * A `link_token`, which can be supplied to Link in order to initialize it and receive a `public_token`, which can be exchanged for an `access_token`.
     * @type {string}
     * @memberof LinkTokenCreateResponse
     */
    link_token: string;
    /**
     * The expiration date for the `link_token`, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format. A `link_token` created to generate a `public_token` that will be exchanged for a new `access_token` expires after 4 hours. A `link_token` created for an existing Item (such as when updating an existing `access_token` by launching Link in update mode) expires after 30 minutes.
     * @type {string}
     * @memberof LinkTokenCreateResponse
     */
    expiration: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof LinkTokenCreateResponse
     */
    request_id: string;
}
/**
 * Configuration parameters for EU flows
 * @export
 * @interface LinkTokenEUConfig
 */
export interface LinkTokenEUConfig {
    /**
     * If `true`, open Link without an initial UI. Defaults to `false`.
     * @type {boolean}
     * @memberof LinkTokenEUConfig
     */
    headless?: boolean;
}
/**
 * An object specifying the arguments originally provided to the `/link/token/create` call.
 * @export
 * @interface LinkTokenGetMetadataResponse
 */
export interface LinkTokenGetMetadataResponse {
    [key: string]: object | any;
    /**
     * The `products` specified in the `/link/token/create` call.
     * @type {Array<Products>}
     * @memberof LinkTokenGetMetadataResponse
     */
    initial_products: Array<Products>;
    /**
     * The `webhook` specified in the `/link/token/create` call.
     * @type {string}
     * @memberof LinkTokenGetMetadataResponse
     */
    webhook: string | null;
    /**
     * The `country_codes` specified in the `/link/token/create` call.
     * @type {Array<CountryCode>}
     * @memberof LinkTokenGetMetadataResponse
     */
    country_codes: Array<CountryCode>;
    /**
     * The `language` specified in the `/link/token/create` call.
     * @type {string}
     * @memberof LinkTokenGetMetadataResponse
     */
    language: string | null;
    /**
     *
     * @type {AccountFiltersResponse}
     * @memberof LinkTokenGetMetadataResponse
     */
    account_filters?: AccountFiltersResponse;
    /**
     * The `redirect_uri` specified in the `/link/token/create` call.
     * @type {string}
     * @memberof LinkTokenGetMetadataResponse
     */
    redirect_uri: string | null;
    /**
     * The `client_name` specified in the `/link/token/create` call.
     * @type {string}
     * @memberof LinkTokenGetMetadataResponse
     */
    client_name: string | null;
}
/**
 * LinkTokenGetRequest defines the request schema for `/link/token/get`
 * @export
 * @interface LinkTokenGetRequest
 */
export interface LinkTokenGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof LinkTokenGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof LinkTokenGetRequest
     */
    secret?: string;
    /**
     * A `link_token` from a previous invocation of `/link/token/create`
     * @type {string}
     * @memberof LinkTokenGetRequest
     */
    link_token: string;
}
/**
 * LinkTokenGetResponse defines the response schema for `/link/token/get`
 * @export
 * @interface LinkTokenGetResponse
 */
export interface LinkTokenGetResponse {
    [key: string]: object | any;
    /**
     * A `link_token`, which can be supplied to Link in order to initialize it and receive a `public_token`, which can be exchanged for an `access_token`.
     * @type {string}
     * @memberof LinkTokenGetResponse
     */
    link_token: string;
    /**
     * The creation timestamp for the `link_token`, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.
     * @type {string}
     * @memberof LinkTokenGetResponse
     */
    created_at: string | null;
    /**
     * The expiration timestamp for the `link_token`, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.
     * @type {string}
     * @memberof LinkTokenGetResponse
     */
    expiration: string | null;
    /**
     *
     * @type {LinkTokenGetMetadataResponse}
     * @memberof LinkTokenGetResponse
     */
    metadata: LinkTokenGetMetadataResponse;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof LinkTokenGetResponse
     */
    request_id: string;
}
/**
 * Valid account subtypes for loan accounts. For a list containing descriptions of each subtype, see [Account schemas](https://plaid.com/docs/api/accounts/#StandaloneAccountType-loan).
 * @export
 * @enum {string}
 */
export declare enum LoanAccountSubtype {
    Auto = "auto",
    Business = "business",
    Commercial = "commercial",
    Construction = "construction",
    Consumer = "consumer",
    HomeEquity = "home equity",
    Loan = "loan",
    Mortgage = "mortgage",
    LineOfCredit = "line of credit",
    Student = "student",
    Other = "other",
    All = "all"
}
/**
 * A filter to apply to `loan`-type accounts
 * @export
 * @interface LoanFilter
 */
export interface LoanFilter {
    [key: string]: object | any;
    /**
     * An array of account subtypes to display in Link. If not specified, all account subtypes will be shown. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).
     * @type {Array<LoanAccountSubtype>}
     * @memberof LoanFilter
     */
    account_subtypes: Array<LoanAccountSubtype>;
}
/**
 * A representation of where a transaction took place
 * @export
 * @interface Location
 */
export interface Location {
    [key: string]: object | any;
    /**
     * The street address where the transaction occurred.
     * @type {string}
     * @memberof Location
     */
    address: string | null;
    /**
     * The city where the transaction occurred.
     * @type {string}
     * @memberof Location
     */
    city: string | null;
    /**
     * The region or state where the transaction occurred. In API versions 2018-05-22 and earlier, this field is called `state`.
     * @type {string}
     * @memberof Location
     */
    region: string | null;
    /**
     * The postal code where the transaction occurred. In API versions 2018-05-22 and earlier, this field is called `zip`.
     * @type {string}
     * @memberof Location
     */
    postal_code: string | null;
    /**
     * The ISO 3166-1 alpha-2 country code where the transaction occurred.
     * @type {string}
     * @memberof Location
     */
    country: string | null;
    /**
     * The latitude where the transaction occurred.
     * @type {number}
     * @memberof Location
     */
    lat: number | null;
    /**
     * The longitude where the transaction occurred.
     * @type {number}
     * @memberof Location
     */
    lon: number | null;
    /**
     * The merchant defined store number where the transaction occurred.
     * @type {string}
     * @memberof Location
     */
    store_number: string | null;
}
/**
 * Specifies the multi-factor authentication settings to use with this test account
 * @export
 * @interface MFA
 */
export interface MFA {
    [key: string]: object | any;
    /**
     * Possible values are `device`, `selections`, or `questions`.  If value is `device`, the MFA answer is `1234`.  If value is `selections`, the MFA answer is always the first option.  If value is `questions`, the MFA answer is  `answer_<i>_<j>` for the j-th question in the i-th round, starting from 0. For example, the answer to the first question in the second round is `answer_1_0`.
     * @type {string}
     * @memberof MFA
     */
    type: string;
    /**
     * Number of rounds of questions. Required if value of `type` is `questions`.
     * @type {number}
     * @memberof MFA
     */
    question_rounds: number;
    /**
     * Number of questions per round. Required if value of `type` is `questions`. If value of type is `selections`, default value is 2.
     * @type {number}
     * @memberof MFA
     */
    questions_per_round: number;
    /**
     * Number of rounds of selections, used if `type` is `selections`. Defaults to 1.
     * @type {number}
     * @memberof MFA
     */
    selection_rounds: number;
    /**
     * Number of available answers per question, used if `type` is `selection`. Defaults to 2.
     * @type {number}
     * @memberof MFA
     */
    selections_per_question: number;
}
/**
 * Allows specifying the metadata of the test account
 * @export
 * @interface Meta
 */
export interface Meta {
    [key: string]: object | any;
    /**
     * The account\'s name
     * @type {string}
     * @memberof Meta
     */
    name: string;
    /**
     * The account\'s official name
     * @type {string}
     * @memberof Meta
     */
    official_name: string;
    /**
     * The account\'s limit
     * @type {number}
     * @memberof Meta
     */
    limit: number;
}
/**
 * We use standard HTTP response codes for success and failure notifications, and our errors are further classified by `error_type`. In general, 200 HTTP codes correspond to success, 40X codes are for developer- or user-related failures, and 50X codes are for Plaid-related issues.  Error fields will be `null` if no error has occurred.
 * @export
 * @interface ModelError
 */
export interface ModelError {
    [key: string]: object | any;
    /**
     * A broad categorization of the error. Safe for programmatic use.
     * @type {string}
     * @memberof ModelError
     */
    error_type: ModelErrorErrorTypeEnum;
    /**
     * The particular error code. Safe for programmatic use.
     * @type {string}
     * @memberof ModelError
     */
    error_code: string;
    /**
     * A developer-friendly representation of the error code. This may change over time and is not safe for programmatic use.
     * @type {string}
     * @memberof ModelError
     */
    error_message: string;
    /**
     * A user-friendly representation of the error code. `null` if the error is not related to user action.  This may change over time and is not safe for programmatic use.
     * @type {string}
     * @memberof ModelError
     */
    display_message: string | null;
    /**
     * A unique ID identifying the request, to be used for troubleshooting purposes. This field will be omitted in errors provided by webhooks.
     * @type {string}
     * @memberof ModelError
     */
    request_id?: string;
    /**
     * In the Assets product, a request can pertain to more than one Item. If an error is returned for such a request, `causes` will return an array of errors containing a breakdown of these errors on the individual Item level, if any can be identified.  `causes` will only be provided for the `error_type` `ASSET_REPORT_ERROR`. `causes` will also not be populated inside an error nested within a `warning` object.
     * @type {Array<any>}
     * @memberof ModelError
     */
    causes?: Array<any>;
    /**
     * The HTTP status code associated with the error. This will only be returned in the response body when the error information is provided via a webhook.
     * @type {number}
     * @memberof ModelError
     */
    status?: number | null;
    /**
     * The URL of a Plaid documentation page with more information about the error
     * @type {string}
     * @memberof ModelError
     */
    documentation_url?: string;
    /**
     * Suggested steps for resolving the error
     * @type {string}
     * @memberof ModelError
     */
    suggested_action?: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum ModelErrorErrorTypeEnum {
    InvalidRequest = "INVALID_REQUEST",
    InvalidResult = "INVALID_RESULT",
    InvalidInput = "INVALID_INPUT",
    InstitutionError = "INSTITUTION_ERROR",
    RateLimitExceeded = "RATE_LIMIT_EXCEEDED",
    ApiError = "API_ERROR",
    ItemError = "ITEM_ERROR",
    AssetReportError = "ASSET_REPORT_ERROR",
    RecaptchaError = "RECAPTCHA_ERROR",
    OauthError = "OAUTH_ERROR",
    PaymentError = "PAYMENT_ERROR",
    BankTransferError = "BANK_TRANSFER_ERROR",
    IncomeVerificationError = "INCOME_VERIFICATION_ERROR"
}
/**
 * Object containing metadata about the interest rate for the mortgage.
 * @export
 * @interface MortgageInterestRate
 */
export interface MortgageInterestRate {
    [key: string]: object | any;
    /**
     * Percentage value (interest rate of current mortgage, not APR) of interest payable on a loan.
     * @type {number}
     * @memberof MortgageInterestRate
     */
    percentage: number | null;
    /**
     * The type of interest charged (fixed or variable).
     * @type {string}
     * @memberof MortgageInterestRate
     */
    type: string | null;
}
/**
 * Contains details about a mortgage account.
 * @export
 * @interface MortgageLiability
 */
export interface MortgageLiability {
    [key: string]: object | any;
    /**
     * The ID of the account that this liability belongs to.
     * @type {string}
     * @memberof MortgageLiability
     */
    account_id: string;
    /**
     * The account number of the loan.
     * @type {string}
     * @memberof MortgageLiability
     */
    account_number: string;
    /**
     * The current outstanding amount charged for late payment.
     * @type {number}
     * @memberof MortgageLiability
     */
    current_late_fee: number | null;
    /**
     * Total amount held in escrow to pay taxes and insurance on behalf of the borrower.
     * @type {number}
     * @memberof MortgageLiability
     */
    escrow_balance: number | null;
    /**
     * Indicates whether the borrower has private mortgage insurance in effect.
     * @type {boolean}
     * @memberof MortgageLiability
     */
    has_pmi: boolean | null;
    /**
     * Indicates whether the borrower will pay a penalty for early payoff of mortgage.
     * @type {boolean}
     * @memberof MortgageLiability
     */
    has_prepayment_penalty: boolean | null;
    /**
     *
     * @type {MortgageInterestRate}
     * @memberof MortgageLiability
     */
    interest_rate: MortgageInterestRate;
    /**
     * The amount of the last payment.
     * @type {number}
     * @memberof MortgageLiability
     */
    last_payment_amount: number | null;
    /**
     * The date of the last payment. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof MortgageLiability
     */
    last_payment_date: string | null;
    /**
     * Description of the type of loan, for example `conventional`, `fixed`, or `variable`. This field is provided directly from the loan servicer and does not have an enumerated set of possible values.
     * @type {string}
     * @memberof MortgageLiability
     */
    loan_type_description: string | null;
    /**
     * Full duration of mortgage as at origination (e.g. `10 year`).
     * @type {string}
     * @memberof MortgageLiability
     */
    loan_term: string | null;
    /**
     * Original date on which mortgage is due in full. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof MortgageLiability
     */
    maturity_date: string | null;
    /**
     * The amount of the next payment.
     * @type {number}
     * @memberof MortgageLiability
     */
    next_monthly_payment: number | null;
    /**
     * The due date for the next payment. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof MortgageLiability
     */
    next_payment_due_date: string | null;
    /**
     * The date on which the loan was initially lent. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof MortgageLiability
     */
    origination_date: string | null;
    /**
     * The original principal balance of the mortgage.
     * @type {number}
     * @memberof MortgageLiability
     */
    origination_principal_amount: number | null;
    /**
     * Amount of loan (principal + interest) past due for payment.
     * @type {number}
     * @memberof MortgageLiability
     */
    past_due_amount: number | null;
    /**
     *
     * @type {MortgagePropertyAddress}
     * @memberof MortgageLiability
     */
    property_address: MortgagePropertyAddress;
    /**
     * The year to date (YTD) interest paid.
     * @type {number}
     * @memberof MortgageLiability
     */
    ytd_interest_paid: number | null;
    /**
     * The YTD principal paid.
     * @type {number}
     * @memberof MortgageLiability
     */
    ytd_principal_paid: number | null;
}
/**
 * Object containing fields describing property address.
 * @export
 * @interface MortgagePropertyAddress
 */
export interface MortgagePropertyAddress {
    [key: string]: object | any;
    /**
     * The city name.
     * @type {string}
     * @memberof MortgagePropertyAddress
     */
    city: string | null;
    /**
     * The ISO 3166-1 alpha-2 country code.
     * @type {string}
     * @memberof MortgagePropertyAddress
     */
    country: string | null;
    /**
     * The five or nine digit postal code.
     * @type {string}
     * @memberof MortgagePropertyAddress
     */
    postal_code: string | null;
    /**
     * The region or state (example \"NC\").
     * @type {string}
     * @memberof MortgagePropertyAddress
     */
    region: string | null;
    /**
     * The full street address (example \"564 Main Street, Apt 15\").
     * @type {string}
     * @memberof MortgagePropertyAddress
     */
    street: string | null;
}
/**
 * An object representing information about the net pay amount on the paystub.
 * @export
 * @interface NetPay
 */
export interface NetPay {
    [key: string]: object | any;
    /**
     * Raw amount of the net pay for the pay period
     * @type {number}
     * @memberof NetPay
     */
    current_amount?: number | null;
    /**
     * Description of the net pay
     * @type {string}
     * @memberof NetPay
     */
    description?: string | null;
    /**
     * The ISO-4217 currency code of the net pay. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof NetPay
     */
    iso_currency_code?: string | null;
    /**
     * The unofficial currency code associated with the net pay. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof NetPay
     */
    unofficial_currency_code?: string | null;
    /**
     * The year-to-date amount of the net pay
     * @type {number}
     * @memberof NetPay
     */
    ytd_amount?: number | null;
    /**
     *
     * @type {Total}
     * @memberof NetPay
     * @deprecated
     */
    total?: Total;
}
/**
 * Fired when Plaid detects a new account for Items created or updated with [Account Select v2](https://plaid.com/docs/link/customization/#account-select). Upon receiving this webhook, you can prompt your users to share new accounts with you through [Account Select v2 update mode](https://plaid.com/docs/link/update-mode/#using-update-mode-to-request-new-accounts).
 * @export
 * @interface NewAccountsAvailableWebhook
 */
export interface NewAccountsAvailableWebhook {
    /**
     * `ITEM`
     * @type {string}
     * @memberof NewAccountsAvailableWebhook
     */
    webhook_type?: string;
    /**
     * `NEW_ACCOUNTS_AVAILABLE`
     * @type {string}
     * @memberof NewAccountsAvailableWebhook
     */
    webhook_code?: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof NewAccountsAvailableWebhook
     */
    item_id?: string;
    /**
     *
     * @type {PlaidError}
     * @memberof NewAccountsAvailableWebhook
     */
    error?: PlaidError;
}
/**
 * Account and bank identifier number data used to configure the test account. All values are optional.
 * @export
 * @interface Numbers
 */
export interface Numbers {
    [key: string]: object | any;
    /**
     * Will be used for the account number.
     * @type {string}
     * @memberof Numbers
     */
    account?: string;
    /**
     * Must be a valid ACH routing number.
     * @type {string}
     * @memberof Numbers
     */
    ach_routing?: string;
    /**
     * Must be a valid wire transfer routing number.
     * @type {string}
     * @memberof Numbers
     */
    ach_wire_routing?: string;
    /**
     * EFT institution number. Must be specified alongside `eft_branch`.
     * @type {string}
     * @memberof Numbers
     */
    eft_institution?: string;
    /**
     * EFT branch number. Must be specified alongside `eft_institution`.
     * @type {string}
     * @memberof Numbers
     */
    eft_branch?: string;
    /**
     * Bank identifier code (BIC). Must be specified alongside `international_iban`.
     * @type {string}
     * @memberof Numbers
     */
    international_bic?: string;
    /**
     * International bank account number (IBAN). If no account number is specified via `account`, will also be used as the account number by default. Must be specified alongside `international_bic`.
     * @type {string}
     * @memberof Numbers
     */
    international_iban?: string;
    /**
     * BACS sort code
     * @type {string}
     * @memberof Numbers
     */
    bacs_sort_code?: string;
}
/**
 * Identifying information for transferring money to or from a US account via ACH or wire transfer.
 * @export
 * @interface NumbersACH
 */
export interface NumbersACH {
    [key: string]: object | any;
    /**
     * The Plaid account ID associated with the account numbers
     * @type {string}
     * @memberof NumbersACH
     */
    account_id: string;
    /**
     * The ACH account number for the account.  Note that when using OAuth with Chase Bank (`ins_56`), Chase will issue \"tokenized\" routing and account numbers, which are not the user\'s actual account and routing numbers. These tokenized numbers should work identically to normal account and routing numbers. The digits returned in the `mask` field will continue to reflect the actual account number, rather than the tokenized account number; for this reason, when displaying account numbers to the user to help them identify their account in your UI, always use the `mask` rather than truncating the `account` number. If a user revokes their permissions to your app, the tokenized numbers will continue to work for ACH deposits, but not withdrawals.
     * @type {string}
     * @memberof NumbersACH
     */
    account: string;
    /**
     * The ACH routing number for the account. If the institution is `ins_56`, this may be a tokenized routing number. For more information, see the description of the `account` field.
     * @type {string}
     * @memberof NumbersACH
     */
    routing: string;
    /**
     * The wire transfer routing number for the account, if available
     * @type {string}
     * @memberof NumbersACH
     */
    wire_routing: string | null;
}
/**
 * Identifying information for transferring money to or from a US account via ACH or wire transfer.
 * @export
 * @interface NumbersACHNullable
 */
export interface NumbersACHNullable {
    /**
     * The Plaid account ID associated with the account numbers
     * @type {string}
     * @memberof NumbersACHNullable
     */
    account_id: string;
    /**
     * The ACH account number for the account.  Note that when using OAuth with Chase Bank (`ins_56`), Chase will issue \"tokenized\" routing and account numbers, which are not the user\'s actual account and routing numbers. These tokenized numbers should work identically to normal account and routing numbers. The digits returned in the `mask` field will continue to reflect the actual account number, rather than the tokenized account number; for this reason, when displaying account numbers to the user to help them identify their account in your UI, always use the `mask` rather than truncating the `account` number. If a user revokes their permissions to your app, the tokenized numbers will continue to work for ACH deposits, but not withdrawals.
     * @type {string}
     * @memberof NumbersACHNullable
     */
    account: string;
    /**
     * The ACH routing number for the account. If the institution is `ins_56`, this may be a tokenized routing number. For more information, see the description of the `account` field.
     * @type {string}
     * @memberof NumbersACHNullable
     */
    routing: string;
    /**
     * The wire transfer routing number for the account, if available
     * @type {string}
     * @memberof NumbersACHNullable
     */
    wire_routing: string | null;
}
/**
 * Identifying information for transferring money to or from a UK bank account via BACS.
 * @export
 * @interface NumbersBACS
 */
export interface NumbersBACS {
    [key: string]: object | any;
    /**
     * The Plaid account ID associated with the account numbers
     * @type {string}
     * @memberof NumbersBACS
     */
    account_id: string;
    /**
     * The BACS account number for the account
     * @type {string}
     * @memberof NumbersBACS
     */
    account: string;
    /**
     * The BACS sort code for the account
     * @type {string}
     * @memberof NumbersBACS
     */
    sort_code: string;
}
/**
 * Identifying information for transferring money to or from a UK bank account via BACS.
 * @export
 * @interface NumbersBACSNullable
 */
export interface NumbersBACSNullable {
    /**
     * The Plaid account ID associated with the account numbers
     * @type {string}
     * @memberof NumbersBACSNullable
     */
    account_id: string;
    /**
     * The BACS account number for the account
     * @type {string}
     * @memberof NumbersBACSNullable
     */
    account: string;
    /**
     * The BACS sort code for the account
     * @type {string}
     * @memberof NumbersBACSNullable
     */
    sort_code: string;
}
/**
 * Identifying information for transferring money to or from a Canadian bank account via EFT.
 * @export
 * @interface NumbersEFT
 */
export interface NumbersEFT {
    [key: string]: object | any;
    /**
     * The Plaid account ID associated with the account numbers
     * @type {string}
     * @memberof NumbersEFT
     */
    account_id: string;
    /**
     * The EFT account number for the account
     * @type {string}
     * @memberof NumbersEFT
     */
    account: string;
    /**
     * The EFT institution number for the account
     * @type {string}
     * @memberof NumbersEFT
     */
    institution: string;
    /**
     * The EFT branch number for the account
     * @type {string}
     * @memberof NumbersEFT
     */
    branch: string;
}
/**
 * Identifying information for transferring money to or from a Canadian bank account via EFT.
 * @export
 * @interface NumbersEFTNullable
 */
export interface NumbersEFTNullable {
    /**
     * The Plaid account ID associated with the account numbers
     * @type {string}
     * @memberof NumbersEFTNullable
     */
    account_id: string;
    /**
     * The EFT account number for the account
     * @type {string}
     * @memberof NumbersEFTNullable
     */
    account: string;
    /**
     * The EFT institution number for the account
     * @type {string}
     * @memberof NumbersEFTNullable
     */
    institution: string;
    /**
     * The EFT branch number for the account
     * @type {string}
     * @memberof NumbersEFTNullable
     */
    branch: string;
}
/**
 * Identifying information for transferring money to or from an international bank account via wire transfer.
 * @export
 * @interface NumbersInternational
 */
export interface NumbersInternational {
    [key: string]: object | any;
    /**
     * The Plaid account ID associated with the account numbers
     * @type {string}
     * @memberof NumbersInternational
     */
    account_id: string;
    /**
     * The International Bank Account Number (IBAN) for the account
     * @type {string}
     * @memberof NumbersInternational
     */
    iban: string;
    /**
     * The Bank Identifier Code (BIC) for the account
     * @type {string}
     * @memberof NumbersInternational
     */
    bic: string;
}
/**
 * Identifying information for transferring money to or from an international bank account via wire transfer.
 * @export
 * @interface NumbersInternationalNullable
 */
export interface NumbersInternationalNullable {
    /**
     * The Plaid account ID associated with the account numbers
     * @type {string}
     * @memberof NumbersInternationalNullable
     */
    account_id: string;
    /**
     * The International Bank Account Number (IBAN) for the account
     * @type {string}
     * @memberof NumbersInternationalNullable
     */
    iban: string;
    /**
     * The Bank Identifier Code (BIC) for the account
     * @type {string}
     * @memberof NumbersInternationalNullable
     */
    bic: string;
}
/**
 * `investment:` Investment account.  `credit:` Credit card  `depository:` Depository account  `loan:` Loan account  `payroll:` Payroll account  `other:` Non-specified account type  See the [Account type schema](https://plaid.com/docs/api/accounts#account-type-schema) for a full listing of account types and corresponding subtypes.
 * @export
 * @enum {string}
 */
export declare enum OverrideAccountType {
    Investment = "investment",
    Credit = "credit",
    Depository = "depository",
    Loan = "loan",
    Payroll = "payroll",
    Other = "other"
}
/**
 * Data to use to set values of test accounts. Some values cannot be specified in the schema and will instead will be calculated from other test data in order to achieve more consistent, realistic test data.
 * @export
 * @interface OverrideAccounts
 */
export interface OverrideAccounts {
    [key: string]: object | any;
    /**
     *
     * @type {OverrideAccountType}
     * @memberof OverrideAccounts
     */
    type: OverrideAccountType;
    /**
     *
     * @type {AccountSubtype}
     * @memberof OverrideAccounts
     */
    subtype: AccountSubtype | null;
    /**
     * If provided, the account will start with this amount as the current balance.
     * @type {number}
     * @memberof OverrideAccounts
     */
    starting_balance: number;
    /**
     * If provided, the account will always have this amount as its  available balance, regardless of current balance or changes in transactions over time.
     * @type {number}
     * @memberof OverrideAccounts
     */
    force_available_balance: number;
    /**
     * ISO-4217 currency code. If provided, the account will be denominated in the given currency. Transactions will also be in this currency by default.
     * @type {string}
     * @memberof OverrideAccounts
     */
    currency: string;
    /**
     *
     * @type {Meta}
     * @memberof OverrideAccounts
     */
    meta: Meta;
    /**
     *
     * @type {Numbers}
     * @memberof OverrideAccounts
     */
    numbers: Numbers;
    /**
     * Specify the list of transactions on the account.
     * @type {Array<TransactionOverride>}
     * @memberof OverrideAccounts
     */
    transactions: Array<TransactionOverride>;
    /**
     *
     * @type {HoldingsOverride}
     * @memberof OverrideAccounts
     */
    holdings?: HoldingsOverride;
    /**
     *
     * @type {InvestmentsTransactionsOverride}
     * @memberof OverrideAccounts
     */
    investment_transactions?: InvestmentsTransactionsOverride;
    /**
     *
     * @type {OwnerOverride}
     * @memberof OverrideAccounts
     */
    identity: OwnerOverride;
    /**
     *
     * @type {LiabilityOverride}
     * @memberof OverrideAccounts
     */
    liability: LiabilityOverride;
    /**
     *
     * @type {InflowModel}
     * @memberof OverrideAccounts
     */
    inflow_model: InflowModel;
    /**
     *
     * @type {IncomeOverride}
     * @memberof OverrideAccounts
     */
    income?: IncomeOverride;
}
/**
 * Data returned from the financial institution about the owner or owners of an account. Only the `names` array must be non-empty.
 * @export
 * @interface Owner
 */
export interface Owner {
    [key: string]: object | any;
    /**
     * A list of names associated with the account by the financial institution. These should always be the names of individuals, even for business accounts. If the name of a business is reported, please contact Plaid Support. In the case of a joint account, Plaid will make a best effort to report the names of all account holders.  If an Item contains multiple accounts with different owner names, some institutions will report all names associated with the Item in each account\'s `names` array.
     * @type {Array<string>}
     * @memberof Owner
     */
    names: Array<string>;
    /**
     * A list of phone numbers associated with the account by the financial institution. May be an empty array if no relevant information is returned from the financial institution.
     * @type {Array<PhoneNumber>}
     * @memberof Owner
     */
    phone_numbers: Array<PhoneNumber>;
    /**
     * A list of email addresses associated with the account by the financial institution. May be an empty array if no relevant information is returned from the financial institution.
     * @type {Array<Email>}
     * @memberof Owner
     */
    emails: Array<Email>;
    /**
     * Data about the various addresses associated with the account by the financial institution. May be an empty array if no relevant information is returned from the financial institution.
     * @type {Array<Address>}
     * @memberof Owner
     */
    addresses: Array<Address>;
}
/**
 * Data about the owner or owners of an account. Any fields not specified will be filled in with default Sandbox information.
 * @export
 * @interface OwnerOverride
 */
export interface OwnerOverride {
    [key: string]: object | any;
    /**
     * A list of names associated with the account by the financial institution. These should always be the names of individuals, even for business accounts. Note that the same name data will be used for all accounts associated with an Item.
     * @type {Array<string>}
     * @memberof OwnerOverride
     */
    names: Array<string>;
    /**
     * A list of phone numbers associated with the account.
     * @type {Array<PhoneNumber>}
     * @memberof OwnerOverride
     */
    phone_numbers: Array<PhoneNumber>;
    /**
     * A list of email addresses associated with the account.
     * @type {Array<Email>}
     * @memberof OwnerOverride
     */
    emails: Array<Email>;
    /**
     * Data about the various addresses associated with the account.
     * @type {Array<Address>}
     * @memberof OwnerOverride
     */
    addresses: Array<Address>;
}
/**
 * Information about the student\'s eligibility in the Public Service Loan Forgiveness program. This is only returned if the institution is Fedloan (`ins_116527`).
 * @export
 * @interface PSLFStatus
 */
export interface PSLFStatus {
    [key: string]: object | any;
    /**
     * The estimated date borrower will have completed 120 qualifying monthly payments. Returned in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof PSLFStatus
     */
    estimated_eligibility_date: string | null;
    /**
     * The number of qualifying payments that have been made.
     * @type {number}
     * @memberof PSLFStatus
     */
    payments_made: number | null;
    /**
     * The number of qualifying payments remaining.
     * @type {number}
     * @memberof PSLFStatus
     */
    payments_remaining: number | null;
}
/**
 * An object representing a monetary amount.
 * @export
 * @interface Pay
 */
export interface Pay {
    [key: string]: object | any;
    /**
     * A numerical amount of a specific currency.
     * @type {number}
     * @memberof Pay
     */
    amount?: number | null;
    /**
     * Currency code, e.g. USD
     * @type {string}
     * @memberof Pay
     */
    currency?: string | null;
}
/**
 * The frequency of the pay period.
 * @export
 * @interface PayFrequency
 */
export interface PayFrequency {
    [key: string]: object | any;
    /**
     *
     * @type {PayFrequencyValue}
     * @memberof PayFrequency
     */
    value: PayFrequencyValue;
    /**
     *
     * @type {VerificationStatus}
     * @memberof PayFrequency
     */
    verification_status: VerificationStatus;
}
/**
 * The frequency of the pay period.
 * @export
 * @enum {string}
 */
export declare enum PayFrequencyValue {
    Monthly = "monthly",
    Semimonthly = "semimonthly",
    Weekly = "weekly",
    Biweekly = "biweekly",
    Unknown = "unknown",
    Null = "null"
}
/**
 * Details about the pay period.
 * @export
 * @interface PayPeriodDetails
 */
export interface PayPeriodDetails {
    [key: string]: object | any;
    /**
     * The amount of the paycheck.
     * @type {number}
     * @memberof PayPeriodDetails
     */
    check_amount?: number | null;
    /**
     *
     * @type {Array<DistributionBreakdown>}
     * @memberof PayPeriodDetails
     */
    distribution_breakdown?: Array<DistributionBreakdown>;
    /**
     * The pay period end date, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format: \"yyyy-mm-dd\".
     * @type {string}
     * @memberof PayPeriodDetails
     */
    end_date?: string | null;
    /**
     * Total earnings before tax/deductions.
     * @type {number}
     * @memberof PayPeriodDetails
     */
    gross_earnings?: number | null;
    /**
     * The date on which the paystub was issued, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (\"yyyy-mm-dd\").
     * @type {string}
     * @memberof PayPeriodDetails
     */
    pay_date?: string | null;
    /**
     * The frequency at which an individual is paid.
     * @type {string}
     * @memberof PayPeriodDetails
     */
    pay_frequency?: PayPeriodDetailsPayFrequencyEnum;
    /**
     * The date on which the paystub was issued, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (\"yyyy-mm-dd\").
     * @type {string}
     * @memberof PayPeriodDetails
     * @deprecated
     */
    pay_day?: string | null;
    /**
     * The pay period start date, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format: \"yyyy-mm-dd\".
     * @type {string}
     * @memberof PayPeriodDetails
     */
    start_date?: string | null;
}
/**
    * @export
    * @enum {string}
    */
export declare enum PayPeriodDetailsPayFrequencyEnum {
    PayFrequencyUnknown = "PAY_FREQUENCY_UNKNOWN",
    PayFrequencyWeekly = "PAY_FREQUENCY_WEEKLY",
    PayFrequencyBiweekly = "PAY_FREQUENCY_BIWEEKLY",
    PayFrequencySemimonthly = "PAY_FREQUENCY_SEMIMONTHLY",
    PayFrequencyMonthly = "PAY_FREQUENCY_MONTHLY",
    Null = "null"
}
/**
 * The amount and currency of a payment
 * @export
 * @interface PaymentAmount
 */
export interface PaymentAmount {
    [key: string]: object | any;
    /**
     * The ISO-4217 currency code of the payment. For standing orders, `\"GBP\"` must be used.
     * @type {string}
     * @memberof PaymentAmount
     */
    currency: PaymentAmountCurrencyEnum;
    /**
     * The amount of the payment. Must contain at most two digits of precision e.g. `1.23`. Minimum accepted value is `1`.
     * @type {number}
     * @memberof PaymentAmount
     */
    value: number;
}
/**
    * @export
    * @enum {string}
    */
export declare enum PaymentAmountCurrencyEnum {
    Gbp = "GBP",
    Eur = "EUR"
}
/**
 * The optional address of the payment recipient. This object is not currently required to make payments from UK institutions and should not be populated, though may be necessary for future European expansion.
 * @export
 * @interface PaymentInitiationAddress
 */
export interface PaymentInitiationAddress {
    [key: string]: object | any;
    /**
     * An array of length 1-2 representing the street address where the recipient is located. Maximum of 70 characters.
     * @type {Array<string>}
     * @memberof PaymentInitiationAddress
     */
    street: Array<string>;
    /**
     * The city where the recipient is located. Maximum of 35 characters.
     * @type {string}
     * @memberof PaymentInitiationAddress
     */
    city: string;
    /**
     * The postal code where the recipient is located. Maximum of 16 characters.
     * @type {string}
     * @memberof PaymentInitiationAddress
     */
    postal_code: string;
    /**
     * The ISO 3166-1 alpha-2 country code where the recipient is located.
     * @type {string}
     * @memberof PaymentInitiationAddress
     */
    country: string;
}
/**
 * Metadata that captures what specific payment configurations an institution supports when making Payment Initiation requests.
 * @export
 * @interface PaymentInitiationMetadata
 */
export interface PaymentInitiationMetadata {
    [key: string]: object | any;
    /**
     * Indicates whether the institution supports payments from a different country.
     * @type {boolean}
     * @memberof PaymentInitiationMetadata
     */
    supports_international_payments: boolean;
    /**
     * A mapping of currency to maximum payment amount (denominated in the smallest unit of currency) supported by the institution.  Example: `{\"GBP\": \"10000\"}`
     * @type {{ [key: string]: string; }}
     * @memberof PaymentInitiationMetadata
     */
    maximum_payment_amount: {
        [key: string]: string;
    };
    /**
     * Indicates whether the institution supports returning refund details when initiating a payment.
     * @type {boolean}
     * @memberof PaymentInitiationMetadata
     */
    supports_refund_details: boolean;
    /**
     *
     * @type {PaymentInitiationStandingOrderMetadata}
     * @memberof PaymentInitiationMetadata
     */
    standing_order_metadata: PaymentInitiationStandingOrderMetadata | null;
}
/**
 * An optional object used to restrict the accounts used for payments. If provided, the end user will be able to send payments only from the specified bank account.
 * @export
 * @interface PaymentInitiationOptionalRestrictionBacs
 */
export interface PaymentInitiationOptionalRestrictionBacs {
    /**
     * The account number of the account. Maximum of 10 characters.
     * @type {string}
     * @memberof PaymentInitiationOptionalRestrictionBacs
     */
    account?: string;
    /**
     * The 6-character sort code of the account.
     * @type {string}
     * @memberof PaymentInitiationOptionalRestrictionBacs
     */
    sort_code?: string;
}
/**
 * PaymentInitiationPayment defines a payment initiation payment
 * @export
 * @interface PaymentInitiationPayment
 */
export interface PaymentInitiationPayment {
    [key: string]: object | any;
    /**
     * The ID of the payment. Like all Plaid identifiers, the `payment_id` is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationPayment
     */
    payment_id: string;
    /**
     *
     * @type {PaymentAmount}
     * @memberof PaymentInitiationPayment
     */
    amount: PaymentAmount;
    /**
     *
     * @type {PaymentInitiationPaymentStatus}
     * @memberof PaymentInitiationPayment
     */
    status: PaymentInitiationPaymentStatus;
    /**
     * The ID of the recipient
     * @type {string}
     * @memberof PaymentInitiationPayment
     */
    recipient_id: string;
    /**
     * A reference for the payment.
     * @type {string}
     * @memberof PaymentInitiationPayment
     */
    reference: string;
    /**
     * The value of the reference sent to the bank after adjustment to pass bank validation rules.
     * @type {string}
     * @memberof PaymentInitiationPayment
     */
    adjusted_reference?: string | null;
    /**
     * The date and time of the last time the `status` was updated, in IS0 8601 format
     * @type {string}
     * @memberof PaymentInitiationPayment
     */
    last_status_update: string;
    /**
     *
     * @type {ExternalPaymentScheduleGet}
     * @memberof PaymentInitiationPayment
     */
    schedule?: ExternalPaymentScheduleGet | null;
    /**
     *
     * @type {ExternalPaymentRefundDetails}
     * @memberof PaymentInitiationPayment
     */
    refund_details?: ExternalPaymentRefundDetails | null;
    /**
     *
     * @type {SenderBACSNullable}
     * @memberof PaymentInitiationPayment
     */
    bacs: SenderBACSNullable | null;
    /**
     * The International Bank Account Number (IBAN) for the sender, if specified in the `/payment_initiation/payment/create` call.
     * @type {string}
     * @memberof PaymentInitiationPayment
     */
    iban: string | null;
    /**
     * Initiated refunds associated with the payment.
     * @type {Array<PaymentInitiationRefund>}
     * @memberof PaymentInitiationPayment
     */
    initiated_refunds?: Array<PaymentInitiationRefund>;
    /**
     * The EMI (E-Money Institution) wallet that this payment is associated with, if any. This wallet is used as an intermediary account to enable Plaid to reconcile the settlement of funds for Payment Initiation requests.
     * @type {string}
     * @memberof PaymentInitiationPayment
     */
    wallet_id?: string | null;
    /**
     *
     * @type {PaymentScheme}
     * @memberof PaymentInitiationPayment
     */
    scheme?: PaymentScheme | null;
    /**
     *
     * @type {PaymentScheme}
     * @memberof PaymentInitiationPayment
     */
    adjusted_scheme?: PaymentScheme | null;
}
/**
 * PaymentInitiationPaymentCreateRequest defines the request schema for `/payment_initiation/payment/create`
 * @export
 * @interface PaymentInitiationPaymentCreateRequest
 */
export interface PaymentInitiationPaymentCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentCreateRequest
     */
    secret?: string;
    /**
     * The ID of the recipient the payment is for.
     * @type {string}
     * @memberof PaymentInitiationPaymentCreateRequest
     */
    recipient_id: string;
    /**
     * A reference for the payment. This must be an alphanumeric string with at most 18 characters and must not contain any special characters (since not all institutions support them).
     * @type {string}
     * @memberof PaymentInitiationPaymentCreateRequest
     */
    reference: string;
    /**
     *
     * @type {PaymentAmount}
     * @memberof PaymentInitiationPaymentCreateRequest
     */
    amount: PaymentAmount;
    /**
     *
     * @type {ExternalPaymentScheduleRequest}
     * @memberof PaymentInitiationPaymentCreateRequest
     */
    schedule?: ExternalPaymentScheduleRequest;
    /**
     *
     * @type {ExternalPaymentOptions}
     * @memberof PaymentInitiationPaymentCreateRequest
     */
    options?: ExternalPaymentOptions | null;
}
/**
 * PaymentInitiationPaymentCreateResponse defines the response schema for `/payment_initiation/payment/create`
 * @export
 * @interface PaymentInitiationPaymentCreateResponse
 */
export interface PaymentInitiationPaymentCreateResponse {
    [key: string]: object | any;
    /**
     * A unique ID identifying the payment
     * @type {string}
     * @memberof PaymentInitiationPaymentCreateResponse
     */
    payment_id: string;
    /**
     * For a payment returned by this endpoint, there is only one possible value:  `PAYMENT_STATUS_INPUT_NEEDED`: The initial phase of the payment
     * @type {string}
     * @memberof PaymentInitiationPaymentCreateResponse
     */
    status: PaymentInitiationPaymentCreateResponseStatusEnum;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationPaymentCreateResponse
     */
    request_id: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum PaymentInitiationPaymentCreateResponseStatusEnum {
    PaymentStatusInputNeeded = "PAYMENT_STATUS_INPUT_NEEDED"
}
/**
 * PaymentInitiationPaymentGetRequest defines the request schema for `/payment_initiation/payment/get`
 * @export
 * @interface PaymentInitiationPaymentGetRequest
 */
export interface PaymentInitiationPaymentGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetRequest
     */
    secret?: string;
    /**
     * The `payment_id` returned from `/payment_initiation/payment/create`.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetRequest
     */
    payment_id: string;
}
/**
 * PaymentInitiationPaymentGetResponse defines the response schema for `/payment_initation/payment/get`
 * @export
 * @interface PaymentInitiationPaymentGetResponse
 */
export interface PaymentInitiationPaymentGetResponse {
    /**
     * The ID of the payment. Like all Plaid identifiers, the `payment_id` is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    payment_id: string;
    /**
     *
     * @type {PaymentAmount}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    amount: PaymentAmount;
    /**
     *
     * @type {PaymentInitiationPaymentStatus}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    status: PaymentInitiationPaymentStatus;
    /**
     * The ID of the recipient
     * @type {string}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    recipient_id: string;
    /**
     * A reference for the payment.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    reference: string;
    /**
     * The value of the reference sent to the bank after adjustment to pass bank validation rules.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    adjusted_reference?: string | null;
    /**
     * The date and time of the last time the `status` was updated, in IS0 8601 format
     * @type {string}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    last_status_update: string;
    /**
     *
     * @type {ExternalPaymentScheduleGet}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    schedule?: ExternalPaymentScheduleGet | null;
    /**
     *
     * @type {ExternalPaymentRefundDetails}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    refund_details?: ExternalPaymentRefundDetails | null;
    /**
     *
     * @type {SenderBACSNullable}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    bacs: SenderBACSNullable | null;
    /**
     * The International Bank Account Number (IBAN) for the sender, if specified in the `/payment_initiation/payment/create` call.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    iban: string | null;
    /**
     * Initiated refunds associated with the payment.
     * @type {Array<PaymentInitiationRefund>}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    initiated_refunds?: Array<PaymentInitiationRefund>;
    /**
     * The EMI (E-Money Institution) wallet that this payment is associated with, if any. This wallet is used as an intermediary account to enable Plaid to reconcile the settlement of funds for Payment Initiation requests.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    wallet_id?: string | null;
    /**
     *
     * @type {PaymentScheme}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    scheme?: PaymentScheme | null;
    /**
     *
     * @type {PaymentScheme}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    adjusted_scheme?: PaymentScheme | null;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationPaymentGetResponse
     */
    request_id: string;
}
/**
 * PaymentInitiationPaymentListRequest defines the request schema for `/payment_initiation/payment/list`
 * @export
 * @interface PaymentInitiationPaymentListRequest
 */
export interface PaymentInitiationPaymentListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentListRequest
     */
    secret?: string;
    /**
     * The maximum number of payments to return. If `count` is not specified, a maximum of 10 payments will be returned, beginning with the most recent payment before the cursor (if specified).
     * @type {number}
     * @memberof PaymentInitiationPaymentListRequest
     */
    count?: number | null;
    /**
     * A string in RFC 3339 format (i.e. \"2019-12-06T22:35:49Z\"). Only payments created before the cursor will be returned.
     * @type {string}
     * @memberof PaymentInitiationPaymentListRequest
     */
    cursor?: string | null;
}
/**
 * PaymentInitiationPaymentListResponse defines the response schema for `/payment_initiation/payment/list`
 * @export
 * @interface PaymentInitiationPaymentListResponse
 */
export interface PaymentInitiationPaymentListResponse {
    [key: string]: object | any;
    /**
     * An array of payments that have been created, associated with the given `client_id`.
     * @type {Array<PaymentInitiationPayment>}
     * @memberof PaymentInitiationPaymentListResponse
     */
    payments: Array<PaymentInitiationPayment>;
    /**
     * The value that, when used as the optional `cursor` parameter to `/payment_initiation/payment/list`, will return the next unreturned payment as its first payment.
     * @type {string}
     * @memberof PaymentInitiationPaymentListResponse
     */
    next_cursor: string | null;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationPaymentListResponse
     */
    request_id: string;
}
/**
 * PaymentInitiationPaymentReverseRequest defines the request schema for `/payment_initiation/payment/reverse`
 * @export
 * @interface PaymentInitiationPaymentReverseRequest
 */
export interface PaymentInitiationPaymentReverseRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentReverseRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentReverseRequest
     */
    secret?: string;
    /**
     * The ID of the payment to reverse
     * @type {string}
     * @memberof PaymentInitiationPaymentReverseRequest
     */
    payment_id: string;
}
/**
 * PaymentInitiationPaymentReverseResponse defines the response schema for `/payment_initation/payment/reverse`
 * @export
 * @interface PaymentInitiationPaymentReverseResponse
 */
export interface PaymentInitiationPaymentReverseResponse {
    [key: string]: object | any;
    /**
     * A unique ID identifying the refund
     * @type {string}
     * @memberof PaymentInitiationPaymentReverseResponse
     */
    refund_id: string;
    /**
     * The status of the refund.  `PROCESSING`: The refund is currently being processed. The refund will automatically exit this state when processing is complete.  `INITIATED`: The refund has been successfully initiated.  `EXECUTED`: Indicates that the refund has been successfully executed.  `FAILED`: The refund has failed to be executed. This error is retryable once the root cause is resolved.
     * @type {string}
     * @memberof PaymentInitiationPaymentReverseResponse
     */
    status: PaymentInitiationPaymentReverseResponseStatusEnum;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationPaymentReverseResponse
     */
    request_id: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum PaymentInitiationPaymentReverseResponseStatusEnum {
    Processing = "PROCESSING",
    Executed = "EXECUTED",
    Initiated = "INITIATED",
    Failed = "FAILED"
}
/**
 * The status of the payment.  `PAYMENT_STATUS_INPUT_NEEDED`: This is the initial state of all payments. It indicates that the payment is waiting on user input to continue processing. A payment may re-enter this state later on if further input is needed.  `PAYMENT_STATUS_INITIATED`: The payment has been successfully authorised and accepted by the financial institution but has not been executed.  `PAYMENT_STATUS_INSUFFICIENT_FUNDS`: The payment has failed due to insufficient funds.  `PAYMENT_STATUS_FAILED`: The payment has failed to be initiated. This error is retryable once the root cause is resolved.  `PAYMENT_STATUS_BLOCKED`: The payment has been blocked. This is a retryable error.  `PAYMENT_STATUS_AUTHORISING`: The payment is currently being processed. The payment will automatically exit this state when the financial institution has authorised the transaction.  `PAYMENT_STATUS_CANCELLED`: The payment was cancelled during authorisation.  `PAYMENT_STATUS_EXECUTED`: The payment has been successfully initiated and is considered complete.  `PAYMENT_STATUS_ESTABLISHED`: Indicates that the standing order has been successfully established. This state is only used for standing orders.  `PAYMENT_STATUS_REJECTED`: The payment was rejected by the financial institution.  Deprecated: These statuses will be removed in a future release.  `PAYMENT_STATUS_UNKNOWN`: The payment status is unknown.  `PAYMENT_STATUS_PROCESSING`: The payment is currently being processed. The payment will automatically exit this state when processing is complete.  `PAYMENT_STATUS_COMPLETED`: Indicates that the standing order has been successfully established. This state is only used for standing orders.
 * @export
 * @enum {string}
 */
export declare enum PaymentInitiationPaymentStatus {
    InputNeeded = "PAYMENT_STATUS_INPUT_NEEDED",
    Processing = "PAYMENT_STATUS_PROCESSING",
    Initiated = "PAYMENT_STATUS_INITIATED",
    Completed = "PAYMENT_STATUS_COMPLETED",
    InsufficientFunds = "PAYMENT_STATUS_INSUFFICIENT_FUNDS",
    Failed = "PAYMENT_STATUS_FAILED",
    Blocked = "PAYMENT_STATUS_BLOCKED",
    Unknown = "PAYMENT_STATUS_UNKNOWN",
    Executed = "PAYMENT_STATUS_EXECUTED",
    Authorising = "PAYMENT_STATUS_AUTHORISING",
    Cancelled = "PAYMENT_STATUS_CANCELLED",
    Established = "PAYMENT_STATUS_ESTABLISHED",
    Rejected = "PAYMENT_STATUS_REJECTED"
}
/**
 * PaymentInitiationPaymentTokenCreateRequest defines the request schema for `/payment_initiation/payment/token/create`
 * @export
 * @interface PaymentInitiationPaymentTokenCreateRequest
 */
export interface PaymentInitiationPaymentTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationPaymentTokenCreateRequest
     */
    secret?: string;
    /**
     * The `payment_id` returned from `/payment_initiation/payment/create`.
     * @type {string}
     * @memberof PaymentInitiationPaymentTokenCreateRequest
     */
    payment_id: string;
}
/**
 * PaymentInitiationPaymentTokenCreateResponse defines the response schema for `/payment_initiation/payment/token/create`
 * @export
 * @interface PaymentInitiationPaymentTokenCreateResponse
 */
export interface PaymentInitiationPaymentTokenCreateResponse {
    [key: string]: object | any;
    /**
     * A `payment_token` that can be provided to Link initialization to enter the payment initiation flow
     * @type {string}
     * @memberof PaymentInitiationPaymentTokenCreateResponse
     */
    payment_token: string;
    /**
     * The date and time at which the token will expire, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format. A `payment_token` expires after 15 minutes.
     * @type {string}
     * @memberof PaymentInitiationPaymentTokenCreateResponse
     */
    payment_token_expiration_time: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationPaymentTokenCreateResponse
     */
    request_id: string;
}
/**
 * PaymentInitiationRecipient defines a payment initiation recipient
 * @export
 * @interface PaymentInitiationRecipient
 */
export interface PaymentInitiationRecipient {
    [key: string]: object | any;
    /**
     * The ID of the recipient.
     * @type {string}
     * @memberof PaymentInitiationRecipient
     */
    recipient_id: string;
    /**
     * The name of the recipient.
     * @type {string}
     * @memberof PaymentInitiationRecipient
     */
    name: string;
    /**
     *
     * @type {PaymentInitiationAddress}
     * @memberof PaymentInitiationRecipient
     */
    address?: PaymentInitiationAddress | null;
    /**
     * The International Bank Account Number (IBAN) for the recipient.
     * @type {string}
     * @memberof PaymentInitiationRecipient
     */
    iban?: string | null;
    /**
     *
     * @type {RecipientBACSNullable}
     * @memberof PaymentInitiationRecipient
     */
    bacs?: RecipientBACSNullable | null;
    /**
     * The EMI (E-Money Institution) recipient that this recipient is associated with, if any. This EMI recipient is used as an intermediary account to enable Plaid to reconcile the settlement of funds for Payment Initiation requests.
     * @type {string}
     * @memberof PaymentInitiationRecipient
     */
    emi_recipient_id?: string | null;
}
/**
 * PaymentInitiationRecipientCreateRequest defines the request schema for `/payment_initiation/recipient/create`
 * @export
 * @interface PaymentInitiationRecipientCreateRequest
 */
export interface PaymentInitiationRecipientCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationRecipientCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationRecipientCreateRequest
     */
    secret?: string;
    /**
     * The name of the recipient
     * @type {string}
     * @memberof PaymentInitiationRecipientCreateRequest
     */
    name: string;
    /**
     * The International Bank Account Number (IBAN) for the recipient. If BACS data is not provided, an IBAN is required.
     * @type {string}
     * @memberof PaymentInitiationRecipientCreateRequest
     */
    iban?: string | null;
    /**
     *
     * @type {RecipientBACSNullable}
     * @memberof PaymentInitiationRecipientCreateRequest
     */
    bacs?: RecipientBACSNullable | null;
    /**
     *
     * @type {PaymentInitiationAddress}
     * @memberof PaymentInitiationRecipientCreateRequest
     */
    address?: PaymentInitiationAddress | null;
}
/**
 * PaymentInitiationRecipientCreateResponse defines the response schema for `/payment_initation/recipient/create`
 * @export
 * @interface PaymentInitiationRecipientCreateResponse
 */
export interface PaymentInitiationRecipientCreateResponse {
    [key: string]: object | any;
    /**
     * A unique ID identifying the recipient
     * @type {string}
     * @memberof PaymentInitiationRecipientCreateResponse
     */
    recipient_id: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationRecipientCreateResponse
     */
    request_id: string;
}
/**
 * PaymentInitiationRecipientGetRequest defines the request schema for `/payment_initiation/recipient/get`
 * @export
 * @interface PaymentInitiationRecipientGetRequest
 */
export interface PaymentInitiationRecipientGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationRecipientGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationRecipientGetRequest
     */
    secret?: string;
    /**
     * The ID of the recipient
     * @type {string}
     * @memberof PaymentInitiationRecipientGetRequest
     */
    recipient_id: string;
}
/**
 * PaymentInitiationRecipientGetResponse defines the response schema for `/payment_initiation/recipient/get`
 * @export
 * @interface PaymentInitiationRecipientGetResponse
 */
export interface PaymentInitiationRecipientGetResponse {
    /**
     * The ID of the recipient.
     * @type {string}
     * @memberof PaymentInitiationRecipientGetResponse
     */
    recipient_id: string;
    /**
     * The name of the recipient.
     * @type {string}
     * @memberof PaymentInitiationRecipientGetResponse
     */
    name: string;
    /**
     *
     * @type {PaymentInitiationAddress}
     * @memberof PaymentInitiationRecipientGetResponse
     */
    address?: PaymentInitiationAddress | null;
    /**
     * The International Bank Account Number (IBAN) for the recipient.
     * @type {string}
     * @memberof PaymentInitiationRecipientGetResponse
     */
    iban?: string | null;
    /**
     *
     * @type {RecipientBACSNullable}
     * @memberof PaymentInitiationRecipientGetResponse
     */
    bacs?: RecipientBACSNullable | null;
    /**
     * The EMI (E-Money Institution) recipient that this recipient is associated with, if any. This EMI recipient is used as an intermediary account to enable Plaid to reconcile the settlement of funds for Payment Initiation requests.
     * @type {string}
     * @memberof PaymentInitiationRecipientGetResponse
     */
    emi_recipient_id?: string | null;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationRecipientGetResponse
     */
    request_id: string;
}
/**
 *
 * @export
 * @interface PaymentInitiationRecipientGetResponseAllOf
 */
export interface PaymentInitiationRecipientGetResponseAllOf {
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationRecipientGetResponseAllOf
     */
    request_id?: string;
}
/**
 * PaymentInitiationRecipientListRequest defines the request schema for `/payment_initiation/recipient/list`
 * @export
 * @interface PaymentInitiationRecipientListRequest
 */
export interface PaymentInitiationRecipientListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationRecipientListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof PaymentInitiationRecipientListRequest
     */
    secret?: string;
}
/**
 * PaymentInitiationRecipientListResponse defines the response schema for `/payment_initiation/recipient/list`
 * @export
 * @interface PaymentInitiationRecipientListResponse
 */
export interface PaymentInitiationRecipientListResponse {
    [key: string]: object | any;
    /**
     * An array of payment recipients created for Payment Initiation
     * @type {Array<PaymentInitiationRecipient>}
     * @memberof PaymentInitiationRecipientListResponse
     */
    recipients: Array<PaymentInitiationRecipient>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationRecipientListResponse
     */
    request_id: string;
}
/**
 * PaymentInitiationRefund defines a payment initiation refund
 * @export
 * @interface PaymentInitiationRefund
 */
export interface PaymentInitiationRefund {
    [key: string]: object | any;
    /**
     * The ID of the refund. Like all Plaid identifiers, the `refund_id` is case sensitive.
     * @type {string}
     * @memberof PaymentInitiationRefund
     */
    refund_id: string;
    /**
     *
     * @type {PaymentAmount}
     * @memberof PaymentInitiationRefund
     */
    amount: PaymentAmount;
    /**
     * The status of the refund.  `PROCESSING`: The refund is currently being processed. The refund will automatically exit this state when processing is complete.  `INITIATED`: The refund has been successfully initiated.  `EXECUTED`: Indicates that the refund has been successfully executed.  `FAILED`: The refund has failed to be executed. This error is retryable once the root cause is resolved.
     * @type {string}
     * @memberof PaymentInitiationRefund
     */
    status: PaymentInitiationRefundStatusEnum;
    /**
     * The date and time of the last time the `status` was updated, in IS0 8601 format
     * @type {string}
     * @memberof PaymentInitiationRefund
     */
    last_status_update: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum PaymentInitiationRefundStatusEnum {
    Processing = "PROCESSING",
    Initiated = "INITIATED",
    Executed = "EXECUTED",
    Failed = "FAILED"
}
/**
 * Metadata specifically related to valid Payment Initiation standing order configurations for the institution.
 * @export
 * @interface PaymentInitiationStandingOrderMetadata
 */
export interface PaymentInitiationStandingOrderMetadata {
    [key: string]: object | any;
    /**
     * Indicates whether the institution supports closed-ended standing orders by providing an end date.
     * @type {boolean}
     * @memberof PaymentInitiationStandingOrderMetadata
     */
    supports_standing_order_end_date: boolean;
    /**
     * This is only applicable to `MONTHLY` standing orders. Indicates whether the institution supports negative integers (-1 to -5) for setting up a `MONTHLY` standing order relative to the end of the month.
     * @type {boolean}
     * @memberof PaymentInitiationStandingOrderMetadata
     */
    supports_standing_order_negative_execution_days: boolean;
    /**
     * A list of the valid standing order intervals supported by the institution.
     * @type {Array<PaymentScheduleInterval>}
     * @memberof PaymentInitiationStandingOrderMetadata
     */
    valid_standing_order_intervals: Array<PaymentScheduleInterval>;
}
/**
 * Transaction information specific to inter-bank transfers. If the transaction was not an inter-bank transfer, all fields will be `null`.  If the `transactions` object was returned by a Transactions endpoint such as `/transactions/get`, the `payment_meta` key will always appear, but no data elements are guaranteed. If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
 * @export
 * @interface PaymentMeta
 */
export interface PaymentMeta {
    [key: string]: object | any;
    /**
     * The transaction reference number supplied by the financial institution.
     * @type {string}
     * @memberof PaymentMeta
     */
    reference_number: string | null;
    /**
     * The ACH PPD ID for the payer.
     * @type {string}
     * @memberof PaymentMeta
     */
    ppd_id: string | null;
    /**
     * For transfers, the party that is receiving the transaction.
     * @type {string}
     * @memberof PaymentMeta
     */
    payee: string | null;
    /**
     * The party initiating a wire transfer. Will be `null` if the transaction is not a wire transfer.
     * @type {string}
     * @memberof PaymentMeta
     */
    by_order_of: string | null;
    /**
     * For transfers, the party that is paying the transaction.
     * @type {string}
     * @memberof PaymentMeta
     */
    payer: string | null;
    /**
     * The type of transfer, e.g. \'ACH\'
     * @type {string}
     * @memberof PaymentMeta
     */
    payment_method: string | null;
    /**
     * The name of the payment processor
     * @type {string}
     * @memberof PaymentMeta
     */
    payment_processor: string | null;
    /**
     * The payer-supplied description of the transfer.
     * @type {string}
     * @memberof PaymentMeta
     */
    reason: string | null;
}
/**
 * The frequency interval of the payment.
 * @export
 * @enum {string}
 */
export declare enum PaymentScheduleInterval {
    Weekly = "WEEKLY",
    Monthly = "MONTHLY"
}
/**
 * Payment scheme. If not specified - the default in the region will be used (e.g. `SEPA_CREDIT_TRANSFER` for EU). Using unsupported values will result in a failed payment.  `FASTER_PAYMENTS`: Enables payments to move quickly between UK bank accounts. Default value in the UK.  `SEPA_CREDIT_TRANSFER`: The standard payment to a beneficiary within the SEPA area.  `SEPA_CREDIT_TRANSFER_INSTANT`: Instant payment within the SEPA area. May involve additional fees and may not be available at some banks.
 * @export
 * @enum {string}
 */
export declare enum PaymentScheme {
    Null = "null",
    FasterPayments = "FASTER_PAYMENTS",
    SepaCreditTransfer = "SEPA_CREDIT_TRANSFER",
    SepaCreditTransferInstant = "SEPA_CREDIT_TRANSFER_INSTANT"
}
/**
 * Fired when the status of a payment has changed.
 * @export
 * @interface PaymentStatusUpdateWebhook
 */
export interface PaymentStatusUpdateWebhook {
    [key: string]: object | any;
    /**
     * `PAYMENT_INITIATION`
     * @type {string}
     * @memberof PaymentStatusUpdateWebhook
     */
    webhook_type: string;
    /**
     * `PAYMENT_STATUS_UPDATE`
     * @type {string}
     * @memberof PaymentStatusUpdateWebhook
     */
    webhook_code: string;
    /**
     * The `payment_id` for the payment being updated
     * @type {string}
     * @memberof PaymentStatusUpdateWebhook
     */
    payment_id: string;
    /**
     *
     * @type {PaymentInitiationPaymentStatus}
     * @memberof PaymentStatusUpdateWebhook
     */
    new_payment_status: PaymentInitiationPaymentStatus;
    /**
     *
     * @type {PaymentInitiationPaymentStatus}
     * @memberof PaymentStatusUpdateWebhook
     */
    old_payment_status: PaymentInitiationPaymentStatus;
    /**
     * The original value of the reference when creating the payment.
     * @type {string}
     * @memberof PaymentStatusUpdateWebhook
     */
    original_reference: string | null;
    /**
     * The value of the reference sent to the bank after adjustment to pass bank validation rules.
     * @type {string}
     * @memberof PaymentStatusUpdateWebhook
     */
    adjusted_reference?: string | null;
    /**
     * The original value of the `start_date` provided during the creation of a standing order. If the payment is not a standing order, this field will be `null`.
     * @type {string}
     * @memberof PaymentStatusUpdateWebhook
     */
    original_start_date: string | null;
    /**
     * The start date sent to the bank after adjusting for holidays or weekends.  Will be provided in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). If the start date did not require adjustment, or if the payment is not a standing order, this field will be `null`.
     * @type {string}
     * @memberof PaymentStatusUpdateWebhook
     */
    adjusted_start_date: string | null;
    /**
     * The timestamp of the update, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format, e.g. `\"2017-09-14T14:42:19.350Z\"`
     * @type {string}
     * @memberof PaymentStatusUpdateWebhook
     */
    timestamp: string;
    /**
     *
     * @type {PlaidError}
     * @memberof PaymentStatusUpdateWebhook
     */
    error?: PlaidError;
}
/**
 * An object representing data extracted from the end user\'s paystub.
 * @export
 * @interface Paystub
 */
export interface Paystub {
    [key: string]: object | any;
    /**
     *
     * @type {Deductions}
     * @memberof Paystub
     */
    deductions: Deductions;
    /**
     * An identifier of the document referenced by the document metadata.
     * @type {string}
     * @memberof Paystub
     */
    doc_id: string;
    /**
     *
     * @type {Earnings}
     * @memberof Paystub
     */
    earnings: Earnings;
    /**
     *
     * @type {Employee}
     * @memberof Paystub
     */
    employee: Employee;
    /**
     *
     * @type {PaystubEmployer}
     * @memberof Paystub
     */
    employer: PaystubEmployer;
    /**
     *
     * @type {EmploymentDetails}
     * @memberof Paystub
     * @deprecated
     */
    employment_details?: EmploymentDetails;
    /**
     *
     * @type {NetPay}
     * @memberof Paystub
     */
    net_pay: NetPay;
    /**
     *
     * @type {PayPeriodDetails}
     * @memberof Paystub
     */
    pay_period_details: PayPeriodDetails;
    /**
     *
     * @type {PaystubDetails}
     * @memberof Paystub
     * @deprecated
     */
    paystub_details?: PaystubDetails;
    /**
     *
     * @type {Array<IncomeBreakdown>}
     * @memberof Paystub
     * @deprecated
     */
    income_breakdown?: Array<IncomeBreakdown>;
    /**
     *
     * @type {PaystubYTDDetails}
     * @memberof Paystub
     * @deprecated
     */
    ytd_earnings?: PaystubYTDDetails;
    /**
     *
     * @type {PaystubVerification}
     * @memberof Paystub
     */
    verification: PaystubVerification | null;
}
/**
 * Address on the paystub
 * @export
 * @interface PaystubAddress
 */
export interface PaystubAddress {
    [key: string]: object | any;
    /**
     * The full city name.
     * @type {string}
     * @memberof PaystubAddress
     */
    city?: string | null;
    /**
     * The ISO 3166-1 alpha-2 country code.
     * @type {string}
     * @memberof PaystubAddress
     */
    country?: string | null;
    /**
     * The postal code of the address.
     * @type {string}
     * @memberof PaystubAddress
     */
    postal_code?: string | null;
    /**
     * The region or state Example: `\"NC\"`
     * @type {string}
     * @memberof PaystubAddress
     */
    region?: string | null;
    /**
     * The full street address.
     * @type {string}
     * @memberof PaystubAddress
     */
    street?: string | null;
    /**
     * Street address line 1.
     * @type {string}
     * @memberof PaystubAddress
     * @deprecated
     */
    line1?: string | null;
    /**
     * Street address line 2.
     * @type {string}
     * @memberof PaystubAddress
     * @deprecated
     */
    line2?: string | null;
    /**
     * The region or state Example: `\"NC\"`
     * @type {string}
     * @memberof PaystubAddress
     * @deprecated
     */
    state_code?: string | null;
}
/**
 * Deduction on the paystub
 * @export
 * @interface PaystubDeduction
 */
export interface PaystubDeduction {
    [key: string]: object | any;
    /**
     * The description of the deduction, as provided on the paystub. For example: `\"401(k)\"`, `\"FICA MED TAX\"`.
     * @type {string}
     * @memberof PaystubDeduction
     */
    type: string | null;
    /**
     * `true` if the deduction is pre-tax; `false` otherwise.
     * @type {boolean}
     * @memberof PaystubDeduction
     */
    is_pretax: boolean | null;
    /**
     * The amount of the deduction.
     * @type {number}
     * @memberof PaystubDeduction
     */
    total: number | null;
}
/**
 * An object representing details that can be found on the paystub.
 * @export
 * @interface PaystubDetails
 */
export interface PaystubDetails {
    [key: string]: object | any;
    /**
     * Beginning date of the pay period on the paystub in the \'YYYY-MM-DD\' format.
     * @type {string}
     * @memberof PaystubDetails
     */
    pay_period_start_date?: string | null;
    /**
     * Ending date of the pay period on the paystub in the \'YYYY-MM-DD\' format.
     * @type {string}
     * @memberof PaystubDetails
     */
    pay_period_end_date?: string | null;
    /**
     * Pay date on the paystub in the \'YYYY-MM-DD\' format.
     * @type {string}
     * @memberof PaystubDetails
     */
    pay_date?: string | null;
    /**
     * The name of the payroll provider that generated the paystub, e.g. ADP
     * @type {string}
     * @memberof PaystubDetails
     */
    paystub_provider?: string | null;
    /**
     *
     * @type {PaystubPayFrequency}
     * @memberof PaystubDetails
     */
    pay_frequency?: PaystubPayFrequency | null;
}
/**
 * Information about the employer on the paystub
 * @export
 * @interface PaystubEmployer
 */
export interface PaystubEmployer {
    [key: string]: object | any;
    /**
     *
     * @type {PaystubAddress}
     * @memberof PaystubEmployer
     */
    address?: PaystubAddress;
    /**
     * The name of the employer on the paystub.
     * @type {string}
     * @memberof PaystubEmployer
     */
    name: string | null;
}
/**
 * An object representing data from a paystub.
 * @export
 * @interface PaystubOverride
 */
export interface PaystubOverride {
    /**
     *
     * @type {PaystubOverrideEmployer}
     * @memberof PaystubOverride
     */
    employer?: PaystubOverrideEmployer;
    /**
     *
     * @type {PaystubOverrideEmployee}
     * @memberof PaystubOverride
     */
    employee?: PaystubOverrideEmployee;
    /**
     *
     * @type {Array<IncomeBreakdown>}
     * @memberof PaystubOverride
     */
    income_breakdown?: Array<IncomeBreakdown>;
    /**
     *
     * @type {PayPeriodDetails}
     * @memberof PaystubOverride
     */
    pay_period_details?: PayPeriodDetails;
}
/**
 * The employee on the paystub.
 * @export
 * @interface PaystubOverrideEmployee
 */
export interface PaystubOverrideEmployee {
    /**
     * The name of the employee.
     * @type {string}
     * @memberof PaystubOverrideEmployee
     */
    name?: string;
    /**
     *
     * @type {PaystubOverrideEmployeeAddress}
     * @memberof PaystubOverrideEmployee
     */
    address?: PaystubOverrideEmployeeAddress;
}
/**
 * The address of the employee.
 * @export
 * @interface PaystubOverrideEmployeeAddress
 */
export interface PaystubOverrideEmployeeAddress {
    /**
     * The full city name.
     * @type {string}
     * @memberof PaystubOverrideEmployeeAddress
     */
    city?: string;
    /**
     * The region or state Example: `\"NC\"`
     * @type {string}
     * @memberof PaystubOverrideEmployeeAddress
     */
    region?: string;
    /**
     * The full street address Example: `\"564 Main Street, APT 15\"`
     * @type {string}
     * @memberof PaystubOverrideEmployeeAddress
     */
    street?: string;
    /**
     * 5 digit postal code.
     * @type {string}
     * @memberof PaystubOverrideEmployeeAddress
     */
    postal_code?: string;
    /**
     * The country of the address.
     * @type {string}
     * @memberof PaystubOverrideEmployeeAddress
     */
    country?: string;
}
/**
 * The employer on the paystub.
 * @export
 * @interface PaystubOverrideEmployer
 */
export interface PaystubOverrideEmployer {
    /**
     * The name of the employer.
     * @type {string}
     * @memberof PaystubOverrideEmployer
     */
    name?: string;
}
/**
 * The frequency at which the employee is paid. Possible values: `MONTHLY`, `BI-WEEKLY`, `WEEKLY`, `SEMI-MONTHLY`.
 * @export
 * @enum {string}
 */
export declare enum PaystubPayFrequency {
    Monthly = "MONTHLY",
    BiWeekly = "BI-WEEKLY",
    Weekly = "WEEKLY",
    SemiMonthly = "SEMI-MONTHLY",
    Null = "null"
}
/**
 * An object containing details on the paystub\'s verification status. This object will only be populated if the [`income_verification.access_tokens`](/docs/api/tokens/#link-token-create-request-income-verification-access-tokens) parameter was provided during the `/link/token/create` call or if a problem was detected with the information supplied by the user; otherwise it will be `null`.
 * @export
 * @interface PaystubVerification
 */
export interface PaystubVerification {
    [key: string]: object | any;
    /**
     *
     * @type {PaystubVerificationStatus}
     * @memberof PaystubVerification
     */
    verification_status: PaystubVerificationStatus | null;
    /**
     *
     * @type {Array<VerificationAttribute>}
     * @memberof PaystubVerification
     */
    verification_attributes: Array<VerificationAttribute>;
}
/**
 * Derived verification status.
 * @export
 * @enum {string}
 */
export declare enum PaystubVerificationStatus {
    PaystubVerificationStatusUnknown = "PAYSTUB_VERIFICATION_STATUS_UNKNOWN",
    PaystubVerificationStatusVerified = "PAYSTUB_VERIFICATION_STATUS_VERIFIED",
    PaystubVerificationStatusFraudulent = "PAYSTUB_VERIFICATION_STATUS_FRAUDULENT",
    Null = "null"
}
/**
 * The amount of income earned year to date, as based on paystub data.
 * @export
 * @interface PaystubYTDDetails
 */
export interface PaystubYTDDetails {
    [key: string]: object | any;
    /**
     * Year-to-date gross earnings.
     * @type {number}
     * @memberof PaystubYTDDetails
     */
    gross_earnings?: number | null;
    /**
     * Year-to-date net (take home) earnings.
     * @type {number}
     * @memberof PaystubYTDDetails
     */
    net_earnings?: number | null;
}
/**
 * Fired when an Item’s access consent is expiring in 7 days. Some Items have explicit expiration times and we try to relay this when possible to reduce service disruption. This can be resolved by having the user go through Link’s update mode.
 * @export
 * @interface PendingExpirationWebhook
 */
export interface PendingExpirationWebhook {
    [key: string]: object | any;
    /**
     * `ITEM`
     * @type {string}
     * @memberof PendingExpirationWebhook
     */
    webhook_type: string;
    /**
     * `PENDING_EXPIRATION`
     * @type {string}
     * @memberof PendingExpirationWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof PendingExpirationWebhook
     */
    item_id: string;
    /**
     * The date and time at which the Item\'s access consent will expire, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format
     * @type {string}
     * @memberof PendingExpirationWebhook
     */
    consent_expiration_time: string;
}
/**
 * Information describing the intent of the transaction. Most relevant for personal finance use cases, but not limited to such use cases. The field is currently in beta.  The complete category can be generated by concatenating primary and detailed categories.  This feature is currently in beta – to request access, contact transactions-feedback@plaid.com.
 * @export
 * @interface PersonalFinanceCategory
 */
export interface PersonalFinanceCategory {
    [key: string]: object | any;
    /**
     * A high level category that communicates the broad category of the transaction.
     * @type {string}
     * @memberof PersonalFinanceCategory
     */
    primary: string;
    /**
     * Provides additional granularity to the primary categorization.
     * @type {string}
     * @memberof PersonalFinanceCategory
     */
    detailed: string;
}
/**
 * A phone number
 * @export
 * @interface PhoneNumber
 */
export interface PhoneNumber {
    [key: string]: object | any;
    /**
     * The phone number.
     * @type {string}
     * @memberof PhoneNumber
     */
    data: string;
    /**
     * When `true`, identifies the phone number as the primary number on an account.
     * @type {boolean}
     * @memberof PhoneNumber
     */
    primary: boolean;
    /**
     * The type of phone number.
     * @type {string}
     * @memberof PhoneNumber
     */
    type: PhoneNumberTypeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum PhoneNumberTypeEnum {
    Home = "home",
    Work = "work",
    Office = "office",
    Mobile = "mobile",
    Mobile1 = "mobile1",
    Other = "other"
}
/**
 * We use standard HTTP response codes for success and failure notifications, and our errors are further classified by `error_type`. In general, 200 HTTP codes correspond to success, 40X codes are for developer- or user-related failures, and 50X codes are for Plaid-related issues.  Error fields will be `null` if no error has occurred.
 * @export
 * @interface PlaidError
 */
export interface PlaidError {
    /**
     * A broad categorization of the error. Safe for programmatic use.
     * @type {string}
     * @memberof PlaidError
     */
    error_type: PlaidErrorErrorTypeEnum;
    /**
     * The particular error code. Safe for programmatic use.
     * @type {string}
     * @memberof PlaidError
     */
    error_code: string;
    /**
     * A developer-friendly representation of the error code. This may change over time and is not safe for programmatic use.
     * @type {string}
     * @memberof PlaidError
     */
    error_message: string;
    /**
     * A user-friendly representation of the error code. `null` if the error is not related to user action.  This may change over time and is not safe for programmatic use.
     * @type {string}
     * @memberof PlaidError
     */
    display_message: string | null;
    /**
     * A unique ID identifying the request, to be used for troubleshooting purposes. This field will be omitted in errors provided by webhooks.
     * @type {string}
     * @memberof PlaidError
     */
    request_id?: string;
    /**
     * In the Assets product, a request can pertain to more than one Item. If an error is returned for such a request, `causes` will return an array of errors containing a breakdown of these errors on the individual Item level, if any can be identified.  `causes` will only be provided for the `error_type` `ASSET_REPORT_ERROR`. `causes` will also not be populated inside an error nested within a `warning` object.
     * @type {Array<any>}
     * @memberof PlaidError
     */
    causes?: Array<any>;
    /**
     * The HTTP status code associated with the error. This will only be returned in the response body when the error information is provided via a webhook.
     * @type {number}
     * @memberof PlaidError
     */
    status?: number | null;
    /**
     * The URL of a Plaid documentation page with more information about the error
     * @type {string}
     * @memberof PlaidError
     */
    documentation_url?: string;
    /**
     * Suggested steps for resolving the error
     * @type {string}
     * @memberof PlaidError
     */
    suggested_action?: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum PlaidErrorErrorTypeEnum {
    InvalidRequest = "INVALID_REQUEST",
    InvalidResult = "INVALID_RESULT",
    InvalidInput = "INVALID_INPUT",
    InstitutionError = "INSTITUTION_ERROR",
    RateLimitExceeded = "RATE_LIMIT_EXCEEDED",
    ApiError = "API_ERROR",
    ItemError = "ITEM_ERROR",
    AssetReportError = "ASSET_REPORT_ERROR",
    RecaptchaError = "RECAPTCHA_ERROR",
    OauthError = "OAUTH_ERROR",
    PaymentError = "PAYMENT_ERROR",
    BankTransferError = "BANK_TRANSFER_ERROR",
    IncomeVerificationError = "INCOME_VERIFICATION_ERROR"
}
/**
 * An object containing a set of ids related to an employee
 * @export
 * @interface PlatformIds
 */
export interface PlatformIds {
    [key: string]: object | any;
    /**
     * The ID of an employee as given by their employer
     * @type {string}
     * @memberof PlatformIds
     */
    employee_id?: string | null;
    /**
     * The ID of an employee as given by their payroll
     * @type {string}
     * @memberof PlatformIds
     */
    payroll_id?: string | null;
    /**
     * The ID of the position of the employee
     * @type {string}
     * @memberof PlatformIds
     */
    position_id?: string | null;
}
/**
 * ProcessorApexProcessorTokenCreateRequest defines the request schema for `/processor/apex/processor_token/create`
 * @export
 * @interface ProcessorApexProcessorTokenCreateRequest
 */
export interface ProcessorApexProcessorTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorApexProcessorTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorApexProcessorTokenCreateRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ProcessorApexProcessorTokenCreateRequest
     */
    access_token: string;
    /**
     * The `account_id` value obtained from the `onSuccess` callback in Link
     * @type {string}
     * @memberof ProcessorApexProcessorTokenCreateRequest
     */
    account_id: string;
}
/**
 * ProcessorAuthGetRequest defines the request schema for `/processor/auth/get`
 * @export
 * @interface ProcessorAuthGetRequest
 */
export interface ProcessorAuthGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorAuthGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorAuthGetRequest
     */
    secret?: string;
    /**
     * The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`
     * @type {string}
     * @memberof ProcessorAuthGetRequest
     */
    processor_token: string;
}
/**
 * ProcessorAuthGetResponse defines the response schema for `/processor/auth/get`
 * @export
 * @interface ProcessorAuthGetResponse
 */
export interface ProcessorAuthGetResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ProcessorAuthGetResponse
     */
    request_id: string;
    /**
     *
     * @type {ProcessorNumber}
     * @memberof ProcessorAuthGetResponse
     */
    numbers: ProcessorNumber;
    /**
     *
     * @type {AccountBase}
     * @memberof ProcessorAuthGetResponse
     */
    account: AccountBase;
}
/**
 * ProcessorBalanceGetRequest defines the request schema for `/processor/balance/get`
 * @export
 * @interface ProcessorBalanceGetRequest
 */
export interface ProcessorBalanceGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorBalanceGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorBalanceGetRequest
     */
    secret?: string;
    /**
     * The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`
     * @type {string}
     * @memberof ProcessorBalanceGetRequest
     */
    processor_token: string;
    /**
     *
     * @type {ProcessorBalanceGetRequestOptions}
     * @memberof ProcessorBalanceGetRequest
     */
    options?: ProcessorBalanceGetRequestOptions;
}
/**
 * An optional object to filter `/processor/balance/get` results.
 * @export
 * @interface ProcessorBalanceGetRequestOptions
 */
export interface ProcessorBalanceGetRequestOptions {
    /**
     * Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the oldest acceptable balance when making a request to `/accounts/balance/get`.  If the balance that is pulled for `ins_128026` (Capital One) is older than the given timestamp, an `INVALID_REQUEST` error with the code of `LAST_UPDATED_DATETIME_OUT_OF_RANGE` will be returned with the most recent timestamp for the requested account contained in the response.  This field is only used when the institution is `ins_128026` (Capital One), in which case a value must be provided or an `INVALID_REQUEST` error with the code of `INVALID_FIELD` will be returned. For all other institutions, this field is ignored.
     * @type {string}
     * @memberof ProcessorBalanceGetRequestOptions
     */
    min_last_updated_datetime?: string;
}
/**
 * ProcessorBalanceGetResponse defines the response schema for `/processor/balance/get`
 * @export
 * @interface ProcessorBalanceGetResponse
 */
export interface ProcessorBalanceGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {AccountBase}
     * @memberof ProcessorBalanceGetResponse
     */
    account: AccountBase;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ProcessorBalanceGetResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/processor/bank_transfer/create`
 * @export
 * @interface ProcessorBankTransferCreateRequest
 */
export interface ProcessorBankTransferCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    secret?: string;
    /**
     * A random key provided by the client, per unique bank transfer. Maximum of 50 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. For example, if a request to create a bank transfer fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single bank transfer is created.
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    idempotency_key: string;
    /**
     * The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    processor_token: string;
    /**
     *
     * @type {BankTransferType}
     * @memberof ProcessorBankTransferCreateRequest
     */
    type: BankTransferType;
    /**
     *
     * @type {BankTransferNetwork}
     * @memberof ProcessorBankTransferCreateRequest
     */
    network: BankTransferNetwork;
    /**
     * The amount of the bank transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    amount: string;
    /**
     * The currency of the transfer amount – should be set to \"USD\".
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    iso_currency_code: string;
    /**
     * The transfer description. Maximum of 10 characters.
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    description: string;
    /**
     *
     * @type {ACHClass}
     * @memberof ProcessorBankTransferCreateRequest
     */
    ach_class?: ACHClass;
    /**
     *
     * @type {BankTransferUser}
     * @memberof ProcessorBankTransferCreateRequest
     */
    user: BankTransferUser;
    /**
     * An arbitrary string provided by the client for storage with the bank transfer. May be up to 100 characters.
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    custom_tag?: string | null;
    /**
     * The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters
     * @type {{ [key: string]: string; }}
     * @memberof ProcessorBankTransferCreateRequest
     */
    metadata?: {
        [key: string]: string;
    } | null;
    /**
     * Plaid’s unique identifier for the origination account for this transfer. If you have more than one origination account, this value must be specified.
     * @type {string}
     * @memberof ProcessorBankTransferCreateRequest
     */
    origination_account_id?: string | null;
}
/**
 * Defines the response schema for `/processor/bank_transfer/create`
 * @export
 * @interface ProcessorBankTransferCreateResponse
 */
export interface ProcessorBankTransferCreateResponse {
    [key: string]: object | any;
    /**
     *
     * @type {BankTransfer}
     * @memberof ProcessorBankTransferCreateResponse
     */
    bank_transfer: BankTransfer;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ProcessorBankTransferCreateResponse
     */
    request_id: string;
}
/**
 * ProcessorIdentityGetRequest defines the request schema for `/processor/identity/get`
 * @export
 * @interface ProcessorIdentityGetRequest
 */
export interface ProcessorIdentityGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorIdentityGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorIdentityGetRequest
     */
    secret?: string;
    /**
     * The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`
     * @type {string}
     * @memberof ProcessorIdentityGetRequest
     */
    processor_token: string;
}
/**
 * ProcessorIdentityGetResponse defines the response schema for `/processor/identity/get`
 * @export
 * @interface ProcessorIdentityGetResponse
 */
export interface ProcessorIdentityGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {AccountIdentity}
     * @memberof ProcessorIdentityGetResponse
     */
    account: AccountIdentity;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ProcessorIdentityGetResponse
     */
    request_id: string;
}
/**
 * An object containing identifying numbers used for making electronic transfers to and from the `account`. The identifying number type (ACH, EFT, IBAN, or BACS) used will depend on the country of the account. An account may have more than one number type. If a particular identifying number type is not used by the `account` for which auth data has been requested, a null value will be returned.
 * @export
 * @interface ProcessorNumber
 */
export interface ProcessorNumber {
    [key: string]: object | any;
    /**
     *
     * @type {NumbersACHNullable}
     * @memberof ProcessorNumber
     */
    ach?: NumbersACHNullable | null;
    /**
     *
     * @type {NumbersEFTNullable}
     * @memberof ProcessorNumber
     */
    eft?: NumbersEFTNullable | null;
    /**
     *
     * @type {NumbersInternationalNullable}
     * @memberof ProcessorNumber
     */
    international?: NumbersInternationalNullable | null;
    /**
     *
     * @type {NumbersBACSNullable}
     * @memberof ProcessorNumber
     */
    bacs?: NumbersBACSNullable | null;
}
/**
 * ProcessorStripeBankAccountTokenCreateRequest defines the request schema for `/processor/stripe/bank_account/create`
 * @export
 * @interface ProcessorStripeBankAccountTokenCreateRequest
 */
export interface ProcessorStripeBankAccountTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorStripeBankAccountTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorStripeBankAccountTokenCreateRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ProcessorStripeBankAccountTokenCreateRequest
     */
    access_token: string;
    /**
     * The `account_id` value obtained from the `onSuccess` callback in Link
     * @type {string}
     * @memberof ProcessorStripeBankAccountTokenCreateRequest
     */
    account_id: string;
}
/**
 * ProcessorStripeBankAccountTokenCreateResponse defines the response schema for `/processor/stripe/bank_account/create`
 * @export
 * @interface ProcessorStripeBankAccountTokenCreateResponse
 */
export interface ProcessorStripeBankAccountTokenCreateResponse {
    [key: string]: object | any;
    /**
     * A token that can be sent to Stripe for use in making API calls to Plaid
     * @type {string}
     * @memberof ProcessorStripeBankAccountTokenCreateResponse
     */
    stripe_bank_account_token: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ProcessorStripeBankAccountTokenCreateResponse
     */
    request_id: string;
}
/**
 * ProcessorTokenCreateRequest defines the request schema for `/processor/token/create`
 * @export
 * @interface ProcessorTokenCreateRequest
 */
export interface ProcessorTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof ProcessorTokenCreateRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof ProcessorTokenCreateRequest
     */
    access_token: string;
    /**
     * The `account_id` value obtained from the `onSuccess` callback in Link
     * @type {string}
     * @memberof ProcessorTokenCreateRequest
     */
    account_id: string;
    /**
     * The processor you are integrating with.
     * @type {string}
     * @memberof ProcessorTokenCreateRequest
     */
    processor: ProcessorTokenCreateRequestProcessorEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum ProcessorTokenCreateRequestProcessorEnum {
    Achq = "achq",
    Alpaca = "alpaca",
    Astra = "astra",
    Check = "check",
    Checkbook = "checkbook",
    Circle = "circle",
    Drivewealth = "drivewealth",
    Dwolla = "dwolla",
    Galileo = "galileo",
    Lithic = "lithic",
    ModernTreasury = "modern_treasury",
    Moov = "moov",
    Ocrolus = "ocrolus",
    PrimeTrust = "prime_trust",
    Rize = "rize",
    SilaMoney = "sila_money",
    SvbApi = "svb_api",
    TreasuryPrime = "treasury_prime",
    Unit = "unit",
    Vesta = "vesta",
    Vopay = "vopay",
    Wyre = "wyre"
}
/**
 * ProcessorTokenCreateResponse defines the response schema for `/processor/token/create` and `/processor/apex/processor_token/create`
 * @export
 * @interface ProcessorTokenCreateResponse
 */
export interface ProcessorTokenCreateResponse {
    [key: string]: object | any;
    /**
     * The `processor_token` that can then be used by the Plaid partner to make API requests
     * @type {string}
     * @memberof ProcessorTokenCreateResponse
     */
    processor_token: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof ProcessorTokenCreateResponse
     */
    request_id: string;
}
/**
 * The product access being requested. Used to or disallow product access across all accounts. If unset, defaults to all products allowed.
 * @export
 * @interface ProductAccess
 */
export interface ProductAccess {
    [key: string]: object | any;
    /**
     * Allow access to statements. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof ProductAccess
     */
    statements?: boolean | null;
    /**
     * Allow access to the Identity product (name, email, phone, address). Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof ProductAccess
     */
    identity?: boolean | null;
    /**
     * Allow access to account number details. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof ProductAccess
     */
    auth?: boolean | null;
    /**
     * Allow access to transaction details. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.
     * @type {boolean}
     * @memberof ProductAccess
     */
    transactions?: boolean | null;
}
/**
 * A representation of the status health of a request type. Auth requests, Balance requests, Identity requests, Investments requests, Liabilities requests, Transactions updates, Investments updates, Liabilities updates, and Item logins each have their own status object.
 * @export
 * @interface ProductStatus
 */
export interface ProductStatus {
    [key: string]: object | any;
    /**
     * This field is deprecated in favor of the `breakdown` object, which provides more granular institution health data.  `HEALTHY`: the majority of requests are successful `DEGRADED`: only some requests are successful `DOWN`: all requests are failing
     * @type {string}
     * @memberof ProductStatus
     * @deprecated
     */
    status: ProductStatusStatusEnum;
    /**
     * [ISO 8601](https://wikipedia.org/wiki/ISO_8601) formatted timestamp of the last status change for the institution.
     * @type {string}
     * @memberof ProductStatus
     */
    last_status_change: string;
    /**
     *
     * @type {ProductStatusBreakdown}
     * @memberof ProductStatus
     */
    breakdown: ProductStatusBreakdown;
}
/**
    * @export
    * @enum {string}
    */
export declare enum ProductStatusStatusEnum {
    Healthy = "HEALTHY",
    Degraded = "DEGRADED",
    Down = "DOWN"
}
/**
 * A detailed breakdown of the institution\'s performance for a request type. The values for `success`, `error_plaid`, and `error_institution` sum to 1.
 * @export
 * @interface ProductStatusBreakdown
 */
export interface ProductStatusBreakdown {
    [key: string]: object | any;
    /**
     * The percentage of login attempts that are successful, expressed as a decimal.
     * @type {number}
     * @memberof ProductStatusBreakdown
     */
    success: number;
    /**
     * The percentage of logins that are failing due to an internal Plaid issue, expressed as a decimal.
     * @type {number}
     * @memberof ProductStatusBreakdown
     */
    error_plaid: number;
    /**
     * The percentage of logins that are failing due to an issue in the institution\'s system, expressed as a decimal.
     * @type {number}
     * @memberof ProductStatusBreakdown
     */
    error_institution: number;
    /**
     * The `refresh_interval` may be `DELAYED` or `STOPPED` even when the success rate is high. This value is only returned for Transactions status breakdowns.
     * @type {string}
     * @memberof ProductStatusBreakdown
     */
    refresh_interval?: ProductStatusBreakdownRefreshIntervalEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum ProductStatusBreakdownRefreshIntervalEnum {
    Normal = "NORMAL",
    Delayed = "DELAYED",
    Stopped = "STOPPED"
}
/**
 * A list of products that an institution can support. All Items must be initialized with at least one product. The Balance product is always available and does not need to be specified during initialization.
 * @export
 * @enum {string}
 */
export declare enum Products {
    Assets = "assets",
    Auth = "auth",
    Balance = "balance",
    Identity = "identity",
    Investments = "investments",
    Liabilities = "liabilities",
    PaymentInitiation = "payment_initiation",
    Transactions = "transactions",
    CreditDetails = "credit_details",
    Income = "income",
    IncomeVerification = "income_verification",
    DepositSwitch = "deposit_switch",
    StandingOrders = "standing_orders",
    Transfer = "transfer",
    Employment = "employment"
}
/**
 * The employee\'s estimated annual salary, as derived from information reported on the paystub.
 * @export
 * @interface ProjectedIncomeSummaryFieldNumber
 */
export interface ProjectedIncomeSummaryFieldNumber {
    /**
     * The value of the field.
     * @type {number}
     * @memberof ProjectedIncomeSummaryFieldNumber
     */
    value: number;
    /**
     *
     * @type {VerificationStatus}
     * @memberof ProjectedIncomeSummaryFieldNumber
     */
    verification_status: VerificationStatus;
}
/**
 * The request was flagged by Plaid\'s fraud system, and requires additional verification to ensure they are not a bot.
 * @export
 * @interface RecaptchaRequiredError
 */
export interface RecaptchaRequiredError {
    [key: string]: object | any;
    /**
     * RECAPTCHA_ERROR
     * @type {string}
     * @memberof RecaptchaRequiredError
     */
    error_type: string;
    /**
     * RECAPTCHA_REQUIRED
     * @type {string}
     * @memberof RecaptchaRequiredError
     */
    error_code: string;
    /**
     *
     * @type {string}
     * @memberof RecaptchaRequiredError
     */
    display_message: string;
    /**
     * 400
     * @type {string}
     * @memberof RecaptchaRequiredError
     */
    http_code: string;
    /**
     * Your user will be prompted to solve a Google reCAPTCHA challenge in the Link Recaptcha pane. If they solve the challenge successfully, the user\'s request is resubmitted and they are directed to the next Item creation step.
     * @type {string}
     * @memberof RecaptchaRequiredError
     */
    link_user_experience: string;
    /**
     * Plaid\'s fraud system detects abusive traffic and considers a variety of parameters throughout Item creation requests. When a request is considered risky or possibly fraudulent, Link presents a reCAPTCHA for the user to solve.
     * @type {string}
     * @memberof RecaptchaRequiredError
     */
    common_causes: string;
    /**
     * Link will automatically guide your user through reCAPTCHA verification. As a general rule, we recommend instrumenting basic fraud monitoring to detect and protect your website from spam and abuse.  If your user cannot verify their session, please submit a Support ticket with the following identifiers: `link_session_id` or `request_id`
     * @type {string}
     * @memberof RecaptchaRequiredError
     */
    troubleshooting_steps: string;
}
/**
 * An object containing a BACS account number and sort code. If an IBAN is not provided or if this recipient needs to accept domestic GBP-denominated payments, BACS data is required.
 * @export
 * @interface RecipientBACS
 */
export interface RecipientBACS {
    [key: string]: object | any;
    /**
     * The account number of the account. Maximum of 10 characters.
     * @type {string}
     * @memberof RecipientBACS
     */
    account?: string;
    /**
     * The 6-character sort code of the account.
     * @type {string}
     * @memberof RecipientBACS
     */
    sort_code?: string;
}
/**
 * An object containing a BACS account number and sort code. If an IBAN is not provided or if this recipient needs to accept domestic GBP-denominated payments, BACS data is required.
 * @export
 * @interface RecipientBACSNullable
 */
export interface RecipientBACSNullable {
    /**
     * The account number of the account. Maximum of 10 characters.
     * @type {string}
     * @memberof RecipientBACSNullable
     */
    account?: string;
    /**
     * The 6-character sort code of the account.
     * @type {string}
     * @memberof RecipientBACSNullable
     */
    sort_code?: string;
}
/**
 * describes the frequency of the transaction stream.
 * @export
 * @enum {string}
 */
export declare enum RecurringTransactionFrequency {
    Unknown = "UNKNOWN",
    Weekly = "WEEKLY",
    Biweekly = "BIWEEKLY",
    SemiMonthly = "SEMI_MONTHLY",
    Monthly = "MONTHLY"
}
/**
 * A representation of a removed transaction
 * @export
 * @interface RemovedTransaction
 */
export interface RemovedTransaction {
    /**
     * The ID of the removed transaction.
     * @type {string}
     * @memberof RemovedTransaction
     */
    transaction_id?: string;
}
/**
 * Scope of required and optional account features or content from a ConnectedApplication.
 * @export
 * @interface RequestedScopes
 */
export interface RequestedScopes {
    /**
     *
     * @type {AccountFilter}
     * @memberof RequestedScopes
     */
    account_filters?: AccountFilter;
    /**
     *
     * @type {AccountSelectionCardinality}
     * @memberof RequestedScopes
     */
    account_selection_cardinality: AccountSelectionCardinality;
}
/**
 * Defines the request schema for `/sandbox/bank_transfer/fire_webhook`
 * @export
 * @interface SandboxBankTransferFireWebhookRequest
 */
export interface SandboxBankTransferFireWebhookRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxBankTransferFireWebhookRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxBankTransferFireWebhookRequest
     */
    secret?: string;
    /**
     * The URL to which the webhook should be sent.
     * @type {string}
     * @memberof SandboxBankTransferFireWebhookRequest
     */
    webhook: string;
}
/**
 * Defines the response schema for `/sandbox/bank_transfer/fire_webhook`
 * @export
 * @interface SandboxBankTransferFireWebhookResponse
 */
export interface SandboxBankTransferFireWebhookResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxBankTransferFireWebhookResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/sandbox/bank_transfer/simulate`
 * @export
 * @interface SandboxBankTransferSimulateRequest
 */
export interface SandboxBankTransferSimulateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxBankTransferSimulateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxBankTransferSimulateRequest
     */
    secret?: string;
    /**
     * Plaid’s unique identifier for a bank transfer.
     * @type {string}
     * @memberof SandboxBankTransferSimulateRequest
     */
    bank_transfer_id: string;
    /**
     * The asynchronous event to be simulated. May be: `posted`, `failed`, or `reversed`.  An error will be returned if the event type is incompatible with the current transfer status. Compatible status --> event type transitions include:  `pending` --> `failed`  `pending` --> `posted`  `posted` --> `reversed`
     * @type {string}
     * @memberof SandboxBankTransferSimulateRequest
     */
    event_type: string;
    /**
     *
     * @type {BankTransferFailure}
     * @memberof SandboxBankTransferSimulateRequest
     */
    failure_reason?: BankTransferFailure | null;
}
/**
 * Defines the response schema for `/sandbox/bank_transfer/simulate`
 * @export
 * @interface SandboxBankTransferSimulateResponse
 */
export interface SandboxBankTransferSimulateResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxBankTransferSimulateResponse
     */
    request_id: string;
}
/**
 * SandboxIncomeFireWebhookRequest defines the request schema for `/sandbox/income/fire_webhook`
 * @export
 * @interface SandboxIncomeFireWebhookRequest
 */
export interface SandboxIncomeFireWebhookRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxIncomeFireWebhookRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxIncomeFireWebhookRequest
     */
    secret?: string;
    /**
     * The ID of the verification.
     * @type {string}
     * @memberof SandboxIncomeFireWebhookRequest
     */
    income_verification_id: string;
    /**
     * The Item ID associated with the verification.
     * @type {string}
     * @memberof SandboxIncomeFireWebhookRequest
     */
    item_id: string;
    /**
     * The URL to which the webhook should be sent.
     * @type {string}
     * @memberof SandboxIncomeFireWebhookRequest
     */
    webhook: string;
    /**
     * `VERIFICATION_STATUS_PROCESSING_COMPLETE`: The income verification status processing has completed. If the user uploaded multiple documents, this webhook will fire when all documents have finished processing. Call the `/income/verification/paystubs/get` endpoint and check the document metadata to see which documents were successfully parsed.  `VERIFICATION_STATUS_PROCESSING_FAILED`: A failure occurred when attempting to process the verification documentation.  `VERIFICATION_STATUS_PENDING_APPROVAL`: The income verification has been sent to the user for review.
     * @type {string}
     * @memberof SandboxIncomeFireWebhookRequest
     */
    verification_status: SandboxIncomeFireWebhookRequestVerificationStatusEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum SandboxIncomeFireWebhookRequestVerificationStatusEnum {
    ProcessingComplete = "VERIFICATION_STATUS_PROCESSING_COMPLETE",
    ProcessingFailed = "VERIFICATION_STATUS_PROCESSING_FAILED",
    PendingApproval = "VERIFICATION_STATUS_PENDING_APPROVAL"
}
/**
 * SandboxIncomeFireWebhookResponse defines the response schema for `/sandbox/income/fire_webhook`
 * @export
 * @interface SandboxIncomeFireWebhookResponse
 */
export interface SandboxIncomeFireWebhookResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxIncomeFireWebhookResponse
     */
    request_id: string;
}
/**
 * SandboxItemFireWebhookRequest defines the request schema for `/sandbox/item/fire_webhook`
 * @export
 * @interface SandboxItemFireWebhookRequest
 */
export interface SandboxItemFireWebhookRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxItemFireWebhookRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxItemFireWebhookRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof SandboxItemFireWebhookRequest
     */
    access_token: string;
    /**
     * The following values for `webhook_code` are supported:  * `DEFAULT_UPDATE` * `NEW_ACCOUNTS_AVAILABLE`
     * @type {string}
     * @memberof SandboxItemFireWebhookRequest
     */
    webhook_code: SandboxItemFireWebhookRequestWebhookCodeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum SandboxItemFireWebhookRequestWebhookCodeEnum {
    DefaultUpdate = "DEFAULT_UPDATE",
    NewAccountsAvailable = "NEW_ACCOUNTS_AVAILABLE"
}
/**
 * SandboxItemFireWebhookResponse defines the response schema for `/sandbox/item/fire_webhook`
 * @export
 * @interface SandboxItemFireWebhookResponse
 */
export interface SandboxItemFireWebhookResponse {
    [key: string]: object | any;
    /**
     * Value is `true`  if the test` webhook_code`  was successfully fired.
     * @type {boolean}
     * @memberof SandboxItemFireWebhookResponse
     */
    webhook_fired: boolean;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxItemFireWebhookResponse
     */
    request_id: string;
}
/**
 * SandboxItemResetLoginRequest defines the request schema for `/sandbox/item/reset_login`
 * @export
 * @interface SandboxItemResetLoginRequest
 */
export interface SandboxItemResetLoginRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxItemResetLoginRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxItemResetLoginRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof SandboxItemResetLoginRequest
     */
    access_token: string;
}
/**
 * SandboxItemResetLoginResponse defines the response schema for `/sandbox/item/reset_login`
 * @export
 * @interface SandboxItemResetLoginResponse
 */
export interface SandboxItemResetLoginResponse {
    [key: string]: object | any;
    /**
     * `true` if the call succeeded
     * @type {boolean}
     * @memberof SandboxItemResetLoginResponse
     */
    reset_login: boolean;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxItemResetLoginResponse
     */
    request_id: string;
}
/**
 * SandboxItemSetVerificationStatusRequest defines the request schema for `/sandbox/item/set_verification_status`
 * @export
 * @interface SandboxItemSetVerificationStatusRequest
 */
export interface SandboxItemSetVerificationStatusRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxItemSetVerificationStatusRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxItemSetVerificationStatusRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof SandboxItemSetVerificationStatusRequest
     */
    access_token: string;
    /**
     * The `account_id` of the account whose verification status is to be modified
     * @type {string}
     * @memberof SandboxItemSetVerificationStatusRequest
     */
    account_id: string;
    /**
     * The verification status to set the account to.
     * @type {string}
     * @memberof SandboxItemSetVerificationStatusRequest
     */
    verification_status: SandboxItemSetVerificationStatusRequestVerificationStatusEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum SandboxItemSetVerificationStatusRequestVerificationStatusEnum {
    AutomaticallyVerified = "automatically_verified",
    VerificationExpired = "verification_expired"
}
/**
 * SandboxItemSetVerificationStatusResponse defines the response schema for `/sandbox/item/set_verification_status`
 * @export
 * @interface SandboxItemSetVerificationStatusResponse
 */
export interface SandboxItemSetVerificationStatusResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxItemSetVerificationStatusResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `sandbox/oauth/select_accounts`
 * @export
 * @interface SandboxOauthSelectAccountsRequest
 */
export interface SandboxOauthSelectAccountsRequest {
    /**
     *
     * @type {string}
     * @memberof SandboxOauthSelectAccountsRequest
     */
    oauth_state_id: string;
    /**
     *
     * @type {Array<string>}
     * @memberof SandboxOauthSelectAccountsRequest
     */
    accounts: Array<string>;
}
/**
 * SandboxProcessorTokenCreateRequest defines the request schema for `/sandbox/processor_token/create`
 * @export
 * @interface SandboxProcessorTokenCreateRequest
 */
export interface SandboxProcessorTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxProcessorTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxProcessorTokenCreateRequest
     */
    secret?: string;
    /**
     * The ID of the institution the Item will be associated with
     * @type {string}
     * @memberof SandboxProcessorTokenCreateRequest
     */
    institution_id: string;
    /**
     *
     * @type {SandboxProcessorTokenCreateRequestOptions}
     * @memberof SandboxProcessorTokenCreateRequest
     */
    options?: SandboxProcessorTokenCreateRequestOptions;
}
/**
 * An optional set of options to be used when configuring the Item. If specified, must not be `null`.
 * @export
 * @interface SandboxProcessorTokenCreateRequestOptions
 */
export interface SandboxProcessorTokenCreateRequestOptions {
    /**
     * Test username to use for the creation of the Sandbox Item. Default value is `user_good`.
     * @type {string}
     * @memberof SandboxProcessorTokenCreateRequestOptions
     */
    override_username?: string | null;
    /**
     * Test password to use for the creation of the Sandbox Item. Default value is `pass_good`.
     * @type {string}
     * @memberof SandboxProcessorTokenCreateRequestOptions
     */
    override_password?: string | null;
}
/**
 * SandboxProcessorTokenCreateResponse defines the response schema for `/sandbox/processor_token/create`
 * @export
 * @interface SandboxProcessorTokenCreateResponse
 */
export interface SandboxProcessorTokenCreateResponse {
    [key: string]: object | any;
    /**
     * A processor token that can be used to call the `/processor/` endpoints.
     * @type {string}
     * @memberof SandboxProcessorTokenCreateResponse
     */
    processor_token: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxProcessorTokenCreateResponse
     */
    request_id: string;
}
/**
 * SandboxPublicTokenCreateRequest defines the request schema for `/sandbox/public_token/create`
 * @export
 * @interface SandboxPublicTokenCreateRequest
 */
export interface SandboxPublicTokenCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxPublicTokenCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxPublicTokenCreateRequest
     */
    secret?: string;
    /**
     * The ID of the institution the Item will be associated with
     * @type {string}
     * @memberof SandboxPublicTokenCreateRequest
     */
    institution_id: string;
    /**
     * The products to initially pull for the Item. May be any products that the specified `institution_id`  supports. This array may not be empty.
     * @type {Array<Products>}
     * @memberof SandboxPublicTokenCreateRequest
     */
    initial_products: Array<Products>;
    /**
     *
     * @type {SandboxPublicTokenCreateRequestOptions}
     * @memberof SandboxPublicTokenCreateRequest
     */
    options?: SandboxPublicTokenCreateRequestOptions;
}
/**
 * An optional set of options to be used when configuring the Item. If specified, must not be `null`.
 * @export
 * @interface SandboxPublicTokenCreateRequestOptions
 */
export interface SandboxPublicTokenCreateRequestOptions {
    /**
     * Specify a webhook to associate with the new Item.
     * @type {string}
     * @memberof SandboxPublicTokenCreateRequestOptions
     */
    webhook?: string;
    /**
     * Test username to use for the creation of the Sandbox Item. Default value is `user_good`.
     * @type {string}
     * @memberof SandboxPublicTokenCreateRequestOptions
     */
    override_username?: string | null;
    /**
     * Test password to use for the creation of the Sandbox Item. Default value is `pass_good`.
     * @type {string}
     * @memberof SandboxPublicTokenCreateRequestOptions
     */
    override_password?: string | null;
    /**
     *
     * @type {SandboxPublicTokenCreateRequestOptionsTransactions}
     * @memberof SandboxPublicTokenCreateRequestOptions
     */
    transactions?: SandboxPublicTokenCreateRequestOptionsTransactions;
}
/**
 * An optional set of parameters corresponding to transactions options.
 * @export
 * @interface SandboxPublicTokenCreateRequestOptionsTransactions
 */
export interface SandboxPublicTokenCreateRequestOptionsTransactions {
    /**
     * The earliest date for which to fetch transaction history. Dates should be formatted as YYYY-MM-DD.
     * @type {string}
     * @memberof SandboxPublicTokenCreateRequestOptionsTransactions
     */
    start_date?: string;
    /**
     * The most recent date for which to fetch transaction history. Dates should be formatted as YYYY-MM-DD.
     * @type {string}
     * @memberof SandboxPublicTokenCreateRequestOptionsTransactions
     */
    end_date?: string;
}
/**
 * SandboxPublicTokenCreateResponse defines the response schema for `/sandbox/public_token/create`
 * @export
 * @interface SandboxPublicTokenCreateResponse
 */
export interface SandboxPublicTokenCreateResponse {
    [key: string]: object | any;
    /**
     * A public token that can be exchanged for an access token using `/item/public_token/exchange`
     * @type {string}
     * @memberof SandboxPublicTokenCreateResponse
     */
    public_token: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxPublicTokenCreateResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/sandbox/transfer/repayment/simulate`
 * @export
 * @interface SandboxTransferRepaymentSimulateRequest
 */
export interface SandboxTransferRepaymentSimulateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxTransferRepaymentSimulateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxTransferRepaymentSimulateRequest
     */
    secret?: string;
}
/**
 * Defines the response schema for `/sandbox/transfer/repayment/simulate`
 * @export
 * @interface SandboxTransferRepaymentSimulateResponse
 */
export interface SandboxTransferRepaymentSimulateResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxTransferRepaymentSimulateResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/sandbox/transfer/simulate`
 * @export
 * @interface SandboxTransferSimulateRequest
 */
export interface SandboxTransferSimulateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxTransferSimulateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxTransferSimulateRequest
     */
    secret?: string;
    /**
     * Plaid’s unique identifier for a transfer.
     * @type {string}
     * @memberof SandboxTransferSimulateRequest
     */
    transfer_id: string;
    /**
     * The asynchronous event to be simulated. May be: `posted`, `failed`, or `reversed`.  An error will be returned if the event type is incompatible with the current transfer status. Compatible status --> event type transitions include:  `pending` --> `failed`  `pending` --> `posted`  `posted` --> `reversed`
     * @type {string}
     * @memberof SandboxTransferSimulateRequest
     */
    event_type: string;
    /**
     *
     * @type {TransferFailure}
     * @memberof SandboxTransferSimulateRequest
     */
    failure_reason?: TransferFailure | null;
}
/**
 * Defines the response schema for `/sandbox/transfer/simulate`
 * @export
 * @interface SandboxTransferSimulateResponse
 */
export interface SandboxTransferSimulateResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxTransferSimulateResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/sandbox/transfer/sweep/simulate`
 * @export
 * @interface SandboxTransferSweepSimulateRequest
 */
export interface SandboxTransferSweepSimulateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SandboxTransferSweepSimulateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SandboxTransferSweepSimulateRequest
     */
    secret?: string;
}
/**
 * Defines the response schema for `/sandbox/transfer/sweep/simulate`
 * @export
 * @interface SandboxTransferSweepSimulateResponse
 */
export interface SandboxTransferSweepSimulateResponse {
    [key: string]: object | any;
    /**
     *
     * @type {SimulatedTransferSweep}
     * @memberof SandboxTransferSweepSimulateResponse
     */
    sweep?: SimulatedTransferSweep;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SandboxTransferSweepSimulateResponse
     */
    request_id: string;
}
/**
 * The scopes object
 * @export
 * @interface Scopes
 */
export interface Scopes {
    /**
     *
     * @type {ProductAccess}
     * @memberof Scopes
     */
    product_access?: ProductAccess;
    /**
     *
     * @type {Array<AccountAccess>}
     * @memberof Scopes
     */
    accounts?: Array<AccountAccess>;
    /**
     * Allow access to newly opened accounts as they are opened. If unset, defaults to `true`.
     * @type {boolean}
     * @memberof Scopes
     */
    new_accounts?: boolean | null;
}
/**
 * An indicator for when scopes are being updated. When scopes are updated via enrollment (i.e. OAuth), the partner must send `ENROLLMENT`. When scopes are updated in a post-enrollment view, the partner must send `PORTAL`.
 * @export
 * @enum {string}
 */
export declare enum ScopesContext {
    Enrollment = "ENROLLMENT",
    Portal = "PORTAL"
}
/**
 * The scopes object
 * @export
 * @interface ScopesNullable
 */
export interface ScopesNullable {
    /**
     *
     * @type {ProductAccess}
     * @memberof ScopesNullable
     */
    product_access?: ProductAccess;
    /**
     *
     * @type {Array<AccountAccess>}
     * @memberof ScopesNullable
     */
    accounts?: Array<AccountAccess>;
    /**
     * Allow access to newly opened accounts as they are opened. If unset, defaults to `true`.
     * @type {boolean}
     * @memberof ScopesNullable
     */
    new_accounts?: boolean | null;
}
/**
 * Contains details about a security
 * @export
 * @interface Security
 */
export interface Security {
    [key: string]: object | any;
    /**
     * A unique, Plaid-specific identifier for the security, used to associate securities with holdings. Like all Plaid identifiers, the `security_id` is case sensitive.
     * @type {string}
     * @memberof Security
     */
    security_id: string;
    /**
     * 12-character ISIN, a globally unique securities identifier.
     * @type {string}
     * @memberof Security
     */
    isin: string | null;
    /**
     * 9-character CUSIP, an identifier assigned to North American securities.
     * @type {string}
     * @memberof Security
     */
    cusip: string | null;
    /**
     * 7-character SEDOL, an identifier assigned to securities in the UK.
     * @type {string}
     * @memberof Security
     */
    sedol: string | null;
    /**
     * An identifier given to the security by the institution
     * @type {string}
     * @memberof Security
     */
    institution_security_id: string | null;
    /**
     * If `institution_security_id` is present, this field indicates the Plaid `institution_id` of the institution to whom the identifier belongs.
     * @type {string}
     * @memberof Security
     */
    institution_id: string | null;
    /**
     * In certain cases, Plaid will provide the ID of another security whose performance resembles this security, typically when the original security has low volume, or when a private security can be modeled with a publicly traded security.
     * @type {string}
     * @memberof Security
     */
    proxy_security_id: string | null;
    /**
     * A descriptive name for the security, suitable for display.
     * @type {string}
     * @memberof Security
     */
    name: string | null;
    /**
     * The security’s trading symbol for publicly traded securities, and otherwise a short identifier if available.
     * @type {string}
     * @memberof Security
     */
    ticker_symbol: string | null;
    /**
     * Indicates that a security is a highly liquid asset and can be treated like cash.
     * @type {boolean}
     * @memberof Security
     */
    is_cash_equivalent: boolean | null;
    /**
     * The security type of the holding. Valid security types are:  `cash`: Cash, currency, and money market funds  `derivative`: Options, warrants, and other derivative instruments  `equity`: Domestic and foreign equities  `etf`: Multi-asset exchange-traded investment funds  `fixed income`: Bonds and certificates of deposit (CDs)  `loan`: Loans and loan receivables.  `mutual fund`: Open- and closed-end vehicles pooling funds of multiple investors.  `other`: Unknown or other investment types
     * @type {string}
     * @memberof Security
     */
    type: string | null;
    /**
     * Price of the security at the close of the previous trading session. `null` for non-public securities. If the security is a foreign currency or a cryptocurrency this field will be updated daily and will be priced in USD.
     * @type {number}
     * @memberof Security
     */
    close_price: number | null;
    /**
     * Date for which `close_price` is accurate. Always `null` if `close_price` is `null`.
     * @type {string}
     * @memberof Security
     */
    close_price_as_of: string | null;
    /**
     * The ISO-4217 currency code of the price given. Always `null` if `unofficial_currency_code` is non-`null`.
     * @type {string}
     * @memberof Security
     */
    iso_currency_code: string | null;
    /**
     * The unofficial currency code associated with the security. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof Security
     */
    unofficial_currency_code: string | null;
}
/**
 * Specify the security associated with the holding or investment transaction. When inputting custom security data to the Sandbox, Plaid will perform post-data-retrieval normalization and enrichment. These processes may cause the data returned by the Sandbox to be slightly different from the data you input. An ISO-4217 currency code and a security identifier (`ticker_symbol`, `cusip`, `isin`, or `sedol`) are required.
 * @export
 * @interface SecurityOverride
 */
export interface SecurityOverride {
    /**
     * 12-character ISIN, a globally unique securities identifier.
     * @type {string}
     * @memberof SecurityOverride
     */
    isin?: string;
    /**
     * 9-character CUSIP, an identifier assigned to North American securities.
     * @type {string}
     * @memberof SecurityOverride
     */
    cusip?: string;
    /**
     * 7-character SEDOL, an identifier assigned to securities in the UK.
     * @type {string}
     * @memberof SecurityOverride
     */
    sedol?: string;
    /**
     * A descriptive name for the security, suitable for display.
     * @type {string}
     * @memberof SecurityOverride
     */
    name?: string;
    /**
     * The security’s trading symbol for publicly traded securities, and otherwise a short identifier if available.
     * @type {string}
     * @memberof SecurityOverride
     */
    ticker_symbol?: string;
    /**
     * Either a valid `iso_currency_code` or `unofficial_currency_code`
     * @type {string}
     * @memberof SecurityOverride
     */
    currency?: string;
}
/**
 * An object containing a BACS account number and sort code. If an IBAN is not provided or if this recipient needs to accept domestic GBP-denominated payments, BACS data is required.
 * @export
 * @interface SenderBACSNullable
 */
export interface SenderBACSNullable {
    /**
     * The account number of the account. Maximum of 10 characters.
     * @type {string}
     * @memberof SenderBACSNullable
     */
    account?: string;
    /**
     * The 6-character sort code of the account.
     * @type {string}
     * @memberof SenderBACSNullable
     */
    sort_code?: string;
}
/**
 * The address of the student loan servicer. This is generally the remittance address to which payments should be sent.
 * @export
 * @interface ServicerAddressData
 */
export interface ServicerAddressData {
    [key: string]: object | any;
    /**
     * The full city name
     * @type {string}
     * @memberof ServicerAddressData
     */
    city: string | null;
    /**
     * The region or state Example: `\"NC\"`
     * @type {string}
     * @memberof ServicerAddressData
     */
    region: string | null;
    /**
     * The full street address Example: `\"564 Main Street, APT 15\"`
     * @type {string}
     * @memberof ServicerAddressData
     */
    street: string | null;
    /**
     * The postal code
     * @type {string}
     * @memberof ServicerAddressData
     */
    postal_code: string | null;
    /**
     * The ISO 3166-1 alpha-2 country code
     * @type {string}
     * @memberof ServicerAddressData
     */
    country: string | null;
}
/**
 * Data about the components comprising an address.
 * @export
 * @interface SignalAddressData
 */
export interface SignalAddressData {
    [key: string]: object | any;
    /**
     * The full city name
     * @type {string}
     * @memberof SignalAddressData
     */
    city?: string;
    /**
     * The region or state Example: `\"NC\"`
     * @type {string}
     * @memberof SignalAddressData
     */
    region?: string | null;
    /**
     * The full street address Example: `\"564 Main Street, APT 15\"`
     * @type {string}
     * @memberof SignalAddressData
     */
    street?: string;
    /**
     * The postal code
     * @type {string}
     * @memberof SignalAddressData
     */
    postal_code?: string | null;
    /**
     * The ISO 3166-1 alpha-2 country code
     * @type {string}
     * @memberof SignalAddressData
     */
    country?: string | null;
}
/**
 * SignalDecisionReportRequest defines the request schema for `/signal/decision/report`
 * @export
 * @interface SignalDecisionReportRequest
 */
export interface SignalDecisionReportRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SignalDecisionReportRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SignalDecisionReportRequest
     */
    secret?: string;
    /**
     * Must be the same as the `client_transaction_id` supplied when calling `/signal/evaluate`
     * @type {string}
     * @memberof SignalDecisionReportRequest
     */
    client_transaction_id: string;
    /**
     * `true` if the ACH transaction was initiated, `false` otherwise.
     * @type {boolean}
     * @memberof SignalDecisionReportRequest
     */
    initiated: boolean;
    /**
     * The actual number of days (hold time) since the ACH debit transaction that you wait before making funds available to your customers. The holding time could affect the ACH return rate. For example, use 0 if you make funds available to your customers instantly or the same day following the debit transaction, or 1 if you make funds available the next day following the debit initialization.
     * @type {number}
     * @memberof SignalDecisionReportRequest
     */
    days_funds_on_hold?: number | null;
}
/**
 * SignalDecisionReportResponse defines the response schema for `/signal/decision/report`
 * @export
 * @interface SignalDecisionReportResponse
 */
export interface SignalDecisionReportResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SignalDecisionReportResponse
     */
    request_id: string;
}
/**
 * Details about the end user\'s device
 * @export
 * @interface SignalDevice
 */
export interface SignalDevice {
    /**
     * The IP address of the device that initiated the transaction
     * @type {string}
     * @memberof SignalDevice
     */
    ip_address?: string | null;
    /**
     * The user agent of the device that initiated the transaction (e.g. \"Mozilla/5.0\")
     * @type {string}
     * @memberof SignalDevice
     */
    user_agent?: string | null;
}
/**
 * The core attributes object contains additional data that can be used to assess the ACH return risk. Examples of data include:  `days_since_first_plaid_connection`: The number of days since the first time the Item was connected to an application via Plaid `plaid_connections_count_7d`: The number of times the Item has been connected to applications via Plaid over the past 7 days `plaid_connections_count_30d`: The number of times the Item has been connected to applications via Plaid over the past 30 days `total_plaid_connections_count`: The number of times the Item has been connected to applications via Plaid `is_savings_or_money_market_account`: Indicates whether the ACH transaction funding account is a savings/money market account  For the full list and detailed documentation of core attributes available, or to request that core attributes not be returned, contact Sales or your Plaid account manager
 * @export
 * @interface SignalEvaluateCoreAttributes
 */
export interface SignalEvaluateCoreAttributes {
    /**
     * We parse and analyze historical transaction metadata to identify the number of possible past returns due to unauthorized transactions over the past 7 days from the account that will be debited.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    unauthorized_transactions_count_7d?: number;
    /**
     * We parse and analyze historical transaction metadata to identify the number of possible past returns due to unauthorized transactions over the past 30 days from the account that will be debited.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    unauthorized_transactions_count_30d?: number;
    /**
     * We parse and analyze historical transaction metadata to identify the number of possible past returns due to unauthorized transactions over the past 60 days from the account that will be debited.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    unauthorized_transactions_count_60d?: number;
    /**
     * We parse and analyze historical transaction metadata to identify the number of possible past returns due to unauthorized transactions over the past 90 days from the account that will be debited.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    unauthorized_transactions_count_90d?: number;
    /**
     * We parse and analyze historical transaction metadata to identify the number of possible past returns due to non-sufficient funds/overdrafts over the past 7 days from the account that will be debited.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    nsf_overdraft_transactions_count_7d?: number;
    /**
     * We parse and analyze historical transaction metadata to identify the number of possible past returns due to non-sufficient funds/overdrafts over the past 30 days from the account that will be debited.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    nsf_overdraft_transactions_count_30d?: number;
    /**
     * We parse and analyze historical transaction metadata to identify the number of possible past returns due to non-sufficient funds/overdrafts over the past 60 days from the account that will be debited.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    nsf_overdraft_transactions_count_60d?: number;
    /**
     * We parse and analyze historical transaction metadata to identify the number of possible past returns due to non-sufficient funds/overdrafts over the past 90 days from the account that will be debited.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    nsf_overdraft_transactions_count_90d?: number;
    /**
     * The number of days since the first time the Item was connected to an application via Plaid
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    days_since_first_plaid_connection?: number | null;
    /**
     * The number of times the Item has been connected to applications via Plaid over the past 7 days
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    plaid_connections_count_7d?: number | null;
    /**
     * The number of times the Item has been connected to applications via Plaid over the past 30 days
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    plaid_connections_count_30d?: number | null;
    /**
     * The total number of times the Item has been connected to applications via Plaid
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    total_plaid_connections_count?: number | null;
    /**
     * Indicates if the ACH transaction funding account is a savings/money market account
     * @type {boolean}
     * @memberof SignalEvaluateCoreAttributes
     */
    is_savings_or_money_market_account?: boolean;
    /**
     * The total credit (inflow) transaction amount over the past 10 days from the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    total_credit_transactions_amount_10d?: number;
    /**
     * The total debit (outflow) transaction amount over the past 10 days from the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    total_debit_transactions_amount_10d?: number;
    /**
     * The 50th percentile of all credit (inflow) transaction amounts over the past 28 days from the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p50_credit_transactions_amount_28d?: number | null;
    /**
     * The 50th percentile of all debit (outflow) transaction amounts over the past 28 days from the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p50_debit_transactions_amount_28d?: number | null;
    /**
     * The 95th percentile of all credit (inflow) transaction amounts over the past 28 days from the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p95_credit_transactions_amount_28d?: number | null;
    /**
     * The 95th percentile of all debit (outflow) transaction amounts over the past 28 days from the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p95_debit_transactions_amount_28d?: number | null;
    /**
     * The number of days within the past 90 days when the account that will be debited had a negative end-of-day available balance
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    days_with_negative_balance_count_90d?: number | null;
    /**
     * The 90th percentile of the end-of-day available balance over the past 30 days of the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p90_eod_balance_30d?: number | null;
    /**
     * The 90th percentile of the end-of-day available balance over the past 60 days of the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p90_eod_balance_60d?: number | null;
    /**
     * The 90th percentile of the end-of-day available balance over the past 90 days of the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p90_eod_balance_90d?: number | null;
    /**
     * The 10th percentile of the end-of-day available balance over the past 30 days of the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p10_eod_balance_30d?: number | null;
    /**
     * The 10th percentile of the end-of-day available balance over the past 60 days of the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p10_eod_balance_60d?: number | null;
    /**
     * The 10th percentile of the end-of-day available balance over the past 90 days of the account that will be debited
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    p10_eod_balance_90d?: number | null;
    /**
     * Available balance, as of the `balance_last_updated` time. The available balance is the current balance less any outstanding holds or debits that have not yet posted to the account.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    available_balance?: number | null;
    /**
     * Current balance, as of the `balance_last_updated` time. The current balance is the total amount of funds in the account.
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    current_balance?: number | null;
    /**
     * Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DDTHH:mm:ssZ) indicating the last time that the balance for the given account has been updated.
     * @type {string}
     * @memberof SignalEvaluateCoreAttributes
     */
    balance_last_updated?: string | null;
    /**
     * The number of times the account\'s phone numbers on file have changed over the past 28 days
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    phone_change_count_28d?: number | null;
    /**
     * The number of times the account\'s phone numbers on file have changed over the past 90 days
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    phone_change_count_90d?: number | null;
    /**
     * The number of times the account\'s email addresses on file have changed over the past 28 days
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    email_change_count_28d?: number | null;
    /**
     * The number of times the account\'s email addresses on file have changed over the past 90 days
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    email_change_count_90d?: number | null;
    /**
     * The number of times the account\'s addresses on file have changed over the past 28 days
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    address_change_count_28d?: number | null;
    /**
     * The number of times the account\'s addresses on file have changed over the past 90 days
     * @type {number}
     * @memberof SignalEvaluateCoreAttributes
     */
    address_change_count_90d?: number | null;
}
/**
 * SignalEvaluateRequest defines the request schema for `/signal/evaluate`
 * @export
 * @interface SignalEvaluateRequest
 */
export interface SignalEvaluateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SignalEvaluateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SignalEvaluateRequest
     */
    secret?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof SignalEvaluateRequest
     */
    access_token: string;
    /**
     * The `account_id` of the account whose verification status is to be modified
     * @type {string}
     * @memberof SignalEvaluateRequest
     */
    account_id: string;
    /**
     * The unique ID that you would like to use to refer to this transaction. For your convenience mapping your internal data, you could use your internal ID/identifier for this transaction. The max length for this field is 36 characters.
     * @type {string}
     * @memberof SignalEvaluateRequest
     */
    client_transaction_id: string;
    /**
     * The transaction amount, in USD (e.g. `102.05`)
     * @type {number}
     * @memberof SignalEvaluateRequest
     */
    amount: number;
    /**
     * `true` if the end user is present while initiating the ACH transfer and the endpoint is being called; `false` otherwise (for example, when the ACH transfer is scheduled and the end user is not present, or you call this endpoint after the ACH transfer but before submitting the Nacha file for ACH processing).
     * @type {boolean}
     * @memberof SignalEvaluateRequest
     */
    user_present?: boolean | null;
    /**
     * A unique ID that identifies the end user in your system. This ID is used to correlate requests by a user with multiple Items. The max length for this field is 36 characters.
     * @type {string}
     * @memberof SignalEvaluateRequest
     */
    client_user_id?: string;
    /**
     *
     * @type {SignalUser}
     * @memberof SignalEvaluateRequest
     */
    user?: SignalUser;
    /**
     *
     * @type {SignalDevice}
     * @memberof SignalEvaluateRequest
     */
    device?: SignalDevice;
}
/**
 * SignalEvaluateResponse defines the response schema for `/signal/income/evaluate`
 * @export
 * @interface SignalEvaluateResponse
 */
export interface SignalEvaluateResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SignalEvaluateResponse
     */
    request_id: string;
    /**
     *
     * @type {SignalScores}
     * @memberof SignalEvaluateResponse
     */
    scores: SignalScores;
    /**
     *
     * @type {SignalEvaluateCoreAttributes}
     * @memberof SignalEvaluateResponse
     */
    core_attributes?: SignalEvaluateCoreAttributes;
}
/**
 * The user\'s legal name
 * @export
 * @interface SignalPersonName
 */
export interface SignalPersonName {
    /**
     * The user\'s name prefix (e.g. \"Mr.\")
     * @type {string}
     * @memberof SignalPersonName
     */
    prefix?: string | null;
    /**
     * The user\'s given name. If the user has a one-word name, it should be provided in this field.
     * @type {string}
     * @memberof SignalPersonName
     */
    given_name?: string | null;
    /**
     * The user\'s middle name
     * @type {string}
     * @memberof SignalPersonName
     */
    middle_name?: string | null;
    /**
     * The user\'s family name / surname
     * @type {string}
     * @memberof SignalPersonName
     */
    family_name?: string | null;
    /**
     * The user\'s name suffix (e.g. \"II\")
     * @type {string}
     * @memberof SignalPersonName
     */
    suffix?: string | null;
}
/**
 * SignalReturnReportRequest defines the request schema for `/signal/return/report`
 * @export
 * @interface SignalReturnReportRequest
 */
export interface SignalReturnReportRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof SignalReturnReportRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof SignalReturnReportRequest
     */
    secret?: string;
    /**
     * Must be the same as the `client_transaction_id` supplied when calling `/signal/evaluate`
     * @type {string}
     * @memberof SignalReturnReportRequest
     */
    client_transaction_id: string;
    /**
     * Must be a valid ACH return code (e.g. \"R01\")
     * @type {string}
     * @memberof SignalReturnReportRequest
     */
    return_code: string;
}
/**
 * SignalReturnReportResponse defines the response schema for `/signal/return/report`
 * @export
 * @interface SignalReturnReportResponse
 */
export interface SignalReturnReportResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof SignalReturnReportResponse
     */
    request_id: string;
}
/**
 * Risk scoring details broken down by risk category.
 * @export
 * @interface SignalScores
 */
export interface SignalScores {
    [key: string]: object | any;
    /**
     *
     * @type {CustomerInitiatedReturnRisk}
     * @memberof SignalScores
     */
    customer_initiated_return_risk?: CustomerInitiatedReturnRisk;
    /**
     *
     * @type {BankInitiatedReturnRisk}
     * @memberof SignalScores
     */
    bank_initiated_return_risk?: BankInitiatedReturnRisk;
}
/**
 * Details about the end user initiating the transaction (i.e., the account holder).
 * @export
 * @interface SignalUser
 */
export interface SignalUser {
    /**
     *
     * @type {SignalPersonName}
     * @memberof SignalUser
     */
    name?: SignalPersonName | null;
    /**
     * The user\'s phone number, in E.164 format: +{countrycode}{number}. For example: \"+14151234567\"
     * @type {string}
     * @memberof SignalUser
     */
    phone_number?: string | null;
    /**
     * The user\'s email address.
     * @type {string}
     * @memberof SignalUser
     */
    email_address?: string | null;
    /**
     *
     * @type {SignalAddressData}
     * @memberof SignalUser
     */
    address?: SignalAddressData | null;
}
/**
 * A sweep returned from the `/sandbox/transfer/sweep/simulate` endpoint. Can be null if there are no transfers to include in a sweep.
 * @export
 * @interface SimulatedTransferSweep
 */
export interface SimulatedTransferSweep {
    /**
     * Identifier of the sweep.
     * @type {string}
     * @memberof SimulatedTransferSweep
     */
    id: string;
    /**
     * The datetime when the sweep occurred, in RFC 3339 format.
     * @type {string}
     * @memberof SimulatedTransferSweep
     */
    created: string;
    /**
     * Signed decimal amount of the sweep as it appears on your sweep account ledger (e.g. \"-10.00\")  If amount is not present, the sweep was net-settled to zero and outstanding debits and credits between the sweep account and Plaid are balanced.
     * @type {string}
     * @memberof SimulatedTransferSweep
     */
    amount: string;
    /**
     * The currency of the sweep, e.g. \"USD\".
     * @type {string}
     * @memberof SimulatedTransferSweep
     */
    iso_currency_code: string;
}
/**
 * The schema below describes the various `types` and corresponding `subtypes` that Plaid recognizes and reports for financial institution accounts.
 * @export
 * @interface StandaloneAccountType
 */
export interface StandaloneAccountType {
    [key: string]: object | any;
    /**
     * An account type holding cash, in which funds are deposited. Supported products for `depository` accounts are: Auth (`checking` and `savings` types only), Balance, Transactions, Identity, Payment Initiation, and Assets.
     * @type {string}
     * @memberof StandaloneAccountType
     */
    depository: string;
    /**
     * A credit card type account. Supported products for `credit` accounts are: Balance, Transactions, Identity, and Liabilities.
     * @type {string}
     * @memberof StandaloneAccountType
     */
    credit: string;
    /**
     * A loan type account. Supported products for `loan` accounts are: Balance, Liabilities, and Transactions.
     * @type {string}
     * @memberof StandaloneAccountType
     */
    loan: string;
    /**
     * An investment account. Supported products for `investment` accounts are: Balance and Investments. In API versions 2018-05-22 and earlier, this type is called `brokerage`.
     * @type {string}
     * @memberof StandaloneAccountType
     */
    investment: string;
    /**
     * Other or unknown account type. Supported products for `other` accounts are: Balance, Transactions, Identity, and Assets.
     * @type {string}
     * @memberof StandaloneAccountType
     */
    other: string;
}
/**
 * The following currency codes are supported by Plaid.
 * @export
 * @interface StandaloneCurrencyCodeList
 */
export interface StandaloneCurrencyCodeList {
    [key: string]: object | any;
    /**
     * Plaid supports all ISO 4217 currency codes.
     * @type {string}
     * @memberof StandaloneCurrencyCodeList
     */
    iso_currency_code: string;
    /**
     * List of unofficial currency codes
     * @type {string}
     * @memberof StandaloneCurrencyCodeList
     */
    unofficial_currency_code: string;
}
/**
 * Valid values for investment transaction types and subtypes. Note that transactions representing inflow of cash will appear as negative amounts, outflow of cash will appear as positive amounts.
 * @export
 * @interface StandaloneInvestmentTransactionType
 */
export interface StandaloneInvestmentTransactionType {
    [key: string]: object | any;
    /**
     * Buying an investment
     * @type {string}
     * @memberof StandaloneInvestmentTransactionType
     */
    buy: string;
    /**
     * Selling an investment
     * @type {string}
     * @memberof StandaloneInvestmentTransactionType
     */
    sell: string;
    /**
     * A cancellation of a pending transaction
     * @type {string}
     * @memberof StandaloneInvestmentTransactionType
     */
    cancel: string;
    /**
     * Activity that modifies a cash position
     * @type {string}
     * @memberof StandaloneInvestmentTransactionType
     */
    cash: string;
    /**
     * Fees on the account, e.g. commission, bookkeeping, options-related.
     * @type {string}
     * @memberof StandaloneInvestmentTransactionType
     */
    fee: string;
    /**
     * Activity that modifies a position, but not through buy/sell activity e.g. options exercise, portfolio transfer
     * @type {string}
     * @memberof StandaloneInvestmentTransactionType
     */
    transfer: string;
}
/**
 * Contains details about a student loan account
 * @export
 * @interface StudentLoan
 */
export interface StudentLoan {
    [key: string]: object | any;
    /**
     * The ID of the account that this liability belongs to.
     * @type {string}
     * @memberof StudentLoan
     */
    account_id: string | null;
    /**
     * The account number of the loan. For some institutions, this may be a masked version of the number (e.g., the last 4 digits instead of the entire number).
     * @type {string}
     * @memberof StudentLoan
     */
    account_number: string | null;
    /**
     * The dates on which loaned funds were disbursed or will be disbursed. These are often in the past. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {Array<string>}
     * @memberof StudentLoan
     */
    disbursement_dates: Array<string> | null;
    /**
     * The date when the student loan is expected to be paid off. Availability for this field is limited. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof StudentLoan
     */
    expected_payoff_date: string | null;
    /**
     * The guarantor of the student loan.
     * @type {string}
     * @memberof StudentLoan
     */
    guarantor: string | null;
    /**
     * The interest rate on the loan as a percentage.
     * @type {number}
     * @memberof StudentLoan
     */
    interest_rate_percentage: number;
    /**
     * `true` if a payment is currently overdue. Availability for this field is limited.
     * @type {boolean}
     * @memberof StudentLoan
     */
    is_overdue: boolean | null;
    /**
     * The amount of the last payment.
     * @type {number}
     * @memberof StudentLoan
     */
    last_payment_amount: number | null;
    /**
     * The date of the last payment. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof StudentLoan
     */
    last_payment_date: string | null;
    /**
     * The date of the last statement. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof StudentLoan
     */
    last_statement_issue_date: string | null;
    /**
     * The type of loan, e.g., \"Consolidation Loans\".
     * @type {string}
     * @memberof StudentLoan
     */
    loan_name: string | null;
    /**
     *
     * @type {StudentLoanStatus}
     * @memberof StudentLoan
     */
    loan_status: StudentLoanStatus;
    /**
     * The minimum payment due for the next billing cycle. There are some exceptions: Some institutions require a minimum payment across all loans associated with an account number. Our API presents that same minimum payment amount on each loan. The institutions that do this are: Great Lakes ( `ins_116861`), Firstmark (`ins_116295`), Commonbond Firstmark Services (`ins_116950`), Nelnet (`ins_116528`), EdFinancial Services (`ins_116304`), Granite State (`ins_116308`), and Oklahoma Student Loan Authority (`ins_116945`). Firstmark (`ins_116295` ) and Navient (`ins_116248`) will display as $0 if there is an autopay program in effect.
     * @type {number}
     * @memberof StudentLoan
     */
    minimum_payment_amount: number | null;
    /**
     * The due date for the next payment. The due date is `null` if a payment is not expected. A payment is not expected if `loan_status.type` is `deferment`, `in_school`, `consolidated`, `paid in full`, or `transferred`. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof StudentLoan
     */
    next_payment_due_date: string | null;
    /**
     * The date on which the loan was initially lent. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof StudentLoan
     */
    origination_date: string | null;
    /**
     * The original principal balance of the loan.
     * @type {number}
     * @memberof StudentLoan
     */
    origination_principal_amount: number | null;
    /**
     * The total dollar amount of the accrued interest balance. For Sallie Mae ( `ins_116944`), this amount is included in the current balance of the loan, so this field will return as `null`.
     * @type {number}
     * @memberof StudentLoan
     */
    outstanding_interest_amount: number | null;
    /**
     * The relevant account number that should be used to reference this loan for payments. In the majority of cases, `payment_reference_number` will match a`ccount_number,` but in some institutions, such as Great Lakes (`ins_116861`), it will be different.
     * @type {string}
     * @memberof StudentLoan
     */
    payment_reference_number: string | null;
    /**
     *
     * @type {PSLFStatus}
     * @memberof StudentLoan
     */
    pslf_status: PSLFStatus;
    /**
     *
     * @type {StudentRepaymentPlan}
     * @memberof StudentLoan
     */
    repayment_plan: StudentRepaymentPlan;
    /**
     * The sequence number of the student loan. Heartland ECSI (`ins_116948`) does not make this field available.
     * @type {string}
     * @memberof StudentLoan
     */
    sequence_number: string | null;
    /**
     *
     * @type {ServicerAddressData}
     * @memberof StudentLoan
     */
    servicer_address: ServicerAddressData;
    /**
     * The year to date (YTD) interest paid. Availability for this field is limited.
     * @type {number}
     * @memberof StudentLoan
     */
    ytd_interest_paid: number | null;
    /**
     * The year to date (YTD) principal paid. Availability for this field is limited.
     * @type {number}
     * @memberof StudentLoan
     */
    ytd_principal_paid: number | null;
}
/**
 * Student loan repayment information used to configure Sandbox test data for the Liabilities product
 * @export
 * @interface StudentLoanRepaymentModel
 */
export interface StudentLoanRepaymentModel {
    [key: string]: object | any;
    /**
     * The only currently supported value for this field is `standard`.
     * @type {string}
     * @memberof StudentLoanRepaymentModel
     */
    type: string;
    /**
     * Configures the number of months before repayment starts.
     * @type {number}
     * @memberof StudentLoanRepaymentModel
     */
    non_repayment_months: number;
    /**
     * Configures the number of months of repayments before the loan is paid off.
     * @type {number}
     * @memberof StudentLoanRepaymentModel
     */
    repayment_months: number;
}
/**
 * An object representing the status of the student loan
 * @export
 * @interface StudentLoanStatus
 */
export interface StudentLoanStatus {
    [key: string]: object | any;
    /**
     * The date until which the loan will be in its current status. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).
     * @type {string}
     * @memberof StudentLoanStatus
     */
    end_date: string | null;
    /**
     * The status type of the student loan
     * @type {string}
     * @memberof StudentLoanStatus
     */
    type: StudentLoanStatusTypeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum StudentLoanStatusTypeEnum {
    Cancelled = "cancelled",
    ChargedOff = "charged off",
    Claim = "claim",
    Consolidated = "consolidated",
    Deferment = "deferment",
    Delinquent = "delinquent",
    Discharged = "discharged",
    Extension = "extension",
    Forbearance = "forbearance",
    InGrace = "in grace",
    InMilitary = "in military",
    InSchool = "in school",
    NotFullyDisbursed = "not fully disbursed",
    Other = "other",
    PaidInFull = "paid in full",
    Refunded = "refunded",
    Repayment = "repayment",
    Transferred = "transferred"
}
/**
 * An object representing the repayment plan for the student loan
 * @export
 * @interface StudentRepaymentPlan
 */
export interface StudentRepaymentPlan {
    [key: string]: object | any;
    /**
     * The description of the repayment plan as provided by the servicer.
     * @type {string}
     * @memberof StudentRepaymentPlan
     */
    description: string | null;
    /**
     * The type of the repayment plan.
     * @type {string}
     * @memberof StudentRepaymentPlan
     */
    type: StudentRepaymentPlanTypeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum StudentRepaymentPlanTypeEnum {
    ExtendedGraduated = "extended graduated",
    ExtendedStandard = "extended standard",
    Graduated = "graduated",
    IncomeContingentRepayment = "income-contingent repayment",
    IncomeBasedRepayment = "income-based repayment",
    InterestOnly = "interest-only",
    Other = "other",
    PayAsYouEarn = "pay as you earn",
    RevisedPayAsYouEarn = "revised pay as you earn",
    Standard = "standard",
    Null = "null"
}
/**
 * Data about an official document used to report the user\'s income to the IRS.
 * @export
 * @interface Taxform
 */
export interface Taxform {
    [key: string]: object | any;
    /**
     * An identifier of the document referenced by the document metadata.
     * @type {string}
     * @memberof Taxform
     */
    doc_id?: string;
    /**
     * The type of tax document. Currently, the only supported value is `w2`.
     * @type {string}
     * @memberof Taxform
     */
    document_type: string;
    /**
     *
     * @type {W2}
     * @memberof Taxform
     */
    w2?: W2;
}
/**
 * Taxpayer ID of the individual receiving the paystub.
 * @export
 * @interface TaxpayerID
 */
export interface TaxpayerID {
    [key: string]: object | any;
    /**
     * Type of ID, e.g. \'SSN\'
     * @type {string}
     * @memberof TaxpayerID
     */
    id_type?: string | null;
    /**
     * ID mask; i.e. last 4 digits of the taxpayer ID
     * @type {string}
     * @memberof TaxpayerID
     */
    id_mask?: string | null;
    /**
     * Last 4 digits of unique number of ID.
     * @type {string}
     * @memberof TaxpayerID
     * @deprecated
     */
    last_4_digits?: string | null;
}
/**
 * An object representing both the current pay period and year to date amount for a category.
 * @export
 * @interface Total
 */
export interface Total {
    [key: string]: object | any;
    /**
     *
     * @type {TotalCanonicalDescription}
     * @memberof Total
     */
    canonical_description?: TotalCanonicalDescription | null;
    /**
     * Text of the line item as printed on the paystub.
     * @type {string}
     * @memberof Total
     */
    description?: string | null;
    /**
     *
     * @type {Pay}
     * @memberof Total
     * @deprecated
     */
    current_pay?: Pay;
    /**
     *
     * @type {Pay}
     * @memberof Total
     * @deprecated
     */
    ytd_pay?: Pay;
}
/**
 * Commonly used term to describe the line item.
 * @export
 * @enum {string}
 */
export declare enum TotalCanonicalDescription {
    Bonus = "BONUS",
    Commission = "COMMISSION",
    Overtime = "OVERTIME",
    PaidTimeOff = "PAID TIME OFF",
    RegularPay = "REGULAR PAY",
    Vacation = "VACATION",
    EmployeeMedicare = "EMPLOYEE MEDICARE",
    Fica = "FICA",
    SocialSecurityEmployeeTax = "SOCIAL SECURITY EMPLOYEE TAX",
    Medical = "MEDICAL",
    Vision = "VISION",
    Dental = "DENTAL",
    NetPay = "NET PAY",
    Taxes = "TAXES",
    NotFound = "NOT_FOUND",
    Other = "OTHER",
    Null = "null"
}
/**
 * A representation of a transaction
 * @export
 * @interface Transaction
 */
export interface Transaction {
    /**
     * Please use the `payment_channel` field, `transaction_type` will be deprecated in the future.  `digital:` transactions that took place online.  `place:` transactions that were made at a physical location.  `special:` transactions that relate to banks, e.g. fees or deposits.  `unresolved:` transactions that do not fit into the other three types.
     * @type {string}
     * @memberof Transaction
     * @deprecated
     */
    transaction_type?: TransactionTransactionTypeEnum;
    /**
     * The ID of a posted transaction\'s associated pending transaction, where applicable.
     * @type {string}
     * @memberof Transaction
     */
    pending_transaction_id: string | null;
    /**
     * The ID of the category to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/#categoriesget).  If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {string}
     * @memberof Transaction
     */
    category_id: string | null;
    /**
     * A hierarchical array of the categories to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/#categoriesget).  If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {Array<string>}
     * @memberof Transaction
     */
    category: Array<string> | null;
    /**
     *
     * @type {Location}
     * @memberof Transaction
     */
    location: Location;
    /**
     *
     * @type {PaymentMeta}
     * @memberof Transaction
     */
    payment_meta: PaymentMeta;
    /**
     * The name of the account owner. This field is not typically populated and only relevant when dealing with sub-accounts.
     * @type {string}
     * @memberof Transaction
     */
    account_owner: string | null;
    /**
     * The merchant name or transaction description.  If the `transactions` object was returned by a Transactions endpoint such as `/transactions/get`, this field will always appear. If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {string}
     * @memberof Transaction
     */
    name: string;
    /**
     * The string returned by the financial institution to describe the transaction. For transactions returned by `/transactions/get`, this field is in beta and will be omitted unless the client is both enrolled in the closed beta program and has set `options.include_original_description` to `true`.
     * @type {string}
     * @memberof Transaction
     */
    original_description?: string | null;
    /**
     * The ID of the account in which this transaction occurred.
     * @type {string}
     * @memberof Transaction
     */
    account_id: string;
    /**
     * The settled value of the transaction, denominated in the account\'s currency, as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.
     * @type {number}
     * @memberof Transaction
     */
    amount: number;
    /**
     * The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof Transaction
     */
    iso_currency_code: string | null;
    /**
     * The unofficial currency code associated with the transaction. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof Transaction
     */
    unofficial_currency_code: string | null;
    /**
     * For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ).
     * @type {string}
     * @memberof Transaction
     */
    date: string;
    /**
     * When `true`, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.
     * @type {boolean}
     * @memberof Transaction
     */
    pending: boolean;
    /**
     * The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.
     * @type {string}
     * @memberof Transaction
     */
    transaction_id: string;
    /**
     * The merchant name, as extracted by Plaid from the `name` field.
     * @type {string}
     * @memberof Transaction
     */
    merchant_name?: string | null;
    /**
     * The check number of the transaction. This field is only populated for check transactions.
     * @type {string}
     * @memberof Transaction
     */
    check_number?: string | null;
    /**
     * The channel used to make a payment. `online:` transactions that took place online.  `in store:` transactions that were made at a physical location.  `other:` transactions that relate to banks, e.g. fees or deposits.  This field replaces the `transaction_type` field.
     * @type {string}
     * @memberof Transaction
     */
    payment_channel: TransactionPaymentChannelEnum;
    /**
     * The date that the transaction was authorized. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ). The `authorized_date` field uses machine learning to determine a transaction date for transactions where the `date_transacted` is not available. If the `date_transacted` field is present and not `null`, the `authorized_date` field will have the same value as the `date_transacted` field.
     * @type {string}
     * @memberof Transaction
     */
    authorized_date: string | null;
    /**
     * Date and time when a transaction was authorized in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DDTHH:mm:ssZ` ).  This field is returned for select financial institutions and comes as provided by the institution. It may contain default time values (such as 00:00:00).
     * @type {string}
     * @memberof Transaction
     */
    authorized_datetime: string | null;
    /**
     * Date and time when a transaction was posted in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DDTHH:mm:ssZ` ).  This field is returned for select financial institutions and comes as provided by the institution. It may contain default time values (such as 00:00:00).
     * @type {string}
     * @memberof Transaction
     */
    datetime: string | null;
    /**
     *
     * @type {TransactionCode}
     * @memberof Transaction
     */
    transaction_code: TransactionCode | null;
    /**
     *
     * @type {PersonalFinanceCategory & any}
     * @memberof Transaction
     */
    personal_finance_category?: PersonalFinanceCategory & any | null;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransactionTransactionTypeEnum {
    Digital = "digital",
    Place = "place",
    Special = "special",
    Unresolved = "unresolved"
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransactionPaymentChannelEnum {
    Online = "online",
    InStore = "in store",
    Other = "other"
}
/**
 *
 * @export
 * @interface TransactionAllOf
 */
export interface TransactionAllOf {
    /**
     * The channel used to make a payment. `online:` transactions that took place online.  `in store:` transactions that were made at a physical location.  `other:` transactions that relate to banks, e.g. fees or deposits.  This field replaces the `transaction_type` field.
     * @type {string}
     * @memberof TransactionAllOf
     */
    payment_channel: TransactionAllOfPaymentChannelEnum;
    /**
     * The date that the transaction was authorized. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ). The `authorized_date` field uses machine learning to determine a transaction date for transactions where the `date_transacted` is not available. If the `date_transacted` field is present and not `null`, the `authorized_date` field will have the same value as the `date_transacted` field.
     * @type {string}
     * @memberof TransactionAllOf
     */
    authorized_date: string | null;
    /**
     * Date and time when a transaction was authorized in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DDTHH:mm:ssZ` ).  This field is returned for select financial institutions and comes as provided by the institution. It may contain default time values (such as 00:00:00).
     * @type {string}
     * @memberof TransactionAllOf
     */
    authorized_datetime: string | null;
    /**
     * Date and time when a transaction was posted in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DDTHH:mm:ssZ` ).  This field is returned for select financial institutions and comes as provided by the institution. It may contain default time values (such as 00:00:00).
     * @type {string}
     * @memberof TransactionAllOf
     */
    datetime: string | null;
    /**
     *
     * @type {TransactionCode}
     * @memberof TransactionAllOf
     */
    transaction_code: TransactionCode | null;
    /**
     *
     * @type {PersonalFinanceCategory & any}
     * @memberof TransactionAllOf
     */
    personal_finance_category?: PersonalFinanceCategory & any | null;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransactionAllOfPaymentChannelEnum {
    Online = "online",
    InStore = "in store",
    Other = "other"
}
/**
 * A representation of a transaction
 * @export
 * @interface TransactionBase
 */
export interface TransactionBase {
    [key: string]: object | any;
    /**
     * Please use the `payment_channel` field, `transaction_type` will be deprecated in the future.  `digital:` transactions that took place online.  `place:` transactions that were made at a physical location.  `special:` transactions that relate to banks, e.g. fees or deposits.  `unresolved:` transactions that do not fit into the other three types.
     * @type {string}
     * @memberof TransactionBase
     * @deprecated
     */
    transaction_type?: TransactionBaseTransactionTypeEnum;
    /**
     * The ID of a posted transaction\'s associated pending transaction, where applicable.
     * @type {string}
     * @memberof TransactionBase
     */
    pending_transaction_id?: string | null;
    /**
     * The ID of the category to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/#categoriesget).  If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {string}
     * @memberof TransactionBase
     */
    category_id?: string | null;
    /**
     * A hierarchical array of the categories to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/#categoriesget).  If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {Array<string>}
     * @memberof TransactionBase
     */
    category?: Array<string> | null;
    /**
     *
     * @type {Location}
     * @memberof TransactionBase
     */
    location?: Location;
    /**
     *
     * @type {PaymentMeta}
     * @memberof TransactionBase
     */
    payment_meta?: PaymentMeta;
    /**
     * The name of the account owner. This field is not typically populated and only relevant when dealing with sub-accounts.
     * @type {string}
     * @memberof TransactionBase
     */
    account_owner?: string | null;
    /**
     * The merchant name or transaction description.  If the `transactions` object was returned by a Transactions endpoint such as `/transactions/get`, this field will always appear. If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.
     * @type {string}
     * @memberof TransactionBase
     */
    name?: string;
    /**
     * The string returned by the financial institution to describe the transaction. For transactions returned by `/transactions/get`, this field is in beta and will be omitted unless the client is both enrolled in the closed beta program and has set `options.include_original_description` to `true`.
     * @type {string}
     * @memberof TransactionBase
     */
    original_description?: string | null;
    /**
     * The ID of the account in which this transaction occurred.
     * @type {string}
     * @memberof TransactionBase
     */
    account_id: string;
    /**
     * The settled value of the transaction, denominated in the account\'s currency, as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.
     * @type {number}
     * @memberof TransactionBase
     */
    amount: number;
    /**
     * The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-null.
     * @type {string}
     * @memberof TransactionBase
     */
    iso_currency_code: string | null;
    /**
     * The unofficial currency code associated with the transaction. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof TransactionBase
     */
    unofficial_currency_code: string | null;
    /**
     * For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ).
     * @type {string}
     * @memberof TransactionBase
     */
    date: string;
    /**
     * When `true`, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.
     * @type {boolean}
     * @memberof TransactionBase
     */
    pending: boolean;
    /**
     * The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.
     * @type {string}
     * @memberof TransactionBase
     */
    transaction_id: string;
    /**
     * The merchant name, as extracted by Plaid from the `name` field.
     * @type {string}
     * @memberof TransactionBase
     */
    merchant_name?: string | null;
    /**
     * The check number of the transaction. This field is only populated for check transactions.
     * @type {string}
     * @memberof TransactionBase
     */
    check_number?: string | null;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransactionBaseTransactionTypeEnum {
    Digital = "digital",
    Place = "place",
    Special = "special",
    Unresolved = "unresolved"
}
/**
 * An identifier classifying the transaction type.  This field is only populated for European institutions. For institutions in the US and Canada, this field is set to `null`.  `adjustment:` Bank adjustment  `atm:` Cash deposit or withdrawal via an automated teller machine  `bank charge:` Charge or fee levied by the institution  `bill payment`: Payment of a bill  `cash:` Cash deposit or withdrawal  `cashback:` Cash withdrawal while making a debit card purchase  `cheque:` Document ordering the payment of money to another person or organization  `direct debit:` Automatic withdrawal of funds initiated by a third party at a regular interval  `interest:` Interest earned or incurred  `purchase:` Purchase made with a debit or credit card  `standing order:` Payment instructed by the account holder to a third party at a regular interval  `transfer:` Transfer of money between accounts
 * @export
 * @enum {string}
 */
export declare enum TransactionCode {
    Adjustment = "adjustment",
    Atm = "atm",
    BankCharge = "bank charge",
    BillPayment = "bill payment",
    Cash = "cash",
    Cashback = "cashback",
    Cheque = "cheque",
    DirectDebit = "direct debit",
    Interest = "interest",
    Purchase = "purchase",
    StandingOrder = "standing order",
    Transfer = "transfer",
    Null = "null"
}
/**
 * Information about the matched direct deposit transaction used to verify a user\'s payroll information.
 * @export
 * @interface TransactionData
 */
export interface TransactionData {
    [key: string]: object | any;
    /**
     * The description of the transaction.
     * @type {string}
     * @memberof TransactionData
     */
    description: string;
    /**
     * The amount of the transaction.
     * @type {number}
     * @memberof TransactionData
     */
    amount: number;
    /**
     * The date of the transaction, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (\"yyyy-mm-dd\").
     * @type {string}
     * @memberof TransactionData
     */
    date: string;
    /**
     * A unique identifier for the end user\'s account.
     * @type {string}
     * @memberof TransactionData
     */
    account_id: string;
    /**
     * A unique identifier for the transaction.
     * @type {string}
     * @memberof TransactionData
     */
    transaction_id: string;
}
/**
 * Data to populate as test transaction data. If not specified, random transactions will be generated instead.
 * @export
 * @interface TransactionOverride
 */
export interface TransactionOverride {
    [key: string]: object | any;
    /**
     * The date of the transaction, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format. Transactions in Sandbox will move from pending to posted once their transaction date has been reached. If a `date_transacted` is not provided by the institution, a transaction date may be available in the [`authorized_date`](https://plaid.com/docs/api/products/#transactions-get-response-transactions-authorized-date) field.
     * @type {string}
     * @memberof TransactionOverride
     */
    date_transacted: string;
    /**
     * The date the transaction posted, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format. Posted dates in the past or present will result in posted transactions; posted dates in the future will result in pending transactions.
     * @type {string}
     * @memberof TransactionOverride
     */
    date_posted: string;
    /**
     * The transaction amount. Can be negative.
     * @type {number}
     * @memberof TransactionOverride
     */
    amount: number;
    /**
     * The transaction description.
     * @type {string}
     * @memberof TransactionOverride
     */
    description: string;
    /**
     * The ISO-4217 format currency code for the transaction.
     * @type {string}
     * @memberof TransactionOverride
     */
    currency?: string;
}
/**
 * A grouping of related transactions
 * @export
 * @interface TransactionStream
 */
export interface TransactionStream {
    [key: string]: object | any;
    /**
     * The ID of the account to which the stream belongs
     * @type {string}
     * @memberof TransactionStream
     */
    account_id: string;
    /**
     * A unique id for the stream
     * @type {string}
     * @memberof TransactionStream
     */
    stream_id: string;
    /**
     * The ID of the category to which this transaction belongs. See [Categories](https://plaid.com/docs/#category-overview).
     * @type {string}
     * @memberof TransactionStream
     */
    category_id: string;
    /**
     * A hierarchical array of the categories to which this transaction belongs. See [Categories](https://plaid.com/docs/#category-overview).
     * @type {Array<string>}
     * @memberof TransactionStream
     */
    category: Array<string>;
    /**
     * A description of the transaction stream.
     * @type {string}
     * @memberof TransactionStream
     */
    description: string;
    /**
     * The posted date of the earliest transaction in the stream.
     * @type {string}
     * @memberof TransactionStream
     */
    first_date: string;
    /**
     * The posted date of the latest transaction in the stream.
     * @type {string}
     * @memberof TransactionStream
     */
    last_date: string;
    /**
     *
     * @type {RecurringTransactionFrequency}
     * @memberof TransactionStream
     */
    frequency: RecurringTransactionFrequency;
    /**
     * An array of Plaid transaction IDs belonging to the stream, sorted by posted date.
     * @type {Array<string>}
     * @memberof TransactionStream
     */
    transaction_ids: Array<string>;
    /**
     *
     * @type {TransactionStreamAmount}
     * @memberof TransactionStream
     */
    average_amount: TransactionStreamAmount;
    /**
     * indicates whether the transaction stream is still live.
     * @type {boolean}
     * @memberof TransactionStream
     */
    is_active: boolean;
}
/**
 * Object with data pertaining to an amount on the transaction stream.
 * @export
 * @interface TransactionStreamAmount
 */
export interface TransactionStreamAmount {
    [key: string]: object | any;
    /**
     * represents the numerical value of an amount.
     * @type {number}
     * @memberof TransactionStreamAmount
     */
    amount?: number;
    /**
     * The ISO-4217 currency code of the amount. Always `null` if `unofficial_currency_code` is non-`null`.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.
     * @type {string}
     * @memberof TransactionStreamAmount
     */
    iso_currency_code?: string | null;
    /**
     * The unofficial currency code of the amount. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.
     * @type {string}
     * @memberof TransactionStreamAmount
     */
    unofficial_currency_code?: string | null;
}
/**
 * TransactionsGetRequest defines the request schema for `/transactions/get`
 * @export
 * @interface TransactionsGetRequest
 */
export interface TransactionsGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransactionsGetRequest
     */
    client_id?: string;
    /**
     *
     * @type {TransactionsGetRequestOptions}
     * @memberof TransactionsGetRequest
     */
    options?: TransactionsGetRequestOptions;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof TransactionsGetRequest
     */
    access_token: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransactionsGetRequest
     */
    secret?: string;
    /**
     * The earliest date for which data should be returned. Dates should be formatted as YYYY-MM-DD.
     * @type {string}
     * @memberof TransactionsGetRequest
     */
    start_date: string;
    /**
     * The latest date for which data should be returned. Dates should be formatted as YYYY-MM-DD.
     * @type {string}
     * @memberof TransactionsGetRequest
     */
    end_date: string;
}
/**
 * An optional object to be used with the request. If specified, `options` must not be `null`.
 * @export
 * @interface TransactionsGetRequestOptions
 */
export interface TransactionsGetRequestOptions {
    /**
     * A list of `account_ids` to retrieve for the Item  Note: An error will be returned if a provided `account_id` is not associated with the Item.
     * @type {Array<string>}
     * @memberof TransactionsGetRequestOptions
     */
    account_ids?: Array<string>;
    /**
     * The number of transactions to fetch.
     * @type {number}
     * @memberof TransactionsGetRequestOptions
     */
    count?: number;
    /**
     * The number of transactions to skip. The default value is 0.
     * @type {number}
     * @memberof TransactionsGetRequestOptions
     */
    offset?: number;
    /**
     * Include the raw unparsed transaction description from the financial institution. This field is disabled by default. If you need this information in addition to the parsed data provided, contact your Plaid Account Manager.
     * @type {boolean}
     * @memberof TransactionsGetRequestOptions
     */
    include_original_description?: boolean | null;
    /**
     * Include the `personal_finance_category` object in the response. This feature is currently in beta – to request access, contact transactions-feedback@plaid.com.
     * @type {boolean}
     * @memberof TransactionsGetRequestOptions
     */
    include_personal_finance_category_beta?: boolean;
}
/**
 * TransactionsGetResponse defines the response schema for `/transactions/get`
 * @export
 * @interface TransactionsGetResponse
 */
export interface TransactionsGetResponse {
    [key: string]: object | any;
    /**
     * An array containing the `accounts` associated with the Item for which transactions are being returned. Each transaction can be mapped to its corresponding account via the `account_id` field.
     * @type {Array<AccountBase>}
     * @memberof TransactionsGetResponse
     */
    accounts: Array<AccountBase>;
    /**
     * An array containing transactions from the account. Transactions are returned in reverse chronological order, with the most recent at the beginning of the array. The maximum number of transactions returned is determined by the `count` parameter.
     * @type {Array<Transaction>}
     * @memberof TransactionsGetResponse
     */
    transactions: Array<Transaction>;
    /**
     * The total number of transactions available within the date range specified. If `total_transactions` is larger than the size of the `transactions` array, more transactions are available and can be fetched via manipulating the `offset` parameter.
     * @type {number}
     * @memberof TransactionsGetResponse
     */
    total_transactions: number;
    /**
     *
     * @type {Item}
     * @memberof TransactionsGetResponse
     */
    item: Item;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransactionsGetResponse
     */
    request_id: string;
}
/**
 * TransactionsRecurringGetRequest defines the request schema for `/transactions/recurring/get`
 * @export
 * @interface TransactionsRecurringGetRequest
 */
export interface TransactionsRecurringGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransactionsRecurringGetRequest
     */
    client_id?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof TransactionsRecurringGetRequest
     */
    access_token: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransactionsRecurringGetRequest
     */
    secret?: string;
    /**
     * A list of `account_ids` to retrieve for the Item  Note: An error will be returned if a provided `account_id` is not associated with the Item.
     * @type {Array<string>}
     * @memberof TransactionsRecurringGetRequest
     */
    account_ids: Array<string>;
}
/**
 * TransactionsRecurringGetResponse defines the response schema for `/transactions/recurring/get`
 * @export
 * @interface TransactionsRecurringGetResponse
 */
export interface TransactionsRecurringGetResponse {
    [key: string]: object | any;
    /**
     * An array of depository transaction streams.
     * @type {Array<TransactionStream>}
     * @memberof TransactionsRecurringGetResponse
     */
    inflow_streams: Array<TransactionStream>;
    /**
     * An array of expense transaction streams.
     * @type {Array<TransactionStream>}
     * @memberof TransactionsRecurringGetResponse
     */
    outflow_streams: Array<TransactionStream>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransactionsRecurringGetResponse
     */
    request_id: string;
}
/**
 * TransactionsRefreshRequest defines the request schema for `/transactions/refresh`
 * @export
 * @interface TransactionsRefreshRequest
 */
export interface TransactionsRefreshRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransactionsRefreshRequest
     */
    client_id?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof TransactionsRefreshRequest
     */
    access_token: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransactionsRefreshRequest
     */
    secret?: string;
}
/**
 * TransactionsRefreshResponse defines the response schema for `/transactions/refresh`
 * @export
 * @interface TransactionsRefreshResponse
 */
export interface TransactionsRefreshResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransactionsRefreshResponse
     */
    request_id: string;
}
/**
 * Fired when transaction(s) for an Item are deleted. The deleted transaction IDs are included in the webhook payload. Plaid will typically check for deleted transaction data several times a day.
 * @export
 * @interface TransactionsRemovedWebhook
 */
export interface TransactionsRemovedWebhook {
    [key: string]: object | any;
    /**
     * `TRANSACTIONS`
     * @type {string}
     * @memberof TransactionsRemovedWebhook
     */
    webhook_type: string;
    /**
     * `TRANSACTIONS_REMOVED`
     * @type {string}
     * @memberof TransactionsRemovedWebhook
     */
    webhook_code: string;
    /**
     *
     * @type {PlaidError}
     * @memberof TransactionsRemovedWebhook
     */
    error?: PlaidError;
    /**
     * An array of `transaction_ids` corresponding to the removed transactions
     * @type {Array<string>}
     * @memberof TransactionsRemovedWebhook
     */
    removed_transactions: Array<string>;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof TransactionsRemovedWebhook
     */
    item_id: string;
}
/**
 * TransactionsSyncRequest defines the request schema for `/transactions/sync`
 * @export
 * @interface TransactionsSyncRequest
 */
export interface TransactionsSyncRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransactionsSyncRequest
     */
    client_id?: string;
    /**
     * The access token associated with the Item data is being requested for.
     * @type {string}
     * @memberof TransactionsSyncRequest
     */
    access_token: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransactionsSyncRequest
     */
    secret?: string;
    /**
     * The cursor value represents the last update requested. Providing it will cause the response to only return changes after this update. If omitted, the entire history of updates will be returned, starting with the first-added transactions on the item. Note: The upper-bound length of this cursor is 256 characters of base64.
     * @type {string}
     * @memberof TransactionsSyncRequest
     */
    cursor?: string;
    /**
     * The number of transaction updates to fetch.
     * @type {number}
     * @memberof TransactionsSyncRequest
     */
    count?: number;
}
/**
 * TransactionsSyncResponse defines the response schema for `/transactions/sync`
 * @export
 * @interface TransactionsSyncResponse
 */
export interface TransactionsSyncResponse {
    [key: string]: object | any;
    /**
     * Transactions that have been added to the item since `cursor` ordered by ascending last modified time.
     * @type {Array<Transaction>}
     * @memberof TransactionsSyncResponse
     */
    added: Array<Transaction>;
    /**
     * Transactions that have been modified on the item since `cursor` ordered by ascending last modified time.
     * @type {Array<Transaction>}
     * @memberof TransactionsSyncResponse
     */
    modified: Array<Transaction>;
    /**
     * Transactions that have been removed from the item since `cursor` ordered by ascending last modified time.
     * @type {Array<RemovedTransaction>}
     * @memberof TransactionsSyncResponse
     */
    removed: Array<RemovedTransaction>;
    /**
     * Cursor used for fetching any future updates after the latest update provided in this response.
     * @type {string}
     * @memberof TransactionsSyncResponse
     */
    next_cursor: string;
    /**
     * Represents if more than requested count of transaction updates exist. If true, the additional updates can be fetched by making an additional request with `cursor` set to `next_cursor`.
     * @type {boolean}
     * @memberof TransactionsSyncResponse
     */
    has_more: boolean;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransactionsSyncResponse
     */
    request_id: string;
}
/**
 * Represents a transfer within the Transfers API.
 * @export
 * @interface Transfer
 */
export interface Transfer {
    [key: string]: object | any;
    /**
     * Plaid’s unique identifier for a transfer.
     * @type {string}
     * @memberof Transfer
     */
    id: string;
    /**
     *
     * @type {ACHClass}
     * @memberof Transfer
     */
    ach_class: ACHClass;
    /**
     * The account ID that should be credited/debited for this transfer.
     * @type {string}
     * @memberof Transfer
     */
    account_id: string;
    /**
     *
     * @type {TransferType}
     * @memberof Transfer
     */
    type: TransferType;
    /**
     *
     * @type {TransferUserInResponse}
     * @memberof Transfer
     */
    user: TransferUserInResponse;
    /**
     * The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof Transfer
     */
    amount: string;
    /**
     * The description of the transfer.
     * @type {string}
     * @memberof Transfer
     */
    description: string;
    /**
     * The datetime when this transfer was created. This will be of the form `2006-01-02T15:04:05Z`
     * @type {string}
     * @memberof Transfer
     */
    created: string;
    /**
     *
     * @type {TransferStatus}
     * @memberof Transfer
     */
    status: TransferStatus;
    /**
     *
     * @type {TransferSweepStatus}
     * @memberof Transfer
     */
    sweep_status?: TransferSweepStatus | null;
    /**
     *
     * @type {TransferNetwork}
     * @memberof Transfer
     */
    network: TransferNetwork;
    /**
     * When `true`, you can still cancel this transfer.
     * @type {boolean}
     * @memberof Transfer
     */
    cancellable: boolean;
    /**
     *
     * @type {TransferFailure}
     * @memberof Transfer
     */
    failure_reason: TransferFailure | null;
    /**
     * The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters
     * @type {{ [key: string]: string; }}
     * @memberof Transfer
     */
    metadata: {
        [key: string]: string;
    } | null;
    /**
     * Plaid’s unique identifier for the origination account that was used for this transfer.
     * @type {string}
     * @memberof Transfer
     */
    origination_account_id: string;
    /**
     *
     * @type {TransferAuthorizationGuaranteeDecision}
     * @memberof Transfer
     */
    guarantee_decision: TransferAuthorizationGuaranteeDecision | null;
    /**
     *
     * @type {TransferAuthorizationGuaranteeDecisionRationale}
     * @memberof Transfer
     */
    guarantee_decision_rationale: TransferAuthorizationGuaranteeDecisionRationale | null;
    /**
     * The currency of the transfer amount, e.g. \"USD\"
     * @type {string}
     * @memberof Transfer
     */
    iso_currency_code: string;
}
/**
 * Contains the authorization decision for a proposed transfer
 * @export
 * @interface TransferAuthorization
 */
export interface TransferAuthorization {
    [key: string]: object | any;
    /**
     * Plaid’s unique identifier for a transfer authorization.
     * @type {string}
     * @memberof TransferAuthorization
     */
    id: string;
    /**
     * The datetime representing when the authorization was created, in the format `2006-01-02T15:04:05Z`.
     * @type {string}
     * @memberof TransferAuthorization
     */
    created: string;
    /**
     *  A decision regarding the proposed transfer.  `approved` – The proposed transfer has received the end user\'s consent and has been approved for processing. Plaid has also reviewed the proposed transfer and has approved it for processing.   `permitted` – Plaid was unable to fetch the information required to approve or decline the proposed transfer. You may proceed with the transfer, but further review is recommended. Plaid is awaiting further instructions from the client.  `declined` – Plaid reviewed the proposed transfer and declined processing. Refer to the `code` field in the `decision_rationale` object for details.
     * @type {string}
     * @memberof TransferAuthorization
     */
    decision: TransferAuthorizationDecisionEnum;
    /**
     *
     * @type {TransferAuthorizationDecisionRationale}
     * @memberof TransferAuthorization
     */
    decision_rationale: TransferAuthorizationDecisionRationale | null;
    /**
     *
     * @type {TransferAuthorizationGuaranteeDecision}
     * @memberof TransferAuthorization
     */
    guarantee_decision: TransferAuthorizationGuaranteeDecision | null;
    /**
     *
     * @type {TransferAuthorizationGuaranteeDecisionRationale}
     * @memberof TransferAuthorization
     */
    guarantee_decision_rationale: TransferAuthorizationGuaranteeDecisionRationale | null;
    /**
     *
     * @type {TransferAuthorizationProposedTransfer}
     * @memberof TransferAuthorization
     */
    proposed_transfer: TransferAuthorizationProposedTransfer;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransferAuthorizationDecisionEnum {
    Approved = "approved",
    Permitted = "permitted",
    Declined = "declined"
}
/**
 * Defines the request schema for `/transfer/authorization/create`
 * @export
 * @interface TransferAuthorizationCreateRequest
 */
export interface TransferAuthorizationCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferAuthorizationCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferAuthorizationCreateRequest
     */
    secret?: string;
    /**
     * The Plaid `access_token` for the account that will be debited or credited.
     * @type {string}
     * @memberof TransferAuthorizationCreateRequest
     */
    access_token: string;
    /**
     * The Plaid `account_id` for the account that will be debited or credited.
     * @type {string}
     * @memberof TransferAuthorizationCreateRequest
     */
    account_id: string;
    /**
     *
     * @type {TransferType}
     * @memberof TransferAuthorizationCreateRequest
     */
    type: TransferType;
    /**
     *
     * @type {TransferNetwork}
     * @memberof TransferAuthorizationCreateRequest
     */
    network: TransferNetwork;
    /**
     * The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof TransferAuthorizationCreateRequest
     */
    amount: string;
    /**
     *
     * @type {ACHClass}
     * @memberof TransferAuthorizationCreateRequest
     */
    ach_class: ACHClass;
    /**
     *
     * @type {TransferUserInRequest}
     * @memberof TransferAuthorizationCreateRequest
     */
    user: TransferUserInRequest;
    /**
     *
     * @type {TransferAuthorizationDevice}
     * @memberof TransferAuthorizationCreateRequest
     */
    device?: TransferAuthorizationDevice;
    /**
     * Plaid\'s unique identifier for the origination account for this authorization. If not specified, the default account will be used.
     * @type {string}
     * @memberof TransferAuthorizationCreateRequest
     */
    origination_account_id?: string;
    /**
     * The currency of the transfer amount. The default value is \"USD\".
     * @type {string}
     * @memberof TransferAuthorizationCreateRequest
     */
    iso_currency_code?: string;
}
/**
 * Defines the response schema for `/transfer/authorization/create`
 * @export
 * @interface TransferAuthorizationCreateResponse
 */
export interface TransferAuthorizationCreateResponse {
    [key: string]: object | any;
    /**
     *
     * @type {TransferAuthorization}
     * @memberof TransferAuthorizationCreateResponse
     */
    authorization: TransferAuthorization;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferAuthorizationCreateResponse
     */
    request_id: string;
}
/**
 * The rationale for Plaid\'s decision regarding a proposed transfer. Will be null for `approved` decisions.
 * @export
 * @interface TransferAuthorizationDecisionRationale
 */
export interface TransferAuthorizationDecisionRationale {
    [key: string]: object | any;
    /**
     * A code representing the rationale for permitting or declining the proposed transfer. Possible values are:  `NSF` – Transaction likely to result in a return due to insufficient funds.  `RISK` - Transaction is high-risk.  `MANUALLY_VERIFIED_ITEM` – Item created via same-day micro deposits, limited information available. Plaid can only offer `permitted` as a transaction decision.  `LOGIN_REQUIRED` – Unable to collect the account information required for an authorization decision due to Item staleness. Can be rectified using Link update mode.  `ERROR` – Unable to collect the account information required for an authorization decision due to an error.
     * @type {string}
     * @memberof TransferAuthorizationDecisionRationale
     */
    code: TransferAuthorizationDecisionRationaleCodeEnum;
    /**
     * A human-readable description of the code associated with a permitted transfer or transfer decline.
     * @type {string}
     * @memberof TransferAuthorizationDecisionRationale
     */
    description: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransferAuthorizationDecisionRationaleCodeEnum {
    Nsf = "NSF",
    Risk = "RISK",
    ManuallyVerifiedItem = "MANUALLY_VERIFIED_ITEM",
    LoginRequired = "LOGIN_REQUIRED",
    Error = "ERROR"
}
/**
 * Information about the device being used to initiate the authorization.
 * @export
 * @interface TransferAuthorizationDevice
 */
export interface TransferAuthorizationDevice {
    [key: string]: object | any;
    /**
     * The IP address of the device being used to initiate the authorization.
     * @type {string}
     * @memberof TransferAuthorizationDevice
     */
    ip_address?: string;
    /**
     * The user agent of the device being used to initiate the authorization.
     * @type {string}
     * @memberof TransferAuthorizationDevice
     */
    user_agent?: string;
}
/**
 * Indicates whether the transfer is guaranteed by Plaid (Guaranteed ACH customers only). This field will contain either `GUARANTEED` or `NOT_GUARANTEED` indicating whether Plaid will guarantee the transfer. If the transfer is not guaranteed, additional information will be provided in the `guarantee_decision_rationale` field. Refer to the `code` field in `guarantee_decision_rationale` for details.
 * @export
 * @enum {string}
 */
export declare enum TransferAuthorizationGuaranteeDecision {
    Guaranteed = "GUARANTEED",
    NotGuaranteed = "NOT_GUARANTEED",
    Null = "null"
}
/**
 * The rationale for Plaid\'s decision to not guarantee a transfer. Will be `null` unless `guarantee_decision` is `NOT_GUARANTEED`.
 * @export
 * @interface TransferAuthorizationGuaranteeDecisionRationale
 */
export interface TransferAuthorizationGuaranteeDecisionRationale {
    [key: string]: object | any;
    /**
     * A code representing the reason Plaid declined to guarantee this transfer:  `RETURN_BANK`: The risk of a bank-initiated return (for example, an R01/NSF) is too high to guarantee this transfer.  `RETURN_CUSTOMER`: The risk of a customer-initiated return (for example, a R10/Unauthorized) is too high to guarantee this transfer.  `GUARANTEE_LIMIT_REACHED`: This transfer is low-risk, but Guaranteed ACH has exhausted an internal limit on the number or rate of guarantees that applies to this transfer.  `RISK_ESTIMATE_UNAVAILABLE`: A risk estimate is unavailable for this Item.
     * @type {string}
     * @memberof TransferAuthorizationGuaranteeDecisionRationale
     */
    code: TransferAuthorizationGuaranteeDecisionRationaleCodeEnum;
    /**
     * A human-readable description of why the transfer cannot be guaranteed.
     * @type {string}
     * @memberof TransferAuthorizationGuaranteeDecisionRationale
     */
    description: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransferAuthorizationGuaranteeDecisionRationaleCodeEnum {
    ReturnBank = "RETURN_BANK",
    ReturnCustomer = "RETURN_CUSTOMER",
    GuaranteeLimitReached = "GUARANTEE_LIMIT_REACHED",
    RiskEstimateUnavailable = "RISK_ESTIMATE_UNAVAILABLE"
}
/**
 * Details regarding the proposed transfer.
 * @export
 * @interface TransferAuthorizationProposedTransfer
 */
export interface TransferAuthorizationProposedTransfer {
    [key: string]: object | any;
    /**
     *
     * @type {ACHClass}
     * @memberof TransferAuthorizationProposedTransfer
     */
    ach_class: ACHClass;
    /**
     * The Plaid `account_id` for the account that will be debited or credited.
     * @type {string}
     * @memberof TransferAuthorizationProposedTransfer
     */
    account_id: string;
    /**
     *
     * @type {TransferType}
     * @memberof TransferAuthorizationProposedTransfer
     */
    type: TransferType;
    /**
     *
     * @type {TransferUserInResponse}
     * @memberof TransferAuthorizationProposedTransfer
     */
    user: TransferUserInResponse;
    /**
     * The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof TransferAuthorizationProposedTransfer
     */
    amount: string;
    /**
     * The network or rails used for the transfer.
     * @type {string}
     * @memberof TransferAuthorizationProposedTransfer
     */
    network: string;
    /**
     * Plaid\'s unique identifier for the origination account that was used for this transfer.
     * @type {string}
     * @memberof TransferAuthorizationProposedTransfer
     */
    origination_account_id: string;
    /**
     * The currency of the transfer amount. The default value is \"USD\".
     * @type {string}
     * @memberof TransferAuthorizationProposedTransfer
     */
    iso_currency_code: string;
}
/**
 * Defines the request schema for `/transfer/cancel`
 * @export
 * @interface TransferCancelRequest
 */
export interface TransferCancelRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferCancelRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferCancelRequest
     */
    secret?: string;
    /**
     * Plaid’s unique identifier for a transfer.
     * @type {string}
     * @memberof TransferCancelRequest
     */
    transfer_id: string;
}
/**
 * Defines the response schema for `/transfer/cancel`
 * @export
 * @interface TransferCancelResponse
 */
export interface TransferCancelResponse {
    [key: string]: object | any;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferCancelResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/transfer/create`
 * @export
 * @interface TransferCreateRequest
 */
export interface TransferCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferCreateRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferCreateRequest
     */
    secret?: string;
    /**
     * Deprecated. `authorization_id` is now for used idempotency instead.  A random key provided by the client, per unique transfer. Maximum of 50 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. For example, if a request to create a transfer fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single transfer is created.
     * @type {string}
     * @memberof TransferCreateRequest
     * @deprecated
     */
    idempotency_key?: string;
    /**
     * The Plaid `access_token` for the account that will be debited or credited.
     * @type {string}
     * @memberof TransferCreateRequest
     */
    access_token: string;
    /**
     * The Plaid `account_id` for the account that will be debited or credited.
     * @type {string}
     * @memberof TransferCreateRequest
     */
    account_id: string;
    /**
     * Plaid’s unique identifier for a transfer authorization. This parameter also serves the purpose of acting as an idempotency identifier.
     * @type {string}
     * @memberof TransferCreateRequest
     */
    authorization_id: string;
    /**
     *
     * @type {TransferType}
     * @memberof TransferCreateRequest
     */
    type: TransferType;
    /**
     *
     * @type {TransferNetwork}
     * @memberof TransferCreateRequest
     */
    network: TransferNetwork;
    /**
     * The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof TransferCreateRequest
     */
    amount: string;
    /**
     * The transfer description. Maximum of 10 characters.
     * @type {string}
     * @memberof TransferCreateRequest
     */
    description: string;
    /**
     *
     * @type {ACHClass}
     * @memberof TransferCreateRequest
     */
    ach_class: ACHClass;
    /**
     *
     * @type {TransferUserInRequest}
     * @memberof TransferCreateRequest
     */
    user: TransferUserInRequest;
    /**
     * The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters
     * @type {{ [key: string]: string; }}
     * @memberof TransferCreateRequest
     */
    metadata?: {
        [key: string]: string;
    } | null;
    /**
     * Plaid’s unique identifier for the origination account for this transfer. If you have more than one origination account, this value must be specified. Otherwise, this field should be left blank.
     * @type {string}
     * @memberof TransferCreateRequest
     */
    origination_account_id?: string | null;
    /**
     * The currency of the transfer amount. The default value is \"USD\".
     * @type {string}
     * @memberof TransferCreateRequest
     */
    iso_currency_code?: string;
}
/**
 * Defines the response schema for `/transfer/create`
 * @export
 * @interface TransferCreateResponse
 */
export interface TransferCreateResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Transfer}
     * @memberof TransferCreateResponse
     */
    transfer: Transfer;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferCreateResponse
     */
    request_id: string;
}
/**
 * Represents an event in the Transfers API.
 * @export
 * @interface TransferEvent
 */
export interface TransferEvent {
    [key: string]: object | any;
    /**
     * Plaid’s unique identifier for this event. IDs are sequential unsigned 64-bit integers.
     * @type {number}
     * @memberof TransferEvent
     */
    event_id: number;
    /**
     * The datetime when this event occurred. This will be of the form `2006-01-02T15:04:05Z`.
     * @type {string}
     * @memberof TransferEvent
     */
    timestamp: string;
    /**
     *
     * @type {TransferEventType}
     * @memberof TransferEvent
     */
    event_type: TransferEventType;
    /**
     * The account ID associated with the transfer.
     * @type {string}
     * @memberof TransferEvent
     */
    account_id: string;
    /**
     * Plaid’s unique identifier for a transfer.
     * @type {string}
     * @memberof TransferEvent
     */
    transfer_id: string;
    /**
     * The ID of the origination account that this balance belongs to.
     * @type {string}
     * @memberof TransferEvent
     */
    origination_account_id: string | null;
    /**
     *
     * @type {TransferType}
     * @memberof TransferEvent
     */
    transfer_type: TransferType;
    /**
     * The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof TransferEvent
     */
    transfer_amount: string;
    /**
     *
     * @type {TransferFailure}
     * @memberof TransferEvent
     */
    failure_reason: TransferFailure | null;
    /**
     * Plaid’s unique identifier for a sweep.
     * @type {string}
     * @memberof TransferEvent
     */
    sweep_id: string | null;
    /**
     * A signed amount of how much was `swept` or `reverse_swept` (decimal string with two digits of precision e.g. \"-5.50\").
     * @type {string}
     * @memberof TransferEvent
     */
    sweep_amount: string | null;
}
/**
 * Defines the request schema for `/transfer/event/list`
 * @export
 * @interface TransferEventListRequest
 */
export interface TransferEventListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferEventListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferEventListRequest
     */
    secret?: string;
    /**
     * The start datetime of transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)
     * @type {string}
     * @memberof TransferEventListRequest
     */
    start_date?: string | null;
    /**
     * The end datetime of transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)
     * @type {string}
     * @memberof TransferEventListRequest
     */
    end_date?: string | null;
    /**
     * Plaid’s unique identifier for a transfer.
     * @type {string}
     * @memberof TransferEventListRequest
     */
    transfer_id?: string | null;
    /**
     * The account ID to get events for all transactions to/from an account.
     * @type {string}
     * @memberof TransferEventListRequest
     */
    account_id?: string | null;
    /**
     * The type of transfer. This will be either `debit` or `credit`.  A `debit` indicates a transfer of money into your origination account; a `credit` indicates a transfer of money out of your origination account.
     * @type {string}
     * @memberof TransferEventListRequest
     */
    transfer_type?: TransferEventListRequestTransferTypeEnum;
    /**
     * Filter events by event type.
     * @type {Array<TransferEventType>}
     * @memberof TransferEventListRequest
     */
    event_types?: Array<TransferEventType>;
    /**
     * Plaid’s unique identifier for a sweep.
     * @type {string}
     * @memberof TransferEventListRequest
     */
    sweep_id?: string;
    /**
     * The maximum number of transfer events to return. If the number of events matching the above parameters is greater than `count`, the most recent events will be returned.
     * @type {number}
     * @memberof TransferEventListRequest
     */
    count?: number | null;
    /**
     * The offset into the list of transfer events. When `count`=25 and `offset`=0, the first 25 events will be returned. When `count`=25 and `offset`=25, the next 25 bank transfer events will be returned.
     * @type {number}
     * @memberof TransferEventListRequest
     */
    offset?: number | null;
    /**
     * The origination account ID to get events for transfers from a specific origination account.
     * @type {string}
     * @memberof TransferEventListRequest
     */
    origination_account_id?: string | null;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransferEventListRequestTransferTypeEnum {
    Debit = "debit",
    Credit = "credit",
    Null = "null"
}
/**
 * Defines the response schema for `/transfer/event/list`
 * @export
 * @interface TransferEventListResponse
 */
export interface TransferEventListResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<TransferEvent>}
     * @memberof TransferEventListResponse
     */
    transfer_events: Array<TransferEvent>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferEventListResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/transfer/event/sync`
 * @export
 * @interface TransferEventSyncRequest
 */
export interface TransferEventSyncRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferEventSyncRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferEventSyncRequest
     */
    secret?: string;
    /**
     * The latest (largest) `event_id` fetched via the sync endpoint, or 0 initially.
     * @type {number}
     * @memberof TransferEventSyncRequest
     */
    after_id: number;
    /**
     * The maximum number of transfer events to return.
     * @type {number}
     * @memberof TransferEventSyncRequest
     */
    count?: number | null;
}
/**
 * Defines the response schema for `/transfer/event/sync`
 * @export
 * @interface TransferEventSyncResponse
 */
export interface TransferEventSyncResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<TransferEvent>}
     * @memberof TransferEventSyncResponse
     */
    transfer_events: Array<TransferEvent>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferEventSyncResponse
     */
    request_id: string;
}
/**
 * The type of event that this transfer represents.  `pending`: A new transfer was created; it is in the pending state.  `cancelled`: The transfer was cancelled by the client.  `failed`: The transfer failed, no funds were moved.  `posted`: The transfer has been successfully submitted to the payment network.  `reversed`: A posted transfer was reversed.  `swept`: The transfer was swept to / from the sweep account.  `reverse_swept`: Due to the transfer reversing, funds were pulled from or pushed back to the sweep account.
 * @export
 * @enum {string}
 */
export declare enum TransferEventType {
    Pending = "pending",
    Cancelled = "cancelled",
    Failed = "failed",
    Posted = "posted",
    Reversed = "reversed",
    Swept = "swept",
    ReverseSwept = "reverse_swept"
}
/**
 * The failure reason if the event type for a transfer is `\"failed\"` or `\"reversed\"`. Null value otherwise.
 * @export
 * @interface TransferFailure
 */
export interface TransferFailure {
    [key: string]: object | any;
    /**
     * The ACH return code, e.g. `R01`.  A return code will be provided if and only if the transfer status is `reversed`. For a full listing of ACH return codes, see [Transfer errors](https://plaid.com/docs/errors/transfer/#ach-return-codes).
     * @type {string}
     * @memberof TransferFailure
     */
    ach_return_code?: string | null;
    /**
     * A human-readable description of the reason for the failure or reversal.
     * @type {string}
     * @memberof TransferFailure
     */
    description?: string;
}
/**
 * Defines the request schema for `/transfer/get`
 * @export
 * @interface TransferGetRequest
 */
export interface TransferGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferGetRequest
     */
    secret?: string;
    /**
     * Plaid’s unique identifier for a transfer.
     * @type {string}
     * @memberof TransferGetRequest
     */
    transfer_id: string;
}
/**
 * Defines the response schema for `/transfer/get`
 * @export
 * @interface TransferGetResponse
 */
export interface TransferGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Transfer}
     * @memberof TransferGetResponse
     */
    transfer: Transfer;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferGetResponse
     */
    request_id: string;
}
/**
 * Represents a transfer intent within Transfer UI.
 * @export
 * @interface TransferIntentCreate
 */
export interface TransferIntentCreate {
    [key: string]: object | any;
    /**
     * Plaid\'s unique identifier for the transfer intent object.
     * @type {string}
     * @memberof TransferIntentCreate
     */
    id: string;
    /**
     * The datetime the transfer was created. This will be of the form `2006-01-02T15:04:05Z`.
     * @type {string}
     * @memberof TransferIntentCreate
     */
    created: string;
    /**
     * The status of the transfer intent.  - `PENDING` – The transfer intent is pending. - `SUCCEEDED` – The transfer intent was successfully created. - `FAILED` – The transfer intent was unable to be created.
     * @type {string}
     * @memberof TransferIntentCreate
     */
    status: TransferIntentCreateStatusEnum;
    /**
     * The Plaid `account_id` for the account that will be debited or credited. Returned only if `account_id` was set on intent creation.
     * @type {string}
     * @memberof TransferIntentCreate
     */
    account_id?: string | null;
    /**
     * Plaid’s unique identifier for the origination account for the intent. If not provided, the default account will be used.
     * @type {string}
     * @memberof TransferIntentCreate
     */
    origination_account_id: string;
    /**
     * The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof TransferIntentCreate
     */
    amount: string;
    /**
     *
     * @type {TransferIntentCreateMode}
     * @memberof TransferIntentCreate
     */
    mode: TransferIntentCreateMode;
    /**
     *
     * @type {ACHClass}
     * @memberof TransferIntentCreate
     */
    ach_class: ACHClass;
    /**
     *
     * @type {TransferUserInResponse}
     * @memberof TransferIntentCreate
     */
    user: TransferUserInResponse;
    /**
     * A description for the underlying transfer. Maximum of 8 characters.
     * @type {string}
     * @memberof TransferIntentCreate
     */
    description: string;
    /**
     * The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters
     * @type {{ [key: string]: string; }}
     * @memberof TransferIntentCreate
     */
    metadata?: {
        [key: string]: string;
    } | null;
    /**
     * The currency of the transfer amount, e.g. \"USD\"
     * @type {string}
     * @memberof TransferIntentCreate
     */
    iso_currency_code: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransferIntentCreateStatusEnum {
    Pending = "PENDING",
    Succeeded = "SUCCEEDED",
    Failed = "FAILED"
}
/**
 * The direction of the flow of transfer funds.  - `PAYMENT` – Transfers funds from an end user\'s account to your business account.  - `DISBURSEMENT` – Transfers funds from your business account to an end user\'s account.
 * @export
 * @enum {string}
 */
export declare enum TransferIntentCreateMode {
    Payment = "PAYMENT",
    Disbursement = "DISBURSEMENT"
}
/**
 * Defines the request schema for `/transfer/intent/create`
 * @export
 * @interface TransferIntentCreateRequest
 */
export interface TransferIntentCreateRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferIntentCreateRequest
     */
    client_id: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferIntentCreateRequest
     */
    secret: string;
    /**
     * The Plaid `account_id` for the account that will be debited or credited.
     * @type {string}
     * @memberof TransferIntentCreateRequest
     */
    account_id?: string | null;
    /**
     *
     * @type {TransferIntentCreateMode}
     * @memberof TransferIntentCreateRequest
     */
    mode: TransferIntentCreateMode;
    /**
     * The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof TransferIntentCreateRequest
     */
    amount: string;
    /**
     * A description for the underlying transfer. Maximum of 8 characters.
     * @type {string}
     * @memberof TransferIntentCreateRequest
     */
    description: string;
    /**
     *
     * @type {ACHClass}
     * @memberof TransferIntentCreateRequest
     */
    ach_class: ACHClass;
    /**
     * Plaid’s unique identifier for the origination account for the intent. If not provided, the default account will be used.
     * @type {string}
     * @memberof TransferIntentCreateRequest
     */
    origination_account_id?: string | null;
    /**
     *
     * @type {TransferUserInRequest}
     * @memberof TransferIntentCreateRequest
     */
    user: TransferUserInRequest;
    /**
     * The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters
     * @type {{ [key: string]: string; }}
     * @memberof TransferIntentCreateRequest
     */
    metadata?: {
        [key: string]: string;
    } | null;
    /**
     * The currency of the transfer amount, e.g. \"USD\"
     * @type {string}
     * @memberof TransferIntentCreateRequest
     */
    iso_currency_code?: string;
}
/**
 * Defines the response schema for `/transfer/intent/create`
 * @export
 * @interface TransferIntentCreateResponse
 */
export interface TransferIntentCreateResponse {
    [key: string]: object | any;
    /**
     *
     * @type {TransferIntentCreate}
     * @memberof TransferIntentCreateResponse
     */
    transfer_intent: TransferIntentCreate;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferIntentCreateResponse
     */
    request_id: string;
}
/**
 * Represents a transfer intent within Transfer UI.
 * @export
 * @interface TransferIntentGet
 */
export interface TransferIntentGet {
    [key: string]: object | any;
    /**
     * Plaid\'s unique identifier for a transfer intent object.
     * @type {string}
     * @memberof TransferIntentGet
     */
    id: string;
    /**
     * The datetime the transfer was created. This will be of the form `2006-01-02T15:04:05Z`.
     * @type {string}
     * @memberof TransferIntentGet
     */
    created: string;
    /**
     * The status of the transfer intent.  - `PENDING` – The transfer intent is pending. - `SUCCEEDED` – The transfer intent was successfully created. - `FAILED` – The transfer intent was unable to be created.
     * @type {string}
     * @memberof TransferIntentGet
     */
    status: TransferIntentGetStatusEnum;
    /**
     * Plaid\'s unique identifier for the transfer created through the UI. Returned only if the transfer was successfully created. Null value otherwise.
     * @type {string}
     * @memberof TransferIntentGet
     */
    transfer_id: string | null;
    /**
     *
     * @type {TransferIntentGetFailureReason}
     * @memberof TransferIntentGet
     */
    failure_reason: TransferIntentGetFailureReason | null;
    /**
     *  A decision regarding the proposed transfer.  `APPROVED` – The proposed transfer has received the end user\'s consent and has been approved for processing. Plaid has also reviewed the proposed transfer and has approved it for processing.   `PERMITTED` – Plaid was unable to fetch the information required to approve or decline the proposed transfer. You may proceed with the transfer, but further review is recommended. Plaid is awaiting further instructions from the client.  `DECLINED` – Plaid reviewed the proposed transfer and declined processing. Refer to the `code` field in the `decision_rationale` object for details. Null value otherwise.
     * @type {string}
     * @memberof TransferIntentGet
     */
    authorization_decision: TransferIntentGetAuthorizationDecisionEnum;
    /**
     *
     * @type {TransferAuthorizationDecisionRationale}
     * @memberof TransferIntentGet
     */
    authorization_decision_rationale: TransferAuthorizationDecisionRationale | null;
    /**
     * The Plaid `account_id` for the account that will be debited or credited. Returned only if `account_id` was set on intent creation.
     * @type {string}
     * @memberof TransferIntentGet
     */
    account_id?: string | null;
    /**
     * Plaid’s unique identifier for the origination account used for the transfer.
     * @type {string}
     * @memberof TransferIntentGet
     */
    origination_account_id: string;
    /**
     * The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
     * @type {string}
     * @memberof TransferIntentGet
     */
    amount: string;
    /**
     *
     * @type {TransferIntentCreateMode}
     * @memberof TransferIntentGet
     */
    mode: TransferIntentCreateMode;
    /**
     *
     * @type {ACHClass}
     * @memberof TransferIntentGet
     */
    ach_class: ACHClass;
    /**
     *
     * @type {TransferUserInResponse}
     * @memberof TransferIntentGet
     */
    user: TransferUserInResponse;
    /**
     * A description for the underlying transfer. Maximum of 8 characters.
     * @type {string}
     * @memberof TransferIntentGet
     */
    description: string;
    /**
     * The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters
     * @type {{ [key: string]: string; }}
     * @memberof TransferIntentGet
     */
    metadata?: {
        [key: string]: string;
    } | null;
    /**
     * The currency of the transfer amount, e.g. \"USD\"
     * @type {string}
     * @memberof TransferIntentGet
     */
    iso_currency_code: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransferIntentGetStatusEnum {
    Pending = "PENDING",
    Succeeded = "SUCCEEDED",
    Failed = "FAILED"
}
/**
    * @export
    * @enum {string}
    */
export declare enum TransferIntentGetAuthorizationDecisionEnum {
    Approved = "APPROVED",
    Permitted = "PERMITTED",
    Declined = "DECLINED"
}
/**
 * The reason for a failed transfer intent. Returned only if the transfer intent status is `failed`. Null otherwise.
 * @export
 * @interface TransferIntentGetFailureReason
 */
export interface TransferIntentGetFailureReason {
    [key: string]: object | any;
    /**
     * A broad categorization of the error.
     * @type {string}
     * @memberof TransferIntentGetFailureReason
     */
    error_type?: string;
    /**
     * A code representing the reason for a failed transfer intent (i.e., an API error or the authorization being declined).  For a full listing of bank transfer errors, see [Bank Transfers errors](https://plaid.com/docs/errors/bank-transfers/).
     * @type {string}
     * @memberof TransferIntentGetFailureReason
     */
    error_code?: string;
    /**
     * A human-readable description of the code associated with a failed transfer intent.
     * @type {string}
     * @memberof TransferIntentGetFailureReason
     */
    error_message?: string;
}
/**
 * Defines the request schema for `/transfer/intent/get`
 * @export
 * @interface TransferIntentGetRequest
 */
export interface TransferIntentGetRequest {
    [key: string]: object | any;
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferIntentGetRequest
     */
    client_id: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferIntentGetRequest
     */
    secret: string;
    /**
     * Plaid\'s unique identifier for a transfer intent object.
     * @type {string}
     * @memberof TransferIntentGetRequest
     */
    transfer_intent_id: string;
}
/**
 * Defines the response schema for `/transfer/intent/get`
 * @export
 * @interface TransferIntentGetResponse
 */
export interface TransferIntentGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {TransferIntentGet}
     * @memberof TransferIntentGetResponse
     */
    transfer_intent: TransferIntentGet;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferIntentGetResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/transfer/list`
 * @export
 * @interface TransferListRequest
 */
export interface TransferListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferListRequest
     */
    secret?: string;
    /**
     * The start datetime of transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)
     * @type {string}
     * @memberof TransferListRequest
     */
    start_date?: string | null;
    /**
     * The end datetime of transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)
     * @type {string}
     * @memberof TransferListRequest
     */
    end_date?: string | null;
    /**
     * The maximum number of transfers to return.
     * @type {number}
     * @memberof TransferListRequest
     */
    count?: number;
    /**
     * The number of transfers to skip before returning results.
     * @type {number}
     * @memberof TransferListRequest
     */
    offset?: number;
    /**
     * Filter transfers to only those originated through the specified origination account.
     * @type {string}
     * @memberof TransferListRequest
     */
    origination_account_id?: string | null;
}
/**
 * Defines the response schema for `/transfer/list`
 * @export
 * @interface TransferListResponse
 */
export interface TransferListResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<Transfer>}
     * @memberof TransferListResponse
     */
    transfers: Array<Transfer>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferListResponse
     */
    request_id: string;
}
/**
 * The network or rails used for the transfer. Valid options are `ach` or `same-day-ach`.
 * @export
 * @enum {string}
 */
export declare enum TransferNetwork {
    Ach = "ach",
    SameDayAch = "same-day-ach"
}
/**
 * A repayment is created automatically after one or more guaranteed transactions receive a return. If there are multiple eligible returns in a day, they are batched together into a single repayment.  Repayments are sent over ACH, with funds typically available on the next banking day.
 * @export
 * @interface TransferRepayment
 */
export interface TransferRepayment {
    [key: string]: object | any;
    /**
     * Identifier of the repayment.
     * @type {string}
     * @memberof TransferRepayment
     */
    repayment_id: string;
    /**
     * The datetime when the repayment occurred, in RFC 3339 format.
     * @type {string}
     * @memberof TransferRepayment
     */
    created: string;
    /**
     * Decimal amount of the repayment as it appears on your account ledger.
     * @type {string}
     * @memberof TransferRepayment
     */
    amount: string;
    /**
     * The currency of the repayment, e.g. \"USD\".
     * @type {string}
     * @memberof TransferRepayment
     */
    iso_currency_code: string;
}
/**
 * Defines the request schema for `/transfer/repayment/list`
 * @export
 * @interface TransferRepaymentListRequest
 */
export interface TransferRepaymentListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferRepaymentListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferRepaymentListRequest
     */
    secret?: string;
    /**
     * The start datetime of repayments to return (RFC 3339 format).
     * @type {string}
     * @memberof TransferRepaymentListRequest
     */
    start_date?: string | null;
    /**
     * The end datetime of repayments to return (RFC 3339 format).
     * @type {string}
     * @memberof TransferRepaymentListRequest
     */
    end_date?: string | null;
    /**
     * The maximum number of repayments to return.
     * @type {number}
     * @memberof TransferRepaymentListRequest
     */
    count?: number | null;
    /**
     * The number of repayments to skip before returning results.
     * @type {number}
     * @memberof TransferRepaymentListRequest
     */
    offset?: number;
}
/**
 * Defines the response schema for `/transfer/repayments/list`
 * @export
 * @interface TransferRepaymentListResponse
 */
export interface TransferRepaymentListResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<TransferRepayment>}
     * @memberof TransferRepaymentListResponse
     */
    repayments: Array<TransferRepayment>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferRepaymentListResponse
     */
    request_id: string;
}
/**
 * Represents a return on a Guaranteed ACH transfer that is included in the specified repayment.
 * @export
 * @interface TransferRepaymentReturn
 */
export interface TransferRepaymentReturn {
    [key: string]: object | any;
    /**
     * The unique identifier of the guaranteed transfer that was returned.
     * @type {string}
     * @memberof TransferRepaymentReturn
     */
    transfer_id: string;
    /**
     * The unique identifier of the corresponding `reversed` transfer event.
     * @type {number}
     * @memberof TransferRepaymentReturn
     */
    event_id: number;
    /**
     * The value of the returned transfer.
     * @type {string}
     * @memberof TransferRepaymentReturn
     */
    amount: string;
    /**
     * The currency of the repayment, e.g. \"USD\".
     * @type {string}
     * @memberof TransferRepaymentReturn
     */
    iso_currency_code: string;
}
/**
 * Defines the request schema for `/transfer/repayment/return/list`
 * @export
 * @interface TransferRepaymentReturnListRequest
 */
export interface TransferRepaymentReturnListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferRepaymentReturnListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferRepaymentReturnListRequest
     */
    secret?: string;
    /**
     * Identifier of the repayment to query.
     * @type {string}
     * @memberof TransferRepaymentReturnListRequest
     */
    repayment_id: string;
    /**
     * The maximum number of repayments to return.
     * @type {number}
     * @memberof TransferRepaymentReturnListRequest
     */
    count?: number | null;
    /**
     * The number of repayments to skip before returning results.
     * @type {number}
     * @memberof TransferRepaymentReturnListRequest
     */
    offset?: number;
}
/**
 * Defines the response schema for `/transfer/repayments/return/list`
 * @export
 * @interface TransferRepaymentReturnListResponse
 */
export interface TransferRepaymentReturnListResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<TransferRepaymentReturn>}
     * @memberof TransferRepaymentReturnListResponse
     */
    repayment_returns: Array<TransferRepaymentReturn>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferRepaymentReturnListResponse
     */
    request_id: string;
}
/**
 * The status of the transfer.
 * @export
 * @enum {string}
 */
export declare enum TransferStatus {
    Pending = "pending",
    Posted = "posted",
    Cancelled = "cancelled",
    Failed = "failed",
    Reversed = "reversed"
}
/**
 * Describes a sweep of funds to / from the sweep account.  A sweep is associated with many sweep events (events of type `swept` or `reverse_swept`) which can be retrieved by invoking the `/transfer/event/list` endpoint with the corresponding `sweep_id`.  `swept` events occur when the transfer amount is credited or debited from your sweep account, depending on the `type` of the transfer. `reverse_swept` events occur when a transfer is reversed and Plaid undoes the credit or debit.  The total sum of the `swept` and `reverse_swept` events is equal to the `amount` of the sweep Plaid creates and matches the amount of the entry on your sweep account ledger.
 * @export
 * @interface TransferSweep
 */
export interface TransferSweep {
    [key: string]: object | any;
    /**
     * Identifier of the sweep.
     * @type {string}
     * @memberof TransferSweep
     */
    id: string;
    /**
     * The datetime when the sweep occurred, in RFC 3339 format.
     * @type {string}
     * @memberof TransferSweep
     */
    created: string;
    /**
     * Signed decimal amount of the sweep as it appears on your sweep account ledger (e.g. \"-10.00\")  If amount is not present, the sweep was net-settled to zero and outstanding debits and credits between the sweep account and Plaid are balanced.
     * @type {string}
     * @memberof TransferSweep
     */
    amount: string;
    /**
     * The currency of the sweep, e.g. \"USD\".
     * @type {string}
     * @memberof TransferSweep
     */
    iso_currency_code: string;
}
/**
 * Defines the request schema for `/transfer/sweep/get`
 * @export
 * @interface TransferSweepGetRequest
 */
export interface TransferSweepGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferSweepGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferSweepGetRequest
     */
    secret?: string;
    /**
     * Plaid’s unique identifier for a sweep.
     * @type {string}
     * @memberof TransferSweepGetRequest
     */
    sweep_id: string;
}
/**
 * Defines the response schema for `/transfer/sweep/get`
 * @export
 * @interface TransferSweepGetResponse
 */
export interface TransferSweepGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {TransferSweep}
     * @memberof TransferSweepGetResponse
     */
    sweep: TransferSweep;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferSweepGetResponse
     */
    request_id: string;
}
/**
 * Defines the request schema for `/transfer/sweep/list`
 * @export
 * @interface TransferSweepListRequest
 */
export interface TransferSweepListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof TransferSweepListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof TransferSweepListRequest
     */
    secret?: string;
    /**
     * The start datetime of sweeps to return (RFC 3339 format).
     * @type {string}
     * @memberof TransferSweepListRequest
     */
    start_date?: string | null;
    /**
     * The end datetime of sweeps to return (RFC 3339 format).
     * @type {string}
     * @memberof TransferSweepListRequest
     */
    end_date?: string | null;
    /**
     * The maximum number of sweeps to return.
     * @type {number}
     * @memberof TransferSweepListRequest
     */
    count?: number | null;
    /**
     * The number of sweeps to skip before returning results.
     * @type {number}
     * @memberof TransferSweepListRequest
     */
    offset?: number;
}
/**
 * Defines the response schema for `/transfer/sweep/list`
 * @export
 * @interface TransferSweepListResponse
 */
export interface TransferSweepListResponse {
    [key: string]: object | any;
    /**
     *
     * @type {Array<TransferSweep>}
     * @memberof TransferSweepListResponse
     */
    sweeps: Array<TransferSweep>;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof TransferSweepListResponse
     */
    request_id: string;
}
/**
 * The status of the sweep for the transfer. `unswept`: The transfer hasn\'t been swept yet. `swept`: The transfer was swept to the sweep account. `reverse_swept`: The transfer was reversed, funds were pulled back or pushed back to the sweep account. `null`: The transfer will never be swept (e.g. if the transfer is cancelled or reversed before being swept)
 * @export
 * @enum {string}
 */
export declare enum TransferSweepStatus {
    Null = "null",
    Unswept = "unswept",
    Swept = "swept",
    ReverseSwept = "reverse_swept"
}
/**
 * The type of transfer. This will be either `debit` or `credit`.  A `debit` indicates a transfer of money into the origination account; a `credit` indicates a transfer of money out of the origination account.
 * @export
 * @enum {string}
 */
export declare enum TransferType {
    Debit = "debit",
    Credit = "credit"
}
/**
 * The address associated with the account holder.
 * @export
 * @interface TransferUserAddressInRequest
 */
export interface TransferUserAddressInRequest {
    [key: string]: object | any;
    /**
     * The street number and name (i.e., \"100 Market St.\").
     * @type {string}
     * @memberof TransferUserAddressInRequest
     */
    street?: string;
    /**
     * Ex. \"San Francisco\"
     * @type {string}
     * @memberof TransferUserAddressInRequest
     */
    city?: string;
    /**
     * The state or province (e.g., \"California\").
     * @type {string}
     * @memberof TransferUserAddressInRequest
     */
    region?: string;
    /**
     * The postal code (e.g., \"94103\").
     * @type {string}
     * @memberof TransferUserAddressInRequest
     */
    postal_code?: string;
    /**
     * A two-letter country code (e.g., \"US\").
     * @type {string}
     * @memberof TransferUserAddressInRequest
     */
    country?: string;
}
/**
 * The address associated with the account holder.
 * @export
 * @interface TransferUserAddressInResponse
 */
export interface TransferUserAddressInResponse {
    [key: string]: object | any;
    /**
     * The street number and name (i.e., \"100 Market St.\").
     * @type {string}
     * @memberof TransferUserAddressInResponse
     */
    street: string | null;
    /**
     * Ex. \"San Francisco\"
     * @type {string}
     * @memberof TransferUserAddressInResponse
     */
    city: string | null;
    /**
     * The state or province (e.g., \"California\").
     * @type {string}
     * @memberof TransferUserAddressInResponse
     */
    region: string | null;
    /**
     * The postal code (e.g., \"94103\").
     * @type {string}
     * @memberof TransferUserAddressInResponse
     */
    postal_code: string | null;
    /**
     * A two-letter country code (e.g., \"US\").
     * @type {string}
     * @memberof TransferUserAddressInResponse
     */
    country: string | null;
}
/**
 * The legal name and other information for the account holder.
 * @export
 * @interface TransferUserInRequest
 */
export interface TransferUserInRequest {
    [key: string]: object | any;
    /**
     * The user\'s legal name.
     * @type {string}
     * @memberof TransferUserInRequest
     */
    legal_name: string;
    /**
     * The user\'s phone number.
     * @type {string}
     * @memberof TransferUserInRequest
     */
    phone_number?: string;
    /**
     * The user\'s email address.
     * @type {string}
     * @memberof TransferUserInRequest
     */
    email_address?: string;
    /**
     *
     * @type {TransferUserAddressInRequest}
     * @memberof TransferUserInRequest
     */
    address?: TransferUserAddressInRequest;
}
/**
 * The legal name and other information for the account holder.
 * @export
 * @interface TransferUserInResponse
 */
export interface TransferUserInResponse {
    [key: string]: object | any;
    /**
     * The user\'s legal name.
     * @type {string}
     * @memberof TransferUserInResponse
     */
    legal_name: string;
    /**
     * The user\'s phone number.
     * @type {string}
     * @memberof TransferUserInResponse
     */
    phone_number: string | null;
    /**
     * The user\'s email address.
     * @type {string}
     * @memberof TransferUserInResponse
     */
    email_address: string | null;
    /**
     *
     * @type {TransferUserAddressInResponse}
     * @memberof TransferUserInResponse
     */
    address: TransferUserAddressInResponse | null;
}
/**
 * Custom test accounts are configured with a JSON configuration object formulated according to the schema below. All fields are optional. Sending an empty object as a configuration will result in an account configured with random balances and transaction history.
 * @export
 * @interface UserCustomPassword
 */
export interface UserCustomPassword {
    [key: string]: object | any;
    /**
     * The version of the password schema to use, possible values are 1 or 2. The default value is 2. You should only specify 1 if you know it is necessary for your test suite.
     * @type {string}
     * @memberof UserCustomPassword
     */
    version?: string | null;
    /**
     * A seed, in the form of a string, that will be used to randomly generate account and transaction data, if this data is not specified using the `override_accounts` argument. If no seed is specified, the randomly generated data will be different each time.  Note that transactions data is generated relative to the Item\'s creation date. Different Items created on different dates with the same seed for transactions data will have different dates for the transactions. The number of days between each transaction and the Item creation will remain constant. For example, an Item created on December 15 might show a transaction on December 14. An Item created on December 20, using the same seed, would show that same transaction occurring on December 19.
     * @type {string}
     * @memberof UserCustomPassword
     */
    seed: string;
    /**
     * An array of account overrides to configure the accounts for the Item. By default, if no override is specified, transactions and account data will be randomly generated based on the account type and subtype, and other products will have fixed or empty data.
     * @type {Array<OverrideAccounts>}
     * @memberof UserCustomPassword
     */
    override_accounts: Array<OverrideAccounts>;
    /**
     *
     * @type {MFA}
     * @memberof UserCustomPassword
     */
    mfa: MFA;
    /**
     * You may trigger a reCAPTCHA in Plaid Link in the Sandbox environment by using the recaptcha field. Possible values are `good` or `bad`. A value of `good` will result in successful Item creation and `bad` will result in a `RECAPTCHA_BAD` error to simulate a failed reCAPTCHA. Both values require the reCAPTCHA to be manually solved within Plaid Link.
     * @type {string}
     * @memberof UserCustomPassword
     */
    recaptcha: string;
    /**
     * An error code to force on Item creation. Possible values are:  `\"INSTITUTION_NOT_RESPONDING\"` `\"INSTITUTION_NO_LONGER_SUPPORTED\"` `\"INVALID_CREDENTIALS\"` `\"INVALID_MFA\"` `\"ITEM_LOCKED\"` `\"ITEM_LOGIN_REQUIRED\"` `\"ITEM_NOT_SUPPORTED\"` `\"INVALID_LINK_TOKEN\"` `\"MFA_NOT_SUPPORTED\"` `\"NO_ACCOUNTS\"` `\"PLAID_ERROR\"` `\"PRODUCTS_NOT_SUPPORTED\"` `\"USER_SETUP_REQUIRED\"`
     * @type {string}
     * @memberof UserCustomPassword
     */
    force_error: string;
}
/**
 * The `USER_PERMISSION_REVOKED` webhook is fired to when an end user has used the [my.plaid.com portal](https://my.plaid.com) to revoke the permission that they previously granted to access an Item. Once access to an Item has been revoked, it cannot be restored. If the user subsequently returns to your application, a new Item must be created for the user.
 * @export
 * @interface UserPermissionRevokedWebhook
 */
export interface UserPermissionRevokedWebhook {
    [key: string]: object | any;
    /**
     * `ITEM`
     * @type {string}
     * @memberof UserPermissionRevokedWebhook
     */
    webhook_type: string;
    /**
     * `USER_PERMISSION_REVOKED`
     * @type {string}
     * @memberof UserPermissionRevokedWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof UserPermissionRevokedWebhook
     */
    item_id: string;
    /**
     *
     * @type {PlaidError}
     * @memberof UserPermissionRevokedWebhook
     */
    error?: PlaidError;
}
/**
 * Details about a certain reason as to why a document could potentially be fraudulent
 * @export
 * @interface VerificationAttribute
 */
export interface VerificationAttribute {
    [key: string]: object | any;
    /**
     * Message indicating the reason as to why the verification failed
     * @type {string}
     * @memberof VerificationAttribute
     */
    type: VerificationAttributeTypeEnum;
}
/**
    * @export
    * @enum {string}
    */
export declare enum VerificationAttributeTypeEnum {
    VerificationAttributeTypeUnknown = "VERIFICATION_ATTRIBUTE_TYPE_UNKNOWN",
    VerificationAttributeTypeAmountMatch = "VERIFICATION_ATTRIBUTE_TYPE_AMOUNT_MATCH",
    VerificationAttributeTypeDateMatch = "VERIFICATION_ATTRIBUTE_TYPE_DATE_MATCH",
    VerificationAttributeTypeDateMismatch = "VERIFICATION_ATTRIBUTE_TYPE_DATE_MISMATCH",
    VerificationAttributeTypeFileTampering = "VERIFICATION_ATTRIBUTE_TYPE_FILE_TAMPERING",
    VerificationAttributeTypeDescriptionMatch = "VERIFICATION_ATTRIBUTE_TYPE_DESCRIPTION_MATCH",
    VerificationAttributeTypeDescriptionMismatch = "VERIFICATION_ATTRIBUTE_TYPE_DESCRIPTION_MISMATCH",
    VerificationAttributeTypeFirstNameMatch = "VERIFICATION_ATTRIBUTE_TYPE_FIRST_NAME_MATCH",
    VerificationAttributeTypeFirstNameMismatch = "VERIFICATION_ATTRIBUTE_TYPE_FIRST_NAME_MISMATCH",
    VerificationAttributeTypeLastNameMatch = "VERIFICATION_ATTRIBUTE_TYPE_LAST_NAME_MATCH",
    VerificationAttributeTypeLastNameMismatch = "VERIFICATION_ATTRIBUTE_TYPE_LAST_NAME_MISMATCH",
    Null = "null"
}
/**
 * Fired when an Item was not verified via automated micro-deposits after seven days since the automated micro-deposit was made.
 * @export
 * @interface VerificationExpiredWebhook
 */
export interface VerificationExpiredWebhook {
    [key: string]: object | any;
    /**
     * `AUTH`
     * @type {string}
     * @memberof VerificationExpiredWebhook
     */
    webhook_type: string;
    /**
     * `VERIFICATION_EXPIRED`
     * @type {string}
     * @memberof VerificationExpiredWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof VerificationExpiredWebhook
     */
    item_id: string;
    /**
     * The `account_id` of the account associated with the webhook
     * @type {string}
     * @memberof VerificationExpiredWebhook
     */
    account_id: string;
}
/**
 * The verification refresh status. One of the following:  `\"VERIFICATION_REFRESH_STATUS_USER_PRESENCE_REQUIRED\"` User presence is required to refresh an income verification. `\"VERIFICATION_REFRESH_SUCCESSFUL\"` The income verification refresh was successful. `\"VERIFICATION_REFRESH_NOT_FOUND\"` No new data was found after the income verification refresh.
 * @export
 * @enum {string}
 */
export declare enum VerificationRefreshStatus {
    StatusUserPresenceRequired = "VERIFICATION_REFRESH_STATUS_USER_PRESENCE_REQUIRED",
    Successful = "VERIFICATION_REFRESH_SUCCESSFUL",
    NotFound = "VERIFICATION_REFRESH_NOT_FOUND"
}
/**
 * The verification status. One of the following:  `\"VERIFIED\"`: The information was successfully verified.  `\"UNVERIFIED\"`: The verification has not yet been performed.  `\"NEEDS_INFO\"`: The verification was attempted but could not be completed due to missing information.  \"`UNABLE_TO_VERIFY`\": The verification was performed and the information could not be verified.  `\"UNKNOWN\"`: The verification status is unknown.
 * @export
 * @enum {string}
 */
export declare enum VerificationStatus {
    Verified = "VERIFIED",
    Unverified = "UNVERIFIED",
    NeedsInfo = "NEEDS_INFO",
    UnableToVerify = "UNABLE_TO_VERIFY",
    Unknown = "UNKNOWN"
}
/**
 * W2 is an object that represents income data taken from a W2 tax document.
 * @export
 * @interface W2
 */
export interface W2 {
    [key: string]: object | any;
    /**
     *
     * @type {PaystubEmployer}
     * @memberof W2
     */
    employer?: PaystubEmployer;
    /**
     *
     * @type {Employee}
     * @memberof W2
     */
    employee?: Employee;
    /**
     * The tax year of the W2 document.
     * @type {string}
     * @memberof W2
     */
    tax_year?: string | null;
    /**
     * An employee identification number or EIN.
     * @type {string}
     * @memberof W2
     */
    employer_id_number?: string | null;
    /**
     * Wages from tips and other compensation.
     * @type {string}
     * @memberof W2
     */
    wages_tips_other_comp?: string | null;
    /**
     * Federal income tax withheld for the tax year.
     * @type {string}
     * @memberof W2
     */
    federal_income_tax_withheld?: string | null;
    /**
     * Wages from social security.
     * @type {string}
     * @memberof W2
     */
    social_security_wages?: string | null;
    /**
     * Social security tax withheld for the tax year.
     * @type {string}
     * @memberof W2
     */
    social_security_tax_withheld?: string | null;
    /**
     * Wages and tips from medicare.
     * @type {string}
     * @memberof W2
     */
    medicare_wages_and_tips?: string | null;
    /**
     * Medicare tax withheld for the tax year.
     * @type {string}
     * @memberof W2
     */
    medicare_tax_withheld?: string | null;
    /**
     * Tips from social security.
     * @type {string}
     * @memberof W2
     */
    social_security_tips?: string | null;
    /**
     * Allocated tips.
     * @type {string}
     * @memberof W2
     */
    allocated_tips?: string | null;
    /**
     * Contents from box 9 on the W2.
     * @type {string}
     * @memberof W2
     */
    box_9?: string | null;
    /**
     * Dependent care benefits.
     * @type {string}
     * @memberof W2
     */
    dependent_care_benefits?: string | null;
    /**
     * Nonqualified plans.
     * @type {string}
     * @memberof W2
     */
    nonqualified_plans?: string | null;
    /**
     *
     * @type {Array<W2Box12>}
     * @memberof W2
     */
    box_12?: Array<W2Box12>;
    /**
     * Statutory employee.
     * @type {string}
     * @memberof W2
     */
    statutory_employee?: string | null;
    /**
     * Retirement plan.
     * @type {string}
     * @memberof W2
     */
    retirement_plan?: string | null;
    /**
     * Third party sick pay.
     * @type {string}
     * @memberof W2
     */
    third_party_sick_pay?: string | null;
    /**
     * Other.
     * @type {string}
     * @memberof W2
     */
    other?: string | null;
    /**
     *
     * @type {Array<W2StateAndLocalWages>}
     * @memberof W2
     */
    state_and_local_wages?: Array<W2StateAndLocalWages>;
}
/**
 * Data on the W2 Box 12
 * @export
 * @interface W2Box12
 */
export interface W2Box12 {
    [key: string]: object | any;
    /**
     * W2 Box 12 code.
     * @type {string}
     * @memberof W2Box12
     */
    code?: string | null;
    /**
     * W2 Box 12 amount.
     * @type {string}
     * @memberof W2Box12
     */
    amount?: string | null;
}
/**
 * W2 state and local wages
 * @export
 * @interface W2StateAndLocalWages
 */
export interface W2StateAndLocalWages {
    [key: string]: object | any;
    /**
     * State associated with the wage.
     * @type {string}
     * @memberof W2StateAndLocalWages
     */
    state?: string | null;
    /**
     * State identification number of the employer.
     * @type {string}
     * @memberof W2StateAndLocalWages
     */
    employer_state_id_number?: string | null;
    /**
     * Wages and tips from the specified state.
     * @type {string}
     * @memberof W2StateAndLocalWages
     */
    state_wages_tips?: string | null;
    /**
     * Income tax from the specified state.
     * @type {string}
     * @memberof W2StateAndLocalWages
     */
    state_income_tax?: string | null;
    /**
     * Wages and tips from the locality.
     * @type {string}
     * @memberof W2StateAndLocalWages
     */
    local_wages_tips?: string | null;
    /**
     * Income tax from the locality.
     * @type {string}
     * @memberof W2StateAndLocalWages
     */
    local_income_tax?: string | null;
    /**
     * Name of the locality.
     * @type {string}
     * @memberof W2StateAndLocalWages
     */
    locality_name?: string | null;
}
/**
 * An object representing the e-wallet balance
 * @export
 * @interface WalletBalance
 */
export interface WalletBalance {
    [key: string]: object | any;
    /**
     * The ISO-4217 currency code of the balance
     * @type {string}
     * @memberof WalletBalance
     */
    iso_currency_code: string;
    /**
     * The total amount of funds in the account
     * @type {number}
     * @memberof WalletBalance
     */
    current: number;
}
/**
 * WalletGetRequest defines the request schema for `/wallet/get`
 * @export
 * @interface WalletGetRequest
 */
export interface WalletGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof WalletGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof WalletGetRequest
     */
    secret?: string;
    /**
     * The ID of the e-wallet
     * @type {string}
     * @memberof WalletGetRequest
     */
    wallet_id: string;
}
/**
 * WalletGetResponse defines the response schema for `/wallet/get`
 * @export
 * @interface WalletGetResponse
 */
export interface WalletGetResponse {
    [key: string]: object | any;
    /**
     * A unique ID identifying the e-wallet
     * @type {string}
     * @memberof WalletGetResponse
     */
    wallet_id: string;
    /**
     *
     * @type {WalletBalance}
     * @memberof WalletGetResponse
     */
    balance: WalletBalance | null;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof WalletGetResponse
     */
    request_id: string;
}
/**
 * The transaction details
 * @export
 * @interface WalletTransaction
 */
export interface WalletTransaction {
    [key: string]: object | any;
    /**
     * A unique ID identifying the transaction
     * @type {string}
     * @memberof WalletTransaction
     */
    transaction_id: string;
    /**
     * A reference for the transaction
     * @type {string}
     * @memberof WalletTransaction
     */
    reference: string;
    /**
     * The type of of the transaction. Currently, only `\"PAYOUT\"` is supported.
     * @type {string}
     * @memberof WalletTransaction
     */
    type: WalletTransactionTypeEnum;
    /**
     *
     * @type {WalletTransactionAmount}
     * @memberof WalletTransaction
     */
    amount: WalletTransactionAmount;
    /**
     *
     * @type {WalletTransactionCounterparty}
     * @memberof WalletTransaction
     */
    counterparty: WalletTransactionCounterparty;
    /**
     *
     * @type {WalletTransactionStatus}
     * @memberof WalletTransaction
     */
    status: WalletTransactionStatus;
    /**
     * Timestamp when the transaction was created, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.
     * @type {string}
     * @memberof WalletTransaction
     */
    created_at: string;
}
/**
    * @export
    * @enum {string}
    */
export declare enum WalletTransactionTypeEnum {
    Payout = "PAYOUT"
}
/**
 * The amount and currency of a transaction
 * @export
 * @interface WalletTransactionAmount
 */
export interface WalletTransactionAmount {
    [key: string]: object | any;
    /**
     * The ISO-4217 currency code of the transaction. Currently, only `\"GBP\"` is supported.
     * @type {string}
     * @memberof WalletTransactionAmount
     */
    iso_currency_code: WalletTransactionAmountIsoCurrencyCodeEnum;
    /**
     * The amount of the transaction. Must contain at most two digits of precision e.g. `1.23`.
     * @type {number}
     * @memberof WalletTransactionAmount
     */
    value: number;
}
/**
    * @export
    * @enum {string}
    */
export declare enum WalletTransactionAmountIsoCurrencyCodeEnum {
    Gbp = "GBP"
}
/**
 * An object representing the e-wallet transaction\'s counterparty
 * @export
 * @interface WalletTransactionCounterparty
 */
export interface WalletTransactionCounterparty {
    [key: string]: object | any;
    /**
     * The name of the counterparty
     * @type {string}
     * @memberof WalletTransactionCounterparty
     */
    name: string;
    /**
     *
     * @type {WalletTransactionCounterpartyNumbers}
     * @memberof WalletTransactionCounterparty
     */
    numbers: WalletTransactionCounterpartyNumbers;
}
/**
 * The account number and sort code of the counterparty\'s account
 * @export
 * @interface WalletTransactionCounterpartyBACS
 */
export interface WalletTransactionCounterpartyBACS {
    /**
     * The account number of the account. Maximum of 10 characters.
     * @type {string}
     * @memberof WalletTransactionCounterpartyBACS
     */
    account?: string;
    /**
     * The 6-character sort code of the account.
     * @type {string}
     * @memberof WalletTransactionCounterpartyBACS
     */
    sort_code?: string;
}
/**
 * The counterparty\'s bank account numbers
 * @export
 * @interface WalletTransactionCounterpartyNumbers
 */
export interface WalletTransactionCounterpartyNumbers {
    /**
     *
     * @type {WalletTransactionCounterpartyBACS}
     * @memberof WalletTransactionCounterpartyNumbers
     */
    bacs: WalletTransactionCounterpartyBACS;
}
/**
 * WalletTransactionExecuteRequest defines the request schema for `/wallet/transaction/execute`
 * @export
 * @interface WalletTransactionExecuteRequest
 */
export interface WalletTransactionExecuteRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof WalletTransactionExecuteRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof WalletTransactionExecuteRequest
     */
    secret?: string;
    /**
     * A random key provided by the client, per unique wallet transaction. Maximum of 128 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. If a request to execute a wallet transaction fails due to a network connection error, then after a minimum delay of one minute, you can retry the request with the same idempotency key to guarantee that only a single wallet transaction is created. If the request was successfully processed, it will prevent any transaction that uses the same idempotency key, and was received within 24 hours of the first request, from being processed.
     * @type {string}
     * @memberof WalletTransactionExecuteRequest
     */
    idempotency_key: string;
    /**
     * The ID of the e-wallet to debit from
     * @type {string}
     * @memberof WalletTransactionExecuteRequest
     */
    wallet_id: string;
    /**
     *
     * @type {WalletTransactionCounterparty}
     * @memberof WalletTransactionExecuteRequest
     */
    counterparty: WalletTransactionCounterparty;
    /**
     *
     * @type {WalletTransactionAmount}
     * @memberof WalletTransactionExecuteRequest
     */
    amount: WalletTransactionAmount;
    /**
     * A reference for the transaction. This must be an alphanumeric string with at most 18 characters and must not contain any special characters or spaces.
     * @type {string}
     * @memberof WalletTransactionExecuteRequest
     */
    reference: string;
}
/**
 * WalletTransactionExecuteResponse defines the response schema for `/wallet/transaction/execute`
 * @export
 * @interface WalletTransactionExecuteResponse
 */
export interface WalletTransactionExecuteResponse {
    [key: string]: object | any;
    /**
     * A unique ID identifying the transaction
     * @type {string}
     * @memberof WalletTransactionExecuteResponse
     */
    transaction_id: string;
    /**
     *
     * @type {WalletTransactionStatus}
     * @memberof WalletTransactionExecuteResponse
     */
    status: WalletTransactionStatus;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof WalletTransactionExecuteResponse
     */
    request_id: string;
}
/**
 * The status of the transaction.  `INITIATED`: This is the initial state of all transactions. It indicates that the transaction has been initiated and is currently being processed.  `EXECUTED`: The transaction has been successfully executed.  `FAILED`: The transaction failed to process successfully. This is a terminal status.  `BLOCKED`: The transaction has been blocked for violating compliance rules. This is a terminal status.
 * @export
 * @enum {string}
 */
export declare enum WalletTransactionStatus {
    Initiated = "INITIATED",
    Executed = "EXECUTED",
    Blocked = "BLOCKED",
    Failed = "FAILED"
}
/**
 * WalletTransactionsListRequest defines the request schema for `/wallet/transactions/list`
 * @export
 * @interface WalletTransactionsListRequest
 */
export interface WalletTransactionsListRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof WalletTransactionsListRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof WalletTransactionsListRequest
     */
    secret?: string;
    /**
     * The ID of the e-wallet to fetch transactions from
     * @type {string}
     * @memberof WalletTransactionsListRequest
     */
    wallet_id: string;
    /**
     * A base64 value representing the latest transaction that has already been requested. Set this to `next_cursor` received from the previous `/wallet/transactions/list` request. If provided, the response will only contain transactions created before that transaction. If omitted, the response will contain transactions starting from the most recent, and in descending order by the `created_at` time.
     * @type {string}
     * @memberof WalletTransactionsListRequest
     */
    cursor?: string;
    /**
     * The number of transactions to fetch
     * @type {number}
     * @memberof WalletTransactionsListRequest
     */
    count?: number;
}
/**
 * WalletTransactionsListResponse defines the response schema for `/wallet/transactions/list`
 * @export
 * @interface WalletTransactionsListResponse
 */
export interface WalletTransactionsListResponse {
    [key: string]: object | any;
    /**
     * An array of transactions of an e-wallet, associated with the given `wallet_id`
     * @type {Array<WalletTransaction>}
     * @memberof WalletTransactionsListResponse
     */
    transactions: Array<WalletTransaction>;
    /**
     * Cursor used for fetching transactions created before the latest transaction provided in this response
     * @type {string}
     * @memberof WalletTransactionsListResponse
     */
    next_cursor?: string;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof WalletTransactionsListResponse
     */
    request_id: string;
}
/**
 * It is possible for an Asset Report to be returned with missing account owner information. In such cases, the Asset Report will contain warning data in the response, indicating why obtaining the owner information failed.
 * @export
 * @interface Warning
 */
export interface Warning {
    [key: string]: object | any;
    /**
     * The warning type, which will always be `ASSET_REPORT_WARNING`
     * @type {string}
     * @memberof Warning
     */
    warning_type: string;
    /**
     * The warning code identifies a specific kind of warning. Currently, the only possible warning code is `OWNERS_UNAVAILABLE`, which indicates that account-owner information is not available.
     * @type {string}
     * @memberof Warning
     */
    warning_code: WarningWarningCodeEnum;
    /**
     *
     * @type {Cause}
     * @memberof Warning
     */
    cause: Cause;
}
/**
    * @export
    * @enum {string}
    */
export declare enum WarningWarningCodeEnum {
    OwnersUnavailable = "OWNERS_UNAVAILABLE"
}
/**
 * Fired when an Item\'s webhook is updated. This will be sent to the newly specified webhook.
 * @export
 * @interface WebhookUpdateAcknowledgedWebhook
 */
export interface WebhookUpdateAcknowledgedWebhook {
    [key: string]: object | any;
    /**
     * `ITEM`
     * @type {string}
     * @memberof WebhookUpdateAcknowledgedWebhook
     */
    webhook_type: string;
    /**
     * `WEBHOOK_UPDATE_ACKNOWLEDGED`
     * @type {string}
     * @memberof WebhookUpdateAcknowledgedWebhook
     */
    webhook_code: string;
    /**
     * The `item_id` of the Item associated with this webhook, warning, or error
     * @type {string}
     * @memberof WebhookUpdateAcknowledgedWebhook
     */
    item_id: string;
    /**
     * The new webhook URL
     * @type {string}
     * @memberof WebhookUpdateAcknowledgedWebhook
     */
    new_webhook_url: string;
    /**
     *
     * @type {PlaidError}
     * @memberof WebhookUpdateAcknowledgedWebhook
     */
    error?: PlaidError;
}
/**
 * WebhookVerificationKeyGetRequest defines the request schema for `/webhook_verification_key/get`
 * @export
 * @interface WebhookVerificationKeyGetRequest
 */
export interface WebhookVerificationKeyGetRequest {
    /**
     * Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.
     * @type {string}
     * @memberof WebhookVerificationKeyGetRequest
     */
    client_id?: string;
    /**
     * Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.
     * @type {string}
     * @memberof WebhookVerificationKeyGetRequest
     */
    secret?: string;
    /**
     * The key ID ( `kid` ) from the JWT header.
     * @type {string}
     * @memberof WebhookVerificationKeyGetRequest
     */
    key_id: string;
}
/**
 * WebhookVerificationKeyGetResponse defines the response schema for `/webhook_verification_key/get`
 * @export
 * @interface WebhookVerificationKeyGetResponse
 */
export interface WebhookVerificationKeyGetResponse {
    [key: string]: object | any;
    /**
     *
     * @type {JWKPublicKey}
     * @memberof WebhookVerificationKeyGetResponse
     */
    key: JWKPublicKey;
    /**
     * A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.
     * @type {string}
     * @memberof WebhookVerificationKeyGetResponse
     */
    request_id: string;
}
/**
 * Year-to-date pre-tax earnings, as reported on the paystub.
 * @export
 * @interface YTDGrossIncomeSummaryFieldNumber
 */
export interface YTDGrossIncomeSummaryFieldNumber {
    /**
     * The value of the field.
     * @type {number}
     * @memberof YTDGrossIncomeSummaryFieldNumber
     */
    value: number;
    /**
     *
     * @type {VerificationStatus}
     * @memberof YTDGrossIncomeSummaryFieldNumber
     */
    verification_status: VerificationStatus;
}
/**
 * Year-to-date earnings after any tax withholdings, benefit payments or deductions, as reported on the paystub.
 * @export
 * @interface YTDNetIncomeSummaryFieldNumber
 */
export interface YTDNetIncomeSummaryFieldNumber {
    /**
     * The value of the field.
     * @type {number}
     * @memberof YTDNetIncomeSummaryFieldNumber
     */
    value: number;
    /**
     *
     * @type {VerificationStatus}
     * @memberof YTDNetIncomeSummaryFieldNumber
     */
    verification_status: VerificationStatus;
}
/**
 * PlaidApi - axios parameter creator
 * @export
 */
export declare const PlaidApiAxiosParamCreator: (configuration?: Configuration | undefined) => {
    /**
     * The `/accounts/balance/get` endpoint returns the real-time balance for each of an Item\'s accounts. While other endpoints may return a balance object, only `/accounts/balance/get` forces the available and current balance fields to be refreshed rather than cached. This endpoint can be used for existing Items that were added via any of Plaid’s other products. This endpoint can be used as long as Link has been initialized with any other product, `balance` itself is not a product that can be used to initialize Link.
     * @summary Retrieve real-time balance data
     * @param {AccountsBalanceGetRequest} accountsBalanceGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    accountsBalanceGet: (accountsBalanceGetRequest: AccountsBalanceGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/accounts/get` endpoint can be used to retrieve a list of accounts associated with any linked Item. Plaid will only return active bank accounts — that is, accounts that are not closed and are capable of carrying a balance.  This endpoint only returns accounts that were permissioned by the user when they initially created the Item. If a user creates a new account after the initial link, you can capture this event through the [`NEW_ACCOUNTS_AVAILABLE`](https://plaid.com/docs/api/webhooks/#item-new_accounts_available) webhook and then use Link\'s [update mode](https://plaid.com/docs/link/update-mode/) to request that the user share this new account with you.  This endpoint retrieves cached information, rather than extracting fresh information from the institution. As a result, balances returned may not be up-to-date; for realtime balance information, use `/accounts/balance/get` instead. Note that some information is nullable.
     * @summary Retrieve accounts
     * @param {AccountsGetRequest} accountsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    accountsGet: (accountsGetRequest: AccountsGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Allows financial institutions to retrieve information about Plaid clients for the purpose of building control-tower experiences
     * @summary Retrieve information about a Plaid application
     * @param {ApplicationGetRequest} applicationGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    applicationGet: (applicationGetRequest: ApplicationGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Plaid can provide an Audit Copy of any Asset Report directly to a participating third party on your behalf. For example, Plaid can supply an Audit Copy directly to Fannie Mae on your behalf if you participate in the Day 1 Certainty™ program. An Audit Copy contains the same underlying data as the Asset Report.  To grant access to an Audit Copy, use the `/asset_report/audit_copy/create` endpoint to create an `audit_copy_token` and then pass that token to the third party who needs access. Each third party has its own `auditor_id`, for example `fannie_mae`. You’ll need to create a separate Audit Copy for each third party to whom you want to grant access to the Report.
     * @summary Create Asset Report Audit Copy
     * @param {AssetReportAuditCopyCreateRequest} assetReportAuditCopyCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyCreate: (assetReportAuditCopyCreateRequest: AssetReportAuditCopyCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/asset_report/audit_copy/get` allows auditors to get a copy of an Asset Report that was previously shared via the `/asset_report/audit_copy/create` endpoint.  The caller of `/asset_report/audit_copy/create` must provide the `audit_copy_token` to the auditor.  This token can then be used to call `/asset_report/audit_copy/create`.
     * @summary Retrieve an Asset Report Audit Copy
     * @param {AssetReportAuditCopyGetRequest} assetReportAuditCopyGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyGet: (assetReportAuditCopyGetRequest: AssetReportAuditCopyGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/asset_report/audit_copy/remove` endpoint allows you to remove an Audit Copy. Removing an Audit Copy invalidates the `audit_copy_token` associated with it, meaning both you and any third parties holding the token will no longer be able to use it to access Report data. Items associated with the Asset Report, the Asset Report itself and other Audit Copies of it are not affected and will remain accessible after removing the given Audit Copy.
     * @summary Remove Asset Report Audit Copy
     * @param {AssetReportAuditCopyRemoveRequest} assetReportAuditCopyRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyRemove: (assetReportAuditCopyRemoveRequest: AssetReportAuditCopyRemoveRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/asset_report/create` endpoint initiates the process of creating an Asset Report, which can then be retrieved by passing the `asset_report_token` return value to the `/asset_report/get` or `/asset_report/pdf/get` endpoints.  The Asset Report takes some time to be created and is not available immediately after calling `/asset_report/create`. When the Asset Report is ready to be retrieved using `/asset_report/get` or `/asset_report/pdf/get`, Plaid will fire a `PRODUCT_READY` webhook. For full details of the webhook schema, see [Asset Report webhooks](https://plaid.com/docs/api/webhooks/#assets-webhooks).  The `/asset_report/create` endpoint creates an Asset Report at a moment in time. Asset Reports are immutable. To get an updated Asset Report, use the `/asset_report/refresh` endpoint.
     * @summary Create an Asset Report
     * @param {AssetReportCreateRequest} assetReportCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportCreate: (assetReportCreateRequest: AssetReportCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * By default, an Asset Report will contain all of the accounts on a given Item. In some cases, you may not want the Asset Report to contain all accounts. For example, you might have the end user choose which accounts are relevant in Link using the Account Select view, which you can enable in the dashboard. Or, you might always exclude certain account types or subtypes, which you can identify by using the `/accounts/get` endpoint. To narrow an Asset Report to only a subset of accounts, use the `/asset_report/filter` endpoint.  To exclude certain Accounts from an Asset Report, first use the `/asset_report/create` endpoint to create the report, then send the `asset_report_token` along with a list of `account_ids` to exclude to the `/asset_report/filter` endpoint, to create a new Asset Report which contains only a subset of the original Asset Report\'s data.  Because Asset Reports are immutable, calling `/asset_report/filter` does not alter the original Asset Report in any way; rather, `/asset_report/filter` creates a new Asset Report with a new token and id. Asset Reports created via `/asset_report/filter` do not contain new Asset data, and are not billed.  Plaid will fire a [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook once generation of the filtered Asset Report has completed.
     * @summary Filter Asset Report
     * @param {AssetReportFilterRequest} assetReportFilterRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportFilter: (assetReportFilterRequest: AssetReportFilterRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/asset_report/get` endpoint retrieves the Asset Report in JSON format. Before calling `/asset_report/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook to fire, indicating that the Report is ready to be retrieved.  By default, an Asset Report includes transaction descriptions as returned by the bank, as opposed to parsed and categorized by Plaid. You can also receive cleaned and categorized transactions, as well as additional insights like merchant name or location information. We call this an Asset Report with Insights. An Asset Report with Insights provides transaction category, location, and merchant information in addition to the transaction strings provided in a standard Asset Report.  To retrieve an Asset Report with Insights, call the `/asset_report/get` endpoint with `include_insights` set to `true`.
     * @summary Retrieve an Asset Report
     * @param {AssetReportGetRequest} assetReportGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportGet: (assetReportGetRequest: AssetReportGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/asset_report/pdf/get` endpoint retrieves the Asset Report in PDF format. Before calling `/asset_report/pdf/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook to fire, indicating that the Report is ready to be retrieved.  The response to `/asset_report/pdf/get` is the PDF binary data. The `request_id`  is returned in the `Plaid-Request-ID` header.  [View a sample PDF Asset Report](https://plaid.com/documents/sample-asset-report.pdf).
     * @summary Retrieve a PDF Asset Report
     * @param {AssetReportPDFGetRequest} assetReportPDFGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportPdfGet: (assetReportPDFGetRequest: AssetReportPDFGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * An Asset Report is an immutable snapshot of a user\'s assets. In order to \"refresh\" an Asset Report you created previously, you can use the `/asset_report/refresh` endpoint to create a new Asset Report based on the old one, but with the most recent data available.  The new Asset Report will contain the same Items as the original Report, as well as the same filters applied by any call to `/asset_report/filter`. By default, the new Asset Report will also use the same parameters you submitted with your original `/asset_report/create` request, but the original `days_requested` value and the values of any parameters in the `options` object can be overridden with new values. To change these arguments, simply supply new values for them in your request to `/asset_report/refresh`. Submit an empty string (\"\") for any previously-populated fields you would like set as empty.
     * @summary Refresh an Asset Report
     * @param {AssetReportRefreshRequest} assetReportRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportRefresh: (assetReportRefreshRequest: AssetReportRefreshRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/item/remove` endpoint allows you to invalidate an `access_token`, meaning you will not be able to create new Asset Reports with it. Removing an Item does not affect any Asset Reports or Audit Copies you have already created, which will remain accessible until you remove them specifically.  The `/asset_report/remove` endpoint allows you to remove an Asset Report. Removing an Asset Report invalidates its `asset_report_token`, meaning you will no longer be able to use it to access Report data or create new Audit Copies. Removing an Asset Report does not affect the underlying Items, but does invalidate any `audit_copy_tokens` associated with the Asset Report.
     * @summary Delete an Asset Report
     * @param {AssetReportRemoveRequest} assetReportRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportRemove: (assetReportRemoveRequest: AssetReportRemoveRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/auth/get` endpoint returns the bank account and bank identification numbers (such as routing numbers, for US accounts) associated with an Item\'s checking and savings accounts, along with high-level account data and balances when available.  Note: This request may take some time to complete if `auth` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.  Also note that `/auth/get` will not return data for any new accounts opened after the Item was created. To obtain data for new accounts, create a new Item.  Versioning note: In API version 2017-03-08, the schema of the `numbers` object returned by this endpoint is substantially different. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2018-05-22).
     * @summary Retrieve auth data
     * @param {AuthGetRequest} authGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authGet: (authGetRequest: AuthGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/bank_transfer/balance/get` endpoint to see the available balance in your bank transfer account. Debit transfers increase this balance once their status is posted. Credit transfers decrease this balance when they are created.  The transactable balance shows the amount in your account that you are able to use for transfers, and is essentially your available balance minus your minimum balance.  Note that this endpoint can only be used with FBO accounts, when using Bank Transfers in the Full Service configuration. It cannot be used on your own account when using Bank Transfers in the BTS Platform configuration.
     * @summary Get balance of your Bank Transfer account
     * @param {BankTransferBalanceGetRequest} bankTransferBalanceGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferBalanceGet: (bankTransferBalanceGetRequest: BankTransferBalanceGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/bank_transfer/cancel` endpoint to cancel a bank transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/bank_transfer/get` is `true`.
     * @summary Cancel a bank transfer
     * @param {BankTransferCancelRequest} bankTransferCancelRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferCancel: (bankTransferCancelRequest: BankTransferCancelRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/bank_transfer/create` endpoint to initiate a new bank transfer.
     * @summary Create a bank transfer
     * @param {BankTransferCreateRequest} bankTransferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferCreate: (bankTransferCreateRequest: BankTransferCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/bank_transfer/event/list` endpoint to get a list of bank transfer events based on specified filter criteria.
     * @summary List bank transfer events
     * @param {BankTransferEventListRequest} bankTransferEventListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferEventList: (bankTransferEventListRequest: BankTransferEventListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/bank_transfer/event/sync` allows you to request up to the next 25 bank transfer events that happened after a specific `event_id`. Use the `/bank_transfer/event/sync` endpoint to guarantee you have seen all bank transfer events.
     * @summary Sync bank transfer events
     * @param {BankTransferEventSyncRequest} bankTransferEventSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferEventSync: (bankTransferEventSyncRequest: BankTransferEventSyncRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/bank_transfer/get` fetches information about the bank transfer corresponding to the given `bank_transfer_id`.
     * @summary Retrieve a bank transfer
     * @param {BankTransferGetRequest} bankTransferGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferGet: (bankTransferGetRequest: BankTransferGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/bank_transfer/list` endpoint to see a list of all your bank transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired bank transfers.
     * @summary List bank transfers
     * @param {BankTransferListRequest} bankTransferListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferList: (bankTransferListRequest: BankTransferListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * As an alternative to adding Items via Link, you can also use the `/bank_transfer/migrate_account` endpoint to migrate known account and routing numbers to Plaid Items.  Note that Items created in this way are not compatible with endpoints for other products, such as `/accounts/balance/get`, and can only be used with Bank Transfer endpoints.  If you require access to other endpoints, create the Item through Link instead.  Access to `/bank_transfer/migrate_account` is not enabled by default; to obtain access, contact your Plaid Account Manager.
     * @summary Migrate account into Bank Transfers
     * @param {BankTransferMigrateAccountRequest} bankTransferMigrateAccountRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferMigrateAccount: (bankTransferMigrateAccountRequest: BankTransferMigrateAccountRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/bank_transfer/sweep/get` endpoint fetches information about the sweep corresponding to the given `sweep_id`.
     * @summary Retrieve a sweep
     * @param {BankTransferSweepGetRequest} bankTransferSweepGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferSweepGet: (bankTransferSweepGetRequest: BankTransferSweepGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/bank_transfer/sweep/list` endpoint fetches information about the sweeps matching the given filters.
     * @summary List sweeps
     * @param {BankTransferSweepListRequest} bankTransferSweepListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferSweepList: (bankTransferSweepListRequest: BankTransferSweepListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Send a request to the `/categories/get` endpoint to get detailed information on categories returned by Plaid. This endpoint does not require authentication.
     * @summary Get Categories
     * @param {object} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    categoriesGet: (body: object, options?: any) => Promise<RequestArgs>;
    /**
     * The `/payment_initiation/payment/token/create` endpoint has been deprecated. New Plaid customers will be unable to use this endpoint, and existing customers are encouraged to migrate to the newer, `link_token`-based flow. The recommended flow is to provide the `payment_id` to `/link/token/create`, which returns a `link_token` used to initialize Link.  The `/payment_initiation/payment/token/create` is used to create a `payment_token`, which can then be used in Link initialization to enter a payment initiation flow. You can only use a `payment_token` once. If this attempt fails, the end user aborts the flow, or the token expires, you will need to create a new payment token. Creating a new payment token does not require end user input.
     * @summary Create payment token
     * @param {PaymentInitiationPaymentTokenCreateRequest} paymentInitiationPaymentTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPaymentToken: (paymentInitiationPaymentTokenCreateRequest: PaymentInitiationPaymentTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * This endpoint provides an alternative to `/deposit_switch/create` for customers who have not yet fully integrated with Plaid Exchange. Like `/deposit_switch/create`, it creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.
     * @summary Create a deposit switch without using Plaid Exchange
     * @param {DepositSwitchAltCreateRequest} depositSwitchAltCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchAltCreate: (depositSwitchAltCreateRequest: DepositSwitchAltCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * This endpoint creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.
     * @summary Create a deposit switch
     * @param {DepositSwitchCreateRequest} depositSwitchCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchCreate: (depositSwitchCreateRequest: DepositSwitchCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * This endpoint returns information related to how the user has configured their payroll allocation and the state of the switch. You can use this information to build logic related to the user\'s direct deposit allocation preferences.
     * @summary Retrieve a deposit switch
     * @param {DepositSwitchGetRequest} depositSwitchGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchGet: (depositSwitchGetRequest: DepositSwitchGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * In order for the end user to take action, you will need to create a public token representing the deposit switch. This token is used to initialize Link. It can be used one time and expires after 30 minutes.
     * @summary Create a deposit switch token
     * @param {DepositSwitchTokenCreateRequest} depositSwitchTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchTokenCreate: (depositSwitchTokenCreateRequest: DepositSwitchTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/employers/search` allows you the ability to search Plaid’s database of known employers, for use with Deposit Switch. You can use this endpoint to look up a user\'s employer in order to confirm that they are supported. Users with non-supported employers can then be routed out of the Deposit Switch flow.  The data in the employer database is currently limited. As the Deposit Switch and Income products progress through their respective beta periods, more employers are being regularly added. Because the employer database is frequently updated, we recommend that you do not cache or store data from this endpoint for more than a day.
     * @summary Search employer database
     * @param {EmployersSearchRequest} employersSearchRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    employersSearch: (employersSearchRequest: EmployersSearchRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/employment/verification/get` returns a list of employments through a user payroll that was verified by an end user.
     * @summary Retrieve a summary of an individual\'s employment information
     * @param {EmploymentVerificationGetRequest} employmentVerificationGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    employmentVerificationGet: (employmentVerificationGetRequest: EmploymentVerificationGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses. Only name data is guaranteed to be returned; other fields will be empty arrays if not provided by the institution.  Note: This request may take some time to complete if identity was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.
     * @summary Retrieve identity data
     * @param {IdentityGetRequest} identityGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    identityGet: (identityGetRequest: IdentityGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/income/verification/create` begins the income verification process by returning an `income_verification_id`. You can then provide the `income_verification_id` to `/link/token/create` under the `income_verification` parameter in order to create a Link instance that will prompt the user to go through the income verification flow. Plaid will fire an `INCOME` webhook once the user completes the Payroll Income flow, or when the uploaded documents in the Document Income flow have finished processing.
     * @summary (Deprecated) Create an income verification instance
     * @param {IncomeVerificationCreateRequest} incomeVerificationCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationCreate: (incomeVerificationCreateRequest: IncomeVerificationCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/income/verification/documents/download` provides the ability to download the source documents associated with the verification.  If Document Income was used, the documents will be those the user provided in Link. For Payroll Income, the most recent files available for download from the payroll provider will be available from this endpoint.  The response to `/income/verification/documents/download` is a ZIP file in binary data. If a `document_id` is passed, a single document will be contained in this file. If not, the response will contain all documents associated with the verification.  The `request_id` is returned in the `Plaid-Request-ID` header.
     * @summary Download the original documents used for income verification
     * @param {IncomeVerificationDocumentsDownloadRequest} incomeVerificationDocumentsDownloadRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationDocumentsDownload: (incomeVerificationDocumentsDownloadRequest: IncomeVerificationDocumentsDownloadRequest, options?: any) => Promise<RequestArgs>;
    /**
     * /income/verification/paystub/get returns information from a single paystub used for income verification
     * @summary (Deprecated) Retrieve information from a single paystub used for income verification
     * @param {IncomeVerificationPaystubGetRequest} incomeVerificationPaystubGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPaystubGet: (incomeVerificationPaystubGetRequest: IncomeVerificationPaystubGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/income/verification/paystubs/get` returns the information collected from the paystubs that were used to verify an end user\'s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary Retrieve information from the paystubs used for income verification
     * @param {IncomeVerificationPaystubsGetRequest} incomeVerificationPaystubsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPaystubsGet: (incomeVerificationPaystubsGetRequest: IncomeVerificationPaystubsGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/income/verification/precheck` is an optional endpoint that can be called before initializing a Link session for income verification. It evaluates whether a given user is supportable by digital income verification and returns a `precheck_id` that can be provided to `/link/token/create`. If the user is eligible for digital verification, providing the `precheck_id` in this way will generate a Link UI optimized for the end user and their specific employer. If the user cannot be confirmed as eligible, the `precheck_id` can still be provided to `/link/token/create` and the user can still use the income verification flow, but they may be required to manually upload a paystub to verify their income.  While all request fields are optional, providing either `employer` or `transactions_access_tokens` data will increase the chance of receiving a useful result.
     * @summary Check digital income verification eligibility and optimize conversion
     * @param {IncomeVerificationPrecheckRequest} incomeVerificationPrecheckRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPrecheck: (incomeVerificationPrecheckRequest: IncomeVerificationPrecheckRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/income/verification/refresh` refreshes a given income verification.
     * @summary Refresh an income verification
     * @param {IncomeVerificationRefreshRequest} incomeVerificationRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationRefresh: (incomeVerificationRefreshRequest: IncomeVerificationRefreshRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/income/verification/summary/get` returns a verification summary for the income that was verified for an end user. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary (Deprecated) Retrieve a summary of information derived from income verification
     * @param {IncomeVerificationSummaryGetRequest} incomeVerificationSummaryGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationSummaryGet: (incomeVerificationSummaryGetRequest: IncomeVerificationSummaryGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/income/verification/taxforms/get` returns the information collected from forms that were used to verify an end user\'s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary Retrieve information from the tax documents used for income verification
     * @param {{ [key: string]: object; }} requestBody
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationTaxformsGet: (requestBody: {
        [key: string]: object;
    }, options?: any) => Promise<RequestArgs>;
    /**
     * Returns a JSON response containing details on all financial institutions currently supported by Plaid. Because Plaid supports thousands of institutions, results are paginated.  If there is no overlap between an institution’s enabled products and a client’s enabled products, then the institution will be filtered out from the response. As a result, the number of institutions returned may not match the count specified in the call.
     * @summary Get details of all supported institutions
     * @param {InstitutionsGetRequest} institutionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsGet: (institutionsGetRequest: InstitutionsGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Returns a JSON response containing details on a specified financial institution currently supported by Plaid.   Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` to authenticate to this endpoint. The `public_key` has been deprecated; all customers are encouraged to use `client_id` and `secret` instead.
     * @summary Get details of an institution
     * @param {InstitutionsGetByIdRequest} institutionsGetByIdRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsGetById: (institutionsGetByIdRequest: InstitutionsGetByIdRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Returns a JSON response containing details for institutions that match the query parameters, up to a maximum of ten institutions per query.  Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` parameters to authenticate to this endpoint. The `public_key` parameter has since been deprecated; all customers are encouraged to use `client_id` and `secret` instead.
     * @summary Search institutions
     * @param {InstitutionsSearchRequest} institutionsSearchRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsSearch: (institutionsSearchRequest: InstitutionsSearchRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/investments/holdings/get` endpoint allows developers to receive user-authorized stock position data for `investment`-type accounts.
     * @summary Get Investment holdings
     * @param {InvestmentsHoldingsGetRequest} investmentsHoldingsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    investmentsHoldingsGet: (investmentsHoldingsGetRequest: InvestmentsHoldingsGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/investments/transactions/get` endpoint allows developers to retrieve user-authorized transaction data for investment accounts.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Due to the potentially large number of investment transactions associated with an Item, results are paginated. Manipulate the count and offset parameters in conjunction with the `total_investment_transactions` response body field to fetch all available investment transactions.
     * @summary Get investment transactions
     * @param {InvestmentsTransactionsGetRequest} investmentsTransactionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    investmentsTransactionsGet: (investmentsTransactionsGetRequest: InvestmentsTransactionsGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * By default, the `access_token` associated with an Item does not expire and should be stored in a persistent, secure manner.  You can use the `/item/access_token/invalidate` endpoint to rotate the `access_token` associated with an Item. The endpoint returns a new `access_token` and immediately invalidates the previous `access_token`.
     * @summary Invalidate access_token
     * @param {ItemAccessTokenInvalidateRequest} itemAccessTokenInvalidateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemAccessTokenInvalidate: (itemAccessTokenInvalidateRequest: ItemAccessTokenInvalidateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * List a user’s connected applications
     * @summary List a user’s connected applications
     * @param {ItemApplicationListRequest} itemApplicationListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemApplicationList: (itemApplicationListRequest: ItemApplicationListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Enable consumers to update product access on selected accounts for an application.
     * @summary Update the scopes of access for a particular application
     * @param {ItemApplicationScopesUpdateRequest} itemApplicationScopesUpdateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemApplicationScopesUpdate: (itemApplicationScopesUpdateRequest: ItemApplicationScopesUpdateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Note: As of July 2020, the `/item/public_token/create` endpoint is deprecated. Instead, use `/link/token/create` with an `access_token` to create a Link token for use with [update mode](https://plaid.com/docs/link/update-mode).  If you need your user to take action to restore or resolve an error associated with an Item, generate a public token with the `/item/public_token/create` endpoint and then initialize Link with that `public_token`.  A `public_token` is one-time use and expires after 30 minutes. You use a `public_token` to initialize Link in [update mode](https://plaid.com/docs/link/update-mode) for a particular Item. You can generate a `public_token` for an Item even if you did not use Link to create the Item originally.  The `/item/public_token/create` endpoint is **not** used to create your initial `public_token`. If you have not already received an `access_token` for a specific Item, use Link to obtain your `public_token` instead. See the [Quickstart](https://plaid.com/docs/quickstart) for more information.
     * @summary Create public token
     * @param {ItemPublicTokenCreateRequest} itemPublicTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemCreatePublicToken: (itemPublicTokenCreateRequest: ItemPublicTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Returns information about the status of an Item.
     * @summary Retrieve an Item
     * @param {ItemGetRequest} itemGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemGet: (itemGetRequest: ItemGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/item/import` creates an Item via your Plaid Exchange Integration and returns an `access_token`. As part of an `/item/import` request, you will include a User ID (`user_auth.user_id`) and Authentication Token (`user_auth.auth_token`) that enable data aggregation through your Plaid Exchange API endpoints. These authentication principals are to be chosen by you.  Upon creating an Item via `/item/import`, Plaid will automatically begin an extraction of that Item through the Plaid Exchange infrastructure you have already integrated. This will automatically generate the Plaid native account ID for the account the user will switch their direct deposit to (`target_account_id`).
     * @summary Import Item
     * @param {ItemImportRequest} itemImportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemImport: (itemImportRequest: ItemImportRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Exchange a Link `public_token` for an API `access_token`. Link hands off the `public_token` client-side via the `onSuccess` callback once a user has successfully created an Item. The `public_token` is ephemeral and expires after 30 minutes.  The response also includes an `item_id` that should be stored with the `access_token`. The `item_id` is used to identify an Item in a webhook. The `item_id` can also be retrieved by making an `/item/get` request.
     * @summary Exchange public token for an access token
     * @param {ItemPublicTokenExchangeRequest} itemPublicTokenExchangeRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemPublicTokenExchange: (itemPublicTokenExchangeRequest: ItemPublicTokenExchangeRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/item/remove`  endpoint allows you to remove an Item. Once removed, the `access_token`  associated with the Item is no longer valid and cannot be used to access any data that was associated with the Item.  Note that in the Development environment, issuing an `/item/remove`  request will not decrement your live credential count. To increase your credential account in Development, contact Support.  Also note that for certain OAuth-based institutions, an Item removed via `/item/remove` may still show as an active connection in the institution\'s OAuth permission manager.  API versions 2019-05-29 and earlier return a `removed` boolean as part of the response.
     * @summary Remove an Item
     * @param {ItemRemoveRequest} itemRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemRemove: (itemRemoveRequest: ItemRemoveRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The POST `/item/webhook/update` allows you to update the webhook URL associated with an Item. This request triggers a [`WEBHOOK_UPDATE_ACKNOWLEDGED`](https://plaid.com/docs/api/webhooks/#item-webhook-update-acknowledged) webhook to the newly specified webhook URL.
     * @summary Update Webhook URL
     * @param {ItemWebhookUpdateRequest} itemWebhookUpdateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemWebhookUpdate: (itemWebhookUpdateRequest: ItemWebhookUpdateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/liabilities/get` endpoint returns various details about an Item with loan or credit accounts. Liabilities data is available primarily for US financial institutions, with some limited coverage of Canadian institutions. Currently supported account types are account type `credit` with account subtype `credit card` or `paypal`, and account type `loan` with account subtype `student` or `mortgage`. To limit accounts listed in Link to types and subtypes supported by Liabilities, you can use the `account_filters` parameter when [creating a Link token](https://plaid.com/docs/api/tokens/#linktokencreate).  The types of information returned by Liabilities can include balances and due dates, loan terms, and account details such as original loan amount and guarantor. Data is refreshed approximately once per day; the latest data can be retrieved by calling `/liabilities/get`.  Note: This request may take some time to complete if `liabilities` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the additional data.
     * @summary Retrieve Liabilities data
     * @param {LiabilitiesGetRequest} liabilitiesGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    liabilitiesGet: (liabilitiesGetRequest: LiabilitiesGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/link/token/create` endpoint creates a `link_token`, which is required as a parameter when initializing Link. Once Link has been initialized, it returns a `public_token`, which can then be exchanged for an `access_token` via `/item/public_token/exchange` as part of the main Link flow.  A `link_token` generated by `/link/token/create` is also used to initialize other Link flows, such as the update mode flow for tokens with expired credentials, or the Payment Initiation (Europe) flow.
     * @summary Create Link Token
     * @param {LinkTokenCreateRequest} linkTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    linkTokenCreate: (linkTokenCreateRequest: LinkTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/link/token/get` endpoint gets information about a previously-created `link_token` using the `/link/token/create` endpoint. It can be useful for debugging purposes.
     * @summary Get Link Token
     * @param {LinkTokenGetRequest} linkTokenGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    linkTokenGet: (linkTokenGetRequest: LinkTokenGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * After creating a payment recipient, you can use the `/payment_initiation/payment/create` endpoint to create a payment to that recipient.  Payments can be one-time or standing order (recurring) and can be denominated in either EUR or GBP.  If making domestic GBP-denominated payments, your recipient must have been created with BACS numbers. In general, EUR-denominated payments will be sent via SEPA Credit Transfer and GBP-denominated payments will be sent via the Faster Payments network, but the payment network used will be determined by the institution. Payments sent via Faster Payments will typically arrive immediately, while payments sent via SEPA Credit Transfer will typically arrive in one business day.  Standing orders (recurring payments) must be denominated in GBP and can only be sent to recipients in the UK. Once created, standing order payments cannot be modified or canceled via the API. An end user can cancel or modify a standing order directly on their banking application or website, or by contacting the bank. Standing orders will follow the payment rules of the underlying rails (Faster Payments in UK). Payments can be sent Monday to Friday, excluding bank holidays. If the pre-arranged date falls on a weekend or bank holiday, the payment is made on the next working day. It is not possible to guarantee the exact time the payment will reach the recipient’s account, although at least 90% of standing order payments are sent by 6am.  In the Development environment, payments must be below 5 GBP / EUR. For details on any payment limits in Production, contact your Plaid Account Manager.
     * @summary Create a payment
     * @param {PaymentInitiationPaymentCreateRequest} paymentInitiationPaymentCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentCreate: (paymentInitiationPaymentCreateRequest: PaymentInitiationPaymentCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/payment_initiation/payment/get` endpoint can be used to check the status of a payment, as well as to receive basic information such as recipient and payment amount. In the case of standing orders, the `/payment_initiation/payment/get` endpoint will provide information about the status of the overall standing order itself; the API cannot be used to retrieve payment status for individual payments within a standing order.
     * @summary Get payment details
     * @param {PaymentInitiationPaymentGetRequest} paymentInitiationPaymentGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentGet: (paymentInitiationPaymentGetRequest: PaymentInitiationPaymentGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/payment_initiation/payment/list` endpoint can be used to retrieve all created payments. By default, the 10 most recent payments are returned. You can request more payments and paginate through the results using the optional `count` and `cursor` parameters.
     * @summary List payments
     * @param {PaymentInitiationPaymentListRequest} paymentInitiationPaymentListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentList: (paymentInitiationPaymentListRequest: PaymentInitiationPaymentListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Reverse a previously initiated payment.  A payment can only be reversed once and will be refunded to the original sender\'s account.
     * @summary Reverse an existing payment
     * @param {PaymentInitiationPaymentReverseRequest} paymentInitiationPaymentReverseRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentReverse: (paymentInitiationPaymentReverseRequest: PaymentInitiationPaymentReverseRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Create a payment recipient for payment initiation.  The recipient must be in Europe, within a country that is a member of the Single Euro Payment Area (SEPA).  For a standing order (recurring) payment, the recipient must be in the UK.  The endpoint is idempotent: if a developer has already made a request with the same payment details, Plaid will return the same `recipient_id`.
     * @summary Create payment recipient
     * @param {PaymentInitiationRecipientCreateRequest} paymentInitiationRecipientCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientCreate: (paymentInitiationRecipientCreateRequest: PaymentInitiationRecipientCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Get details about a payment recipient you have previously created.
     * @summary Get payment recipient
     * @param {PaymentInitiationRecipientGetRequest} paymentInitiationRecipientGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientGet: (paymentInitiationRecipientGetRequest: PaymentInitiationRecipientGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/payment_initiation/recipient/list` endpoint list the payment recipients that you have previously created.
     * @summary List payment recipients
     * @param {PaymentInitiationRecipientListRequest} paymentInitiationRecipientListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientList: (paymentInitiationRecipientListRequest: PaymentInitiationRecipientListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Used to create a token suitable for sending to Apex to enable Plaid-Apex integrations.
     * @summary Create Apex bank account token
     * @param {ProcessorApexProcessorTokenCreateRequest} processorApexProcessorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorApexProcessorTokenCreate: (processorApexProcessorTokenCreateRequest: ProcessorApexProcessorTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/processor/auth/get` endpoint returns the bank account and bank identification number (such as the routing number, for US accounts), for a checking or savings account that\'\'s associated with a given `processor_token`. The endpoint also returns high-level account data and balances when available.   Versioning note: API versions 2019-05-29 and earlier use a different schema for the `numbers` object returned by this endpoint. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2020-09-14).
     * @summary Retrieve Auth data
     * @param {ProcessorAuthGetRequest} processorAuthGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorAuthGet: (processorAuthGetRequest: ProcessorAuthGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/processor/balance/get` endpoint returns the real-time balance for each of an Item\'s accounts. While other endpoints may return a balance object, only `/processor/balance/get` forces the available and current balance fields to be refreshed rather than cached.
     * @summary Retrieve Balance data
     * @param {ProcessorBalanceGetRequest} processorBalanceGetRequest The &#x60;/processor/balance/get&#x60; endpoint returns the real-time balance for the account associated with a given &#x60;processor_token&#x60;.  The current balance is the total amount of funds in the account. The available balance is the current balance less any outstanding holds or debits that have not yet posted to the account.  Note that not all institutions calculate the available balance. In the event that available balance is unavailable from the institution, Plaid will return an available balance value of &#x60;null&#x60;.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorBalanceGet: (processorBalanceGetRequest: ProcessorBalanceGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/processor/bank_transfer/create` endpoint to initiate a new bank transfer as a processor
     * @summary Create a bank transfer as a processor
     * @param {ProcessorBankTransferCreateRequest} processorBankTransferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorBankTransferCreate: (processorBankTransferCreateRequest: ProcessorBankTransferCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/processor/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses.
     * @summary Retrieve Identity data
     * @param {ProcessorIdentityGetRequest} processorIdentityGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorIdentityGet: (processorIdentityGetRequest: ProcessorIdentityGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Used to create a token suitable for sending to Stripe to enable Plaid-Stripe integrations. For a detailed guide on integrating Stripe, see [Add Stripe to your app](https://plaid.com/docs/auth/partnerships/stripe/).
     * @summary Create Stripe bank account token
     * @param {ProcessorStripeBankAccountTokenCreateRequest} processorStripeBankAccountTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorStripeBankAccountTokenCreate: (processorStripeBankAccountTokenCreateRequest: ProcessorStripeBankAccountTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Used to create a token suitable for sending to one of Plaid\'s partners to enable integrations. Note that Stripe partnerships use bank account tokens instead; see `/processor/stripe/bank_account_token/create` for creating tokens for use with Stripe integrations.
     * @summary Create processor token
     * @param {ProcessorTokenCreateRequest} processorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorTokenCreate: (processorTokenCreateRequest: ProcessorTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/sandbox/bank_transfer/fire_webhook` endpoint to manually trigger a Bank Transfers webhook in the Sandbox environment.
     * @summary Manually fire a Bank Transfer webhook
     * @param {SandboxBankTransferFireWebhookRequest} sandboxBankTransferFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxBankTransferFireWebhook: (sandboxBankTransferFireWebhookRequest: SandboxBankTransferFireWebhookRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/sandbox/bank_transfer/simulate` endpoint to simulate a bank transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/bank_transfer/event/sync` or `/bank_transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.
     * @summary Simulate a bank transfer event in Sandbox
     * @param {SandboxBankTransferSimulateRequest} sandboxBankTransferSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxBankTransferSimulate: (sandboxBankTransferSimulateRequest: SandboxBankTransferSimulateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/sandbox/income/fire_webhook` endpoint to manually trigger an Income webhook in the Sandbox environment.
     * @summary Manually fire an Income webhook
     * @param {SandboxIncomeFireWebhookRequest} sandboxIncomeFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxIncomeFireWebhook: (sandboxIncomeFireWebhookRequest: SandboxIncomeFireWebhookRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/sandbox/item/fire_webhook` endpoint is used to test that code correctly handles webhooks. This endpoint can trigger a Transactions `DEFAULT_UPDATE` webhook to be fired for a given Sandbox Item. If the Item does not support Transactions, a `SANDBOX_PRODUCT_NOT_ENABLED` error will result. This endpoint can also trigger a `NEW_ACCOUNTS_AVAILABLE` webhook to be fired for a given Sandbox Item created with Account Select v2. Note that this endpoint is provided for developer ease-of-use and is not required for testing webhooks; webhooks will also fire in Sandbox under the same conditions that they would in Production or Development.
     * @summary Fire a test webhook
     * @param {SandboxItemFireWebhookRequest} sandboxItemFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemFireWebhook: (sandboxItemFireWebhookRequest: SandboxItemFireWebhookRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/sandbox/item/reset_login/` forces an Item into an `ITEM_LOGIN_REQUIRED` state in order to simulate an Item whose login is no longer valid. This makes it easy to test Link\'s [update mode](https://plaid.com/docs/link/update-mode) flow in the Sandbox environment.  After calling `/sandbox/item/reset_login`, You can then use Plaid Link update mode to restore the Item to a good state. An `ITEM_LOGIN_REQUIRED` webhook will also be fired after a call to this endpoint, if one is associated with the Item.   In the Sandbox, Items will transition to an `ITEM_LOGIN_REQUIRED` error state automatically after 30 days, even if this endpoint is not called.
     * @summary Force a Sandbox Item into an error state
     * @param {SandboxItemResetLoginRequest} sandboxItemResetLoginRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemResetLogin: (sandboxItemResetLoginRequest: SandboxItemResetLoginRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/sandbox/item/set_verification_status` endpoint can be used to change the verification status of an Item in in the Sandbox in order to simulate the Automated Micro-deposit flow.  Note that not all Plaid developer accounts are enabled for micro-deposit based verification by default. Your account must be enabled for this feature in order to test it in Sandbox. To enable this features or check your status, contact your account manager or [submit a product access Support ticket](https://dashboard.plaid.com/support/new/product-and-development/product-troubleshooting/request-product-access).  For more information on testing Automated Micro-deposits in Sandbox, see [Auth full coverage testing](https://plaid.com/docs/auth/coverage/testing#).
     * @summary Set verification status for Sandbox account
     * @param {SandboxItemSetVerificationStatusRequest} sandboxItemSetVerificationStatusRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemSetVerificationStatus: (sandboxItemSetVerificationStatusRequest: SandboxItemSetVerificationStatusRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Save the selected accounts when connecting to the Platypus Oauth institution
     * @summary Save the selected accounts when connecting to the Platypus Oauth institution
     * @param {SandboxOauthSelectAccountsRequest} sandboxOauthSelectAccountsRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxOauthSelectAccounts: (sandboxOauthSelectAccountsRequest: SandboxOauthSelectAccountsRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/sandbox/processor_token/create` endpoint to create a valid `processor_token` for an arbitrary institution ID and test credentials. The created `processor_token` corresponds to a new Sandbox Item. You can then use this `processor_token` with the `/processor/` API endpoints in Sandbox. You can also use `/sandbox/processor_token/create` with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data.
     * @summary Create a test Item and processor token
     * @param {SandboxProcessorTokenCreateRequest} sandboxProcessorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxProcessorTokenCreate: (sandboxProcessorTokenCreateRequest: SandboxProcessorTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/sandbox/public_token/create` endpoint to create a valid `public_token`  for an arbitrary institution ID, initial products, and test credentials. The created `public_token` maps to a new Sandbox Item. You can then call `/item/public_token/exchange` to exchange the `public_token` for an `access_token` and perform all API actions. `/sandbox/public_token/create` can also be used with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data. `/sandbox/public_token/create` cannot be used with OAuth institutions.
     * @summary Create a test Item
     * @param {SandboxPublicTokenCreateRequest} sandboxPublicTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxPublicTokenCreate: (sandboxPublicTokenCreateRequest: SandboxPublicTokenCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/sandbox/transfer/repayment/simulate` endpoint to trigger the creation of a repayment. As a side effect of calling this route, a repayment is created that includes all unreimbursed returns of guaranteed transfers. If there are no such returns, an 400 error is returned.
     * @summary Trigger the creation of a repayment
     * @param {SandboxTransferRepaymentSimulateRequest} sandboxTransferRepaymentSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferRepaymentSimulate: (sandboxTransferRepaymentSimulateRequest: SandboxTransferRepaymentSimulateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/sandbox/transfer/simulate` endpoint to simulate a transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/transfer/event/sync` or `/transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.
     * @summary Simulate a transfer event in Sandbox
     * @param {SandboxTransferSimulateRequest} sandboxTransferSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferSimulate: (sandboxTransferSimulateRequest: SandboxTransferSimulateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/sandbox/transfer/sweep/simulate` endpoint to create a sweep and associated events in the Sandbox environment. Upon calling this endpoint, all `posted` or `pending` transfers with a sweep status of `unswept` will become `swept`, and all `reversed` transfers with a sweep status of `swept` will become `reverse_swept`.
     * @summary Simulate creating a sweep
     * @param {SandboxTransferSweepSimulateRequest} sandboxTransferSweepSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferSweepSimulate: (sandboxTransferSweepSimulateRequest: SandboxTransferSweepSimulateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * After calling `/signal/evaluate`, call `/signal/decision/report` to report whether the transaction was initiated. This endpoint will return an `INVALID_REQUEST` error if called a second time with a different value for `initiated`.
     * @summary Report whether you initiated an ACH transaction
     * @param {SignalDecisionReportRequest} signalDecisionReportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalDecisionReport: (signalDecisionReportRequest: SignalDecisionReportRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use `/signal/evaluate` to evaluate a planned ACH transaction to get a return risk assessment (such as a risk score and risk tier) and additional risk signals.  In order to obtain a valid score for an ACH transaction, Plaid must have an access token for the account, and the Item must be healthy (receiving product updates) or have recently been in a healthy state. If the transaction does not meet eligibility requirements, an error will be returned corresponding to the underlying cause. If `/signal/evaluate` is called on the same transaction multiple times within a 24-hour period, cached results may be returned.
     * @summary Evaluate a planned ACH transaction
     * @param {SignalEvaluateRequest} signalEvaluateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalEvaluate: (signalEvaluateRequest: SignalEvaluateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Call the `/signal/return/report` endpoint to report a returned transaction that was previously sent to the `/signal/evaluate` endpoint. Your feedback will be used by the model to incorporate the latest risk trend in your portfolio.
     * @summary Report a return for an ACH transaction
     * @param {SignalReturnReportRequest} signalReturnReportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalReturnReport: (signalReturnReportRequest: SignalReturnReportRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/transactions/get` endpoint allows developers to receive user-authorized transaction data for credit, depository, and some loan-type accounts (only those with account subtype `student`; coverage may be limited). For transaction history from investments accounts, use the [Investments endpoint](https://plaid.com/docs/api/products#investments) instead. Transaction data is standardized across financial institutions, and in many cases transactions are linked to a clean name, entity type, location, and category. Similarly, account data is standardized and returned with a clean name, number, balance, and other meta information where available.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Transactions are not immutable and can also be removed altogether by the institution; a removed transaction will no longer appear in `/transactions/get`.  For more details, see [Pending and posted transactions](https://plaid.com/docs/transactions/transactions-data/#pending-and-posted-transactions).  Due to the potentially large number of transactions associated with an Item, results are paginated. Manipulate the `count` and `offset` parameters in conjunction with the `total_transactions` response body field to fetch all available transactions.  Data returned by `/transactions/get` will be the data available for the Item as of the most recent successful check for new transactions. Plaid typically checks for new data multiple times a day, but these checks may occur less frequently, such as once a day, depending on the institution. An Item\'s `status.transactions.last_successful_update` field will show the timestamp of the most recent successful update. To force Plaid to check for new transactions, you can use the `/transactions/refresh` endpoint.  Note that data may not be immediately available to `/transactions/get`. Plaid will begin to prepare transactions data upon Item link, if Link was initialized with `transactions`, or upon the first call to `/transactions/get`, if it wasn\'t. To be alerted when transaction data is ready to be fetched, listen for the [`INITIAL_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-initial_update) and [`HISTORICAL_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-historical_update) webhooks. If no transaction history is ready when `/transactions/get` is called, it will return a `PRODUCT_NOT_READY` error.
     * @summary Get transaction data
     * @param {TransactionsGetRequest} transactionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsGet: (transactionsGetRequest: TransactionsGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/transactions/recurring/get` endpoint identifies and returns groups of transactions that occur on a regular basis for the inputted Item and accounts.  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.
     * @summary Get streams of recurring transactions
     * @param {TransactionsRecurringGetRequest} transactionsRecurringGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsRecurringGet: (transactionsRecurringGetRequest: TransactionsRecurringGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/transactions/refresh` is an optional endpoint for users of the Transactions product. It initiates an on-demand extraction to fetch the newest transactions for an Item. This on-demand extraction takes place in addition to the periodic extractions that automatically occur multiple times a day for any Transactions-enabled Item. If changes to transactions are discovered after calling `/transactions/refresh`, Plaid will fire a webhook: [`TRANSACTIONS_REMOVED`](https://plaid.com/docs/api/webhooks#deleted-transactions-detected) will be fired if any removed transactions are detected, and [`DEFAULT_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-default_update) will be fired if any new transactions are detected. New transactions can be fetched by calling `/transactions/get`.  Access to `/transactions/refresh` in Production is specific to certain pricing plans. If you cannot access `/transactions/refresh` in Production, [contact Sales](https://www.plaid.com/contact) for assistance.
     * @summary Refresh transaction data
     * @param {TransactionsRefreshRequest} transactionsRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsRefresh: (transactionsRefreshRequest: TransactionsRefreshRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/transactions/sync` endpoint returns item transactions as a set of delta updates. Subsequent calls to the endpoint using the cursor returned in the response will return new added, modified, and removed transactions since the last call to the endpoint  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.
     * @summary Get incremental transaction updates on an Item
     * @param {TransactionsSyncRequest} transactionsSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsSync: (transactionsSyncRequest: TransactionsSyncRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/transfer/authorization/create` endpoint to determine transfer failure risk.  In Plaid\'s sandbox environment the decisions will be returned as follows:    - To approve a transfer, make an authorization request with an `amount` less than the available balance in the account.    - To decline a transfer with the rationale code `NSF`, the available balance on the account must be less than the authorization `amount`. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To decline a transfer with the rationale code `RISK`, the available balance on the account must be exactly $0. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To permit a transfer with the rationale code `MANUALLY_VERIFIED_ITEM`, create an Item in Link through the [Same Day Micro-deposits flow](https://plaid.com/docs/auth/coverage/testing/#testing-same-day-micro-deposits).    - To permit a transfer with the rationale code `LOGIN_REQUIRED`, [reset the login for an Item](https://plaid.com/docs/sandbox/#item_login_required).  All username/password combinations other than the ones listed above will result in a decision of permitted and rationale code `ERROR`.
     * @summary Create a transfer authorization
     * @param {TransferAuthorizationCreateRequest} transferAuthorizationCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferAuthorizationCreate: (transferAuthorizationCreateRequest: TransferAuthorizationCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/transfer/cancel` endpoint to cancel a transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/transfer/get` is `true`.
     * @summary Cancel a transfer
     * @param {TransferCancelRequest} transferCancelRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferCancel: (transferCancelRequest: TransferCancelRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/transfer/create` endpoint to initiate a new transfer.
     * @summary Create a transfer
     * @param {TransferCreateRequest} transferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferCreate: (transferCreateRequest: TransferCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/transfer/event/list` endpoint to get a list of transfer events based on specified filter criteria.
     * @summary List transfer events
     * @param {TransferEventListRequest} transferEventListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferEventList: (transferEventListRequest: TransferEventListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * `/transfer/event/sync` allows you to request up to the next 25 transfer events that happened after a specific `event_id`. Use the `/transfer/event/sync` endpoint to guarantee you have seen all transfer events.
     * @summary Sync transfer events
     * @param {TransferEventSyncRequest} transferEventSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferEventSync: (transferEventSyncRequest: TransferEventSyncRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/transfer/get` fetches information about the transfer corresponding to the given `transfer_id`.
     * @summary Retrieve a transfer
     * @param {TransferGetRequest} transferGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferGet: (transferGetRequest: TransferGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/transfer/intent/create` endpoint to generate a transfer intent object and invoke the Transfer UI.
     * @summary Create a transfer intent object to invoke the Transfer UI
     * @param {TransferIntentCreateRequest} transferIntentCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferIntentCreate: (transferIntentCreateRequest: TransferIntentCreateRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/transfer/intent/get` endpoint to retrieve more information about a transfer intent.
     * @summary Retrieve more information about a transfer intent
     * @param {{ [key: string]: object; }} requestBody
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferIntentGet: (requestBody: {
        [key: string]: object;
    }, options?: any) => Promise<RequestArgs>;
    /**
     * Use the `/transfer/list` endpoint to see a list of all your transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired transfers.
     * @summary List transfers
     * @param {TransferListRequest} transferListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferList: (transferListRequest: TransferListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/transfer/repayment/list` endpoint fetches repayments matching the given filters. Repayments are returned in reverse-chronological order (most recent first) starting at the given `start_time`.
     * @summary Lists historical repayments
     * @param {TransferRepaymentListRequest} transferRepaymentListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferRepaymentList: (transferRepaymentListRequest: TransferRepaymentListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/transfer/repayment/return/list` endpoint retrieves the set of returns that were batched together into the specified repayment. The sum of amounts of returns retrieved by this request equals the amount of the repayment.
     * @summary List the returns included in a repayment
     * @param {TransferRepaymentReturnListRequest} transferRepaymentReturnListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferRepaymentReturnList: (transferRepaymentReturnListRequest: TransferRepaymentReturnListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/transfer/sweep/get` endpoint fetches a sweep corresponding to the given `sweep_id`.
     * @summary Retrieve a sweep
     * @param {TransferSweepGetRequest} transferSweepGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferSweepGet: (transferSweepGetRequest: TransferSweepGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * The `/transfer/sweep/list` endpoint fetches sweeps matching the given filters.
     * @summary List sweeps
     * @param {TransferSweepListRequest} transferSweepListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferSweepList: (transferSweepListRequest: TransferSweepListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Fetch an e-wallet. The response includes the current balance.
     * @summary Fetch an e-wallet
     * @param {WalletGetRequest} walletGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletGet: (walletGetRequest: WalletGetRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Execute a transaction using the specified e-wallet. Specify the e-wallet to debit from, the counterparty to credit to, the idempotency key to prevent duplicate payouts, the amount and reference for the payout. The payouts are executed over the Faster Payment rails, where settlement usually only takes a few seconds.
     * @summary Execute a transaction using an e-wallet
     * @param {WalletTransactionExecuteRequest} walletTransactionExecuteRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletTransactionExecute: (walletTransactionExecuteRequest: WalletTransactionExecuteRequest, options?: any) => Promise<RequestArgs>;
    /**
     * This endpoint lists the latest transactions of the specified e-wallet. Transactions are returned in descending order by the `created_at` time.
     * @summary List e-wallet transactions
     * @param {WalletTransactionsListRequest} walletTransactionsListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletTransactionsList: (walletTransactionsListRequest: WalletTransactionsListRequest, options?: any) => Promise<RequestArgs>;
    /**
     * Plaid signs all outgoing webhooks and provides JSON Web Tokens (JWTs) so that you can verify the authenticity of any incoming webhooks to your application. A message signature is included in the `Plaid-Verification` header.  The `/webhook_verification_key/get` endpoint provides a JSON Web Key (JWK) that can be used to verify a JWT.
     * @summary Get webhook verification key
     * @param {WebhookVerificationKeyGetRequest} webhookVerificationKeyGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    webhookVerificationKeyGet: (webhookVerificationKeyGetRequest: WebhookVerificationKeyGetRequest, options?: any) => Promise<RequestArgs>;
};
/**
 * PlaidApi - functional programming interface
 * @export
 */
export declare const PlaidApiFp: (configuration?: Configuration | undefined) => {
    /**
     * The `/accounts/balance/get` endpoint returns the real-time balance for each of an Item\'s accounts. While other endpoints may return a balance object, only `/accounts/balance/get` forces the available and current balance fields to be refreshed rather than cached. This endpoint can be used for existing Items that were added via any of Plaid’s other products. This endpoint can be used as long as Link has been initialized with any other product, `balance` itself is not a product that can be used to initialize Link.
     * @summary Retrieve real-time balance data
     * @param {AccountsBalanceGetRequest} accountsBalanceGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    accountsBalanceGet(accountsBalanceGetRequest: AccountsBalanceGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AccountsGetResponse>>;
    /**
     * The `/accounts/get` endpoint can be used to retrieve a list of accounts associated with any linked Item. Plaid will only return active bank accounts — that is, accounts that are not closed and are capable of carrying a balance.  This endpoint only returns accounts that were permissioned by the user when they initially created the Item. If a user creates a new account after the initial link, you can capture this event through the [`NEW_ACCOUNTS_AVAILABLE`](https://plaid.com/docs/api/webhooks/#item-new_accounts_available) webhook and then use Link\'s [update mode](https://plaid.com/docs/link/update-mode/) to request that the user share this new account with you.  This endpoint retrieves cached information, rather than extracting fresh information from the institution. As a result, balances returned may not be up-to-date; for realtime balance information, use `/accounts/balance/get` instead. Note that some information is nullable.
     * @summary Retrieve accounts
     * @param {AccountsGetRequest} accountsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    accountsGet(accountsGetRequest: AccountsGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AccountsGetResponse>>;
    /**
     * Allows financial institutions to retrieve information about Plaid clients for the purpose of building control-tower experiences
     * @summary Retrieve information about a Plaid application
     * @param {ApplicationGetRequest} applicationGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    applicationGet(applicationGetRequest: ApplicationGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ApplicationGetResponse>>;
    /**
     * Plaid can provide an Audit Copy of any Asset Report directly to a participating third party on your behalf. For example, Plaid can supply an Audit Copy directly to Fannie Mae on your behalf if you participate in the Day 1 Certainty™ program. An Audit Copy contains the same underlying data as the Asset Report.  To grant access to an Audit Copy, use the `/asset_report/audit_copy/create` endpoint to create an `audit_copy_token` and then pass that token to the third party who needs access. Each third party has its own `auditor_id`, for example `fannie_mae`. You’ll need to create a separate Audit Copy for each third party to whom you want to grant access to the Report.
     * @summary Create Asset Report Audit Copy
     * @param {AssetReportAuditCopyCreateRequest} assetReportAuditCopyCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyCreate(assetReportAuditCopyCreateRequest: AssetReportAuditCopyCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AssetReportAuditCopyCreateResponse>>;
    /**
     * `/asset_report/audit_copy/get` allows auditors to get a copy of an Asset Report that was previously shared via the `/asset_report/audit_copy/create` endpoint.  The caller of `/asset_report/audit_copy/create` must provide the `audit_copy_token` to the auditor.  This token can then be used to call `/asset_report/audit_copy/create`.
     * @summary Retrieve an Asset Report Audit Copy
     * @param {AssetReportAuditCopyGetRequest} assetReportAuditCopyGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyGet(assetReportAuditCopyGetRequest: AssetReportAuditCopyGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AssetReportGetResponse>>;
    /**
     * The `/asset_report/audit_copy/remove` endpoint allows you to remove an Audit Copy. Removing an Audit Copy invalidates the `audit_copy_token` associated with it, meaning both you and any third parties holding the token will no longer be able to use it to access Report data. Items associated with the Asset Report, the Asset Report itself and other Audit Copies of it are not affected and will remain accessible after removing the given Audit Copy.
     * @summary Remove Asset Report Audit Copy
     * @param {AssetReportAuditCopyRemoveRequest} assetReportAuditCopyRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyRemove(assetReportAuditCopyRemoveRequest: AssetReportAuditCopyRemoveRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AssetReportAuditCopyRemoveResponse>>;
    /**
     * The `/asset_report/create` endpoint initiates the process of creating an Asset Report, which can then be retrieved by passing the `asset_report_token` return value to the `/asset_report/get` or `/asset_report/pdf/get` endpoints.  The Asset Report takes some time to be created and is not available immediately after calling `/asset_report/create`. When the Asset Report is ready to be retrieved using `/asset_report/get` or `/asset_report/pdf/get`, Plaid will fire a `PRODUCT_READY` webhook. For full details of the webhook schema, see [Asset Report webhooks](https://plaid.com/docs/api/webhooks/#assets-webhooks).  The `/asset_report/create` endpoint creates an Asset Report at a moment in time. Asset Reports are immutable. To get an updated Asset Report, use the `/asset_report/refresh` endpoint.
     * @summary Create an Asset Report
     * @param {AssetReportCreateRequest} assetReportCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportCreate(assetReportCreateRequest: AssetReportCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AssetReportCreateResponse>>;
    /**
     * By default, an Asset Report will contain all of the accounts on a given Item. In some cases, you may not want the Asset Report to contain all accounts. For example, you might have the end user choose which accounts are relevant in Link using the Account Select view, which you can enable in the dashboard. Or, you might always exclude certain account types or subtypes, which you can identify by using the `/accounts/get` endpoint. To narrow an Asset Report to only a subset of accounts, use the `/asset_report/filter` endpoint.  To exclude certain Accounts from an Asset Report, first use the `/asset_report/create` endpoint to create the report, then send the `asset_report_token` along with a list of `account_ids` to exclude to the `/asset_report/filter` endpoint, to create a new Asset Report which contains only a subset of the original Asset Report\'s data.  Because Asset Reports are immutable, calling `/asset_report/filter` does not alter the original Asset Report in any way; rather, `/asset_report/filter` creates a new Asset Report with a new token and id. Asset Reports created via `/asset_report/filter` do not contain new Asset data, and are not billed.  Plaid will fire a [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook once generation of the filtered Asset Report has completed.
     * @summary Filter Asset Report
     * @param {AssetReportFilterRequest} assetReportFilterRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportFilter(assetReportFilterRequest: AssetReportFilterRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AssetReportFilterResponse>>;
    /**
     * The `/asset_report/get` endpoint retrieves the Asset Report in JSON format. Before calling `/asset_report/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook to fire, indicating that the Report is ready to be retrieved.  By default, an Asset Report includes transaction descriptions as returned by the bank, as opposed to parsed and categorized by Plaid. You can also receive cleaned and categorized transactions, as well as additional insights like merchant name or location information. We call this an Asset Report with Insights. An Asset Report with Insights provides transaction category, location, and merchant information in addition to the transaction strings provided in a standard Asset Report.  To retrieve an Asset Report with Insights, call the `/asset_report/get` endpoint with `include_insights` set to `true`.
     * @summary Retrieve an Asset Report
     * @param {AssetReportGetRequest} assetReportGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportGet(assetReportGetRequest: AssetReportGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AssetReportGetResponse>>;
    /**
     * The `/asset_report/pdf/get` endpoint retrieves the Asset Report in PDF format. Before calling `/asset_report/pdf/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook to fire, indicating that the Report is ready to be retrieved.  The response to `/asset_report/pdf/get` is the PDF binary data. The `request_id`  is returned in the `Plaid-Request-ID` header.  [View a sample PDF Asset Report](https://plaid.com/documents/sample-asset-report.pdf).
     * @summary Retrieve a PDF Asset Report
     * @param {AssetReportPDFGetRequest} assetReportPDFGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportPdfGet(assetReportPDFGetRequest: AssetReportPDFGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<any>>;
    /**
     * An Asset Report is an immutable snapshot of a user\'s assets. In order to \"refresh\" an Asset Report you created previously, you can use the `/asset_report/refresh` endpoint to create a new Asset Report based on the old one, but with the most recent data available.  The new Asset Report will contain the same Items as the original Report, as well as the same filters applied by any call to `/asset_report/filter`. By default, the new Asset Report will also use the same parameters you submitted with your original `/asset_report/create` request, but the original `days_requested` value and the values of any parameters in the `options` object can be overridden with new values. To change these arguments, simply supply new values for them in your request to `/asset_report/refresh`. Submit an empty string (\"\") for any previously-populated fields you would like set as empty.
     * @summary Refresh an Asset Report
     * @param {AssetReportRefreshRequest} assetReportRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportRefresh(assetReportRefreshRequest: AssetReportRefreshRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AssetReportRefreshResponse>>;
    /**
     * The `/item/remove` endpoint allows you to invalidate an `access_token`, meaning you will not be able to create new Asset Reports with it. Removing an Item does not affect any Asset Reports or Audit Copies you have already created, which will remain accessible until you remove them specifically.  The `/asset_report/remove` endpoint allows you to remove an Asset Report. Removing an Asset Report invalidates its `asset_report_token`, meaning you will no longer be able to use it to access Report data or create new Audit Copies. Removing an Asset Report does not affect the underlying Items, but does invalidate any `audit_copy_tokens` associated with the Asset Report.
     * @summary Delete an Asset Report
     * @param {AssetReportRemoveRequest} assetReportRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportRemove(assetReportRemoveRequest: AssetReportRemoveRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AssetReportRemoveResponse>>;
    /**
     * The `/auth/get` endpoint returns the bank account and bank identification numbers (such as routing numbers, for US accounts) associated with an Item\'s checking and savings accounts, along with high-level account data and balances when available.  Note: This request may take some time to complete if `auth` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.  Also note that `/auth/get` will not return data for any new accounts opened after the Item was created. To obtain data for new accounts, create a new Item.  Versioning note: In API version 2017-03-08, the schema of the `numbers` object returned by this endpoint is substantially different. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2018-05-22).
     * @summary Retrieve auth data
     * @param {AuthGetRequest} authGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authGet(authGetRequest: AuthGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<AuthGetResponse>>;
    /**
     * Use the `/bank_transfer/balance/get` endpoint to see the available balance in your bank transfer account. Debit transfers increase this balance once their status is posted. Credit transfers decrease this balance when they are created.  The transactable balance shows the amount in your account that you are able to use for transfers, and is essentially your available balance minus your minimum balance.  Note that this endpoint can only be used with FBO accounts, when using Bank Transfers in the Full Service configuration. It cannot be used on your own account when using Bank Transfers in the BTS Platform configuration.
     * @summary Get balance of your Bank Transfer account
     * @param {BankTransferBalanceGetRequest} bankTransferBalanceGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferBalanceGet(bankTransferBalanceGetRequest: BankTransferBalanceGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferBalanceGetResponse>>;
    /**
     * Use the `/bank_transfer/cancel` endpoint to cancel a bank transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/bank_transfer/get` is `true`.
     * @summary Cancel a bank transfer
     * @param {BankTransferCancelRequest} bankTransferCancelRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferCancel(bankTransferCancelRequest: BankTransferCancelRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferCancelResponse>>;
    /**
     * Use the `/bank_transfer/create` endpoint to initiate a new bank transfer.
     * @summary Create a bank transfer
     * @param {BankTransferCreateRequest} bankTransferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferCreate(bankTransferCreateRequest: BankTransferCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferCreateResponse>>;
    /**
     * Use the `/bank_transfer/event/list` endpoint to get a list of bank transfer events based on specified filter criteria.
     * @summary List bank transfer events
     * @param {BankTransferEventListRequest} bankTransferEventListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferEventList(bankTransferEventListRequest: BankTransferEventListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferEventListResponse>>;
    /**
     * `/bank_transfer/event/sync` allows you to request up to the next 25 bank transfer events that happened after a specific `event_id`. Use the `/bank_transfer/event/sync` endpoint to guarantee you have seen all bank transfer events.
     * @summary Sync bank transfer events
     * @param {BankTransferEventSyncRequest} bankTransferEventSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferEventSync(bankTransferEventSyncRequest: BankTransferEventSyncRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferEventSyncResponse>>;
    /**
     * The `/bank_transfer/get` fetches information about the bank transfer corresponding to the given `bank_transfer_id`.
     * @summary Retrieve a bank transfer
     * @param {BankTransferGetRequest} bankTransferGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferGet(bankTransferGetRequest: BankTransferGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferGetResponse>>;
    /**
     * Use the `/bank_transfer/list` endpoint to see a list of all your bank transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired bank transfers.
     * @summary List bank transfers
     * @param {BankTransferListRequest} bankTransferListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferList(bankTransferListRequest: BankTransferListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferListResponse>>;
    /**
     * As an alternative to adding Items via Link, you can also use the `/bank_transfer/migrate_account` endpoint to migrate known account and routing numbers to Plaid Items.  Note that Items created in this way are not compatible with endpoints for other products, such as `/accounts/balance/get`, and can only be used with Bank Transfer endpoints.  If you require access to other endpoints, create the Item through Link instead.  Access to `/bank_transfer/migrate_account` is not enabled by default; to obtain access, contact your Plaid Account Manager.
     * @summary Migrate account into Bank Transfers
     * @param {BankTransferMigrateAccountRequest} bankTransferMigrateAccountRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferMigrateAccount(bankTransferMigrateAccountRequest: BankTransferMigrateAccountRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferMigrateAccountResponse>>;
    /**
     * The `/bank_transfer/sweep/get` endpoint fetches information about the sweep corresponding to the given `sweep_id`.
     * @summary Retrieve a sweep
     * @param {BankTransferSweepGetRequest} bankTransferSweepGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferSweepGet(bankTransferSweepGetRequest: BankTransferSweepGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferSweepGetResponse>>;
    /**
     * The `/bank_transfer/sweep/list` endpoint fetches information about the sweeps matching the given filters.
     * @summary List sweeps
     * @param {BankTransferSweepListRequest} bankTransferSweepListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferSweepList(bankTransferSweepListRequest: BankTransferSweepListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<BankTransferSweepListResponse>>;
    /**
     * Send a request to the `/categories/get` endpoint to get detailed information on categories returned by Plaid. This endpoint does not require authentication.
     * @summary Get Categories
     * @param {object} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    categoriesGet(body: object, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<CategoriesGetResponse>>;
    /**
     * The `/payment_initiation/payment/token/create` endpoint has been deprecated. New Plaid customers will be unable to use this endpoint, and existing customers are encouraged to migrate to the newer, `link_token`-based flow. The recommended flow is to provide the `payment_id` to `/link/token/create`, which returns a `link_token` used to initialize Link.  The `/payment_initiation/payment/token/create` is used to create a `payment_token`, which can then be used in Link initialization to enter a payment initiation flow. You can only use a `payment_token` once. If this attempt fails, the end user aborts the flow, or the token expires, you will need to create a new payment token. Creating a new payment token does not require end user input.
     * @summary Create payment token
     * @param {PaymentInitiationPaymentTokenCreateRequest} paymentInitiationPaymentTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPaymentToken(paymentInitiationPaymentTokenCreateRequest: PaymentInitiationPaymentTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<PaymentInitiationPaymentTokenCreateResponse>>;
    /**
     * This endpoint provides an alternative to `/deposit_switch/create` for customers who have not yet fully integrated with Plaid Exchange. Like `/deposit_switch/create`, it creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.
     * @summary Create a deposit switch without using Plaid Exchange
     * @param {DepositSwitchAltCreateRequest} depositSwitchAltCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchAltCreate(depositSwitchAltCreateRequest: DepositSwitchAltCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<DepositSwitchAltCreateResponse>>;
    /**
     * This endpoint creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.
     * @summary Create a deposit switch
     * @param {DepositSwitchCreateRequest} depositSwitchCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchCreate(depositSwitchCreateRequest: DepositSwitchCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<DepositSwitchCreateResponse>>;
    /**
     * This endpoint returns information related to how the user has configured their payroll allocation and the state of the switch. You can use this information to build logic related to the user\'s direct deposit allocation preferences.
     * @summary Retrieve a deposit switch
     * @param {DepositSwitchGetRequest} depositSwitchGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchGet(depositSwitchGetRequest: DepositSwitchGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<DepositSwitchGetResponse>>;
    /**
     * In order for the end user to take action, you will need to create a public token representing the deposit switch. This token is used to initialize Link. It can be used one time and expires after 30 minutes.
     * @summary Create a deposit switch token
     * @param {DepositSwitchTokenCreateRequest} depositSwitchTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchTokenCreate(depositSwitchTokenCreateRequest: DepositSwitchTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<DepositSwitchTokenCreateResponse>>;
    /**
     * `/employers/search` allows you the ability to search Plaid’s database of known employers, for use with Deposit Switch. You can use this endpoint to look up a user\'s employer in order to confirm that they are supported. Users with non-supported employers can then be routed out of the Deposit Switch flow.  The data in the employer database is currently limited. As the Deposit Switch and Income products progress through their respective beta periods, more employers are being regularly added. Because the employer database is frequently updated, we recommend that you do not cache or store data from this endpoint for more than a day.
     * @summary Search employer database
     * @param {EmployersSearchRequest} employersSearchRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    employersSearch(employersSearchRequest: EmployersSearchRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<EmployersSearchResponse>>;
    /**
     * `/employment/verification/get` returns a list of employments through a user payroll that was verified by an end user.
     * @summary Retrieve a summary of an individual\'s employment information
     * @param {EmploymentVerificationGetRequest} employmentVerificationGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    employmentVerificationGet(employmentVerificationGetRequest: EmploymentVerificationGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<EmploymentVerificationGetResponse>>;
    /**
     * The `/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses. Only name data is guaranteed to be returned; other fields will be empty arrays if not provided by the institution.  Note: This request may take some time to complete if identity was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.
     * @summary Retrieve identity data
     * @param {IdentityGetRequest} identityGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    identityGet(identityGetRequest: IdentityGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<IdentityGetResponse>>;
    /**
     * `/income/verification/create` begins the income verification process by returning an `income_verification_id`. You can then provide the `income_verification_id` to `/link/token/create` under the `income_verification` parameter in order to create a Link instance that will prompt the user to go through the income verification flow. Plaid will fire an `INCOME` webhook once the user completes the Payroll Income flow, or when the uploaded documents in the Document Income flow have finished processing.
     * @summary (Deprecated) Create an income verification instance
     * @param {IncomeVerificationCreateRequest} incomeVerificationCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationCreate(incomeVerificationCreateRequest: IncomeVerificationCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<IncomeVerificationCreateResponse>>;
    /**
     * `/income/verification/documents/download` provides the ability to download the source documents associated with the verification.  If Document Income was used, the documents will be those the user provided in Link. For Payroll Income, the most recent files available for download from the payroll provider will be available from this endpoint.  The response to `/income/verification/documents/download` is a ZIP file in binary data. If a `document_id` is passed, a single document will be contained in this file. If not, the response will contain all documents associated with the verification.  The `request_id` is returned in the `Plaid-Request-ID` header.
     * @summary Download the original documents used for income verification
     * @param {IncomeVerificationDocumentsDownloadRequest} incomeVerificationDocumentsDownloadRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationDocumentsDownload(incomeVerificationDocumentsDownloadRequest: IncomeVerificationDocumentsDownloadRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<any>>;
    /**
     * /income/verification/paystub/get returns information from a single paystub used for income verification
     * @summary (Deprecated) Retrieve information from a single paystub used for income verification
     * @param {IncomeVerificationPaystubGetRequest} incomeVerificationPaystubGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPaystubGet(incomeVerificationPaystubGetRequest: IncomeVerificationPaystubGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<IncomeVerificationPaystubGetResponse>>;
    /**
     * `/income/verification/paystubs/get` returns the information collected from the paystubs that were used to verify an end user\'s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary Retrieve information from the paystubs used for income verification
     * @param {IncomeVerificationPaystubsGetRequest} incomeVerificationPaystubsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPaystubsGet(incomeVerificationPaystubsGetRequest: IncomeVerificationPaystubsGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<IncomeVerificationPaystubsGetResponse>>;
    /**
     * `/income/verification/precheck` is an optional endpoint that can be called before initializing a Link session for income verification. It evaluates whether a given user is supportable by digital income verification and returns a `precheck_id` that can be provided to `/link/token/create`. If the user is eligible for digital verification, providing the `precheck_id` in this way will generate a Link UI optimized for the end user and their specific employer. If the user cannot be confirmed as eligible, the `precheck_id` can still be provided to `/link/token/create` and the user can still use the income verification flow, but they may be required to manually upload a paystub to verify their income.  While all request fields are optional, providing either `employer` or `transactions_access_tokens` data will increase the chance of receiving a useful result.
     * @summary Check digital income verification eligibility and optimize conversion
     * @param {IncomeVerificationPrecheckRequest} incomeVerificationPrecheckRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPrecheck(incomeVerificationPrecheckRequest: IncomeVerificationPrecheckRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<IncomeVerificationPrecheckResponse>>;
    /**
     * `/income/verification/refresh` refreshes a given income verification.
     * @summary Refresh an income verification
     * @param {IncomeVerificationRefreshRequest} incomeVerificationRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationRefresh(incomeVerificationRefreshRequest: IncomeVerificationRefreshRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<IncomeVerificationRefreshResponse>>;
    /**
     * `/income/verification/summary/get` returns a verification summary for the income that was verified for an end user. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary (Deprecated) Retrieve a summary of information derived from income verification
     * @param {IncomeVerificationSummaryGetRequest} incomeVerificationSummaryGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationSummaryGet(incomeVerificationSummaryGetRequest: IncomeVerificationSummaryGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<IncomeVerificationSummaryGetResponse>>;
    /**
     * `/income/verification/taxforms/get` returns the information collected from forms that were used to verify an end user\'s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary Retrieve information from the tax documents used for income verification
     * @param {{ [key: string]: object; }} requestBody
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationTaxformsGet(requestBody: {
        [key: string]: object;
    }, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<IncomeVerificationTaxformsGetResponse>>;
    /**
     * Returns a JSON response containing details on all financial institutions currently supported by Plaid. Because Plaid supports thousands of institutions, results are paginated.  If there is no overlap between an institution’s enabled products and a client’s enabled products, then the institution will be filtered out from the response. As a result, the number of institutions returned may not match the count specified in the call.
     * @summary Get details of all supported institutions
     * @param {InstitutionsGetRequest} institutionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsGet(institutionsGetRequest: InstitutionsGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<InstitutionsGetResponse>>;
    /**
     * Returns a JSON response containing details on a specified financial institution currently supported by Plaid.   Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` to authenticate to this endpoint. The `public_key` has been deprecated; all customers are encouraged to use `client_id` and `secret` instead.
     * @summary Get details of an institution
     * @param {InstitutionsGetByIdRequest} institutionsGetByIdRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsGetById(institutionsGetByIdRequest: InstitutionsGetByIdRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<InstitutionsGetByIdResponse>>;
    /**
     * Returns a JSON response containing details for institutions that match the query parameters, up to a maximum of ten institutions per query.  Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` parameters to authenticate to this endpoint. The `public_key` parameter has since been deprecated; all customers are encouraged to use `client_id` and `secret` instead.
     * @summary Search institutions
     * @param {InstitutionsSearchRequest} institutionsSearchRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsSearch(institutionsSearchRequest: InstitutionsSearchRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<InstitutionsSearchResponse>>;
    /**
     * The `/investments/holdings/get` endpoint allows developers to receive user-authorized stock position data for `investment`-type accounts.
     * @summary Get Investment holdings
     * @param {InvestmentsHoldingsGetRequest} investmentsHoldingsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    investmentsHoldingsGet(investmentsHoldingsGetRequest: InvestmentsHoldingsGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<InvestmentsHoldingsGetResponse>>;
    /**
     * The `/investments/transactions/get` endpoint allows developers to retrieve user-authorized transaction data for investment accounts.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Due to the potentially large number of investment transactions associated with an Item, results are paginated. Manipulate the count and offset parameters in conjunction with the `total_investment_transactions` response body field to fetch all available investment transactions.
     * @summary Get investment transactions
     * @param {InvestmentsTransactionsGetRequest} investmentsTransactionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    investmentsTransactionsGet(investmentsTransactionsGetRequest: InvestmentsTransactionsGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<InvestmentsTransactionsGetResponse>>;
    /**
     * By default, the `access_token` associated with an Item does not expire and should be stored in a persistent, secure manner.  You can use the `/item/access_token/invalidate` endpoint to rotate the `access_token` associated with an Item. The endpoint returns a new `access_token` and immediately invalidates the previous `access_token`.
     * @summary Invalidate access_token
     * @param {ItemAccessTokenInvalidateRequest} itemAccessTokenInvalidateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemAccessTokenInvalidate(itemAccessTokenInvalidateRequest: ItemAccessTokenInvalidateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemAccessTokenInvalidateResponse>>;
    /**
     * List a user’s connected applications
     * @summary List a user’s connected applications
     * @param {ItemApplicationListRequest} itemApplicationListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemApplicationList(itemApplicationListRequest: ItemApplicationListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemApplicationListResponse>>;
    /**
     * Enable consumers to update product access on selected accounts for an application.
     * @summary Update the scopes of access for a particular application
     * @param {ItemApplicationScopesUpdateRequest} itemApplicationScopesUpdateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemApplicationScopesUpdate(itemApplicationScopesUpdateRequest: ItemApplicationScopesUpdateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemApplicationScopesUpdateResponse>>;
    /**
     * Note: As of July 2020, the `/item/public_token/create` endpoint is deprecated. Instead, use `/link/token/create` with an `access_token` to create a Link token for use with [update mode](https://plaid.com/docs/link/update-mode).  If you need your user to take action to restore or resolve an error associated with an Item, generate a public token with the `/item/public_token/create` endpoint and then initialize Link with that `public_token`.  A `public_token` is one-time use and expires after 30 minutes. You use a `public_token` to initialize Link in [update mode](https://plaid.com/docs/link/update-mode) for a particular Item. You can generate a `public_token` for an Item even if you did not use Link to create the Item originally.  The `/item/public_token/create` endpoint is **not** used to create your initial `public_token`. If you have not already received an `access_token` for a specific Item, use Link to obtain your `public_token` instead. See the [Quickstart](https://plaid.com/docs/quickstart) for more information.
     * @summary Create public token
     * @param {ItemPublicTokenCreateRequest} itemPublicTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemCreatePublicToken(itemPublicTokenCreateRequest: ItemPublicTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemPublicTokenCreateResponse>>;
    /**
     * Returns information about the status of an Item.
     * @summary Retrieve an Item
     * @param {ItemGetRequest} itemGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemGet(itemGetRequest: ItemGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemGetResponse>>;
    /**
     * `/item/import` creates an Item via your Plaid Exchange Integration and returns an `access_token`. As part of an `/item/import` request, you will include a User ID (`user_auth.user_id`) and Authentication Token (`user_auth.auth_token`) that enable data aggregation through your Plaid Exchange API endpoints. These authentication principals are to be chosen by you.  Upon creating an Item via `/item/import`, Plaid will automatically begin an extraction of that Item through the Plaid Exchange infrastructure you have already integrated. This will automatically generate the Plaid native account ID for the account the user will switch their direct deposit to (`target_account_id`).
     * @summary Import Item
     * @param {ItemImportRequest} itemImportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemImport(itemImportRequest: ItemImportRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemImportResponse>>;
    /**
     * Exchange a Link `public_token` for an API `access_token`. Link hands off the `public_token` client-side via the `onSuccess` callback once a user has successfully created an Item. The `public_token` is ephemeral and expires after 30 minutes.  The response also includes an `item_id` that should be stored with the `access_token`. The `item_id` is used to identify an Item in a webhook. The `item_id` can also be retrieved by making an `/item/get` request.
     * @summary Exchange public token for an access token
     * @param {ItemPublicTokenExchangeRequest} itemPublicTokenExchangeRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemPublicTokenExchange(itemPublicTokenExchangeRequest: ItemPublicTokenExchangeRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemPublicTokenExchangeResponse>>;
    /**
     * The `/item/remove`  endpoint allows you to remove an Item. Once removed, the `access_token`  associated with the Item is no longer valid and cannot be used to access any data that was associated with the Item.  Note that in the Development environment, issuing an `/item/remove`  request will not decrement your live credential count. To increase your credential account in Development, contact Support.  Also note that for certain OAuth-based institutions, an Item removed via `/item/remove` may still show as an active connection in the institution\'s OAuth permission manager.  API versions 2019-05-29 and earlier return a `removed` boolean as part of the response.
     * @summary Remove an Item
     * @param {ItemRemoveRequest} itemRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemRemove(itemRemoveRequest: ItemRemoveRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemRemoveResponse>>;
    /**
     * The POST `/item/webhook/update` allows you to update the webhook URL associated with an Item. This request triggers a [`WEBHOOK_UPDATE_ACKNOWLEDGED`](https://plaid.com/docs/api/webhooks/#item-webhook-update-acknowledged) webhook to the newly specified webhook URL.
     * @summary Update Webhook URL
     * @param {ItemWebhookUpdateRequest} itemWebhookUpdateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemWebhookUpdate(itemWebhookUpdateRequest: ItemWebhookUpdateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ItemWebhookUpdateResponse>>;
    /**
     * The `/liabilities/get` endpoint returns various details about an Item with loan or credit accounts. Liabilities data is available primarily for US financial institutions, with some limited coverage of Canadian institutions. Currently supported account types are account type `credit` with account subtype `credit card` or `paypal`, and account type `loan` with account subtype `student` or `mortgage`. To limit accounts listed in Link to types and subtypes supported by Liabilities, you can use the `account_filters` parameter when [creating a Link token](https://plaid.com/docs/api/tokens/#linktokencreate).  The types of information returned by Liabilities can include balances and due dates, loan terms, and account details such as original loan amount and guarantor. Data is refreshed approximately once per day; the latest data can be retrieved by calling `/liabilities/get`.  Note: This request may take some time to complete if `liabilities` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the additional data.
     * @summary Retrieve Liabilities data
     * @param {LiabilitiesGetRequest} liabilitiesGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    liabilitiesGet(liabilitiesGetRequest: LiabilitiesGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<LiabilitiesGetResponse>>;
    /**
     * The `/link/token/create` endpoint creates a `link_token`, which is required as a parameter when initializing Link. Once Link has been initialized, it returns a `public_token`, which can then be exchanged for an `access_token` via `/item/public_token/exchange` as part of the main Link flow.  A `link_token` generated by `/link/token/create` is also used to initialize other Link flows, such as the update mode flow for tokens with expired credentials, or the Payment Initiation (Europe) flow.
     * @summary Create Link Token
     * @param {LinkTokenCreateRequest} linkTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    linkTokenCreate(linkTokenCreateRequest: LinkTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<LinkTokenCreateResponse>>;
    /**
     * The `/link/token/get` endpoint gets information about a previously-created `link_token` using the `/link/token/create` endpoint. It can be useful for debugging purposes.
     * @summary Get Link Token
     * @param {LinkTokenGetRequest} linkTokenGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    linkTokenGet(linkTokenGetRequest: LinkTokenGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<LinkTokenGetResponse>>;
    /**
     * After creating a payment recipient, you can use the `/payment_initiation/payment/create` endpoint to create a payment to that recipient.  Payments can be one-time or standing order (recurring) and can be denominated in either EUR or GBP.  If making domestic GBP-denominated payments, your recipient must have been created with BACS numbers. In general, EUR-denominated payments will be sent via SEPA Credit Transfer and GBP-denominated payments will be sent via the Faster Payments network, but the payment network used will be determined by the institution. Payments sent via Faster Payments will typically arrive immediately, while payments sent via SEPA Credit Transfer will typically arrive in one business day.  Standing orders (recurring payments) must be denominated in GBP and can only be sent to recipients in the UK. Once created, standing order payments cannot be modified or canceled via the API. An end user can cancel or modify a standing order directly on their banking application or website, or by contacting the bank. Standing orders will follow the payment rules of the underlying rails (Faster Payments in UK). Payments can be sent Monday to Friday, excluding bank holidays. If the pre-arranged date falls on a weekend or bank holiday, the payment is made on the next working day. It is not possible to guarantee the exact time the payment will reach the recipient’s account, although at least 90% of standing order payments are sent by 6am.  In the Development environment, payments must be below 5 GBP / EUR. For details on any payment limits in Production, contact your Plaid Account Manager.
     * @summary Create a payment
     * @param {PaymentInitiationPaymentCreateRequest} paymentInitiationPaymentCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentCreate(paymentInitiationPaymentCreateRequest: PaymentInitiationPaymentCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<PaymentInitiationPaymentCreateResponse>>;
    /**
     * The `/payment_initiation/payment/get` endpoint can be used to check the status of a payment, as well as to receive basic information such as recipient and payment amount. In the case of standing orders, the `/payment_initiation/payment/get` endpoint will provide information about the status of the overall standing order itself; the API cannot be used to retrieve payment status for individual payments within a standing order.
     * @summary Get payment details
     * @param {PaymentInitiationPaymentGetRequest} paymentInitiationPaymentGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentGet(paymentInitiationPaymentGetRequest: PaymentInitiationPaymentGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<PaymentInitiationPaymentGetResponse>>;
    /**
     * The `/payment_initiation/payment/list` endpoint can be used to retrieve all created payments. By default, the 10 most recent payments are returned. You can request more payments and paginate through the results using the optional `count` and `cursor` parameters.
     * @summary List payments
     * @param {PaymentInitiationPaymentListRequest} paymentInitiationPaymentListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentList(paymentInitiationPaymentListRequest: PaymentInitiationPaymentListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<PaymentInitiationPaymentListResponse>>;
    /**
     * Reverse a previously initiated payment.  A payment can only be reversed once and will be refunded to the original sender\'s account.
     * @summary Reverse an existing payment
     * @param {PaymentInitiationPaymentReverseRequest} paymentInitiationPaymentReverseRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentReverse(paymentInitiationPaymentReverseRequest: PaymentInitiationPaymentReverseRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<PaymentInitiationPaymentReverseResponse>>;
    /**
     * Create a payment recipient for payment initiation.  The recipient must be in Europe, within a country that is a member of the Single Euro Payment Area (SEPA).  For a standing order (recurring) payment, the recipient must be in the UK.  The endpoint is idempotent: if a developer has already made a request with the same payment details, Plaid will return the same `recipient_id`.
     * @summary Create payment recipient
     * @param {PaymentInitiationRecipientCreateRequest} paymentInitiationRecipientCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientCreate(paymentInitiationRecipientCreateRequest: PaymentInitiationRecipientCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<PaymentInitiationRecipientCreateResponse>>;
    /**
     * Get details about a payment recipient you have previously created.
     * @summary Get payment recipient
     * @param {PaymentInitiationRecipientGetRequest} paymentInitiationRecipientGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientGet(paymentInitiationRecipientGetRequest: PaymentInitiationRecipientGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<PaymentInitiationRecipientGetResponse>>;
    /**
     * The `/payment_initiation/recipient/list` endpoint list the payment recipients that you have previously created.
     * @summary List payment recipients
     * @param {PaymentInitiationRecipientListRequest} paymentInitiationRecipientListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientList(paymentInitiationRecipientListRequest: PaymentInitiationRecipientListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<PaymentInitiationRecipientListResponse>>;
    /**
     * Used to create a token suitable for sending to Apex to enable Plaid-Apex integrations.
     * @summary Create Apex bank account token
     * @param {ProcessorApexProcessorTokenCreateRequest} processorApexProcessorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorApexProcessorTokenCreate(processorApexProcessorTokenCreateRequest: ProcessorApexProcessorTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ProcessorTokenCreateResponse>>;
    /**
     * The `/processor/auth/get` endpoint returns the bank account and bank identification number (such as the routing number, for US accounts), for a checking or savings account that\'\'s associated with a given `processor_token`. The endpoint also returns high-level account data and balances when available.   Versioning note: API versions 2019-05-29 and earlier use a different schema for the `numbers` object returned by this endpoint. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2020-09-14).
     * @summary Retrieve Auth data
     * @param {ProcessorAuthGetRequest} processorAuthGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorAuthGet(processorAuthGetRequest: ProcessorAuthGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ProcessorAuthGetResponse>>;
    /**
     * The `/processor/balance/get` endpoint returns the real-time balance for each of an Item\'s accounts. While other endpoints may return a balance object, only `/processor/balance/get` forces the available and current balance fields to be refreshed rather than cached.
     * @summary Retrieve Balance data
     * @param {ProcessorBalanceGetRequest} processorBalanceGetRequest The &#x60;/processor/balance/get&#x60; endpoint returns the real-time balance for the account associated with a given &#x60;processor_token&#x60;.  The current balance is the total amount of funds in the account. The available balance is the current balance less any outstanding holds or debits that have not yet posted to the account.  Note that not all institutions calculate the available balance. In the event that available balance is unavailable from the institution, Plaid will return an available balance value of &#x60;null&#x60;.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorBalanceGet(processorBalanceGetRequest: ProcessorBalanceGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ProcessorBalanceGetResponse>>;
    /**
     * Use the `/processor/bank_transfer/create` endpoint to initiate a new bank transfer as a processor
     * @summary Create a bank transfer as a processor
     * @param {ProcessorBankTransferCreateRequest} processorBankTransferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorBankTransferCreate(processorBankTransferCreateRequest: ProcessorBankTransferCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ProcessorBankTransferCreateResponse>>;
    /**
     * The `/processor/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses.
     * @summary Retrieve Identity data
     * @param {ProcessorIdentityGetRequest} processorIdentityGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorIdentityGet(processorIdentityGetRequest: ProcessorIdentityGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ProcessorIdentityGetResponse>>;
    /**
     * Used to create a token suitable for sending to Stripe to enable Plaid-Stripe integrations. For a detailed guide on integrating Stripe, see [Add Stripe to your app](https://plaid.com/docs/auth/partnerships/stripe/).
     * @summary Create Stripe bank account token
     * @param {ProcessorStripeBankAccountTokenCreateRequest} processorStripeBankAccountTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorStripeBankAccountTokenCreate(processorStripeBankAccountTokenCreateRequest: ProcessorStripeBankAccountTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ProcessorStripeBankAccountTokenCreateResponse>>;
    /**
     * Used to create a token suitable for sending to one of Plaid\'s partners to enable integrations. Note that Stripe partnerships use bank account tokens instead; see `/processor/stripe/bank_account_token/create` for creating tokens for use with Stripe integrations.
     * @summary Create processor token
     * @param {ProcessorTokenCreateRequest} processorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorTokenCreate(processorTokenCreateRequest: ProcessorTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<ProcessorTokenCreateResponse>>;
    /**
     * Use the `/sandbox/bank_transfer/fire_webhook` endpoint to manually trigger a Bank Transfers webhook in the Sandbox environment.
     * @summary Manually fire a Bank Transfer webhook
     * @param {SandboxBankTransferFireWebhookRequest} sandboxBankTransferFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxBankTransferFireWebhook(sandboxBankTransferFireWebhookRequest: SandboxBankTransferFireWebhookRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxBankTransferFireWebhookResponse>>;
    /**
     * Use the `/sandbox/bank_transfer/simulate` endpoint to simulate a bank transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/bank_transfer/event/sync` or `/bank_transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.
     * @summary Simulate a bank transfer event in Sandbox
     * @param {SandboxBankTransferSimulateRequest} sandboxBankTransferSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxBankTransferSimulate(sandboxBankTransferSimulateRequest: SandboxBankTransferSimulateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxBankTransferSimulateResponse>>;
    /**
     * Use the `/sandbox/income/fire_webhook` endpoint to manually trigger an Income webhook in the Sandbox environment.
     * @summary Manually fire an Income webhook
     * @param {SandboxIncomeFireWebhookRequest} sandboxIncomeFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxIncomeFireWebhook(sandboxIncomeFireWebhookRequest: SandboxIncomeFireWebhookRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxIncomeFireWebhookResponse>>;
    /**
     * The `/sandbox/item/fire_webhook` endpoint is used to test that code correctly handles webhooks. This endpoint can trigger a Transactions `DEFAULT_UPDATE` webhook to be fired for a given Sandbox Item. If the Item does not support Transactions, a `SANDBOX_PRODUCT_NOT_ENABLED` error will result. This endpoint can also trigger a `NEW_ACCOUNTS_AVAILABLE` webhook to be fired for a given Sandbox Item created with Account Select v2. Note that this endpoint is provided for developer ease-of-use and is not required for testing webhooks; webhooks will also fire in Sandbox under the same conditions that they would in Production or Development.
     * @summary Fire a test webhook
     * @param {SandboxItemFireWebhookRequest} sandboxItemFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemFireWebhook(sandboxItemFireWebhookRequest: SandboxItemFireWebhookRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxItemFireWebhookResponse>>;
    /**
     * `/sandbox/item/reset_login/` forces an Item into an `ITEM_LOGIN_REQUIRED` state in order to simulate an Item whose login is no longer valid. This makes it easy to test Link\'s [update mode](https://plaid.com/docs/link/update-mode) flow in the Sandbox environment.  After calling `/sandbox/item/reset_login`, You can then use Plaid Link update mode to restore the Item to a good state. An `ITEM_LOGIN_REQUIRED` webhook will also be fired after a call to this endpoint, if one is associated with the Item.   In the Sandbox, Items will transition to an `ITEM_LOGIN_REQUIRED` error state automatically after 30 days, even if this endpoint is not called.
     * @summary Force a Sandbox Item into an error state
     * @param {SandboxItemResetLoginRequest} sandboxItemResetLoginRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemResetLogin(sandboxItemResetLoginRequest: SandboxItemResetLoginRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxItemResetLoginResponse>>;
    /**
     * The `/sandbox/item/set_verification_status` endpoint can be used to change the verification status of an Item in in the Sandbox in order to simulate the Automated Micro-deposit flow.  Note that not all Plaid developer accounts are enabled for micro-deposit based verification by default. Your account must be enabled for this feature in order to test it in Sandbox. To enable this features or check your status, contact your account manager or [submit a product access Support ticket](https://dashboard.plaid.com/support/new/product-and-development/product-troubleshooting/request-product-access).  For more information on testing Automated Micro-deposits in Sandbox, see [Auth full coverage testing](https://plaid.com/docs/auth/coverage/testing#).
     * @summary Set verification status for Sandbox account
     * @param {SandboxItemSetVerificationStatusRequest} sandboxItemSetVerificationStatusRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemSetVerificationStatus(sandboxItemSetVerificationStatusRequest: SandboxItemSetVerificationStatusRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxItemSetVerificationStatusResponse>>;
    /**
     * Save the selected accounts when connecting to the Platypus Oauth institution
     * @summary Save the selected accounts when connecting to the Platypus Oauth institution
     * @param {SandboxOauthSelectAccountsRequest} sandboxOauthSelectAccountsRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxOauthSelectAccounts(sandboxOauthSelectAccountsRequest: SandboxOauthSelectAccountsRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<{
        [key: string]: object;
    }>>;
    /**
     * Use the `/sandbox/processor_token/create` endpoint to create a valid `processor_token` for an arbitrary institution ID and test credentials. The created `processor_token` corresponds to a new Sandbox Item. You can then use this `processor_token` with the `/processor/` API endpoints in Sandbox. You can also use `/sandbox/processor_token/create` with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data.
     * @summary Create a test Item and processor token
     * @param {SandboxProcessorTokenCreateRequest} sandboxProcessorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxProcessorTokenCreate(sandboxProcessorTokenCreateRequest: SandboxProcessorTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxProcessorTokenCreateResponse>>;
    /**
     * Use the `/sandbox/public_token/create` endpoint to create a valid `public_token`  for an arbitrary institution ID, initial products, and test credentials. The created `public_token` maps to a new Sandbox Item. You can then call `/item/public_token/exchange` to exchange the `public_token` for an `access_token` and perform all API actions. `/sandbox/public_token/create` can also be used with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data. `/sandbox/public_token/create` cannot be used with OAuth institutions.
     * @summary Create a test Item
     * @param {SandboxPublicTokenCreateRequest} sandboxPublicTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxPublicTokenCreate(sandboxPublicTokenCreateRequest: SandboxPublicTokenCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxPublicTokenCreateResponse>>;
    /**
     * Use the `/sandbox/transfer/repayment/simulate` endpoint to trigger the creation of a repayment. As a side effect of calling this route, a repayment is created that includes all unreimbursed returns of guaranteed transfers. If there are no such returns, an 400 error is returned.
     * @summary Trigger the creation of a repayment
     * @param {SandboxTransferRepaymentSimulateRequest} sandboxTransferRepaymentSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferRepaymentSimulate(sandboxTransferRepaymentSimulateRequest: SandboxTransferRepaymentSimulateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxTransferRepaymentSimulateResponse>>;
    /**
     * Use the `/sandbox/transfer/simulate` endpoint to simulate a transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/transfer/event/sync` or `/transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.
     * @summary Simulate a transfer event in Sandbox
     * @param {SandboxTransferSimulateRequest} sandboxTransferSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferSimulate(sandboxTransferSimulateRequest: SandboxTransferSimulateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxTransferSimulateResponse>>;
    /**
     * Use the `/sandbox/transfer/sweep/simulate` endpoint to create a sweep and associated events in the Sandbox environment. Upon calling this endpoint, all `posted` or `pending` transfers with a sweep status of `unswept` will become `swept`, and all `reversed` transfers with a sweep status of `swept` will become `reverse_swept`.
     * @summary Simulate creating a sweep
     * @param {SandboxTransferSweepSimulateRequest} sandboxTransferSweepSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferSweepSimulate(sandboxTransferSweepSimulateRequest: SandboxTransferSweepSimulateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SandboxTransferSweepSimulateResponse>>;
    /**
     * After calling `/signal/evaluate`, call `/signal/decision/report` to report whether the transaction was initiated. This endpoint will return an `INVALID_REQUEST` error if called a second time with a different value for `initiated`.
     * @summary Report whether you initiated an ACH transaction
     * @param {SignalDecisionReportRequest} signalDecisionReportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalDecisionReport(signalDecisionReportRequest: SignalDecisionReportRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SignalDecisionReportResponse>>;
    /**
     * Use `/signal/evaluate` to evaluate a planned ACH transaction to get a return risk assessment (such as a risk score and risk tier) and additional risk signals.  In order to obtain a valid score for an ACH transaction, Plaid must have an access token for the account, and the Item must be healthy (receiving product updates) or have recently been in a healthy state. If the transaction does not meet eligibility requirements, an error will be returned corresponding to the underlying cause. If `/signal/evaluate` is called on the same transaction multiple times within a 24-hour period, cached results may be returned.
     * @summary Evaluate a planned ACH transaction
     * @param {SignalEvaluateRequest} signalEvaluateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalEvaluate(signalEvaluateRequest: SignalEvaluateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SignalEvaluateResponse>>;
    /**
     * Call the `/signal/return/report` endpoint to report a returned transaction that was previously sent to the `/signal/evaluate` endpoint. Your feedback will be used by the model to incorporate the latest risk trend in your portfolio.
     * @summary Report a return for an ACH transaction
     * @param {SignalReturnReportRequest} signalReturnReportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalReturnReport(signalReturnReportRequest: SignalReturnReportRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<SignalReturnReportResponse>>;
    /**
     * The `/transactions/get` endpoint allows developers to receive user-authorized transaction data for credit, depository, and some loan-type accounts (only those with account subtype `student`; coverage may be limited). For transaction history from investments accounts, use the [Investments endpoint](https://plaid.com/docs/api/products#investments) instead. Transaction data is standardized across financial institutions, and in many cases transactions are linked to a clean name, entity type, location, and category. Similarly, account data is standardized and returned with a clean name, number, balance, and other meta information where available.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Transactions are not immutable and can also be removed altogether by the institution; a removed transaction will no longer appear in `/transactions/get`.  For more details, see [Pending and posted transactions](https://plaid.com/docs/transactions/transactions-data/#pending-and-posted-transactions).  Due to the potentially large number of transactions associated with an Item, results are paginated. Manipulate the `count` and `offset` parameters in conjunction with the `total_transactions` response body field to fetch all available transactions.  Data returned by `/transactions/get` will be the data available for the Item as of the most recent successful check for new transactions. Plaid typically checks for new data multiple times a day, but these checks may occur less frequently, such as once a day, depending on the institution. An Item\'s `status.transactions.last_successful_update` field will show the timestamp of the most recent successful update. To force Plaid to check for new transactions, you can use the `/transactions/refresh` endpoint.  Note that data may not be immediately available to `/transactions/get`. Plaid will begin to prepare transactions data upon Item link, if Link was initialized with `transactions`, or upon the first call to `/transactions/get`, if it wasn\'t. To be alerted when transaction data is ready to be fetched, listen for the [`INITIAL_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-initial_update) and [`HISTORICAL_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-historical_update) webhooks. If no transaction history is ready when `/transactions/get` is called, it will return a `PRODUCT_NOT_READY` error.
     * @summary Get transaction data
     * @param {TransactionsGetRequest} transactionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsGet(transactionsGetRequest: TransactionsGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransactionsGetResponse>>;
    /**
     * The `/transactions/recurring/get` endpoint identifies and returns groups of transactions that occur on a regular basis for the inputted Item and accounts.  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.
     * @summary Get streams of recurring transactions
     * @param {TransactionsRecurringGetRequest} transactionsRecurringGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsRecurringGet(transactionsRecurringGetRequest: TransactionsRecurringGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransactionsRecurringGetResponse>>;
    /**
     * `/transactions/refresh` is an optional endpoint for users of the Transactions product. It initiates an on-demand extraction to fetch the newest transactions for an Item. This on-demand extraction takes place in addition to the periodic extractions that automatically occur multiple times a day for any Transactions-enabled Item. If changes to transactions are discovered after calling `/transactions/refresh`, Plaid will fire a webhook: [`TRANSACTIONS_REMOVED`](https://plaid.com/docs/api/webhooks#deleted-transactions-detected) will be fired if any removed transactions are detected, and [`DEFAULT_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-default_update) will be fired if any new transactions are detected. New transactions can be fetched by calling `/transactions/get`.  Access to `/transactions/refresh` in Production is specific to certain pricing plans. If you cannot access `/transactions/refresh` in Production, [contact Sales](https://www.plaid.com/contact) for assistance.
     * @summary Refresh transaction data
     * @param {TransactionsRefreshRequest} transactionsRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsRefresh(transactionsRefreshRequest: TransactionsRefreshRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransactionsRefreshResponse>>;
    /**
     * The `/transactions/sync` endpoint returns item transactions as a set of delta updates. Subsequent calls to the endpoint using the cursor returned in the response will return new added, modified, and removed transactions since the last call to the endpoint  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.
     * @summary Get incremental transaction updates on an Item
     * @param {TransactionsSyncRequest} transactionsSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsSync(transactionsSyncRequest: TransactionsSyncRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransactionsSyncResponse>>;
    /**
     * Use the `/transfer/authorization/create` endpoint to determine transfer failure risk.  In Plaid\'s sandbox environment the decisions will be returned as follows:    - To approve a transfer, make an authorization request with an `amount` less than the available balance in the account.    - To decline a transfer with the rationale code `NSF`, the available balance on the account must be less than the authorization `amount`. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To decline a transfer with the rationale code `RISK`, the available balance on the account must be exactly $0. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To permit a transfer with the rationale code `MANUALLY_VERIFIED_ITEM`, create an Item in Link through the [Same Day Micro-deposits flow](https://plaid.com/docs/auth/coverage/testing/#testing-same-day-micro-deposits).    - To permit a transfer with the rationale code `LOGIN_REQUIRED`, [reset the login for an Item](https://plaid.com/docs/sandbox/#item_login_required).  All username/password combinations other than the ones listed above will result in a decision of permitted and rationale code `ERROR`.
     * @summary Create a transfer authorization
     * @param {TransferAuthorizationCreateRequest} transferAuthorizationCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferAuthorizationCreate(transferAuthorizationCreateRequest: TransferAuthorizationCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferAuthorizationCreateResponse>>;
    /**
     * Use the `/transfer/cancel` endpoint to cancel a transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/transfer/get` is `true`.
     * @summary Cancel a transfer
     * @param {TransferCancelRequest} transferCancelRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferCancel(transferCancelRequest: TransferCancelRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferCancelResponse>>;
    /**
     * Use the `/transfer/create` endpoint to initiate a new transfer.
     * @summary Create a transfer
     * @param {TransferCreateRequest} transferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferCreate(transferCreateRequest: TransferCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferCreateResponse>>;
    /**
     * Use the `/transfer/event/list` endpoint to get a list of transfer events based on specified filter criteria.
     * @summary List transfer events
     * @param {TransferEventListRequest} transferEventListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferEventList(transferEventListRequest: TransferEventListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferEventListResponse>>;
    /**
     * `/transfer/event/sync` allows you to request up to the next 25 transfer events that happened after a specific `event_id`. Use the `/transfer/event/sync` endpoint to guarantee you have seen all transfer events.
     * @summary Sync transfer events
     * @param {TransferEventSyncRequest} transferEventSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferEventSync(transferEventSyncRequest: TransferEventSyncRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferEventSyncResponse>>;
    /**
     * The `/transfer/get` fetches information about the transfer corresponding to the given `transfer_id`.
     * @summary Retrieve a transfer
     * @param {TransferGetRequest} transferGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferGet(transferGetRequest: TransferGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferGetResponse>>;
    /**
     * Use the `/transfer/intent/create` endpoint to generate a transfer intent object and invoke the Transfer UI.
     * @summary Create a transfer intent object to invoke the Transfer UI
     * @param {TransferIntentCreateRequest} transferIntentCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferIntentCreate(transferIntentCreateRequest: TransferIntentCreateRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferIntentCreateResponse>>;
    /**
     * Use the `/transfer/intent/get` endpoint to retrieve more information about a transfer intent.
     * @summary Retrieve more information about a transfer intent
     * @param {{ [key: string]: object; }} requestBody
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferIntentGet(requestBody: {
        [key: string]: object;
    }, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferIntentGetResponse>>;
    /**
     * Use the `/transfer/list` endpoint to see a list of all your transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired transfers.
     * @summary List transfers
     * @param {TransferListRequest} transferListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferList(transferListRequest: TransferListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferListResponse>>;
    /**
     * The `/transfer/repayment/list` endpoint fetches repayments matching the given filters. Repayments are returned in reverse-chronological order (most recent first) starting at the given `start_time`.
     * @summary Lists historical repayments
     * @param {TransferRepaymentListRequest} transferRepaymentListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferRepaymentList(transferRepaymentListRequest: TransferRepaymentListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferRepaymentListResponse>>;
    /**
     * The `/transfer/repayment/return/list` endpoint retrieves the set of returns that were batched together into the specified repayment. The sum of amounts of returns retrieved by this request equals the amount of the repayment.
     * @summary List the returns included in a repayment
     * @param {TransferRepaymentReturnListRequest} transferRepaymentReturnListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferRepaymentReturnList(transferRepaymentReturnListRequest: TransferRepaymentReturnListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferRepaymentReturnListResponse>>;
    /**
     * The `/transfer/sweep/get` endpoint fetches a sweep corresponding to the given `sweep_id`.
     * @summary Retrieve a sweep
     * @param {TransferSweepGetRequest} transferSweepGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferSweepGet(transferSweepGetRequest: TransferSweepGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferSweepGetResponse>>;
    /**
     * The `/transfer/sweep/list` endpoint fetches sweeps matching the given filters.
     * @summary List sweeps
     * @param {TransferSweepListRequest} transferSweepListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferSweepList(transferSweepListRequest: TransferSweepListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<TransferSweepListResponse>>;
    /**
     * Fetch an e-wallet. The response includes the current balance.
     * @summary Fetch an e-wallet
     * @param {WalletGetRequest} walletGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletGet(walletGetRequest: WalletGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<WalletGetResponse>>;
    /**
     * Execute a transaction using the specified e-wallet. Specify the e-wallet to debit from, the counterparty to credit to, the idempotency key to prevent duplicate payouts, the amount and reference for the payout. The payouts are executed over the Faster Payment rails, where settlement usually only takes a few seconds.
     * @summary Execute a transaction using an e-wallet
     * @param {WalletTransactionExecuteRequest} walletTransactionExecuteRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletTransactionExecute(walletTransactionExecuteRequest: WalletTransactionExecuteRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<WalletTransactionExecuteResponse>>;
    /**
     * This endpoint lists the latest transactions of the specified e-wallet. Transactions are returned in descending order by the `created_at` time.
     * @summary List e-wallet transactions
     * @param {WalletTransactionsListRequest} walletTransactionsListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletTransactionsList(walletTransactionsListRequest: WalletTransactionsListRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<WalletTransactionsListResponse>>;
    /**
     * Plaid signs all outgoing webhooks and provides JSON Web Tokens (JWTs) so that you can verify the authenticity of any incoming webhooks to your application. A message signature is included in the `Plaid-Verification` header.  The `/webhook_verification_key/get` endpoint provides a JSON Web Key (JWK) that can be used to verify a JWT.
     * @summary Get webhook verification key
     * @param {WebhookVerificationKeyGetRequest} webhookVerificationKeyGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    webhookVerificationKeyGet(webhookVerificationKeyGetRequest: WebhookVerificationKeyGetRequest, options?: any): Promise<(axios?: AxiosInstance | undefined, basePath?: string | undefined) => AxiosPromise<WebhookVerificationKeyGetResponse>>;
};
/**
 * PlaidApi - factory interface
 * @export
 */
export declare const PlaidApiFactory: (configuration?: Configuration | undefined, basePath?: string | undefined, axios?: AxiosInstance | undefined) => {
    /**
     * The `/accounts/balance/get` endpoint returns the real-time balance for each of an Item\'s accounts. While other endpoints may return a balance object, only `/accounts/balance/get` forces the available and current balance fields to be refreshed rather than cached. This endpoint can be used for existing Items that were added via any of Plaid’s other products. This endpoint can be used as long as Link has been initialized with any other product, `balance` itself is not a product that can be used to initialize Link.
     * @summary Retrieve real-time balance data
     * @param {AccountsBalanceGetRequest} accountsBalanceGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    accountsBalanceGet(accountsBalanceGetRequest: AccountsBalanceGetRequest, options?: any): AxiosPromise<AccountsGetResponse>;
    /**
     * The `/accounts/get` endpoint can be used to retrieve a list of accounts associated with any linked Item. Plaid will only return active bank accounts — that is, accounts that are not closed and are capable of carrying a balance.  This endpoint only returns accounts that were permissioned by the user when they initially created the Item. If a user creates a new account after the initial link, you can capture this event through the [`NEW_ACCOUNTS_AVAILABLE`](https://plaid.com/docs/api/webhooks/#item-new_accounts_available) webhook and then use Link\'s [update mode](https://plaid.com/docs/link/update-mode/) to request that the user share this new account with you.  This endpoint retrieves cached information, rather than extracting fresh information from the institution. As a result, balances returned may not be up-to-date; for realtime balance information, use `/accounts/balance/get` instead. Note that some information is nullable.
     * @summary Retrieve accounts
     * @param {AccountsGetRequest} accountsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    accountsGet(accountsGetRequest: AccountsGetRequest, options?: any): AxiosPromise<AccountsGetResponse>;
    /**
     * Allows financial institutions to retrieve information about Plaid clients for the purpose of building control-tower experiences
     * @summary Retrieve information about a Plaid application
     * @param {ApplicationGetRequest} applicationGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    applicationGet(applicationGetRequest: ApplicationGetRequest, options?: any): AxiosPromise<ApplicationGetResponse>;
    /**
     * Plaid can provide an Audit Copy of any Asset Report directly to a participating third party on your behalf. For example, Plaid can supply an Audit Copy directly to Fannie Mae on your behalf if you participate in the Day 1 Certainty™ program. An Audit Copy contains the same underlying data as the Asset Report.  To grant access to an Audit Copy, use the `/asset_report/audit_copy/create` endpoint to create an `audit_copy_token` and then pass that token to the third party who needs access. Each third party has its own `auditor_id`, for example `fannie_mae`. You’ll need to create a separate Audit Copy for each third party to whom you want to grant access to the Report.
     * @summary Create Asset Report Audit Copy
     * @param {AssetReportAuditCopyCreateRequest} assetReportAuditCopyCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyCreate(assetReportAuditCopyCreateRequest: AssetReportAuditCopyCreateRequest, options?: any): AxiosPromise<AssetReportAuditCopyCreateResponse>;
    /**
     * `/asset_report/audit_copy/get` allows auditors to get a copy of an Asset Report that was previously shared via the `/asset_report/audit_copy/create` endpoint.  The caller of `/asset_report/audit_copy/create` must provide the `audit_copy_token` to the auditor.  This token can then be used to call `/asset_report/audit_copy/create`.
     * @summary Retrieve an Asset Report Audit Copy
     * @param {AssetReportAuditCopyGetRequest} assetReportAuditCopyGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyGet(assetReportAuditCopyGetRequest: AssetReportAuditCopyGetRequest, options?: any): AxiosPromise<AssetReportGetResponse>;
    /**
     * The `/asset_report/audit_copy/remove` endpoint allows you to remove an Audit Copy. Removing an Audit Copy invalidates the `audit_copy_token` associated with it, meaning both you and any third parties holding the token will no longer be able to use it to access Report data. Items associated with the Asset Report, the Asset Report itself and other Audit Copies of it are not affected and will remain accessible after removing the given Audit Copy.
     * @summary Remove Asset Report Audit Copy
     * @param {AssetReportAuditCopyRemoveRequest} assetReportAuditCopyRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportAuditCopyRemove(assetReportAuditCopyRemoveRequest: AssetReportAuditCopyRemoveRequest, options?: any): AxiosPromise<AssetReportAuditCopyRemoveResponse>;
    /**
     * The `/asset_report/create` endpoint initiates the process of creating an Asset Report, which can then be retrieved by passing the `asset_report_token` return value to the `/asset_report/get` or `/asset_report/pdf/get` endpoints.  The Asset Report takes some time to be created and is not available immediately after calling `/asset_report/create`. When the Asset Report is ready to be retrieved using `/asset_report/get` or `/asset_report/pdf/get`, Plaid will fire a `PRODUCT_READY` webhook. For full details of the webhook schema, see [Asset Report webhooks](https://plaid.com/docs/api/webhooks/#assets-webhooks).  The `/asset_report/create` endpoint creates an Asset Report at a moment in time. Asset Reports are immutable. To get an updated Asset Report, use the `/asset_report/refresh` endpoint.
     * @summary Create an Asset Report
     * @param {AssetReportCreateRequest} assetReportCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportCreate(assetReportCreateRequest: AssetReportCreateRequest, options?: any): AxiosPromise<AssetReportCreateResponse>;
    /**
     * By default, an Asset Report will contain all of the accounts on a given Item. In some cases, you may not want the Asset Report to contain all accounts. For example, you might have the end user choose which accounts are relevant in Link using the Account Select view, which you can enable in the dashboard. Or, you might always exclude certain account types or subtypes, which you can identify by using the `/accounts/get` endpoint. To narrow an Asset Report to only a subset of accounts, use the `/asset_report/filter` endpoint.  To exclude certain Accounts from an Asset Report, first use the `/asset_report/create` endpoint to create the report, then send the `asset_report_token` along with a list of `account_ids` to exclude to the `/asset_report/filter` endpoint, to create a new Asset Report which contains only a subset of the original Asset Report\'s data.  Because Asset Reports are immutable, calling `/asset_report/filter` does not alter the original Asset Report in any way; rather, `/asset_report/filter` creates a new Asset Report with a new token and id. Asset Reports created via `/asset_report/filter` do not contain new Asset data, and are not billed.  Plaid will fire a [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook once generation of the filtered Asset Report has completed.
     * @summary Filter Asset Report
     * @param {AssetReportFilterRequest} assetReportFilterRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportFilter(assetReportFilterRequest: AssetReportFilterRequest, options?: any): AxiosPromise<AssetReportFilterResponse>;
    /**
     * The `/asset_report/get` endpoint retrieves the Asset Report in JSON format. Before calling `/asset_report/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook to fire, indicating that the Report is ready to be retrieved.  By default, an Asset Report includes transaction descriptions as returned by the bank, as opposed to parsed and categorized by Plaid. You can also receive cleaned and categorized transactions, as well as additional insights like merchant name or location information. We call this an Asset Report with Insights. An Asset Report with Insights provides transaction category, location, and merchant information in addition to the transaction strings provided in a standard Asset Report.  To retrieve an Asset Report with Insights, call the `/asset_report/get` endpoint with `include_insights` set to `true`.
     * @summary Retrieve an Asset Report
     * @param {AssetReportGetRequest} assetReportGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportGet(assetReportGetRequest: AssetReportGetRequest, options?: any): AxiosPromise<AssetReportGetResponse>;
    /**
     * The `/asset_report/pdf/get` endpoint retrieves the Asset Report in PDF format. Before calling `/asset_report/pdf/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook to fire, indicating that the Report is ready to be retrieved.  The response to `/asset_report/pdf/get` is the PDF binary data. The `request_id`  is returned in the `Plaid-Request-ID` header.  [View a sample PDF Asset Report](https://plaid.com/documents/sample-asset-report.pdf).
     * @summary Retrieve a PDF Asset Report
     * @param {AssetReportPDFGetRequest} assetReportPDFGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportPdfGet(assetReportPDFGetRequest: AssetReportPDFGetRequest, options?: any): AxiosPromise<any>;
    /**
     * An Asset Report is an immutable snapshot of a user\'s assets. In order to \"refresh\" an Asset Report you created previously, you can use the `/asset_report/refresh` endpoint to create a new Asset Report based on the old one, but with the most recent data available.  The new Asset Report will contain the same Items as the original Report, as well as the same filters applied by any call to `/asset_report/filter`. By default, the new Asset Report will also use the same parameters you submitted with your original `/asset_report/create` request, but the original `days_requested` value and the values of any parameters in the `options` object can be overridden with new values. To change these arguments, simply supply new values for them in your request to `/asset_report/refresh`. Submit an empty string (\"\") for any previously-populated fields you would like set as empty.
     * @summary Refresh an Asset Report
     * @param {AssetReportRefreshRequest} assetReportRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportRefresh(assetReportRefreshRequest: AssetReportRefreshRequest, options?: any): AxiosPromise<AssetReportRefreshResponse>;
    /**
     * The `/item/remove` endpoint allows you to invalidate an `access_token`, meaning you will not be able to create new Asset Reports with it. Removing an Item does not affect any Asset Reports or Audit Copies you have already created, which will remain accessible until you remove them specifically.  The `/asset_report/remove` endpoint allows you to remove an Asset Report. Removing an Asset Report invalidates its `asset_report_token`, meaning you will no longer be able to use it to access Report data or create new Audit Copies. Removing an Asset Report does not affect the underlying Items, but does invalidate any `audit_copy_tokens` associated with the Asset Report.
     * @summary Delete an Asset Report
     * @param {AssetReportRemoveRequest} assetReportRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    assetReportRemove(assetReportRemoveRequest: AssetReportRemoveRequest, options?: any): AxiosPromise<AssetReportRemoveResponse>;
    /**
     * The `/auth/get` endpoint returns the bank account and bank identification numbers (such as routing numbers, for US accounts) associated with an Item\'s checking and savings accounts, along with high-level account data and balances when available.  Note: This request may take some time to complete if `auth` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.  Also note that `/auth/get` will not return data for any new accounts opened after the Item was created. To obtain data for new accounts, create a new Item.  Versioning note: In API version 2017-03-08, the schema of the `numbers` object returned by this endpoint is substantially different. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2018-05-22).
     * @summary Retrieve auth data
     * @param {AuthGetRequest} authGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    authGet(authGetRequest: AuthGetRequest, options?: any): AxiosPromise<AuthGetResponse>;
    /**
     * Use the `/bank_transfer/balance/get` endpoint to see the available balance in your bank transfer account. Debit transfers increase this balance once their status is posted. Credit transfers decrease this balance when they are created.  The transactable balance shows the amount in your account that you are able to use for transfers, and is essentially your available balance minus your minimum balance.  Note that this endpoint can only be used with FBO accounts, when using Bank Transfers in the Full Service configuration. It cannot be used on your own account when using Bank Transfers in the BTS Platform configuration.
     * @summary Get balance of your Bank Transfer account
     * @param {BankTransferBalanceGetRequest} bankTransferBalanceGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferBalanceGet(bankTransferBalanceGetRequest: BankTransferBalanceGetRequest, options?: any): AxiosPromise<BankTransferBalanceGetResponse>;
    /**
     * Use the `/bank_transfer/cancel` endpoint to cancel a bank transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/bank_transfer/get` is `true`.
     * @summary Cancel a bank transfer
     * @param {BankTransferCancelRequest} bankTransferCancelRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferCancel(bankTransferCancelRequest: BankTransferCancelRequest, options?: any): AxiosPromise<BankTransferCancelResponse>;
    /**
     * Use the `/bank_transfer/create` endpoint to initiate a new bank transfer.
     * @summary Create a bank transfer
     * @param {BankTransferCreateRequest} bankTransferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferCreate(bankTransferCreateRequest: BankTransferCreateRequest, options?: any): AxiosPromise<BankTransferCreateResponse>;
    /**
     * Use the `/bank_transfer/event/list` endpoint to get a list of bank transfer events based on specified filter criteria.
     * @summary List bank transfer events
     * @param {BankTransferEventListRequest} bankTransferEventListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferEventList(bankTransferEventListRequest: BankTransferEventListRequest, options?: any): AxiosPromise<BankTransferEventListResponse>;
    /**
     * `/bank_transfer/event/sync` allows you to request up to the next 25 bank transfer events that happened after a specific `event_id`. Use the `/bank_transfer/event/sync` endpoint to guarantee you have seen all bank transfer events.
     * @summary Sync bank transfer events
     * @param {BankTransferEventSyncRequest} bankTransferEventSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferEventSync(bankTransferEventSyncRequest: BankTransferEventSyncRequest, options?: any): AxiosPromise<BankTransferEventSyncResponse>;
    /**
     * The `/bank_transfer/get` fetches information about the bank transfer corresponding to the given `bank_transfer_id`.
     * @summary Retrieve a bank transfer
     * @param {BankTransferGetRequest} bankTransferGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferGet(bankTransferGetRequest: BankTransferGetRequest, options?: any): AxiosPromise<BankTransferGetResponse>;
    /**
     * Use the `/bank_transfer/list` endpoint to see a list of all your bank transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired bank transfers.
     * @summary List bank transfers
     * @param {BankTransferListRequest} bankTransferListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferList(bankTransferListRequest: BankTransferListRequest, options?: any): AxiosPromise<BankTransferListResponse>;
    /**
     * As an alternative to adding Items via Link, you can also use the `/bank_transfer/migrate_account` endpoint to migrate known account and routing numbers to Plaid Items.  Note that Items created in this way are not compatible with endpoints for other products, such as `/accounts/balance/get`, and can only be used with Bank Transfer endpoints.  If you require access to other endpoints, create the Item through Link instead.  Access to `/bank_transfer/migrate_account` is not enabled by default; to obtain access, contact your Plaid Account Manager.
     * @summary Migrate account into Bank Transfers
     * @param {BankTransferMigrateAccountRequest} bankTransferMigrateAccountRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferMigrateAccount(bankTransferMigrateAccountRequest: BankTransferMigrateAccountRequest, options?: any): AxiosPromise<BankTransferMigrateAccountResponse>;
    /**
     * The `/bank_transfer/sweep/get` endpoint fetches information about the sweep corresponding to the given `sweep_id`.
     * @summary Retrieve a sweep
     * @param {BankTransferSweepGetRequest} bankTransferSweepGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferSweepGet(bankTransferSweepGetRequest: BankTransferSweepGetRequest, options?: any): AxiosPromise<BankTransferSweepGetResponse>;
    /**
     * The `/bank_transfer/sweep/list` endpoint fetches information about the sweeps matching the given filters.
     * @summary List sweeps
     * @param {BankTransferSweepListRequest} bankTransferSweepListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    bankTransferSweepList(bankTransferSweepListRequest: BankTransferSweepListRequest, options?: any): AxiosPromise<BankTransferSweepListResponse>;
    /**
     * Send a request to the `/categories/get` endpoint to get detailed information on categories returned by Plaid. This endpoint does not require authentication.
     * @summary Get Categories
     * @param {object} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    categoriesGet(body: object, options?: any): AxiosPromise<CategoriesGetResponse>;
    /**
     * The `/payment_initiation/payment/token/create` endpoint has been deprecated. New Plaid customers will be unable to use this endpoint, and existing customers are encouraged to migrate to the newer, `link_token`-based flow. The recommended flow is to provide the `payment_id` to `/link/token/create`, which returns a `link_token` used to initialize Link.  The `/payment_initiation/payment/token/create` is used to create a `payment_token`, which can then be used in Link initialization to enter a payment initiation flow. You can only use a `payment_token` once. If this attempt fails, the end user aborts the flow, or the token expires, you will need to create a new payment token. Creating a new payment token does not require end user input.
     * @summary Create payment token
     * @param {PaymentInitiationPaymentTokenCreateRequest} paymentInitiationPaymentTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPaymentToken(paymentInitiationPaymentTokenCreateRequest: PaymentInitiationPaymentTokenCreateRequest, options?: any): AxiosPromise<PaymentInitiationPaymentTokenCreateResponse>;
    /**
     * This endpoint provides an alternative to `/deposit_switch/create` for customers who have not yet fully integrated with Plaid Exchange. Like `/deposit_switch/create`, it creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.
     * @summary Create a deposit switch without using Plaid Exchange
     * @param {DepositSwitchAltCreateRequest} depositSwitchAltCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchAltCreate(depositSwitchAltCreateRequest: DepositSwitchAltCreateRequest, options?: any): AxiosPromise<DepositSwitchAltCreateResponse>;
    /**
     * This endpoint creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.
     * @summary Create a deposit switch
     * @param {DepositSwitchCreateRequest} depositSwitchCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchCreate(depositSwitchCreateRequest: DepositSwitchCreateRequest, options?: any): AxiosPromise<DepositSwitchCreateResponse>;
    /**
     * This endpoint returns information related to how the user has configured their payroll allocation and the state of the switch. You can use this information to build logic related to the user\'s direct deposit allocation preferences.
     * @summary Retrieve a deposit switch
     * @param {DepositSwitchGetRequest} depositSwitchGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchGet(depositSwitchGetRequest: DepositSwitchGetRequest, options?: any): AxiosPromise<DepositSwitchGetResponse>;
    /**
     * In order for the end user to take action, you will need to create a public token representing the deposit switch. This token is used to initialize Link. It can be used one time and expires after 30 minutes.
     * @summary Create a deposit switch token
     * @param {DepositSwitchTokenCreateRequest} depositSwitchTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    depositSwitchTokenCreate(depositSwitchTokenCreateRequest: DepositSwitchTokenCreateRequest, options?: any): AxiosPromise<DepositSwitchTokenCreateResponse>;
    /**
     * `/employers/search` allows you the ability to search Plaid’s database of known employers, for use with Deposit Switch. You can use this endpoint to look up a user\'s employer in order to confirm that they are supported. Users with non-supported employers can then be routed out of the Deposit Switch flow.  The data in the employer database is currently limited. As the Deposit Switch and Income products progress through their respective beta periods, more employers are being regularly added. Because the employer database is frequently updated, we recommend that you do not cache or store data from this endpoint for more than a day.
     * @summary Search employer database
     * @param {EmployersSearchRequest} employersSearchRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    employersSearch(employersSearchRequest: EmployersSearchRequest, options?: any): AxiosPromise<EmployersSearchResponse>;
    /**
     * `/employment/verification/get` returns a list of employments through a user payroll that was verified by an end user.
     * @summary Retrieve a summary of an individual\'s employment information
     * @param {EmploymentVerificationGetRequest} employmentVerificationGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    employmentVerificationGet(employmentVerificationGetRequest: EmploymentVerificationGetRequest, options?: any): AxiosPromise<EmploymentVerificationGetResponse>;
    /**
     * The `/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses. Only name data is guaranteed to be returned; other fields will be empty arrays if not provided by the institution.  Note: This request may take some time to complete if identity was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.
     * @summary Retrieve identity data
     * @param {IdentityGetRequest} identityGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    identityGet(identityGetRequest: IdentityGetRequest, options?: any): AxiosPromise<IdentityGetResponse>;
    /**
     * `/income/verification/create` begins the income verification process by returning an `income_verification_id`. You can then provide the `income_verification_id` to `/link/token/create` under the `income_verification` parameter in order to create a Link instance that will prompt the user to go through the income verification flow. Plaid will fire an `INCOME` webhook once the user completes the Payroll Income flow, or when the uploaded documents in the Document Income flow have finished processing.
     * @summary (Deprecated) Create an income verification instance
     * @param {IncomeVerificationCreateRequest} incomeVerificationCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationCreate(incomeVerificationCreateRequest: IncomeVerificationCreateRequest, options?: any): AxiosPromise<IncomeVerificationCreateResponse>;
    /**
     * `/income/verification/documents/download` provides the ability to download the source documents associated with the verification.  If Document Income was used, the documents will be those the user provided in Link. For Payroll Income, the most recent files available for download from the payroll provider will be available from this endpoint.  The response to `/income/verification/documents/download` is a ZIP file in binary data. If a `document_id` is passed, a single document will be contained in this file. If not, the response will contain all documents associated with the verification.  The `request_id` is returned in the `Plaid-Request-ID` header.
     * @summary Download the original documents used for income verification
     * @param {IncomeVerificationDocumentsDownloadRequest} incomeVerificationDocumentsDownloadRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationDocumentsDownload(incomeVerificationDocumentsDownloadRequest: IncomeVerificationDocumentsDownloadRequest, options?: any): AxiosPromise<any>;
    /**
     * /income/verification/paystub/get returns information from a single paystub used for income verification
     * @summary (Deprecated) Retrieve information from a single paystub used for income verification
     * @param {IncomeVerificationPaystubGetRequest} incomeVerificationPaystubGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPaystubGet(incomeVerificationPaystubGetRequest: IncomeVerificationPaystubGetRequest, options?: any): AxiosPromise<IncomeVerificationPaystubGetResponse>;
    /**
     * `/income/verification/paystubs/get` returns the information collected from the paystubs that were used to verify an end user\'s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary Retrieve information from the paystubs used for income verification
     * @param {IncomeVerificationPaystubsGetRequest} incomeVerificationPaystubsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPaystubsGet(incomeVerificationPaystubsGetRequest: IncomeVerificationPaystubsGetRequest, options?: any): AxiosPromise<IncomeVerificationPaystubsGetResponse>;
    /**
     * `/income/verification/precheck` is an optional endpoint that can be called before initializing a Link session for income verification. It evaluates whether a given user is supportable by digital income verification and returns a `precheck_id` that can be provided to `/link/token/create`. If the user is eligible for digital verification, providing the `precheck_id` in this way will generate a Link UI optimized for the end user and their specific employer. If the user cannot be confirmed as eligible, the `precheck_id` can still be provided to `/link/token/create` and the user can still use the income verification flow, but they may be required to manually upload a paystub to verify their income.  While all request fields are optional, providing either `employer` or `transactions_access_tokens` data will increase the chance of receiving a useful result.
     * @summary Check digital income verification eligibility and optimize conversion
     * @param {IncomeVerificationPrecheckRequest} incomeVerificationPrecheckRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationPrecheck(incomeVerificationPrecheckRequest: IncomeVerificationPrecheckRequest, options?: any): AxiosPromise<IncomeVerificationPrecheckResponse>;
    /**
     * `/income/verification/refresh` refreshes a given income verification.
     * @summary Refresh an income verification
     * @param {IncomeVerificationRefreshRequest} incomeVerificationRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationRefresh(incomeVerificationRefreshRequest: IncomeVerificationRefreshRequest, options?: any): AxiosPromise<IncomeVerificationRefreshResponse>;
    /**
     * `/income/verification/summary/get` returns a verification summary for the income that was verified for an end user. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary (Deprecated) Retrieve a summary of information derived from income verification
     * @param {IncomeVerificationSummaryGetRequest} incomeVerificationSummaryGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationSummaryGet(incomeVerificationSummaryGetRequest: IncomeVerificationSummaryGetRequest, options?: any): AxiosPromise<IncomeVerificationSummaryGetResponse>;
    /**
     * `/income/verification/taxforms/get` returns the information collected from forms that were used to verify an end user\'s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary Retrieve information from the tax documents used for income verification
     * @param {{ [key: string]: object; }} requestBody
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    incomeVerificationTaxformsGet(requestBody: {
        [key: string]: object;
    }, options?: any): AxiosPromise<IncomeVerificationTaxformsGetResponse>;
    /**
     * Returns a JSON response containing details on all financial institutions currently supported by Plaid. Because Plaid supports thousands of institutions, results are paginated.  If there is no overlap between an institution’s enabled products and a client’s enabled products, then the institution will be filtered out from the response. As a result, the number of institutions returned may not match the count specified in the call.
     * @summary Get details of all supported institutions
     * @param {InstitutionsGetRequest} institutionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsGet(institutionsGetRequest: InstitutionsGetRequest, options?: any): AxiosPromise<InstitutionsGetResponse>;
    /**
     * Returns a JSON response containing details on a specified financial institution currently supported by Plaid.   Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` to authenticate to this endpoint. The `public_key` has been deprecated; all customers are encouraged to use `client_id` and `secret` instead.
     * @summary Get details of an institution
     * @param {InstitutionsGetByIdRequest} institutionsGetByIdRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsGetById(institutionsGetByIdRequest: InstitutionsGetByIdRequest, options?: any): AxiosPromise<InstitutionsGetByIdResponse>;
    /**
     * Returns a JSON response containing details for institutions that match the query parameters, up to a maximum of ten institutions per query.  Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` parameters to authenticate to this endpoint. The `public_key` parameter has since been deprecated; all customers are encouraged to use `client_id` and `secret` instead.
     * @summary Search institutions
     * @param {InstitutionsSearchRequest} institutionsSearchRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    institutionsSearch(institutionsSearchRequest: InstitutionsSearchRequest, options?: any): AxiosPromise<InstitutionsSearchResponse>;
    /**
     * The `/investments/holdings/get` endpoint allows developers to receive user-authorized stock position data for `investment`-type accounts.
     * @summary Get Investment holdings
     * @param {InvestmentsHoldingsGetRequest} investmentsHoldingsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    investmentsHoldingsGet(investmentsHoldingsGetRequest: InvestmentsHoldingsGetRequest, options?: any): AxiosPromise<InvestmentsHoldingsGetResponse>;
    /**
     * The `/investments/transactions/get` endpoint allows developers to retrieve user-authorized transaction data for investment accounts.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Due to the potentially large number of investment transactions associated with an Item, results are paginated. Manipulate the count and offset parameters in conjunction with the `total_investment_transactions` response body field to fetch all available investment transactions.
     * @summary Get investment transactions
     * @param {InvestmentsTransactionsGetRequest} investmentsTransactionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    investmentsTransactionsGet(investmentsTransactionsGetRequest: InvestmentsTransactionsGetRequest, options?: any): AxiosPromise<InvestmentsTransactionsGetResponse>;
    /**
     * By default, the `access_token` associated with an Item does not expire and should be stored in a persistent, secure manner.  You can use the `/item/access_token/invalidate` endpoint to rotate the `access_token` associated with an Item. The endpoint returns a new `access_token` and immediately invalidates the previous `access_token`.
     * @summary Invalidate access_token
     * @param {ItemAccessTokenInvalidateRequest} itemAccessTokenInvalidateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemAccessTokenInvalidate(itemAccessTokenInvalidateRequest: ItemAccessTokenInvalidateRequest, options?: any): AxiosPromise<ItemAccessTokenInvalidateResponse>;
    /**
     * List a user’s connected applications
     * @summary List a user’s connected applications
     * @param {ItemApplicationListRequest} itemApplicationListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemApplicationList(itemApplicationListRequest: ItemApplicationListRequest, options?: any): AxiosPromise<ItemApplicationListResponse>;
    /**
     * Enable consumers to update product access on selected accounts for an application.
     * @summary Update the scopes of access for a particular application
     * @param {ItemApplicationScopesUpdateRequest} itemApplicationScopesUpdateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemApplicationScopesUpdate(itemApplicationScopesUpdateRequest: ItemApplicationScopesUpdateRequest, options?: any): AxiosPromise<ItemApplicationScopesUpdateResponse>;
    /**
     * Note: As of July 2020, the `/item/public_token/create` endpoint is deprecated. Instead, use `/link/token/create` with an `access_token` to create a Link token for use with [update mode](https://plaid.com/docs/link/update-mode).  If you need your user to take action to restore or resolve an error associated with an Item, generate a public token with the `/item/public_token/create` endpoint and then initialize Link with that `public_token`.  A `public_token` is one-time use and expires after 30 minutes. You use a `public_token` to initialize Link in [update mode](https://plaid.com/docs/link/update-mode) for a particular Item. You can generate a `public_token` for an Item even if you did not use Link to create the Item originally.  The `/item/public_token/create` endpoint is **not** used to create your initial `public_token`. If you have not already received an `access_token` for a specific Item, use Link to obtain your `public_token` instead. See the [Quickstart](https://plaid.com/docs/quickstart) for more information.
     * @summary Create public token
     * @param {ItemPublicTokenCreateRequest} itemPublicTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemCreatePublicToken(itemPublicTokenCreateRequest: ItemPublicTokenCreateRequest, options?: any): AxiosPromise<ItemPublicTokenCreateResponse>;
    /**
     * Returns information about the status of an Item.
     * @summary Retrieve an Item
     * @param {ItemGetRequest} itemGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemGet(itemGetRequest: ItemGetRequest, options?: any): AxiosPromise<ItemGetResponse>;
    /**
     * `/item/import` creates an Item via your Plaid Exchange Integration and returns an `access_token`. As part of an `/item/import` request, you will include a User ID (`user_auth.user_id`) and Authentication Token (`user_auth.auth_token`) that enable data aggregation through your Plaid Exchange API endpoints. These authentication principals are to be chosen by you.  Upon creating an Item via `/item/import`, Plaid will automatically begin an extraction of that Item through the Plaid Exchange infrastructure you have already integrated. This will automatically generate the Plaid native account ID for the account the user will switch their direct deposit to (`target_account_id`).
     * @summary Import Item
     * @param {ItemImportRequest} itemImportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemImport(itemImportRequest: ItemImportRequest, options?: any): AxiosPromise<ItemImportResponse>;
    /**
     * Exchange a Link `public_token` for an API `access_token`. Link hands off the `public_token` client-side via the `onSuccess` callback once a user has successfully created an Item. The `public_token` is ephemeral and expires after 30 minutes.  The response also includes an `item_id` that should be stored with the `access_token`. The `item_id` is used to identify an Item in a webhook. The `item_id` can also be retrieved by making an `/item/get` request.
     * @summary Exchange public token for an access token
     * @param {ItemPublicTokenExchangeRequest} itemPublicTokenExchangeRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemPublicTokenExchange(itemPublicTokenExchangeRequest: ItemPublicTokenExchangeRequest, options?: any): AxiosPromise<ItemPublicTokenExchangeResponse>;
    /**
     * The `/item/remove`  endpoint allows you to remove an Item. Once removed, the `access_token`  associated with the Item is no longer valid and cannot be used to access any data that was associated with the Item.  Note that in the Development environment, issuing an `/item/remove`  request will not decrement your live credential count. To increase your credential account in Development, contact Support.  Also note that for certain OAuth-based institutions, an Item removed via `/item/remove` may still show as an active connection in the institution\'s OAuth permission manager.  API versions 2019-05-29 and earlier return a `removed` boolean as part of the response.
     * @summary Remove an Item
     * @param {ItemRemoveRequest} itemRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemRemove(itemRemoveRequest: ItemRemoveRequest, options?: any): AxiosPromise<ItemRemoveResponse>;
    /**
     * The POST `/item/webhook/update` allows you to update the webhook URL associated with an Item. This request triggers a [`WEBHOOK_UPDATE_ACKNOWLEDGED`](https://plaid.com/docs/api/webhooks/#item-webhook-update-acknowledged) webhook to the newly specified webhook URL.
     * @summary Update Webhook URL
     * @param {ItemWebhookUpdateRequest} itemWebhookUpdateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    itemWebhookUpdate(itemWebhookUpdateRequest: ItemWebhookUpdateRequest, options?: any): AxiosPromise<ItemWebhookUpdateResponse>;
    /**
     * The `/liabilities/get` endpoint returns various details about an Item with loan or credit accounts. Liabilities data is available primarily for US financial institutions, with some limited coverage of Canadian institutions. Currently supported account types are account type `credit` with account subtype `credit card` or `paypal`, and account type `loan` with account subtype `student` or `mortgage`. To limit accounts listed in Link to types and subtypes supported by Liabilities, you can use the `account_filters` parameter when [creating a Link token](https://plaid.com/docs/api/tokens/#linktokencreate).  The types of information returned by Liabilities can include balances and due dates, loan terms, and account details such as original loan amount and guarantor. Data is refreshed approximately once per day; the latest data can be retrieved by calling `/liabilities/get`.  Note: This request may take some time to complete if `liabilities` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the additional data.
     * @summary Retrieve Liabilities data
     * @param {LiabilitiesGetRequest} liabilitiesGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    liabilitiesGet(liabilitiesGetRequest: LiabilitiesGetRequest, options?: any): AxiosPromise<LiabilitiesGetResponse>;
    /**
     * The `/link/token/create` endpoint creates a `link_token`, which is required as a parameter when initializing Link. Once Link has been initialized, it returns a `public_token`, which can then be exchanged for an `access_token` via `/item/public_token/exchange` as part of the main Link flow.  A `link_token` generated by `/link/token/create` is also used to initialize other Link flows, such as the update mode flow for tokens with expired credentials, or the Payment Initiation (Europe) flow.
     * @summary Create Link Token
     * @param {LinkTokenCreateRequest} linkTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    linkTokenCreate(linkTokenCreateRequest: LinkTokenCreateRequest, options?: any): AxiosPromise<LinkTokenCreateResponse>;
    /**
     * The `/link/token/get` endpoint gets information about a previously-created `link_token` using the `/link/token/create` endpoint. It can be useful for debugging purposes.
     * @summary Get Link Token
     * @param {LinkTokenGetRequest} linkTokenGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    linkTokenGet(linkTokenGetRequest: LinkTokenGetRequest, options?: any): AxiosPromise<LinkTokenGetResponse>;
    /**
     * After creating a payment recipient, you can use the `/payment_initiation/payment/create` endpoint to create a payment to that recipient.  Payments can be one-time or standing order (recurring) and can be denominated in either EUR or GBP.  If making domestic GBP-denominated payments, your recipient must have been created with BACS numbers. In general, EUR-denominated payments will be sent via SEPA Credit Transfer and GBP-denominated payments will be sent via the Faster Payments network, but the payment network used will be determined by the institution. Payments sent via Faster Payments will typically arrive immediately, while payments sent via SEPA Credit Transfer will typically arrive in one business day.  Standing orders (recurring payments) must be denominated in GBP and can only be sent to recipients in the UK. Once created, standing order payments cannot be modified or canceled via the API. An end user can cancel or modify a standing order directly on their banking application or website, or by contacting the bank. Standing orders will follow the payment rules of the underlying rails (Faster Payments in UK). Payments can be sent Monday to Friday, excluding bank holidays. If the pre-arranged date falls on a weekend or bank holiday, the payment is made on the next working day. It is not possible to guarantee the exact time the payment will reach the recipient’s account, although at least 90% of standing order payments are sent by 6am.  In the Development environment, payments must be below 5 GBP / EUR. For details on any payment limits in Production, contact your Plaid Account Manager.
     * @summary Create a payment
     * @param {PaymentInitiationPaymentCreateRequest} paymentInitiationPaymentCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentCreate(paymentInitiationPaymentCreateRequest: PaymentInitiationPaymentCreateRequest, options?: any): AxiosPromise<PaymentInitiationPaymentCreateResponse>;
    /**
     * The `/payment_initiation/payment/get` endpoint can be used to check the status of a payment, as well as to receive basic information such as recipient and payment amount. In the case of standing orders, the `/payment_initiation/payment/get` endpoint will provide information about the status of the overall standing order itself; the API cannot be used to retrieve payment status for individual payments within a standing order.
     * @summary Get payment details
     * @param {PaymentInitiationPaymentGetRequest} paymentInitiationPaymentGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentGet(paymentInitiationPaymentGetRequest: PaymentInitiationPaymentGetRequest, options?: any): AxiosPromise<PaymentInitiationPaymentGetResponse>;
    /**
     * The `/payment_initiation/payment/list` endpoint can be used to retrieve all created payments. By default, the 10 most recent payments are returned. You can request more payments and paginate through the results using the optional `count` and `cursor` parameters.
     * @summary List payments
     * @param {PaymentInitiationPaymentListRequest} paymentInitiationPaymentListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentList(paymentInitiationPaymentListRequest: PaymentInitiationPaymentListRequest, options?: any): AxiosPromise<PaymentInitiationPaymentListResponse>;
    /**
     * Reverse a previously initiated payment.  A payment can only be reversed once and will be refunded to the original sender\'s account.
     * @summary Reverse an existing payment
     * @param {PaymentInitiationPaymentReverseRequest} paymentInitiationPaymentReverseRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationPaymentReverse(paymentInitiationPaymentReverseRequest: PaymentInitiationPaymentReverseRequest, options?: any): AxiosPromise<PaymentInitiationPaymentReverseResponse>;
    /**
     * Create a payment recipient for payment initiation.  The recipient must be in Europe, within a country that is a member of the Single Euro Payment Area (SEPA).  For a standing order (recurring) payment, the recipient must be in the UK.  The endpoint is idempotent: if a developer has already made a request with the same payment details, Plaid will return the same `recipient_id`.
     * @summary Create payment recipient
     * @param {PaymentInitiationRecipientCreateRequest} paymentInitiationRecipientCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientCreate(paymentInitiationRecipientCreateRequest: PaymentInitiationRecipientCreateRequest, options?: any): AxiosPromise<PaymentInitiationRecipientCreateResponse>;
    /**
     * Get details about a payment recipient you have previously created.
     * @summary Get payment recipient
     * @param {PaymentInitiationRecipientGetRequest} paymentInitiationRecipientGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientGet(paymentInitiationRecipientGetRequest: PaymentInitiationRecipientGetRequest, options?: any): AxiosPromise<PaymentInitiationRecipientGetResponse>;
    /**
     * The `/payment_initiation/recipient/list` endpoint list the payment recipients that you have previously created.
     * @summary List payment recipients
     * @param {PaymentInitiationRecipientListRequest} paymentInitiationRecipientListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    paymentInitiationRecipientList(paymentInitiationRecipientListRequest: PaymentInitiationRecipientListRequest, options?: any): AxiosPromise<PaymentInitiationRecipientListResponse>;
    /**
     * Used to create a token suitable for sending to Apex to enable Plaid-Apex integrations.
     * @summary Create Apex bank account token
     * @param {ProcessorApexProcessorTokenCreateRequest} processorApexProcessorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorApexProcessorTokenCreate(processorApexProcessorTokenCreateRequest: ProcessorApexProcessorTokenCreateRequest, options?: any): AxiosPromise<ProcessorTokenCreateResponse>;
    /**
     * The `/processor/auth/get` endpoint returns the bank account and bank identification number (such as the routing number, for US accounts), for a checking or savings account that\'\'s associated with a given `processor_token`. The endpoint also returns high-level account data and balances when available.   Versioning note: API versions 2019-05-29 and earlier use a different schema for the `numbers` object returned by this endpoint. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2020-09-14).
     * @summary Retrieve Auth data
     * @param {ProcessorAuthGetRequest} processorAuthGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorAuthGet(processorAuthGetRequest: ProcessorAuthGetRequest, options?: any): AxiosPromise<ProcessorAuthGetResponse>;
    /**
     * The `/processor/balance/get` endpoint returns the real-time balance for each of an Item\'s accounts. While other endpoints may return a balance object, only `/processor/balance/get` forces the available and current balance fields to be refreshed rather than cached.
     * @summary Retrieve Balance data
     * @param {ProcessorBalanceGetRequest} processorBalanceGetRequest The &#x60;/processor/balance/get&#x60; endpoint returns the real-time balance for the account associated with a given &#x60;processor_token&#x60;.  The current balance is the total amount of funds in the account. The available balance is the current balance less any outstanding holds or debits that have not yet posted to the account.  Note that not all institutions calculate the available balance. In the event that available balance is unavailable from the institution, Plaid will return an available balance value of &#x60;null&#x60;.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorBalanceGet(processorBalanceGetRequest: ProcessorBalanceGetRequest, options?: any): AxiosPromise<ProcessorBalanceGetResponse>;
    /**
     * Use the `/processor/bank_transfer/create` endpoint to initiate a new bank transfer as a processor
     * @summary Create a bank transfer as a processor
     * @param {ProcessorBankTransferCreateRequest} processorBankTransferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorBankTransferCreate(processorBankTransferCreateRequest: ProcessorBankTransferCreateRequest, options?: any): AxiosPromise<ProcessorBankTransferCreateResponse>;
    /**
     * The `/processor/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses.
     * @summary Retrieve Identity data
     * @param {ProcessorIdentityGetRequest} processorIdentityGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorIdentityGet(processorIdentityGetRequest: ProcessorIdentityGetRequest, options?: any): AxiosPromise<ProcessorIdentityGetResponse>;
    /**
     * Used to create a token suitable for sending to Stripe to enable Plaid-Stripe integrations. For a detailed guide on integrating Stripe, see [Add Stripe to your app](https://plaid.com/docs/auth/partnerships/stripe/).
     * @summary Create Stripe bank account token
     * @param {ProcessorStripeBankAccountTokenCreateRequest} processorStripeBankAccountTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorStripeBankAccountTokenCreate(processorStripeBankAccountTokenCreateRequest: ProcessorStripeBankAccountTokenCreateRequest, options?: any): AxiosPromise<ProcessorStripeBankAccountTokenCreateResponse>;
    /**
     * Used to create a token suitable for sending to one of Plaid\'s partners to enable integrations. Note that Stripe partnerships use bank account tokens instead; see `/processor/stripe/bank_account_token/create` for creating tokens for use with Stripe integrations.
     * @summary Create processor token
     * @param {ProcessorTokenCreateRequest} processorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    processorTokenCreate(processorTokenCreateRequest: ProcessorTokenCreateRequest, options?: any): AxiosPromise<ProcessorTokenCreateResponse>;
    /**
     * Use the `/sandbox/bank_transfer/fire_webhook` endpoint to manually trigger a Bank Transfers webhook in the Sandbox environment.
     * @summary Manually fire a Bank Transfer webhook
     * @param {SandboxBankTransferFireWebhookRequest} sandboxBankTransferFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxBankTransferFireWebhook(sandboxBankTransferFireWebhookRequest: SandboxBankTransferFireWebhookRequest, options?: any): AxiosPromise<SandboxBankTransferFireWebhookResponse>;
    /**
     * Use the `/sandbox/bank_transfer/simulate` endpoint to simulate a bank transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/bank_transfer/event/sync` or `/bank_transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.
     * @summary Simulate a bank transfer event in Sandbox
     * @param {SandboxBankTransferSimulateRequest} sandboxBankTransferSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxBankTransferSimulate(sandboxBankTransferSimulateRequest: SandboxBankTransferSimulateRequest, options?: any): AxiosPromise<SandboxBankTransferSimulateResponse>;
    /**
     * Use the `/sandbox/income/fire_webhook` endpoint to manually trigger an Income webhook in the Sandbox environment.
     * @summary Manually fire an Income webhook
     * @param {SandboxIncomeFireWebhookRequest} sandboxIncomeFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxIncomeFireWebhook(sandboxIncomeFireWebhookRequest: SandboxIncomeFireWebhookRequest, options?: any): AxiosPromise<SandboxIncomeFireWebhookResponse>;
    /**
     * The `/sandbox/item/fire_webhook` endpoint is used to test that code correctly handles webhooks. This endpoint can trigger a Transactions `DEFAULT_UPDATE` webhook to be fired for a given Sandbox Item. If the Item does not support Transactions, a `SANDBOX_PRODUCT_NOT_ENABLED` error will result. This endpoint can also trigger a `NEW_ACCOUNTS_AVAILABLE` webhook to be fired for a given Sandbox Item created with Account Select v2. Note that this endpoint is provided for developer ease-of-use and is not required for testing webhooks; webhooks will also fire in Sandbox under the same conditions that they would in Production or Development.
     * @summary Fire a test webhook
     * @param {SandboxItemFireWebhookRequest} sandboxItemFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemFireWebhook(sandboxItemFireWebhookRequest: SandboxItemFireWebhookRequest, options?: any): AxiosPromise<SandboxItemFireWebhookResponse>;
    /**
     * `/sandbox/item/reset_login/` forces an Item into an `ITEM_LOGIN_REQUIRED` state in order to simulate an Item whose login is no longer valid. This makes it easy to test Link\'s [update mode](https://plaid.com/docs/link/update-mode) flow in the Sandbox environment.  After calling `/sandbox/item/reset_login`, You can then use Plaid Link update mode to restore the Item to a good state. An `ITEM_LOGIN_REQUIRED` webhook will also be fired after a call to this endpoint, if one is associated with the Item.   In the Sandbox, Items will transition to an `ITEM_LOGIN_REQUIRED` error state automatically after 30 days, even if this endpoint is not called.
     * @summary Force a Sandbox Item into an error state
     * @param {SandboxItemResetLoginRequest} sandboxItemResetLoginRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemResetLogin(sandboxItemResetLoginRequest: SandboxItemResetLoginRequest, options?: any): AxiosPromise<SandboxItemResetLoginResponse>;
    /**
     * The `/sandbox/item/set_verification_status` endpoint can be used to change the verification status of an Item in in the Sandbox in order to simulate the Automated Micro-deposit flow.  Note that not all Plaid developer accounts are enabled for micro-deposit based verification by default. Your account must be enabled for this feature in order to test it in Sandbox. To enable this features or check your status, contact your account manager or [submit a product access Support ticket](https://dashboard.plaid.com/support/new/product-and-development/product-troubleshooting/request-product-access).  For more information on testing Automated Micro-deposits in Sandbox, see [Auth full coverage testing](https://plaid.com/docs/auth/coverage/testing#).
     * @summary Set verification status for Sandbox account
     * @param {SandboxItemSetVerificationStatusRequest} sandboxItemSetVerificationStatusRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxItemSetVerificationStatus(sandboxItemSetVerificationStatusRequest: SandboxItemSetVerificationStatusRequest, options?: any): AxiosPromise<SandboxItemSetVerificationStatusResponse>;
    /**
     * Save the selected accounts when connecting to the Platypus Oauth institution
     * @summary Save the selected accounts when connecting to the Platypus Oauth institution
     * @param {SandboxOauthSelectAccountsRequest} sandboxOauthSelectAccountsRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxOauthSelectAccounts(sandboxOauthSelectAccountsRequest: SandboxOauthSelectAccountsRequest, options?: any): AxiosPromise<{
        [key: string]: object;
    }>;
    /**
     * Use the `/sandbox/processor_token/create` endpoint to create a valid `processor_token` for an arbitrary institution ID and test credentials. The created `processor_token` corresponds to a new Sandbox Item. You can then use this `processor_token` with the `/processor/` API endpoints in Sandbox. You can also use `/sandbox/processor_token/create` with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data.
     * @summary Create a test Item and processor token
     * @param {SandboxProcessorTokenCreateRequest} sandboxProcessorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxProcessorTokenCreate(sandboxProcessorTokenCreateRequest: SandboxProcessorTokenCreateRequest, options?: any): AxiosPromise<SandboxProcessorTokenCreateResponse>;
    /**
     * Use the `/sandbox/public_token/create` endpoint to create a valid `public_token`  for an arbitrary institution ID, initial products, and test credentials. The created `public_token` maps to a new Sandbox Item. You can then call `/item/public_token/exchange` to exchange the `public_token` for an `access_token` and perform all API actions. `/sandbox/public_token/create` can also be used with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data. `/sandbox/public_token/create` cannot be used with OAuth institutions.
     * @summary Create a test Item
     * @param {SandboxPublicTokenCreateRequest} sandboxPublicTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxPublicTokenCreate(sandboxPublicTokenCreateRequest: SandboxPublicTokenCreateRequest, options?: any): AxiosPromise<SandboxPublicTokenCreateResponse>;
    /**
     * Use the `/sandbox/transfer/repayment/simulate` endpoint to trigger the creation of a repayment. As a side effect of calling this route, a repayment is created that includes all unreimbursed returns of guaranteed transfers. If there are no such returns, an 400 error is returned.
     * @summary Trigger the creation of a repayment
     * @param {SandboxTransferRepaymentSimulateRequest} sandboxTransferRepaymentSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferRepaymentSimulate(sandboxTransferRepaymentSimulateRequest: SandboxTransferRepaymentSimulateRequest, options?: any): AxiosPromise<SandboxTransferRepaymentSimulateResponse>;
    /**
     * Use the `/sandbox/transfer/simulate` endpoint to simulate a transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/transfer/event/sync` or `/transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.
     * @summary Simulate a transfer event in Sandbox
     * @param {SandboxTransferSimulateRequest} sandboxTransferSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferSimulate(sandboxTransferSimulateRequest: SandboxTransferSimulateRequest, options?: any): AxiosPromise<SandboxTransferSimulateResponse>;
    /**
     * Use the `/sandbox/transfer/sweep/simulate` endpoint to create a sweep and associated events in the Sandbox environment. Upon calling this endpoint, all `posted` or `pending` transfers with a sweep status of `unswept` will become `swept`, and all `reversed` transfers with a sweep status of `swept` will become `reverse_swept`.
     * @summary Simulate creating a sweep
     * @param {SandboxTransferSweepSimulateRequest} sandboxTransferSweepSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    sandboxTransferSweepSimulate(sandboxTransferSweepSimulateRequest: SandboxTransferSweepSimulateRequest, options?: any): AxiosPromise<SandboxTransferSweepSimulateResponse>;
    /**
     * After calling `/signal/evaluate`, call `/signal/decision/report` to report whether the transaction was initiated. This endpoint will return an `INVALID_REQUEST` error if called a second time with a different value for `initiated`.
     * @summary Report whether you initiated an ACH transaction
     * @param {SignalDecisionReportRequest} signalDecisionReportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalDecisionReport(signalDecisionReportRequest: SignalDecisionReportRequest, options?: any): AxiosPromise<SignalDecisionReportResponse>;
    /**
     * Use `/signal/evaluate` to evaluate a planned ACH transaction to get a return risk assessment (such as a risk score and risk tier) and additional risk signals.  In order to obtain a valid score for an ACH transaction, Plaid must have an access token for the account, and the Item must be healthy (receiving product updates) or have recently been in a healthy state. If the transaction does not meet eligibility requirements, an error will be returned corresponding to the underlying cause. If `/signal/evaluate` is called on the same transaction multiple times within a 24-hour period, cached results may be returned.
     * @summary Evaluate a planned ACH transaction
     * @param {SignalEvaluateRequest} signalEvaluateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalEvaluate(signalEvaluateRequest: SignalEvaluateRequest, options?: any): AxiosPromise<SignalEvaluateResponse>;
    /**
     * Call the `/signal/return/report` endpoint to report a returned transaction that was previously sent to the `/signal/evaluate` endpoint. Your feedback will be used by the model to incorporate the latest risk trend in your portfolio.
     * @summary Report a return for an ACH transaction
     * @param {SignalReturnReportRequest} signalReturnReportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    signalReturnReport(signalReturnReportRequest: SignalReturnReportRequest, options?: any): AxiosPromise<SignalReturnReportResponse>;
    /**
     * The `/transactions/get` endpoint allows developers to receive user-authorized transaction data for credit, depository, and some loan-type accounts (only those with account subtype `student`; coverage may be limited). For transaction history from investments accounts, use the [Investments endpoint](https://plaid.com/docs/api/products#investments) instead. Transaction data is standardized across financial institutions, and in many cases transactions are linked to a clean name, entity type, location, and category. Similarly, account data is standardized and returned with a clean name, number, balance, and other meta information where available.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Transactions are not immutable and can also be removed altogether by the institution; a removed transaction will no longer appear in `/transactions/get`.  For more details, see [Pending and posted transactions](https://plaid.com/docs/transactions/transactions-data/#pending-and-posted-transactions).  Due to the potentially large number of transactions associated with an Item, results are paginated. Manipulate the `count` and `offset` parameters in conjunction with the `total_transactions` response body field to fetch all available transactions.  Data returned by `/transactions/get` will be the data available for the Item as of the most recent successful check for new transactions. Plaid typically checks for new data multiple times a day, but these checks may occur less frequently, such as once a day, depending on the institution. An Item\'s `status.transactions.last_successful_update` field will show the timestamp of the most recent successful update. To force Plaid to check for new transactions, you can use the `/transactions/refresh` endpoint.  Note that data may not be immediately available to `/transactions/get`. Plaid will begin to prepare transactions data upon Item link, if Link was initialized with `transactions`, or upon the first call to `/transactions/get`, if it wasn\'t. To be alerted when transaction data is ready to be fetched, listen for the [`INITIAL_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-initial_update) and [`HISTORICAL_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-historical_update) webhooks. If no transaction history is ready when `/transactions/get` is called, it will return a `PRODUCT_NOT_READY` error.
     * @summary Get transaction data
     * @param {TransactionsGetRequest} transactionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsGet(transactionsGetRequest: TransactionsGetRequest, options?: any): AxiosPromise<TransactionsGetResponse>;
    /**
     * The `/transactions/recurring/get` endpoint identifies and returns groups of transactions that occur on a regular basis for the inputted Item and accounts.  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.
     * @summary Get streams of recurring transactions
     * @param {TransactionsRecurringGetRequest} transactionsRecurringGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsRecurringGet(transactionsRecurringGetRequest: TransactionsRecurringGetRequest, options?: any): AxiosPromise<TransactionsRecurringGetResponse>;
    /**
     * `/transactions/refresh` is an optional endpoint for users of the Transactions product. It initiates an on-demand extraction to fetch the newest transactions for an Item. This on-demand extraction takes place in addition to the periodic extractions that automatically occur multiple times a day for any Transactions-enabled Item. If changes to transactions are discovered after calling `/transactions/refresh`, Plaid will fire a webhook: [`TRANSACTIONS_REMOVED`](https://plaid.com/docs/api/webhooks#deleted-transactions-detected) will be fired if any removed transactions are detected, and [`DEFAULT_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-default_update) will be fired if any new transactions are detected. New transactions can be fetched by calling `/transactions/get`.  Access to `/transactions/refresh` in Production is specific to certain pricing plans. If you cannot access `/transactions/refresh` in Production, [contact Sales](https://www.plaid.com/contact) for assistance.
     * @summary Refresh transaction data
     * @param {TransactionsRefreshRequest} transactionsRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsRefresh(transactionsRefreshRequest: TransactionsRefreshRequest, options?: any): AxiosPromise<TransactionsRefreshResponse>;
    /**
     * The `/transactions/sync` endpoint returns item transactions as a set of delta updates. Subsequent calls to the endpoint using the cursor returned in the response will return new added, modified, and removed transactions since the last call to the endpoint  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.
     * @summary Get incremental transaction updates on an Item
     * @param {TransactionsSyncRequest} transactionsSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transactionsSync(transactionsSyncRequest: TransactionsSyncRequest, options?: any): AxiosPromise<TransactionsSyncResponse>;
    /**
     * Use the `/transfer/authorization/create` endpoint to determine transfer failure risk.  In Plaid\'s sandbox environment the decisions will be returned as follows:    - To approve a transfer, make an authorization request with an `amount` less than the available balance in the account.    - To decline a transfer with the rationale code `NSF`, the available balance on the account must be less than the authorization `amount`. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To decline a transfer with the rationale code `RISK`, the available balance on the account must be exactly $0. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To permit a transfer with the rationale code `MANUALLY_VERIFIED_ITEM`, create an Item in Link through the [Same Day Micro-deposits flow](https://plaid.com/docs/auth/coverage/testing/#testing-same-day-micro-deposits).    - To permit a transfer with the rationale code `LOGIN_REQUIRED`, [reset the login for an Item](https://plaid.com/docs/sandbox/#item_login_required).  All username/password combinations other than the ones listed above will result in a decision of permitted and rationale code `ERROR`.
     * @summary Create a transfer authorization
     * @param {TransferAuthorizationCreateRequest} transferAuthorizationCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferAuthorizationCreate(transferAuthorizationCreateRequest: TransferAuthorizationCreateRequest, options?: any): AxiosPromise<TransferAuthorizationCreateResponse>;
    /**
     * Use the `/transfer/cancel` endpoint to cancel a transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/transfer/get` is `true`.
     * @summary Cancel a transfer
     * @param {TransferCancelRequest} transferCancelRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferCancel(transferCancelRequest: TransferCancelRequest, options?: any): AxiosPromise<TransferCancelResponse>;
    /**
     * Use the `/transfer/create` endpoint to initiate a new transfer.
     * @summary Create a transfer
     * @param {TransferCreateRequest} transferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferCreate(transferCreateRequest: TransferCreateRequest, options?: any): AxiosPromise<TransferCreateResponse>;
    /**
     * Use the `/transfer/event/list` endpoint to get a list of transfer events based on specified filter criteria.
     * @summary List transfer events
     * @param {TransferEventListRequest} transferEventListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferEventList(transferEventListRequest: TransferEventListRequest, options?: any): AxiosPromise<TransferEventListResponse>;
    /**
     * `/transfer/event/sync` allows you to request up to the next 25 transfer events that happened after a specific `event_id`. Use the `/transfer/event/sync` endpoint to guarantee you have seen all transfer events.
     * @summary Sync transfer events
     * @param {TransferEventSyncRequest} transferEventSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferEventSync(transferEventSyncRequest: TransferEventSyncRequest, options?: any): AxiosPromise<TransferEventSyncResponse>;
    /**
     * The `/transfer/get` fetches information about the transfer corresponding to the given `transfer_id`.
     * @summary Retrieve a transfer
     * @param {TransferGetRequest} transferGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferGet(transferGetRequest: TransferGetRequest, options?: any): AxiosPromise<TransferGetResponse>;
    /**
     * Use the `/transfer/intent/create` endpoint to generate a transfer intent object and invoke the Transfer UI.
     * @summary Create a transfer intent object to invoke the Transfer UI
     * @param {TransferIntentCreateRequest} transferIntentCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferIntentCreate(transferIntentCreateRequest: TransferIntentCreateRequest, options?: any): AxiosPromise<TransferIntentCreateResponse>;
    /**
     * Use the `/transfer/intent/get` endpoint to retrieve more information about a transfer intent.
     * @summary Retrieve more information about a transfer intent
     * @param {{ [key: string]: object; }} requestBody
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferIntentGet(requestBody: {
        [key: string]: object;
    }, options?: any): AxiosPromise<TransferIntentGetResponse>;
    /**
     * Use the `/transfer/list` endpoint to see a list of all your transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired transfers.
     * @summary List transfers
     * @param {TransferListRequest} transferListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferList(transferListRequest: TransferListRequest, options?: any): AxiosPromise<TransferListResponse>;
    /**
     * The `/transfer/repayment/list` endpoint fetches repayments matching the given filters. Repayments are returned in reverse-chronological order (most recent first) starting at the given `start_time`.
     * @summary Lists historical repayments
     * @param {TransferRepaymentListRequest} transferRepaymentListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferRepaymentList(transferRepaymentListRequest: TransferRepaymentListRequest, options?: any): AxiosPromise<TransferRepaymentListResponse>;
    /**
     * The `/transfer/repayment/return/list` endpoint retrieves the set of returns that were batched together into the specified repayment. The sum of amounts of returns retrieved by this request equals the amount of the repayment.
     * @summary List the returns included in a repayment
     * @param {TransferRepaymentReturnListRequest} transferRepaymentReturnListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferRepaymentReturnList(transferRepaymentReturnListRequest: TransferRepaymentReturnListRequest, options?: any): AxiosPromise<TransferRepaymentReturnListResponse>;
    /**
     * The `/transfer/sweep/get` endpoint fetches a sweep corresponding to the given `sweep_id`.
     * @summary Retrieve a sweep
     * @param {TransferSweepGetRequest} transferSweepGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferSweepGet(transferSweepGetRequest: TransferSweepGetRequest, options?: any): AxiosPromise<TransferSweepGetResponse>;
    /**
     * The `/transfer/sweep/list` endpoint fetches sweeps matching the given filters.
     * @summary List sweeps
     * @param {TransferSweepListRequest} transferSweepListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    transferSweepList(transferSweepListRequest: TransferSweepListRequest, options?: any): AxiosPromise<TransferSweepListResponse>;
    /**
     * Fetch an e-wallet. The response includes the current balance.
     * @summary Fetch an e-wallet
     * @param {WalletGetRequest} walletGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletGet(walletGetRequest: WalletGetRequest, options?: any): AxiosPromise<WalletGetResponse>;
    /**
     * Execute a transaction using the specified e-wallet. Specify the e-wallet to debit from, the counterparty to credit to, the idempotency key to prevent duplicate payouts, the amount and reference for the payout. The payouts are executed over the Faster Payment rails, where settlement usually only takes a few seconds.
     * @summary Execute a transaction using an e-wallet
     * @param {WalletTransactionExecuteRequest} walletTransactionExecuteRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletTransactionExecute(walletTransactionExecuteRequest: WalletTransactionExecuteRequest, options?: any): AxiosPromise<WalletTransactionExecuteResponse>;
    /**
     * This endpoint lists the latest transactions of the specified e-wallet. Transactions are returned in descending order by the `created_at` time.
     * @summary List e-wallet transactions
     * @param {WalletTransactionsListRequest} walletTransactionsListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    walletTransactionsList(walletTransactionsListRequest: WalletTransactionsListRequest, options?: any): AxiosPromise<WalletTransactionsListResponse>;
    /**
     * Plaid signs all outgoing webhooks and provides JSON Web Tokens (JWTs) so that you can verify the authenticity of any incoming webhooks to your application. A message signature is included in the `Plaid-Verification` header.  The `/webhook_verification_key/get` endpoint provides a JSON Web Key (JWK) that can be used to verify a JWT.
     * @summary Get webhook verification key
     * @param {WebhookVerificationKeyGetRequest} webhookVerificationKeyGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    webhookVerificationKeyGet(webhookVerificationKeyGetRequest: WebhookVerificationKeyGetRequest, options?: any): AxiosPromise<WebhookVerificationKeyGetResponse>;
};
/**
 * PlaidApi - object-oriented interface
 * @export
 * @class PlaidApi
 * @extends {BaseAPI}
 */
export declare class PlaidApi extends BaseAPI {
    /**
     * The `/accounts/balance/get` endpoint returns the real-time balance for each of an Item\'s accounts. While other endpoints may return a balance object, only `/accounts/balance/get` forces the available and current balance fields to be refreshed rather than cached. This endpoint can be used for existing Items that were added via any of Plaid’s other products. This endpoint can be used as long as Link has been initialized with any other product, `balance` itself is not a product that can be used to initialize Link.
     * @summary Retrieve real-time balance data
     * @param {AccountsBalanceGetRequest} accountsBalanceGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    accountsBalanceGet(accountsBalanceGetRequest: AccountsBalanceGetRequest, options?: any): Promise<import("axios").AxiosResponse<AccountsGetResponse>>;
    /**
     * The `/accounts/get` endpoint can be used to retrieve a list of accounts associated with any linked Item. Plaid will only return active bank accounts — that is, accounts that are not closed and are capable of carrying a balance.  This endpoint only returns accounts that were permissioned by the user when they initially created the Item. If a user creates a new account after the initial link, you can capture this event through the [`NEW_ACCOUNTS_AVAILABLE`](https://plaid.com/docs/api/webhooks/#item-new_accounts_available) webhook and then use Link\'s [update mode](https://plaid.com/docs/link/update-mode/) to request that the user share this new account with you.  This endpoint retrieves cached information, rather than extracting fresh information from the institution. As a result, balances returned may not be up-to-date; for realtime balance information, use `/accounts/balance/get` instead. Note that some information is nullable.
     * @summary Retrieve accounts
     * @param {AccountsGetRequest} accountsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    accountsGet(accountsGetRequest: AccountsGetRequest, options?: any): Promise<import("axios").AxiosResponse<AccountsGetResponse>>;
    /**
     * Allows financial institutions to retrieve information about Plaid clients for the purpose of building control-tower experiences
     * @summary Retrieve information about a Plaid application
     * @param {ApplicationGetRequest} applicationGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    applicationGet(applicationGetRequest: ApplicationGetRequest, options?: any): Promise<import("axios").AxiosResponse<ApplicationGetResponse>>;
    /**
     * Plaid can provide an Audit Copy of any Asset Report directly to a participating third party on your behalf. For example, Plaid can supply an Audit Copy directly to Fannie Mae on your behalf if you participate in the Day 1 Certainty™ program. An Audit Copy contains the same underlying data as the Asset Report.  To grant access to an Audit Copy, use the `/asset_report/audit_copy/create` endpoint to create an `audit_copy_token` and then pass that token to the third party who needs access. Each third party has its own `auditor_id`, for example `fannie_mae`. You’ll need to create a separate Audit Copy for each third party to whom you want to grant access to the Report.
     * @summary Create Asset Report Audit Copy
     * @param {AssetReportAuditCopyCreateRequest} assetReportAuditCopyCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportAuditCopyCreate(assetReportAuditCopyCreateRequest: AssetReportAuditCopyCreateRequest, options?: any): Promise<import("axios").AxiosResponse<AssetReportAuditCopyCreateResponse>>;
    /**
     * `/asset_report/audit_copy/get` allows auditors to get a copy of an Asset Report that was previously shared via the `/asset_report/audit_copy/create` endpoint.  The caller of `/asset_report/audit_copy/create` must provide the `audit_copy_token` to the auditor.  This token can then be used to call `/asset_report/audit_copy/create`.
     * @summary Retrieve an Asset Report Audit Copy
     * @param {AssetReportAuditCopyGetRequest} assetReportAuditCopyGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportAuditCopyGet(assetReportAuditCopyGetRequest: AssetReportAuditCopyGetRequest, options?: any): Promise<import("axios").AxiosResponse<AssetReportGetResponse>>;
    /**
     * The `/asset_report/audit_copy/remove` endpoint allows you to remove an Audit Copy. Removing an Audit Copy invalidates the `audit_copy_token` associated with it, meaning both you and any third parties holding the token will no longer be able to use it to access Report data. Items associated with the Asset Report, the Asset Report itself and other Audit Copies of it are not affected and will remain accessible after removing the given Audit Copy.
     * @summary Remove Asset Report Audit Copy
     * @param {AssetReportAuditCopyRemoveRequest} assetReportAuditCopyRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportAuditCopyRemove(assetReportAuditCopyRemoveRequest: AssetReportAuditCopyRemoveRequest, options?: any): Promise<import("axios").AxiosResponse<AssetReportAuditCopyRemoveResponse>>;
    /**
     * The `/asset_report/create` endpoint initiates the process of creating an Asset Report, which can then be retrieved by passing the `asset_report_token` return value to the `/asset_report/get` or `/asset_report/pdf/get` endpoints.  The Asset Report takes some time to be created and is not available immediately after calling `/asset_report/create`. When the Asset Report is ready to be retrieved using `/asset_report/get` or `/asset_report/pdf/get`, Plaid will fire a `PRODUCT_READY` webhook. For full details of the webhook schema, see [Asset Report webhooks](https://plaid.com/docs/api/webhooks/#assets-webhooks).  The `/asset_report/create` endpoint creates an Asset Report at a moment in time. Asset Reports are immutable. To get an updated Asset Report, use the `/asset_report/refresh` endpoint.
     * @summary Create an Asset Report
     * @param {AssetReportCreateRequest} assetReportCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportCreate(assetReportCreateRequest: AssetReportCreateRequest, options?: any): Promise<import("axios").AxiosResponse<AssetReportCreateResponse>>;
    /**
     * By default, an Asset Report will contain all of the accounts on a given Item. In some cases, you may not want the Asset Report to contain all accounts. For example, you might have the end user choose which accounts are relevant in Link using the Account Select view, which you can enable in the dashboard. Or, you might always exclude certain account types or subtypes, which you can identify by using the `/accounts/get` endpoint. To narrow an Asset Report to only a subset of accounts, use the `/asset_report/filter` endpoint.  To exclude certain Accounts from an Asset Report, first use the `/asset_report/create` endpoint to create the report, then send the `asset_report_token` along with a list of `account_ids` to exclude to the `/asset_report/filter` endpoint, to create a new Asset Report which contains only a subset of the original Asset Report\'s data.  Because Asset Reports are immutable, calling `/asset_report/filter` does not alter the original Asset Report in any way; rather, `/asset_report/filter` creates a new Asset Report with a new token and id. Asset Reports created via `/asset_report/filter` do not contain new Asset data, and are not billed.  Plaid will fire a [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook once generation of the filtered Asset Report has completed.
     * @summary Filter Asset Report
     * @param {AssetReportFilterRequest} assetReportFilterRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportFilter(assetReportFilterRequest: AssetReportFilterRequest, options?: any): Promise<import("axios").AxiosResponse<AssetReportFilterResponse>>;
    /**
     * The `/asset_report/get` endpoint retrieves the Asset Report in JSON format. Before calling `/asset_report/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook to fire, indicating that the Report is ready to be retrieved.  By default, an Asset Report includes transaction descriptions as returned by the bank, as opposed to parsed and categorized by Plaid. You can also receive cleaned and categorized transactions, as well as additional insights like merchant name or location information. We call this an Asset Report with Insights. An Asset Report with Insights provides transaction category, location, and merchant information in addition to the transaction strings provided in a standard Asset Report.  To retrieve an Asset Report with Insights, call the `/asset_report/get` endpoint with `include_insights` set to `true`.
     * @summary Retrieve an Asset Report
     * @param {AssetReportGetRequest} assetReportGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportGet(assetReportGetRequest: AssetReportGetRequest, options?: any): Promise<import("axios").AxiosResponse<AssetReportGetResponse>>;
    /**
     * The `/asset_report/pdf/get` endpoint retrieves the Asset Report in PDF format. Before calling `/asset_report/pdf/get`, you must first create the Asset Report using `/asset_report/create` (or filter an Asset Report using `/asset_report/filter`) and then wait for the [`PRODUCT_READY`](https://plaid.com/docs/api/webhooks) webhook to fire, indicating that the Report is ready to be retrieved.  The response to `/asset_report/pdf/get` is the PDF binary data. The `request_id`  is returned in the `Plaid-Request-ID` header.  [View a sample PDF Asset Report](https://plaid.com/documents/sample-asset-report.pdf).
     * @summary Retrieve a PDF Asset Report
     * @param {AssetReportPDFGetRequest} assetReportPDFGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportPdfGet(assetReportPDFGetRequest: AssetReportPDFGetRequest, options?: any): Promise<import("axios").AxiosResponse<any>>;
    /**
     * An Asset Report is an immutable snapshot of a user\'s assets. In order to \"refresh\" an Asset Report you created previously, you can use the `/asset_report/refresh` endpoint to create a new Asset Report based on the old one, but with the most recent data available.  The new Asset Report will contain the same Items as the original Report, as well as the same filters applied by any call to `/asset_report/filter`. By default, the new Asset Report will also use the same parameters you submitted with your original `/asset_report/create` request, but the original `days_requested` value and the values of any parameters in the `options` object can be overridden with new values. To change these arguments, simply supply new values for them in your request to `/asset_report/refresh`. Submit an empty string (\"\") for any previously-populated fields you would like set as empty.
     * @summary Refresh an Asset Report
     * @param {AssetReportRefreshRequest} assetReportRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportRefresh(assetReportRefreshRequest: AssetReportRefreshRequest, options?: any): Promise<import("axios").AxiosResponse<AssetReportRefreshResponse>>;
    /**
     * The `/item/remove` endpoint allows you to invalidate an `access_token`, meaning you will not be able to create new Asset Reports with it. Removing an Item does not affect any Asset Reports or Audit Copies you have already created, which will remain accessible until you remove them specifically.  The `/asset_report/remove` endpoint allows you to remove an Asset Report. Removing an Asset Report invalidates its `asset_report_token`, meaning you will no longer be able to use it to access Report data or create new Audit Copies. Removing an Asset Report does not affect the underlying Items, but does invalidate any `audit_copy_tokens` associated with the Asset Report.
     * @summary Delete an Asset Report
     * @param {AssetReportRemoveRequest} assetReportRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    assetReportRemove(assetReportRemoveRequest: AssetReportRemoveRequest, options?: any): Promise<import("axios").AxiosResponse<AssetReportRemoveResponse>>;
    /**
     * The `/auth/get` endpoint returns the bank account and bank identification numbers (such as routing numbers, for US accounts) associated with an Item\'s checking and savings accounts, along with high-level account data and balances when available.  Note: This request may take some time to complete if `auth` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.  Also note that `/auth/get` will not return data for any new accounts opened after the Item was created. To obtain data for new accounts, create a new Item.  Versioning note: In API version 2017-03-08, the schema of the `numbers` object returned by this endpoint is substantially different. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2018-05-22).
     * @summary Retrieve auth data
     * @param {AuthGetRequest} authGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    authGet(authGetRequest: AuthGetRequest, options?: any): Promise<import("axios").AxiosResponse<AuthGetResponse>>;
    /**
     * Use the `/bank_transfer/balance/get` endpoint to see the available balance in your bank transfer account. Debit transfers increase this balance once their status is posted. Credit transfers decrease this balance when they are created.  The transactable balance shows the amount in your account that you are able to use for transfers, and is essentially your available balance minus your minimum balance.  Note that this endpoint can only be used with FBO accounts, when using Bank Transfers in the Full Service configuration. It cannot be used on your own account when using Bank Transfers in the BTS Platform configuration.
     * @summary Get balance of your Bank Transfer account
     * @param {BankTransferBalanceGetRequest} bankTransferBalanceGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferBalanceGet(bankTransferBalanceGetRequest: BankTransferBalanceGetRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferBalanceGetResponse>>;
    /**
     * Use the `/bank_transfer/cancel` endpoint to cancel a bank transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/bank_transfer/get` is `true`.
     * @summary Cancel a bank transfer
     * @param {BankTransferCancelRequest} bankTransferCancelRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferCancel(bankTransferCancelRequest: BankTransferCancelRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferCancelResponse>>;
    /**
     * Use the `/bank_transfer/create` endpoint to initiate a new bank transfer.
     * @summary Create a bank transfer
     * @param {BankTransferCreateRequest} bankTransferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferCreate(bankTransferCreateRequest: BankTransferCreateRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferCreateResponse>>;
    /**
     * Use the `/bank_transfer/event/list` endpoint to get a list of bank transfer events based on specified filter criteria.
     * @summary List bank transfer events
     * @param {BankTransferEventListRequest} bankTransferEventListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferEventList(bankTransferEventListRequest: BankTransferEventListRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferEventListResponse>>;
    /**
     * `/bank_transfer/event/sync` allows you to request up to the next 25 bank transfer events that happened after a specific `event_id`. Use the `/bank_transfer/event/sync` endpoint to guarantee you have seen all bank transfer events.
     * @summary Sync bank transfer events
     * @param {BankTransferEventSyncRequest} bankTransferEventSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferEventSync(bankTransferEventSyncRequest: BankTransferEventSyncRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferEventSyncResponse>>;
    /**
     * The `/bank_transfer/get` fetches information about the bank transfer corresponding to the given `bank_transfer_id`.
     * @summary Retrieve a bank transfer
     * @param {BankTransferGetRequest} bankTransferGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferGet(bankTransferGetRequest: BankTransferGetRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferGetResponse>>;
    /**
     * Use the `/bank_transfer/list` endpoint to see a list of all your bank transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired bank transfers.
     * @summary List bank transfers
     * @param {BankTransferListRequest} bankTransferListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferList(bankTransferListRequest: BankTransferListRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferListResponse>>;
    /**
     * As an alternative to adding Items via Link, you can also use the `/bank_transfer/migrate_account` endpoint to migrate known account and routing numbers to Plaid Items.  Note that Items created in this way are not compatible with endpoints for other products, such as `/accounts/balance/get`, and can only be used with Bank Transfer endpoints.  If you require access to other endpoints, create the Item through Link instead.  Access to `/bank_transfer/migrate_account` is not enabled by default; to obtain access, contact your Plaid Account Manager.
     * @summary Migrate account into Bank Transfers
     * @param {BankTransferMigrateAccountRequest} bankTransferMigrateAccountRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferMigrateAccount(bankTransferMigrateAccountRequest: BankTransferMigrateAccountRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferMigrateAccountResponse>>;
    /**
     * The `/bank_transfer/sweep/get` endpoint fetches information about the sweep corresponding to the given `sweep_id`.
     * @summary Retrieve a sweep
     * @param {BankTransferSweepGetRequest} bankTransferSweepGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferSweepGet(bankTransferSweepGetRequest: BankTransferSweepGetRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferSweepGetResponse>>;
    /**
     * The `/bank_transfer/sweep/list` endpoint fetches information about the sweeps matching the given filters.
     * @summary List sweeps
     * @param {BankTransferSweepListRequest} bankTransferSweepListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    bankTransferSweepList(bankTransferSweepListRequest: BankTransferSweepListRequest, options?: any): Promise<import("axios").AxiosResponse<BankTransferSweepListResponse>>;
    /**
     * Send a request to the `/categories/get` endpoint to get detailed information on categories returned by Plaid. This endpoint does not require authentication.
     * @summary Get Categories
     * @param {object} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    categoriesGet(body: object, options?: any): Promise<import("axios").AxiosResponse<CategoriesGetResponse>>;
    /**
     * The `/payment_initiation/payment/token/create` endpoint has been deprecated. New Plaid customers will be unable to use this endpoint, and existing customers are encouraged to migrate to the newer, `link_token`-based flow. The recommended flow is to provide the `payment_id` to `/link/token/create`, which returns a `link_token` used to initialize Link.  The `/payment_initiation/payment/token/create` is used to create a `payment_token`, which can then be used in Link initialization to enter a payment initiation flow. You can only use a `payment_token` once. If this attempt fails, the end user aborts the flow, or the token expires, you will need to create a new payment token. Creating a new payment token does not require end user input.
     * @summary Create payment token
     * @param {PaymentInitiationPaymentTokenCreateRequest} paymentInitiationPaymentTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    createPaymentToken(paymentInitiationPaymentTokenCreateRequest: PaymentInitiationPaymentTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<PaymentInitiationPaymentTokenCreateResponse>>;
    /**
     * This endpoint provides an alternative to `/deposit_switch/create` for customers who have not yet fully integrated with Plaid Exchange. Like `/deposit_switch/create`, it creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.
     * @summary Create a deposit switch without using Plaid Exchange
     * @param {DepositSwitchAltCreateRequest} depositSwitchAltCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    depositSwitchAltCreate(depositSwitchAltCreateRequest: DepositSwitchAltCreateRequest, options?: any): Promise<import("axios").AxiosResponse<DepositSwitchAltCreateResponse>>;
    /**
     * This endpoint creates a deposit switch entity that will be persisted throughout the lifecycle of the switch.
     * @summary Create a deposit switch
     * @param {DepositSwitchCreateRequest} depositSwitchCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    depositSwitchCreate(depositSwitchCreateRequest: DepositSwitchCreateRequest, options?: any): Promise<import("axios").AxiosResponse<DepositSwitchCreateResponse>>;
    /**
     * This endpoint returns information related to how the user has configured their payroll allocation and the state of the switch. You can use this information to build logic related to the user\'s direct deposit allocation preferences.
     * @summary Retrieve a deposit switch
     * @param {DepositSwitchGetRequest} depositSwitchGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    depositSwitchGet(depositSwitchGetRequest: DepositSwitchGetRequest, options?: any): Promise<import("axios").AxiosResponse<DepositSwitchGetResponse>>;
    /**
     * In order for the end user to take action, you will need to create a public token representing the deposit switch. This token is used to initialize Link. It can be used one time and expires after 30 minutes.
     * @summary Create a deposit switch token
     * @param {DepositSwitchTokenCreateRequest} depositSwitchTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    depositSwitchTokenCreate(depositSwitchTokenCreateRequest: DepositSwitchTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<DepositSwitchTokenCreateResponse>>;
    /**
     * `/employers/search` allows you the ability to search Plaid’s database of known employers, for use with Deposit Switch. You can use this endpoint to look up a user\'s employer in order to confirm that they are supported. Users with non-supported employers can then be routed out of the Deposit Switch flow.  The data in the employer database is currently limited. As the Deposit Switch and Income products progress through their respective beta periods, more employers are being regularly added. Because the employer database is frequently updated, we recommend that you do not cache or store data from this endpoint for more than a day.
     * @summary Search employer database
     * @param {EmployersSearchRequest} employersSearchRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    employersSearch(employersSearchRequest: EmployersSearchRequest, options?: any): Promise<import("axios").AxiosResponse<EmployersSearchResponse>>;
    /**
     * `/employment/verification/get` returns a list of employments through a user payroll that was verified by an end user.
     * @summary Retrieve a summary of an individual\'s employment information
     * @param {EmploymentVerificationGetRequest} employmentVerificationGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    employmentVerificationGet(employmentVerificationGetRequest: EmploymentVerificationGetRequest, options?: any): Promise<import("axios").AxiosResponse<EmploymentVerificationGetResponse>>;
    /**
     * The `/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses. Only name data is guaranteed to be returned; other fields will be empty arrays if not provided by the institution.  Note: This request may take some time to complete if identity was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the data.
     * @summary Retrieve identity data
     * @param {IdentityGetRequest} identityGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    identityGet(identityGetRequest: IdentityGetRequest, options?: any): Promise<import("axios").AxiosResponse<IdentityGetResponse>>;
    /**
     * `/income/verification/create` begins the income verification process by returning an `income_verification_id`. You can then provide the `income_verification_id` to `/link/token/create` under the `income_verification` parameter in order to create a Link instance that will prompt the user to go through the income verification flow. Plaid will fire an `INCOME` webhook once the user completes the Payroll Income flow, or when the uploaded documents in the Document Income flow have finished processing.
     * @summary (Deprecated) Create an income verification instance
     * @param {IncomeVerificationCreateRequest} incomeVerificationCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    incomeVerificationCreate(incomeVerificationCreateRequest: IncomeVerificationCreateRequest, options?: any): Promise<import("axios").AxiosResponse<IncomeVerificationCreateResponse>>;
    /**
     * `/income/verification/documents/download` provides the ability to download the source documents associated with the verification.  If Document Income was used, the documents will be those the user provided in Link. For Payroll Income, the most recent files available for download from the payroll provider will be available from this endpoint.  The response to `/income/verification/documents/download` is a ZIP file in binary data. If a `document_id` is passed, a single document will be contained in this file. If not, the response will contain all documents associated with the verification.  The `request_id` is returned in the `Plaid-Request-ID` header.
     * @summary Download the original documents used for income verification
     * @param {IncomeVerificationDocumentsDownloadRequest} incomeVerificationDocumentsDownloadRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    incomeVerificationDocumentsDownload(incomeVerificationDocumentsDownloadRequest: IncomeVerificationDocumentsDownloadRequest, options?: any): Promise<import("axios").AxiosResponse<any>>;
    /**
     * /income/verification/paystub/get returns information from a single paystub used for income verification
     * @summary (Deprecated) Retrieve information from a single paystub used for income verification
     * @param {IncomeVerificationPaystubGetRequest} incomeVerificationPaystubGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    incomeVerificationPaystubGet(incomeVerificationPaystubGetRequest: IncomeVerificationPaystubGetRequest, options?: any): Promise<import("axios").AxiosResponse<IncomeVerificationPaystubGetResponse>>;
    /**
     * `/income/verification/paystubs/get` returns the information collected from the paystubs that were used to verify an end user\'s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary Retrieve information from the paystubs used for income verification
     * @param {IncomeVerificationPaystubsGetRequest} incomeVerificationPaystubsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    incomeVerificationPaystubsGet(incomeVerificationPaystubsGetRequest: IncomeVerificationPaystubsGetRequest, options?: any): Promise<import("axios").AxiosResponse<IncomeVerificationPaystubsGetResponse>>;
    /**
     * `/income/verification/precheck` is an optional endpoint that can be called before initializing a Link session for income verification. It evaluates whether a given user is supportable by digital income verification and returns a `precheck_id` that can be provided to `/link/token/create`. If the user is eligible for digital verification, providing the `precheck_id` in this way will generate a Link UI optimized for the end user and their specific employer. If the user cannot be confirmed as eligible, the `precheck_id` can still be provided to `/link/token/create` and the user can still use the income verification flow, but they may be required to manually upload a paystub to verify their income.  While all request fields are optional, providing either `employer` or `transactions_access_tokens` data will increase the chance of receiving a useful result.
     * @summary Check digital income verification eligibility and optimize conversion
     * @param {IncomeVerificationPrecheckRequest} incomeVerificationPrecheckRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    incomeVerificationPrecheck(incomeVerificationPrecheckRequest: IncomeVerificationPrecheckRequest, options?: any): Promise<import("axios").AxiosResponse<IncomeVerificationPrecheckResponse>>;
    /**
     * `/income/verification/refresh` refreshes a given income verification.
     * @summary Refresh an income verification
     * @param {IncomeVerificationRefreshRequest} incomeVerificationRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    incomeVerificationRefresh(incomeVerificationRefreshRequest: IncomeVerificationRefreshRequest, options?: any): Promise<import("axios").AxiosResponse<IncomeVerificationRefreshResponse>>;
    /**
     * `/income/verification/summary/get` returns a verification summary for the income that was verified for an end user. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary (Deprecated) Retrieve a summary of information derived from income verification
     * @param {IncomeVerificationSummaryGetRequest} incomeVerificationSummaryGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    incomeVerificationSummaryGet(incomeVerificationSummaryGetRequest: IncomeVerificationSummaryGetRequest, options?: any): Promise<import("axios").AxiosResponse<IncomeVerificationSummaryGetResponse>>;
    /**
     * `/income/verification/taxforms/get` returns the information collected from forms that were used to verify an end user\'s income. It can be called once the status of the verification has been set to `VERIFICATION_STATUS_PROCESSING_COMPLETE`, as reported by the `INCOME: verification_status` webhook. Attempting to call the endpoint before verification has been completed will result in an error.
     * @summary Retrieve information from the tax documents used for income verification
     * @param {{ [key: string]: object; }} requestBody
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    incomeVerificationTaxformsGet(requestBody: {
        [key: string]: object;
    }, options?: any): Promise<import("axios").AxiosResponse<IncomeVerificationTaxformsGetResponse>>;
    /**
     * Returns a JSON response containing details on all financial institutions currently supported by Plaid. Because Plaid supports thousands of institutions, results are paginated.  If there is no overlap between an institution’s enabled products and a client’s enabled products, then the institution will be filtered out from the response. As a result, the number of institutions returned may not match the count specified in the call.
     * @summary Get details of all supported institutions
     * @param {InstitutionsGetRequest} institutionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    institutionsGet(institutionsGetRequest: InstitutionsGetRequest, options?: any): Promise<import("axios").AxiosResponse<InstitutionsGetResponse>>;
    /**
     * Returns a JSON response containing details on a specified financial institution currently supported by Plaid.   Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` to authenticate to this endpoint. The `public_key` has been deprecated; all customers are encouraged to use `client_id` and `secret` instead.
     * @summary Get details of an institution
     * @param {InstitutionsGetByIdRequest} institutionsGetByIdRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    institutionsGetById(institutionsGetByIdRequest: InstitutionsGetByIdRequest, options?: any): Promise<import("axios").AxiosResponse<InstitutionsGetByIdResponse>>;
    /**
     * Returns a JSON response containing details for institutions that match the query parameters, up to a maximum of ten institutions per query.  Versioning note: API versions 2019-05-29 and earlier allow use of the `public_key` parameter instead of the `client_id` and `secret` parameters to authenticate to this endpoint. The `public_key` parameter has since been deprecated; all customers are encouraged to use `client_id` and `secret` instead.
     * @summary Search institutions
     * @param {InstitutionsSearchRequest} institutionsSearchRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    institutionsSearch(institutionsSearchRequest: InstitutionsSearchRequest, options?: any): Promise<import("axios").AxiosResponse<InstitutionsSearchResponse>>;
    /**
     * The `/investments/holdings/get` endpoint allows developers to receive user-authorized stock position data for `investment`-type accounts.
     * @summary Get Investment holdings
     * @param {InvestmentsHoldingsGetRequest} investmentsHoldingsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    investmentsHoldingsGet(investmentsHoldingsGetRequest: InvestmentsHoldingsGetRequest, options?: any): Promise<import("axios").AxiosResponse<InvestmentsHoldingsGetResponse>>;
    /**
     * The `/investments/transactions/get` endpoint allows developers to retrieve user-authorized transaction data for investment accounts.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Due to the potentially large number of investment transactions associated with an Item, results are paginated. Manipulate the count and offset parameters in conjunction with the `total_investment_transactions` response body field to fetch all available investment transactions.
     * @summary Get investment transactions
     * @param {InvestmentsTransactionsGetRequest} investmentsTransactionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    investmentsTransactionsGet(investmentsTransactionsGetRequest: InvestmentsTransactionsGetRequest, options?: any): Promise<import("axios").AxiosResponse<InvestmentsTransactionsGetResponse>>;
    /**
     * By default, the `access_token` associated with an Item does not expire and should be stored in a persistent, secure manner.  You can use the `/item/access_token/invalidate` endpoint to rotate the `access_token` associated with an Item. The endpoint returns a new `access_token` and immediately invalidates the previous `access_token`.
     * @summary Invalidate access_token
     * @param {ItemAccessTokenInvalidateRequest} itemAccessTokenInvalidateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemAccessTokenInvalidate(itemAccessTokenInvalidateRequest: ItemAccessTokenInvalidateRequest, options?: any): Promise<import("axios").AxiosResponse<ItemAccessTokenInvalidateResponse>>;
    /**
     * List a user’s connected applications
     * @summary List a user’s connected applications
     * @param {ItemApplicationListRequest} itemApplicationListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemApplicationList(itemApplicationListRequest: ItemApplicationListRequest, options?: any): Promise<import("axios").AxiosResponse<ItemApplicationListResponse>>;
    /**
     * Enable consumers to update product access on selected accounts for an application.
     * @summary Update the scopes of access for a particular application
     * @param {ItemApplicationScopesUpdateRequest} itemApplicationScopesUpdateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemApplicationScopesUpdate(itemApplicationScopesUpdateRequest: ItemApplicationScopesUpdateRequest, options?: any): Promise<import("axios").AxiosResponse<ItemApplicationScopesUpdateResponse>>;
    /**
     * Note: As of July 2020, the `/item/public_token/create` endpoint is deprecated. Instead, use `/link/token/create` with an `access_token` to create a Link token for use with [update mode](https://plaid.com/docs/link/update-mode).  If you need your user to take action to restore or resolve an error associated with an Item, generate a public token with the `/item/public_token/create` endpoint and then initialize Link with that `public_token`.  A `public_token` is one-time use and expires after 30 minutes. You use a `public_token` to initialize Link in [update mode](https://plaid.com/docs/link/update-mode) for a particular Item. You can generate a `public_token` for an Item even if you did not use Link to create the Item originally.  The `/item/public_token/create` endpoint is **not** used to create your initial `public_token`. If you have not already received an `access_token` for a specific Item, use Link to obtain your `public_token` instead. See the [Quickstart](https://plaid.com/docs/quickstart) for more information.
     * @summary Create public token
     * @param {ItemPublicTokenCreateRequest} itemPublicTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemCreatePublicToken(itemPublicTokenCreateRequest: ItemPublicTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<ItemPublicTokenCreateResponse>>;
    /**
     * Returns information about the status of an Item.
     * @summary Retrieve an Item
     * @param {ItemGetRequest} itemGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemGet(itemGetRequest: ItemGetRequest, options?: any): Promise<import("axios").AxiosResponse<ItemGetResponse>>;
    /**
     * `/item/import` creates an Item via your Plaid Exchange Integration and returns an `access_token`. As part of an `/item/import` request, you will include a User ID (`user_auth.user_id`) and Authentication Token (`user_auth.auth_token`) that enable data aggregation through your Plaid Exchange API endpoints. These authentication principals are to be chosen by you.  Upon creating an Item via `/item/import`, Plaid will automatically begin an extraction of that Item through the Plaid Exchange infrastructure you have already integrated. This will automatically generate the Plaid native account ID for the account the user will switch their direct deposit to (`target_account_id`).
     * @summary Import Item
     * @param {ItemImportRequest} itemImportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemImport(itemImportRequest: ItemImportRequest, options?: any): Promise<import("axios").AxiosResponse<ItemImportResponse>>;
    /**
     * Exchange a Link `public_token` for an API `access_token`. Link hands off the `public_token` client-side via the `onSuccess` callback once a user has successfully created an Item. The `public_token` is ephemeral and expires after 30 minutes.  The response also includes an `item_id` that should be stored with the `access_token`. The `item_id` is used to identify an Item in a webhook. The `item_id` can also be retrieved by making an `/item/get` request.
     * @summary Exchange public token for an access token
     * @param {ItemPublicTokenExchangeRequest} itemPublicTokenExchangeRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemPublicTokenExchange(itemPublicTokenExchangeRequest: ItemPublicTokenExchangeRequest, options?: any): Promise<import("axios").AxiosResponse<ItemPublicTokenExchangeResponse>>;
    /**
     * The `/item/remove`  endpoint allows you to remove an Item. Once removed, the `access_token`  associated with the Item is no longer valid and cannot be used to access any data that was associated with the Item.  Note that in the Development environment, issuing an `/item/remove`  request will not decrement your live credential count. To increase your credential account in Development, contact Support.  Also note that for certain OAuth-based institutions, an Item removed via `/item/remove` may still show as an active connection in the institution\'s OAuth permission manager.  API versions 2019-05-29 and earlier return a `removed` boolean as part of the response.
     * @summary Remove an Item
     * @param {ItemRemoveRequest} itemRemoveRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemRemove(itemRemoveRequest: ItemRemoveRequest, options?: any): Promise<import("axios").AxiosResponse<ItemRemoveResponse>>;
    /**
     * The POST `/item/webhook/update` allows you to update the webhook URL associated with an Item. This request triggers a [`WEBHOOK_UPDATE_ACKNOWLEDGED`](https://plaid.com/docs/api/webhooks/#item-webhook-update-acknowledged) webhook to the newly specified webhook URL.
     * @summary Update Webhook URL
     * @param {ItemWebhookUpdateRequest} itemWebhookUpdateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    itemWebhookUpdate(itemWebhookUpdateRequest: ItemWebhookUpdateRequest, options?: any): Promise<import("axios").AxiosResponse<ItemWebhookUpdateResponse>>;
    /**
     * The `/liabilities/get` endpoint returns various details about an Item with loan or credit accounts. Liabilities data is available primarily for US financial institutions, with some limited coverage of Canadian institutions. Currently supported account types are account type `credit` with account subtype `credit card` or `paypal`, and account type `loan` with account subtype `student` or `mortgage`. To limit accounts listed in Link to types and subtypes supported by Liabilities, you can use the `account_filters` parameter when [creating a Link token](https://plaid.com/docs/api/tokens/#linktokencreate).  The types of information returned by Liabilities can include balances and due dates, loan terms, and account details such as original loan amount and guarantor. Data is refreshed approximately once per day; the latest data can be retrieved by calling `/liabilities/get`.  Note: This request may take some time to complete if `liabilities` was not specified as an initial product when creating the Item. This is because Plaid must communicate directly with the institution to retrieve the additional data.
     * @summary Retrieve Liabilities data
     * @param {LiabilitiesGetRequest} liabilitiesGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    liabilitiesGet(liabilitiesGetRequest: LiabilitiesGetRequest, options?: any): Promise<import("axios").AxiosResponse<LiabilitiesGetResponse>>;
    /**
     * The `/link/token/create` endpoint creates a `link_token`, which is required as a parameter when initializing Link. Once Link has been initialized, it returns a `public_token`, which can then be exchanged for an `access_token` via `/item/public_token/exchange` as part of the main Link flow.  A `link_token` generated by `/link/token/create` is also used to initialize other Link flows, such as the update mode flow for tokens with expired credentials, or the Payment Initiation (Europe) flow.
     * @summary Create Link Token
     * @param {LinkTokenCreateRequest} linkTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    linkTokenCreate(linkTokenCreateRequest: LinkTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<LinkTokenCreateResponse>>;
    /**
     * The `/link/token/get` endpoint gets information about a previously-created `link_token` using the `/link/token/create` endpoint. It can be useful for debugging purposes.
     * @summary Get Link Token
     * @param {LinkTokenGetRequest} linkTokenGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    linkTokenGet(linkTokenGetRequest: LinkTokenGetRequest, options?: any): Promise<import("axios").AxiosResponse<LinkTokenGetResponse>>;
    /**
     * After creating a payment recipient, you can use the `/payment_initiation/payment/create` endpoint to create a payment to that recipient.  Payments can be one-time or standing order (recurring) and can be denominated in either EUR or GBP.  If making domestic GBP-denominated payments, your recipient must have been created with BACS numbers. In general, EUR-denominated payments will be sent via SEPA Credit Transfer and GBP-denominated payments will be sent via the Faster Payments network, but the payment network used will be determined by the institution. Payments sent via Faster Payments will typically arrive immediately, while payments sent via SEPA Credit Transfer will typically arrive in one business day.  Standing orders (recurring payments) must be denominated in GBP and can only be sent to recipients in the UK. Once created, standing order payments cannot be modified or canceled via the API. An end user can cancel or modify a standing order directly on their banking application or website, or by contacting the bank. Standing orders will follow the payment rules of the underlying rails (Faster Payments in UK). Payments can be sent Monday to Friday, excluding bank holidays. If the pre-arranged date falls on a weekend or bank holiday, the payment is made on the next working day. It is not possible to guarantee the exact time the payment will reach the recipient’s account, although at least 90% of standing order payments are sent by 6am.  In the Development environment, payments must be below 5 GBP / EUR. For details on any payment limits in Production, contact your Plaid Account Manager.
     * @summary Create a payment
     * @param {PaymentInitiationPaymentCreateRequest} paymentInitiationPaymentCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    paymentInitiationPaymentCreate(paymentInitiationPaymentCreateRequest: PaymentInitiationPaymentCreateRequest, options?: any): Promise<import("axios").AxiosResponse<PaymentInitiationPaymentCreateResponse>>;
    /**
     * The `/payment_initiation/payment/get` endpoint can be used to check the status of a payment, as well as to receive basic information such as recipient and payment amount. In the case of standing orders, the `/payment_initiation/payment/get` endpoint will provide information about the status of the overall standing order itself; the API cannot be used to retrieve payment status for individual payments within a standing order.
     * @summary Get payment details
     * @param {PaymentInitiationPaymentGetRequest} paymentInitiationPaymentGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    paymentInitiationPaymentGet(paymentInitiationPaymentGetRequest: PaymentInitiationPaymentGetRequest, options?: any): Promise<import("axios").AxiosResponse<PaymentInitiationPaymentGetResponse>>;
    /**
     * The `/payment_initiation/payment/list` endpoint can be used to retrieve all created payments. By default, the 10 most recent payments are returned. You can request more payments and paginate through the results using the optional `count` and `cursor` parameters.
     * @summary List payments
     * @param {PaymentInitiationPaymentListRequest} paymentInitiationPaymentListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    paymentInitiationPaymentList(paymentInitiationPaymentListRequest: PaymentInitiationPaymentListRequest, options?: any): Promise<import("axios").AxiosResponse<PaymentInitiationPaymentListResponse>>;
    /**
     * Reverse a previously initiated payment.  A payment can only be reversed once and will be refunded to the original sender\'s account.
     * @summary Reverse an existing payment
     * @param {PaymentInitiationPaymentReverseRequest} paymentInitiationPaymentReverseRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    paymentInitiationPaymentReverse(paymentInitiationPaymentReverseRequest: PaymentInitiationPaymentReverseRequest, options?: any): Promise<import("axios").AxiosResponse<PaymentInitiationPaymentReverseResponse>>;
    /**
     * Create a payment recipient for payment initiation.  The recipient must be in Europe, within a country that is a member of the Single Euro Payment Area (SEPA).  For a standing order (recurring) payment, the recipient must be in the UK.  The endpoint is idempotent: if a developer has already made a request with the same payment details, Plaid will return the same `recipient_id`.
     * @summary Create payment recipient
     * @param {PaymentInitiationRecipientCreateRequest} paymentInitiationRecipientCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    paymentInitiationRecipientCreate(paymentInitiationRecipientCreateRequest: PaymentInitiationRecipientCreateRequest, options?: any): Promise<import("axios").AxiosResponse<PaymentInitiationRecipientCreateResponse>>;
    /**
     * Get details about a payment recipient you have previously created.
     * @summary Get payment recipient
     * @param {PaymentInitiationRecipientGetRequest} paymentInitiationRecipientGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    paymentInitiationRecipientGet(paymentInitiationRecipientGetRequest: PaymentInitiationRecipientGetRequest, options?: any): Promise<import("axios").AxiosResponse<PaymentInitiationRecipientGetResponse>>;
    /**
     * The `/payment_initiation/recipient/list` endpoint list the payment recipients that you have previously created.
     * @summary List payment recipients
     * @param {PaymentInitiationRecipientListRequest} paymentInitiationRecipientListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    paymentInitiationRecipientList(paymentInitiationRecipientListRequest: PaymentInitiationRecipientListRequest, options?: any): Promise<import("axios").AxiosResponse<PaymentInitiationRecipientListResponse>>;
    /**
     * Used to create a token suitable for sending to Apex to enable Plaid-Apex integrations.
     * @summary Create Apex bank account token
     * @param {ProcessorApexProcessorTokenCreateRequest} processorApexProcessorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    processorApexProcessorTokenCreate(processorApexProcessorTokenCreateRequest: ProcessorApexProcessorTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<ProcessorTokenCreateResponse>>;
    /**
     * The `/processor/auth/get` endpoint returns the bank account and bank identification number (such as the routing number, for US accounts), for a checking or savings account that\'\'s associated with a given `processor_token`. The endpoint also returns high-level account data and balances when available.   Versioning note: API versions 2019-05-29 and earlier use a different schema for the `numbers` object returned by this endpoint. For details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2020-09-14).
     * @summary Retrieve Auth data
     * @param {ProcessorAuthGetRequest} processorAuthGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    processorAuthGet(processorAuthGetRequest: ProcessorAuthGetRequest, options?: any): Promise<import("axios").AxiosResponse<ProcessorAuthGetResponse>>;
    /**
     * The `/processor/balance/get` endpoint returns the real-time balance for each of an Item\'s accounts. While other endpoints may return a balance object, only `/processor/balance/get` forces the available and current balance fields to be refreshed rather than cached.
     * @summary Retrieve Balance data
     * @param {ProcessorBalanceGetRequest} processorBalanceGetRequest The &#x60;/processor/balance/get&#x60; endpoint returns the real-time balance for the account associated with a given &#x60;processor_token&#x60;.  The current balance is the total amount of funds in the account. The available balance is the current balance less any outstanding holds or debits that have not yet posted to the account.  Note that not all institutions calculate the available balance. In the event that available balance is unavailable from the institution, Plaid will return an available balance value of &#x60;null&#x60;.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    processorBalanceGet(processorBalanceGetRequest: ProcessorBalanceGetRequest, options?: any): Promise<import("axios").AxiosResponse<ProcessorBalanceGetResponse>>;
    /**
     * Use the `/processor/bank_transfer/create` endpoint to initiate a new bank transfer as a processor
     * @summary Create a bank transfer as a processor
     * @param {ProcessorBankTransferCreateRequest} processorBankTransferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    processorBankTransferCreate(processorBankTransferCreateRequest: ProcessorBankTransferCreateRequest, options?: any): Promise<import("axios").AxiosResponse<ProcessorBankTransferCreateResponse>>;
    /**
     * The `/processor/identity/get` endpoint allows you to retrieve various account holder information on file with the financial institution, including names, emails, phone numbers, and addresses.
     * @summary Retrieve Identity data
     * @param {ProcessorIdentityGetRequest} processorIdentityGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    processorIdentityGet(processorIdentityGetRequest: ProcessorIdentityGetRequest, options?: any): Promise<import("axios").AxiosResponse<ProcessorIdentityGetResponse>>;
    /**
     * Used to create a token suitable for sending to Stripe to enable Plaid-Stripe integrations. For a detailed guide on integrating Stripe, see [Add Stripe to your app](https://plaid.com/docs/auth/partnerships/stripe/).
     * @summary Create Stripe bank account token
     * @param {ProcessorStripeBankAccountTokenCreateRequest} processorStripeBankAccountTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    processorStripeBankAccountTokenCreate(processorStripeBankAccountTokenCreateRequest: ProcessorStripeBankAccountTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<ProcessorStripeBankAccountTokenCreateResponse>>;
    /**
     * Used to create a token suitable for sending to one of Plaid\'s partners to enable integrations. Note that Stripe partnerships use bank account tokens instead; see `/processor/stripe/bank_account_token/create` for creating tokens for use with Stripe integrations.
     * @summary Create processor token
     * @param {ProcessorTokenCreateRequest} processorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    processorTokenCreate(processorTokenCreateRequest: ProcessorTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<ProcessorTokenCreateResponse>>;
    /**
     * Use the `/sandbox/bank_transfer/fire_webhook` endpoint to manually trigger a Bank Transfers webhook in the Sandbox environment.
     * @summary Manually fire a Bank Transfer webhook
     * @param {SandboxBankTransferFireWebhookRequest} sandboxBankTransferFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxBankTransferFireWebhook(sandboxBankTransferFireWebhookRequest: SandboxBankTransferFireWebhookRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxBankTransferFireWebhookResponse>>;
    /**
     * Use the `/sandbox/bank_transfer/simulate` endpoint to simulate a bank transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/bank_transfer/event/sync` or `/bank_transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.
     * @summary Simulate a bank transfer event in Sandbox
     * @param {SandboxBankTransferSimulateRequest} sandboxBankTransferSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxBankTransferSimulate(sandboxBankTransferSimulateRequest: SandboxBankTransferSimulateRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxBankTransferSimulateResponse>>;
    /**
     * Use the `/sandbox/income/fire_webhook` endpoint to manually trigger an Income webhook in the Sandbox environment.
     * @summary Manually fire an Income webhook
     * @param {SandboxIncomeFireWebhookRequest} sandboxIncomeFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxIncomeFireWebhook(sandboxIncomeFireWebhookRequest: SandboxIncomeFireWebhookRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxIncomeFireWebhookResponse>>;
    /**
     * The `/sandbox/item/fire_webhook` endpoint is used to test that code correctly handles webhooks. This endpoint can trigger a Transactions `DEFAULT_UPDATE` webhook to be fired for a given Sandbox Item. If the Item does not support Transactions, a `SANDBOX_PRODUCT_NOT_ENABLED` error will result. This endpoint can also trigger a `NEW_ACCOUNTS_AVAILABLE` webhook to be fired for a given Sandbox Item created with Account Select v2. Note that this endpoint is provided for developer ease-of-use and is not required for testing webhooks; webhooks will also fire in Sandbox under the same conditions that they would in Production or Development.
     * @summary Fire a test webhook
     * @param {SandboxItemFireWebhookRequest} sandboxItemFireWebhookRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxItemFireWebhook(sandboxItemFireWebhookRequest: SandboxItemFireWebhookRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxItemFireWebhookResponse>>;
    /**
     * `/sandbox/item/reset_login/` forces an Item into an `ITEM_LOGIN_REQUIRED` state in order to simulate an Item whose login is no longer valid. This makes it easy to test Link\'s [update mode](https://plaid.com/docs/link/update-mode) flow in the Sandbox environment.  After calling `/sandbox/item/reset_login`, You can then use Plaid Link update mode to restore the Item to a good state. An `ITEM_LOGIN_REQUIRED` webhook will also be fired after a call to this endpoint, if one is associated with the Item.   In the Sandbox, Items will transition to an `ITEM_LOGIN_REQUIRED` error state automatically after 30 days, even if this endpoint is not called.
     * @summary Force a Sandbox Item into an error state
     * @param {SandboxItemResetLoginRequest} sandboxItemResetLoginRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxItemResetLogin(sandboxItemResetLoginRequest: SandboxItemResetLoginRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxItemResetLoginResponse>>;
    /**
     * The `/sandbox/item/set_verification_status` endpoint can be used to change the verification status of an Item in in the Sandbox in order to simulate the Automated Micro-deposit flow.  Note that not all Plaid developer accounts are enabled for micro-deposit based verification by default. Your account must be enabled for this feature in order to test it in Sandbox. To enable this features or check your status, contact your account manager or [submit a product access Support ticket](https://dashboard.plaid.com/support/new/product-and-development/product-troubleshooting/request-product-access).  For more information on testing Automated Micro-deposits in Sandbox, see [Auth full coverage testing](https://plaid.com/docs/auth/coverage/testing#).
     * @summary Set verification status for Sandbox account
     * @param {SandboxItemSetVerificationStatusRequest} sandboxItemSetVerificationStatusRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxItemSetVerificationStatus(sandboxItemSetVerificationStatusRequest: SandboxItemSetVerificationStatusRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxItemSetVerificationStatusResponse>>;
    /**
     * Save the selected accounts when connecting to the Platypus Oauth institution
     * @summary Save the selected accounts when connecting to the Platypus Oauth institution
     * @param {SandboxOauthSelectAccountsRequest} sandboxOauthSelectAccountsRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxOauthSelectAccounts(sandboxOauthSelectAccountsRequest: SandboxOauthSelectAccountsRequest, options?: any): Promise<import("axios").AxiosResponse<{
        [key: string]: object;
    }>>;
    /**
     * Use the `/sandbox/processor_token/create` endpoint to create a valid `processor_token` for an arbitrary institution ID and test credentials. The created `processor_token` corresponds to a new Sandbox Item. You can then use this `processor_token` with the `/processor/` API endpoints in Sandbox. You can also use `/sandbox/processor_token/create` with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data.
     * @summary Create a test Item and processor token
     * @param {SandboxProcessorTokenCreateRequest} sandboxProcessorTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxProcessorTokenCreate(sandboxProcessorTokenCreateRequest: SandboxProcessorTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxProcessorTokenCreateResponse>>;
    /**
     * Use the `/sandbox/public_token/create` endpoint to create a valid `public_token`  for an arbitrary institution ID, initial products, and test credentials. The created `public_token` maps to a new Sandbox Item. You can then call `/item/public_token/exchange` to exchange the `public_token` for an `access_token` and perform all API actions. `/sandbox/public_token/create` can also be used with the [`user_custom` test username](https://plaid.com/docs/sandbox/user-custom) to generate a test account with custom data. `/sandbox/public_token/create` cannot be used with OAuth institutions.
     * @summary Create a test Item
     * @param {SandboxPublicTokenCreateRequest} sandboxPublicTokenCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxPublicTokenCreate(sandboxPublicTokenCreateRequest: SandboxPublicTokenCreateRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxPublicTokenCreateResponse>>;
    /**
     * Use the `/sandbox/transfer/repayment/simulate` endpoint to trigger the creation of a repayment. As a side effect of calling this route, a repayment is created that includes all unreimbursed returns of guaranteed transfers. If there are no such returns, an 400 error is returned.
     * @summary Trigger the creation of a repayment
     * @param {SandboxTransferRepaymentSimulateRequest} sandboxTransferRepaymentSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxTransferRepaymentSimulate(sandboxTransferRepaymentSimulateRequest: SandboxTransferRepaymentSimulateRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxTransferRepaymentSimulateResponse>>;
    /**
     * Use the `/sandbox/transfer/simulate` endpoint to simulate a transfer event in the Sandbox environment.  Note that while an event will be simulated and will appear when using endpoints such as `/transfer/event/sync` or `/transfer/event/list`, no transactions will actually take place and funds will not move between accounts, even within the Sandbox.
     * @summary Simulate a transfer event in Sandbox
     * @param {SandboxTransferSimulateRequest} sandboxTransferSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxTransferSimulate(sandboxTransferSimulateRequest: SandboxTransferSimulateRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxTransferSimulateResponse>>;
    /**
     * Use the `/sandbox/transfer/sweep/simulate` endpoint to create a sweep and associated events in the Sandbox environment. Upon calling this endpoint, all `posted` or `pending` transfers with a sweep status of `unswept` will become `swept`, and all `reversed` transfers with a sweep status of `swept` will become `reverse_swept`.
     * @summary Simulate creating a sweep
     * @param {SandboxTransferSweepSimulateRequest} sandboxTransferSweepSimulateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    sandboxTransferSweepSimulate(sandboxTransferSweepSimulateRequest: SandboxTransferSweepSimulateRequest, options?: any): Promise<import("axios").AxiosResponse<SandboxTransferSweepSimulateResponse>>;
    /**
     * After calling `/signal/evaluate`, call `/signal/decision/report` to report whether the transaction was initiated. This endpoint will return an `INVALID_REQUEST` error if called a second time with a different value for `initiated`.
     * @summary Report whether you initiated an ACH transaction
     * @param {SignalDecisionReportRequest} signalDecisionReportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    signalDecisionReport(signalDecisionReportRequest: SignalDecisionReportRequest, options?: any): Promise<import("axios").AxiosResponse<SignalDecisionReportResponse>>;
    /**
     * Use `/signal/evaluate` to evaluate a planned ACH transaction to get a return risk assessment (such as a risk score and risk tier) and additional risk signals.  In order to obtain a valid score for an ACH transaction, Plaid must have an access token for the account, and the Item must be healthy (receiving product updates) or have recently been in a healthy state. If the transaction does not meet eligibility requirements, an error will be returned corresponding to the underlying cause. If `/signal/evaluate` is called on the same transaction multiple times within a 24-hour period, cached results may be returned.
     * @summary Evaluate a planned ACH transaction
     * @param {SignalEvaluateRequest} signalEvaluateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    signalEvaluate(signalEvaluateRequest: SignalEvaluateRequest, options?: any): Promise<import("axios").AxiosResponse<SignalEvaluateResponse>>;
    /**
     * Call the `/signal/return/report` endpoint to report a returned transaction that was previously sent to the `/signal/evaluate` endpoint. Your feedback will be used by the model to incorporate the latest risk trend in your portfolio.
     * @summary Report a return for an ACH transaction
     * @param {SignalReturnReportRequest} signalReturnReportRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    signalReturnReport(signalReturnReportRequest: SignalReturnReportRequest, options?: any): Promise<import("axios").AxiosResponse<SignalReturnReportResponse>>;
    /**
     * The `/transactions/get` endpoint allows developers to receive user-authorized transaction data for credit, depository, and some loan-type accounts (only those with account subtype `student`; coverage may be limited). For transaction history from investments accounts, use the [Investments endpoint](https://plaid.com/docs/api/products#investments) instead. Transaction data is standardized across financial institutions, and in many cases transactions are linked to a clean name, entity type, location, and category. Similarly, account data is standardized and returned with a clean name, number, balance, and other meta information where available.  Transactions are returned in reverse-chronological order, and the sequence of transaction ordering is stable and will not shift.  Transactions are not immutable and can also be removed altogether by the institution; a removed transaction will no longer appear in `/transactions/get`.  For more details, see [Pending and posted transactions](https://plaid.com/docs/transactions/transactions-data/#pending-and-posted-transactions).  Due to the potentially large number of transactions associated with an Item, results are paginated. Manipulate the `count` and `offset` parameters in conjunction with the `total_transactions` response body field to fetch all available transactions.  Data returned by `/transactions/get` will be the data available for the Item as of the most recent successful check for new transactions. Plaid typically checks for new data multiple times a day, but these checks may occur less frequently, such as once a day, depending on the institution. An Item\'s `status.transactions.last_successful_update` field will show the timestamp of the most recent successful update. To force Plaid to check for new transactions, you can use the `/transactions/refresh` endpoint.  Note that data may not be immediately available to `/transactions/get`. Plaid will begin to prepare transactions data upon Item link, if Link was initialized with `transactions`, or upon the first call to `/transactions/get`, if it wasn\'t. To be alerted when transaction data is ready to be fetched, listen for the [`INITIAL_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-initial_update) and [`HISTORICAL_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-historical_update) webhooks. If no transaction history is ready when `/transactions/get` is called, it will return a `PRODUCT_NOT_READY` error.
     * @summary Get transaction data
     * @param {TransactionsGetRequest} transactionsGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transactionsGet(transactionsGetRequest: TransactionsGetRequest, options?: any): Promise<import("axios").AxiosResponse<TransactionsGetResponse>>;
    /**
     * The `/transactions/recurring/get` endpoint identifies and returns groups of transactions that occur on a regular basis for the inputted Item and accounts.  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.
     * @summary Get streams of recurring transactions
     * @param {TransactionsRecurringGetRequest} transactionsRecurringGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transactionsRecurringGet(transactionsRecurringGetRequest: TransactionsRecurringGetRequest, options?: any): Promise<import("axios").AxiosResponse<TransactionsRecurringGetResponse>>;
    /**
     * `/transactions/refresh` is an optional endpoint for users of the Transactions product. It initiates an on-demand extraction to fetch the newest transactions for an Item. This on-demand extraction takes place in addition to the periodic extractions that automatically occur multiple times a day for any Transactions-enabled Item. If changes to transactions are discovered after calling `/transactions/refresh`, Plaid will fire a webhook: [`TRANSACTIONS_REMOVED`](https://plaid.com/docs/api/webhooks#deleted-transactions-detected) will be fired if any removed transactions are detected, and [`DEFAULT_UPDATE`](https://plaid.com/docs/api/webhooks#transactions-default_update) will be fired if any new transactions are detected. New transactions can be fetched by calling `/transactions/get`.  Access to `/transactions/refresh` in Production is specific to certain pricing plans. If you cannot access `/transactions/refresh` in Production, [contact Sales](https://www.plaid.com/contact) for assistance.
     * @summary Refresh transaction data
     * @param {TransactionsRefreshRequest} transactionsRefreshRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transactionsRefresh(transactionsRefreshRequest: TransactionsRefreshRequest, options?: any): Promise<import("axios").AxiosResponse<TransactionsRefreshResponse>>;
    /**
     * The `/transactions/sync` endpoint returns item transactions as a set of delta updates. Subsequent calls to the endpoint using the cursor returned in the response will return new added, modified, and removed transactions since the last call to the endpoint  The product is currently in beta. To request access, contact transactions-feedback@plaid.com.
     * @summary Get incremental transaction updates on an Item
     * @param {TransactionsSyncRequest} transactionsSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transactionsSync(transactionsSyncRequest: TransactionsSyncRequest, options?: any): Promise<import("axios").AxiosResponse<TransactionsSyncResponse>>;
    /**
     * Use the `/transfer/authorization/create` endpoint to determine transfer failure risk.  In Plaid\'s sandbox environment the decisions will be returned as follows:    - To approve a transfer, make an authorization request with an `amount` less than the available balance in the account.    - To decline a transfer with the rationale code `NSF`, the available balance on the account must be less than the authorization `amount`. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To decline a transfer with the rationale code `RISK`, the available balance on the account must be exactly $0. See [Create Sandbox test data](https://plaid.com/docs/sandbox/user-custom/) for details on how to customize data in Sandbox.    - To permit a transfer with the rationale code `MANUALLY_VERIFIED_ITEM`, create an Item in Link through the [Same Day Micro-deposits flow](https://plaid.com/docs/auth/coverage/testing/#testing-same-day-micro-deposits).    - To permit a transfer with the rationale code `LOGIN_REQUIRED`, [reset the login for an Item](https://plaid.com/docs/sandbox/#item_login_required).  All username/password combinations other than the ones listed above will result in a decision of permitted and rationale code `ERROR`.
     * @summary Create a transfer authorization
     * @param {TransferAuthorizationCreateRequest} transferAuthorizationCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferAuthorizationCreate(transferAuthorizationCreateRequest: TransferAuthorizationCreateRequest, options?: any): Promise<import("axios").AxiosResponse<TransferAuthorizationCreateResponse>>;
    /**
     * Use the `/transfer/cancel` endpoint to cancel a transfer.  A transfer is eligible for cancelation if the `cancellable` property returned by `/transfer/get` is `true`.
     * @summary Cancel a transfer
     * @param {TransferCancelRequest} transferCancelRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferCancel(transferCancelRequest: TransferCancelRequest, options?: any): Promise<import("axios").AxiosResponse<TransferCancelResponse>>;
    /**
     * Use the `/transfer/create` endpoint to initiate a new transfer.
     * @summary Create a transfer
     * @param {TransferCreateRequest} transferCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferCreate(transferCreateRequest: TransferCreateRequest, options?: any): Promise<import("axios").AxiosResponse<TransferCreateResponse>>;
    /**
     * Use the `/transfer/event/list` endpoint to get a list of transfer events based on specified filter criteria.
     * @summary List transfer events
     * @param {TransferEventListRequest} transferEventListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferEventList(transferEventListRequest: TransferEventListRequest, options?: any): Promise<import("axios").AxiosResponse<TransferEventListResponse>>;
    /**
     * `/transfer/event/sync` allows you to request up to the next 25 transfer events that happened after a specific `event_id`. Use the `/transfer/event/sync` endpoint to guarantee you have seen all transfer events.
     * @summary Sync transfer events
     * @param {TransferEventSyncRequest} transferEventSyncRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferEventSync(transferEventSyncRequest: TransferEventSyncRequest, options?: any): Promise<import("axios").AxiosResponse<TransferEventSyncResponse>>;
    /**
     * The `/transfer/get` fetches information about the transfer corresponding to the given `transfer_id`.
     * @summary Retrieve a transfer
     * @param {TransferGetRequest} transferGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferGet(transferGetRequest: TransferGetRequest, options?: any): Promise<import("axios").AxiosResponse<TransferGetResponse>>;
    /**
     * Use the `/transfer/intent/create` endpoint to generate a transfer intent object and invoke the Transfer UI.
     * @summary Create a transfer intent object to invoke the Transfer UI
     * @param {TransferIntentCreateRequest} transferIntentCreateRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferIntentCreate(transferIntentCreateRequest: TransferIntentCreateRequest, options?: any): Promise<import("axios").AxiosResponse<TransferIntentCreateResponse>>;
    /**
     * Use the `/transfer/intent/get` endpoint to retrieve more information about a transfer intent.
     * @summary Retrieve more information about a transfer intent
     * @param {{ [key: string]: object; }} requestBody
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferIntentGet(requestBody: {
        [key: string]: object;
    }, options?: any): Promise<import("axios").AxiosResponse<TransferIntentGetResponse>>;
    /**
     * Use the `/transfer/list` endpoint to see a list of all your transfers and their statuses. Results are paginated; use the `count` and `offset` query parameters to retrieve the desired transfers.
     * @summary List transfers
     * @param {TransferListRequest} transferListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferList(transferListRequest: TransferListRequest, options?: any): Promise<import("axios").AxiosResponse<TransferListResponse>>;
    /**
     * The `/transfer/repayment/list` endpoint fetches repayments matching the given filters. Repayments are returned in reverse-chronological order (most recent first) starting at the given `start_time`.
     * @summary Lists historical repayments
     * @param {TransferRepaymentListRequest} transferRepaymentListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferRepaymentList(transferRepaymentListRequest: TransferRepaymentListRequest, options?: any): Promise<import("axios").AxiosResponse<TransferRepaymentListResponse>>;
    /**
     * The `/transfer/repayment/return/list` endpoint retrieves the set of returns that were batched together into the specified repayment. The sum of amounts of returns retrieved by this request equals the amount of the repayment.
     * @summary List the returns included in a repayment
     * @param {TransferRepaymentReturnListRequest} transferRepaymentReturnListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferRepaymentReturnList(transferRepaymentReturnListRequest: TransferRepaymentReturnListRequest, options?: any): Promise<import("axios").AxiosResponse<TransferRepaymentReturnListResponse>>;
    /**
     * The `/transfer/sweep/get` endpoint fetches a sweep corresponding to the given `sweep_id`.
     * @summary Retrieve a sweep
     * @param {TransferSweepGetRequest} transferSweepGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferSweepGet(transferSweepGetRequest: TransferSweepGetRequest, options?: any): Promise<import("axios").AxiosResponse<TransferSweepGetResponse>>;
    /**
     * The `/transfer/sweep/list` endpoint fetches sweeps matching the given filters.
     * @summary List sweeps
     * @param {TransferSweepListRequest} transferSweepListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    transferSweepList(transferSweepListRequest: TransferSweepListRequest, options?: any): Promise<import("axios").AxiosResponse<TransferSweepListResponse>>;
    /**
     * Fetch an e-wallet. The response includes the current balance.
     * @summary Fetch an e-wallet
     * @param {WalletGetRequest} walletGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    walletGet(walletGetRequest: WalletGetRequest, options?: any): Promise<import("axios").AxiosResponse<WalletGetResponse>>;
    /**
     * Execute a transaction using the specified e-wallet. Specify the e-wallet to debit from, the counterparty to credit to, the idempotency key to prevent duplicate payouts, the amount and reference for the payout. The payouts are executed over the Faster Payment rails, where settlement usually only takes a few seconds.
     * @summary Execute a transaction using an e-wallet
     * @param {WalletTransactionExecuteRequest} walletTransactionExecuteRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    walletTransactionExecute(walletTransactionExecuteRequest: WalletTransactionExecuteRequest, options?: any): Promise<import("axios").AxiosResponse<WalletTransactionExecuteResponse>>;
    /**
     * This endpoint lists the latest transactions of the specified e-wallet. Transactions are returned in descending order by the `created_at` time.
     * @summary List e-wallet transactions
     * @param {WalletTransactionsListRequest} walletTransactionsListRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    walletTransactionsList(walletTransactionsListRequest: WalletTransactionsListRequest, options?: any): Promise<import("axios").AxiosResponse<WalletTransactionsListResponse>>;
    /**
     * Plaid signs all outgoing webhooks and provides JSON Web Tokens (JWTs) so that you can verify the authenticity of any incoming webhooks to your application. A message signature is included in the `Plaid-Verification` header.  The `/webhook_verification_key/get` endpoint provides a JSON Web Key (JWK) that can be used to verify a JWT.
     * @summary Get webhook verification key
     * @param {WebhookVerificationKeyGetRequest} webhookVerificationKeyGetRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PlaidApi
     */
    webhookVerificationKeyGet(webhookVerificationKeyGetRequest: WebhookVerificationKeyGetRequest, options?: any): Promise<import("axios").AxiosResponse<WebhookVerificationKeyGetResponse>>;
}
