from jarvis.ai.descriptors.get_desc import CFID
from jarvis.core.atoms import Atoms


def test_desc():
    box = [[2.715, 2.715, 0], [0, 2.715, 2.715], [2.715, 0, 2.715]]
    coords = [[0, 0, 0], [0.25, 0.2, 0.25]]
    elements = ["Si", "Si"]
    Si = Atoms(lattice_mat=box, coords=coords, elements=elements)
    cfid = CFID(Si)
    names = cfid.get_comp_descp(print_names=True)
    values = cfid.get_comp_descp().tolist()
    cfid_values = [
        3490.3,
        3173.5021,
        6.680000000000001,
        -16.0255,
        0.0,
        19.933819999999997,
        3.0,
        338.71113,
        0.03333333333333333,
        -1682.0,
        6.083000000000001,
        2.5384,
        63.28,
        0.0,
        -145.0,
        11.246666666666666,
        3.2359999999999998,
        3185.06,
        0.0,
        55.9,
        150.0,
        55.9,
        0.0,
        0.0,
        0.0,
        55.9,
        55.9,
        150.0,
        1685.664,
        1.8381,
        -6.81568,
        137.94,
        -10.16,
        7.64958,
        13.15168,
        0.29024514429153836,
        -4.43,
        13.4865,
        13.4865,
        13.4865,
        37.522228,
        29.421499999999998,
        148.664,
        0.039166117747592176,
        0.22000000000000003,
        4.0,
        45.0787904,
        337.4,
        24.01911969727146,
        60.06658240017091,
        -1537.0,
        2.0,
        10.96,
        2.19079864568811,
        1687.0,
        1.6021,
        33.085499999999996,
        25.532272727272726,
        0.4564545454545454,
        10.507,
        8.15168,
        3174.9,
        148.9,
        3.1516800000000007,
        2.6216800000000005,
        -1.3979,
        98.30926080000002,
        13751.884160000001,
        89115.29149999999,
        1486.0,
        6.630000000000001,
        149.4979,
        1699.06,
        6.81568,
        178.0855,
        0.18723666666666666,
        0.6759270315091211,
        0.003278008298755187,
        -148.664,
        0.0,
        0.14789999999999992,
        -1658.9145,
        7.0600000000000005,
        -4.1690586,
        155.312815,
        1695.15168,
        36.23718,
        38266.380000000005,
        40.1455,
        0.0,
        -4.4979,
        0.41459369817578773,
        4.0929585280000005,
        47380.2385,
        5.53,
        141.84832,
        10.724,
        136.36363636363635,
        -19.933819999999997,
        2.09,
        1674.94,
        0.00015824141191301606,
        -137.94,
        3.90832,
        0.773,
        285.0,
        10.16,
        -0.5639999999999998,
        1.1,
        3171.664,
        0.6783877679202324,
        1855.7,
        9329.11,
        0.002569076583674756,
        28.0855,
        3023.0,
        3201.0855,
        11.013742282413862,
        0.5523100000000001,
        1.6303360000000002,
        1837.0,
        14.10172955,
        0.041633499170812605,
        0.09079566003616636,
        16.23517227643896,
        -26.7495,
        2.5105,
        3.6300000000000003,
        200.4,
        -26.9855,
        0.0,
        -23.0855,
        22.914,
        -1686.4979,
        10.963636363636363,
        22.5555,
        0.0912106135986733,
        3174.336,
        55.9,
        55.9,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        150.0,
        0.10042,
        -22.5555,
        0.0,
        0.0,
        0.7999999999999998,
        0.5639999999999998,
        5.0,
        1715.0855,
        1688.336,
        0.0,
        3178.53,
        6.0321,
        -6.25168,
        1678.84832,
        5.5,
        -1674.94,
        0.01664819205690575,
        -0.5300000000000002,
        389.244916385334,
        1692.53,
        155.53,
        -0.5979000000000001,
        0.05434453333333334,
        -26.1855,
        -3160.94,
        829.5,
        3168.0,
        13.4865,
        13.4865,
        13.4865,
        -0.7999999999999998,
        6.9,
        8435.0,
        1658.9145,
        1692.0,
        298.7452698665605,
        112.97644692100906,
        15.488192,
        6.055326,
        0.001575795776867318,
        2.412,
        5.6171,
        0.0,
        2.180831826401447,
        -121.9145,
        0.007333333333333334,
        5.07875226039783,
        3174.1,
        4.4979,
        -3167.47,
        0.0017428301292152538,
        2253.8320000000003,
        0.0,
        2.3288142620232173,
        139.88391376451077,
        145.0,
        26.9855,
        1.106,
        -1681.47,
        -144.47,
        87.267,
        -4.0,
        1.4696000000000002,
        144.47,
        -3168.0,
        3178.0,
        0.0,
        3205.2999999999997,
        30.894050000000004,
        40.7584,
        -3.6639999999999997,
        1.880853586247777,
        -10.96,
        3172.4979,
        -7.051680000000001,
        0.000297628927089508,
        -1678.84832,
        1688.1,
        28.5876,
        3160.94,
        8.653780000000001,
        3171.9,
        2884.5454545454545,
        0.0,
        27.5834,
        1537.0,
        5.027272727272727,
        17.59,
        3181.15168,
        -149.4979,
        3359.888468432583,
        -3171.1,
        5352851.0,
        4212.825,
        0.0804,
        3.1,
        -3.90832,
        6.8660000000000005,
        121.9145,
        -3172.4979,
        16.0255,
        1.9,
        0.0,
        -7.64958,
        0.004832056905749852,
        151.1,
        0.19891500904159132,
        0.017877552473696393,
        253050.0,
        10.051680000000001,
        10.530000000000001,
        6.53,
        18.40111486221245,
        15865.0,
        29.1855,
        847.0427,
        0.9041591320072332,
        151.336,
        74.1,
        0.0,
        5.5021,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        74.1,
        27.124773960217,
        20345.22,
        1685.1,
        3144.9145,
        158.15168,
        0.1780278079436008,
        23.0855,
        150.5021,
        0.0006520450503852994,
        1682.0,
        2.776613,
        6319.458275243976,
        30.0,
        7.051680000000001,
        -3171.9,
        3.0,
        17.060000000000002,
        0.54,
        263.1011608623549,
        -1685.9,
        140.4275,
        151.9,
        -148.9,
        13.68168,
        17546.690000000002,
        10.890644480000002,
        -10.724,
        2.0,
        11.5579,
        0.008851402458241411,
        3167.47,
        4860.0,
        0.45854063018242125,
        3.6639999999999997,
        2.436,
        13.16,
        0.9539899999999999,
        1686.4979,
        0.6133704954070817,
        0.13494150898955798,
        16.112160000000003,
        1.0,
        75.315,
        0.0033473333333333332,
        12.43781094527363,
        1.336,
        1533.6363636363635,
        -4.194,
        0.19689875558562248,
        -0.236,
        21.153333333333332,
        53.362449999999995,
        305.0632911392405,
        0.236,
        4.545454545454545,
        -11.5579,
        162.06,
        6028.7,
        0.08891523414344991,
        1681.47,
        0.00034667507091081,
        0.5979000000000001,
        4.194,
        5.340834238308024,
        634.6,
        3323.0,
        0.06159466514877914,
        9.5,
        3171.1,
        0.5300000000000002,
        14.0,
        1.4740831826401448,
        228.94400864000002,
        1809.0,
        475950.0,
        12.06,
        60.300000000000004,
        26.7495,
        3.4453634097511183,
        -0.8339000000000001,
        25865.28064,
        66.6918,
        33.6155,
        4239.128000000001,
        3.9,
        1688.9,
        -3171.664,
        0.036866666666666666,
        27.650000000000002,
        3173.0,
        750.0,
        -1685.664,
        0.0,
        0.0,
        0.0,
        0.0,
        74.1,
        0.0,
        6.25168,
        0.0,
        -1486.0,
        12.562100000000001,
        2.0,
        -3.9,
        -148.1,
        -2.6216800000000005,
        -27.5834,
        0.003800819413803971,
        -141.84832,
        6.336,
        9.958175662218682,
        150.0,
        3164.84832,
        -3.1,
        0.04727387330601954,
        0.5316734951150331,
        7.410618181818182,
        -5.027900000000001,
        0.007148784825133373,
        6.1,
        13.266000000000002,
        8.966848000000002,
        1593.1633,
        -3.1516800000000007,
        14.0,
        5.027900000000001,
        7.43,
        0.0,
        4.0,
        -3164.84832,
        0.002963841138114997,
        55.93606851224855,
        -5.424918005,
        0.8339000000000001,
        -3144.9145,
        9.487680000000001,
        20.21168,
        0.6708056,
        7.38808,
        2.4021,
        1687.5021,
        -3023.0,
        573.7793851717902,
        1.3979,
        165.0,
        155.0,
        0.14789999999999992,
        -3.6300000000000003,
        1.479449634921881,
        206.95120515034935,
        -7.0600000000000005,
        13.396,
        13.96,
        29.9855,
        4.43,
        0.42940307275996514,
        -6.53,
        1685.9,
        -1685.1,
        26.1855,
        9.25168,
        148.1,
        0.5021,
        1222.7520000000002,
        20.01288,
        2.99638,
        0.27858,
        2.33035,
        0.000101099096,
        13.885753587772703,
        14.688247243975486,
        10.88939265779301,
        9.704967243016455,
        10.803790350142046,
        12.528159730426601,
        13.824128467757193,
        14.320374210042372,
        14.042714632327769,
        13.180047480540503,
        11.95255871108468,
        10.552025476821736,
        9.12340175114956,
        7.764798886981367,
        6.534631106098834,
        5.463232745463234,
        4.557765642232334,
        3.8143618160637662,
        3.2179062464334436,
        2.753075965502031,
        2.399369256231971,
        2.1395788234700657,
        1.9552841758946582,
        1.8315174267355625,
        1.7546297163412778,
        1.713919078494754,
        1.6990982461812005,
        1.7022494870937832,
        1.7171656061942961,
        1.7386714483689918,
        1.7629056889877732,
        1.7870241329349243,
        1.8088886442082208,
        1.826938881162812,
        1.8403209224284398,
        1.8482313910746344,
        1.8504125974968808,
        1.8468892965687804,
        1.837755806913579,
        1.8232467579086382,
        1.8037008033327644,
        1.7795281868243293,
        1.7511825103162408,
        1.7191367490265947,
        1.6838626876541745,
        1.6456342900604544,
        1.6051036941688623,
        1.5626848825372899,
        1.5186674253219972,
        1.4734531684561074,
        1.4274271565606376,
        1.3807960458941457,
        1.3339149652519229,
        1.2869955004472409,
        1.240245765922027,
        1.1939053354488198,
        1.148059591935554,
        1.1029526243364558,
        1.0586330662767796,
        1.0151684474569673,
        0.9728219077603807,
        0.931489151737343,
        0.8912262156325292,
        0.8522153066876396,
        0.8144219465071573,
        0.7778118054626184,
        0.7424039012518674,
        0.7082343003749112,
        0.6754155509626677,
        0.6438066422448463,
        0.6134005195117006,
        0.5841855441772918,
        0.5561459857617796,
        0.529262467360619,
        0.5035124009943308,
        0.47887041515578477,
        0.455308741685914,
        0.43280022603107887,
        0.41132648073538125,
        0.3908266357814463,
        0.37126759092749484,
        0.3526156452396327,
        0.33486108667124204,
        0.3179581764888271,
        0.30186866863925976,
        0.2865578456320608,
        0.27199143121630787,
        0.2581357440978138,
        0.2449578490511471,
        0.23242566717418608,
        0.22050808202994263,
        0.20917501999784535,
        0.19839750854307509,
        0.18819780202779982,
        0.17855291279502553,
        0.16938222151015173,
        0.16066071303855306,
        0.15236465053438544,
        0.14447156056636531,
        0.13703176880200346,
        0.12999563106894887,
        0.12329701642093344,
        0.11691775823981221,
        0.11084084683726511,
        0.10515962660593746,
        0.09975192732795807,
        0.09459456959257567,
        0.08967446327166051,
        0.08507864680195673,
        0.08070508276340634,
        0.0765264806531167,
        0.07255471310996964,
        0.068845949251928,
        0.06529627532786149,
        0.061898212150207126,
        0.058729165633157075,
        0.05571100735262829,
        0.052816335818010623,
        0.050102706756455104,
        0.047532500911007636,
        0.04506256746173452,
        0.04274763049216789,
        0.040554251944774175,
        0.03844220457587506,
        0.03647495509047614,
        0.034598288808659096,
        0.03278767316451108,
        0.03112247505237718,
        0.029512026976846212,
        0.027982315824572397,
        0.026551646787638838,
        0.025165235675720467,
        0.023878353982339277,
        0.02264463010666857,
        0.02146619126366128,
        0.020369231720256387,
        0.019301546896048405,
        0.018316615489918493,
        0.01736510435547117,
        0.016466193360574647,
        0.015618535632907223,
        0.014799087363498532,
        0.014044133029401244,
        0.013304221909134833,
        0.012625688745143745,
        0.011964689170466627,
        0.011348386406010106,
        0.010757770939975712,
        0.010198698231169246,
        0.009670792776518675,
        0.009164289508085737,
        0.008692201103340529,
        0.008233927145394206,
        0.0078114764086595085,
        0.007397394910706231,
        0.007019053017458167,
        0.0066454131422765805,
        0.006306243162203803,
        0.005969563930313939,
        0.005665166207569104,
        0.005362220856586049,
        0.005088682370907881,
        0.004816483484075582,
        0.0045703309915934905,
        0.004326116346270603,
        0.004104272844268788,
        0.003885491698372317,
        0.0036852364042653588,
        0.003489536560607184,
        0.003308467974271203,
        0.003133683354361227,
        0.0029696853311410756,
        0.0028138241334860633,
        0.0026650347988531257,
        0.002526268229295912,
        0.0023910515463299903,
        0.002267703030419314,
        0.0021446228925632647,
        0.0020351578193777316,
        0.0019256927461922025,
        0.0018259704970339486,
        0.0017289864694662014,
        0.0016377570193007952,
        0.0015519745778663195,
        0.0014683833880593051,
        0.0013926371829758265,
        0.0013168909778923505,
        0.0012491705031880376,
        0.0011824009544116338,
        0.0011199640014200659,
        0.0010612094069965853,
        0.0010035796268781053,
        0.0009519686336844218,
        0.0009003576404907364,
        0.0008534775836312171,
        0.0008082221689993223,
        0.0007646653319453457,
        0.0007250541460347281,
        0.000685442960124109,
        0.000649968342080621,
        0.000615360437449981,
        0.0005821756839215665,
        0.0005519946521981862,
        0.0005218136204748048,
        0.0004947002688195703,
        0.0004684287233913552,
        0.0004429013943759038,
        0.0004200758696398584,
        0.0003972503449038122,
        0.00037628911577081966,
        0.0003564952519118203,
        0.00033670138805282096,
        0.0003195194016892166,
        0.0003023874540262648,
        0.00028598875009319224,
        0.00027118949227568703,
        0.0002563902344581818,
        0.00024284343796539607,
        0.0002300842852507038,
        0.00021732513253601202,
        0.00020613213427104923,
        0.0001951536333171973,
        0.00018434693546782896,
        0.0001749194800016106,
        0.00016549202453539262,
        0.00015647870863483778,
        0.00014839952173415275,
        0.000140320334833468,
        0.00013278886449617745,
        0.0001258792673938571,
        0.00011896967029153651,
        0.00011266119214373987,
        0.00010676405365761346,
        0.00010086691517148686,
        9.556712027626406e-05,
        9.054458257624502e-05,
        8.5522044876226e-05,
        8.105410556122916e-05,
        7.678546293140986e-05,
        7.25168203015907e-05,
        6.87353146409114e-05,
        6.511512796061997e-05,
        6.149494128032866e-05,
        5.828062675243658e-05,
        5.521698739411655e-05,
        5.215334803579641e-05,
        4.940871234458078e-05,
        4.6821695826697765e-05,
        4.4234679308814654e-05,
        4.1880146246334466e-05,
        3.9700395258902684e-05,
        3.7520644271470903e-05,
        3.549138391972442e-05,
        3.3658859184888866e-05,
        3.182633445005338e-05,
        3.0069575330228096e-05,
        2.8532419291633898e-05,
        2.6995263253039754e-05,
        2.5468047708748333e-05,
        2.4181572416176546e-05,
        2.2895097123604715e-05,
        2.1608621831032884e-05,
        2.048820850232913e-05,
        1.9413998001864034e-05,
        1.8339787501398976e-05,
        1.7352374121844967e-05,
        1.6457480955229187e-05,
        1.5562587788613434e-05,
        1.468949651367825e-05,
        1.394573040533558e-05,
        1.3201964296992885e-05,
        1.245819818865019e-05,
        1.1811317117103277e-05,
        1.119461768486463e-05,
        1.0577918252626004e-05,
        9.997258721933266e-06,
        9.487139549065982e-06,
        8.977020376198715e-06,
        8.466901203331431e-06,
        8.034435034311605e-06,
        7.613495513705872e-06,
        7.192555993100139e-06,
        6.798394090928692e-06,
        6.451891844626393e-06,
        6.105389598324107e-06,
        5.758887352021808e-06,
        5.462250340298855e-06,
        5.177726515166134e-06,
        4.893202690033403e-06,
        4.619213922436829e-06,
        4.3861654934995145e-06,
        4.153117064562199e-06,
        3.920068635624892e-06,
        3.710879183619191e-06,
        3.520475212151084e-06,
        3.3300712406829702e-06,
        3.139667269214856e-06,
        2.979866030214414e-06,
        2.824700069643391e-06,
        2.669534109072373e-06,
        2.518172894154483e-06,
        2.3920499067226954e-06,
        2.265926919290912e-06,
        2.1398039318591237e-06,
        2.0219542446154104e-06,
        1.919705544957678e-06,
        1.8174568452999462e-06,
        1.715208145642218e-06,
        1.623029587837531e-06,
        1.5403547817029076e-06,
        1.457679975568281e-06,
        1.3750051694336548e-06,
        1.3024808440966697e-06,
        1.2358112615635655e-06,
        1.1691416790304638e-06,
        1.1024720964973596e-06,
        1.0450056957379996e-06,
        9.913880501429275e-07,
        9.377704045478534e-07,
        8.841527589527813e-07,
        8.382476006077349e-07,
        7.952441512225473e-07,
        7.522407018373596e-07,
        7.09237252452175e-07,
        6.72244282781084e-07,
        6.378508983660387e-07,
        6.034575139509933e-07,
        5.690641295359478e-07,
        5.389772504432337e-07,
        5.11542637515001e-07,
        4.841080245867682e-07,
        4.566734116585355e-07,
        4.319825789248996e-07,
        4.10166620840682e-07,
        3.8835066275646286e-07,
        3.665347046722437e-07,
        3.461023589109603e-07,
        3.288101977054132e-07,
        3.115180364998673e-07,
        2.9422587529432015e-07,
        2.7719031421884296e-07,
        2.635243949237832e-07,
        2.498584756287235e-07,
        2.3619255633366476e-07,
        2.22526637038605e-07,
        2.1112731726973314e-07,
        2.003583810091671e-07,
        1.8958944474860104e-07,
        1.7882050848803577e-07,
        1.6906717024222378e-07,
        1.6060590779544846e-07,
        1.5214464534867314e-07,
        1.4368338290189783e-07,
        1.353012521779115e-07,
        1.2867284568120904e-07,
        1.2204443918450655e-07,
        1.1541603268780408e-07,
        1.087876261911016e-07,
        1.0301692373301486e-07,
        9.783992572137744e-08,
        9.266292770974001e-08,
        8.748592969810259e-08,
        8.240371197999009e-08,
        7.837259366858356e-08,
        7.434147535717674e-08,
        7.031035704576993e-08,
        6.627923873436311e-08,
        6.271511165928579e-08,
        5.95859073657198e-08,
        5.6456703072153584e-08,
        5.332749877858736e-08,
        5.019829448502115e-08,
        4.7702772429769e-08,
        4.528126088185758e-08,
        4.2859749333945986e-08,
        4.043823778603439e-08,
        3.81356970659779e-08,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        3.4446446874449723,
        0.0,
        5.766713556410591,
        0.0,
        2.448858114549567,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        12.89243673888783,
        0.0,
        0.0,
        0.0,
        0.0,
        1.6831855492288896,
        2.4125848416863285,
        3.8461778952553507,
        1.473014392318843,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        3.216960283797239,
        0.0,
        0.0,
        1.4450213271961465,
        0.930694882923183,
        1.7993492821716246,
        0.8701797981033056,
        0.42105597792246025,
        0.0,
        0.0,
        0.0,
        0.0,
        8.64289834594618,
        0.0,
        1.0181975239368075,
        0.6594054491044383,
        1.6020797335813168,
        0.9345482522304529,
        0.9089458142214852,
        0.0,
        0.0,
        0.0,
        3.2655161005772038,
        0.0,
        1.0337474293257236,
        2.015810213168586,
        0.9830198408489697,
        1.4385674255491163,
        0.46796828262756335,
        0.0,
        0.0,
        5.228458910020921,
        0.0,
        0.6240222275440075,
        0.4066665686246087,
        0.7952598196473212,
        0.5833367198916855,
        0.0,
        0.0,
        0.0,
        1.4266648296774873,
        1.2223257655203918,
        1.1971240745392393,
        0.5025830689876436,
        1.1490038571616263,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        1.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        2.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        1.7223223437224862,
        0.0,
        2.8833567782052953,
        0.0,
        1.2244290572747836,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        6.446218369443915,
        0.0,
        0.0,
        0.0,
        0.0,
        0.8415927746144448,
        1.2062924208431642,
        1.9230889476276753,
        0.7365071961594215,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        1.6084801418986194,
        0.0,
        0.0,
        0.7225106635980733,
        0.4653474414615915,
        0.8996746410858123,
        0.4350898990516528,
        0.21052798896123012,
        0.0,
        0.0,
        0.0,
        0.0,
        4.32144917297309,
        0.0,
        0.5090987619684038,
        0.32970272455221916,
        0.8010398667906584,
        0.46727412611522645,
        0.4544729071107426,
        0.0,
        0.0,
        0.0,
        1.6327580502886019,
        0.0,
        0.5168737146628618,
        1.007905106584293,
        0.4915099204244848,
        0.7192837127745582,
        0.23398414131378167,
        0.0,
        0.0,
        2.6142294550104603,
        0.0,
        0.31201111377200375,
        0.20333328431230435,
        0.3976299098236606,
        0.2916683599458427,
        0.0,
        0.0,
        0.0,
        0.7133324148387437,
        0.6111628827601959,
        0.5985620372696197,
        0.2512915344938218,
        0.5745019285808132,
        0.0,
        0.0,
    ]

    # print (values,len(values))
    cfid_names = [
        "bp_mult_atom_rad",
        "hfus_add_bp",
        "elec_aff_mult_voro_coord",
        "mol_vol_subs_atom_mass",
        "is_halogen",
        "atom_mass_subs_first_ion_en",
        "row",
        "mol_vol_mult_atom_mass",
        "voro_coord_divi_therm_cond",
        "voro_coord_subs_mp",
        "polzbl_mult_atom_rad",
        "elec_aff_mult_X",
        "GV",
        "nfunfill",
        "voro_coord_subs_therm_cond",
        "mp_divi_therm_cond",
        "elec_aff_add_X",
        "mol_vol_add_bp",
        "C-9",
        "C-8",
        "C-7",
        "C-6",
        "C-5",
        "C-4",
        "C-3",
        "C-2",
        "C-1",
        "C-0",
        "mp_subs_elec_aff",
        "hfus_add_elec_aff",
        "elec_aff_subs_first_ion_en",
        "therm_cond_subs_mol_vol",
        "X_subs_mol_vol",
        "first_ion_en_subs_hfus",
        "first_ion_en_add_voro_coord",
        "first_ion_en_divi_atom_mass",
        "atom_rad_subs_polzbl",
        "me1",
        "me3",
        "me2",
        "elec_aff_mult_atom_mass",
        "elec_aff_add_atom_mass",
        "therm_cond_subs_elec_aff",
        "atom_rad_divi_atom_mass",
        "atom_rad_divi_voro_coord",
        "max_oxid_s",
        "polzbl_mult_first_ion_en",
        "mp_divi_voro_coord",
        "mol_vol_divi_hfus",
        "mp_divi_atom_mass",
        "therm_cond_subs_mp",
        "npvalence",
        "mol_vol_subs_atom_rad",
        "atom_rad_divi_hfus",
        "mp",
        "hfus_add_atom_rad",
        "atom_mass_add_voro_coord",
        "atom_mass_divi_atom_rad",
        "hfus_divi_atom_rad",
        "polzbl_mult_X",
        "first_ion_en",
        "bp_add_X",
        "therm_cond_subs_atom_rad",
        "first_ion_en_subs_voro_coord",
        "first_ion_en_subs_polzbl",
        "hfus_subs_X",
        "first_ion_en_mult_mol_vol",
        "first_ion_en_mult_mp",
        "bp_mult_atom_mass",
        "bp_subs_mp",
        "polzbl_add_atom_rad",
        "therm_cond_subs_hfus",
        "mol_vol_add_mp",
        "first_ion_en_subs_elec_aff",
        "atom_mass_add_therm_cond",
        "atom_mass_divi_therm_cond",
        "first_ion_en_divi_mol_vol",
        "polzbl_divi_mp",
        "elec_aff_subs_therm_cond",
        "ndunfill",
        "op_eg",
        "atom_mass_subs_mp",
        "mol_vol_subs_voro_coord",
        "jv_enp",
        "polzbl_mult_atom_mass",
        "first_ion_en_add_mp",
        "first_ion_en_add_atom_mass",
        "mol_vol_mult_bp",
        "mol_vol_add_atom_mass",
        "nfvalence",
        "hfus_subs_voro_coord",
        "voro_coord_divi_mol_vol",
        "hfus_mult_first_ion_en",
        "mp_mult_atom_mass",
        "polzbl",
        "therm_cond_subs_first_ion_en",
        "mol_vol_subs_elec_aff",
        "therm_cond_divi_atom_rad",
        "first_ion_en_subs_atom_mass",
        "atom_rad_mult_X",
        "mp_subs_mol_vol",
        "hfus_divi_bp",
        "mol_vol_subs_therm_cond",
        "mol_vol_subs_first_ion_en",
        "oq_bg",
        "therm_cond_mult_X",
        "mol_vol_subs_X",
        "elec_aff_subs_X",
        "atom_rad",
        "bp_subs_elec_aff",
        "polzbl_divi_first_ion_en",
        "mp_mult_atom_rad",
        "polzbl_mult_mp",
        "first_ion_en_divi_bp",
        "atom_mass",
        "bp_subs_therm_cond",
        "bp_add_atom_mass",
        "polzbl_divi_hfus",
        "hfus_mult_atom_rad",
        "first_ion_en_divi_voro_coord",
        "mp_add_therm_cond",
        "hfus_mult_atom_mass",
        "hfus_divi_mol_vol",
        "hfus_divi_polzbl",
        "first_ion_en_divi_hfus",
        "elec_aff_subs_atom_mass",
        "hfus_mult_voro_coord",
        "polzbl_subs_X",
        "elec_aff_mult_therm_cond",
        "atom_rad_subs_atom_mass",
        "is_alkali",
        "voro_coord_subs_atom_mass",
        "mol_vol_mult_X",
        "hfus_subs_mp",
        "mol_vol_divi_atom_rad",
        "atom_mass_subs_polzbl",
        "atom_rad_divi_mol_vol",
        "elec_aff_add_bp",
        "C-13",
        "C-12",
        "C-11",
        "C-10",
        "C-17",
        "C-16",
        "C-15",
        "C-14",
        "hfus_divi_voro_coord",
        "polzbl_subs_atom_mass",
        "C-19",
        "C-18",
        "X_subs_atom_rad",
        "X_subs_elec_aff",
        "voro_coord",
        "mp_add_atom_mass",
        "elec_aff_add_mp",
        "is_noble_gas",
        "polzbl_add_bp",
        "hfus_add_polzbl",
        "X_subs_first_ion_en",
        "mp_subs_first_ion_en",
        "atom_rad_mult_voro_coord",
        "mol_vol_subs_mp",
        "atom_mass_divi_mp",
        "voro_coord_subs_polzbl",
        "bp_divi_first_ion_en",
        "polzbl_add_mp",
        "polzbl_add_therm_cond",
        "hfus_subs_atom_rad",
        "first_ion_en_divi_therm_cond",
        "X_subs_atom_mass",
        "mol_vol_subs_bp",
        "polzbl_mult_therm_cond",
        "bp_subs_voro_coord",
        "e1",
        "e3",
        "e2",
        "atom_rad_subs_X",
        "X_add_voro_coord",
        "mp_mult_voro_coord",
        "mp_subs_atom_mass",
        "mp_add_voro_coord",
        "therm_cond_divi_hfus",
        "bp_divi_atom_mass",
        "first_ion_en_mult_X",
        "hfus_mult_mol_vol",
        "voro_coord_divi_bp",
        "mol_vol_divi_voro_coord",
        "atom_mass_divi_voro_coord",
        "is_lanthanoid",
        "mol_vol_divi_polzbl",
        "atom_mass_subs_therm_cond",
        "atom_rad_divi_therm_cond",
        "atom_mass_divi_polzbl",
        "bp_add_atom_rad",
        "voro_coord_subs_hfus",
        "polzbl_subs_bp",
        "polzbl_divi_bp",
        "elec_aff_mult_mp",
        "ndvalence",
        "atom_mass_divi_mol_vol",
        "mp_divi_mol_vol",
        "therm_cond_subs_voro_coord",
        "atom_mass_subs_atom_rad",
        "polzbl_divi_voro_coord",
        "polzbl_subs_mp",
        "polzbl_subs_therm_cond",
        "KV",
        "min_oxid_s",
        "elec_aff_mult_atom_rad",
        "therm_cond_subs_polzbl",
        "voro_coord_subs_bp",
        "bp_add_voro_coord",
        "nsunfill",
        "mp_mult_X",
        "atom_mass_mult_atom_rad",
        "first_ion_en_mult_voro_coord",
        "elec_aff_subs_voro_coord",
        "bp_divi_mp",
        "atom_rad_subs_mol_vol",
        "bp_subs_hfus",
        "atom_rad_subs_first_ion_en",
        "hfus_divi_mp",
        "first_ion_en_subs_mp",
        "mp_add_atom_rad",
        "hfus_add_atom_mass",
        "bp_subs_mol_vol",
        "hfus_add_first_ion_en",
        "bp_subs_atom_rad",
        "bp_divi_atom_rad",
        "C-26",
        "atom_mass_subs_hfus",
        "mp_subs_therm_cond",
        "polzbl_divi_atom_rad",
        "polzbl_add_mol_vol",
        "first_ion_en_add_bp",
        "hfus_subs_therm_cond",
        "mp_divi_hfus",
        "X_subs_bp",
        "bp_mult_mp",
        "atom_mass_mult_therm_cond",
        "mol_vol_divi_therm_cond",
        "voro_coord_subs_X",
        "first_ion_en_subs_mol_vol",
        "polzbl_add_elec_aff",
        "therm_cond_subs_atom_mass",
        "hfus_subs_bp",
        "atom_mass_subs_mol_vol",
        "X",
        "is_actinoid",
        "hfus_subs_first_ion_en",
        "first_ion_en_divi_mp",
        "atom_rad_add_therm_cond",
        "atom_rad_divi_polzbl",
        "hfus_divi_atom_mass",
        "mp_mult_therm_cond",
        "first_ion_en_add_X",
        "polzbl_add_voro_coord",
        "mol_vol_subs_polzbl",
        "therm_cond_divi_first_ion_en",
        "bp_mult_voro_coord",
        "atom_mass_add_atom_rad",
        "hfus_mult_mp",
        "voro_coord_divi_polzbl",
        "elec_aff_add_therm_cond",
        "C-28",
        "C-29",
        "hfus_add_voro_coord",
        "C-27",
        "C-24",
        "C-25",
        "C-22",
        "C-23",
        "C-20",
        "C-21",
        "therm_cond_divi_polzbl",
        "mol_vol_mult_mp",
        "mp_subs_X",
        "bp_subs_atom_mass",
        "first_ion_en_add_therm_cond",
        "voro_coord_divi_atom_mass",
        "atom_mass_subs_voro_coord",
        "hfus_add_therm_cond",
        "atom_rad_divi_mp",
        "mp_subs_voro_coord",
        "hfus_mult_polzbl",
        "bp_divi_hfus",
        "therm_cond_divi_voro_coord",
        "first_ion_en_subs_atom_rad",
        "atom_rad_subs_bp",
        "atom_rad_add_X",
        "mol_vol_add_voro_coord",
        "avg_ion_rad",
        "bp_divi_mol_vol",
        "atom_rad_subs_mp",
        "atom_mass_mult_voro_coord",
        "therm_cond_add_X",
        "atom_rad_subs_therm_cond",
        "polzbl_add_first_ion_en",
        "polzbl_mult_bp",
        "first_ion_en_mult_elec_aff",
        "elec_aff_subs_mol_vol",
        "nsvalence",
        "mol_vol_subs_hfus",
        "atom_mass_divi_bp",
        "bp_subs_polzbl",
        "bp_add_mp",
        "polzbl_divi_mol_vol",
        "voro_coord_subs_elec_aff",
        "elec_aff_add_atom_rad",
        "mol_vol_add_atom_rad",
        "hfus_mult_X",
        "mp_subs_hfus",
        "voro_coord_divi_first_ion_en",
        "atom_rad_divi_first_ion_en",
        "elec_aff_mult_mol_vol",
        "is_metalloid",
        "hfus_mult_therm_cond",
        "hfus_divi_therm_cond",
        "therm_cond_divi_mol_vol",
        "elec_aff",
        "mp_divi_atom_rad",
        "elec_aff_subs_polzbl",
        "polzbl_divi_atom_mass",
        "atom_rad_subs_elec_aff",
        "bp_divi_therm_cond",
        "atom_mass_mult_X",
        "mp_divi_polzbl",
        "elec_aff_subs_atom_rad",
        "voro_coord_divi_atom_rad",
        "hfus_subs_mol_vol",
        "mol_vol_add_therm_cond",
        "bp_mult_X",
        "therm_cond_divi_mp",
        "mp_subs_polzbl",
        "atom_rad_divi_bp",
        "atom_rad_subs_hfus",
        "polzbl_subs_elec_aff",
        "therm_cond_divi_atom_mass",
        "bp_divi_voro_coord",
        "bp_add_therm_cond",
        "hfus_divi_first_ion_en",
        "X_mult_voro_coord",
        "bp_subs_X",
        "polzbl_subs_voro_coord",
        "coulmn",
        "first_ion_en_divi_polzbl",
        "first_ion_en_mult_atom_mass",
        "mol_vol_mult_therm_cond",
        "bp_mult_therm_cond",
        "mol_vol",
        "mol_vol_mult_voro_coord",
        "atom_mass_subs_elec_aff",
        "atom_mass_divi_first_ion_en",
        "hfus_subs_elec_aff",
        "first_ion_en_mult_bp",
        "polzbl_mult_mol_vol",
        "polzbl_add_atom_mass",
        "elec_aff_mult_bp",
        "voro_coord_subs_atom_rad",
        "mp_add_X",
        "elec_aff_subs_bp",
        "polzbl_divi_therm_cond",
        "polzbl_mult_voro_coord",
        "bp",
        "therm_cond_mult_voro_coord",
        "elec_aff_subs_mp",
        "C-31",
        "C-30",
        "C-33",
        "C-32",
        "C-35",
        "C-34",
        "first_ion_en_subs_X",
        "is_transition_metal",
        "mp_subs_bp",
        "hfus_add_mol_vol",
        "block",
        "atom_rad_subs_voro_coord",
        "X_subs_therm_cond",
        "polzbl_subs_first_ion_en",
        "hfus_subs_atom_mass",
        "mol_vol_divi_bp",
        "first_ion_en_subs_therm_cond",
        "elec_aff_add_voro_coord",
        "voro_coord_divi_hfus",
        "therm_cond",
        "bp_subs_first_ion_en",
        "X_subs_voro_coord",
        "therm_cond_divi_bp",
        "mp_divi_bp",
        "first_ion_en_divi_atom_rad",
        "hfus_subs_polzbl",
        "mol_vol_divi_mp",
        "atom_rad_add_voro_coord",
        "mol_vol_mult_atom_rad",
        "first_ion_en_mult_atom_rad",
        "hfus_mult_bp",
        "voro_coord_subs_first_ion_en",
        "Z",
        "polzbl_subs_hfus",
        "polzbl_add_X",
        "is_alkaline",
        "npunfill",
        "first_ion_en_subs_bp",
        "voro_coord_divi_mp",
        "atom_mass_divi_hfus",
        "oq_enp",
        "elec_aff_subs_hfus",
        "atom_mass_subs_bp",
        "first_ion_en_add_elec_aff",
        "first_ion_en_add_mol_vol",
        "hfus_mult_elec_aff",
        "polzbl_mult_elec_aff",
        "hfus_add_X",
        "hfus_add_mp",
        "therm_cond_subs_bp",
        "bp_divi_polzbl",
        "X_subs_hfus",
        "atom_rad_mult_therm_cond",
        "therm_cond_add_voro_coord",
        "mop_eg",
        "X_subs_polzbl",
        "mol_vol_divi_first_ion_en",
        "mp_divi_first_ion_en",
        "voro_coord_subs_mol_vol",
        "elec_aff_add_mol_vol",
        "mol_vol_add_X",
        "atom_mass_add_X",
        "polzbl_subs_atom_rad",
        "mol_vol_divi_atom_mass",
        "polzbl_subs_mol_vol",
        "mp_subs_atom_rad",
        "X_subs_mp",
        "atom_mass_subs_X",
        "first_ion_en_add_atom_rad",
        "therm_cond_subs_X",
        "hfus",
        "first_ion_en_mult_therm_cond",
        "cell_0",
        "cell_1",
        "cell_2",
        "cell_3",
        "mean_chg_0",
        "mean_chg_1",
        "mean_chg_2",
        "mean_chg_3",
        "mean_chg_4",
        "mean_chg_5",
        "mean_chg_6",
        "mean_chg_7",
        "mean_chg_8",
        "mean_chg_9",
        "mean_chg_10",
        "mean_chg_11",
        "mean_chg_12",
        "mean_chg_13",
        "mean_chg_14",
        "mean_chg_15",
        "mean_chg_16",
        "mean_chg_17",
        "mean_chg_18",
        "mean_chg_19",
        "mean_chg_20",
        "mean_chg_21",
        "mean_chg_22",
        "mean_chg_23",
        "mean_chg_24",
        "mean_chg_25",
        "mean_chg_26",
        "mean_chg_27",
        "mean_chg_28",
        "mean_chg_29",
        "mean_chg_30",
        "mean_chg_31",
        "mean_chg_32",
        "mean_chg_33",
        "mean_chg_34",
        "mean_chg_35",
        "mean_chg_36",
        "mean_chg_37",
        "mean_chg_38",
        "mean_chg_39",
        "mean_chg_40",
        "mean_chg_41",
        "mean_chg_42",
        "mean_chg_43",
        "mean_chg_44",
        "mean_chg_45",
        "mean_chg_46",
        "mean_chg_47",
        "mean_chg_48",
        "mean_chg_49",
        "mean_chg_50",
        "mean_chg_51",
        "mean_chg_52",
        "mean_chg_53",
        "mean_chg_54",
        "mean_chg_55",
        "mean_chg_56",
        "mean_chg_57",
        "mean_chg_58",
        "mean_chg_59",
        "mean_chg_60",
        "mean_chg_61",
        "mean_chg_62",
        "mean_chg_63",
        "mean_chg_64",
        "mean_chg_65",
        "mean_chg_66",
        "mean_chg_67",
        "mean_chg_68",
        "mean_chg_69",
        "mean_chg_70",
        "mean_chg_71",
        "mean_chg_72",
        "mean_chg_73",
        "mean_chg_74",
        "mean_chg_75",
        "mean_chg_76",
        "mean_chg_77",
        "mean_chg_78",
        "mean_chg_79",
        "mean_chg_80",
        "mean_chg_81",
        "mean_chg_82",
        "mean_chg_83",
        "mean_chg_84",
        "mean_chg_85",
        "mean_chg_86",
        "mean_chg_87",
        "mean_chg_88",
        "mean_chg_89",
        "mean_chg_90",
        "mean_chg_91",
        "mean_chg_92",
        "mean_chg_93",
        "mean_chg_94",
        "mean_chg_95",
        "mean_chg_96",
        "mean_chg_97",
        "mean_chg_98",
        "mean_chg_99",
        "mean_chg_100",
        "mean_chg_101",
        "mean_chg_102",
        "mean_chg_103",
        "mean_chg_104",
        "mean_chg_105",
        "mean_chg_106",
        "mean_chg_107",
        "mean_chg_108",
        "mean_chg_109",
        "mean_chg_110",
        "mean_chg_111",
        "mean_chg_112",
        "mean_chg_113",
        "mean_chg_114",
        "mean_chg_115",
        "mean_chg_116",
        "mean_chg_117",
        "mean_chg_118",
        "mean_chg_119",
        "mean_chg_120",
        "mean_chg_121",
        "mean_chg_122",
        "mean_chg_123",
        "mean_chg_124",
        "mean_chg_125",
        "mean_chg_126",
        "mean_chg_127",
        "mean_chg_128",
        "mean_chg_129",
        "mean_chg_130",
        "mean_chg_131",
        "mean_chg_132",
        "mean_chg_133",
        "mean_chg_134",
        "mean_chg_135",
        "mean_chg_136",
        "mean_chg_137",
        "mean_chg_138",
        "mean_chg_139",
        "mean_chg_140",
        "mean_chg_141",
        "mean_chg_142",
        "mean_chg_143",
        "mean_chg_144",
        "mean_chg_145",
        "mean_chg_146",
        "mean_chg_147",
        "mean_chg_148",
        "mean_chg_149",
        "mean_chg_150",
        "mean_chg_151",
        "mean_chg_152",
        "mean_chg_153",
        "mean_chg_154",
        "mean_chg_155",
        "mean_chg_156",
        "mean_chg_157",
        "mean_chg_158",
        "mean_chg_159",
        "mean_chg_160",
        "mean_chg_161",
        "mean_chg_162",
        "mean_chg_163",
        "mean_chg_164",
        "mean_chg_165",
        "mean_chg_166",
        "mean_chg_167",
        "mean_chg_168",
        "mean_chg_169",
        "mean_chg_170",
        "mean_chg_171",
        "mean_chg_172",
        "mean_chg_173",
        "mean_chg_174",
        "mean_chg_175",
        "mean_chg_176",
        "mean_chg_177",
        "mean_chg_178",
        "mean_chg_179",
        "mean_chg_180",
        "mean_chg_181",
        "mean_chg_182",
        "mean_chg_183",
        "mean_chg_184",
        "mean_chg_185",
        "mean_chg_186",
        "mean_chg_187",
        "mean_chg_188",
        "mean_chg_189",
        "mean_chg_190",
        "mean_chg_191",
        "mean_chg_192",
        "mean_chg_193",
        "mean_chg_194",
        "mean_chg_195",
        "mean_chg_196",
        "mean_chg_197",
        "mean_chg_198",
        "mean_chg_199",
        "mean_chg_200",
        "mean_chg_201",
        "mean_chg_202",
        "mean_chg_203",
        "mean_chg_204",
        "mean_chg_205",
        "mean_chg_206",
        "mean_chg_207",
        "mean_chg_208",
        "mean_chg_209",
        "mean_chg_210",
        "mean_chg_211",
        "mean_chg_212",
        "mean_chg_213",
        "mean_chg_214",
        "mean_chg_215",
        "mean_chg_216",
        "mean_chg_217",
        "mean_chg_218",
        "mean_chg_219",
        "mean_chg_220",
        "mean_chg_221",
        "mean_chg_222",
        "mean_chg_223",
        "mean_chg_224",
        "mean_chg_225",
        "mean_chg_226",
        "mean_chg_227",
        "mean_chg_228",
        "mean_chg_229",
        "mean_chg_230",
        "mean_chg_231",
        "mean_chg_232",
        "mean_chg_233",
        "mean_chg_234",
        "mean_chg_235",
        "mean_chg_236",
        "mean_chg_237",
        "mean_chg_238",
        "mean_chg_239",
        "mean_chg_240",
        "mean_chg_241",
        "mean_chg_242",
        "mean_chg_243",
        "mean_chg_244",
        "mean_chg_245",
        "mean_chg_246",
        "mean_chg_247",
        "mean_chg_248",
        "mean_chg_249",
        "mean_chg_250",
        "mean_chg_251",
        "mean_chg_252",
        "mean_chg_253",
        "mean_chg_254",
        "mean_chg_255",
        "mean_chg_256",
        "mean_chg_257",
        "mean_chg_258",
        "mean_chg_259",
        "mean_chg_260",
        "mean_chg_261",
        "mean_chg_262",
        "mean_chg_263",
        "mean_chg_264",
        "mean_chg_265",
        "mean_chg_266",
        "mean_chg_267",
        "mean_chg_268",
        "mean_chg_269",
        "mean_chg_270",
        "mean_chg_271",
        "mean_chg_272",
        "mean_chg_273",
        "mean_chg_274",
        "mean_chg_275",
        "mean_chg_276",
        "mean_chg_277",
        "mean_chg_278",
        "mean_chg_279",
        "mean_chg_280",
        "mean_chg_281",
        "mean_chg_282",
        "mean_chg_283",
        "mean_chg_284",
        "mean_chg_285",
        "mean_chg_286",
        "mean_chg_287",
        "mean_chg_288",
        "mean_chg_289",
        "mean_chg_290",
        "mean_chg_291",
        "mean_chg_292",
        "mean_chg_293",
        "mean_chg_294",
        "mean_chg_295",
        "mean_chg_296",
        "mean_chg_297",
        "mean_chg_298",
        "mean_chg_299",
        "mean_chg_300",
        "mean_chg_301",
        "mean_chg_302",
        "mean_chg_303",
        "mean_chg_304",
        "mean_chg_305",
        "mean_chg_306",
        "mean_chg_307",
        "mean_chg_308",
        "mean_chg_309",
        "mean_chg_310",
        "mean_chg_311",
        "mean_chg_312",
        "mean_chg_313",
        "mean_chg_314",
        "mean_chg_315",
        "mean_chg_316",
        "mean_chg_317",
        "mean_chg_318",
        "mean_chg_319",
        "mean_chg_320",
        "mean_chg_321",
        "mean_chg_322",
        "mean_chg_323",
        "mean_chg_324",
        "mean_chg_325",
        "mean_chg_326",
        "mean_chg_327",
        "mean_chg_328",
        "mean_chg_329",
        "mean_chg_330",
        "mean_chg_331",
        "mean_chg_332",
        "mean_chg_333",
        "mean_chg_334",
        "mean_chg_335",
        "mean_chg_336",
        "mean_chg_337",
        "mean_chg_338",
        "mean_chg_339",
        "mean_chg_340",
        "mean_chg_341",
        "mean_chg_342",
        "mean_chg_343",
        "mean_chg_344",
        "mean_chg_345",
        "mean_chg_346",
        "mean_chg_347",
        "mean_chg_348",
        "mean_chg_349",
        "mean_chg_350",
        "mean_chg_351",
        "mean_chg_352",
        "mean_chg_353",
        "mean_chg_354",
        "mean_chg_355",
        "mean_chg_356",
        "mean_chg_357",
        "mean_chg_358",
        "mean_chg_359",
        "mean_chg_360",
        "mean_chg_361",
        "mean_chg_362",
        "mean_chg_363",
        "mean_chg_364",
        "mean_chg_365",
        "mean_chg_366",
        "mean_chg_367",
        "mean_chg_368",
        "mean_chg_369",
        "mean_chg_370",
        "mean_chg_371",
        "mean_chg_372",
        "mean_chg_373",
        "mean_chg_374",
        "mean_chg_375",
        "mean_chg_376",
        "mean_chg_377",
        "rdf_0",
        "rdf_1",
        "rdf_2",
        "rdf_3",
        "rdf_4",
        "rdf_5",
        "rdf_6",
        "rdf_7",
        "rdf_8",
        "rdf_9",
        "rdf_10",
        "rdf_11",
        "rdf_12",
        "rdf_13",
        "rdf_14",
        "rdf_15",
        "rdf_16",
        "rdf_17",
        "rdf_18",
        "rdf_19",
        "rdf_20",
        "rdf_21",
        "rdf_22",
        "rdf_23",
        "rdf_24",
        "rdf_25",
        "rdf_26",
        "rdf_27",
        "rdf_28",
        "rdf_29",
        "rdf_30",
        "rdf_31",
        "rdf_32",
        "rdf_33",
        "rdf_34",
        "rdf_35",
        "rdf_36",
        "rdf_37",
        "rdf_38",
        "rdf_39",
        "rdf_40",
        "rdf_41",
        "rdf_42",
        "rdf_43",
        "rdf_44",
        "rdf_45",
        "rdf_46",
        "rdf_47",
        "rdf_48",
        "rdf_49",
        "rdf_50",
        "rdf_51",
        "rdf_52",
        "rdf_53",
        "rdf_54",
        "rdf_55",
        "rdf_56",
        "rdf_57",
        "rdf_58",
        "rdf_59",
        "rdf_60",
        "rdf_61",
        "rdf_62",
        "rdf_63",
        "rdf_64",
        "rdf_65",
        "rdf_66",
        "rdf_67",
        "rdf_68",
        "rdf_69",
        "rdf_70",
        "rdf_71",
        "rdf_72",
        "rdf_73",
        "rdf_74",
        "rdf_75",
        "rdf_76",
        "rdf_77",
        "rdf_78",
        "rdf_79",
        "rdf_80",
        "rdf_81",
        "rdf_82",
        "rdf_83",
        "rdf_84",
        "rdf_85",
        "rdf_86",
        "rdf_87",
        "rdf_88",
        "rdf_89",
        "rdf_90",
        "rdf_91",
        "rdf_92",
        "rdf_93",
        "rdf_94",
        "rdf_95",
        "rdf_96",
        "rdf_97",
        "rdf_98",
        "rdf_99",
        "adfa_0",
        "adfa_1",
        "adfa_2",
        "adfa_3",
        "adfa_4",
        "adfa_5",
        "adfa_6",
        "adfa_7",
        "adfa_8",
        "adfa_9",
        "adfa_10",
        "adfa_11",
        "adfa_12",
        "adfa_13",
        "adfa_14",
        "adfa_15",
        "adfa_16",
        "adfa_17",
        "adfa_18",
        "adfa_19",
        "adfa_20",
        "adfa_21",
        "adfa_22",
        "adfa_23",
        "adfa_24",
        "adfa_25",
        "adfa_26",
        "adfa_27",
        "adfa_28",
        "adfa_29",
        "adfa_30",
        "adfa_31",
        "adfa_32",
        "adfa_33",
        "adfa_34",
        "adfa_35",
        "adfa_36",
        "adfa_37",
        "adfa_38",
        "adfa_39",
        "adfa_40",
        "adfa_41",
        "adfa_42",
        "adfa_43",
        "adfa_44",
        "adfa_45",
        "adfa_46",
        "adfa_47",
        "adfa_48",
        "adfa_49",
        "adfa_50",
        "adfa_51",
        "adfa_52",
        "adfa_53",
        "adfa_54",
        "adfa_55",
        "adfa_56",
        "adfa_57",
        "adfa_58",
        "adfa_59",
        "adfa_60",
        "adfa_61",
        "adfa_62",
        "adfa_63",
        "adfa_64",
        "adfa_65",
        "adfa_66",
        "adfa_67",
        "adfa_68",
        "adfa_69",
        "adfa_70",
        "adfa_71",
        "adfa_72",
        "adfa_73",
        "adfa_74",
        "adfa_75",
        "adfa_76",
        "adfa_77",
        "adfa_78",
        "adfa_79",
        "adfa_80",
        "adfa_81",
        "adfa_82",
        "adfa_83",
        "adfa_84",
        "adfa_85",
        "adfa_86",
        "adfa_87",
        "adfa_88",
        "adfa_89",
        "adfa_90",
        "adfa_91",
        "adfa_92",
        "adfa_93",
        "adfa_94",
        "adfa_95",
        "adfa_96",
        "adfa_97",
        "adfa_98",
        "adfa_99",
        "adfa_100",
        "adfa_101",
        "adfa_102",
        "adfa_103",
        "adfa_104",
        "adfa_105",
        "adfa_106",
        "adfa_107",
        "adfa_108",
        "adfa_109",
        "adfa_110",
        "adfa_111",
        "adfa_112",
        "adfa_113",
        "adfa_114",
        "adfa_115",
        "adfa_116",
        "adfa_117",
        "adfa_118",
        "adfa_119",
        "adfa_120",
        "adfa_121",
        "adfa_122",
        "adfa_123",
        "adfa_124",
        "adfa_125",
        "adfa_126",
        "adfa_127",
        "adfa_128",
        "adfa_129",
        "adfa_130",
        "adfa_131",
        "adfa_132",
        "adfa_133",
        "adfa_134",
        "adfa_135",
        "adfa_136",
        "adfa_137",
        "adfa_138",
        "adfa_139",
        "adfa_140",
        "adfa_141",
        "adfa_142",
        "adfa_143",
        "adfa_144",
        "adfa_145",
        "adfa_146",
        "adfa_147",
        "adfa_148",
        "adfa_149",
        "adfa_150",
        "adfa_151",
        "adfa_152",
        "adfa_153",
        "adfa_154",
        "adfa_155",
        "adfa_156",
        "adfa_157",
        "adfa_158",
        "adfa_159",
        "adfa_160",
        "adfa_161",
        "adfa_162",
        "adfa_163",
        "adfa_164",
        "adfa_165",
        "adfa_166",
        "adfa_167",
        "adfa_168",
        "adfa_169",
        "adfa_170",
        "adfa_171",
        "adfa_172",
        "adfa_173",
        "adfa_174",
        "adfa_175",
        "adfa_176",
        "adfa_177",
        "adfa_178",
        "adfb_0",
        "adfb_1",
        "adfb_2",
        "adfb_3",
        "adfb_4",
        "adfb_5",
        "adfb_6",
        "adfb_7",
        "adfb_8",
        "adfb_9",
        "adfb_10",
        "adfb_11",
        "adfb_12",
        "adfb_13",
        "adfb_14",
        "adfb_15",
        "adfb_16",
        "adfb_17",
        "adfb_18",
        "adfb_19",
        "adfb_20",
        "adfb_21",
        "adfb_22",
        "adfb_23",
        "adfb_24",
        "adfb_25",
        "adfb_26",
        "adfb_27",
        "adfb_28",
        "adfb_29",
        "adfb_30",
        "adfb_31",
        "adfb_32",
        "adfb_33",
        "adfb_34",
        "adfb_35",
        "adfb_36",
        "adfb_37",
        "adfb_38",
        "adfb_39",
        "adfb_40",
        "adfb_41",
        "adfb_42",
        "adfb_43",
        "adfb_44",
        "adfb_45",
        "adfb_46",
        "adfb_47",
        "adfb_48",
        "adfb_49",
        "adfb_50",
        "adfb_51",
        "adfb_52",
        "adfb_53",
        "adfb_54",
        "adfb_55",
        "adfb_56",
        "adfb_57",
        "adfb_58",
        "adfb_59",
        "adfb_60",
        "adfb_61",
        "adfb_62",
        "adfb_63",
        "adfb_64",
        "adfb_65",
        "adfb_66",
        "adfb_67",
        "adfb_68",
        "adfb_69",
        "adfb_70",
        "adfb_71",
        "adfb_72",
        "adfb_73",
        "adfb_74",
        "adfb_75",
        "adfb_76",
        "adfb_77",
        "adfb_78",
        "adfb_79",
        "adfb_80",
        "adfb_81",
        "adfb_82",
        "adfb_83",
        "adfb_84",
        "adfb_85",
        "adfb_86",
        "adfb_87",
        "adfb_88",
        "adfb_89",
        "adfb_90",
        "adfb_91",
        "adfb_92",
        "adfb_93",
        "adfb_94",
        "adfb_95",
        "adfb_96",
        "adfb_97",
        "adfb_98",
        "adfb_99",
        "adfb_100",
        "adfb_101",
        "adfb_102",
        "adfb_103",
        "adfb_104",
        "adfb_105",
        "adfb_106",
        "adfb_107",
        "adfb_108",
        "adfb_109",
        "adfb_110",
        "adfb_111",
        "adfb_112",
        "adfb_113",
        "adfb_114",
        "adfb_115",
        "adfb_116",
        "adfb_117",
        "adfb_118",
        "adfb_119",
        "adfb_120",
        "adfb_121",
        "adfb_122",
        "adfb_123",
        "adfb_124",
        "adfb_125",
        "adfb_126",
        "adfb_127",
        "adfb_128",
        "adfb_129",
        "adfb_130",
        "adfb_131",
        "adfb_132",
        "adfb_133",
        "adfb_134",
        "adfb_135",
        "adfb_136",
        "adfb_137",
        "adfb_138",
        "adfb_139",
        "adfb_140",
        "adfb_141",
        "adfb_142",
        "adfb_143",
        "adfb_144",
        "adfb_145",
        "adfb_146",
        "adfb_147",
        "adfb_148",
        "adfb_149",
        "adfb_150",
        "adfb_151",
        "adfb_152",
        "adfb_153",
        "adfb_154",
        "adfb_155",
        "adfb_156",
        "adfb_157",
        "adfb_158",
        "adfb_159",
        "adfb_160",
        "adfb_161",
        "adfb_162",
        "adfb_163",
        "adfb_164",
        "adfb_165",
        "adfb_166",
        "adfb_167",
        "adfb_168",
        "adfb_169",
        "adfb_170",
        "adfb_171",
        "adfb_172",
        "adfb_173",
        "adfb_174",
        "adfb_175",
        "adfb_176",
        "adfb_177",
        "adfb_178",
        "ddf_0",
        "ddf_1",
        "ddf_2",
        "ddf_3",
        "ddf_4",
        "ddf_5",
        "ddf_6",
        "ddf_7",
        "ddf_8",
        "ddf_9",
        "ddf_10",
        "ddf_11",
        "ddf_12",
        "ddf_13",
        "ddf_14",
        "ddf_15",
        "ddf_16",
        "ddf_17",
        "ddf_18",
        "ddf_19",
        "ddf_20",
        "ddf_21",
        "ddf_22",
        "ddf_23",
        "ddf_24",
        "ddf_25",
        "ddf_26",
        "ddf_27",
        "ddf_28",
        "ddf_29",
        "ddf_30",
        "ddf_31",
        "ddf_32",
        "ddf_33",
        "ddf_34",
        "ddf_35",
        "ddf_36",
        "ddf_37",
        "ddf_38",
        "ddf_39",
        "ddf_40",
        "ddf_41",
        "ddf_42",
        "ddf_43",
        "ddf_44",
        "ddf_45",
        "ddf_46",
        "ddf_47",
        "ddf_48",
        "ddf_49",
        "ddf_50",
        "ddf_51",
        "ddf_52",
        "ddf_53",
        "ddf_54",
        "ddf_55",
        "ddf_56",
        "ddf_57",
        "ddf_58",
        "ddf_59",
        "ddf_60",
        "ddf_61",
        "ddf_62",
        "ddf_63",
        "ddf_64",
        "ddf_65",
        "ddf_66",
        "ddf_67",
        "ddf_68",
        "ddf_69",
        "ddf_70",
        "ddf_71",
        "ddf_72",
        "ddf_73",
        "ddf_74",
        "ddf_75",
        "ddf_76",
        "ddf_77",
        "ddf_78",
        "ddf_79",
        "ddf_80",
        "ddf_81",
        "ddf_82",
        "ddf_83",
        "ddf_84",
        "ddf_85",
        "ddf_86",
        "ddf_87",
        "ddf_88",
        "ddf_89",
        "ddf_90",
        "ddf_91",
        "ddf_92",
        "ddf_93",
        "ddf_94",
        "ddf_95",
        "ddf_96",
        "ddf_97",
        "ddf_98",
        "ddf_99",
        "ddf_100",
        "ddf_101",
        "ddf_102",
        "ddf_103",
        "ddf_104",
        "ddf_105",
        "ddf_106",
        "ddf_107",
        "ddf_108",
        "ddf_109",
        "ddf_110",
        "ddf_111",
        "ddf_112",
        "ddf_113",
        "ddf_114",
        "ddf_115",
        "ddf_116",
        "ddf_117",
        "ddf_118",
        "ddf_119",
        "ddf_120",
        "ddf_121",
        "ddf_122",
        "ddf_123",
        "ddf_124",
        "ddf_125",
        "ddf_126",
        "ddf_127",
        "ddf_128",
        "ddf_129",
        "ddf_130",
        "ddf_131",
        "ddf_132",
        "ddf_133",
        "ddf_134",
        "ddf_135",
        "ddf_136",
        "ddf_137",
        "ddf_138",
        "ddf_139",
        "ddf_140",
        "ddf_141",
        "ddf_142",
        "ddf_143",
        "ddf_144",
        "ddf_145",
        "ddf_146",
        "ddf_147",
        "ddf_148",
        "ddf_149",
        "ddf_150",
        "ddf_151",
        "ddf_152",
        "ddf_153",
        "ddf_154",
        "ddf_155",
        "ddf_156",
        "ddf_157",
        "ddf_158",
        "ddf_159",
        "ddf_160",
        "ddf_161",
        "ddf_162",
        "ddf_163",
        "ddf_164",
        "ddf_165",
        "ddf_166",
        "ddf_167",
        "ddf_168",
        "ddf_169",
        "ddf_170",
        "ddf_171",
        "ddf_172",
        "ddf_173",
        "ddf_174",
        "ddf_175",
        "ddf_176",
        "ddf_177",
        "ddf_178",
        "nn_0",
        "nn_1",
        "nn_2",
        "nn_3",
        "nn_4",
        "nn_5",
        "nn_6",
        "nn_7",
        "nn_8",
        "nn_9",
        "nn_10",
        "nn_11",
        "nn_12",
        "nn_13",
        "nn_14",
        "nn_15",
        "nn_16",
        "nn_17",
        "nn_18",
        "nn_19",
        "nn_20",
        "nn_21",
        "nn_22",
        "nn_23",
        "nn_24",
        "nn_25",
        "nn_26",
        "nn_27",
        "nn_28",
        "nn_29",
        "nn_30",
        "nn_31",
        "nn_32",
        "nn_33",
        "nn_34",
        "nn_35",
        "nn_36",
        "nn_37",
        "nn_38",
        "nn_39",
        "nn_40",
        "nn_41",
        "nn_42",
        "nn_43",
        "nn_44",
        "nn_45",
        "nn_46",
        "nn_47",
        "nn_48",
        "nn_49",
        "nn_50",
        "nn_51",
        "nn_52",
        "nn_53",
        "nn_54",
        "nn_55",
        "nn_56",
        "nn_57",
        "nn_58",
        "nn_59",
        "nn_60",
        "nn_61",
        "nn_62",
        "nn_63",
        "nn_64",
        "nn_65",
        "nn_66",
        "nn_67",
        "nn_68",
        "nn_69",
        "nn_70",
        "nn_71",
        "nn_72",
        "nn_73",
        "nn_74",
        "nn_75",
        "nn_76",
        "nn_77",
        "nn_78",
        "nn_79",
        "nn_80",
        "nn_81",
        "nn_82",
        "nn_83",
        "nn_84",
        "nn_85",
        "nn_86",
        "nn_87",
        "nn_88",
        "nn_89",
        "nn_90",
        "nn_91",
        "nn_92",
        "nn_93",
        "nn_94",
        "nn_95",
        "nn_96",
        "nn_97",
        "nn_98",
        "nn_99",
    ]
    # for i,j,k,l in zip(names,cfid_names, [round(i,2) for i in values], [round(i,2) for i in cfid_values]):
    #   if k!=l:
    #      print ('kl',k,l)
    assert (names, [round(i, 2) for i in values]) == (
        cfid_names,
        [round(i, 2) for i in cfid_values],
    )


# test_desc()
