# Copyright 2021 Zilliz. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from towhee.types.image import Image
from towhee.types.audio_frame import AudioFrame
from towhee.types.arg import arg, to_image_color

__all__ = [
    'Image',
    'AudioFrame',
    'arg',
    'to_image_color',
]

equivalents = {
    'towhee.types.image.Image': 'towhee.types.Image',
    'towhee.types.audio_frame.AudioFrame': 'towhee.types.AudioFrame',
    'towhee.types.arg.arg': 'towhee.types.arg',
    'towhee.types.arg.to_image_color': 'towhee.types.to_image_color',
}
