"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrateTask = exports.MigrateTaskProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "MigrateTaskProperty", { enumerable: true, get: function () { return rds_generated_1.RosMigrateTask; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::MigrateTask`
 */
class MigrateTask extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::MigrateTask`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMigrateTask = new rds_generated_1.RosMigrateTask(this, id, {
            isOnlineDb: props.isOnlineDb,
            dbInstanceId: props.dbInstanceId,
            ossObjectPositions: props.ossObjectPositions,
            checkDbMode: props.checkDbMode,
            backupMode: props.backupMode,
            dbName: props.dbName,
            ossUrls: props.ossUrls,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMigrateTask;
        this.attrDbName = rosMigrateTask.attrDbName;
        this.attrMigrateTaskId = rosMigrateTask.attrMigrateTaskId;
    }
}
exports.MigrateTask = MigrateTask;
//# sourceMappingURL=data:application/json;base64,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