""" Property definitions """
from __future__ import annotations

from dataclasses import dataclass

from .const import (
    TYPE_CN_STRING,
    TYPE_CN_UINT32,
    UNIT_NODE,
    UNIT_NODECONFIGURATION,
    UNIT_TEMPHUMCONTROL,
)


@dataclass
class Property:
    """Dataclass for a Property"""

    unit: int
    subunit: int
    property_id: int
    property_type: int


PROPERTY_SERIAL_NUMBER = Property(UNIT_NODE, 0x01, 0x04, TYPE_CN_STRING)
PROPERTY_FIRMWARE_VERSION = Property(UNIT_NODE, 0x01, 0x06, TYPE_CN_UINT32)
PROPERTY_MODEL = Property(UNIT_NODE, 0x01, 0x08, TYPE_CN_STRING)
PROPERTY_ARTICLE = Property(UNIT_NODE, 0x01, 0x0B, TYPE_CN_STRING)
PROPERTY_COUNTRY = Property(UNIT_NODE, 0x01, 0x0D, TYPE_CN_STRING)

PROPERTY_MAINTAINER_PASSWORD = Property(UNIT_NODECONFIGURATION, 0x01, 0x03, TYPE_CN_STRING)

PROPERTY_SENSOR_VENTILATION_TEMP_PASSIVE = Property(UNIT_TEMPHUMCONTROL, 0x01, 0x04, TYPE_CN_UINT32)
PROPERTY_SENSOR_VENTILATION_HUMIDITY_COMFORT = Property(UNIT_TEMPHUMCONTROL, 0x01, 0x06, TYPE_CN_UINT32)
PROPERTY_SENSOR_VENTILATION_HUMIDITY_PROTECTION = Property(UNIT_TEMPHUMCONTROL, 0x01, 0x07, TYPE_CN_UINT32)
