# Generated by Django 3.1.3 on 2020-11-09 19:33

import uuid

from django.conf import settings
from django.db import migrations, models

try:
    from django.db.models import JSONField
except ImportError:
    if "sqlite" in settings.DATABASES["default"]["ENGINE"]:
        from saml2_pro_auth.json_field import JSONField
    else:
        from django.contrib.postgres.fields import JSONField


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="SamlProvider",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="A descriptive name for the provider configuration.",
                        max_length=50,
                        verbose_name="Name",
                    ),
                ),
                (
                    "idp_issuer",
                    models.TextField(
                        help_text="The Issuer or Entity ID from your Identity Provider.",
                        max_length=1024,
                        verbose_name="IdP Issuer (Entity ID)",
                    ),
                ),
                (
                    "idp_x509",
                    models.TextField(
                        help_text="A PEM encoded public certificate provided by your Identity Provider.",
                        verbose_name="IdP Certificate",
                    ),
                ),
                (
                    "idp_sso_url",
                    models.TextField(
                        help_text="The single sign-on service URL provided by your IdP.",
                        max_length=2048,
                        verbose_name="IdP Single Sign-On URL",
                    ),
                ),
                (
                    "idp_sso_binding",
                    models.CharField(
                        choices=[
                            (
                                "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
                                "HTTP-POST",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
                                "HTTP-Redirect",
                            ),
                        ],
                        default="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
                        help_text="The single sign-on service protocol binding set by your IdP. HTTP-POST is recommended.",
                        max_length=255,
                        verbose_name="IdP Single Sign-On Binding",
                    ),
                ),
                (
                    "nameidformat",
                    models.CharField(
                        choices=[
                            (
                                "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified",
                                "Unspecified",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress",
                                "EmailAddress",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent",
                                "Persistent",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:2.0:nameid-format:transient",
                                "Transient",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName",
                                "X509SubjectName",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName",
                                "WindowsDomainQualifiedName",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos",
                                "Kerberos",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:2.0:nameid-format:entity",
                                "Entity",
                            ),
                        ],
                        default="urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified",
                        help_text="Format of the assertions subject statement NameID attribute. This must match the format sent from your IdP.",
                        max_length=255,
                        verbose_name="NameID Format",
                    ),
                ),
                (
                    "sp_acs_binding",
                    models.TextField(
                        choices=[
                            (
                                "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
                                "HTTP-POST",
                            ),
                            (
                                "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect",
                                "HTTP-Redirect",
                            ),
                        ],
                        default="urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST",
                        help_text="The single sign-on service protocol binding for this service provider. HTTP-POST is recommended.",
                        max_length=1024,
                        verbose_name="SP Single Sign-On Binding",
                    ),
                ),
                (
                    "debug",
                    models.BooleanField(
                        default=False,
                        help_text="Enable settings debug messages.",
                        verbose_name="Debug",
                    ),
                ),
                (
                    "lowercase_urlencoding",
                    models.BooleanField(
                        default=False,
                        help_text="Enable ADFS lowercase Url encoding support.",
                        verbose_name="Support ADFS",
                    ),
                ),
                (
                    "idp_initiated_auth",
                    models.BooleanField(
                        default=False,
                        help_text="Accept unsolicited IdP initiated assertions.",
                        verbose_name="Allow IdP Initiated Assertions",
                    ),
                ),
                (
                    "sec_want_messages_signed",
                    models.BooleanField(
                        default=True,
                        help_text="Require signed responses from the IdP.",
                        verbose_name="Signed Responses",
                    ),
                ),
                (
                    "sec_want_assertions_signed",
                    models.BooleanField(
                        default=False,
                        help_text="Require signed assertions from the IdP.",
                        verbose_name="Signed Assertions",
                    ),
                ),
                (
                    "sec_want_assertions_encrypted",
                    models.BooleanField(
                        default=False,
                        help_text="Require encrypted assertions from the IdP.",
                        verbose_name="Encrypted Assertions",
                    ),
                ),
                (
                    "attributes",
                    JSONField(
                        blank=True,
                        default=dict,
                        help_text="Map attributes from the IdP to User fields.",
                        verbose_name="Attribute Statements",
                    ),
                ),
            ],
        ),
    ]
