# Contributing

Contributions are welcome, and they are greatly appreciated!
Every little bit helps, and credit will always be given.

You can contribute in many ways:

## Types of Contributions

### Report Bugs

[Report bugs](https://gitlab.com/CoSApp/cosapp/issues/new?issuable_template=Bug) on Gitlab.

If you are reporting a bug, please include:

* Your operating system name and version.
* Any details about your local setup that might be helpful in troubleshooting.
* Detailed steps to reproduce the bug.

### Fix Bugs

Look through the GitLab issues for bugs. Anything tagged with "Bug" and "To do" is open to whoever
wants to implement it.

### Implement Features

Look through the GitLab issues for features. Anything tagged with "Enhancement"
and "To do" is open to whoever wants to implement it.

### Write Documentation

CoSApp could always use more documentation, whether as part of the
official CoSApp docs, in docstrings, or even on the web in blog posts,
articles, and such.

### Submit Feedback

The best way to send feedback is to file a [Feature Proposal](https://gitlab.com/CoSApp/cosapp/issues/new?issuable_template=FeatureProposal).

If you are proposing a feature:

* Explain in detail how it would work.
* Keep the scope as narrow as possible, to make it easier to implement.
* Remember that this is a volunteer-driven project, and that contributions are welcome :)

## Get Started!

Ready to contribute? Here's how to set up `cosapp` for local development.

1. Fork the `cosapp` repo on GitLab.
2. Clone your fork locally:
```
git clone https://gitlab.com/your_login/cosapp.git
```
3. Install your local copy into a conda environment. Assuming you have conda installed, this is how you set up your fork for local development::
```
conda create -n cosapp python scipy pandas jsonschema pytest
cd cosapp/
python -m pip install -e .
```
4. Create a branch for local development::
```
git checkout -b name-of-your-bugfix-or-feature
```
   Now you can make your changes locally.

5. When you're done making changes, check that your changes pass the tests::
```
pytest cosapp
```
6. Commit your changes and push your branch to GitLab::
```
git add .
git commit -m "Your detailed description of your changes."
git push origin name-of-your-bugfix-or-feature
```
7. Submit a pull request through the GitLab website.

## Merge Request Guidelines

Before you submit a merge request, check that it meets these guidelines:

1. The pull request should include tests.
2. If the pull request adds functionality, the docs should be updated. Put
   your new functionality into a function with a docstring, and add the
   feature to the list in `HISTORY.md`.
3. Make sure that the tests pass for all supported Python versions.

## Tips

To run a subset of tests:
```
pytest cosapp/path/to/dir
```
