from typing import Optional, Tuple, List

from configalchemy import BaseConfig


class DefaultConfig(BaseConfig):

    #: Directory of proto files and py files
    #: generated by the protocol buffer compiler
    PROTO_TEMPLATE_PATH = "protos"

    #: Max workers in service thread pool
    GPRC_SERVER_MAX_WORKERS = 10
    #: An optional list of key-value pairs (channel args in gRPC runtime)
    #: to configure the channel.
    GRPC_SERVER_OPTIONS: List[Tuple[str, str]] = []

    #: The maximum number of concurrent RPCs this server
    #: will service before returning RESOURCE_EXHAUSTED status, or None to
    #: indicate no limit.
    GRPC_SERVER_MAXIMUM_CONCURRENT_RPCS: Optional[int] = None

    #: If set `True` the server run will not be blocked.
    GRPC_SERVER_TEST = False
    #: The host/domain name that this server can serve
    GRPC_SERVER_HOST = "[::]"
    #: The port this server listen.
    GRPC_SERVER_PORT = 50051
