/*
 * Decompiled with CFR 0.152.
 */
package org.planit.zoning;

import java.util.logging.Logger;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.zoning.DirectedConnectoid;
import org.planit.utils.zoning.Zone;
import org.planit.zoning.ConnectoidImpl;

public class DirectedConnectoidImpl
extends ConnectoidImpl
implements DirectedConnectoid {
    private static final Logger LOGGER = Logger.getLogger(DirectedConnectoidImpl.class.getCanonicalName());
    protected LinkSegment accessEdgeSegment;
    protected boolean nodeAccessDownstream = true;

    protected void setAccessLinkSegment(LinkSegment accessEdgeSegment) {
        this.accessEdgeSegment = accessEdgeSegment;
    }

    protected DirectedConnectoidImpl(IdGroupingToken idToken, LinkSegment accessLinkSegment, Zone accessZone, double length) {
        super(idToken, accessZone, length);
        this.setAccessLinkSegment(accessLinkSegment);
    }

    public DirectedConnectoidImpl(IdGroupingToken idToken, LinkSegment accessEdgeSegment) {
        super(idToken);
        this.setAccessLinkSegment(accessEdgeSegment);
    }

    protected DirectedConnectoidImpl(DirectedConnectoidImpl connectoidImpl) {
        super(connectoidImpl);
        this.setAccessLinkSegment(connectoidImpl.getAccessLinkSegment());
    }

    @Override
    public LinkSegment getAccessLinkSegment() {
        return this.accessEdgeSegment;
    }

    @Override
    public boolean isNodeAccessDownstream() {
        return this.nodeAccessDownstream;
    }

    @Override
    public void setNodeAccessDownstream(boolean nodeAccessDownstream) {
        this.nodeAccessDownstream = nodeAccessDownstream;
    }
}

