/*
 * Decompiled with CFR 0.152.
 */
package org.planit.zoning;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Node;
import org.planit.utils.zoning.Connectoid;
import org.planit.utils.zoning.Connectoids;
import org.planit.utils.zoning.DirectedConnectoid;
import org.planit.utils.zoning.UndirectedConnectoid;
import org.planit.utils.zoning.Zone;
import org.planit.zoning.DirectedConnectoidImpl;
import org.planit.zoning.UndirectedConnectoidImpl;

public class ConnectoidsImpl
implements Connectoids {
    protected IdGroupingToken idToken;
    protected Map<Long, Connectoid> connectoidMap = new TreeMap<Long, Connectoid>();

    public ConnectoidsImpl(IdGroupingToken idToken) {
        this.idToken = idToken;
    }

    @Override
    public Iterator<Connectoid> iterator() {
        return this.connectoidMap.values().iterator();
    }

    @Override
    public Connectoid register(Connectoid connectoid) {
        return this.connectoidMap.put(connectoid.getId(), connectoid);
    }

    @Override
    public UndirectedConnectoid registerNew(Node accessNode, Zone parentZone, double length) throws PlanItException {
        UndirectedConnectoidImpl newConnectoid = new UndirectedConnectoidImpl(this.idToken, accessNode, parentZone, length);
        this.register(newConnectoid);
        return newConnectoid;
    }

    @Override
    public UndirectedConnectoid registerNew(Node accessNode, Zone parentZone) throws PlanItException {
        return this.registerNew(accessNode, parentZone, 0.0);
    }

    @Override
    public UndirectedConnectoid registerNew(Node accessNode) throws PlanItException {
        UndirectedConnectoidImpl newConnectoid = new UndirectedConnectoidImpl(this.idToken, accessNode);
        this.register(newConnectoid);
        return newConnectoid;
    }

    @Override
    public DirectedConnectoid registerNew(LinkSegment accessLinkSegment, Zone parentZone, double length) throws PlanItException {
        DirectedConnectoidImpl newConnectoid = new DirectedConnectoidImpl(this.idToken, accessLinkSegment, parentZone, length);
        this.register(newConnectoid);
        return newConnectoid;
    }

    @Override
    public DirectedConnectoid registerNew(LinkSegment accessLinkSegment, Zone parentZone) throws PlanItException {
        return this.registerNew(accessLinkSegment, parentZone, 0.0);
    }

    @Override
    public DirectedConnectoid registerNew(LinkSegment accessLinkSegment) throws PlanItException {
        DirectedConnectoidImpl newConnectoid = new DirectedConnectoidImpl(this.idToken, accessLinkSegment);
        this.register(newConnectoid);
        return newConnectoid;
    }

    @Override
    public Connectoid get(long id) {
        return this.connectoidMap.get(id);
    }

    @Override
    public int size() {
        return this.connectoidMap.size();
    }
}

