/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.misc;

import java.io.File;
import java.io.FilenameFilter;
import org.planit.utils.exceptions.PlanItException;

public class FileUtils {
    public static final String DOT = ".";

    public static String getExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(DOT) != -1 && fileName.lastIndexOf(DOT) != 0) {
            return fileName.substring(fileName.lastIndexOf(DOT) + 1);
        }
        return "";
    }

    public static File[] getFilesWithExtensionFromDir(String pathToDir, final String fileExtension) throws PlanItException {
        PlanItException.throwIfNull(pathToDir, String.format("path directory is null when collecting files", new Object[0]));
        PlanItException.throwIfNull(fileExtension, String.format("file extension to use is null when collecting files from directory", new Object[0]));
        File directoryPath = new File(pathToDir);
        PlanItException.throwIf(!directoryPath.isDirectory(), String.format("%s is not a valid directory", directoryPath));
        FilenameFilter fileExtensionFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.endsWith(fileExtension);
            }
        };
        return directoryPath.listFiles(fileExtensionFilter);
    }
}

