/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.graph;

import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.Edges;
import org.planit.utils.graph.Vertex;
import org.planit.utils.graph.Vertices;

public interface Graph<V extends Vertex, E extends Edge> {
    public long getId();

    public Vertices<V> getVertices();

    public Edges<E> getEdges();

    default public boolean validate() {
        boolean isValid = true;
        for (Edge edge : this.getEdges()) {
            isValid = isValid && edge.validate();
        }
        for (Vertex vertex : this.getVertices()) {
            isValid = isValid && vertex.validate();
        }
        return isValid;
    }

    default public void transformGeometries(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        for (Edge edge : this.getEdges()) {
            edge.transformGeometry(transformer);
        }
        for (Vertex vertex : this.getVertices()) {
            vertex.transformPosition(transformer);
        }
    }
}

