/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.graph;

import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.EdgeSegments;
import org.planit.utils.graph.Graph;

public interface DirectedGraph<V extends DirectedVertex, E extends DirectedEdge, ES extends EdgeSegment>
extends Graph<V, E> {
    public EdgeSegments<ES> getEdgeSegments();

    @Override
    default public boolean validate() {
        boolean isValid = Graph.super.validate();
        for (EdgeSegment edgeSegment : this.getEdgeSegments()) {
            isValid = isValid && edgeSegment.validate();
        }
        return isValid;
    }

    @Override
    default public void transformGeometries(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        Graph.super.transformGeometries(transformer);
    }
}

