/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.adapter;

import org.planit.assignment.TrafficAssignment;
import org.planit.assignment.traditionalstatic.TraditionalStaticAssignment;
import org.planit.output.adapter.LinkOutputTypeAdapterImpl;
import org.planit.output.enums.OutputType;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.LinkSegment;

public class TraditionalStaticAssignmentLinkOutputTypeAdapter
extends LinkOutputTypeAdapterImpl {
    protected TraditionalStaticAssignment theAssignment;

    private double getCalculatedSpeed(LinkSegment linkSegment, Mode mode) throws PlanItException {
        int id = (int)linkSegment.getId();
        double[] modalNetworkSegmentCosts = this.theAssignment.getIterationData().getModalLinkSegmentCosts(mode);
        double travelTime = modalNetworkSegmentCosts[id];
        double length = linkSegment.getParentLink().getLengthKm();
        return length / travelTime;
    }

    private double getFlow(LinkSegment linkSegment, Mode mode) throws PlanItException {
        int id = (int)linkSegment.getId();
        double[] modalNetworkSegmentFlows = this.theAssignment.getIterationData().getModeSpecificData().get(mode).getCurrentSegmentFlows();
        return modalNetworkSegmentFlows[id];
    }

    private double getLinkCost(LinkSegment linkSegment, Mode mode, double timeUnitMultiplier) throws PlanItException {
        int id = (int)linkSegment.getId();
        double[] modalNetworkSegmentCosts = this.theAssignment.getIterationData().getModalLinkSegmentCosts(mode);
        return modalNetworkSegmentCosts[id] * timeUnitMultiplier;
    }

    private double getCostTimesFlow(LinkSegment linkSegment, Mode mode, double timeUnitMultiplier) throws PlanItException {
        return this.getLinkCost(linkSegment, mode, timeUnitMultiplier) * this.getFlow(linkSegment, mode);
    }

    private double getVCRatio(LinkSegment linkSegment) throws PlanItException {
        double totalFlow = 0.0;
        for (Mode mode : this.trafficAssignment.getTransportNetwork().getInfrastructureNetwork().modes) {
            totalFlow += this.getFlow(linkSegment, mode);
        }
        double capacityPerLane = this.getCapacityPerLane(linkSegment);
        return totalFlow / ((double)linkSegment.getNumberOfLanes() * capacityPerLane);
    }

    public TraditionalStaticAssignmentLinkOutputTypeAdapter(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
        this.theAssignment = (TraditionalStaticAssignment)this.trafficAssignment;
    }

    @Override
    public boolean isFlowPositive(LinkSegment linkSegment, Mode mode) {
        return this.theAssignment.getIterationData().getModeSpecificData().get(mode).getCurrentSegmentFlows()[(int)linkSegment.getId()] > 0.0;
    }

    @Override
    public Object getLinkOutputPropertyValue(OutputProperty outputProperty, LinkSegment linkSegment, Mode mode, TimePeriod timePeriod, double timeUnitMultiplier) {
        try {
            Object obj = this.getOutputTypeIndependentPropertyValue(outputProperty, mode, timePeriod);
            if (obj != null) {
                return obj;
            }
            obj = super.getLinkOutputPropertyValue(outputProperty, linkSegment, mode, timePeriod, timeUnitMultiplier);
            if (obj != null) {
                return obj;
            }
            switch (outputProperty) {
                case CALCULATED_SPEED: {
                    return this.getCalculatedSpeed(linkSegment, mode);
                }
                case FLOW: {
                    return this.getFlow(linkSegment, mode);
                }
                case LINK_COST: {
                    return this.getLinkCost(linkSegment, mode, timeUnitMultiplier);
                }
                case VC_RATIO: {
                    return this.getVCRatio(linkSegment);
                }
                case COST_TIMES_FLOW: {
                    return this.getCostTimesFlow(linkSegment, mode, timeUnitMultiplier);
                }
            }
            return new PlanItException("Tried to find link property of " + BaseOutputProperty.convertToBaseOutputProperty(outputProperty).getName() + " which is not applicable for links.");
        }
        catch (PlanItException e) {
            return e;
        }
    }
}

