/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.adapter;

import org.planit.assignment.TrafficAssignment;
import org.planit.od.odpath.ODPathIterator;
import org.planit.output.adapter.OutputTypeAdapterImpl;
import org.planit.output.adapter.PathOutputTypeAdapter;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.PathOutputIdentificationType;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.path.Path;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.mode.Mode;

public abstract class PathOutputTypeAdapterImpl
extends OutputTypeAdapterImpl
implements PathOutputTypeAdapter {
    protected String getDestinationZoneExternalId(ODPathIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentDestination().getExternalId();
    }

    protected String getDestinationZoneXmlId(ODPathIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentDestination().getXmlId();
    }

    protected long getDestinationZoneId(ODPathIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentDestination().getId();
    }

    protected Object getOriginZoneExternalId(ODPathIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentOrigin().getExternalId();
    }

    protected String getOriginZoneXmlId(ODPathIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentOrigin().getXmlId();
    }

    protected long getOriginZoneId(ODPathIterator odPathIterator) throws PlanItException {
        return odPathIterator.getCurrentOrigin().getId();
    }

    protected String getPathAsString(ODPathIterator odPathIterator, PathOutputIdentificationType pathOutputType) {
        Path path = odPathIterator.getCurrentValue();
        if (path != null) {
            return path.toString(pathOutputType);
        }
        return "";
    }

    protected long getPathId(ODPathIterator odPathIterator) {
        Path path = odPathIterator.getCurrentValue();
        if (path == null) {
            return -1L;
        }
        return odPathIterator.getCurrentValue().getId();
    }

    public PathOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Object getPathOutputPropertyValue(OutputProperty outputProperty, ODPathIterator odPathIterator, Mode mode, TimePeriod timePeriod, PathOutputIdentificationType pathOutputType) {
        try {
            Object obj = this.getOutputTypeIndependentPropertyValue(outputProperty, mode, timePeriod);
            if (obj != null) {
                return obj;
            }
            switch (outputProperty) {
                case DESTINATION_ZONE_EXTERNAL_ID: {
                    return this.getDestinationZoneExternalId(odPathIterator);
                }
                case DESTINATION_ZONE_XML_ID: {
                    return this.getDestinationZoneXmlId(odPathIterator);
                }
                case DESTINATION_ZONE_ID: {
                    return this.getDestinationZoneId(odPathIterator);
                }
                case PATH_STRING: {
                    return this.getPathAsString(odPathIterator, pathOutputType);
                }
                case PATH_ID: {
                    return this.getPathId(odPathIterator);
                }
                case ORIGIN_ZONE_EXTERNAL_ID: {
                    return this.getOriginZoneExternalId(odPathIterator);
                }
                case ORIGIN_ZONE_XML_ID: {
                    return this.getOriginZoneXmlId(odPathIterator);
                }
                case ORIGIN_ZONE_ID: {
                    return this.getOriginZoneId(odPathIterator);
                }
            }
            return new PlanItException("Tried to find link property of " + BaseOutputProperty.convertToBaseOutputProperty(outputProperty).getName() + " which is not applicable for OD path");
        }
        catch (PlanItException e) {
            return e;
        }
    }
}

