/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.transport;

import java.util.Collection;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureNetwork;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.network.virtual.VirtualNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.network.virtual.ConnectoidEdge;
import org.planit.utils.network.virtual.ConnectoidSegment;
import org.planit.utils.zoning.Connectoid;
import org.planit.zoning.Zoning;

public class TransportNetwork {
    protected final InfrastructureNetwork infrastructureNetwork;
    protected final Zoning zoning;

    protected void connectVerticesToEdgeSegment(EdgeSegment edgeSegment) throws PlanItException {
        edgeSegment.getUpstreamVertex().addEdgeSegment(edgeSegment);
        edgeSegment.getDownstreamVertex().addEdgeSegment(edgeSegment);
    }

    protected void disconnectVerticesFromEdgeSegment(EdgeSegment edgeSegment) throws PlanItException {
        edgeSegment.getUpstreamVertex().removeEdgeSegment(edgeSegment);
        edgeSegment.getDownstreamVertex().removeEdgeSegment(edgeSegment);
    }

    protected void connectVerticesToEdge(Edge edge) throws PlanItException {
        edge.getVertexA().addEdge(edge);
        edge.getVertexB().addEdge(edge);
    }

    protected void disconnectVerticesFromEdge(Edge edge) throws PlanItException {
        edge.getVertexA().removeEdge(edge);
        edge.getVertexB().removeEdge(edge);
    }

    public TransportNetwork(InfrastructureNetwork infrastructureNetwork, Zoning zoning) {
        this.infrastructureNetwork = infrastructureNetwork;
        this.zoning = zoning;
    }

    public int getTotalNumberOfEdgeSegments() {
        return this.getTotalNumberOfPhysicalLinkSegments() + this.getTotalNumberOfConnectoidSegments();
    }

    public int getTotalNumberOfPhysicalLinkSegments() {
        int totalPhysicalLinkSegments = 0;
        for (InfrastructureLayer networkLayer : this.getInfrastructureNetwork().infrastructureLayers) {
            if (!(networkLayer instanceof MacroscopicPhysicalNetwork)) continue;
            totalPhysicalLinkSegments = (int)((long)totalPhysicalLinkSegments + ((MacroscopicPhysicalNetwork)networkLayer).linkSegments.size());
        }
        return totalPhysicalLinkSegments;
    }

    public int getTotalNumberOfConnectoidSegments() {
        return this.zoning.getVirtualNetwork().connectoidSegments.getNumberOfConnectoidSegments();
    }

    public int getTotalNumberOfVertices() {
        return this.zoning.odZones.getNumberOfCentroids() + this.zoning.transferZones.getNumberOfCentroids() + this.getTotalNumberOfPhysicalNodes();
    }

    public int getTotalNumberOfPhysicalNodes() {
        int totalPhysicalNodes = 0;
        for (InfrastructureLayer networkLayer : this.getInfrastructureNetwork().infrastructureLayers) {
            if (!(networkLayer instanceof MacroscopicPhysicalNetwork)) continue;
            totalPhysicalNodes += ((MacroscopicPhysicalNetwork)networkLayer).nodes.size();
        }
        return totalPhysicalNodes;
    }

    public void integrateConnectoidsAndLinks() throws PlanItException {
        VirtualNetwork virtualNetwork = this.zoning.getVirtualNetwork();
        for (Connectoid connectoid : this.zoning.connectoids) {
            Collection<ConnectoidEdge> connectoidEdges = virtualNetwork.connectoidEdges.registerNew(connectoid);
            for (ConnectoidEdge connectoidEdge : connectoidEdges) {
                virtualNetwork.connectoidSegments.createAndRegisterConnectoidSegment(connectoidEdge, true);
                virtualNetwork.connectoidSegments.createAndRegisterConnectoidSegment(connectoidEdge, false);
                this.connectVerticesToEdge(connectoidEdge);
            }
        }
        for (ConnectoidSegment connectoidSegment : virtualNetwork.connectoidSegments) {
            this.connectVerticesToEdgeSegment(connectoidSegment);
        }
    }

    public void removeVirtualNetworkFromPhysicalNetwork() throws PlanItException {
        for (ConnectoidEdge connectoidEdge : this.zoning.getVirtualNetwork().connectoidEdges) {
            this.disconnectVerticesFromEdge(connectoidEdge);
        }
        for (ConnectoidSegment connectoidSegment : this.zoning.getVirtualNetwork().connectoidSegments) {
            this.disconnectVerticesFromEdgeSegment(connectoidSegment);
        }
        this.zoning.getVirtualNetwork().clear();
    }

    public InfrastructureNetwork getInfrastructureNetwork() {
        return this.infrastructureNetwork;
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.zoning.getVirtualNetwork();
    }

    public Zoning getZoning() {
        return this.zoning;
    }
}

