/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical;

import java.util.logging.Logger;
import org.planit.graph.DirectedGraphBuilderImpl;
import org.planit.graph.EdgeSegmentsImpl;
import org.planit.graph.EdgesImpl;
import org.planit.graph.VerticesImpl;
import org.planit.network.physical.LinkImpl;
import org.planit.network.physical.LinkSegmentImpl;
import org.planit.network.physical.NodeImpl;
import org.planit.network.physical.PhysicalNetworkBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.EdgeSegments;
import org.planit.utils.graph.Edges;
import org.planit.utils.graph.Vertex;
import org.planit.utils.graph.Vertices;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Node;

public class PhysicalNetworkBuilderImpl
implements PhysicalNetworkBuilder<Node, Link, LinkSegment> {
    private static final Logger LOGGER = Logger.getLogger(PhysicalNetworkBuilderImpl.class.getCanonicalName());
    protected DirectedGraphBuilderImpl directedGraphBuilderImpl;

    public PhysicalNetworkBuilderImpl(IdGroupingToken groupId) {
        this.directedGraphBuilderImpl = new DirectedGraphBuilderImpl(groupId);
    }

    @Override
    public Node createVertex() {
        return new NodeImpl(this.getIdGroupingToken());
    }

    @Override
    public Link createEdge(Vertex nodeA, Vertex nodeB, double length) throws PlanItException {
        if (nodeA instanceof Node && nodeB instanceof Node) {
            return new LinkImpl(this.getIdGroupingToken(), (Node)nodeA, (Node)nodeB, length);
        }
        throw new PlanItException("unable to create link, vertices should be of type Node");
    }

    @Override
    public LinkSegment createEdgeSegment(DirectedEdge parentLink, boolean directionAB) throws PlanItException {
        return new LinkSegmentImpl(this.getIdGroupingToken(), (Link)parentLink, directionAB);
    }

    @Override
    public void setIdGroupingToken(IdGroupingToken groupToken) {
        this.directedGraphBuilderImpl.setIdGroupingToken(groupToken);
    }

    @Override
    public IdGroupingToken getIdGroupingToken() {
        return this.directedGraphBuilderImpl.getIdGroupingToken();
    }

    @Override
    public void recreateIds(EdgeSegments<? extends LinkSegment> linkSegments) {
        this.directedGraphBuilderImpl.recreateIds((EdgeSegments<? extends EdgeSegment>)linkSegments);
        if (linkSegments instanceof EdgeSegmentsImpl) {
            IdGenerator.reset(this.getIdGroupingToken(), LinkSegment.class);
            for (LinkSegment linkSegment : linkSegments) {
                if (linkSegment instanceof LinkSegmentImpl) {
                    ((LinkSegmentImpl)linkSegment).setLinkSegmentId(LinkSegmentImpl.generateLinkSegmentId(this.getIdGroupingToken()));
                    continue;
                }
                LOGGER.severe(String.format("attempting to reset id on link segment (%s) that is not compatible with the node implementation generated by this builder, ignored", linkSegment.getClass().getCanonicalName()));
            }
        }
    }

    @Override
    public void recreateIds(Edges<? extends Link> links) {
        this.directedGraphBuilderImpl.recreateIds((Edges<? extends DirectedEdge>)links);
        if (links instanceof EdgesImpl) {
            IdGenerator.reset(this.getIdGroupingToken(), Link.class);
            for (Link link : links) {
                if (link instanceof LinkImpl) {
                    ((LinkImpl)link).setLinkId(LinkImpl.generateLinkId(this.getIdGroupingToken()));
                    continue;
                }
                LOGGER.severe(String.format("attempting to reset linkId on link (%s) that is not compatible with the link implementation generated by this builder, ignored", link.getClass().getCanonicalName()));
            }
        } else {
            LOGGER.severe("expected the Edges implementation to be compatible with graph builder, this is not the case: unable to correctly remove subnetwork and update ids");
        }
    }

    @Override
    public void recreateIds(Vertices<? extends Node> nodes) {
        this.directedGraphBuilderImpl.recreateIds((Vertices<? extends DirectedVertex>)nodes);
        if (nodes instanceof VerticesImpl) {
            IdGenerator.reset(this.getIdGroupingToken(), Node.class);
            for (Node node : nodes) {
                if (node instanceof NodeImpl) {
                    ((NodeImpl)node).setNodeId(NodeImpl.generateNodeId(this.getIdGroupingToken()));
                    continue;
                }
                LOGGER.severe(String.format("attempting to reset id on node (%s) that is not compatible with the node implementation generated by this builder, ignored", node.getClass().getCanonicalName()));
            }
        } else {
            LOGGER.severe("expected the Vertices implementation to be compatible with graph builder, this is not the case: unable to correctly remove subnetwork and update ids");
        }
    }

    @Override
    public Link createUniqueCopyOf(Link linkToCopy) {
        if (linkToCopy instanceof LinkImpl) {
            LinkImpl copy = (LinkImpl)this.directedGraphBuilderImpl.createUniqueCopyOf(linkToCopy);
            copy.setLinkId(LinkImpl.generateLinkId(this.getIdGroupingToken()));
            return copy;
        }
        LOGGER.severe("passed in link is not an instance created by this builder, incompatible for creating a copy");
        return null;
    }

    @Override
    public LinkSegment createUniqueCopyOf(LinkSegment linkSegmentToCopy, DirectedEdge parentEdge) {
        if (linkSegmentToCopy instanceof LinkSegmentImpl) {
            LinkSegmentImpl copy = (LinkSegmentImpl)this.directedGraphBuilderImpl.createUniqueCopyOf(linkSegmentToCopy, parentEdge);
            copy.setLinkSegmentId(LinkSegmentImpl.generateLinkSegmentId(this.getIdGroupingToken()));
            return copy;
        }
        LOGGER.severe("passed in link segment is not an instance created by this builder, incompatible for creating a copy");
        return null;
    }
}

