/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegments;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.LinkSegments;

public class LinkSegmentsImpl<LS extends LinkSegment>
implements LinkSegments<LS> {
    private static final Logger LOGGER = Logger.getLogger(LinkSegmentsImpl.class.getCanonicalName());
    private final EdgeSegments<LS> edgeSegments;
    private Map<Long, List<LS>> linkSegmentMapByStartNodeId = new HashMap<Long, List<LS>>();

    protected void registerStartNode(LS linkSegment) {
        DirectedVertex startNode = linkSegment.getUpstreamVertex();
        if (!this.linkSegmentMapByStartNodeId.containsKey(startNode.getId())) {
            this.linkSegmentMapByStartNodeId.put(startNode.getId(), new ArrayList());
        }
        this.linkSegmentMapByStartNodeId.get(startNode.getId()).add(linkSegment);
    }

    public LinkSegmentsImpl(EdgeSegments<LS> edgeSegments) {
        this.edgeSegments = edgeSegments;
    }

    @Override
    public void remove(LS linkSegment) {
        this.edgeSegments.remove(linkSegment);
    }

    @Override
    public void remove(long edgeSegmentId) {
        this.edgeSegments.remove(edgeSegmentId);
    }

    @Override
    public LS create(DirectedEdge parent, boolean directionAB) throws PlanItException {
        return (LS)((LinkSegment)this.edgeSegments.create(parent, directionAB));
    }

    @Override
    public void register(DirectedEdge parentEdge, LS edgeSegment, boolean directionAB) throws PlanItException {
        this.edgeSegments.register(parentEdge, edgeSegment, directionAB);
        this.registerStartNode(edgeSegment);
    }

    @Override
    public LS get(long id) {
        return (LS)((LinkSegment)this.edgeSegments.get(id));
    }

    @Override
    public LS getByXmlId(String xmlId) {
        return (LS)((LinkSegment)this.edgeSegments.getByXmlId(xmlId));
    }

    @Override
    public long size() {
        return this.edgeSegments.size();
    }

    @Override
    public LS registerUniqueCopyOf(LS edgeSegmentToCopy, DirectedEdge newParent) {
        LinkSegment linkSegment = (LinkSegment)this.edgeSegments.registerUniqueCopyOf(edgeSegmentToCopy, newParent);
        this.registerStartNode(linkSegment);
        return (LS)linkSegment;
    }

    @Override
    public Iterator<LS> iterator() {
        return this.edgeSegments.iterator();
    }

    @Override
    public LS registerNew(DirectedEdge parentEdge, boolean directionAb, boolean registerOnNodeAndLink) throws PlanItException {
        LinkSegment linkSegment = (LinkSegment)this.edgeSegments.registerNew(parentEdge, directionAb, registerOnNodeAndLink);
        this.registerStartNode(linkSegment);
        return (LS)linkSegment;
    }

    @Override
    public LS getByExternalId(String externalId) {
        for (LinkSegment linkSegment : this.edgeSegments) {
            if (!externalId.equals(linkSegment.getExternalId())) continue;
            return (LS)linkSegment;
        }
        return null;
    }
}

