/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical;

import org.planit.graph.EdgeSegmentImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.LinkSegment;

public class LinkSegmentImpl
extends EdgeSegmentImpl
implements LinkSegment {
    private static final long serialVersionUID = -4893553215218232006L;
    protected long linkSegmentId;
    protected int numberOfLanes = 1;
    protected double physicalSpeedLinkKmh = 130.0;

    protected static long generateLinkSegmentId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, LinkSegment.class);
    }

    protected void setLinkSegmentId(long linkSegmentId) {
        this.linkSegmentId = linkSegmentId;
    }

    protected LinkSegmentImpl(IdGroupingToken groupId, Link parentLink, boolean directionAB) throws PlanItException {
        super(groupId, parentLink, directionAB);
        this.setLinkSegmentId(LinkSegmentImpl.generateLinkSegmentId(groupId));
    }

    protected LinkSegmentImpl(LinkSegmentImpl linkSegmentImpl) {
        super(linkSegmentImpl);
        this.setLinkSegmentId(linkSegmentImpl.getLinkSegmentId());
        this.setNumberOfLanes(linkSegmentImpl.getNumberOfLanes());
        this.setPhysicalSpeedLimitKmH(linkSegmentImpl.getPhysicalSpeedLimitKmH());
    }

    @Override
    public long getLinkSegmentId() {
        return this.linkSegmentId;
    }

    @Override
    public int getNumberOfLanes() {
        return this.numberOfLanes;
    }

    @Override
    public void setNumberOfLanes(int numberOfLanes) {
        this.numberOfLanes = numberOfLanes;
    }

    @Override
    public void setPhysicalSpeedLimitKmH(double maximumSpeed) {
        this.physicalSpeedLinkKmh = maximumSpeed;
    }

    @Override
    public double getPhysicalSpeedLimitKmH() {
        return this.physicalSpeedLinkKmh;
    }

    @Override
    public Link getParentLink() {
        return (Link)this.getParentEdge();
    }

    @Override
    public LinkSegmentImpl clone() {
        return new LinkSegmentImpl(this);
    }
}

