/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical;

import java.util.logging.Logger;
import org.planit.graph.DirectedEdgeImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.Node;

public class LinkImpl
extends DirectedEdgeImpl
implements Link {
    private static final long serialVersionUID = 2360017879557363410L;
    private static final Logger LOGGER = Logger.getLogger(LinkImpl.class.getCanonicalName());
    protected long linkId;

    protected static long generateLinkId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Link.class);
    }

    protected void setLinkId(long linkId) {
        this.linkId = linkId;
    }

    protected LinkImpl(LinkImpl linkImpl) {
        super(linkImpl);
        this.setLinkId(linkImpl.getLinkId());
    }

    protected LinkImpl(IdGroupingToken groupId, Node nodeA, Node nodeB, double length) throws PlanItException {
        super(groupId, nodeA, nodeB, length);
        this.setLinkId(LinkImpl.generateLinkId(groupId));
    }

    @Override
    public long getLinkId() {
        return this.linkId;
    }

    @Override
    public LinkImpl clone() {
        return new LinkImpl(this);
    }

    @Override
    public boolean validate() {
        if (super.validate() && this.getGeometry() != null) {
            if (!this.getNodeA().getPosition().getCoordinate().equals2D(this.getGeometry().getCoordinateN(0))) {
                return false;
            }
            if (!this.getNodeB().getPosition().getCoordinate().equals2D(this.getGeometry().getCoordinateN(this.getGeometry().getNumPoints() - 1))) {
                LOGGER.warning(String.format("link (id:%d externalId:%s) geometry inconsistent with extreme node B", this.getId(), this.getExternalId()));
                return false;
            }
        }
        return false;
    }
}

