/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.macroscopic.physical;

import java.util.Collection;
import org.planit.network.macroscopic.physical.MacroscopicModePropertiesImpl;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public class MacroscopicModePropertiesFactory {
    public static MacroscopicModeProperties create(double maxSpeedKmH, double criticalSpeedKmH) {
        return new MacroscopicModePropertiesImpl(maxSpeedKmH, criticalSpeedKmH);
    }

    public static MacroscopicModeProperties create(double maxSpeedKmH) {
        return MacroscopicModePropertiesFactory.create(maxSpeedKmH, 60.0);
    }

    public static MacroscopicModeProperties create() {
        return MacroscopicModePropertiesFactory.create(80.0, 60.0);
    }

    public static void createOnLinkSegmentType(MacroscopicLinkSegmentType linkSegmentType, Collection<Mode> modesToAdd, double maxSpeedKmH) {
        for (Mode planitMode : modesToAdd) {
            MacroscopicModePropertiesFactory.createOnLinkSegmentType(linkSegmentType, planitMode, maxSpeedKmH);
        }
    }

    public static void createOnLinkSegmentType(MacroscopicLinkSegmentType linkSegmentType, Mode modeToAdd, double maxSpeedKmH) {
        double cappedMaxSpeed = Math.min(maxSpeedKmH, modeToAdd.getMaximumSpeedKmH());
        linkSegmentType.addModeProperties(modeToAdd, MacroscopicModePropertiesFactory.create(cappedMaxSpeed, cappedMaxSpeed));
    }
}

