/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.converter;

import java.util.logging.Logger;
import org.planit.network.InfrastructureNetwork;
import org.planit.network.converter.NetworkReader;
import org.planit.network.converter.NetworkWriter;
import org.planit.utils.exceptions.PlanItException;

public class NetworkConverter {
    private static final Logger LOGGER = Logger.getLogger(NetworkConverter.class.getCanonicalName());
    protected final NetworkReader reader;
    protected final NetworkWriter writer;

    protected boolean isModeConversionValid() {
        return true;
    }

    protected NetworkConverter(NetworkReader reader, NetworkWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public void convert() throws PlanItException {
        if (this.isModeConversionValid()) {
            LOGGER.info("****************** [START] NETWORK CONVERTER: READ NETWORK   [START] ********************");
            InfrastructureNetwork network = this.reader.read();
            LOGGER.info("****************** [END]   NETWORK CONVERTER: READ NETWORK   [END]   ********************");
            LOGGER.info("****************** [START] NETWORK CONVERTER: WRITE NETWORK [START] ********************");
            this.writer.write(network);
            LOGGER.info("****************** [END]   NETWORK CONVERTER: WRITE NETWORK [END]   ********************");
        } else {
            LOGGER.severe("unable to convert network, modes mapping between reader and writer is incompatible");
        }
    }

    public NetworkReader getReader() {
        return this.reader;
    }

    public NetworkWriter getWriter() {
        return this.writer;
    }
}

