/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureLayers;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;

public class InfraStructureLayersImpl
implements InfrastructureLayers {
    private static final Logger LOGGER = Logger.getLogger(InfraStructureLayersImpl.class.getCanonicalName());
    protected final Map<Long, InfrastructureLayer> infrastructureLayers = new TreeMap<Long, InfrastructureLayer>();
    private final IdGroupingToken groupingId;

    public InfraStructureLayersImpl(IdGroupingToken groupingId) {
        this.groupingId = groupingId;
    }

    @Override
    public InfrastructureLayer remove(InfrastructureLayer entity) {
        if (entity == null) {
            LOGGER.warning("cannot remove infrastructure layer, null provided");
            return null;
        }
        return this.remove(entity.getId());
    }

    @Override
    public InfrastructureLayer remove(long id) {
        return this.infrastructureLayers.remove(id);
    }

    @Override
    public MacroscopicPhysicalNetwork createNew() {
        MacroscopicPhysicalNetwork newInfrastructureLayer = new MacroscopicPhysicalNetwork(this.groupingId);
        this.register(newInfrastructureLayer);
        return newInfrastructureLayer;
    }

    @Override
    public Iterator<InfrastructureLayer> iterator() {
        return this.infrastructureLayers.values().iterator();
    }

    @Override
    public InfrastructureLayer register(InfrastructureLayer entity) {
        if (entity == null) {
            LOGGER.warning("cannot register infrastructure layer, null provided");
            return null;
        }
        return this.infrastructureLayers.put(entity.getId(), entity);
    }

    @Override
    public MacroscopicPhysicalNetwork registerNew() {
        MacroscopicPhysicalNetwork newInfrastructureLayer = this.createNew();
        this.register(newInfrastructureLayer);
        return newInfrastructureLayer;
    }

    @Override
    public int size() {
        return this.infrastructureLayers.size();
    }

    @Override
    public InfrastructureLayer get(long id) {
        return this.infrastructureLayers.get(id);
    }

    @Override
    public InfrastructureLayer get(Mode mode) {
        for (InfrastructureLayer layer : this) {
            if (!layer.supports(mode)) continue;
            return layer;
        }
        return null;
    }
}

