/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.util;

import java.util.regex.Pattern;
import org.planit.io.xml.util.ApplicationProperties;

public class PlanitSchema {
    private static final String XSD_DIR = "/xsd/";
    public static final String MACROSCOPIC_NETWORK_XSD = "macroscopicnetworkinput.xsd";
    public static final String MACROSCOPIC_DEMAND_XSD = "macroscopicdemandinput.xsd";
    public static final String MACROSCOPIC_ZONING_XSD = "macroscopiczoninginput.xsd";
    public static final String METADATA_XSD = "metadata.xsd";
    public static final String MACROSCOPIC_COMBINED_INPUT_XSD = "macroscopicinput.xsd";
    public static final String XSD_SCHEMA_URI_DEVELOPMENT_GENERIC = "https://trafficplanit.github.io/PLANitManual/xsd/";
    public static final String RESOURCES_RELEASE_GENERIC = "https://planitmanual.github.io/version/";
    public static final String MACROSCOPIC_NETWORK_XSD_SCHEMA_URI_DEV = "https://trafficplanit.github.io/PLANitManual/xsd/macroscopicnetworkinput.xsd";
    public static final String MACROSCOPIC_ZONING_XSD_SCHEMA_URI_DEV = "https://trafficplanit.github.io/PLANitManual/xsd/macroscopiczoninginput.xsd";
    public static final String MACROSCOPIC_DEMAND_XSD_SCHEMA_URI_DEV = "https://trafficplanit.github.io/PLANitManual/xsd/macroscopicdemandinput.xsd";
    public static final String XSD_SCHEMA_URI_RELEASE_GENERIC = "https://planitmanual.github.io/version/";

    private static final boolean isReleaseVersion(String version) {
        return Pattern.matches("^[a-zA-Z]*$", version);
    }

    private static final String getReleaseVersionAsUriString() {
        return ApplicationProperties.getVersion().replace('.', '_');
    }

    public static String createPlanitSchemaUri(String xsdFileName) {
        boolean releaseVersion = PlanitSchema.isReleaseVersion(ApplicationProperties.getVersion());
        if (releaseVersion) {
            return "https://planitmanual.github.io/version/" + PlanitSchema.getReleaseVersionAsUriString() + XSD_DIR + xsdFileName;
        }
        return XSD_SCHEMA_URI_DEVELOPMENT_GENERIC + xsdFileName;
    }
}

