/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.util;

import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.planit.io.output.formatter.PlanItOutputFormatter;

public class ApplicationProperties {
    private static final Logger LOGGER = Logger.getLogger(ApplicationProperties.class.getCanonicalName());
    private static final Properties applicationProperties = new Properties();
    public static final String APPLICATION_PROPERTIES_FILE_NAME = "application.properties";
    public static final String DESCRIPTION_PROPERTY_KEY = "planit.description";
    public static final String VERSION_PROPERTY_KEY = "planit.version";

    public static String getPropertyByKey(String key) {
        String value = applicationProperties.getProperty(key);
        if (value == null) {
            LOGGER.warning(String.format("property %s could not be collected from application.properties file", key));
        }
        return value;
    }

    public static String getDescription() {
        return ApplicationProperties.getPropertyByKey(DESCRIPTION_PROPERTY_KEY);
    }

    public static String getVersion() {
        return ApplicationProperties.getPropertyByKey(VERSION_PROPERTY_KEY);
    }

    static {
        InputStream input = PlanItOutputFormatter.class.getClassLoader().getResourceAsStream(APPLICATION_PROPERTIES_FILE_NAME);
        try {
            if (input == null) {
                LOGGER.severe("Application properties application.properties could not be found");
            }
            applicationProperties.load(input);
            input.close();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Error when parsing application.properties file in PLANitIO");
            try {
                input.close();
            }
            catch (Exception e2) {
                LOGGER.severe("Unable to close input stream for reading application.properties");
            }
        }
    }
}

