/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.network.converter;

import java.text.DecimalFormat;
import java.util.logging.Logger;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.planit.utils.math.Precision;
import org.planit.utils.misc.CharacterUtils;

public class PlanitNetworkWriterSettings {
    private static final Logger LOGGER = Logger.getLogger(PlanitNetworkWriterSettings.class.getCanonicalName());
    protected DecimalFormat decimalFormat = Precision.DEFAULT_DECIMAL_FORMAT;
    protected Character tupleSeparator = CharacterUtils.SPACE;
    protected Character commaSeparator = CharacterUtils.COMMA;
    protected Character decimalSeparator = CharacterUtils.DECIMAL_POINT;
    protected CoordinateReferenceSystem destinationCoordinateReferenceSystem = null;
    protected String countryName = null;

    public void logSettings() {
        LOGGER.info(String.format("Decimal fidelity set to %s", this.decimalFormat.getMaximumFractionDigits()));
        if (this.getDestinationCoordinateReferenceSystem() != null) {
            LOGGER.info(String.format("Destination Coordinate Reference System set to: %s", this.getDestinationCoordinateReferenceSystem().getName()));
        }
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public Character getTupleSeparator() {
        return this.tupleSeparator;
    }

    public void setTupleSeparator(Character tupleSeparator) {
        this.tupleSeparator = tupleSeparator;
    }

    public Character getCommaSeparator() {
        return this.commaSeparator;
    }

    public void setCommaSeparator(Character commaSeparator) {
        this.commaSeparator = commaSeparator;
    }

    public Character getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(Character decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public CoordinateReferenceSystem getDestinationCoordinateReferenceSystem() {
        return this.destinationCoordinateReferenceSystem;
    }

    public void setDestinationCoordinateReferenceSystem(CoordinateReferenceSystem destinationCoordinateReferenceSystem) {
        this.destinationCoordinateReferenceSystem = destinationCoordinateReferenceSystem;
    }
}

