/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.intermodal;

import java.util.Map;
import java.util.logging.Logger;
import org.planit.io.intermodal.PlanitInterModalReaderSettings;
import org.planit.io.xml.util.PlanitXmlReader;
import org.planit.network.InfrastructureNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Node;
import org.planit.xml.generated.XMLElementMacroscopicIntermodal;
import org.planit.zoning.Zoning;

public class PlanitInterModalReader
extends PlanitXmlReader<XMLElementMacroscopicIntermodal> {
    private static final Logger LOGGER = Logger.getLogger(PlanitInterModalReader.class.getCanonicalName());
    protected final PlanitInterModalReaderSettings settings = new PlanitInterModalReaderSettings();
    protected Zoning zoning;

    protected void setZoning(Zoning zoning) {
        this.zoning = zoning;
    }

    public PlanitInterModalReader(String pathDirectory, String xmlFileExtension, Zoning zoning) throws PlanItException {
        super(XMLElementMacroscopicIntermodal.class, pathDirectory, xmlFileExtension);
        this.setZoning(zoning);
    }

    public PlanitInterModalReader(XMLElementMacroscopicIntermodal xmlElementMacroscopicIntermodal, Zoning zoning) throws PlanItException {
        super(xmlElementMacroscopicIntermodal);
        this.setZoning(zoning);
    }

    public Zoning read(InfrastructureNetwork network, Map<String, Node> nodesByXmlIds) throws PlanItException {
        try {
            this.initialiseAndParseXmlRootElement();
            this.clearXmlContent();
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when populating zoning in PLANitIO", e);
        }
        return this.zoning;
    }

    public PlanitInterModalReaderSettings getSettings() {
        return this.settings;
    }
}

