/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.planit.graph.GraphBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.Edges;
import org.planit.utils.graph.Vertex;

public class EdgesImpl<V extends Vertex, E extends Edge>
implements Edges<E> {
    private final GraphBuilder<V, E> graphBuilder;
    private Map<Long, E> edgeMap;

    protected void updateIdMapping() {
        HashMap updatedMap = new HashMap(this.edgeMap.size());
        this.edgeMap.forEach((? super K oldId, ? super V edge) -> updatedMap.put(edge.getId(), edge));
        this.edgeMap = updatedMap;
    }

    public EdgesImpl(GraphBuilder<V, E> graphBuilder) {
        this.graphBuilder = graphBuilder;
        this.edgeMap = new TreeMap<Long, E>();
    }

    public E register(E edge) {
        return (E)((Edge)this.edgeMap.put(edge.getId(), edge));
    }

    @Override
    public void remove(E edge) {
        this.edgeMap.remove(edge.getId());
    }

    @Override
    public void remove(long edgeId) {
        this.edgeMap.remove(edgeId);
    }

    @Override
    public Iterator<E> iterator() {
        return this.edgeMap.values().iterator();
    }

    @Override
    public E registerNew(Vertex vertexA, Vertex vertexB, double length, boolean registerOnVertices) throws PlanItException {
        E newEdge = this.graphBuilder.createEdge(vertexA, vertexB, length);
        this.register(newEdge);
        if (registerOnVertices) {
            vertexA.addEdge((Edge)newEdge);
            vertexB.addEdge((Edge)newEdge);
        }
        return newEdge;
    }

    @Override
    public E get(long id) {
        return (E)((Edge)this.edgeMap.get(id));
    }

    @Override
    public int size() {
        return this.edgeMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public E registerUniqueCopyOf(E edgeToCopy) {
        E copy = this.graphBuilder.createUniqueCopyOf(edgeToCopy);
        this.register(copy);
        return copy;
    }
}

