/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.logging.Logger;
import org.planit.graph.EdgeImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.id.IdGroupingToken;

public class DirectedEdgeImpl
extends EdgeImpl
implements DirectedEdge {
    private static final long serialVersionUID = -3061186642253968991L;
    private static final Logger LOGGER = Logger.getLogger(DirectedEdgeImpl.class.getCanonicalName());
    private EdgeSegment edgeSegmentAb = null;
    private EdgeSegment edgeSegmentBa = null;

    protected void setEdgeSegmentBa(EdgeSegment edgeSegmentBa) {
        this.edgeSegmentBa = edgeSegmentBa;
    }

    protected void setEdgeSegmentAb(EdgeSegment edgeSegmentAb) {
        this.edgeSegmentAb = edgeSegmentAb;
    }

    protected DirectedEdgeImpl(IdGroupingToken groupId, DirectedVertex vertexA, DirectedVertex vertexB, double lengthKm) throws PlanItException {
        super(groupId, vertexA, vertexB, lengthKm);
    }

    protected DirectedEdgeImpl(DirectedEdgeImpl directedEdgeImpl) {
        super(directedEdgeImpl);
        this.setEdgeSegmentAb(directedEdgeImpl.getEdgeSegmentAb());
        this.setEdgeSegmentBa(directedEdgeImpl.getEdgeSegmentBa());
    }

    @Override
    public EdgeSegment registerEdgeSegment(EdgeSegment edgeSegment, boolean directionAB) throws PlanItException {
        EdgeSegment currentEdgeSegment;
        PlanItException.throwIf(edgeSegment.getParentEdge().getId() != this.getId(), "inconsistency between link segment parent link and link it is being registered on");
        EdgeSegment edgeSegment2 = currentEdgeSegment = directionAB ? this.getEdgeSegmentAb() : this.getEdgeSegmentBa();
        if (directionAB) {
            this.setEdgeSegmentAb(edgeSegment);
        } else {
            this.setEdgeSegmentBa(edgeSegment);
        }
        return currentEdgeSegment;
    }

    @Override
    public EdgeSegment getEdgeSegmentAb() {
        return this.edgeSegmentAb;
    }

    @Override
    public EdgeSegment getEdgeSegmentBa() {
        return this.edgeSegmentBa;
    }

    @Override
    public DirectedEdgeImpl clone() {
        return new DirectedEdgeImpl(this);
    }

    @Override
    public void replace(EdgeSegment edgeSegmentToReplace, EdgeSegment edgeSegmentToReplaceWith) {
        if (edgeSegmentToReplace != null) {
            if (this.hasEdgeSegmentAb() && this.getEdgeSegmentAb().getId() == edgeSegmentToReplace.getId()) {
                this.setEdgeSegmentAb(edgeSegmentToReplaceWith);
            } else if (this.hasEdgeSegmentBa() && this.getEdgeSegmentBa().getId() == edgeSegmentToReplace.getId()) {
                this.setEdgeSegmentBa(edgeSegmentToReplaceWith);
            } else {
                LOGGER.warning("provided edge segment to replace is not known on the directed edge");
            }
        }
    }
}

